// This file is generated by @lib/ui/country/codegen/generateFlags.ts
import { SvgIconProps } from '@lib/ui/icons/SvgIconProps'

const RsFlag = (props: SvgIconProps) => (
  <svg
    width="1em"
    height="0.75em"
    xmlns="http://www.w3.org/2000/svg"
    xmlnsXlink="http://www.w3.org/1999/xlink"
    id="flag-icons-rs"
    viewBox="0 0 640 480"
    {...props}
  >
    <defs>
      <clipPath id="rs-a">
        <path fillRule="evenodd" d="M60 0h1200v900H60z" />
      </clipPath>
    </defs>
    <g clipPath="url(#rs-a)" transform="translate(-32) scale(.53333)">
      <path fill="#fff" d="M0 0h1350v900H0z" />
      <path fill="#0c4076" d="M0 0h1350v600H0z" />
      <path fill="#c6363c" d="M0 0h1350v300H0z" />
      <g transform="matrix(1 0 0 1.00437 0 -.3)">
        <path
          fill="#21231e"
          d="M473.4 259.4v-.2h1v.2l-.5.5-.6-.6zm1 0v.5h-.5l.4-.6zm-93 5.2-1 .2.3-.6 4.2-.2 4-.3 4-.2 3.8-.3 4-.2 3.6-.3 3.7-.2 3.7-.2 3.5-.2h3.4l3.3-.3 3.2-.2 3.2-.2 3-.2h3l3-.2 3-.2 2.7-.2h2.8l2.7-.2 2.5-.2h2.5l2.4-.3h2.2l2.2-.2h2.2l2-.2h2l2-.2h5.3v1h-5.5l-1.8.2h-2l-2 .2h-2.2l-2.2.2-2.4.2h-2.4l-2.5.2-2.5.2H446l-2.8.3h-2.8l-3 .3-2.8.2h-3l-3 .3-3.3.2-3.3.2-3.3.2h-3.5l-3.5.3-3.6.2-3.5.3-3.8.2-3.8.2-4 .3-4 .2-4 .3-4.2.2.5-.6zm-1 .2-.3-.5h.7l-.4.5zm6.4 31-6.5-31 1-.2 6.5 31-.5.7-.5-.4zm.5.5h-.4l-.2-.4.5.3zm95-4-.2 1h.2-5.8l-3 .2h-3l-2.8.2h-3l-3 .2h-6l-3 .2h-3l-3 .2h-3l-3 .2h-3.2l-3 .2h-3l-3 .2h-3l-3 .2h-3l-3 .2h-3l-3 .2h-3l-3 .2h-3l-2.8.2h-5.8l-2.7.2h-2.7v-1h5.8l2.7-.2h5.8l3-.2h3l2.8-.2h3l3-.2h3l3-.2h3l3-.2h3l3-.2h3l3-.2h3.2l3-.2h3l3-.2h3l3-.2h3l3-.2h3l3-.2h3l2.8-.2h3l2.8-.2h.2zm-.2 0h.2zm94.5 3.4 1 .2-.5.3h-2.8l-2.8-.2h-8.8l-2.8-.2h-3l-3-.2H551l-3-.2h-3l-3-.2h-3l-3-.2h-3l-3-.2h-3l-3.2-.2h-3l-3-.2h-3l-3-.2h-3l-3-.2h-3l-3-.2h-3l-3-.2h-3l-3-.2H485l-3-.2.2-1h2.8l3 .2h3l2.8.2h3l3 .2h3l3 .2h3l3 .2h3l3 .2h3l3 .2h3l3 .2h3.2l3 .2h3l3 .2h3l3 .2h3l3 .2h3l3 .2h5.8l2.7.2h3l2.7.2h2.8l-.5.5zm1 .2v.3h-.5l.5-.4zm6.5-31.2-6.5 31h-1l6.5-31.2.6-.4.4.6zm-.4-.6h.5v.6l-.4-.6zm-93.7-4.8h1l-.6-.5h5.4l2 .2h2l2 .2h2l2.4.2h2.4l2.4.3h5l2.6.3h2.7l3 .3 2.8.2h3l3 .3 3 .3 3.3.2 3.3.2 3.4.2h3.4l3.6.3 3.6.2 3.7.2 3.6.3 4 .2 3.8.3 4 .2 4 .3 4.2.2v1l-4.3-.2-4-.3-4-.2-4-.3-3.7-.2-3.8-.2-3.6-.3-3.6-.2-3.5-.2h-3.4l-3.3-.3-3.3-.2-3.2-.2-3-.2h-3l-3-.2-3-.2h-2.7l-2.6-.3h-2.6l-2.6-.3h-2.5l-2.4-.2-2.3-.2h-2.2l-2.2-.2h-2l-2-.2h-2l-1.8-.2h-3.3l-.5-.6zm.4.5h-.5v-.6l.4.5zm.5-.8v.2h-1v-.2l.3-.5.6.5zm-1 0v-.4h.3l-.4.4zm-8 .3.2-1h8.8l.3.2v.8h-.5v.2h-.3l-.2-1h.2v.7h.2-8.2zm.2 0zm-8.3.2v-1l-.2 1h-.4l-.2-.2-.3-.3v-.5l.2-.2h9.4v1h-8.8l.2-.2v-.8h-.2.4v1zm0-1v1l-.6-.5.5-.5zm-.6.5v-.5h.5l-.6.5z"
        />
        <path
          fill="#edb92e"
          d="M583.5 264.2c3.2-6.6 6.7-13 11.2-18.7-11.7 8.8-18 7.5-18.7-4-.7-.2-1.7-.2-2.6-.2-9 14-17.7 12-26.2-5.8-11.5 18.4-21.4 18-29.2-1-13.3 16.6-24.5 16.7-33.6.2v-2c.5.2 0 .3-1 0l-.3-.3a69.3 69.3 0 0 1-1 .2c-.2 0-.5 0-.8-.2l-.2.4c-1.2.2-1.6 0-1 0v2c-9.2 16.4-20.4 16.3-33.7-.4-7.8 19-17.7 19.5-29.2 1-8.4 18-17 20-26 6-1 0-2 0-2.7.2-.8 11.4-7 12.7-18.8 4 4.6 5.5 8 12 11.3 18.6 34-1.4 67.6-3.2 101.3-5 34 1.8 67.6 3.6 101.5 5z"
        />
        <path
          fill="#21231e"
          d="m595 246-.6-1 .7 1-.3.4-.4.5-.4.4-.5.6-.4.5-.3.6-.4.6-.4.6-.5.5-.3.6-.4.6-.4.4-.3.6-.3.6-.3.6-.4.6-.3.5-.3.6-.4.5-.3.6-.3.7-.4.6-.3.6-.3.5-.3.6-.2.8-.3.6-.4.6-.2.6-.3.6-.3.6-.3.6-1-.4.3-.6.3-.7.3-.6.2-.5.4-.6.3-.7.2-.6.3-.6.3-.6.4-.6.3-.6.3-.6.3-.6.5-.6.3-.6.4-.6.3-.6.4-.5.2-.5.4-.6.4-.7.3-.6.4-.5.4-.6.5-.6.4-.5.3-.6.4-.6.4-.6.5-.5.4-.6.4-.5.7.7zm-19.2-4 .3-1 .5.5v1l.2 1v1l.3.7.2.8.3.7.3.7.2.6.4.5.3.5.4.4.5.3.4.3.4.3.5.2h.4l.5.2h1.9l.7-.2.7-.2.8-.3.8-.3.8-.3 1-.5.8-.6 1-.5 1-.7 1-.7 1-.7 1-1 .7 1-1 .7-1 .8-1 .7-1 .6-1 .5-1 .5-1 .5-.8.4-1 .3-.7.3-.8.2h-.8l-.8.2h-2l-.7-.3-.5-.2-.6-.3-.5-.5-.6-.4-.5-.4-.5-.5-.3-.5-.4-.7-.3-.7-.2-.7-.3-.8-.2-1v-.8l-.2-1v-1l.2.3zm.3-1 .4.2v.3l-.3-.4zm-2.2.6-.8-.6.4-.2h2v.2h.4l-.2 1h-1.2v-.2h-1.2l.4-.2zm-.8-.6v-.2h.4l-.4.2zm-25.3-5.2-1-.6h1l.8 1.7.8 1.4.8 1.5.8 1.2.8 1.2.8 1.2.8 1 .8 1 .8.8.8.8.8.7.7.5 1 .4.7.3.8.3.7.3h2.3l.8-.2.8-.2.8-.3.8-.4.8-.6.8-.6.8-.7.8-.6 1-1 .7-1 .8-1 .8-1 1-1.4.8.6-.8 1.3-1 1-.7 1.2-1 1-.7 1-1 .7-.8.6-.8.6-1 .6-.7.4-1 .4-.8.2-1 .2h-3l-1-.4-.7-.3-1-.5-.7-.5-1-.6-.7-.7-1-.8-.8-1-.8-1-.8-1-.8-1.2-.8-1.3-.8-1.3-.8-1.5-.8-1.6-.8-1.7h1zm-1-.6.6-.7.4.8h-1zm-28.3-.5-.8-.6 1 .2.6 1.7.7 1.5.7 1.5.8 1.4.7 1.3.8 1.2.8 1 .8 1 .8.7.8.7.8.6 1 .5.7.4.8.2 1 .2h2.5l1-.3.8-.2 1-.4.8-.6 1-.7 1-.6 1-1 1-1 1-1 1-1.2 1-1.3 1-1.6 1-1.5 1.2-1.8 1 .6-1.2 1.7-1 1.5-1.2 1.5-1 1.3-1 1.3-1 1.2-1.2 1-1 1-1 .8-1 .7-1 .6-1 .4-1 .4-1 .4h-3l-1-.2-1-.3-.8-.6-1-.5-.8-.8-1-.8-.7-.8-1-1-.8-1-.8-1.3-.8-1.4-.8-1.5-.8-1.5-.7-1.7-.8-1.7h1zm-.8-.6.5-.6.5.8h-1zm-33.8.7h1v-.2l.8 1.5 1 1.4.8 1.2 1 1.2.8 1 1 1 .8 1 1 .8.8.7 1 .6 1 .4 1 .4.8.3 1 .3 1 .2h2l1-.2 1-.3 1-.3 1.2-.4 1-.6 1.2-.6 1-.6 1.3-.8 1-1 1.3-1 1.2-1 1-1.3 1.4-1.3 1.2-1.4 1.2-1.5.8.7-1.3 1.5-1 1.5-1.3 1.3-1.2 1.3-1.2 1-1.2 1-1 1-1.3 1-1.2.7-1 .6-1.3.6-1 .5-1.3.3-1.2.3h-1l-1.2.2h-1l-1.2-.2-1-.2-1-.3-1-.4-1-.5-1-.7-1-.6-1-1-1-.8-1-1-1-1.2-.8-1.2-1-1.3-.8-1.5-1-1.5v-.3zm0 .3v-.3.3zm1-2.3v2h-1v-2l.8-.5.3.5zm-1 0v-.8l.8.2-.8.5zm-1 .3 1-.4-.4-.3h1l-.2.2v.4l.4-1h.2v.2l.2.2v.6h-1.8l-.5-.3zm.5.3h-.3v-.3l.3.3zm.3-1 .2.3-1 .4v-.4l.2-.7.6.2zm-.6-.4.4-.2.2.4-.6-.3zm-1 1 .2-1h.8l.2 1h-1zm.2 0zm-.6-.4-1-.4.7-.3h.8v1h-1l.4-.4zm-1-.4.3-.4h.3l-.6.4zm0 .4v-.4l1 .4-.2.4-.4.3-.5-.7zm.8.4v.3h-.4l.4-.3zm-1-.3h-1l.7.4v.2h.2v-.8h-.2.2l.2-.2h.4l.2 1h-1.9v-.2h-.2v-.5h.2v-.2h.2l.8.4zm-.7-.5.7-.3v.7l-.7-.5zm-.3 2.5v-2h1v2.3l-1-.3zm1 0v.2-.3zm-33.6 0-1-.5h1l1 1.4 1.3 1.4 1.3 1.3 1.2 1.2 1.2 1 1.2 1.2 1 1 1.2.7 1 .7 1.2.7 1 .6 1.2.4 1 .3 1 .3h1l1 .2h1l1-.2 1-.2 1-.2 1-.4 1-.5 1-.7.8-.7 1-.8.8-1 1-1 .8-1 1-1.2.8-1.2.8-1.4 1-1.5.8.5-1 1.5-.8 1.4-1 1.2-.8 1.2-1 1.2-1 1-.8 1-1 .8-1 .7-1 .8-1 .5-1 .4-1 .4-1 .3-1.2.2h-2.2l-1-.2-1.3-.3-1-.3-1.2-.5-1-.6-1.2-.6-1.2-.8-1.2-.8-1.2-1-1.2-1-1.2-1-1.2-1.4-1.2-1.3-1.3-1.5-1-1.5h.8zm-1-.5.3-.8.7.7-1 .2zm-28.3 1.5-1-.4h1l1 1.6 1 1.4 1.2 1.5 1 1.2 1 1.2 1 1 1 1 1 1 1 .7 1 .8 1 .6.8.4 1 .3.8.4h2.8l.8-.2.8-.3.8-.5 1-.5.7-.6 1-.7.7-.8.8-1 .8-1 .8-1.3.8-1.3.8-1.4.8-1.5.7-1.6.8-1.8 1 .4-.8 1.7-.7 1.7-.8 1.5-.8 1.4-.8 1.3-1 1.2-.7 1-1 1-.7 1-1 .7-.8.7-1 .4-.8.5-1 .2-1 .2h-3l-1-.3-1-.3-1-.4-1-.6-1-.7-1-.8-1-1-1-1-1-1-1-1.4-1-1.3-1.2-1.5-1-1.5-1.2-1.7h1zm-1-.4.5-.8.5.7h-1zm-25.6 6.5v-1l.3.2 1 1.3.7 1.2.8 1 .8 1 .8.8 1 .8.7.8 1 .6.7.5.7.3.8.3.8.2.8.2h2.3l.8-.4.8-.3.8-.4.7-.5 1-.6.7-.8.8-.8.8-.8.8-1 1-1 .7-1.2.7-1.2.8-1.3.8-1.6.8-1.5.8-1.7 1 .4-1 1.7-.7 1.5-1 1.4-.7 1.3-.8 1.3-.8 1.2-.8 1-1 1-.8 1-.8.8-.8.7-1 .6-.7.5-1 .5-1 .3-.7.3h-2.6l-1-.2-.8-.2-1-.4-.8-.4-1-.6-.8-.6-.8-.7-1-1-.7-.8-1-1-.8-1-1-1.3-.7-1.4.4.2zm0-1h.2v.2l-.3-.2zm-2.2.8h-1l.4-.5h1.2v-.2h1.5v1H389v.2h-.4l.2-.4zm-1 0v-.4h.4l-.4.3zm-18 3.6-.6.7.6-1 1 1 1.2.6 1 .7 1 .6 1 .4.8.5 1 .4.7.3.8.3.8.3.8.2h.7l.7.2h1.7l.4-.2.5-.2.4-.3.4-.3.4-.3.4-.4.3-.5.2-.5.3-.6.3-.7.3-.7.3-.8v-.8l.3-1v-.8l.2-1h1v1l-.2 1-.2 1-.2 1-.2.7-.2.8-.3.8-.4.7-.2.6-.5.6-.4.5-.6.5-.5.4-.7.2-.6.2-.6.2h-3.3l-.8-.3-.8-.3-1-.3-.8-.4-1-.5-.8-.5-1-.5-1-.6-1-.7-1-.8-1.2-.8.7-.8zm11 18.5v1l-.4-.3-.3-.6-.2-.6-.3-.6-.3-.6-.4-.6-.3-.6-.3-.7-.3-.5-.4-.6-.4-.7-.3-.6-.4-.6-.3-.5-.4-.6-.4-.7-.4-.5-.3-.6-.4-.6-.4-.6-.4-.6-.3-.5-.4-.7-.3-.6-.3-.5-.4-.6-.4-.5-.4-.5-.4-.5-.4-.6-.4-.5-.4-.6-.4-.5.7-.8.4.5.4.6.4.5.4.6.4.5.4.5.4.5.4.6.4.6.4.5.3.6.4.6.4.5.4.6.4.6.3.6.5.6.3.6.3.6.5.6.3.6.3.6.5.6.3.7.3.7.4.6.3.6.4.5.4.6.3.7.3.7.3.6-.5-.3zm0 1h-.3v-.3l.4.3zm101.4-6v1l-3.2.2h-3.2l-3 .3h-3.3l-3 .3-3.3.2H460l-3 .3-3.3.3h-3.2l-3 .3H444l-3 .3h-3.3l-3.3.2-3 .2h-3.3l-3.2.3h-3l-3.3.3-3.3.2h-3l-3.3.3h-3.2l-3 .2-3.3.2h-3.3l-3.2.2h-3l-3.3.3H384l-3 .2-.2-1h3.2l3.2-.3h3l3.3-.2 3.2-.2h3l3.3-.3h3.2l3-.3h3.3l3.2-.3h3l3.3-.2h3.2l3-.3h3.3l3.2-.3 3-.2h3.3l3.2-.3h3l3.3-.3 3.2-.2h3l3.3-.3 3-.3h3.3l3.2-.3 3-.2h3.3l3.2-.3 3-.3h.2zm0 0zm101.2 5v1h-3l-3.3-.2-3-.2h-3.3l-3-.3h-3.3l-3.2-.3h-3l-3.3-.2-3.3-.2h-3l-3.3-.3-3.2-.2h-3l-3.3-.3h-3.3l-3-.3h-3.3l-3.2-.3-3-.3h-3.3l-3.3-.3h-3l-3.3-.3h-3l-3.3-.2-3-.2-3.2-.2h-3.2l-3.2-.3h-3l-3.3-.2.2-1h3l3.3.3 3.2.2 3 .2 3.3.2h3l3.3.3h3.2l3 .2 3.3.2 3.2.2h3l3.3.3h3l3.3.2 3.2.2h3l3.3.3h3.3l3 .3h3.3l3.2.3h3l3.3.3h3.3l3 .3h3.3l3.2.2h3.2l3 .2 3.3.2h3.2zm0 1zm0 0v-1l.5.7-.6.3zm.5-.3-.2.3h-.4l.5-.3z"
        />
        <path fill="#edb92e" d="m459.4 276.2 22.7-11.5 23 11.5-23 11.4z" />
        <path
          fill="#edb92e"
          d="M474 259.2v.2c-17.6.7-48.6 2.5-93.2 5.3l6.5 31c29.6-.8 64.3-2 94.8-3 30.7 1 65.3 2.2 95 3l6.5-31c-44.6-2.8-75.6-4.6-93-5.3v-.2c1.7-.4-1-.4-8.4-.2-7-.2-10-.2-8 .2z"
        />
        <path
          fill="#edb92e"
          d="m597.3 236.7-3.7-.6c-7 17.5-13.4 18-14.6 1.4 1.6-.6 1-3.3 2.8-2.2 1 .5 2-1 1.3-2-2-1.5-3.6-1.3-5.4.4-.8-2.7-3-4-5.4-2.8-1 .5-.7 2.5.4 2.4 1.8-.2 1 1.6 1.6 3-12.5 16.4-19 14.4-17.4-7.3-3-.7-6.5-1.3-9.6-2.4-11.5 23.3-19.7 24.3-26.4 3.4 1.4-1 1-3.8 3-3 1.3.6 2.3-1.5 1.2-2.4-2.4-2-5-1.3-6.8 1.3-1.4-3-4-4-6.6-2.2-1.2.7-.5 3 .8 2.6 2.3-.7 1.3 2.4 3 3.5-5 19.6-30.8 21-26.6-8.2-2.4 0-4.5 0-6.6.2l-6.7-.2c4.2 29-21.5 27.8-26.6 8 1.6-1 .6-4 3-3.4 1.2.3 2-2 .7-2.7-2.6-1.7-5.2-.7-6.6 2.2-1.7-2.7-4.3-3.4-6.7-1.4-1 1 0 3 1 2.5 2.2-.8 1.8 2 3.2 3-6.7 21-15 20-26.4-3.4-3 1-6.5 1.7-9.5 2.3 1.6 21.6-5 23.6-17.4 7 .6-1.2 0-3 1.7-2.8 1 0 1.5-2 .4-2.4-2.4-1-4.5 0-5.3 2.8-1.7-1.7-3.5-2-5.5-.4-.8 1 .4 2.5 1.3 2 1.8-1 1.2 1.6 2.8 2.2-1.2 16.5-7.6 16-14.6-1.3l-3.7.7c0 4 1.3 8.5 3.8 11.7 10.6 13.5 18.5 10.4 18.8-4.7 14 16.4 24.4 14.3 26.2-3 11.7 21.8 30.5 11.4 31-2 5 19.4 33.5 19.2 35.4-3 1.8 22.2 30.3 22.4 35.4 3 .4 13.4 19.2 23.8 31 2 1.7 17.3 12.3 19.4 26 3 .4 15 8.3 18.2 19 4.7 2.4-3.2 3.8-7.6 3.7-11.7z"
        />
        <path
          fill="#21231e"
          d="m593.7 235.6 3.7.6-.2 1-3.6-.6-.4-.7.5-.4zm-.5.3v-.4h.5l-.5.3zm-14.3 1 .2 1 .3-.6.2 1.4v1.4l.3 1.3.2 1.2.2 1 .3 1 .3 1 .3.7.3.7.3.6.3.5.3.5.4.2.3.2h1.3l.4-.3.4-.2.5-.4.4-.3.6-.6.5-.6.6-.7.7-1 .6-.8.7-1.2.6-1.2.6-1.3.7-1.3.5-1.5.7-1.6 1 .3-.8 1.6-.6 1.4-.7 1.4-.5 1.3-.7 1.3-.6 1-.6 1-.7 1-.7.8-.6.8-.6.6-.5.5-.6.3-.7.4-.5.2h-1.2l-.6-.2-.5-.2-.5-.4-.5-.4-.4-.6-.3-.6-.3-.8-.4-.8-.3-1-.2-1-.3-1-.2-1.3-.2-1.3-.2-1.5v-1.6l.3-.5zm-.5.4v-.4h.4l-.5.4zm3.5-2.7-.5 1v-.2h-.4v.2h-.2v.2l-.2.2v.3l-.2.3-.2.3v.2h-.2v.3h-.3v.2h-.3l-.2.2-.3-1v-.2h.2v-.2h.2v-.2l.2-.2v-.5h.2v-.4l.2-.2v-.3l.2-.2.2-.2h.2l.2-.2h1l.2.2zm-.5 1zm1.3-2 .6-1v.2h.2l.2.3v1.6h-.2v.2h-.2v.2h-.2v.2h-.2v.2h-.5v.2h-.8l-.3-.2.5-1v.2h.4v-.2h.2v-.2h.2v-.8zm.6-1v.2-.2zm-6.3 1 1-.3-.8-.2h.2l.2-.3.2-.2.2-.2.3-.2h.2l.2-.2h.2v-.2h.4l.2-.2h2.3l.2.2h.2l.2.2h.2l.2.2h.2l.2.2.2.2-.6.8-.3-.2h-.2l-.2-.2-.2-.2h-.3l-.2-.2h-2.1v.2h-.3v.2h-.2l-.3.2v.2h-.3v.2l-.3.2-1-.3zm1 .3-.7.5-.2-.8 1 .3zm-5.6-2.7-.4-1h.5l.3-.2h2.1l.4.2h.4l.2.3h.2v.2l.3.2h.2l.2.2v.2l.2.2v.2l.2.2.2.2v.2l.2.3v.2l.2.2v.2l-1 .3v-.5h-.2v-.3l-.2-.2v-.2h-.3v-.3h-.2v-.4h-.3v-.2h-.3v-.2h-.6v-.2h-2l-.2.2h-.2zm0 1.4.2 1h-.6v-.2h-.2l-.2-.2-.2-.2-.2-.2V231l.2-.2.2-.2.3-.2.4 1h-.2v1.2h.2zm2.2 3.7-.8-.6v.5-.2h-.2v-1h-.2v-1l-.2-.2h-.7v-1.2h.6l.3.2.2.2h.2v.2l.2.3v.4h.2v1.5h.2v.8zm0-.5h.2l-.2.4v-.5zm-18-6.6.3-1 .3.6v2l-.2 1.8v4.9l.3 1.4v1.3l.3 1 .2 1 .3 1 .4.8.3.8.4.5.5.5.4.3.4.3.5.2h1l.6-.2.7-.3.7-.4.8-.5 1-.4.7-.8 1-.8 1-1 1-1 1-1 1-1.4 1-1.4 1.3-1.4.8.6-1.2 1.5-1 1.3-1.2 1.3-1 1-1 1.2-1 1-1 .8-1 .8-.8.6-1 .5-.7.4-.8.3h-.8l-.8.2h-.7l-.7-.2-.6-.3-.6-.5-.5-.5-.4-.7-.5-.7-.4-1-.2-1-.2-1-.2-1.2-.2-1.3V229l.5.6zm.3-1h.3v.6l-.4-.6zm-9.3-1.6-1-.4.7-.3.3.2h.3l.3.2h.3l.2.2h.3l.4.2h.6l.3.2h.3l.4.2h.6l.3.2h.5l.3.2h.7l.3.2h.6l.3.2h.5l.3.2h.8l.3.2h.3l-.3 1h-.8l-.2-.2h-.6l-.3-.2h-.8l-.3-.2h-.6l-.4-.2h-.7l-.4-.2h-.3l-.3-.2h-.6l-.3-.2h-.2l-.3-.2h-.6l-.4-.2h-.3l-.4-.2h-.4l-.3-.2h-.2l.7-.4zm-1-.4.3-.4h.4l-.6.4zm-26.2 3.2.6.8.3-.6.6 2 .5 1.7.7 1.6.6 1.6.7 1.4.7 1.2.6 1 .7 1 .7 1 .7.6.6.6.7.4.7.4.7.2h1.4l1-.2.6-.2.8-.4 1-.6.7-.6 1-.8 1-1 .8-1 1-1.2 1-1.3.8-1.4 1-1.6 1-1.7 1-1.8 1-2 1.2-2 1 .3-1.2 2.2-1 2-1 1.8-1 1.8-1 1.6-1 1.5-1 1.3-1 1.2-1 1-1 1-1 1-.8.7-1 .5-.8.4-1 .2-.8.2h-1.8l-.8-.3-.8-.3-.8-.5-.8-.6-.7-.8-.8-1-.7-1-.7-1-.7-1.4-.7-1.4-.7-1.5-.7-1.7-.6-1.7-.7-1.8.2-.6zm-.2.6v-.4l.2-.2-.2.5zm3.8-3.6-.3 1h-.3l-.2-.2h-.2v.2h-.2v.2h-.2v.5h-.2v.4l-.2.3-.2.2v.2l-.2.3-.3.3-.2.3h-.2l-.5-.7.2-.2.2-.2v-.5h.2v-.4h.2v-.3l.2-.3v-.2l.2-.2.2-.3.2-.2h.2v-.2h.5v-.2h.7l.2.2zm.7-1.6.6-.8.2.2.2.2v.2l.2.3v1.3l-.2.3v.2l-.2.2h-.2v.2h-.2v.2h-.2l-.2.2h-1.1l.4-1h.7v-.2h.2v-.6h.2v-.7h-.2v-.2zm-7 1 1-.3h-1l.2-.3v-.3h.3l.2-.3.2-.3.2-.2.3-.3.3-.3h.2l.2-.3h.3l.2-.2h.5l.2-.2h2.2l.3.2h.2l.3.2h.3l.3.3h.2l.3.3.3.2-.6.8-.2-.2h-.2l-.2-.3-.4-.2h-.2l-.2-.2H521v.2h-.5l-.2.3h-.2v.2h-.2l-.2.3-.2.2-.3.3v.2l-.2.3-.2.2h-1zm1 .2-.6.7-.3-1 1 .2zm-7-2-.4-1h.3l.2-.2h.3l.4-.2h.2l.3-.2h.4l.3-.2h1.6l.2.2h.2l.3.2h.2l.2.3.3.2.2.2v.2l.3.2.2.2.2.2v.2l.3.2.2.3.3.4v.3l-.8.4-.2-.4-.2-.2v-.2l-.3-.2v-.2l-.3-.2-.3-.3h-.2v-.2h-.3l-.3-.2h-.2l-.3-.2h-.4l-.2-.2h-1.2l-.2.2h-.5l-.2.2h-.2l-.2.2-.2.2zm.5 1.7.3 1h-.5l-.2-.2h-.2l-.2-.2-.2-.2-.2-.2v-.2l-.2-.2V224l.2-.2.2-.3.3-.2.5 1h-.2v1.2h.2v.2h.4zm3.7 4-1-.2.2.5h-.2l-.2-.2h-.2v-.3h-.2l-.2-.3v-.4l-.2-.2v-.3l-.2-.2v-.4l-.2-.2v-.2l-.2-.2v-.2h-.2v-.2h-.6l-.4-1h1.1l.3.2h.2v.4h.2v.3l.2.2v.2h.2v.5l.2.3v.5h.2v.4h.2l.2.2.2.2.3.6zm-.3-.5.3.2v.3l-.3-.5zm-27-7.2v-1l.6.5-.3 2.7-.2 2.4v2.2l.2 2 .3 2 .4 1.7.5 1.5.7 1.4.6 1 .8 1.2 1 1 1 .7 1 .6 1 .5 1 .4 1.3.3h2.4l1.3-.2 1.2-.3 1.2-.5 1.2-.5 1-.7 1.2-1 1-.8 1-1 1-1.3 1-1.3.8-1.3.8-1.5.6-1.7.5-1.7 1 .2-.6 2-.7 1.6-.8 1.6-1 1.5-1 1.4-1 1.3-1 1-1.2 1-1.2 1-1.2.8-1.3.7-1.2.5-1.3.3-1.4.2h-2.5l-1.2-.3-1.3-.4-1.2-.5-1-.7-1-1-1-1-1-1-.8-1.5-.7-1.5-.6-1.6-.4-1.8-.3-2-.2-2.2V227l.2-2.6.3-2.7.5.6zm0-1h.7v.5l-.6-.5zm-6.6 1.2.2-1h4l.2-.2h2.1v1h-4.1l-.2.2h-2zm.2 0zm-6.2-.8h-1l.5-.4h5.1l.2.2h1.2v1h-4l-.3-.2h-2l.5-.6zm-1 0v-.5h.5l-.5.6zm-26.4 7.8.5.8.3-.5.6 1.7.5 1.7.7 1.5 1 1.4.8 1.4 1 1.2 1 1 1 1 1.2 1 1.2.6 1.2.5 1.2.5 1.2.3 1.2.2h2.4l1.2-.3 1-.3 1.2-.4 1-.7 1-1 .8-.8 1-1 .6-1.3.6-1.5.6-1.6.4-1.8.3-2v-2l.2-2.3-.2-2.5-.3-2.7h1l.3 2.6.2 2.5v2.2l-.2 2.2-.3 2-.5 1.8-.5 1.6-.7 1.5-.8 1.4-1 1.2-1 1-1 .8-1 .7-1.2.5-1.3.4-1.3.3H463l-1.2-.2-1.3-.3-1.3-.5-1.3-.6-1.3-.7-1.2-1-1.2-1-1-1-1-1.2-1-1.3-1-1.5-.7-1.6-.7-1.7-.6-2 .2-.5zm-.2.5v-.3l.2-.2-.2.5zm3.7-4-.2 1-.2-.2h-.7v.2l-.2.2v.4l-.2.2v.5l-.2.2v.2l-.2.3v.2l-.2.2v.2h-.2v.3h-.3l-.2.2h-.2l-.4-.7.2-.2.2-.2h.2v-.3l.2-.2v-.5l.2-.2v-.5l.2-.3v-.3l.2-.2.3-.3.2-.2h.2l.2-.2h1.1zm.4-1.8.6-1v.2h.3v.3h.2v.2l.2.2v1.5l-.2.2v.2l-.2.2-.3.2-.2.2h-.9l.3-1h.4v-.4l.2-.2v-.8h-.2v-.2h-.2zm-6.7 2 .8-.6h-.8v-.2l.2-.3.3-.4v-.2l.3-.2.2-.2.2-.2.2-.2.2-.2.2-.2h.2l.3-.3.3-.2h.2l.3-.2h.5l.2-.2h1.6l.4.2h.2l.3.2h.2l.3.2.2.2h.3l-.6 1-.2-.2h-.2l-.2-.2h-.3l-.2-.2h-.5l-.2-.2h-1.3l-.2.2h-.3v.2h-.3l-.2.3-.2.2-.3.3-.3.3-.2.2v.2l-.2.2-.2.2v.3h-.2l-1 .2zm1 0-.5.7-.5-.8h1zm-7-1.2-.8-.8.2-.2.2-.2h.3l.2-.3h.2l.2-.2h.3l.3-.2h2.5l.3.2h.2l.3.2.2.2h.2l.2.3h.2l.2.2.2.2.2.3.2.2h.2v.4l.3.2-.8.6-.2-.2v-.3l-.3-.2-.2-.2-.3-.3-.2-.2h-.2l-.2-.2v-.2h-.2l-.2-.2h-.4l-.2-.2H441l-.2.2h-.2l-.2.2h-.2l-.2.3h-.2l-.2.3zm.5 1.6.4 1h-1.3l-.2-.2-.3-.2h-.2v-.2l-.2-.3v-.2l-.2-.2v-1.6l.2-.2.2-.2v-.2l.8.8-.2.2v1l.2.2.2.2h.4zm3.8 3.6-1-.4.2.6h-.2v-.3h-.3v-.2h-.2v-.3h-.2v-.5h-.2v-.6h-.2v-.5l-.2-.2-.2-.2h-.2v-.2h-.5v.2l-.5-1h.4l.2-.2h.6l.2.2.3.2h.2v.2l.2.2.2.3v.2l.2.2v.2l.2.3v.2l.2.2.2.2.2.2.2.2.2.6zm-.2-.6.3.2v.4l-.2-.6zm-26.6-2.5-.3-1 .5.4 1 2 1 2 1.2 2 1 1.6 1 1.6 1 1.5 1 1.4.8 1.2 1 1 .8 1 1 .8.7.6 1 .6.6.4.8.2.8.2h1.3l.7-.2.7-.4.7-.4.7-.6.7-.7.8-.7.6-1 .7-1 .8-1.3.6-1.4.7-1.5.7-1.5.7-1.8.6-2 1 .5-.7 2-.6 1.6-.7 1.7-.6 1.5-.7 1.4-.7 1.3-.7 1.2-.7 1-.8.8-.7.8-.7.6-.8.5-1 .4-.7.4H432l-1-.2-.7-.3-1-.5-1-.6-.8-.8-1-1-.8-1-1-1-1-1.2-1-1.3-1-1.5-1-1.6-1-1.8-1-1.8-1-2-1-2.2.5.3zm-.3-1h.3l.2.4-.6-.3zm-9 3h-1l.4-.6h.7l.3-.2h.6l.4-.2h.9l.3-.2h.5l.3-.2h.6l.4-.2h.3l.3-.2h.6l.3-.2h.5l.3-.2h.3l.4-.2h.3l.3-.2h.3l.3-.2h.3l.2 1h-.7l-.3.2h-.3l-.3.2h-.3l-.3.2h-.5l-.3.2h-.3l-.4.2h-.6l-.4.2h-.6l-.3.2h-.6l-.2.2h-.6l-.3.2h-.7l-.3.2h-.8v.2h-.4l.4-.5zm-1 0v-.5h.4l-.4.5zm-17.4 7 1 .3v-.5l1 1.4 1 1.4 1.2 1.3 1 1 1 1 1 1 1 .8.8.8 1 .6.6.4.8.4.7.3h.6l.6.2h.4l.5-.2.3-.2.5-.2.4-.5.3-.5.4-.7.2-.7.3-1 .2-1 .2-1v-2.7l.2-1.5v-5l-.2-1.8h1v2l.2 1.8v4.9l-.2 1.4v1.4l-.3 1.2-.3 1-.3 1-.2 1-.4.7-.4.7-.6.5-.5.5-.7.3-.7.2H402l-.6-.2-.8-.4-1-.5-.7-.5-1-.6-1-.8-1-.8-1-1-1-1-1-1.2-1-1.3-1.2-1.4-1-1.6-.2-.5zm0 .4v-.3.4zm2-3.7v1h-.6v.8l-.2.3v1h-.2v.3l-1-.4v-.4l.2-.2v-.9h.2v-.5l.2-.2v-.2h.4v-.2h1zm.3-1.4.3-1 .2.2h.2v.2h.2v.7h.2v1.2l-.2.2v.3l-.2.2-.2.2h-.2l-.2.2h-.5v-1h.4v-.2h.2v-.8l-.2-.2zm-5.7 2.7.7-.8-.8.2v-.2l.2-.3v-.3l.2-.3v-.2l.2-.2.2-.2v-.2l.3-.2v-.2l.3-.2h.2v-.3h.3l.3-.2.2-.2h.4v-.2h2.5l.3.2h.2l.3.2-.4 1-.3-.2h-.5l-.2-.2h-1.3l-.3.2h-.2v.2h-.2l-.2.2v.2h-.2l-.2.2v.2h-.2v.3l-.2.2v.2h-.2v.5l-.2.2-1 .3zm1-.3-.4.8-.7-.5 1-.3zm-5.8-.2-.7-.6v-.2l.3-.2h.3l.2-.2h.2l.2-.2.3-.2h.2l.2-.2h2.1l.2.2h.2l.2.2h.2l.2.2.3.2.2.2h.2l.2.3v.2l-.7.8v-.2h-.3v-.2l-.3-.2-.3-.2h-.3v-.2h-.2l-.2-.2h-2v.2h-.3l-.2.2-.2.2h-.2l-.2.2zm-.7-.6v-.2zm1.4 1.7.6 1h-1.3l-.3-.2-.2-.2v-.2h-.2l-.2-.2v-.3l-.2-.2v-.8l.2-.3h.2l.7.5v.8h.2v.2h.2v.2h.2zm3.6 2.7h-1l.3.5v-.2h-.3v-.2h-.3v-.3h-.2v-.2h-.2v-.2l-.2-.2v-.3h-.2v-.2l-.2-.3v-.2h-.7l-.6-.8h.2l.2-.2h1.1l.3.2.2.2v.2h.2v.4l.2.2v.5h.2v.2l.2.2.2.2h.2l.4.6zm-.4-.5h.4v.4l-.4-.5zm-14.7-.4v-1l.4.3.8 1.5.6 1.5.7 1.3.7 1.3.6 1.2.6 1 .6 1 .6 1 .5.6.6.7.5.7.6.4.5.5.3.2.5.2h1.1l.3-.3.3-.2.4-.4.3-.4.4-.5.3-.6.3-.8.3-.8.2-1 .3-1 .3-1.3.2-1.3v-1.4l.2-1.4h1v1.5l-.2 1.4-.2 1.3-.2 1.2-.2 1-.2 1-.3 1-.4.8-.4.8-.4.6-.4.6-.5.4-.5.4-.5.2-.6.2h-1.1l-.6-.3-.7-.4-.6-.4-.5-.6-.6-.6-.7-.7-.7-.7-.6-1-.6-1-.6-1-.6-1.2-.6-1.2-.7-1.4-.7-1.5-.6-1.7.5.3zm0-1h.3v.3l-.4-.4zm-3.8.6 3.6-.6v1l-3.6.6-.5-.5.4-.5zm-.5.5v-.4h.4l-.5.4zm4.7 11.4-.8.7-.3-.3v-.3l-.3-.3-.2-.3-.3-.3-.2-.3-.2-.3v-.4l-.3-.3-.2-.4-.2-.4v-.4l-.2-.4v-.4l-.3-.4v-.4l-.2-.3v-.4l-.2-.4v-.9l-.2-.3v-.8l-.2-.5V238l-.2-.5v-.7h1v1.9l.2.4v1.1l.2.5v.7l.2.3v.4l.2.4.2.3v.4l.2.5.2.3v.4l.2.3.2.4.2.2v.3l.3.4.2.2v.3l.3.3.2.4.2.3.2.3.2.3zm18.7-4.7-.8.7 1-.3-.2 1.4v1.4l-.2 1.3-.2 1.2-.2 1-.3 1-.2 1-.3 1-.4.7-.4.8-.4.7-.6.6-.5.5-.5.4-.7.3-.6.3h-.7l-.8.2h-.7l-.8-.2-.8-.2-.8-.2-1-.4-.7-.5-1-.7-1-.6-.8-.8-1-1-1-1-1-1-.8-1-1-1.3.8-.6 1 1.3 1 1 .8 1 1 1 1 .8.7 1 1 .5.7.6.8.5.8.4.7.2h.7l.7.3h1.4l.6-.2.4-.2.6-.2.4-.3.5-.5.4-.5.4-.6.4-.7.3-.8.3-.8.3-1 .4-1 .2-1 .2-1.2v-1.2l.2-1.3v-1.3l1-.4zm-1 .4V242l1 1-1 .4zm27.3-3.2-1 .4 1-.2-.2 1.6v1.5l-.4 1.3-.4 1.3-.4 1.2-.4 1.2-.5 1-.7 1-.6 1-.6.7-.6.7-.8.6-.7.5-1 .4h-.8l-1 .3h-2.8l-1-.3-1-.4-1.2-.4-1-.6-1.2-.6-1.2-.8-1-.8-1.3-1-1.2-1-1.3-1.2-1.2-1.3-1.3-1.5-1.3-1.5.7-.7 1.2 1.5 1.3 1.4 1.2 1.2 1.2 1.2 1 1 1.3 1 1 .8 1.2.7 1 .7 1 .6 1 .4 1 .3 1 .2h1l.8.2h.8l1-.2.7-.3.7-.4.7-.5.7-.4.6-.6.6-.7.5-.8.5-1 .4-1 .5-1 .2-1.2.4-1.3.3-1.3v-1.5l.3-1.6h1zm-1 0 .2-1.5.8 1.5h-1zm31.8-1.8-.8.3h1v1l-.3 1.4-.4 1.2-.4 1.2-.5 1-.6 1.3-.6 1-.7 1-.8 1-1 1-1 .7-1 .7-1 .7-1 .6-1.2.5-1.2.4-1.2.3h-3.8l-1.3-.2-1.3-.4-1.4-.4-1.3-.7-1.3-1-1.3-.8-1.3-1.2-1.3-1.2-1-1.5-1.3-1.6-1.2-1.8-1-2 .8-.5 1 2 1.2 1.6 1.2 1.7 1.2 1.4 1 1.3 1.3 1 1.2 1 1.3.7 1.2.6 1.2.5 1.3.5 1.2.2h3.6l1.2-.3 1-.3 1-.3 1.2-.5 1-.6 1-.7.7-.8 1-1 .6-.7.6-1 .6-1 .6-1 .4-1 .4-1.2.3-1V239h1zm35.6-3-1 .2h1l-.2 2-.4 2-.6 1.6-.6 1.7-.8 1.6-1 1.3-1 1.3-1 1-1.3 1-1.3 1-1.3.8-1.3.6-1.5.6-1.5.3-1.5.2h-1.5l-1.6.2-1.4-.2-1.6-.2-1.5-.3-1.5-.5-1.4-.6-1.4-.7-1.4-1-1.3-1-1.2-1-1-1.2-1-1.4-1-1.4-1-1.6-.6-1.6-.5-1.8 1-.3.5 1.7.6 1.6.8 1.5 1 1.3 1 1.3 1 1.2 1.2 1 1.2 1 1.3.8 1.3.7 1.4.5 1.4.5 1.4.3 1.5.2h4.4l1.5-.3 1.4-.4 1.3-.5 1.3-.5 1.3-.7 1-1 1.2-.8 1-1 1-1.3 1-1.4.6-1.4.7-1.7.5-1.7.4-1.8.2-2h1zm35.5 3-1 .2h1l-.4 1.8-.7 1.6-1 1.6-1 1.4-1 1.4-1 1.2-1.3 1-1.2 1-1.4 1-1.3.6-1.5.6-1.4.5-1.6.3-1.5.2-1.5.2h-1.6l-1.5-.2-1.4-.3-1.5-.4-1.4-.6-1.4-.6-1.3-.8-1.4-1-1.2-1-1-1-1.2-1.3-1-1.4-.7-1.7-.7-1.7-.5-1.7-.4-2-.4-2 1-.2.3 2 .3 1.8.5 1.7.6 1.6.8 1.3 1 1.4.8 1.2 1 1 1.2 1 1.2.8 1.3.7 1.3.6 1.4.6 1.4.3 1.4.2h4.5l1.4-.2 1.5-.3 1.4-.5 1.3-.5 1.3-.7 1.3-.8 1-1 1.2-1 1-1 1-1.4 1-1.3.7-1.5.6-1.6.5-1.7h1zm31 2h-1l1 .2-1.2 2-1.2 1.7-1.2 1.6-1.2 1.5-1.3 1.2-1.4 1.2-1.3 1-1.3.7-1.3.6-1.3.5-1.4.5-1.3.2H530l-1.3-.3-1.2-.3-1.2-.4-1-.5-1-.6-1-.7-1-.8-1-1-.7-1-.8-1-.6-1-.6-1-.5-1.2-.3-1.2-.3-1.2-.2-1.3v-1l1-.2v1.2l.2 1.2.3 1 .4 1.2.5 1 .6 1 .7 1 .7 1 .7 1 1 .8.8.7 1 .6 1 .6 1 .5 1 .4 1 .4 1.3.2 1.2.2h2.4l1.2-.3 1.2-.4 1.3-.4 1.2-.6 1.3-.7 1.2-1 1.2-1 1.2-1.2 1.2-1.3 1.2-1.6 1-1.6 1.2-2 1 .2zm-1-.2.8-1.5.2 1.6h-1zm27.2 3.2h-1l1 .3-1.4 1.5-1.3 1.4-1.2 1.2-1.3 1-1.2 1.2-1.2 1-1.2.8-1 .8-1.2.6-1 .6-1.2.4-1 .4-1 .2-1 .2h-2l-1-.3h-.8l-.8-.5-.8-.5-.7-.6-.8-.7-.6-.8-.6-1-.6-1-.5-1-.5-1-.4-1.4-.3-1.3-.3-1.4-.2-1.6-.3-1.6 1-.2.2 1.6.2 1.5.3 1.3.3 1.3.4 1.2.4 1 .5 1 .5 1 .6.8.6.7.6.6.6.5.7.6.6.3.8.2h.8l.8.2h.8l1-.2 1-.2.8-.3 1-.4 1-.6 1.2-.6 1-.6 1.2-.8 1.2-1 1-1 1.4-1.2 1.2-1.2 1.3-1.4 1.3-1.5 1 .4zm-1-.4 1-1v1.4l-1-.4zm19 4.8.7.7-1 1.2-1 1-1 1-1 1-1 1-.8.7-1 .6-.8.6-.8.4-1 .4-.7.3-1 .3-.7.2h-1.5l-.7-.2-.6-.3-.6-.3-.6-.4-.6-.5-.5-.6-.4-.7-.4-.8-.4-.8-.3-1-.3-1-.3-1-.3-1-.2-1.3V246l-.2-1.3v-1.3h1v2.6l.2 1.3.2 1 .2 1.2v1l.4 1 .4.7.3.8.5.6.4.5.4.5.4.5.5.3.5.3.6.3h.6l.6.2h.6l.7-.2h.6l.7-.4.8-.5 1-.4.7-.5 1-.6.7-1 1-.7.8-1 1-1 1-1 1-1.2zm4-10.7v-1l.6.4v2.9l-.2.4v.7l-.2.4v.5l-.2.4v.3l-.2.4v.3l-.3.4v.4l-.2.4-.2.4v.3l-.3.3-.2.4-.2.3-.2.4-.2.3-.2.4-.2.4-.2.3-.2.4-.2.4-.3.3-1-.6.3-.2.3-.3.2-.3.2-.4.2-.3.2-.3.2-.3v-.5l.3-.3v-.3l.2-.5.2-.3v-.4l.3-.3v-.4l.2-.3v-.7l.2-.4v-.3l.2-.4v-.5l.2-.4v-1l.2-.4v-1.8l.5.5zm0-1h.6v.4l-.5-.5zm0 0v1-1zm0 1z"
        />
        <path
          fill="#edb92e"
          d="M482 263h-22.5l-1.3.2H451l-1.3.2h-4.4l-1.2.2h-2.3l-6.3.4h-.3c-3 0-6 .3-9 .4h-.8l-18.2 1.3h-.2a965 965 0 0 0-26.4 2.4c-5 .6-6-5.3 0-6a960.5 960.5 0 0 1 26.3-2.2 983.7 983.7 0 0 1 37-2.2h2.4l15.4-.5h16.8a1082.3 1082.3 0 0 1 7.2 0h16.6l15.2.5h3.3a984 984 0 0 1 37 2.3 960.5 960.5 0 0 1 26.2 2c5.8.7 5 6.6 0 6a965.6 965.6 0 0 0-26.4-2.3h-.3a978.4 978.4 0 0 0-18.3-1.2h-.6l-9.2-.5h-.3c-2.2 0-4.3-.2-6.4-.3h-2.3l-1.2-.2h-4.5l-1.3-.2H506l-1-.2h-23z"
        />
        <path
          fill="#0c4076"
          d="M482 105a17.3 17.3 0 0 1 .1 34.7c-9.3 0-17-7.8-17-17.3 0-9.6 7.7-17.3 17-17.3z"
        />
        <path
          fill="#edb92e"
          d="M485.3 85c1.6-.2 3-1.5 3-3.2 0-1.7-1.4-3-3-3.2 0-1.7-1.4-3-3.2-3a3 3 0 0 0-3 3c-1.6 0-3 1.5-3 3.2a3 3 0 0 0 3 3v6.5h-5.5a3 3 0 0 0-3-3c-1.8 0-3 1.3-3.2 3a3 3 0 0 0-3 3c0 1.8 1.3 3.2 3 3.2a3 3 0 0 0 3 3c1.8 0 3.2-1.2 3.2-3h5.5V119h6.3V97.6h5.5a3 3 0 0 0 3 3c1.8 0 3-1.4 3.2-3 1.7 0 3-1.5 3-3.2a3 3 0 0 0-3-3c0-1.8-1.4-3.2-3-3.2-2 0-3.2 1.4-3.2 3h-5.5V85z"
        />
        <path
          fill="#21231e"
          d="M487.8 81.8h1v1h-.2v.5h-.2v.3l-.2.3-.2.2v.2h-.2l-.2.2-.2.2h-.2v.2h-.2l-.2.2h-.2v.2h-.8l-.2.2h-.3v-1h.7V84h.2l.3-.2h.2v-.2h.2v-.2l.2-.2V83h.2l.2-.2v-.4l.2-.2v-.4zm-3-3.2h1l-.5-.5h.2l.3.2h.4l.3.2h.3l.2.2.2.2h.2v.2h.2l.2.2.2.3.2.2v.2h.2v.4h.2v.5l.2.2v.7h-1V81h-.2v-.4l-.2-.2V80h-.4v-.2h-.2v-.2h-.2l-.3-.2h-.2V79h-.8l-.4-.6zm.4.5h-.4v-.4l.4.5zm-3-3v-1h.7l.2.2h.2l.3.2h.2l.2.2.2.2h.2v.3l.2.2.2.3.2.2v.2h.2v.4h.2v.8h.2v.3h-1V78h-.2v-.5h-.2v-.2l-.2-.2-.2-.2-.2-.2h-.2v-.2h-.2l-.2-.2h-.4l-.3-.2h-.4zm-3.2 3v-1l-.5.6v-.8l.2-.2V77h.2v-.6h.2v-.2l.2-.2.2-.2.2-.2h.2v-.2h.3v-.2h.3l.3-.2h.4l.2-.2h.4v1h-.5v.2h-.3l-.2.2h-.2v.2h-.2v.2h-.2v.2l-.2.2v.2h-.2v.5h-.2v1l-.6.5zm.5-.4v.5h-.5l.5-.4zm-3 3.2h-1V81l.2-.3v-.5l.2-.2v-.2l.2-.2.2-.3.2-.2h.2l.2-.2h.2v-.2h.3v-.2h.5l.3-.2h.7v1h-.7l-.2.2h-.2l-.2.2-.2.2-.2.2-.2.2v.2h-.2v.4l-.2.2v.8zm3 3h-1l.5.6h-1V85h-.7v-.2h-.3v-.2h-.2l-.2-.2-.2-.2V84h-.2v-.2l-.2-.2-.2-.3v-.5h-.2v-1h1v1h.2v.4h.2v.2h.2v.2l.2.2h.2v.2h.2l.3.2h.7v.2h.2l.5.5zm-.5-.4h.5v.5l-.5-.6zm-.5 7V85h1v6.3l-.5.5-.5-.5zm1 0v.4h-.5l.5-.5zm-6-.6h5.5v1h-5.5l-.5-.5.5-.5zm0 1h-.5v-.5l.5.5zm-3-3v-1h1.2v.2h.3l.3.2.3.2.3.2v.2l.2.2.2.3.2.3.2.3v.4l.2.2v.8h-1v-.7l-.2-.2V90h-.2v-.2h-.2v-.2l-.2-.2-.2-.2h-.2V89h-.4l-.2-.2h-.8zm-3.2 3v-1l-.5.4v-.8l.2-.3V90l.2-.3v-.2h.2v-.2l.2-.2h.2v-.3h.2l.2-.2.2-.2h.2V88h.7v-.2h1.1v1h-1l-.2.2h-.2v.2h-.2v.2h-.2l-.2.2v.2h-.2v.4h-.2v.8l-.2.2v.3l-.5.5zm.5-.5v.5h-.5l.5-.5zm-3 3h-1V93h.2v-.2h.2v-.3l.2-.3.3-.3v-.2h.2v-.2h.2v-.2h.2l.2-.2h.2V91h.7l.2-.2h.8v1h-.7l-.2.2h-.2v.2h-.2v.2h-.2l-.2.2-.2.2v.2h-.2v.5h-.2v.7zm3 3.2h-1l.5.5h-1v-.2h-.5l-.2-.2h-.2v-.2h-.2l-.2-.2-.2-.2v-.2h-.3v-.2l-.2-.2V96h-.2v-.4l-.2-.3v-.8h1v.9h.2v.2l.2.3h.2v.2h.2v.2h.2v.2h.2l.2.2h.5v.2h.4l.6.5zm-.5-.5h.5v.5l-.5-.5zm3 3v1h-1l-.2-.2h-.3v-.2h-.3v-.2h-.2l-.2-.2-.2-.3v-.2h-.2v-.3h-.2V99h-.2v-.5l-.2-.2V98h-.2v-.5h1v.7h.2v.4h.2v.2l.2.2v.2h.2v.2h.2v.2h.2l.2.2h.2l.3.2h.6zm3.2-3v1l.5-.4v.8l-.2.2v.3h-.2v.3l-.2.3-.2.2-.2.2-.2.2-.3.2-.2.2h-.2l-.2.2h-.2l-.3.2h-.8v-1h.9v-.2h.2l.2-.2h.2v-.2h.2l.2-.2V99h.2v-.2l.2-.3v-.2l.2-.2v-.4l.5-.5zm-.5.6V97h.5l-.5.6zm6 .5h-5.5v-1h5.5l.5.6-.5.5zm0-1h.5v.6l-.5-.5zm-.5 22V97.6h1V119l-.5.5-.5-.5zm.5.5h-.5v-.5l.5.5zm6.3 0H479v-1h6.3l.5.5-.5.5zm.5-.5v.5h-.5l.5-.5zm0-21.4V119h-1V97.6l.5-.5.5.6zm-1 0V97h.5l-.5.6zm6 .5h-5.5v-1h5.5l.5.6-.5.5zm0-1h.4v.6l-.4-.5zm3 3v1h-1l-.3-.2h-.2l-.3-.2-.2-.2h-.2v-.2h-.2l-.2-.2v-.2h-.2v-.2l-.2-.2V99h-.2v-.2h-.2v-1l-.2-.2h1v.4l.2.2v.2l.2.3v.2h.2v.2h.2l.2.2v.2h.2l.3.2h.2v.2h1.1zm3.2-3v1l.5-.5v.7h-.2v.5l-.2.3v.4h-.2v.3h-.2v.2h-.2v.2h-.3v.2l-.3.2h-.3l-.2.2h-.3l-.2.2h-.8v-1h.9v-.2h.2v-.2h.2l.2-.2.2-.2V99h.2v-.2l.2-.2v-.2l.2-.2v-.6l.6-.6zm-.5.5V97h.5l-.5.5zm3-3h1v.9l-.2.3v.2h-.2v.6h-.2l-.2.2v.2h-.2v.2h-.3v.2h-.2v.2h-.3l-.3.2h-.2l-.3.2h-.7v-1h.8V97h.2v-.2h.2l.2-.2.2-.2h.2V96l.2-.3v-.2h.2v-.7l.2-.3zm-3-3.2h1l-.5-.6h.7l.2.2h.4l.3.2.3.2.3.2.2.2.2.3.2.2v.5h.2v.3h.2v.7l.2.3v.4h-1v-.6h-.2v-.4l-.2-.2-.2-.2v-.2h-.2l-.2-.2-.2-.2h-.2V92h-.5l-.2-.2h-.5l-.5-.5zm.5.5h-.5v-.5l.5.5zm-3-3v-1h1.1l.2.2h.4v.2h.3v.2l.3.2.2.3h.2v.3h.2v.4l.2.2v.4h.2v.7h-1v-.8h-.2V90l-.2-.2-.2-.2-.2-.2-.2-.2h-.2V89h-.5v-.2h-.6zm-3.2 3v-1l-.6.5v-.9l.2-.2V90l.2-.3.2-.3.2-.3h.2v-.2l.2-.2h.2v-.2h.2l.2-.2h.3l.2-.2h.3l.2-.2h1v1h-1l-.3.2h-.2v.2h-.2l-.2.2v.2l-.2.2-.2.2v.2l-.2.2v.7l-.7.6zm.5-.5v.5h-.6l.6-.5zm-6-.5h5.5v1h-5.5l-.5-.5.5-.5zm0 1h-.5v-.5l.5.5zm.5-7v6.5h-1V85l.4-.6.6.5zm-1 0v-.4h.4l-.4.5zm.5 0v-.4.5zm-.5 0v-.4h.4l-.4.5z"
        />
        <path
          fill="#21231e"
          d="M499.8 122.4h-1v-1.7l-.2-1v-.7l-.3-.8-.2-.8-.2-.8-.3-.8-.3-.7-.4-.6-.4-.7-.4-.7-.5-.7-.5-.6-.5-.6-.6-.5-.7-.6-.6-.6-.6-.5-.5-.6-.7-.4-.7-.4-.6-.4-.8-.3-.7-.4-1-.3-.7-.2h-.8l-.8-.2h-.8l-1-.2h-1v-1h2l.8.2h1l.8.3.8.4.8.2.8.4.8.3.8.4.7.4.7.6.7.5.7.6.6.6.6.6.6.6.6.6.5.7.5.7.5.7.4 1 .4.6.4.8.3.8.3 1 .3.7.2.8v1l.2.7v2zM482 140.2v-1h1.8l1-.2.7-.2.8-.2.8-.2 1-.3.6-.2.8-.3.7-.4.8-.3.7-.4.6-.5.7-.5.6-.5.6-.6.5-.5.5-.6.5-.6.5-.6.4-.7.4-.6.4-.8.3-.7.3-1 .3-.6.3-.8.2-.8v-1l.2-.7v-1.6h1v2.8l-.2.8-.2.8-.3 1-.3.7-.3.8-.3.8-.3 1-.4.6-.5.7-.5.7-.5.7-.6.6-.6.7-.6.6-.6.5-.7.6-.7.5-.7.6-.7.4-.8.4-.8.4-.8.3-.8.4-.8.2-1 .2-.8.2h-.8l-1 .2h-1zm-17.5-17.8h1v1.8l.2.7v.8l.3.8.2.8.3.7.3 1 .3.6.5.8.4.7.3.8.5.6.5.6.5.7.6.5.5.6.5.5.7.5.6.5.7.4.7.4.7.5.7.3.7.3.8.4.8.2.8.2.8.2h1.8l.7.2v1h-1.8l-.7-.2-1-.2-.8-.2-.8-.2-1-.3-.7-.2-.8-.4-.8-.4-.7-.4-.7-.5-.7-.4-.7-.5-.7-.4-.7-.6-.5-.7-.5-.6-.5-.7-.5-.7-.5-.7-.4-.7-.4-1-.3-.7-.5-.8-.2-.8-.3-1-.2-.7v-1l-.2-.8v-1.8zm17.6-17.8v1h-1.7l-.7.2h-.8l-.8.3-.8.3-.8.3-.7.3-.8.2-.8.4-.7.4-.7.4-.6.5-.7.4-.6.5-.6.5-.6.6-.5.7-.5.6-.5.7-.4.7-.5.7-.4.7-.2.8-.3.8-.3.8-.2.8-.2.8v.8l-.2 1v1.7h-1v-2.8l.2-1 .2-.8.3-1 .2-.8.4-.8.2-.8.4-.7.4-1 .5-.6.5-.7.5-.7.6-.6.6-.6.7-.6.6-.6.6-.5.7-.4.7-.5.7-.3.8-.4.8-.3.8-.4 1-.2.7-.3h1l.8-.2h.8l1-.2h.8z"
        />
        <path
          fill="#edb92e"
          d="M499 118.8a17.6 17.6 0 0 1 0 6c-5.5-.2-11.2-.3-17-.3-5.5 0-11.2 0-17 .3a17.5 17.5 0 0 1 .3-6l16.8-.3c5.8 0 11.4.2 17 .3z"
        />
        <path
          fill="#21231e"
          d="M499.8 122.4h-1V120h-.2v-1l1-.2v1.7l.2.2v1.6zm-.7 3 .2-1-.6.3v-.8l.2-.2v-1.1h1v2.2h-.2l-.5.5zm.6-.5v.3h-.5l.6-.4zm-17.5 0v-1H494l.4.2h4.8v1h-10.6l-.5-.2h-6zm-17.4 0 1-.3-.5-.4h4.7l.4-.2H482v1h-11l-.5.2H465l-.5-.3zm.6.3h-.5v-.4l.5.3zm-.7-3h1v2.4l-1 .3v-2.6zm.8-4v1l.5-.3v.8l-.2.2v2.5h-1v-3h.2v-.4l.5-.5zm-.5.5v-.4h.5l-.5.4zm17.3-.8v1h-9.1l-.5.2H466l-.7.2v-1h2.5l.5-.2h9l.5-.2h4.2zm17.5.8-1 .2.4.4h-3.6l-.5-.2h-10.3l-.5-.2h-2.1v-1h10l.5.2h6.1l.5.6zm-.5-.5h.4v.5l-.4-.5z"
        />
        <path
          fill="#edb92e"
          d="M468.8 133.2c-3.6-2.3-4.3 1.2-4.2 4.7.4 13.2 3 25.8-.6 42-1.4 6.4-3.7 10-1.5 11.3 5.7 3.2 8.3 6 7.4 7.7 1.5 3.2 5.7 2.6 12 1.6 6.6 1 10.7 1.6 12.4-1.6-1-1.6 1.7-4.5 7.4-7.7 2.2-1.2 0-5-1.5-11.3-3.5-16.2-1-28.8-.7-42 0-3.6-.5-7-4-4.8a28.6 28.6 0 0 1-26.8 0z"
        />
        <path
          fill="#21231e"
          d="M465 138h-1v-1.5l.2-.3v-1.6l.2-.3v-.3h.2v-.4l.2-.2v-.3h.2l.2-.3.2-.2.2-.2h.2l.2-.2h1.8l.4.2.4.2h.3l.4.3-.4 1-.4-.3h-.2l-.3-.2h-.3l-.2-.2h-1.2v.2h-.2v.2l-.2.2v.2l-.2.2v.4l-.2.3v.4l-.2.2v2.5zm-.5 42-1-.2.3-1.5.3-1.4.3-1.6.2-1.4.2-1.5.2-1.4v-2.5l.2-1.4V154l-.2-1.2v-2.5l-.2-1.2V148l-.2-1.2v-1.2l-.2-1.3V142l-.2-1.3V138h1v3.5l.2 1.2v2.6l.2 1.2v1.3l.2 1.2v2.5l.2 1.2v1.3l.2 1.3v13.3l-.2 1.4v1.4l-.3 1.5-.2 1.4-.2 1.6-.2 1.4-.2 1.5-.3 1.6zm-1.8 11-.4.8-.3-.2-.2-.2-.2-.2-.2-.2v-.2l-.2-.3V188l.2-.3v-.4l.2-.3v-.4l.2-.4v-.5l.3-.4.2-.4v-.5l.3-.3v-.5l.3-.5v-.6l.3-.4.2-.6v-.6l.3-.6 1 .3-.2.7v.6l-.3.5v.6l-.2.5-.2.4v.6l-.3.4v.5l-.3.4v.4l-.2.4v.4l-.2.4v.4l-.2.3v.4l-.2.4v1.9l.2.2.2.2zm7.6 7.8-1 .4v-.4h.2v-1l-.2-.2v-.2l-.2-.2v-.4l-.3-.2-.2-.2-.2-.3h-.3l-.2-.4-.3-.2-.3-.3h-.3l-.4-.4-.4-.3-.3-.2-.5-.2-.4-.3-.3-.3-.5-.3-.5-.3-.4-.3-.5-.3-.6-.2.5-1 .6.4.5.3.5.3.4.3.5.4.4.3.5.3.5.2.3.3.4.3.4.3.3.4.2.2.3.3.3.2.2.2.2.3.3.2.2.2v.2l.3.3v.2l.3.2v.5l.2.2v1.1l-.2.3v-.5zm-1 .4v-.4.4zm13 1-.2 1h.2-1.2l-.5.2h-1.2l-.6.2h-1l-.5.2h-4.7l-.4-.2h-.3l-.3-.2-.3-.2-.3-.2-.2-.2-.3-.2-.2-.2-.3-.3h-.2l-.2-.4-.2-.4 1-.4v.2l.2.3.2.2.2.2.2.2h.2l.2.2h.2l.3.2h.3l.3.2h.3l.2.2h4.3l.5-.2h1l.6-.2h1.1l.5-.2h.8zm-.2 0h.2zm12-1 1-.4v.4l-.3.4-.2.3h-.2l-.3.4-.2.2-.3.2-.3.2-.3.2-.4.2h-.3l-.3.2h-.4l-.4.2H486l-.6-.2h-.5l-.6-.2h-1.2l-.5-.2h-.6l.2-1h1.8l.5.2h.6l.6.2h1.1l.5.2h4.2l.3-.2h.3l.2-.2h.3l.2-.2.2-.2.3-.3.2-.2.2-.2v-.3l.3-.2v.5zm1-.4v.4-.4zm6.5-8 .5 1-.5.3-.5.4-.5.3-.4.2-.4.2-.4.3-.4.3-.4.3-.4.3-.3.3-.3.3h-.3l-.2.4-.3.2-.3.3h-.2l-.2.4-.2.2-.2.2v.2l-.3.2v.7h-.2v1.2l-.8.5v-.2l-.2-.2v-1.3l.2-.2v-.3l.3-.3v-.3l.3-.2.2-.3.2-.3.3-.3.2-.2.3-.3.3-.4.4-.2.3-.3.4-.2.4-.3.4-.3.4-.2.4-.3.5-.3.5-.3.5-.2.5-.3.5-.3.5-.3zm-1.7-10.7 1-.2v.6l.3.6.2.6.2.5v.7l.3.5v.5l.2.4v.6l.2.5.2.5v.4l.2.3v.4l.2.4v.5l.2.3v.7l.2.3v1.8l-.2.3v.2l-.3.3h-.2l-.2.3-.3.2-.5-1h.2l.2-.2v-.4h.2v-2.5l-.2-.3v-.3l-.2-.3v-.4l-.2-.4v-.4l-.2-.4v-.4l-.3-.5v-.6l-.2-.4v-.6l-.3-.5v-.6l-.3-.6v-.5l-.2-.6-.2-.6zm-.7-42h1v5.9l-.2 1.4v1.2l-.2 1.2v1.3l-.2 1.3v2.5l-.2 1.2v2.6l-.2 1.2v9.3l.2 1.4v1.4l.2 1.3.2 1.5.2 1.5.2 1.4.2 1.5.3 1.3.3 1.5-1 .3-.3-1.5-.3-1.5-.2-1.4-.2-1.5-.2-1.3-.2-1.5v-1.4l-.2-1.4V167l-.2-1.3v-10.3l.2-1.3v-2.5l.2-1.3V149l.2-1.2v-1.3l.2-1.2V143l.2-1.2V138zm-3.3-4.4-.5-1h.4l.3-.2.2-.2h.3l.4-.2h1.2l.3.2h.2l.2.3v.2l.2.2h.2v.4l.2.2v.3h.2v.7l.2.3v1.5l.2.3v1.1h-1v-2.4l-.2-.3v-.8l-.2-.3v-.4l-.2-.2v-.2h-.2v-.2h-.2v-.2h-.2v-.2h-1.1l-.2.2h-.3l-.3.2-.3.2zm-27 0 .4-1 .8.5.7.5.7.4.7.2.7.3.8.2.8.3 1 .2.7.2 1 .2h.7l1 .2h.8l1 .2h4.6l.7-.2h1l.8-.3h.8l1-.3.7-.2.8-.3.8-.2.8-.3.7-.4.8-.3.7-.4.7-.3.5 1-.7.3-.7.4-.8.4-.7.3-1 .4-.7.3-.7.3-1 .2-.7.2-1 .2h-.8l-1 .2h-1l-.8.2h-4.6l-1-.2h-.8l-1-.2-.8-.2-1-.2-.7-.2-.8-.3-.8-.3-.8-.3-.8-.2-.8-.4-.7-.4-.7-.4z"
        />
        <g id="rs-b">
          <path
            fill="#edb92e"
            d="M363 212c-2-4-.3-9.8.3-11 .3-.8-.6-2.2-1-2.8-13-18.3-13.2-20-4.3-26.8 8-6 26.2-12 39.2-16.2 2.7-2 4.4-5 6.8-7.2-25 1.8-52 12-65.5 23.8-7.2 6.2 1.5 19 12.2 38 6.7 5 9.8 7 12.3 2.3z"
          />
          <path
            fill="#21231e"
            d="m362.8 200.7 1 .4v.2l-.2.2v.3l-.2.3v.5l-.2.2v.6l-.2.4v.7l-.2.3v1.6l-.2.4v2.5l.2.4v.4l.2.4v.4l.2.4v.3l.3.4-1 .3v-.4l-.3-.5v-.4l-.2-.4v-.4l-.2-.5v-.8l-.2-.6v-2.9l.2-.4v-1.2l.2-.3v-.4l.2-.2v-.6l.2-.3v-.6l.2-.2v-.2l.2-.2zm-1-2.2 1-.6v.2h.2v.4h.2v.4h.2v.2l.2.2v.4h.2v1.2l-1-.3v-.6l-.2-.2v-.2l-.2-.2v-.2l-.2-.2v-.2h-.2v-.2zm-4-27.5.5 1-.8.5-.7.6-.7.6-.5.6-.6.5-.6.5-.5.6-.5.5-.3.4-.3.5-.3.5v.5l-.3.5v1.7l.2.6.2.8.2.7.4.8.4.8.4 1 .5 1 .6 1 .7 1 .7 1.3 1 1.2.7 1.3 1 1.4 1 1.5 1 1.5 1.3 1.7-.8.5-1.3-1.7-1-1.5-1-1.5-1-1.4-1-1.3-.8-1.2-.8-1.2-.7-1-.6-1-.7-1-.4-1-.6-1-.3-.7-.2-1-.2-.7v-.7l-.2-.7v-1.4l.2-.6.2-.6.2-.6.3-.6.4-.6.5-.5.5-.5.5-.5.6-.6.7-.5.7-.7.7-.6.7-.7zm39-16.2.7.8h-.2l-1.2.5-1.2.5-1.2.4-1.4.3-1.3.4-1.4.5-1.4.4-1.3.5-1.5.5-1.4.5-1.3.5-1.3.5-1.4.5-1.4.5-1.3.5-1.4.5-1.4.5-1.3.6-1.3.6-1.3.5-1.2.7-1.2.5-1.2.6-1 .5-1.2.6-1 .4-1 .6-1 .6-1 .5-1 .7-.7.6-.7.6-.6-1 .8-.5 1-.6.8-.7 1-.6 1-.6 1-.4 1-.6 1.2-.6 1.2-.5 1-.7 1.4-.6 1.3-.5 1.3-.6 1.3-.5 1.2-.4 1.4-.5 1.3-.5 1.3-.5 1.4-.5 1.3-.5 1.4-.5 1.4-.5 1.4-.4 1.4-.5 1.3-.4 1.3-.4 1.3-.4 1.3-.5 1.2-.4 1.3-.5 1.3-.4 1.2-.3zm.7.8h-.2.2zm6.6-7v-1l.4.8-.2.2-.3.2-.3.3-.2.3-.2.2-.2.2v.3l-.3.2-.2.2-.2.2-.2.3-.3.3-.2.3-.2.2-.2.3v.3l-.3.2-.2.3-.2.2-.3.2-.2.3-.2.2-.2.2h-.2l-.3.4-.3.2-.2.2-.3.2-.2.2-.3.2-.2.2-.6-.8v-.2l.3-.2.3-.2.2-.2.2-.2.2-.2.3-.2.2-.2.2-.2v-.2l.3-.3.2-.2.2-.2.2-.2v-.2l.3-.2.2-.2.2-.3.2-.3v-.3l.3-.2.2-.2.2-.3.2-.2v-.2l.4-.3.2-.2.2-.2.2-.3.2-.2h.3l.2-.3.4.8zm0-1 1.4-.2-1 1-.4-1zM338.8 172l-.7-.8 1.5-1 1.4-1.2 1.4-1 1.5-1.2 1.5-1 1.7-1 1.7-1 1.7-1 2-1 1.8-1 2-1 2-1 2-.8 2-1 2.2-.7 2-.8 2.3-.8 2.3-1 2.2-.6 2.3-.7 2.3-.6 2.4-.5 2.3-.6 2.4-.7 2.4-.5 2.4-.4 2.4-.4 2.4-.4 2.3-.3 2.3-.3 2.4-.3 2.3-.2v1l-2.3.2-2.3.3-2.3.3-2.3.3-2.4.4-2.3.4-2.4.4-2.3.5-2.3.6-2.3.5-2.3.6-2.3.7-2.2.7-2.2.7-2.2.8-2.2.8-2.2.8-2 1-2 .7-2.2 1-2 1-2 1-1.8.8-1.8 1-1.8 1-1.7 1-1.6 1-1.5 1-1.6 1-1.5 1.2-1.4 1-1.2 1.2zm12.2 37.3-.5.8-.2-.2-1-1.6-1-1.8-1-1.7-1-1.7-.8-1.7-1-1.6-.8-1.5-.8-1.5-1-1.5-.7-1.5-.8-1.4-.7-1.3-.7-1.4-.5-1.3-.6-1.3-.6-1.2-.4-1.2-.5-1.2-.3-1-.3-1-.4-1.2v-1l-.2-1v-2.8l.3-.8.3-.8.4-.7.5-.8.5-.7.6-.6.8.8-.6.5-.5.6-.4.7-.3.6-.3.7-.2.8v4.5l.4 1v1l.5 1 .4 1 .4 1.3.5 1.2.4 1.2.6 1.3.7 1.3.7 1.4.7 1.4 1 1.4.7 1.5 1 1.5.8 1.5 1 1.6.8 1.7 1 1.7 1 1.7 1 2 1 1.6h-.3zm-.5.8-.2-.2.2.3zm12.5 1.3v1l.5-.2-.3.4-.2.4-.3.4-.3.3-.3.2-.2.3-.3.2-.3.2h-.3l-.5.2h-2.1l-.4-.2-.5-.2-.4-.2-.3-.2-.5-.2-.4-.3-.5-.3-.5-.3-.4-.4-.6-.3-.5-.3-.5-.4-.6-.4-.5-.4-.6-.4-.5-.5.5-.8.7.4.5.3.6.5.6.3.5.5.4.4.5.2.4.3.4.3.5.3.4.3.4.2.5.2.4.2h.5l.3.2h1.5l.2-.2h.3l.2-.3.2-.2.3-.2.2-.3v-.3l.4-.4.2-.4.4-.4zm-.4.3v-.4h.4l-.4.3zm.4.6v-1l.5.3-.5.6zm.5-.7.3.6h-.8l.5-.7z"
          />
          <path
            fill="#edb92e"
            d="M359 213.6a34 34 0 0 1-1-4.7c-.7-2.8-.4-5.7.5-8.3-3-4.2-6.4-8.8-8.8-13.3-1.7-3.3-3-7-2-10.6 1-4 4.5-6.6 7.6-9 3.7-2.8 8.6-5.3 13.6-7.5 11-4.6 20-7 26.5-7l-4.2 3.8c-12 4-26.4 9.2-33.3 14.5-9 6.8-8.6 8.4 4.3 26.7.4.6 1.3 2 1 2.7-.6 1.2-1.8 7.2 0 11.4-1 2-2.6 1-4.2 1.2z"
          />
          <path
            fill="#21231e"
            d="m357.4 209 1-.2v.7l.2.2v.7h.2v.8l.2.3v.3l.2.3v.7h.2v.6h.2l-1 .4v-.3l-.2-.3v-.2l-.2-.3v-.5l-.2-.3v-.6h-.2v-.5l-.2-.3v-.7l-.2-.3v-.2zm1-.2zm-.4-7.8 1-.6v.5l-.2.4v.2l-.2.2v1l-.2.2v.8l-.2.2v4.7l.2.3-1 .2v-.6l-.2-.2V203h.2v-1l.2-.2v-.5l.2-.2v-.2l.2-.3v.5zm1-.6v.5-.6zm-9.7-12.8 1-.5v.6l.3.4.3.4v.4l.4.5.2.4.3.4v.5l.4.4.3.4.2.4.2.4.3.4.2.4.3.5.3.4.3.3.3.4.2.4.2.5.3.5.3.4.3.4.3.4.3.4.2.4.3.4.2.4.3.4.3.4.3.4.3.4-1 .6-.2-.4-.3-.4-.3-.4-.3-.4-.4-.4-.3-.4-.2-.4-.2-.4-.3-.4-.3-.4-.3-.5-.4-.4-.3-.3-.3-.4-.2-.4-.3-.5-.3-.5-.3-.4-.4-.4-.3-.4-.2-.5-.2-.4-.3-.5-.2-.4-.3-.4-.3-.4-.2-.4-.3-.5-.2-.4-.2-.5-.3-.5-.2-.4zm-2-11 1 .4-.2.3v4.1l.2.4v.3l.2.3v.7l.3.3v.4l.2.4v.6l.3.3v.3l.3.3v.2l.3.3v.3l.2.3-1 .6v-.3l-.2-.3-.2-.3v-.3l-.3-.4v-.3l-.3-.3v-.3l-.3-.3-.2-.3v-.3l-.2-.2v-.4l-.2-.3v-.3l-.2-.3v-.7l-.2-.4V180l-.2-.4V178l.2-.2v-.7l.2-.3zm7.7-9.2.6.8-.3.2-.3.3-.3.2h-.3l-.3.3-.2.3-.2.2-.3.3-.3.3-.3.2-.3.3-.2.2-.3.3-.4.3-.2.2-.3.3v.3l-.4.3-.2.3-.2.2-.3.3-.3.3-.2.3-.2.4v.3l-.3.3-.2.3v.3l-.3.3v.3l-.2.3v.4l-1-.3v-.4l.2-.4v-.4l.2-.4.2-.4v-.3l.3-.4.2-.2.2-.3.2-.3v-.3l.4-.5.2-.3.2-.2.3-.3.4-.3.2-.3.3-.2.2-.2.3-.3.2-.3.3-.2.3-.3.3-.2.3-.3.2-.2.3-.2.3-.3.3-.2h.4l.3-.4.3-.2zm13.7-7.5.4.8-.4.2-.4.2-.5.2-.5.2-.4.2-.5.2-.4.3-.6.2-.5.2-.5.2h-.5l-.4.3-.5.3-.3.2-.4.2-.5.3-.4.2-.4.2-.4.3-.5.2-.3.2-.4.3-.4.2-.5.2-.4.2-.2.3-.4.2-.4.2-.4.2-.3.3-.4.3-.4.2-.6-.8.3-.3h.4l.4-.4.4-.3.4-.2.4-.2.4-.2.4-.3.4-.2.4-.2.4-.2.4-.3.5-.2.5-.2.4-.2.4-.2.4-.3h.4l.5-.3.4-.3.6-.2.4-.2.5-.2.5-.3.4-.2.5-.2h.4l.4-.3.5-.2.5-.2.4-.2h.5zm0 0zm27-6.4-.6-.7.5.7H394l-.6.2h-1.8l-.7.2h-.8l-.7.2h-.7l-.8.3-.8.2h-.7l-.8.2-.8.2-1 .2-.8.2-.8.3-1 .3-.8.3-1 .3-.8.2-1 .3-.8.3-1 .3-1 .5-1 .3-.8.4-1 .4-1 .4-1 .4-1 .4-.5-1 1-.4 1-.4 1-.4 1-.4 1-.3 1-.5 1-.3 1-.4 1-.3.8-.3 1-.3.8-.4 1-.2.8-.3h1l.8-.4.8-.2.8-.2.8-.2h.8l.8-.3.8-.2h.7l.7-.2h.8l.7-.2h1.4l.5-.2h1.9l.4.8zm-.3-1h1.4l-1 1-.4-1zm-4.4 4 4-3.7.8.6-4 3.8-.3.2-.5-1zm.7.8-.2.2.2-.2zM358.3 172l-.6-1 .7-.5.7-.5 1-.5.7-.5.8-.5 1-.5.8-.4 1-.5 1-.4.8-.5 1.2-.4 1-.5 1-.3 1-.5 1.2-.5 1-.4 1.3-.5 1-.4 1.2-.5 1-.5 1.3-.5 1-.4 1.3-.4 1.2-.5 1.2-.4 1.2-.4 1.2-.5 1-.4 1.3-.3 1.2-.4 1-.3 1.2-.4.3 1-1.2.3-1 .3-1.3.4-1 .4-1.3.5-1.2.4-1.2.3-1.2.4-1 .4-1.2.6-1.2.4-1 .4-1.3.5-1 .3-1.3.5-1 .4-1.2.5-1 .4-1 .6-1.2.5-1 .5-1 .5-1 .5-1 .5-.8.5-1 .4-.8.4-.8.5-.8.4-.7.5-.7.4-.7.5zm4.4 26-.8.5-1.3-1.7-1-1.5-1-1.5-1-1.4-1-1.3-.8-1.2-.8-1.2-.7-1-.6-1-.7-1-.4-1-.5-1-.4-.7-.2-1-.2-.7v-.7l-.2-.7v-1.4l.2-.6.2-.6.2-.6.3-.6.4-.6.5-.5.5-.5.5-.5.6-.6.7-.5.7-.7.7-.6.7-.7.6 1-.8.5-.7.6-.7.6-.5.6-.6.5-.6.5-.5.6-.5.5-.3.4-.3.5-.3.5v.5l-.2.6v2.2l.3.8.3.7.4.8.4.8.4 1 .6 1 .5 1 .7 1 .7 1.3 1 1.2.7 1.3 1 1.4 1 1.5 1 1.5 1.3 1.7zm1 3-1-.3v-1h-.2v-.2l-.2-.2v-.2h-.2v-.4l.7-.7.2.2v.4h.2v.2l.2.2v.2l.2.2v.4h.2v1.4zm.2 11.6-1-.5v.6l-.2-.4-.2-.5v-.4l-.2-.4v-.6l-.2-.4v-.5l-.2-.4v-5.4l.2-.4v-.7l.2-.4v-.5l.2-.3v-.4l.2-.2 1 .3v.2l-.2.2v.6l-.2.2v.6l-.2.3v1.1l-.2.4v5.1l.2.4v.8l.3.4v.4l.2.4.2.4v.4zm0-.4v.4-.4zm-5 1v1-1h.2l.2-.2h1.4v.2h1.5l.2-.2h.2v-.2h.2v-.2l.2-.2.2-.3 1 .6-.2.2-.2.2v.2l-.2.2h-.2v.2l-.3.2h-.4l-.2.2h-.3v.2h-3v-1zm0 1v-1l.6.2-.5.7zm.6-.8.2.7h-.7l.6-.6z"
          />
          <path
            fill="#edb92e"
            d="M468 132.2c.3-2.3 0-2-.3 1.6-.3-.7-.8-1-1.4-1-1 0-1.7 1.6-1.8 5.2l.2 2.8c-33-.7-52.7 4.3-57.7 14-4.2 7.8 3 21 13.6 36 1.3 1.8 1.2 1.6 0 3-1.8 2.3-3.8 6-2.3 9.2a24.3 24.3 0 0 1-21 1.5c-1-3-3.4-4.4-5.4-5.8-.5-.2-2-1-2-1.4l-10.2-31.6c-9.5-30.7 75.3-33.5 88.3-33.5z"
          />
          <path
            fill="#21231e"
            d="m467.3 134 1-.4-1 .2V132h.2v-1.2l.2-.2.6-.3.3.3v1.6h-1V131l.4.2h.6v-.2 1l-.2.2v1.8h-1zm1 0-.2 1.6-.7-1.5h1zm-2-.7v-1h.7v.2h.4v.2h.2v.2h.2v.2h.2v.2h.2v.2l-1 .5v-.2h-.2v-.2h-.2v-.2h-.4zm0 0zM465 138h-1v-1.8l.2-.3v-.9l.2-.3v-.7h.2v-.3l.2-.3.2-.3.2-.2h.2v-.2h.2v-.2h.5v1h-.2v.2h-.2v.2l-.2.2v.3l-.2.3v.6l-.2.2v2l-.2.3v.4zm-1 0zm.7 3.3v-1l-.5.5v-2.3h-.2v-.4l1-.2v1.8l.2.2v1l-.5.5zm.5-.5v.5h-.5l.5-.5zM407.4 155l-1-.5.7-1 .7-.8.7-1 .8-.7 1-.8 1-.8 1-.8 1-.7 1.3-.7 1.2-.7 1.4-.6 1.6-.6 1.5-.5 1.7-.7 1.7-.5 1.8-.4 2-.5 1.8-.5 2-.3 2.2-.4 2.2-.3 2.2-.2 2.4-.3 2.4-.2 2.5-.2h2.5l2.7-.2h2.7l2.8-.2h9v1H453l-2.8.2h-2.6l-2.6.2-2.5.2-2.4.2-2.3.3-2.2.2-2.2.3-2 .4-2 .3-2 .4-1.8.4-1.8.4-1.7.5-1.6.5-1.5.6-1.5.5-1.3.5-1.3.7-1.2.6-1 .7-1 .7-1 .7-1 .7-.6.8-.7.8-.6.8-.6 1zm13.6 35.5-.8.6-1-1.3-1-1.4-1-1.4-1-1.5-.8-1.3-.8-1.4-1-1.3-.7-1.3-.8-1.3-.8-1.4-.7-1.2-.7-1.3-.6-1-.6-1.3-.5-1.2-.5-1.2-.5-1.2-.4-1-.5-1-.3-1.2-.3-1-.3-1-.2-1.2v-1l-.2-1V158l.3-.8.3-1 .2-.7.3-.8 1 .5-.4.7-.2.7-.2.8-.2.8v4.5l.2 1 .3 1v1l.5 1 .3 1.2.4 1 .5 1.2.5 1 .5 1.2.6 1.2.6 1.2.6 1.3.7 1 .7 1.4.8 1.3.8 1.3.8 1.3 1 1.3.8 1.4 1 1.3.8 1.4 1 1.4 1 1.5zm0 3.8-.8-.7.2-.3.2-.2h.2v-.2l.2-.2v-.4l-.2-.2v-.2h-.2v-.3h-.2v-.3h-.2l.8-.7.2.3.2.3v.2h.2v.4h.2v.2l.2.2v1l-.2.2v.2h-.2v.2l-.2.2-.2.2-.2.3zm-2.5 9-.4-.8-.2.7v-.3l-.2-.5v-.3l-.2-.3v-3.5l.2-.3v-.3l.2-.4.2-.3v-.3l.2-.3.2-.3v-.3l.3-.2v-.3l.3-.2.2-.3v-.2l.3-.3.2-.2v-.3l.3-.2.2-.2.8.7-.2.2-.2.2v.2h-.3v.3l-.3.3-.2.2v.3l-.3.3v.3l-.2.2-.2.3v.7l-.2.2v.2l-.2.3v.6l-.2.4v2.7l.2.3.2.3-.3.6zm.3-.5v.4l-.3.2.3-.6zm-22 1.8 1-.3-.2-.3.6.2.7.3.5.2.6.2h.8l.6.2.6.2h.7l.6.2h5.7l.7-.2h.5l.7-.3h.6l.7-.2.6-.2.7-.2.7-.2.6-.2.6-.3.6-.3.6-.2.7-.4.6-.3.5 1-.6.2-.7.4-.6.4-.7.2-.6.3-.7.2-.6.2-.6.2-.7.2-.6.2h-.6l-.7.3h-.7l-.6.2h-.7l-.7.2h-5l-.7-.2h-.7l-.6-.3h-.7l-.7-.3-.6-.3-.7-.3-.6-.2-.8-.3-.3-.4zm.4.3-.2-.2v-.2l.2.3zm-5.6-5.8.6-1 .2.2.2.2h.2l.2.2.2.2h.2l.2.2v.2h.3v.3h.3l.2.3h.2l.2.3.3.3.2.2.2.2.2.2v.2l.3.2v.2l.3.2.2.2v.2l.3.3.2.2.2.2v.2l.3.3v.3l.2.3-1 .3-.2-.2v-.3h-.2v-.3l-.2-.3-.2-.2v-.2l-.2-.2-.2-.2v-.2l-.3-.2-.2-.2-.3-.3-.2-.2-.3-.3h-.2l-.2-.3v-.2l-.3-.2h-.2v-.3h-.3l-.2-.2h-.2l-.2-.2h-.2l-.2-.3h-.2l-.2-.2h-.2zm-2-1.7.8-.3h.2v.2h.2l.2.2h.2v.2h.4v.2h.2l.2.2h.2l-.6 1-.2-.2h-.2v-.2h-.4v-.2h-.2l-.2-.2h-.2v-.2h-.2v-.2h-.2v-.2h-.2v-.2zm-10.2-31.7 1-.3.2 1 .3 1 .2.8.3 1 .3 1 .3.8.4 1 .3 1 .3 1 .3 1 .3 1 .3.8.2 1 .4 1 .3 1 .2 1 .3 1 .3 1 .4 1 .3 1 .3 1 .3 1 .5 1 .3 1 .3 1 .5 1 .3 1 .3 1 .4 1.2.4 1 .3 1 .4 1.2-1 .3-.3-1-.2-1.2-.3-1-.4-1-.2-1-.3-1-.3-1.2-.4-1-.3-1-.3-1-.4-1-.3-1-.3-1-.3-1-.4-1-.4-1-.3-1-.4-1-.3-1-.3-.8-.3-1-.4-1-.3-1-.3-1-.3-.8-.3-1-.2-1-.3-1-.3-.8-.3-1-.4-.8-.2-1zm88.2-33.6h1l-.5.5h-5.4l-2.5.2h-2.8l-3 .2-3.3.2-3.5.2-3.7.3-3.8.3-4 .4-4 .5-4 .6-4.2.6-4 .7-4.2 1-4 .8-4 1-3.7 1-3.7 1.3-3.4 1.4-3.3 1.4-3 1.5-2.6 1.6-2.3 1.7-2 2-1.6 1.8-1.2 2.2-.8 2.2-.4 2.3v2.5l.7 2.7-1 .3-.6-2.8v-2.8l.3-2.6 1-2.4 1.2-2.2 1.8-2 2-2 2.5-2 2.7-1.6 3-1.5 3.3-1.6 3.5-1.3 3.6-1 4-1.2 3.8-1 4-1 4-.7 4.2-.6 4.2-.6 4-.6 4-.5 4-.4 4-.4 3.7-.4 3.5-.2 3.3-.2 3-.2h3l2.4-.2h5.4l-.6.4zm1 0v.5h-.5l.7-.5zm-.5 0h-.4.5zm.7 0v.5h-.6l.7-.5z"
          />
          <path
            fill="#fff"
            d="M405 190.2c3.5 0 6.4 2.8 6.4 6.4 0 3.5-3 6.4-6.4 6.4s-6.4-3-6.4-6.4c0-3.6 3-6.4 6.4-6.4z"
          />
          <path
            fill="#21231e"
            d="M412 196.6h-1a6 6 0 0 0-3.4-5.3 5.8 5.8 0 0 0-2.6-.6v-1c2.3 0 4.6 1.2 5.8 3.2a7 7 0 0 1 1 3.6zm-7 7v-1c2.2 0 4.3-1.4 5.2-3.4a6 6 0 0 0 .7-2.6h1c0 2.3-1.4 4.6-3.4 6a7 7 0 0 1-3.6 1zm-7-7h1c0 2.2 1.4 4.3 3.4 5.3a5.8 5.8 0 0 0 2.6.5v1a7 7 0 0 1-5.8-3.3 7 7 0 0 1-1-3.6zm7-7v1a6 6 0 0 0-5.2 3.3 6 6 0 0 0-.7 2.6h-1c0-2.4 1.4-4.7 3.4-6a6.8 6.8 0 0 1 3.6-1z"
          />
          <path
            fill="#fff"
            d="M350.8 203.6c3.2 0 6 2.7 6 6s-2.8 6-6 6c-3.3 0-6-2.7-6-6s2.7-6 6-6z"
          />
          <path
            fill="#21231e"
            d="M357.2 209.6h-1c0-2-1-4-2.8-4.8a5.4 5.4 0 0 0-2.6-.7v-1a7 7 0 0 1 5.4 3 6.5 6.5 0 0 1 1 3.6zm-6.4 6.4v-1c2 0 4-1.2 4.8-3a5.5 5.5 0 0 0 .6-2.4h1c0 2-1.2 4.3-3 5.4a6.4 6.4 0 0 1-3.4 1zm-6.5-6.4h1c0 2 1.2 4 3 4.8.8.4 1.6.6 2.5.6v1a6.6 6.6 0 0 1-5.5-3 6.5 6.5 0 0 1-1-3.4zm6.5-6.5v1c-2 0-4 1.3-5 3a5.5 5.5 0 0 0-.5 2.6h-1c0-2.2 1.2-4.4 3-5.5a6.4 6.4 0 0 1 3.5-1z"
          />
          <path
            fill="#fff"
            d="M345 192.7c3.4 0 6 2.7 6 6s-2.6 6-6 6c-3.2 0-5.8-2.7-5.8-6s2.6-6 6-6z"
          />
          <path
            fill="#21231e"
            d="M351.5 198.7h-1c0-2-1.2-4-3-5a5.3 5.3 0 0 0-2.4-.5v-1c2.3 0 4.4 1.2 5.5 3a6.5 6.5 0 0 1 1 3.5zM345 205v-1c2 0 4-1 4.8-2.7a5.5 5.5 0 0 0 .7-2.6h1c0 2.2-1.2 4.3-3 5.5a6.4 6.4 0 0 1-3.4 1zm-6.3-6.3h1c0 2 1.2 4 3 4.8a5 5 0 0 0 2.4.6v1c-2 .2-4.2-1-5.3-3a6.5 6.5 0 0 1-1-3.3zm6.4-6.5v1c-1.8 0-3.7 1-4.6 2.8a5.5 5.5 0 0 0-.7 2.7h-1c0-2.2 1.2-4.4 3-5.5a6.4 6.4 0 0 1 3.4-1z"
          />
          <path
            fill="#fff"
            d="M339.8 181.7c3.3 0 6 2.7 6 6s-2.7 6-6 6-6-2.7-6-6 2.7-6 6-6z"
          />
          <path
            fill="#21231e"
            d="M346.2 187.7h-1c0-2-1.2-4-3-5a5.4 5.4 0 0 0-2.4-.5v-1c2.2 0 4.3 1.2 5.4 3a6.5 6.5 0 0 1 1 3.5zm-6.4 6.4v-1c2 0 3.8-1 4.7-2.7.5-.8.7-1.7.7-2.6h1c0 2-1 4.3-3 5.4a6.4 6.4 0 0 1-3.4 1zm-6.4-6.3h1c0 2 1 4 3 4.8.7.4 1.5.6 2.4.6v1a6 6 0 0 1-5.4-3 6.5 6.5 0 0 1-1-3.3zm6.4-6.5v1c-2 0-4 1.2-4.8 3a5.5 5.5 0 0 0-.6 2.5h-1c0-2.2 1-4.4 3-5.5a6.4 6.4 0 0 1 3.4-1z"
          />
          <path
            fill="#edb92e"
            d="M444.3 202.2c3.4-.3 2.5 5.8 2 7.2-1 1.8-1.8 1.8-3 .2-.8-1.3-2.4-7.2 1-7.5z"
          />
          <path
            fill="#21231e"
            d="m446.6 209.6-1-.4h.2v-.7l.2-.3v-.5l.2-.3V204h-.2v-.3l-.2-.2v-.2l-.2-.2h-.2l-.3-.2h-.2l-.2-.2h-.3v-1h.7l.3.2h.3l.3.2v.2l.3.3.2.2.2.3v.2l.2.3v.7l.2.3v3.7l-.2.3v.5l-.2.3v.5h-.2zm-3.7.3.8-.7.2.3v.2h.2v.2h.2v.2h.7l.2-.2v-.2h.2v-.2h.2v-.3l1 .3v.2l-.2.2v.3h-.2v.2l-.2.2-.2.2h-.4v.2H444v-.2h-.2v-.2h-.2v-.2h-.2v-.3h-.2v-.3h-.3zm1.2-8.4v1h-.4v.2h-.3v.2h-.3v.3l-.2.2v.4h-.2v3.2l.2.2v.6l.2.2v.3l.2.2v.2l.2.2v.2h.2l-1 .7v-.5l-.2-.2v-.2l-.2-.4v-.2l-.2-.3v-.2l-.2-.3v-.7l-.2-.3v-3l.2-.3v-.3l.3-.3.2-.2.2-.3h.2l.2-.3.3-.2h.4l.2-.2z"
          />
          <path
            fill="#fff"
            d="M444.5 205.5c8-.6 6 13.8 4.4 17-2 4.2-4 4.3-6.7.5-2-3-5.8-17 2.2-17.5z"
          />
          <path
            fill="#21231e"
            d="m449.4 222.7-1-.4.2-.3.2-.4v-.4l.3-.5.2-.5v-.6l.2-.6.2-.7V217l.2-.7v-5.1l-.3-.7v-.6l-.3-.7-.3-.6-.3-.5-.3-.5-.3-.4-.3-.4-.4-.4-.5-.2-.5-.2-.5-.2h-1.4v-1h1.5l.6.2.7.2.5.4.6.4.4.4.4.5.4.7.3.6v.7l.3.6.2.7v.7l.3.8v6.3l-.3.7v.7l-.2.6v.6l-.3.6v.5l-.3.5v.4l-.3.3zm-7.5.5.8-.5.2.3.2.3.3.3.2.3h.2v.4h.3l.2.3.2.2h.4l.2.2h1v-.2h.3l.2-.3v-.2l.2-.2.2-.2h.2l.2-.4v-.3l.3-.3.3-.3.2-.4 1 .4-.3.4-.2.5-.2.3-.2.4-.2.3-.2.3-.2.2-.2.2-.2.3-.3.2h-.2v.3h-.4l-.2.2H445l-.4-.2h-.2l-.3-.3v-.2l-.4-.2-.2-.2-.2-.2-.3-.2-.3-.3-.3-.4-.2-.4-.3-.4zm2.5-17.2v-1 1h-.6l-.7.2-.5.2-.5.3-.4.3-.5.4-.3.4-.3.4-.3.6-.2.5v.6l-.2.5v.7l-.2.7v.6l.2.7v1.4l.2.7v.8l.3.7v.6l.3.7.2.6.2.5.2.6.2.7.2.5.2.4.2.4.2.4.2.3-1 .5v-.3l-.3-.5-.2-.4-.2-.4v-.6l-.4-.5-.2-.7-.2-.6-.2-.7-.2-.7v-.7l-.3-.6v-.8l-.2-.7V213l-.2-.7v-.8l.2-.7v-.6l.2-.7v-.7l.4-.6.2-.6.4-.6.4-.5.4-.5.5-.4.6-.3.7-.3.7-.2h.8v1zm0-1v1-1z"
          />
          <path
            fill="#edb92e"
            d="M379.7 210.8c3.3-1 4 5 3.6 6.6-.4 2-1.2 2.2-2.7 1-1-1.2-4-6.5-1-7.6z"
          />
          <path
            fill="#21231e"
            d="m383.8 217.5-1-.2v-2.8l-.2-.3v-.7l-.2-.3v-.3l-.2-.2v-.3l-.3-.2-.2-.2-.3-.3-.3-.3h-.3l-.3-.2h-.6l-.4-1h1.5l.2.2.3.2.2.2.3.2.2.3.2.2v.3l.3.3v.4l.2.3v.3l.2.3v.3l.2.4v.6l.2.3v2.5zm-3.5 1 .7-.6h.2v.2h.2l.2.2h.2v.2h.4l.2-.2v-.2h.2v-.6h.2v-.3l1 .2v.4h-.2v.4l-.2.3v.2h-.2l-.2.2-.2.2h-.2l-.2.2h-1v-.2h-.3l-.2-.2h-.2v-.2h-.2l-.2-.2v-.2zm-.7-8.2.3 1h-.3l-.2.2h-.2v.2l-.2.2v.2l-.2.2v1.8l.2.4v.3l.2.3v.2l.2.3.2.3v.3l.2.3.2.3v.2l.3.2v.2l.2.2.3.3.2.2-.7.6h-.2v-.4l-.3-.2v-.2l-.3-.2v-.3l-.3-.2v-.2l-.2-.3v-.3l-.3-.3v-.4l-.2-.3v-.3l-.3-.3v-.7l-.2-.3V212l.3-.2.2-.3.2-.3.3-.2.2-.2h.2l.4-.3z"
          />
          <path
            fill="#fff"
            d="M380.7 214c7.7-2.5 9.2 12 8.4 15.5-1 4.5-2.8 5-6.2 2-2.6-2.4-9.7-15-2-17.5z"
          />
          <path
            fill="#21231e"
            d="m389.6 229.6-1-.2v-.8l.2-.4v-2.9l-.2-.7V223l-.3-.7v-.7l-.3-.8-.2-.7-.2-.6-.2-.7-.3-.7-.2-.6-.3-.6-.3-.4-.4-.5-.3-.4-.4-.3-.4-.4-.4-.4-.5-.2h-.5l-.5-.2h-1.1l-.6.3-.4-1 .7-.2h2.2l.7.2.7.2.5.4.5.5.5.4.4.5.4.5.4.6.3.7.3.6.3.6.3.7.2.8.2.8.2.7v.8l.3.7v1.5l.2.7v4.4zm-7 2.3.5-1 .5.4.2.2.3.3h.3l.3.3h.2l.3.3h.3l.2.2h1.4l.2-.2.2-.2.2-.3.3-.3v-.6l.2-.2v-.3l.2-.4v-.2l.2-.4 1 .2v.4l-.2.4v.4l-.2.4-.2.3v.3l-.2.3-.2.4v.3l-.3.2h-.2v.3l-.3.2h-.2l-.2.3h-.8l-.3.2h-.5l-.3-.2h-.2l-.3-.2h-.4l-.3-.3-.3-.2h-.3l-.3-.3-.3-.3-.2-.2-.3-.3zm-2-18.5.3 1-.7.2-.6.3-.4.3-.4.4-.4.4-.3.5-.2.5v.5l-.2.6v2.5l.2.6.2.7.2.6.2.7.3.7v.7l.4.6.3.7.4.6.4.6.3.6.4.6.4.5.3.4.3.4.4.4.2.4.3.3-.5 1-.3-.4-.3-.3-.4-.4-.4-.5-.3-.5-.4-.5-.4-.6-.3-.7-.5-.6-.3-.6-.4-.6-.3-.6-.3-.7-.3-.7-.3-.7-.3-.7-.2-.8-.2-.8v-.7l-.2-.7V218l.2-.7.2-.6.2-.6.3-.5.4-.5.6-.5.6-.4.7-.2.6-.3zm0 .5v-.5.5z"
          />
          <path
            fill="#edb92e"
            d="M464.2 137.8c-17.2-1.6-35 .2-52.3 7-14.8 6-13.4 23.2 4.6 47-1.7 3-2.6 6.8-2.7 11h4.8c-1.3-2.8 0-6.4 1.8-9 1-1.5 1.3-1.2 0-3-10.7-15-17.8-28.2-13.6-36 5-9.7 24.6-14.7 57.7-14 0-1 0-1.8-.2-2.7 0 0-.2 0-.3-.2z"
          />
          <path
            fill="#21231e"
            d="m412 145.4-.3-1 1.7-.6 1.6-.6 1.7-.6 1.6-.5 1.6-.4 1.6-.5 1.6-.4 1.7-.4 1.5-.4 1.7-.4 1.6-.4 1.7-.3 1.6-.3 1.8-.3h1.6l1.7-.3 1.7-.2 1.7-.2 1.6-.2h3.3l1.6-.2h11.5l1.6.2h1.6l1.6.3v1l-1.7-.2h-4.9l-1.6-.2h-9.7l-1.6.2H443l-1.5.3-1.7.2-1.6.2-1.6.2H435l-1.7.4-1.6.3-1.7.3-1.6.4-1.6.3-1.7.5-1.5.4-1.6.4-1.8.5-1.6.6-1.6.6-1.7.6-1.6.6-1.6.6zm5 46.7-1-.4.2.5-1.7-2-1.5-2.3-1.5-2-1.3-2.2-1.3-2-1.2-2-1-2-1-2-1-2-.7-1.7-.6-1.8-.5-1.8-.6-1.7-.4-1.6-.3-1.7-.2-1.6v-4.4l.2-1.3.3-1.3.4-1.2.5-1.2.5-1.2.7-1 .8-1 .8-1 1-.7 1-.8 1.3-.8 1.4-.6 1.3-.5.4 1-1.2.5-1.2.6-1 .7-1 .8-1 1-1 .8-.6 1-.7 1-.5 1-.5 1-.3 1.2-.3 1.2-.2 1.2v3.8l.2 1.5.3 1.7.3 1.6.5 1.6.6 1.6.7 1.8.8 1.8 1 2 .8 1.8 1 2 1.2 2 1.2 2 1.4 2 1.4 2.2 1.5 2 1.7 2.3v.6zm0-.5.2.3-.2.3v-.5zm-3 11v1l-.6-.6v-2.5l.2-.4v-1l.2-.4v-.7l.2-.5v-.4l.2-.2v-.4l.2-.3v-.3l.2-.3v-.4l.2-.3v-.3l.2-.3v-.3l.3-.3v-.3l.2-.2.2-.3v-.3l.3-.3v-.4l1 .5v.4l-.3.2v.3l-.2.2-.2.3v.3l-.2.3v.4l-.2.3v.3l-.2.4v.3l-.2.3v.3l-.2.4v.7l-.2.3v.8l-.2.4v.8l-.2.4v1.4l-.2.4v.7l-.5-.6zm0 1h-.6v-.6l.5.5zm4.3-.4 1-.4-.5.8h-4.6v-1h4.6l-.5.7zm1-.4.3.7h-.8l.4-.7zm1-9 .7.6-.2.2v.3l-.2.2-.2.2v.2l-.3.3v.4l-.2.3-.2.2v.3l-.2.3v.2l-.2.3v.7l-.2.2v.5l-.2.3v2.2l.2.3v.4l.2.2-1 .5v-.5l-.2-.3v-.7l-.2-.3v-2.7l.2-.3v-.3l.2-.2v-.3l.2-.3v-.3l.2-.4v-.3l.2-.3.2-.3v-.2l.2-.3.2-.3v-.3l.3-.3v-.3h.3l.2-.3zm0-2.5.7-.5.2.3.2.3v.2h.2v.4h.2v.4l.2.2v.5l-.2.2v.2h-.2v.2l-.2.2v.2h-.2v.3l-.2.2-.8-.6v-.2l.2-.2.2-.2v-.2h.2v-.4h.2v-.2h-.2v-.2l-.2-.2v-.3h-.2v-.3h-.2zm-13.8-36.5 1 .5-.4.7-.2.7-.2.8-.2.8v4.5l.2 1 .3 1v1l.5 1 .3 1.2.4 1 .5 1.2.5 1 .5 1.2.6 1.2.6 1.2.6 1.3.7 1 .7 1.4.8 1.3.8 1.3.8 1.3 1 1.3.8 1.4 1 1.3.8 1.4 1 1.4 1 1.5-.8.6-1-1.3-1-1.4-1-1.4-1-1.5-.8-1.3-.8-1.4-1-1.3-.7-1.3-.8-1.3-.8-1.4-.7-1.2-.7-1.3-.6-1-.6-1.3-.5-1.2-.5-1.2-.5-1.2-.4-1-.5-1-.3-1.2-.3-1-.3-1-.2-1.2v-1l-.2-1V158l.3-.8.3-1 .2-.7.3-.8zm57.7-13.7h1l-.5.5h-14.5l-2.6.2H445l-2.5.3-2.4.2-2.3.3-2.2.2-2.2.3-2 .4-2 .3-2 .4-1.8.4-1.8.4-1.7.5-1.6.5-1.5.6-1.5.5-1.3.5-1.3.7-1.3.6-1 .7-1 .7-1 .7-.8.7-.8.8-.7.8-.6.8-.6 1-1-.5.7-1 .7-.8.7-1 .8-.7 1-.8 1-.8 1-.8 1-.7 1.2-.7 1.3-.7 1.4-.6 1.6-.6 1.5-.5 1.7-.7 1.7-.5 1.8-.4 2-.5 1.8-.5 2-.3 2.2-.4 2.2-.3 2.2-.2 2.4-.3 2.4-.2 2.5-.2h2.5l2.7-.2h2.7l2.8-.2h9l-.6.6zm1 0v.5h-.5l.5-.5zm-1-2.3.7-.7v1.9h.2v1h-1v-2.3l-.2-.2v-.4.3zm.7-.7v.3-.2zm-1.2-.4.8.7v-.6.2h.2v.2l-.7.7v-.4h-.2v-.6zm0 .7-.3-.2.3-.4v.7zm.8 0-.8-.6h.4l.4.7zm-.4-.7h1l-.6.8-.4-.7z"
          />
          <path
            fill="#fff"
            d="M380.6 142.7c3.4 0 6 2.7 6 6s-2.6 6.3-6 6.3-6.2-2.7-6.2-6.2a6 6 0 0 1 6.2-6z"
          />
          <path
            fill="#21231e"
            d="M387.2 148.8h-1c0-2-1.2-4-3-5a5.6 5.6 0 0 0-2.6-.6v-1c2.2 0 4.5 1.2 5.6 3a6.7 6.7 0 0 1 1 3.6zm-6.6 6.7v-1c2 0 4-1.2 5-3a7 7 0 0 0 .6-2.7h1a7 7 0 0 1-3 5.7 6.6 6.6 0 0 1-3.6 1zm-6.7-6.7h1c0 2 1.2 4.2 3 5a5.6 5.6 0 0 0 2.6.7v1a6.6 6.6 0 0 1-5.6-3 6.7 6.7 0 0 1-1-3.7zm6.6-6.7v1.2c-2 0-4 1.2-5 3a5.7 5.7 0 0 0-.6 2.6h-1c0-2.2 1-4.4 3-5.6a6.6 6.6 0 0 1 3.6-1z"
          />
          <path
            fill="#fff"
            d="M392.6 138.7c3.4 0 6.2 2.8 6.2 6.2 0 3.3-2.8 6-6.2 6a6 6 0 0 1-6-6c0-3.5 2.6-6.3 6-6.3z"
          />
          <path
            fill="#21231e"
            d="M399.3 145h-1c0-2.2-1.3-4.3-3.2-5.2a5.6 5.6 0 0 0-2.4-.6v-1a7 7 0 0 1 5.7 3 6.7 6.7 0 0 1 1 3.7zm-6.7 6.6v-1c2 0 4-1.3 5-3a5.7 5.7 0 0 0 .7-2.7h1c0 2.2-1.2 4.4-3.2 5.6a6.6 6.6 0 0 1-3.4 1zM386 145h1c0 2 1.2 4 3 5a5.6 5.6 0 0 0 2.6.6v1a6.7 6.7 0 0 1-5.6-3.2 6.7 6.7 0 0 1-1-3.5zm6.6-6.8v1c-2 0-4 1.2-5 3a5.7 5.7 0 0 0-.6 2.7h-1c0-2.4 1.2-4.7 3.2-5.8a6.6 6.6 0 0 1 3.4-1z"
          />
          <path
            fill="#edb92e"
            d="M394.2 144a261.2 261.2 0 0 0 2 2.4c-9.8 5.4-14 11-13 16.7.2 1 3.2 11.5 9.8 31.7 4.5 3 7.8 6 10 8.4-.2.4.8 1.2.5 1.5.7 3-2.8 2.4-5 1.7-1.2-3-4.6-6-6.6-7.5-.5-.2-2-1-2-1.4l-10.2-31.6c-3-9.8 3.6-16.8 14.4-21.7z"
          />
          <path
            fill="#21231e"
            d="m396.3 147-.5-1v.7h-.2v-.2h-.2v-.2l-.2-.2h-.2v-.2l-.2-.2v-.2h-.2v-.2h-.2v-.2l-.2-.2-.2-.2v-.2h-.2l.8-.7.2.2h.2v.4h.2v.2h.2v.2l.2.2.2.2v.2h.2v.2h.2v.2l.2.2v1zm.2-1 .3.6-.5.3.2-1zm-12.7 17-1 .2v-3.9l.2-.6.2-.5.2-.6.2-.5.3-.5.2-.5.3-.6.4-.5.3-.6.4-.6.5-.5.4-.6.6-.5.5-.5.6-.5.6-.6.5-.5.7-.4.7-.5.6-.5.8-.5.8-.5 1-.5.7-.5.8-.5.5 1-1 .4-.7.5-.8.4-.8.5-.8.4-.7.5-.7.4-.6.5-.7.4-.6.5-.6.4-.5.5-.6.4-.5.6-.5.5-.4.5-.3.5-.3.5-.3.5-.2.5-.2.5-.2.5-.2.5-.2.5v.5l-.2.5v3.1zm0 0zm9.5 31.3-.6.8-.2-.2-.6-1.8-.7-1.8-.5-1.8-.6-1.7-.5-1.6-.5-1.5-.5-1.5-.5-1.5-.4-1.4-.4-1.2-.4-1.3-.4-1.3-.4-1-.3-1.3-.4-1-.3-1-.3-1-.3-1-.3-.8-.2-.8-.2-.8-.2-.6-.2-.7v-.5l-.3-.5v-.5l-.2-.4v-.8h-.2v-.3h1v.3l.2.3v.4l.2.3v.5l.2.5.2.6.2.7.2.7.2.7.2 1 .3.7.2 1 .2 1 .3 1 .3 1 .4 1 .4 1.2.3 1.2.3 1.3.5 1.3.4 1.4.5 1.5.4 1.5.7 1.6.5 1.6.5 1.7.6 2 .6 1.7.5 1.8-.2-.2zm-.6.8-.2-.2.2.3zm10.7 8.4-.7-.6v.6l-.2-.2-.2-.2-.3-.3-.2-.2-.2-.2-.3-.3-.2-.2-.2-.2-.2-.3-.3-.2-.3-.2-.2-.2-.3-.3-.3-.3-.3-.2-.4-.3-.3-.2-.4-.3-.4-.3-.3-.2-.4-.3-.4-.3-.4-.3-.3-.3-.5-.3-.4-.2-.3-.3-.4-.2-.4-.3-.5-.3-.4-.3-.3-.3.6-.7.4.3.4.3h.5l.4.4.3.3.4.3.4.3.5.3.3.2.4.3.3.4.4.3.2.2.4.2.3.3.2.2.3.3.3.3.3.2.4.3.3.2.3.3.3.3.2.2.3.3.3.3.3.3.2.2.3.2.2.3.2.2.2.3v.6zm0-.6.3.3-.3.4v-.6zm.6 1.6-1 .2.2-.5v.2h-.2v.2-.2l-.2-.2v-.2h-.2v-1.2l.8.6v-.2h.2v.2l.2.2v.2l.2.2v.7l-.2.2.2-.6zm-1 .2v-.3l.2-.2-.2.6zm-5 1.8 1-.4-.4-.3h.4l.2.2h.7l.4.2h2.3v-.2h.2v-1.4l1-.2v1.6l-.2.3v.2l-.2.2h-.2l-.2.2h-.4l-.2.2h-3l-.3-.2h-.5l-.3-.2h-.5l-.3-.4zm.2.3h-.2v-.3l.2.3zm-6.6-7.5.6-1 .2.3h.2l.2.3h.2l.3.3.2.3.2.2.2.2.2.2h.2l.2.3.3.2v.3l.4.2.2.3.2.2.3.3.3.2.2.3.3.3.2.2.2.3.2.4.2.3.2.3.2.2.2.3v.3l.3.3v.4l.3.3v.3l-1 .4v-.3l-.2-.4-.2-.3v-.2l-.3-.2v-.3l-.2-.2-.2-.3-.2-.3-.2-.2-.2-.3-.2-.2-.2-.3-.3-.2-.2-.3v-.2l-.3-.3-.3-.2-.2-.2-.2-.2-.3-.2-.2-.2-.2-.2h-.2l-.2-.3h-.2l-.2-.3h-.2l-.2-.3h-.2l-.2-.2zm.6-1 .3.3-.3-.2zm-2.7-.7 1-.3.2.2h.2v.2h.2v.2h.4v.2h.2l.2.2h.2l-.6 1-.2-.2h-.2v-.2h-.4v-.2h-.2l-.2-.2h-.2v-.2h-.2v-.2h-.2v-.2h-.2v-.2zm-10-31.7.8-.3.3 1 .3 1 .2.8.3 1 .3 1 .3.8.4 1 .3 1 .3 1 .3 1 .3 1 .3.8.2 1 .4 1 .3 1 .2 1 .3 1 .3 1 .4 1 .3 1 .3 1 .3 1 .5 1 .3 1 .3 1 .5 1 .3 1 .3 1 .4 1.2.4 1 .3 1 .4 1.2-1 .3-.3-1-.2-1.2-.3-1-.4-1-.2-1-.3-1-.3-1.2-.4-1-.3-1-.3-1-.4-1-.3-1-.3-1-.3-1-.4-1-.4-1-.3-1-.4-1-.3-1-.3-.8-.3-1-.4-1-.3-1-.3-1-.3-.8-.3-1-.2-1-.3-1-.3-.8-.3-1-.4-.8-.2-1zm15-22-.7.5h.6l-1 .6-1 .4-1 .5-.8.4-1 .5-.7.4-1 .5-.7.5-.8.5-.7.6-.7.6-.5.6-.7.6-.5.6-.6.7-.5.6-.4.7-.4.6-.4.7-.3.7-.3.7-.3.7v.8l-.2.7v.7l-.2.8v2.6l.3.8v1l.3.7-1 .3-.2-1v-.8l-.3-1V159l.2-1 .2-.7.2-.6.3-.8.4-.7.5-1 .4-.6.4-.7.6-.7.5-.7.6-.6.8-.6.6-.6.8-.6.7-.6.7-.5.8-.6 1-.5.7-.5 1-.5 1-.5.8-.5 1-.5 1-.5.6.2zm-.5-.3.4-.2.2.4-.6-.2z"
          />
          <path
            fill="#edb92e"
            d="m356 217-.4 2c-2.8.5-5.3.7-7.3.3 3.4-3.3 6-4 7.6-2.4z"
          />
          <path
            fill="#21231e"
            d="m355 218.8.4-2 1 .2-.3 2-.3.4-.6-.6zm1 0v.5h-.3l.4-.4zm-8 .2.7.7-.3-1 .2.2h4.1l.3-.2h1l.2-.2h.7l.2-.2h.3l.2 1h-.8l-.4.2h-.5l-.4.2h-1.3v.2h-3.7l-.4-1zm.2 1-1-.3.8-.7.2 1zm8.2-3-1-.2.2.5v-.2h-.6v-.2h-.6l-.2-.2H353v.2h-.6l-.2.3-.2.2h-.3l-.2.2-.3.2-.2.2-.3.2-.3.2-.2.2-.3.2-.4.3h-.3l-.3.4-.3.3-.7-.7.3-.3.3-.3.3-.3.2-.2.3-.2.3-.2.3-.3h.4l.3-.3h.3l.2-.3h.3l.3-.3h.6l.3-.2h.5l.4-.2h1.3l.2.2h.3l.2.2h.2l.2.2.3.3v.5zm0-.5v.5-.5zm-.5.4h.4-.5zm.3-.5.2.2v.3l-.2-.5z"
          />
          <path
            fill="#edb92e"
            d="M355.6 212.3c1.8.4 2 .7 2.7 1 1 0 2.4 0 3.3-1 4-2.2 4 2 2.5 5-1 2.4-.5 5 .6 7 1.2 2.2 1 3.2 0 4l-1.6 1c-1 1.2-1.8 1-2-.6-3.8-1.6-5-5.3-6.2-8.6-1.7-4.7-7.8-5.8.8-7.7z"
          />
          <path
            fill="#21231e"
            d="M358.4 212.7v1h-.7v-.2h-.4l-.2-.2h-.4l-.2-.2h-.8l-.3-.2.2-1h.4l.2.2h.4l.2.2h.4v.2h.8v.2h.4zm3-.7.5 1v-.2l-.2.2h-.3v.2h-.2l-.2.2h-.2l-.2.2h-2.1v-1h2.2l.2-.2h.2v-.2h.2l.2-.2zm0 0zm3 5.6-.8-.4v-.3l.3-.4v-.5l.2-.2v-.6l.2-.3v-2.2h-.2v-.2h-.2v-.2h-1.2l-.3.2-.3.2-.3.2-.6-1 .4-.2.3-.2h.5l.3-.2h1.8l.2.2.2.2v.2l.2.3v.4l.2.3v2.4l-.2.3v.3l-.2.4v.3l-.2.3v.3l-.3.3zm.6 6.3-1 .4v-.4l-.2-.2v-.4l-.2-.2v-.2l-.2-.2v-.5l-.2-.2v-.8l-.2-.2v-2.3l.2-.2v-.3l.2-.3v-.3l.2-.2 1 .4-.2.2v.4l-.2.2v.8l-.2.2v2l.2.2v.5l.2.2v.4h.2v.2l.2.2v.4h.2zm0 4.6-.6-1h.2v-.2h.2v-1.6l-.2-.3v-.3l-.2-.2v-.2l-.2-.2v-.2l.8-.5v.2l.2.2v.2l.2.2v.2l.2.2v.2l.2.3v1.7l-.2.2v.2h-.2v.2h-.2v.2l-.2.2zm0 0zm-1.6 1-.8-.7v-.2h.2l.2-.2h.2v-.2h.4v-.2h.2v-.2h.4v-.2h.2l.6.8h-.2v.2h-.4v.2h-.2l-.2.2h-.2v.2h-.2l-.2.2zm-.8-.7v-.2zm-1.8 0 .4-.8.3.4v.5h.2v.2h.4v-.2h.2v-.2h.2l.8.6-.2.2-.2.2-.3.2h-.2v.2h-1.1l-.2-.2v-.2l-.2-.2v-.4h-.2v-.7l.2.4zm.4-.8h.3v.4l-.3-.4zm-7-8 1-.3.2.2v.3l.2.3v.4l.2.3v.3l.3.3.2.4v.3l.2.3.2.3v.3l.3.3v.2l.2.3v.2l.3.3.2.3.2.2v.3l.3.2.2.3.2.2.2.2.2.2h.2l.3.3.3.2.3.2.3.2h.3l.2.2-.4 1-.3-.2-.4-.2-.2-.2-.4-.2-.3-.2-.2-.3-.3-.3-.2-.2-.3-.3-.3-.2-.2-.3-.2-.3-.2-.3-.3-.4-.2-.3-.2-.3-.2-.3v-.4l-.2-.3v-.3l-.3-.3v-.3l-.3-.2v-.3l-.2-.4v-.2l-.2-.3-.2-.3v-.3l-.2-.4v-.3zm1.4-8.4v1l-.6.2-.7.2h-.6l-.5.3h-.4l-.4.3h-.3v.3l-.2.2v.2h-.2v.2l.2.3.3.2.2.3.2.2.2.3.3.2v.3l.4.3.2.3.3.5.2.3.2.4.3.4.2.4v.5l.3.4-1 .3v-.4l-.3-.5-.2-.4-.2-.3-.3-.3-.2-.3v-.2l-.4-.3-.2-.3-.3-.3v-.4l-.3-.2-.3-.3-.3-.4v-.2l-.2-.3-.2-.4v-.6l.3-.3v-.2l.3-.3h.3l.4-.3.4-.3.5-.2h.4l.7-.3.8-.2.7-.2zm0 0zm0 1v-1 1zm0-1z"
          />
          <path
            fill="#edb92e"
            d="M357 212.5c3.5 1.2 4-.7 6-.6-.8 5-1.7 7.7-7 5-3-1.6-6.7.7-7.4 2.3-.3.6-2-.6-2.6-2-2.6-5.8 6.7-6.4 11-4.8z"
          />
          <path
            fill="#21231e"
            d="m363.6 212-1-.2.5.6H362v.2h-.3l-.2.2h-.2l-.3.2h-.3v.2h-.7l-.2.2h-2l-.4-.2h-.3l-.3-.2.3-1h.3l.3.2h.4l.2.2h1.3l.2-.2h.2l.2-.2h.5l.2-.2h.2l.3-.2h.5l.2-.2h.4l.6.6zm-.5-.6h.7v.6l-.6-.6zm-7.2 6 .4-1 .5.4.5.2h.4l.4.3h.3l.4.2h1.7l.2-.2.3-.3.2-.3v-.2l.2-.2.2-.3v-.3l.2-.3v-.3l.2-.2v-.4l.2-.4v-.4l.2-.4v-.9l.2-.5 1 .2v.5l-.2.5v.8l-.2.5v.4l-.2.4v.4l-.3.4v.3l-.2.4-.2.4v.2l-.3.3-.2.3-.2.2-.3.2-.2.2h-.2l-.3.2h-.3l-.3.2h-1.6l-.4-.2-.4-.2h-.4l-.4-.3-.5-.3-.5-.3zm-6.8 2-1-.3h.2v-.3h.3v-.3l.3-.2v-.2l.3-.2h.3l.2-.3.2-.2h.3l.2-.3h.3l.2-.3h.3l.3-.2h.3l.2-.2h.3l.4-.2h2.3l.3.2h.3l.3.2h.2l-.4 1h-.3l-.2-.2h-.5l-.3-.2h-1.8l-.3.2h-.3l-.3.2h-.3l-.2.3h-.2l-.3.2h-.2l-.2.2h-.2v.2l-.2.2h-.2v.3h-.2v.2h-.2v.2h-.2zm-3.5-2 1-.3v.4h.2v.4h.2v.2l.2.2h.2v.2l.2.2h.2v.2h.4v.2l.8.5v.2l-.3.2h-1v-.2h-.2l-.3-.2h-.2v-.2l-.2-.2-.2-.2h-.2v-.3h-.2v-.2h-.2v-.3h-.2v-.4h-.2v-.3zm11.8-5.4-.3 1-.4-.2h-.5l-.3-.2h-.5l-.5-.2h-5l-.5.2-.4.2h-.4l-.4.3-.4.3-.3.2v.2l-.4.2-.2.2v.3l-.3.2v1.6l.3.4.2.5-1 .5-.2-.5-.2-.6V215l.2-.6.2-.4.2-.4.3-.3.2-.4.3-.3.4-.3.4-.2.4-.2.5-.2h.5l.5-.3h1.1l.5-.2h3.3l.6.2h.5l.4.2.5.2h.3zm0 .5v-.5.5z"
          />
          <path
            fill="#fff"
            d="M458.8 124.5c3.4 0 6.2 2.7 6.2 6 0 3.5-2.8 6.3-6.2 6.3s-6-2.8-6-6.2a6 6 0 0 1 6-6z"
          />
          <path
            fill="#21231e"
            d="M465.5 130.6h-1c0-2-1.3-4.2-3.3-5a5.5 5.5 0 0 0-2.4-.6v-1a7 7 0 0 1 5.7 3 6.7 6.7 0 0 1 1 3.6zm-6.7 6.7v-1c2 0 4-1.2 5-3a5.6 5.6 0 0 0 .6-2.7h1c0 2.3-1 4.5-3 5.7a6.6 6.6 0 0 1-3.6 1zm-6.6-6.7h1c0 2 1.3 4.2 3.2 5a5.5 5.5 0 0 0 2.4.7v1a6.6 6.6 0 0 1-5.6-3.2 6.7 6.7 0 0 1-1-3.4zm6.6-6.6v1c-2 0-4 1.2-5 3a5.6 5.6 0 0 0-.6 2.6h-1c0-2.2 1.2-4.4 3.2-5.6a6.6 6.6 0 0 1 3.4-1z"
          />
          <path
            fill="#fff"
            d="M446.3 124.5a6 6 0 0 1 6 6c0 3.5-2.6 6.3-6 6.3s-6-2.8-6-6.2c0-3.4 2.6-6 6-6z"
          />
          <path
            fill="#21231e"
            d="M453 130.6h-1c0-2-1.3-4-3.2-5a5.5 5.5 0 0 0-2.5-.6v-1c2.3 0 4.5 1.2 5.6 3a6.7 6.7 0 0 1 1 3.6zm-6.7 6.7v-1c2 0 4-1.3 5-3a7 7 0 0 0 .6-2.7h1c0 2.3-1.3 4.5-3.2 5.7a6.6 6.6 0 0 1-3.5 1zm-6.6-6.7h1c0 2 1.2 4.2 3 5a5.5 5.5 0 0 0 2.6.7v1a6.5 6.5 0 0 1-5.6-3.2 6.7 6.7 0 0 1-1-3.4zm6.6-6.6v1c-2 0-4 1.2-5 3a5.6 5.6 0 0 0-.6 2.6h-1a7 7 0 0 1 3-5.6 6.6 6.6 0 0 1 3.6-1z"
          />
          <path
            fill="#fff"
            d="M433.8 125.5a6 6 0 0 1 6 6c0 3.5-2.6 6.3-6 6.3s-6-2.8-6-6.2 2.6-6 6-6z"
          />
          <path
            fill="#21231e"
            d="M440.4 131.6h-1c0-2-1.2-4-3-5a5.5 5.5 0 0 0-2.6-.6v-1a7 7 0 0 1 5.6 3 6.7 6.7 0 0 1 1 3.6zm-6.6 6.7v-1c2 0 4-1.3 5-3a5.7 5.7 0 0 0 .6-2.7h1a7 7 0 0 1-3 5.7 6.6 6.6 0 0 1-3.6 1zm-6.6-6.7h1c0 2.2 1.3 4.3 3.2 5.2a5.5 5.5 0 0 0 2.4.5v1a6.4 6.4 0 0 1-5.6-3.2 6.7 6.7 0 0 1-1-3.4zm6.6-6.6v1c-2 0-4 1.2-5 3a5.7 5.7 0 0 0-.6 2.6h-1c0-2.3 1.3-4.6 3.3-5.7a6.6 6.6 0 0 1 3.3-1z"
          />
          <path
            fill="#fff"
            d="M422.3 127.7c3.3 0 6 2.8 6 6.2 0 3.3-2.7 6-6 6s-6.2-2.7-6.2-6 3-6.3 6.3-6.3z"
          />
          <path
            fill="#21231e"
            d="M429 134h-1a6 6 0 0 0-3.3-5.2 5.5 5.5 0 0 0-2.4-.6v-1c2.2 0 4.4 1.2 5.6 3.2a6.7 6.7 0 0 1 1 3.5zm-6.7 6.5v-1c2 0 4-1.2 5-3 .4-1 .6-1.8.6-2.6h1c0 2-1.3 4.3-3.3 5.5a6.6 6.6 0 0 1-3.4 1zm-6.7-6.6h1c0 2 1.2 3.8 3 4.8a5 5 0 0 0 2.7.7v1a7 7 0 0 1-5.7-3 6.7 6.7 0 0 1-1-3.6zm6.7-6.8v1c-2 0-4.2 1.3-5 3.2a5.7 5.7 0 0 0-.7 2.5h-1c0-2.5 1.3-4.7 3.3-6a6.6 6.6 0 0 1 3.3-.8z"
          />
          <path
            fill="#fff"
            d="M346.3 159.4a6 6 0 0 1 6 6.2c0 3.4-2.6 6.2-6 6.2s-6-2.8-6-6.2a6 6 0 0 1 6-6.2z"
          />
          <path
            fill="#21231e"
            d="M353 165.6h-1c0-2-1.3-4-3.2-5a5.6 5.6 0 0 0-2.5-.7v-1c2.2 0 4.5 1 5.6 3a6.7 6.7 0 0 1 1 3.6zm-6.7 6.7v-1c2 0 4-1.2 5-3a7 7 0 0 0 .6-2.7h1c0 2.3-1.3 4.5-3.2 5.7a6.6 6.6 0 0 1-3.5 1zm-6.7-6.7h1c0 2 1.3 4.2 3.2 5a5.6 5.6 0 0 0 2.5.7v1a7 7 0 0 1-5.6-3 6.7 6.7 0 0 1-1-3.7zm6.7-6.7v1c-2 0-4 1.2-5 3a5.7 5.7 0 0 0-.6 2.6h-1a7 7 0 0 1 3-5.7 6.6 6.6 0 0 1 3.6-1z"
          />
          <path
            fill="#fff"
            d="M356.8 152.8c3.4 0 6.2 2.7 6.2 6 0 3.6-2.8 6.3-6.2 6.3-3.4 0-6-2.6-6-6a6 6 0 0 1 6-6.2z"
          />
          <path
            fill="#21231e"
            d="M363.5 159h-1c0-2.2-1.3-4.2-3-5a5.6 5.6 0 0 0-2.7-.7v-1a7 7 0 0 1 5.7 3 6.7 6.7 0 0 1 1 3.6zm-6.7 6.6v-1a5.7 5.7 0 0 0 5.7-5.7h1a7 7 0 0 1-3 5.6 6.6 6.6 0 0 1-3.7 1zm-6.6-6.7h1c0 2 1.2 4 3 5a5.6 5.6 0 0 0 2.6.6v1a7 7 0 0 1-5.6-3 6.7 6.7 0 0 1-1-3.7zm6.6-6.8v1c-2 0-4 1.3-5 3.2a5.7 5.7 0 0 0-.6 2.5h-1c0-2.3 1.2-4.6 3-5.8a6.6 6.6 0 0 1 3.6-1z"
          />
          <path
            fill="#fff"
            d="M368.8 147c3.4 0 6 3 6 6.3 0 3.4-2.6 6.2-6 6.2s-6-2.8-6-6.2a6 6 0 0 1 6-6.2z"
          />
          <path
            fill="#21231e"
            d="M375.4 153.3h-1c0-2-1.2-4.2-3-5a5.6 5.6 0 0 0-2.6-.7v-1a7 7 0 0 1 5.6 3 6.7 6.7 0 0 1 1 3.7zm-6.6 6.7v-1c2 0 4-1.3 5-3a5.7 5.7 0 0 0 .6-2.7h1a7 7 0 0 1-3 5.7 6.6 6.6 0 0 1-3.6 1zm-6.7-6.7h1c0 2 1.4 4 3.2 5a5.6 5.6 0 0 0 2.6.7v1a6.9 6.9 0 0 1-5.7-3.2 6.7 6.7 0 0 1-1-3.5zm6.8-6.7v1c-2 0-4 1.2-5 3a5.7 5.7 0 0 0-.6 2.7h-1c0-2.3 1-4.5 3-5.7a6.6 6.6 0 0 1 3.6-1z"
          />
          <path
            fill="#fff"
            d="M338.2 169.5a6 6 0 0 1 6 6.2c0 3.4-2.6 6.2-6 6.2s-6.2-3-6.2-6.3 2.8-6.2 6.2-6.2z"
          />
          <path
            fill="#21231e"
            d="M344.8 175.7h-1c0-2-1.3-4.2-3.2-5a5.6 5.6 0 0 0-2.4-.7v-1a7 7 0 0 1 5.6 3 6.7 6.7 0 0 1 1 3.7zm-6.6 6.7v-1c2 0 4-1.3 5-3a5.7 5.7 0 0 0 .6-2.7h1c0 2.3-1.2 4.5-3.2 5.7a6.6 6.6 0 0 1-3.4 1zm-6.7-6.7h1c0 2 1.2 4 3 5a5.6 5.6 0 0 0 2.7.7v1a6.9 6.9 0 0 1-5.7-3.2 6.7 6.7 0 0 1-1-3.5zm6.7-6.7v1c-2 0-4 1.2-5 3a5.7 5.7 0 0 0-.7 2.7h-1c0-2.3 1.2-4.5 3.2-5.7a6.6 6.6 0 0 1 3.5-1z"
          />
          <path fill="#edb92e" d="m454.2 276.3-22 12.8-23.4-10 22-12.8z" />
          <path
            fill="#21231e"
            d="m431 266.7-22 12.8-.4-1 22-12.7h.5v1zm-.4-1h.5-.4zm23.5 11-23.3-10 .4-1 23.4 10v1h-.3zm.4-1 1 .5-1 .5v-1zm-22.4 13 22-13 .5 1-22 12.8h-.5v-.8zm.5.8-.2.2h-.3l.5-.2zm-23.4-11 23.4 10-.4 1-23.3-10v-1h.4zm-.3 1-1-.4 1-.4v1z"
          />
          <path
            fill="#c6363c"
            d="M431 270.6c5.8-.3 10.5 2.5 10.8 6.3.2 3.7-4.2 7-9.8 7.4-5.7.3-10.4-2.5-10.7-6.3-.2-3.6 4.2-7 9.8-7.4z"
          />
          <path
            fill="#21231e"
            d="M442.3 277h-1v-.7l-.2-.3v-.6l-.3-.3v-.2l-.3-.2-.2-.3-.2-.3-.3-.2-.3-.3-.2-.2-.3-.2h-.5l-.3-.3-.3-.2-.5-.2-.4-.2h-.3l-.4-.2h-.4l-.5-.3h-.9l-.5-.2h-.8l-.5-.2h-1l-.5.2v-1h3.6l.4.2.5.2h.5l.4.2.5.2.5.2.4.2.3.2.4.2.4.2.4.2.4.3.3.3.4.3.3.3.3.3.2.4.2.3.2.3.2.4v.3l.3.4.2.4v.8zm-10.3 8v-1l.4-.2h.9l.5-.2h.4l.4-.2h.5l.4-.3h.5l.4-.2.4-.2.4-.2.3-.2.4-.2.4-.3.4-.2.3-.2.3-.3.3-.2.3-.3v-.3l.3-.3.2-.4.2-.2v-.3l.2-.2v-.6l.2-.3v-1.1l1-.2v1.6l-.2.4v.3l-.3.5v.3l-.3.4-.3.3v.3l-.4.4-.3.3-.3.3-.3.2-.3.3-.4.3-.4.2-.4.3-.4.3-.4.2-.4.2-.5.2h-.4l-.4.2-.5.2h-.4l-.5.2h-.4l-.5.2h-1zm-11.2-6.8h1v.5l.2.3v.3l.2.3.2.3v.2l.3.3.2.2v.3l.4.2.2.3.3.2.2.2.3.2.4.2.2.2h.4l.4.3h.4l.4.2.4.2h.4l.5.2h1l.4.2h2.3v1H428l-.5-.2h-.4l-.5-.3h-.6l-.4-.3h-.4l-.5-.3-.3-.2-.3-.3-.4-.2-.4-.2-.3-.3-.3-.2-.3-.3-.3-.3-.3-.3v-.3l-.3-.3-.2-.3-.2-.4-.2-.3v-1l-.2-.4zm10.3-8 .2 1h-1.5l-.5.2h-.5l-.5.2-.4.2h-.5l-.4.3-.5.2-.4.2-.3.2-.4.2-.3.2-.3.3-.4.2-.3.3-.3.2-.2.3-.3.2-.2.3-.2.3-.2.4-.2.3v.3l-.3.3v.8l-.2.3v.6l-1 .2V277l.2-.4v-.3l.2-.4v-.5l.3-.3.2-.4.3-.3.2-.3.3-.3.2-.4.4-.3.4-.3.3-.3.4-.3.5-.2.3-.3.5-.3.4-.2.4-.2.6-.2h.4l.5-.2h.5l.5-.3h.5l.5-.2h1.1l.5-.2z"
          />
          <path
            fill="#edb92e"
            d="m382.4 270 23.8 9-19.7 13c-5-1.6-9-19-4-22z"
          />
          <path
            fill="#21231e"
            d="m406 279.4-23.8-9 .4-1 23.7 9v1h-.3zm.3-1 1 .4-1 .5v-1zm-20 13.3 19.6-13.2.4.8-19.6 13.3h-.4v-1zm.5 1h-.4.4zm-4.2-23.3-.4 1h.5l-.4.2-.4.3-.4.4-.2.5-.2.4-.2.7-.2.8v1.5l-.2.8v2.8l.3.8v1l.2.8.2 1 .2 1 .3.7v1l.5 1 .3.7.3.7.5.8.4.6.3.6.4.6.4.5.5.4.4.2.3.3.4.2-.3 1-.6-.3-.5-.3-.5-.3-.5-.5-.4-.6-.6-.6-.4-.7-.4-.7-.4-.7-.4-1-.3-.8-.3-1-.3-.8-.4-1-.2-.8-.2-1-.2-1v-.8l-.3-1v-5.2l.3-.8.2-.7.3-.6.3-.6.4-.5.4-.5.5-.4h.6zm-.5 0h.6-.5zm.4.4.2-.4-.2.5zm-.3-.4h.6-.5z"
          />
          <path
            fill="#0c4076"
            d="M382.8 274.3c5.7-.6 10.5 2 11 5.8.3 3.8-4 7.4-9.6 8-3.6.3-6-3-6.3-6.3-.5-3.4 1-7 4.8-7.4z"
          />
          <path
            fill="#21231e"
            d="M394.2 280h-1v-.5l-.2-.3v-.3l-.2-.4-.2-.3-.2-.2-.2-.2-.2-.3-.2-.2-.3-.3-.2-.2-.3-.2-.3-.2-.4-.2-.3-.2-.4-.2-.3-.2h-.4l-.5-.3h-.4l-.4-.2h-.8l-.5-.2h-3.6l-.2-1h3.8l.4.2h.5l.4.2.4.2h.4l.5.3.4.2h.5l.4.3.2.2.4.3.3.2.2.3.3.3.3.3.2.2.3.3.2.3.2.3v.5l.3.4v.2l.2.4v.4zm-10 8.4v-1h1l.5-.2h.4l.6-.2.5-.2h.5l.4-.3.4-.2h.4l.4-.3.3-.3.4-.2.2-.2.4-.3.3-.2.2-.3.3-.2.2-.3.3-.3.2-.3.2-.2.2-.3v-.4l.3-.3v-.8l.2-.4v-1h1v1.6l-.2.3v.3l-.2.4-.2.3-.2.4-.2.3-.2.4-.3.4-.2.3-.3.3-.3.3-.5.3-.3.3h-.4l-.4.4-.4.2-.4.3h-.4l-.4.3-.5.2h-.5l-.4.3-.5.2h-.6l-.5.2h-.7l-.5.2h-.5zm-6.8-6.7h1v.7l.2.3v.3l.2.4v.3l.2.2v.2l.2.3.2.2v.3l.3.2.2.3v.2l.2.2h.2l.2.3h.2l.2.3.2.2h.3l.2.2h.2l.2.2h.2l.3.2h1.4v1h-2.1l-.3-.2h-.4l-.3-.3-.3-.2-.3-.2-.3-.2-.2-.2-.3-.2-.3-.2-.2-.2-.3-.3-.2-.2v-.2l-.3-.3-.2-.3v-.2l-.3-.4v-.3l-.3-.3-.2-.3v-.3l-.2-.3v-.6l-.2-.3v-.3zm5.4-8v1h-.2l-.4.2h-.8l-.3.3-.3.2-.3.2-.2.2h-.2l-.2.2v.2l-.3.2v.3h-.3v.3l-.2.3-.2.2v.7l-.2.3v.4l-.2.3v2.2h-1V279l.2-.3v-.3l.2-.2v-.3l.2-.3.2-.3v-.4l.3-.3.2-.3.2-.2v-.3l.3-.2.3-.2h.2l.3-.3.4-.2.3-.2h.3l.3-.2h.7l.4-.2h.4z"
          />
          <path
            fill="#fff"
            d="M457.5 280.4c1.7 0 3.2 1.5 3.2 3.2 0 1.8-1.5 3.3-3.2 3.3-1.8 0-3.2-1.6-3.2-3.4 0-1.7 1.4-3.2 3.2-3.2z"
          />
          <path
            fill="#21231e"
            d="M461.2 283.6h-1v-.6l-.2-.2v-.2l-.2-.3v-.2h-.2v-.2h-.2v-.2h-.2l-.2-.2-.3-.2h-.2l-.2-.2h-.7v-1h1l.3.2.2.2h.2l.3.2v.2h.2v.2h.2v.3h.2v.2l.2.2v.2h.2v.2l.2.3v.5l.2.2v.2zm-3.7 3.8v-1h.4l.3-.2h.2l.2-.2h.2v-.2h.2v-.2h.2v-.2l.2-.2.2-.2v-.2l.2-.2v-1h1.2v.8l-.2.2v.3l-.2.2v.2l-.2.2-.2.3h-.2v.3h-.3l-.2.2-.3.2-.3.2h-.6v.2h-.6v.2h-.3zm-3.7-3.8h1v1h.2v.2l.2.2v.2l.2.2h.2v.2h.2v.2h.2l.2.2h.2v.2h1v1.2h-.7l-.2-.2h-.5v-.2h-.3l-.2-.2-.3-.2-.2-.2h-.2v-.3h-.2l-.2-.3-.2-.3v-.2l-.2-.3v-.3l-.2-.3v-.8zm3.7-3.7v1h-.9l-.2.2h-.2v.2h-.2v.2h-.2v.2h-.2v.2h-.2v.2l-.2.3v.5h-.2v.8h-1v-1.2l.2-.2v-.3h.2v-.3l.2-.2.2-.2v-.2h.4v-.2l.2-.2h.2v-.2h.5v-.2h.4v-.2h1z"
          />
          <path
            fill="#fff"
            d="M408.7 283c1.8 0 3.2 1.6 3.2 3.4 0 1.7-1.5 3.2-3.3 3.2a3.2 3.2 0 0 1-3.2-3.2c0-1.8 1.4-3.3 3.2-3.3z"
          />
          <path
            fill="#21231e"
            d="M412.4 286.4h-1v-.9l-.2-.2v-.2l-.2-.2v-.2l-.2-.2-.2-.2h-.2v-.2h-.2v-.2h-.4l-.2-.2h-.8v-1.2h.7v.2h.7v.2h.3v.2h.3v.2h.3l.2.2.2.3h.2l.2.3.2.3v.3h.2v.6l.2.2v.9zm-3.7 3.7v-1h1v-.2h.2l.2-.2h.2v-.2h.2v-.2h.2v-.2l.2-.2v-.3h.2v-.5l.2-.2v-.4h1v.8l-.2.2v.3l-.2.2v.3h-.2v.3h-.2l-.2.3h-.2v.2h-.3l-.2.2h-.2v.2h-.3v.2h-.5l-.2.2h-.8zm-3.7-3.6h1v.8h.2v.5h.2v.2h.2v.2h.2v.2h.2l.2.2h.2v.2h.5v.2h.7v1h-1.2v-.2h-.3v-.2h-.2l-.2-.2-.2-.2h-.2v-.2h-.2v-.3h-.3v-.3h-.2v-.3l-.2-.2v-.2l-.2-.3v-.8zm3.7-3.8v1h-.7v.2h-.5v.2h-.2l-.2.2v.2h-.2l-.2.2v.2l-.2.2v.2h-.2v.7l-.2.3v.4h-1v-1l.2-.2v-.3l.2-.3.2-.3v-.3h.3v-.3h.2l.2-.2.2-.2h.2v-.2h.6l.3-.2h.5l.3-.2h.2z"
          />
          <path
            fill="#fff"
            d="M407 268.3c1.8 0 3.2 1.4 3.2 3.2 0 1.8-1.4 3.2-3.2 3.2a3.2 3.2 0 0 1-3.2-3.2c0-1.8 1.4-3.2 3.2-3.2z"
          />
          <path
            fill="#21231e"
            d="M410.7 271.5h-1v-.7l-.2-.2v-.3l-.2-.2h-.2v-.4h-.2v-.2h-.2l-.2-.2h-.2l-.2-.2h-.5v-.2h-.4v-1h.8v.2h.3l.3.2h.2l.3.2h.2v.2l.3.2.2.2.3.3.2.3v.3h.2v.4l.2.2v1zm-3.7 3.7v-1h1v-.2h.2l.2-.2h.2v-.2h.2v-.2h.2v-.2l.2-.2.2-.2v-.4h.2v-1h1v1.2l-.2.2-.2.3v.3h-.2l-.2.3h-.2v.3h-.3v.2h-.2v.2h-.2l-.2.2h-.5l-.3.2h-.7zm-3.7-3.7h1v.8l.2.2v.4h.2v.2l.2.2v.2h.2v.2h.2v.2h.2l.2.2h.5l.2.2h.5v1h-.9l-.3-.2h-.2l-.3-.2-.3-.2h-.2l-.2-.2-.2-.3h-.3v-.3l-.2-.3v-.3h-.2v-.4l-.2-.2v-.8zm3.7-3.7v1h-.8v.2h-.5l-.2.2h-.2v.2h-.2v.2h-.2v.2h-.2v.2l-.2.2v.3l-.2.2v.7h-1v-1.2h.2v-.6h.2v-.3h.2v-.3h.3l.2-.2v-.2h.3v-.2h.3l.2-.2h.4v-.2h.5l.2-.2h.7z"
          />
          <path
            fill="#fff"
            d="M457.3 266.2c1.8 0 3.2 1.4 3.2 3.2 0 1.8-1.4 3.2-3.2 3.2a3.2 3.2 0 0 1-3.2-3.2c0-1.8 1.6-3.2 3.3-3.2z"
          />
          <path
            fill="#21231e"
            d="M461 269.4h-1v-.8h-.2v-.3l-.2-.2v-.2h-.2v-.2h-.2v-.2l-.2-.2h-.2l-.2-.2h-.2l-.3-.2h-.7v-1h1.1l.2.2h.3l.3.2.3.2.2.3h.2v.2h.2v.2h.2v.3h.2v.3l.2.2v.5l.2.2v.7zm-3.7 3.7v-1h1.2v-.2h.2l.2-.2.2-.2v-.2h.2v-.2h.2v-.2l.2-.2v-.5h.2v-.8h1v1.1l-.2.2v.2l-.2.2-.2.3-.2.3-.2.2-.2.2-.2.2h-.2v.2h-.3v.2h-.4l-.2.2h-1zm-3.7-3.6h1v.5l.2.2v.3l.2.2v.2h.2l.2.2v.2h.2v.2h.2l.3.2h.2l.2.2h.7v1h-1l-.3-.2h-.3l-.3-.2-.3-.2v-.2l-.3-.2-.2-.2v-.2h-.2v-.3h-.2v-.6l-.2-.2v-.7l-.2-.2v-.2zm3.7-3.7v1h-.7v.2h-.4l-.2.2h-.2v.2h-.2v.2l-.2.2-.2.2v.4h-.2v.8h-1.2v-.5l.2-.3v-.4l.2-.2v-.2h.2v-.3h.2v-.3h.2v-.2h.3v-.3l.3-.2.3-.2h.3l.2-.2h1z"
          />
          <path
            fill="#edb92e"
            d="M371 237.4c2.3-.8 6 4.6 7 4.5 1.2-3-1.2-10.5-5.5-16.3-3-1-3.2-3-3.8-7.3-.2-1.3-2.7-.4-2.7 2 0 2.3-.3 3.6.3 5.6.2.8 0 1.6-.8 2.3 4.5 1.8 5.6 4 5.4 9z"
          />
          <path
            fill="#21231e"
            d="m377.6 241.8 1 .3-.5.4h-.4l-.3-.2-.2-.2-.3-.3-.2-.2-.2-.2-.2-.2-.3-.3-.3-.2-.2-.2-.2-.3-.3-.2-.2-.2-.3-.2-.2-.3h-.3l-.3-.3h-.2l-.3-.3-.3-.2h-.2l-.3-.2h-.4l-.2-.2h-.4l-.4-1h1.3l.3.2h.3l.3.2.2.2h.3l.3.3.2.2h.3l.3.3.3.3v.2l.4.2.2.3.3.2v.2l.4.3.2.2.2.2.2.2.2.2.2.2h.2v.2h.3v.2l-.4.3zm1 .3-.2.4h-.3l.5-.3zm-6.3-15.8.4-1 .2.2.3.5.4.5.4.6.4.7.4.5.3.6.5.6.3.6.3.6.4.6.3.6.2.6.2.6.2.5.2.6.2.7.2.5v.6l.3.5v.6l.2.4v.5l.2.4v3.3l-.2.3-1-.2v-.3l.2-.3v-3.6l-.3-.5v-.4l-.2-.5-.2-.5-.2-.5v-.5l-.4-.6-.2-.7-.2-.5-.3-.6-.2-.6-.3-.5-.3-.5-.4-.6-.3-.7-.4-.5-.4-.6-.4-.6-.3-.5-.5-.5-.4-.5.3.2zm.4-1 .2.2-.3-.2zm-4.5-6.7h1v.7l.2.3v1l.2.3v.5l.2.3v.5l.2.2v.4h.2v.3l.2.2v.2h.2v.3h.2l.2.2v.2h.2l.2.2h.2l.2.2h.2l.2.2h.2l.3.2-.4 1h-.2l-.2-.2-.3-.2h-.2l-.2-.2h-.2l-.2-.3-.2-.2h-.2v-.2l-.3-.2-.2-.2-.2-.2v-.2l-.2-.2v-.2l-.2-.3v-.2l-.2-.2v-.3l-.2-.2v-.9l-.2-.3v-.6l-.2-.3V219l-.2-.5zm-1.7 1.8h-1v-1l.2-.2.2-.2v-.4h.2l.2-.3h.2l.2-.2.3-.2h.2l.2-.2h1.2v.2h.2v.3l.2.2v.2h-1.6v.2h-.2v.2h-.2v.2h-.2v.3l-.2.2v.8zm.3 5.6-1 .2v-.6l-.2-.2V224h-.2v-3.6h1v4.2l.2.2v.7l.2.2zm-1 2-.5.8v-1l.2-.2v-.2h.2v-.4h.2v-.4l-.2-.2v-.2l1-.3v1.8h-.2v.4h-.2v.2h-.2v.2l-.2.2h-.2v-.7zm-.5.8-.8-.3.7-.6v.8zm5 8.6h1-1v-.5l.2-.5v-2l-.2-.3v-.7l-.2-.3v-.6l-.2-.3v-.2l-.2-.3-.2-.3v-.2l-.3-.3v-.2l-.3-.2-.2-.2-.3-.2-.2-.2-.3-.2h-.3l-.3-.3-.2-.2-.3-.2-.4-.2h-.3l-.4-.2.4-1 .4.2.5.2.4.2.3.2.3.2.4.2.3.2.3.2.3.2v.2l.4.3.2.3.3.3v.2l.3.3v.4l.3.3v.3l.3.3v.7l.2.3v.7l.2.4v2.9h-1zm1 0h-1l.5-.5.6.4zm-1 0v-.4h.5l-.4.4z"
          />
          <path
            fill="#edb92e"
            d="M368.8 218.5c-.4 1-.6 1.8-.7 3.4 0 1 .5 2 1.2 3 .8 1 1.8 2 3 2.6.8.5 1.6 1.7 2.3 3 .7 1.4 1.2 3 1.2 4 0 3.5.8 6.7 2.4 7.3 1.2.3 1.6.2 2.4 0-.2-.6 0-1.5-.7-2.4a8 8 0 0 1-1.4-3.7c0-1-.5-1.6-.2-3.3.4-1.2 1-1.6 1-2.7-.3-2-2-6-4.3-6s-3.4-.3-4.6-3.4c-.3-1-1-1.6-1.2-2z"
          />
          <path
            fill="#21231e"
            d="m368.6 222-1-.2v-1.2l.2-.2v-1h.2v-.7h.2v-.4l1 .3v.4h-.2v1l-.2.2v1.5l-.2.3zm1 2.8-.8.6v-.2h-.2v-.2l-.2-.2v-.2h-.2v-.4h-.2v-.5l-.2-.2v-.7l-.2-.2v-.7h1v1.1h.2v.7h.2v.4h.2v.4h.2v.2h.2v.2zm3 2.4-.6 1v-.2h-.4v-.2h-.2v-.2h-.2l-.2-.2h-.2v-.2h-.3v-.2h-.2l-.2-.2v-.2l-.2-.2h-.2v-.2h-.2v-.2h-.2v-.2l-.2-.2-.2-.2.8-.6.2.2.2.2v.2h.2l.2.2v.2h.2l.2.2.2.2h.2v.2h.2v.2h.3l.2.2.2.2h.2v.2zm2.4 3.2-1 .4v-.2l-.2-.2v-.2l-.2-.2v-.2h-.2v-.2l-.2-.2v-.2h-.2v-.2l-.2-.2-.2-.2v-.2h-.2l-.2-.2h-.2l.5-1h.2v.2h.2v.2h.2v.2l.2.2.2.2v.2h.2v.2h.2v.2l.2.2v.2l.2.2v.2h.2v.3h.2v.3h.2zm1.2 4.2h-1v-.8l-.2-.2v-.8h-.2v-.5h-.2v-.4h-.2v-.5h-.2v-.2l-.2-.2 1-.4v.4h.2v.4h.2v.5l.2.2v.3h.2v.6h.2v1h.2v.7zm-1 0zm3 6.8-.3 1h-.3l-.2-.2-.3-.3v-.2l-.3-.2h-.2l-.2-.3v-.2h-.2v-.3l-.2-.2v-.3l-.2-.2v-.3l-.2-.2v-.5l-.2-.3v-.8l-.2-.3V236l-.2-.3v-1.5h1v2.1l.2.3v1.4l.2.2v.8l.2.2v.2l.2.2v.4l.2.2v.2l.2.2.2.2v.2h.2v.2h.2l.2.2zm1.7.8 1-.3-.5.5h-.4v.2h-1.4l-.2-.2h-.4l.3-1h.7v.2h1.2v-.2l-.3.7zm1-.3v.4h-.5l.4-.5zm-1.7-2 .8-.7h.2v.4h.2v.4h.2v.8l.2.2v1l-1 .4V241l-.2-.2v-.8h-.2v-.2zm-1.5-4h1v.8h.2v.8l.2.2v.2l.2.2v.2h.2v.5h.2v.2h.2v.2l-.7.7v-.2l-.2-.2v-.4h-.2v-.5h-.2v-.2l-.2-.3v-.2l-.2-.2v-.2l-.2-.3v-.4l-.2-.2v-.5zm1 0zm-1.2-3.4 1 .2v3l.2.2-1 .2v-.8l-.2-.2v-2.6zm1-2.5h1v.7h-.2v.6l-.2.2v.2l-.2.2v.2h-.2v.6h-.2v.2l-1-.2v-.4h.2v-.4l.2-.2v-.2l.2-.2v-.2l.2-.2v-.9zm-4-5.5v-1h1.1l.3.2h.2l.2.2h.3l.2.2.2.2v.2l.3.2v.2l.3.2.2.3v.2l.3.3.2.2.2.3v.2l.2.3v.2l.2.3v.3l.2.2v.3l.2.2v.5l.2.3v.8h-1v-1l-.2-.2v-.4l-.2-.3-.2-.4v-.2l-.2-.2v-.3l-.3-.3v-.2l-.2-.2v-.3l-.2-.2-.3-.3-.2-.2-.3-.3-.3-.2-.3-.2h-.8zm-5-3.7 1-.4v.3l.2.3v.2l.2.2v.2l.2.2v.2l.2.2.2.2v.2h.2v.2h.2v.2h.4v.2h.7v.2h1.7v1H373l-.3-.2h-.4v-.2h-.3v-.2h-.3v-.3h-.3v-.2l-.2-.2-.2-.3-.2-.2v-.2l-.2-.2-.2-.4-.2-.2v-.3l-.2-.2zm-.4-2-1-.5h1.2v.4h.2v.2h.2v.2h.2v.4h.2v.2l.2.2v.2l.2.2-1 .4v-.2l-.2-.2v-.2l-.2-.2v-.2h-.2v-.2l-.2-.2v-.2h-.2v-.2h-.2v-.2h.8zm-1-.5.5-1 .5 1h-1zm.6.2.4.2-.4-.2zm-.5-.2.4-1 .5 1h-1z"
          />
          <path
            fill="#edb92e"
            d="m360 227 2-1a6 6 0 0 1 4-.2c5.5 1.7 8 11.6 1.8 14-1.2.2-2.3-1-3.4-3.3a20.5 20.5 0 0 0-4-6.8c-1-1-1-2-.4-2.6z"
          />
          <path
            fill="#21231e"
            d="m362 225.5.3 1h-.4v.2h-.4v.2h-.8v.2h-.2l-.2.2-.7-.7.2-.2v-.2h.4v-.2h.8v-.2h.4v-.2h.4zm4-.2-.2 1h-.5v-.2h-2.1v.2h-.7l-.2.2-.5-1h.4l.3-.2h.8v-.2h1.6l.2.2h.4zm2 15-.2-1h-.2l.5-.2h.6l.4-.4.4-.3.3-.4.3-.5.2-.4.2-.3.2-.5v-.5l.2-.5V232l-.3-.4-.2-.5-.2-.5v-.5l-.4-.4-.2-.5-.4-.3-.3-.5-.4-.3-.3-.5-.4-.3-.5-.3-.3-.4-.5-.2h-.4l.2-1h.6l.5.3.7.3.4.4.6.3.5.4.5.6.3.4.4.5.3.5.3.6.3.5.3.7.2.6v.6l.3.5v3.4l-.2.5-.2.6-.3.6-.2.5-.3.5-.4.5-.4.4-.4.3-.6.3-.6.3zm0 0zm-4-3.6 1-.4v.4l.2.2.2.3.2.3v.2h.2v.5h.2v.2l.2.2.2.2h.2v.2h.2l.2.2h.8v1.2h-.8v-.2h-.5l-.2-.2-.2-.2-.2-.2-.2-.2v-.2h-.2l-.2-.2v-.2h-.2v-.3l-.2-.2v-.2h-.2v-.2l-.2-.2v-.2l-.2-.3-.3-.3zm0 0zm-4-6.6.7-.6.2.2v.2h.2l.2.3v.3h.2l.2.3v.2l.2.2h.2v.3l.3.2v.2l.2.2.2.2v.4l.2.2.2.3v.3l.2.2.2.3v.3l.2.3v.3l.3.3.2.4v.3l.3.3v.3l-1 .4v-.6l-.2-.2v-.3l-.3-.2v-.3l-.2-.2v-.5l-.3-.3v-.2l-.2-.2v-.3l-.3-.2-.2-.3v-.2l-.3-.2v-.2h-.2v-.3h-.3v-.3l-.2-.2-.3-.3v-.2l-.2-.2h-.2v-.2l-.2-.2zm0 0zm0-3.4v1l.3-.2v.2h-.2v.8h.2v.4l.2.2.2.2v.2l-.7.7h-.2v-.2l-.2-.2-.2-.2v-.3h-.2V227h.2v-.2h.2l.4-.2zm-.4 0h.4-.4zm.4 1v-1l.3 1h-.3zm.3 0h-.2.3z"
          />
          <path
            fill="#edb92e"
            d="M362.8 227.7c5.4-2 9.4 8.3 4.3 10.2-2.6 1-2.8-2.4-3.4-4.3-.7-2.5-6-4-.8-6z"
          />
          <path
            fill="#21231e"
            d="m367.3 238.4-.4-1h.3l.3-.3.3-.2.2-.3.2-.3.2-.3v-.5l.2-.4v-2.7l-.2-.4-.2-.5-.2-.4-.2-.4-.3-.4-.3-.4-.2-.3-.4-.4-.3-.2-.3-.2-.4-.2-.4-.2h-.4l-.3-.2h-1.3l-.4.2-.4-1h.6l.5-.2h1.6l.5.3.5.2.4.2.4.4.5.4.4.4.3.4.3.5.2.4.3.6.3.5.2.6.2.6v.5l.2.5v1.6l-.2.5v.5l-.3.5-.2.4-.3.5-.4.3-.4.4-.4.2-.5.2zM363 234l1-.4.2.2v.6l.2.2v.8l.2.2v.4l.2.2v.2l.2.3.2.3v.2h.2v.2h.2l.2.2h1.2l.3.8h-.3l-.3.2h-1.2l-.2-.2h-.2v-.2l-.3-.2-.3-.3v-.2l-.2-.2v-.2h-.2v-.3l-.2-.2v-.4h-.2v-.8l-.2-.2v-.8l-.2-.2v-.2zm-.4-6.7.4 1h-.5l-.3.3h-.4l-.2.3h-.2l-.2.2v.2h-.2v.4h.2v.3l.2.2v.2h.3v.3l.3.2h.2l.2.2.2.2.2.2.2.2.2.3.2.3.2.2v.3l.3.2v.6l-1 .3v-.7l-.2-.2h-.2v-.3l-.3-.2h-.2v-.3l-.3-.2-.2-.2-.2-.2-.2-.2v-.2l-.2-.2h-.2v-.3l-.3-.3v-.2l-.2-.2v-.8l.2-.3v-.3l.3-.2.2-.2.3-.3.3-.2h.4l.4-.3.6-.2z"
          />
          <path
            fill="#0c4076"
            d="M363.4 229.3c2.6-1 6.2 5 3 6.5-2.3 1-4-.3-4.8-2-.7-2 0-3.8 1.7-4.5z"
          />
          <path
            fill="#21231e"
            d="m366.5 236.3-.4-1h.3l.2-.2h.2v-.2l.2-.2v-2l-.2-.3v-.3h-.2v-.4l-.3-.3-.2-.2-.3-.4-.2-.2-.2-.2h-.2v-.2l-.3-.2h-1.1l-.3-1h1.5l.4.3.3.2.2.3.2.2.3.2.2.2.2.3v.3l.3.3.2.4.2.3v.4l.2.4v2.6l-.2.3-.2.4-.2.3-.2.2h-.4l-.3.3zm-5.4-2.5 1-.3.2.3.2.3v.2l.2.3.2.2.2.2h.3v.2h.2l.3.2h.4v.2h1.3l.3-.2.5 1h-.7l-.2.2h-1.9l-.2-.2h-.2v-.2h-.3l-.2-.2-.3-.2-.3-.3-.3-.3h-.2v-.3l-.2-.3-.2-.3v-.2l-.2-.2v-.2zm2.2-5 .3 1h-.3l-.2.2-.2.2-.2.2-.2.2-.2.2v.2h-.2v.7l-.2.2v1.1l.2.2v.3l-1 .3v-.7l-.2-.3v-1.5l.2-.2v-.3l.2-.2.2-.3.2-.3v-.2l.3-.2v-.2h.3l.2-.2.3-.2h.2l.2-.2zm.2.5-.2-.5.2.5z"
          />
          <path
            fill="#fff"
            d="M400 179.7c3.6 0 6.4 2.8 6.4 6.4 0 3.6-2.8 6.5-6.3 6.5s-6.3-3-6.3-6.4 3-6.3 6.4-6.3z"
          />
          <path
            fill="#21231e"
            d="M407 186h-1c0-2-1.4-4.3-3.3-5.2a5.8 5.8 0 0 0-2.6-.6v-1c2.4 0 4.7 1.2 6 3.2a7 7 0 0 1 1 3.7zm-7 7v-1a6 6 0 0 0 5.3-3.3 6 6 0 0 0 .6-2.6h1c0 2.4-1.3 4.7-3.3 6a6.8 6.8 0 0 1-3.6 1zm-6.8-7h1a6 6 0 0 0 3.3 5.4 5.8 5.8 0 0 0 2.6.6v1a6.8 6.8 0 0 1-5.7-3.3 7 7 0 0 1-1-3.6zm7-7v1.2a5.9 5.9 0 0 0-5.3 3.2 6 6 0 0 0-.8 2.7h-1a7 7 0 0 1 3.3-5.8 6.8 6.8 0 0 1 3.6-1z"
          />
          <path
            fill="#fff"
            d="M395.4 169c3.5 0 6.4 3 6.4 6.4 0 3.6-3 6.4-6.4 6.4s-6.3-2.8-6.3-6.4c0-3.5 3-6.4 6.4-6.4z"
          />
          <path
            fill="#21231e"
            d="M402.3 175.4h-1c0-2.2-1.3-4.3-3.2-5.3a5.8 5.8 0 0 0-2.6-.5v-1c2.4 0 4.6 1.3 6 3.2a7 7 0 0 1 1 3.7zm-7 7v-1c2.3 0 4.4-1.4 5.4-3.3a6 6 0 0 0 .6-2.6h1c0 2.4-1.2 4.7-3.2 6a6.8 6.8 0 0 1-3.6 1zm-6.7-7h1a6 6 0 0 0 3.2 5.3c.8.4 1.7.6 2.6.6v1a6.8 6.8 0 0 1-5.8-3.2 7 7 0 0 1-1-3.6zm6.8-7v1c-2 0-4.2 1.4-5.2 3.3a6 6 0 0 0-.6 2.7h-1c0-2.3 1.2-4.6 3.2-6a7 7 0 0 1 3.6-1z"
          />
          <path
            fill="#fff"
            d="M410.7 131.5c3.4 0 6 2.7 6 6s-2.6 6.3-6 6.3-6.2-2.7-6.2-6.2a6 6 0 0 1 6.2-6z"
          />
          <path
            fill="#21231e"
            d="M417.3 137.7h-1c0-2.2-1.2-4.2-3-5a5.6 5.6 0 0 0-2.6-.7v-1a7 7 0 0 1 5.6 3 6.7 6.7 0 0 1 1 3.7zm-6.6 6.6v-1c2 0 4-1.2 5-3 .4-1 .6-1.8.6-2.6h1c0 2.2-1.2 4.5-3 5.6a6.6 6.6 0 0 1-3.6 1zm-6.7-6.7h1c0 2.2 1.3 4.2 3.2 5a5.6 5.6 0 0 0 2.5.7v1a6.6 6.6 0 0 1-5.6-3 6.7 6.7 0 0 1-1-3.6zm6.7-6.6v1c-2 0-4 1.2-5 3a5.7 5.7 0 0 0-.7 2.6h-1a7 7 0 0 1 3-5.6 6.6 6.6 0 0 1 3.7-1z"
          />
          <path
            fill="#fff"
            d="M400.4 136.2c3.5 0 6.3 3 6.3 6.4 0 3.5-2.8 6.4-6.3 6.4s-6.4-3-6.4-6.4c0-3.5 2.8-6.4 6.4-6.4z"
          />
          <path
            fill="#21231e"
            d="M407.2 142.6h-1a6 6 0 0 0-3.3-5.3 5.8 5.8 0 0 0-2.6-.6v-1c2.3 0 4.6 1.2 5.8 3.2a7 7 0 0 1 1 3.6zm-6.8 7v-1c2 0 4.2-1.4 5.2-3.3a6 6 0 0 0 .6-2.7h1c0 2.3-1.2 4.7-3.2 6a6.8 6.8 0 0 1-3.6 1zm-7-7h1c0 2.2 1.4 4.3 3.3 5.3a5.8 5.8 0 0 0 2.7.5v1a7.2 7.2 0 0 1-6-3.2 7 7 0 0 1-1-3.7zm7-7v1a6.2 6.2 0 0 0-5.3 3.3 6 6 0 0 0-.5 2.6h-1c0-2.4 1.2-4.7 3.2-6a6.8 6.8 0 0 1 3.7-1z"
          />
          <path
            fill="#fff"
            d="M392.8 145.3c3.5 0 6.3 2.8 6.3 6.4 0 3.5-2.7 6.4-6.2 6.4s-6.4-2.8-6.4-6.3c0-3.6 3-6.4 6.4-6.4z"
          />
          <path
            fill="#21231e"
            d="M399.6 151.7h-1a6 6 0 0 0-3.2-5.3 5.8 5.8 0 0 0-2.6-.6v-1c2.3 0 4.6 1.2 5.8 3.2a7 7 0 0 1 1 3.7zm-6.8 7v-1c2 0 4.2-1.4 5.2-3.4a6 6 0 0 0 .6-2.6h1c0 2.3-1.2 4.6-3.2 6a6.8 6.8 0 0 1-3.6 1zm-7-7h1c0 2 1.4 4.3 3.3 5.2a5.8 5.8 0 0 0 2.8.6v1a7.4 7.4 0 0 1-6-3.3 7 7 0 0 1-1-3.6zm7-7v1a6 6 0 0 0-5.3 3.3 6 6 0 0 0-.6 2.7h-1c0-2.4 1-4.7 3.2-6a7 7 0 0 1 3.6-1z"
          />
          <path
            fill="#fff"
            d="M391.5 156.7c3.6 0 6.4 2.8 6.4 6.4s-3 6.5-6.5 6.5-6.3-3-6.3-6.4 2.8-6.3 6.3-6.3z"
          />
          <path
            fill="#21231e"
            d="M398.4 163h-1c0-2-1.3-4.2-3.2-5.2a5.8 5.8 0 0 0-2.7-.6v-1c2.4 0 4.7 1.2 6 3.2a7 7 0 0 1 1 3.7zm-7 7v-1a6 6 0 0 0 5.4-3.3 6 6 0 0 0 .6-2.6h1c0 2.5-1.3 5-3.4 6a6.8 6.8 0 0 1-3.5 1zm-6.7-7h1c0 2.3 1.3 4.4 3.2 5.4.7.4 1.6.6 2.5.6v1a7 7 0 0 1-5.8-3.2 7 7 0 0 1-1-3.7zm6.8-6.8v1c-2 0-4.2 1.3-5.2 3.2a6 6 0 0 0-.6 2.7h-1c0-2.3 1.2-4.6 3.2-5.8a7 7 0 0 1 3.5-1z"
          />
          <path
            fill="#edb92e"
            d="M474.4 198c-2.7-5-5.6-8.2-8.6-9.6 4.2-13.2 5.2-30.2 2.7-51-.2-3.3-1-4.6-2.2-4.6-1 0-1.7 1.6-1.8 5.2.8 11.6 1.7 21.6 1.2 30.2-.5 7.6-2.3 14-4.2 21.2-.3 1 .4 1.7 3.8 3.7 2.6 1.5 4.2 3.3 4.7 5 .7-.2 1.2 0 1.5 0 2.5.8 3.6.6 3 0z"
          />
          <path
            fill="#21231e"
            d="m465.3 188.2 1 .3-.3-.6h.3l.3.2.3.2.2.2h.3l.3.3h.3l.4.4.2.2.3.2.2.3.3.3.3.3.3.3.3.2.3.3.3.3.2.3.2.5.3.3.3.4.2.3.3.4.3.3.2.4.3.4.3.5.2.5.3.4.3.4.3.5.3.5-1 .5-.3-.5-.2-.4-.3-.5-.2-.5-.3-.4-.3-.3-.2-.4-.3-.4-.3-.5-.3-.4-.2-.2-.3-.4-.4-.3-.2-.2-.3-.3v-.3l-.4-.3-.3-.4-.2-.3-.2-.2-.3-.2-.2-.2-.3-.2-.3-.2-.2-.2-.3-.2-.3-.2-.3-.2h-.3l-.3-.3-.4-.2-.3-.6zm.3.6h-.4v-.6l.4.6zm2.4-51.5h1l.2 2 .2 1.8.2 2 .2 2v1.8l.2 1.8v1.8l.2 1.8v15l-.3 1.5-.2 1.5v1.5l-.3 1.5-.2 1.5-.2 1.4-.2 1.5-.2 1.3-.3 1.4-.3 1.3-.3 1.4-.3 1.3-.4 1.3-.3 1.3-.4 1.2-1-.3.4-1.2.4-1.3.4-1.3.3-1.3.3-1.2.3-1.3.3-1.4.2-1.3.3-1.4.3-1.5.2-1.4V172l.3-1.6V169l.2-1.7v-1.6l.2-1.6v-13.6l-.2-1.8v-2l-.2-1.7-.2-2-.2-1.8-.2-2-.2-2zm0 0zm-1.7-4v-1h.6v.2h.3v.2h.2l.2.3h.2v.5h.2v.3l.2.2v.3l.2.2v.4l.2.4v.9l.2.3v.4h-1v-.9l-.2-.2v-.6l-.2-.2v-.5h-.2v-.5h-.2v-.2l-.2-.2h-.2v-.2h-.4zM465 138h-1v-1.7l.2-.3v-1l.2-.3v-.7h.2v-.3l.2-.3v-.3h.2l.2-.2.3-.2.2-.2h.5v1h-.2v.2h-.2v.2l-.2.2v.3l-.2.3v.6l-.2.2v1.6l-.2.4v.7zm-1 0zm2.2 30.2h-1V154l-.2-1v-2.8l-.2-1v-2l-.2-1v-1l-.2-1v-2l-.2-1V139l-.2-1 1-.2v1l.2 1.2v2l.2 1v2.2l.2 1v2l.2 1v2l.2 1v2.8l.2 1v12zm-4.3 21.3-1-.3.2-.6v-.7l.3-.8.2-.6.2-.7v-.7l.2-.7.2-.6.2-.7v-.6l.3-.6v-.6l.2-.6.2-.7v-.5l.2-.6.2-.8v-.6l.2-.7.2-.7v-.7l.2-.6v-.7l.2-.6v-.7l.2-.7v-.7l.2-.6V169l.2-.8h1v1.5l-.2.7v1.5l-.2.6v.7l-.2.8v.7l-.2.6v.8l-.2.7-.2.6v.8l-.2.6-.2.7v.7l-.3.7v.6l-.3.7v.6l-.3.6-.2.6v.6l-.3.7-.2.5-.2.7v.6l-.3.7-.2.7-.2.6v.7zm3.6 3-.5 1-.2-.2h-.3l-.3-.3-.3-.2h-.4l-.2-.3h-.2l-.3-.3h-.3v-.2l-.3-.2h-.2l-.2-.2-.2-.3h-.2v-.2h-.2l-.2-.2v-.2l-.2-.2v-1l1 .2v.5h.2v.2l.2.2h.2v.2h.2l.2.2.3.3h.2l.2.2.2.2h.2l.2.3h.3l.3.3.3.2h.3zm0 0zm4.2 5.2.4 1-.7-.4v-.2l-.2-.2v-.3l-.2-.2v-.3l-.2-.3-.3-.3-.2-.3-.3-.2-.3-.3v-.2h-.3v-.2h-.3v-.2l-.3-.2h-.2v-.3h-.3l-.2-.2h-.3l-.2-.2-.2-.2h-.2l.6-1 .2.2h.2l.3.3.2.2.2.2h.2v.3h.4l.2.3.3.3.3.3.2.2.3.3v.3l.3.2h.2v.3l.3.2v.2h.2v.3l.2.2v.2l.2.3v.3l.2.2v.2l-.6-.3zm.4 1h-.5l-.2-.4.7.3zm1.4-1.2-.3 1h-1l-.4-.8h.2l.2-.2h1.4zm3.3.5h-1l.7-.4.2.2v.8l-.2.2h-.2v.2h-1.8l-.2-.2h-.3l-.2-.2h-.5l.3-1h.7l.2.2h1v.2h.7v.4l.7-.4zm-1 0v-1l.7.6-.8.4zm0 0h1l-1 .3v-.3z"
          />
          <path
            fill="#edb92e"
            d="M458.4 214.6c1.6-1 2-.8 2.4-1.4.6-.8.6-2.2.4-3.5-.8-5.3 2.4-4.6 6-2.2 1.7 1 3.5 4 5 5.3s2.8 1.5 3.2 2v9.2c-.4.6-1.7.7-3.2 2-1.5 1.5-3.3 4.2-5 5.4-3.6 2.3-6.8 3-6-2.2.2-1.3.2-2.7-.4-3.5-.5-.7-.8-.4-2.4-1.4a7 7 0 0 1-2.3-2.2c-.4-.8 0-1.7 0-2.6 0-1-.4-1.8 0-2.6.6-.8 1.4-1.6 2.4-2.2z"
          />
          <path
            fill="#21231e"
            d="m460.4 213 .8.5-.2.2-.2.2h-.4v.2h-.4l-.2.2h-.2l-.2.2h-.2v.2h-.5v.2l-.7-1h.6v-.2h.2l.2-.2h.2l.2-.2h.4v-.2h.4v-.2h.2zm.3-3.2 1-.2v2.9l-.2.3v.2h-.2v.2l-1-.5v-.2h.2v-.4h.2v-2.6zm6.7-2.8-.6 1-.3-.3-.3-.2-.3-.2-.4-.2h-.3l-.3-.2h-.3l-.3-.2h-.3v-.2h-.4l-.2-.2h-1.1v.2h-.2v.2l-.2.2v.6l-.2.3v2l-1 .2v-3l.2-.4v-.3l.3-.2.3-.2.2-.2h.2l.2-.2h.2l.2-.2h1.5v.2h.5l.3.2h.3l.4.3h.3l.3.2.4.2.3.2.3.2.4.2zm5 5.4-.6.7-.3-.2-.3-.3-.3-.3-.2-.2-.2-.2-.3-.3-.2-.2v-.2h-.2v-.3l-.3-.2-.3-.3-.2-.2v-.2l-.3-.2v-.2h-.3l-.2-.3-.3-.2-.2-.2h-.2l-.2-.2v-.2h-.3v-.2h-.2l.6-1 .2.2.3.2v.2h.3v.3h.3l.2.2.2.2v.2l.3.2h.2v.3l.3.3.2.2v.2l.3.2.3.3h.2v.3l.3.2.2.2.2.2.3.3v.2h.3v.3h.3v.3h.2zm3.5 2.4h-1.2v.3h-.2l-.2-.2h-.2v-.2h-.4l-.2-.2h-.2v-.2h-.3v-.2h-.3v-.2l-.3-.2-.3-.2-.2-.3.7-.6h.2v.2h.2v.2h.2v.2h.2v.2h.3l.2.2.2.2h.2l.2.2h.2l.2.2h.2v.2h.4v.2l.2.2v.2zm-.2-.2v.2-.2zm0 4.8h-1v-4.5l1-.2v4.5zm-1 0zm0 0h1-1zm0 0zm1 5-1-.7v.3-4.4h1v4.7zm0-.4v.2-.2zm-3.3 2.5-.7-.8h.2v-.2l.3-.2.3-.2h.3v-.2h.3v-.2h.2l.2-.2h.2v-.2h.4v-.2h.4v-.2l1 .5-.2.2-.2.2h-.2v.2h-.4l-.2.2h-.2v.2h-.4v.2h-.3v.2h-.2l-.2.2-.2.2v.2h-.3zm-5 5.3-.7-.8h.2v-.2l.3-.2.3-.2.2-.2.3-.3.2-.2.2-.2.2-.2v-.2h.3v-.3l.2-.3.2-.2v-.2l.3-.2.3-.2v-.2l.3-.2.2-.2v-.2h.3v-.3l.3-.2.2-.2h.2v-.3h.3v-.3l.8.8-.2.2-.2.2-.2.2v.2h-.3v.3l-.3.2-.3.2-.2.2-.2.2-.2.2v.2l-.3.2v.2l-.2.2h-.2v.3h-.3l-.2.3v.2h-.2l-.2.3-.2.2-.3.3-.3.3-.3.2zm-6.8-2.7 1 .3v2.6l.2.2v.2h.2v.2h1.7v-.2h.4l.3-.2h.3l.3-.3.3-.3h.3l.2-.3.3-.2.3-.2.6.8-.4.2-.3.3-.3.2h-.4l-.3.3-.3.2h-.3l-.2.3h-.4l-.3.2h-.4l-.3.2h-.9l-.3-.2h-.3l-.2-.3-.2-.2-.2-.2v-.3l-.2-.2v-.7l-.2-.3V229zm-.3-3 .8-.6v.2h.2v.4h.2v.6l.2.2v2.4l-1-.2v-2.5h-.2v-.4h-.2v-.2zm-2.3-1.3.7-.8h.2l.2.2h.2l.2.2h.2l.2.2h.4v.2h.2v.2h.2l.2.2.2.2-.8.6-.2-.2h-.2v-.2h-.4l-.2-.2h-.4v-.2h-.2l-.2-.2h-.2v-.2h-.3zm.7-.8.5.2-.5-.3zm-3-1.7.8-.5.2.2v.2h.2v.4h.2v.2h.2v.2h.2v.2h.2l.2.2.2.2h.2v.2h.2l-.5 1v-.2h-.2l-.2-.2-.2-.2h-.2v-.2h-.2v-.2h-.2v-.2h-.2v-.2h-.2v-.2h-.2v-.2l-.2-.2-.2-.2v-.2zm-.3-3h1v2.4l-.7.5v-.2h-.2v-.4l-.2-.2v-2.1zm.3-2.8.8.6v.4l-.2.2v1.8h-1V217h.2v-.4h.2zm2.4-2.4.7 1h-.2v.2h-.2l-.2.2-.2.2-.2.2-.2.2-.2.2-.2.2v.2h-.2v.2h-.2v.2l-1-.5h.2v-.2l.2-.2.2-.2v-.2h.2l.2-.2v-.2h.2v-.2h.2l.2-.2h.2v-.2l.2-.2h.2v-.2h.2zm.7 1 .5-.3-.5.3z"
          />
          <path
            fill="#21231e"
            d="M475.5 220.2v1c-4 .4-7 2-9.7 4.3 1.8-2.7 5.7-4.7 9.7-5.3zm0-1.6v-.8c-4-.5-7-2-9.7-4.4 1.8 2.7 5.7 4.6 9.7 5.2z"
          />
          <path
            fill="#edb92e"
            d="M461.2 207.3c1 .4 2.3 1 3.4 2 1.6 1.5.6 4-1.5 6.6-.6.7-1 2-1 3.5 0 1.3.5 2.7 1 3.5 2.2 2.5 3.2 5 1.6 6.6-1 1-2.3 1.5-3.4 2v-2.4c.2-1.3.2-2.7-.4-3.5-.5-.7-.8-.4-2.4-1.4a7 7 0 0 1-2.3-2.2c-.4-.8 0-1.7 0-2.6 0-1-.4-1.8 0-2.6.6-.8 1.4-1.6 2.4-2.2 1.6-1 2-.8 2.4-1.4.6-.8.6-2.2.4-3.5v-2.4z"
          />
          <path
            fill="#21231e"
            d="m465 209-.8.6-.2-.2-.2-.2h-.2v-.2h-.2l-.2-.2h-.2v-.2h-.4v-.2h-.5v-.2h-.2l-.2-.2h-.2l-.2-.2h-.2l.4-1h.2l.2.2h.2l.2.2h.3l.2.2h.2v.2h.3l.2.2h.2v.2h.3v.2h.2l.2.2.2.2.2.2zm-1.5 7.2-.8-.6.2-.3v-.2h.2l.2-.3.2-.3v-.2l.3-.2v-.5l.2-.2v-.2h.2v-.3l.2-.2v-.4h.2v-1.6l-.2-.3-.2-.2-.2-.2.7-.7.3.3v.2l.2.2v.2h.2v.5l.2.2v1l-.2.2v.4l-.2.2v.5l-.2.3v.3l-.3.2v.5l-.3.2v.3l-.3.2-.2.3v.2l-.3.2-.3.3-.2.2zm-1 3.3h-1v-.7l.2-.2v-1.2h.2v-1h.2v-.4l.2-.2v-.2h.2v-.2l1 .6h-.2v.4h-.2v.2l-.2.2v.9h-.2v1.4h-.2v.5zm1 3.2-.8.6v-.2h-.2v-.2h-.2v-.4h-.2v-1.1l-.2-.3V220h-.2v-.5h1v1.1l.2.2v.4l.2.2v.4l.2.2v.2h.2v.2zm1.5 7.3-.8-.8h.2v-.2h.2v-.3l.2-.2v-1.9l-.2-.2v-.2l-.2-.2v-.2l-.2-.3v-.2l-.2-.2-.3-.3v-.3l-.3-.2-.2-.2v-.2l-.3-.3-.3-.2.8-.6.2.2h.2v.4l.2.2.2.3h.2v.3l.3.3v.5l.3.3v.3l.2.2v.5l.2.2v.5l.2.2v.7l-.2.4v.4l-.2.2v.2l-.2.2v.2l-.3.2v.2zm-4.3 1.7 1-.2-.7-.4h.7v-.2h.4l.2-.2h.2l.2-.2h.2v-.2h.4v-.2h.2l.2-.2.2-.2h.2v-.2h.2v-.2l.8.8h-.2v.2h-.2v.2h-.2l-.2.2-.2.2h-.2l-.2.2h-.2v.2h-.4v.2h-.4v.2h-.5v.2h-.2l-.2.2h-.2l-.7-.3zm.7.4-.6.3v-.6l.6.4zm-.7-3 1 .3v2l-1 .3v-2.4zm-.3-3 .8-.6v.2h.2v.4h.2v.6l.2.2v2.4l-1-.2v-2.4h-.2v-.4h-.2v-.2zm-2.3-1.3.7-.8h.2l.2.2h.2l.2.2h.2l.2.2h.4v.2h.2l.2.2.2.2.2.2-.8.6-.2-.2h-.2v-.2h-.4l-.2-.2h-.4v-.2h-.2l-.2-.2h-.2v-.2h-.3zm0 0-.3-.2.4.2zm-2.3-2.4.8-.5.2.2v.2h.2v.4h.2v.2h.2v.2h.2v.2h.2l.2.2h.2v.2h.2v.2h.2l-.5 1v-.2h-.2l-.2-.2-.2-.2h-.2v-.2h-.2v-.2h-.2v-.2h-.2v-.2h-.2v-.2h-.2v-.2l-.2-.2-.2-.2v-.2zm0 0 .3.5-.3-.5zm-.3-3h1v2.4l-.7.5v-.2h-.2v-.4l-.2-.2v-2.2zm.3-2.8.8.6v.4l-.2.2v1.8h-1V217h.2v-.4h.2zm2.4-2.4.7 1h-.2v.2h-.2l-.2.2-.2.2-.2.2-.2.2-.2.2-.2.2v.2h-.2v.2h-.2v.2l-1-.5h.2v-.2l.2-.2.2-.2v-.2h.2l.2-.2v-.2h.2v-.2h.2l.2-.2h.2v-.2h.2v-.2h.2v-.2h.2zm2.4-1 .8.5-.2.2-.2.2h-.4v.2h-.4l-.2.2h-.2l-.2.2h-.2v.2h-.5v.2l-.7-1h.6v-.2h.2l.2-.2h.2l.2-.2h.4v-.2h.4v-.2h.2zm.3-3.2 1-.2v2.9l-.2.2v.2h-.2v.2l-1-.5v-.2h.2v-.4h.2V210zm.5-2v-1l.5.6v2.1l-1 .2V207l.5.6zm0-1h.6v.6l-.6-.6zm0 0v1h-.2l.2-1zM361 226.3l.7-.3c-1.6-2.2-2-4.2-1.3-6.3-1.3 1.6-1 4.2.6 6.6z"
          />
          <path
            fill="#edb92e"
            d="M410.7 200c1.4 1.6 1.2 2 2 2.5 1 .6 2 .4 3.3 0 5-2 5 2 3.5 6.4-.7 2-2.8 4.3-3.7 6.2-1 1.7-.7 3-1 3.5a95.4 95.4 0 0 1-4 .6l-4 .5c-.6-.3-1-1.6-2.6-3s-4.4-3-6-4.6c-3-3.5-4.6-6.8.2-6.7 1.2 0 2.4-.2 3-1 .4-.7 0-1 .4-3 .3-1.2.8-2.3 1.4-3 .6-.8 1.5-.6 2.3-.7 1-.2 1.6-.7 2.5-.2 1 .4 2 1.2 2.7 2.3z"
          />
          <path
            fill="#21231e"
            d="m413 202-.6 1-.2-.2-.2-.2-.2-.2v-.2h-.2v-.2l-.2-.2v-.2l-.2-.2v-.2h-.2v-.2l-.2-.2-.2-.3-.3-.3.8-.6.3.2.2.3v.2h.2v.4h.2v.4h.2v.2l.2.2v.2h.2v.2l.2.2zm-.6 1zm3.5-1 .2 1h-.5l-.2.2h-.8v.2h-1.2l-.3-.2h-.2l-.2-.2h-.2l.5-1v.2h.8v.2h1l.2-.2h.4l.2-.2h.3zm4 7-1-.3v-.4l.2-.4v-.5l.2-.4v-.3l.2-.3v-.7l.2-.4v-1.7l-.2-.2v-.4h-.2l-.2-.3h-.2l-.3-.2H417l-.4.3h-.4l-.3-.8.3-.2h.5l.4-.2h1.8l.3.2h.3l.2.3.2.4v.2l.3.3.2.4v3.3l-.2.4v.4l-.2.4v.4l-.2.4v.4zm-3.7 6.4-1-.5v-.2l.2-.2.2-.2v-.2l.2-.2v-.4l.2-.2.2-.2v-.2l.2-.2.2-.2.2-.3.2-.2.2-.3.2-.2v-.2l.2-.2h.2v-.3l.2-.2v-.2l.2-.2.2-.3v-.2l.2-.2v-.2l.2-.3 1 .3v.2l-.2.3v.2l-.2.2-.2.3v.2l-.2.2v.3l-.3.2-.2.2v.2l-.2.2-.2.2v.2l-.2.2-.2.2v.2l-.3.2v.2l-.2.2-.2.2v.2l-.2.2v.4h-.3v.3l-.2.2-.2.2v.2zm-1.5 3.8-.2-1-.3.2v-.4h.2v-1l.2-.2v-.4l.2-.3v-.4l.2-.3v-.2h.2l1 .4-.2.2-.2.3v.3h-.2v.7h-.2v.9l-.2.2v.4l-.2.2v.2l-.4.2zm.3 0h-.2.3zm-4.3.6v-1h1.1v-.2h1.2v-.2h1.1l.3-.2.2 1h-.4l-.3.2h-.9l-.2.2h-1.3v.2h-.7zm0 0zm0 0v-1 .5-.5 1-.5.5zm0-1zm-4 1.5.4-1h-.2 1.3l.3-.2h1.9l.2-.2.2 1h-.8v.2h-1.4v.2h-2zm.2 0h-.3.2zm-3-3 .5-1 .2.3.3.3h.2l.2.3.2.2.2.3.2.2v.2h.2v.2h.2v.2l.2.2v.2h.2v.2h.2v.2l-.4 1v-.2h-.2l-.2-.2-.2-.2v-.2h-.2v-.2l-.2-.2v-.2h-.2v-.2l-.2-.2-.2-.2-.2-.2-.2-.3v-.2h-.2v-.2h-.3v-.3zm-6-4.8.7-.6.2.2.3.3.3.3h.2v.3l.3.2h.3l.2.3h.2l.2.3.3.3.2.2.2.2h.2v.2l.3.2h.2l.2.3.2.2.3.3h.2l.2.3.3.2.2.2h.2v.2l-.5.8h-.3v-.2l-.3-.2h-.2v-.2l-.3-.2h-.3l-.2-.2-.2-.2h-.2v-.2l-.3-.2h-.2l-.2-.3h-.2v-.2h-.3l-.2-.2-.2-.2h-.2v-.3h-.3l-.2-.3-.2-.2h-.2v-.3h-.3v-.3l-.3-.2h-.2v-.3l-.3-.2zm.4-7.5v1H397l-.2.2h-.4l-.2.2v.2h-.2v1.5l.2.3v.3l.2.2.2.3.2.4.2.3.2.3.2.3.2.3.3.3v.2l.4.3.3.4-.8.5-.4-.3-.3-.3-.2-.4-.2-.4-.2-.3-.3-.4-.2-.3v-.4l-.3-.4v-.3l-.3-.3v-.3l-.3-.3V206l.2-.2.2-.2.2-.2.3-.2h.2l.3-.2h.7l.4-.2h.8zm2.5-.8.8.5-.2.2-.2.2h-.2v.2h-.2l-.2.2h-.2l-.2.2h-.5l-.2.2h-1.1v-1h1.4l.2-.2h.2l.2-.2h.2v-.2h.2v-.2zm0 0zm.4-2.8 1 .2v.4h-.2v2h-.2v.4l-.2.2-1-.4h.2v-1.4l.2-.3v-.8l.2-.2zm1.4-3.2.8.6-.2.2v.2h-.2v.4h-.2v.4h-.2v.4l-.2.2v.4l-.2.2v.4l-1-.2v-.7l.2-.2v-.4l.2-.2v-.4h.2v-.4h.2v-.4h.2v-.2h.2v-.4h.2zm.8.6.5-.7-.4.8zm1.8-1.5.2 1H404v.2h-.4v.2h-.2l-.8-.5.2-.2.2-.2h.2v-.2h.4l.2-.2h1.4zm.2 1h-.7.6zm2.7-1.2-.5 1H406l-.2.2h-.4l-.2-1h.8l.2-.2h2.1zm3 3h-1v.2-.2h-.2v-.2l-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2h-.2v-.2h-.2l-.2-.2-.2-.2h-.2l-.2-.2.5-1v.2h.2l.2.2h.2v.2h.2v.2h.2l.2.2.2.2.2.2h.2v.2h.2v.2l.2.2.2.2.2.2v.2l.3.3zm-.2-.4h.2v.3-.4zm-.8.3h1l-1 .2v-.3zm0 .2v-.3.2z"
          />
          <path
            fill="#21231e"
            d="M410 219.4h-.7c-1.4-3.8-3.5-7-6.3-9.5 2.8 1.4 5.5 5.3 7 9.4zm1.4-.2c.3 0 .5 0 .8-.2-.5-4 0-7.5 1.5-11-2 2.5-2.8 7-2.3 11.2z"
          />
          <path
            fill="#edb92e"
            d="M418.3 202c-.2 1.4-.4 3-1 4.3-1 2-3.8 1.3-6.6-.7-.8-.6-2.2-.8-3.4-.6-1.3.3-2.4.8-3 1.7-1.5 2.6-3.4 4-5.2 2.6-1-1-2-2.3-2.7-3.5.5-.2 1.2-.3 2-.3 1.3 0 2.5-.2 3-1 .5-.7 0-1 .6-3 0-1.2.6-2.3 1.2-3 .6-.8 1.5-.6 2.3-.7 1-.2 1.6-.7 2.5-.2 1 .4 2 1.2 2.7 2.3 1.4 1.6 1.2 2 2 2.5 1 .6 2.2.4 3.3 0 1-.4 1.7-.6 2.3-.5z"
          />
          <path
            fill="#21231e"
            d="m417.7 206.5-1-.4.2-.2v-.5l.2-.2v-.4l.2-.2v-.9l.2-.2v-1.2h.2v-.4h1v1.1l-.2.3v1h-.2v.7h-.2v.7h-.2v.3l-.2.3v.2zm-7.2-.5.5-.8.3.2h.2l.3.3h.2l.3.3h.2l.3.2.2.2h.2l.3.2h.4v.2h.7l.2.2h1v-.2h.2l.2-.2.2-.3.2-.2 1 .5-.2.2-.2.3-.3.3v.2h-.2l-.2.2h-.2l-.3.2h-2l-.2-.2h-.2l-.3-.2h-.2l-.2-.2h-.2l-.3-.2-.2-.2h-.2l-.3-.3-.2-.2h-.3l-.3-.3-.2-.2zm-3-.4-.3-1h1.1v-.2h1.3v.2h.6v.2h.4v.2h.2l.2.2-.5.8h-.2v-.2h-.4v-.2h-2.4zm-2.7 1.3-.8-.6v-.2h.2v-.2h.2v-.2l.2-.2h.2v-.2h.2l.2-.2h.2l.2-.2h.3v-.2h.8l.2-.2h.5l.2 1h-.7v.2h-.4v.2h-.4l-.2.2h-.2v.2h-.2v.2h-.2v.2h-.2zm-6 2.7.6-.8h.3v.2h.5l.2.2h.5l.3-.2h.3v-.2h.3v-.2h.2v-.3h.3v-.3h.3v-.3l.3-.3.2-.2.2-.2v-.2h.3v-.4l.3-.2.8.5v.2l-.3.2v.3l-.3.2h-.2v.3l-.3.2-.2.2-.2.2-.3.3h-.2l-.2.3h-.2v.3h-.3l-.3.2h-.4l-.3.2h-1.2l-.2-.2h-.2l-.2-.2-.2-.2h-.2zm-2.7-4.4.5 1 .3-.8v.3h.2v.2l.2.2v.2h.2v.2l.2.2v.2h.2v.2l.2.2.2.2.2.2v.2h.2v.2h.2v.2h.2v.2h.2v.2h.2l-.6 1-.2-.2-.2-.2-.2-.2v-.2h-.2v-.2h-.2v-.2h-.2v-.2h-.2v-.3h-.2v-.2h-.2v-.2h-.2v-.3h-.2v-.2h-.2v-.4h-.2v-.2h-.2V205zm0 .8-.4-.4.5-.3v.8zm2.4-1v1H397v.2h-.4l-.5-1h1.2v-.2h1.2zm2.5-.8.8.5-.2.2-.2.2h-.2v.2h-.2l-.2.2h-.2l-.2.2h-.7l-.2.2h-1.2v-1h1.4l.2-.2h.4v-.2h.2v-.2h.2v-.2zm0 0zm.4-2.8 1 .3v.3l-.2.3v1.7h-.2v.7h-.2l-1-.4h.2v-1.4h.2v-1.3l.2-.2zm1.4-3.2.8.6-.2.2v.2h-.2v.4h-.2v.4h-.2v.4l-.2.2v.7h-.2v.5l-1-.3v-.7l.2-.2v-.4l.2-.2v-.4h.2v-.4h.2v-.4h.2v-.2h.2v-.4h.2zm0 0 .4-.5-.4.5zm2.6-1 .2 1h-.6v.2h-1v.2h-.2l-.2.2-.8-.6.2-.2.2-.2h.2v-.2h.4l.2-.2h1.4zm0 0h.6-.6zm3 0-.6.8H406v.2h-.5l-.2-1h.8v-.2h2.1zm-.6.8.3.2-.2-.2zm3.3 1.6-.6.6-.2-.2h-.2v-.2l-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2h-.2v-.2h-.2l-.2-.2h-.2v-.2h-.2l-.2-.2.5-1v.2h.2l.2.2h.2v.2h.2v.2h.2l.2.2.2.2.2.2h.2v.2h.2v.2l.2.2.2.2.2.2v.2zm2 2.5-.6 1-.2-.2-.2-.2-.2-.2v-.2h-.2v-.2l-.2-.2v-.2l-.2-.2v-.2h-.2v-.2l-.2-.2-.2-.3-.2-.3.7-.6.3.2.2.3v.2h.2v.2l.2.2v.4h.2v.2l.2.2v.2h.2v.2l.2.2zm-.6 1-.2-.2h.2zm3.5-1 .2 1h-.5l-.2.2h-.8v.2h-1.3l-.2-.2h-.2l-.2-.2h-.2l.5-1v.2h.6l.2.2h1.1l.2-.2h.4l.2-.2h.2zm2.8 0h-1l.5.5h-1l-.2.2h-.4l-.2.2h-.2l-.3-1 .2-.2h.8v-.2h1.5l.5.4zm-.5-.5h.6l-.2.5-.5-.5z"
          />
          <path
            fill="#edb92e"
            d="M391.8 221.2c.7-1 1-.8 1.2-1.3.2-1-.3-2-1-3.2-2.2-4.6.3-4.2 3.6-2.4 1 .4 2 1.2 3 2 1 1 1.8 1.8 2.7 2.4 1.6 1.2 2.7 1.2 3 1.7 1 2 1.5 3.5 1.8 4.2.3.7 1 2.3 1.6 4.2 0 .4-1 .5-1.8 2-.7 1.2-1.2 3.5-2 4.7-1.4 1.6-2.5 2.6-3.4 2.4-1 0-1.6-1.3-1.8-4.2a4 4 0 0 0-1.5-3c-.5-.6-.6-.4-2-1.2a9.3 9.3 0 0 1-2.4-2c-.6-.6-.7-1.3-1-2-.3-1-.8-1.6-.7-2.4a3.8 3.8 0 0 1 .8-2z"
          />
          <path
            fill="#21231e"
            d="m392.5 219.7 1 .3v.2l-.2.2v.2h-.2v.2h-.2v.2h-.2l-.2.2v.2h-.2l-.8-.5v-.2l.2-.2.2-.2.2-.2h.2v-.2h.2v-.2zm1 .3zm-1.8-3 1-.5v.4l.2.2v.4l.2.3v.2l.2.2v2l-1-.3v-1.2l-.2-.2v-.4h-.2v-.4h-.2v-.4zm4.2-3-.6.8h-.3l-.2-.3h-.3l-.3-.3h-.3l-.3-.2h-.3l-.2-.2h-.5l-.2-.2h-.6v1.5l.3.4.2.3.2.4.2.5-1 .5v-.4l-.3-.4-.2-.4v-.7l-.2-.2v-1.5l.2-.2h.2l.2-.2h.2l.2-.2h1.2l.2.2h.6l.3.3.3.2h.3l.3.2.2.2.4.2h.3zm2.8 2-.7 1v-.4h-.2l-.2-.2h-.2v-.2h-.2v-.2h-.2v-.2h-.2l-.2-.2h-.2v-.2h-.2l-.2-.2-.2-.2h-.2l-.2-.2.5-1v.2h.2v.2h.2l.2.2h.2v.2h.2l.2.2h.2v.2h.2v.2h.2l.2.2.2.2.2.2h.2v.2h.2zm2.8 2.4-.6.8h-.2v-.2h-.2v-.2h-.2l-.2-.2h-.2v-.2h-.2v-.2h-.2v-.2h-.2l-.2-.2-.2-.2-.2-.2h-.2v-.2h-.2v-.2h-.2l.6-1v.2h.2l.2.2v.2h.2l.2.2.2.2h.2v.2h.2v.2h.2v.2h.2l.2.2.2.2h.2v.2h.2l.2.2zm3.3 2-1 .3v.2-.2h-.2v-.2h-.4l-.2-.2h-.2l-.2-.2h-.3l-.2-.2h-.3v-.2h-.3v-.2h-.3v-.2h-.3v-.2l.6-.8.2.2h.2v.2h.3l.2.2h.2l.2.2h.2v.2h.4l.2.2h.4v.2h.2l.2.2h.2v.3zm-.2-.3v.2zm1.7 4.5-1 .4v-.7l-.2-.2v-.4l-.2-.2v-.5h-.2v-.4l-.2-.3v-.3h-.2v-.5h-.2v-.5h-.2v-.3l1-.4v.4l.2.3v.2l.2.3v.2l.2.3v.3l.2.3v.4h.2v.4l.2.2v.4h.2v.4zm0 0zm0 0-1 .4h.3l.3.2-.5-.5.6.5-.5-.5.6.5-.5-.5.2.4-.2-.3v.2l1-.5v.2-.4.4l-.4-.5.6.5-.5-.5.6.5-.5-.5h.4v.3zm0-.2v.2-.2zm1.6 4.7-1-.2v.3-.5l-.2-.3v-.2l-.2-.3v-.3l-.2-.3v-.2l-.2-.2v-.4l-.2-.2v-.2l-.2-.2v-.4l-.2-.2 1-.5v.4h.2v.5h.2v.5l.2.2v.3l.2.3v.5l.2.2v.3l.2.2v.2l.2.2v.6zm0-.3v.3-.3zm-1.7 2.4-1-.4.2-.2v-.2h.2v-.2l.2-.2v-.2h.2v-.2h.2l.2-.2h.2v-.2h.2v-.2l1 .2v.4h-.2v.2h-.2v.2h-.2l-.2.2-.2.2-.2.2-.2.2-.2.2v.2zm-2.2 5-.7-.7.2-.3v-.2h.2v-.3l.2-.2v-.4l.2-.2v-.5h.2v-.4h.2v-.5h.2v-.2l.2-.3v-.2l.2-.3v-.2l.2-.2 1 .5-.2.2v.3h-.2v.4h-.2v.5l-.2.2v.3l-.2.2v.3l-.2.2v.3l-.2.2v.3l-.2.2v.3h-.2v.3h-.2v.3l-.2.2v.2zm-3.7 2.7.2-1h.4v-.2h.2l.2-.2h.2v-.2h.2l.2-.2.2-.2.2-.2.2-.2.2-.3.2-.2v-.2h.2v-.3l1 .7h-.2v.3h-.3v.3h-.2v.3h-.4v.4h-.2v.2h-.2l-.2.2-.2.2-.2.2h-.3v.2h-.4v.2h-1zm-2.2-5h1v.3l.2.2v1.1h.2v.5l.2.2v.3l.2.2v.2h.2v.2h.2v.2h.2v1h-.8v-.2h-.2l-.2-.2-.2-.2v-.3h-.2v-.2l-.2-.2v-.3l-.2-.3v-.4h-.2v-1l-.2-.2v-1zm-1.2-2.6.7-.6.2.2v.2h.2v.2l.2.2v.2h.2v.3l.2.2v.2h.2v.7h.2v.6l-1 .2v-1h-.2v-.4l-.2-.2v-.2h-.2v-.2h-.2v-.4h-.2v-.2h-.2zm-2-1 .4-.8h.3v.2h.4v.2h.4v.2h.4v.2h.4v.2h.2v.2l-.6.7h-.2l-.2-.2h-.4v-.2h-.4l-.2-.2h-.2l-.2-.2h-.3zm-2.5-2 .7-.6.2.2.2.2.2.2.2.2h.2v.2h.2v.2h.2l.2.2h.2v.2h.2l.2.2-.5 1v-.2h-.2v-.2h-.4v-.2l-.2-.2h-.2l-.2-.2-.2-.2-.2-.2-.2-.2h-.2v-.2h-.2v-.2zm-1.2-2.3 1-.4v.2h.2v.4h.2v.5h.2v.4h.2v.2l.2.2-.7.7h-.2v-.4h-.2v-.4h-.2v-.4l-.2-.2v-.8h-.2v-.2zm-.6-2.5h1v.8h.2v.4l.2.2v.2l.2.2v.2l-1 .5v-1h-.2v-.4h-.2v-.6h-.2v-.8zm1 0v.2zm.4-1.5v-1l.3.8v.4h-.2v.2h-.2v.8h-.2v.2h-1v-.9l.2-.2v-.4l.2-.2v-.2h.2v-.4h.2v-.2h.2l.4.7zm0-1h1l-.7.8-.2-.8zm0 0v1l-.4-.8.4-.3zm0 1h-1l.6-.8.4.7z"
          />
          <path
            fill="#21231e"
            d="m406.5 226 .2 1c-1.4.4-2.6 1-3.6 1.8s-1.7 2-2.3 3.2c.2-1.4 1-2.7 2-3.7s2.3-1.8 3.8-2.2zm-.6-1.6-.5-1c-1.6 0-3.2-.4-4.7-1-1.5-.7-3-1.6-4.4-2.8 1 1.3 2.6 2.4 4.3 3.3 1.6.7 3.5 1.3 5.2 1.5z"
          />
          <path
            fill="#edb92e"
            d="M391.4 213.8c1 .4 1.6.8 2.8 1.8.8.7 1.3 1.7 1.5 3 0 1 0 2.5-.3 3.8-.2.8 0 2.2.5 3.6.4 1.4 1 2.8 2 3.5 2.3 2.5 4 5 3.4 6.7a4 4 0 0 1-1.5 1.8c-.4-.6-1-1.2-1.4-2.2a8 8 0 0 0-1.5-3.5c-.5-.6-.7-1.3-2-2.2-1-.5-2-.3-2.6-1-1.2-1.6-3-5.5-1.3-7.2 1.7-1.7 2.3-2.7 1-5.6-.5-1-.5-1.8-.6-2.4z"
          />
          <path
            fill="#21231e"
            d="m394.5 215.2-.7.8-.2-.2-.2-.2-.2-.2h-.2v-.2h-.2v-.2h-.4v-.2h-.2l-.2-.2h-.2l-.2-.2h-.4l.3-1h.4v.2h.4v.2h.4v.2h.4v.2h.2v.2h.2l.2.2.2.2h.2v.2h.2v.2zm1.7 3.2-1 .2v-.6h-.2v-.7h-.2v-.4l-.2-.2v-.2h-.2v-.2h-.2v-.2h-.2v-.2h-.2l.7-.8h.2v.2l.2.2v.2h.2v.2l.2.2v.2h.2v.4l.2.2v.4h.2v.8h.2v.2zm-.3 4h-1V221h.2v-2.4l1-.2v3.3l-.2.2v.5zm-1 0v-.3.3zm1.4 3.5-1 .2v-.5l-.2-.3v-.4l-.2-.3v-.8h-.2v-1.4h1v1.9h.2v.7h.2v.7h.2v.3zm1.8 3.2-.7.7v-.2l-.2-.2h-.2v-.4h-.2v-.2l-.2-.3v-.2h-.2v-.2l-.2-.3v-.2h-.2v-.5l-.2-.2-.2-.3v-.4h-.2l1-.4v.2l.2.2v.2l.2.3.2.2v.3l.2.2v.2h.2v.2h.2v.4h.2v.2h.2v.2h.2v.2zm3.6 7.2-1-.4.2-.2v-1.3l-.2-.2v-.4l-.2-.2v-.2l-.2-.2-.2-.2v-.2l-.2-.2-.2-.2v-.2l-.3-.2-.2-.3v-.3l-.3-.2-.2-.2-.2-.3-.2-.2-.2-.2-.2-.2-.3-.3h-.2l.7-.8.3.2.2.2.2.3.3.4.3.2.2.2v.3l.3.3.3.2.2.3v.2l.3.2.2.3v.2l.2.2.2.2v.2l.2.2v.2l.2.3v.7l.2.2v1.2l-.2.2zm-2.4 1.8 1-.4-.8-.2.2-.2h.2v-.2h.2v-.2h.2v-.2l.2-.2v-.2l.2-.2v-.2l1 .4v.2l-.2.2v.2l-.2.2v.2h-.2v.2h-.2v.2h-.2v.2h-.2v.2h-.2l-.2.2-.8-.2zm.8.2-.5.3-.3-.5.8.2zm-2-2.5 1-.3v.4h.2v.4h.2v.2h.2v.2l.2.2v.2h.2v.4l-.8.4v-.2h-.2v-.2l-.2-.2v-.2h-.2v-.2h-.2v-.4l-.2-.2v-.2l-.2-.2v-.3zm-1.5-3.3.8-.7v.2h.2v.2l.2.2v.2l.2.2v.2h.2v.5h.2v.4l.2.2v.4l.2.3v.7l-.8.2v-.4h-.2v-.5l-.2-.2v-.5h-.2v-.2l-.2-.2v-.2l-.2-.2v-.2h-.2v-.2l-.2-.2zm0 0zm-2-2.2.4-1 .3.2.2.2h.2l.2.2.2.2.2.2v.2h.2v.2h.2v.2l.2.2.2.2v.2h.2v.2l-.7.7-.2-.2v-.2h-.2v-.2h-.2v-.4h-.2v-.2h-.2v-.2h-.2v-.2h-.2v-.2h-.4v-.2h-.2zm-2.7-1.3.8-.6h.2v.2h.2v.2h.9l.2.2h.4l.2.2h.2l.2.2-.4 1v-.2h-.4l-.2-.2h-.9v-.2h-.4l-.2-.2h-.2l-.2-.2-.2-.2-.2-.2zm-1.2-7.8.7.7v.3h-.2v.3h-.2v2.2l.2.3v.5l.2.2v.2l.2.3v.2l.2.2v.2l.2.2v.2l.3.2v.2h.2v.3l.2.2-.7.7-.2-.3-.2-.3v-.2l-.2-.2v-.2h-.3v-.3l-.2-.3-.2-.4v-.2l-.2-.3v-.2l-.2-.2v-.6l-.2-.3v-2.1l.2-.3v-.2h.2l.2-.3.2-.3zm.7-5 1-.5v.5l.2.2v.3l.2.2v.7h.2v1.7l-.2.2v.2l-.2.2v.2h-.2v.3h-.2v.2l-.2.2-.3.3h-.2l-.2.3-.8-.6.2-.3h.2l.2-.3.2-.3.2-.2v-.3l.2-.2v-.2l.2-.3v-.7l-.2-.2v-.5l-.2-.2-.2-.4v-.2zm0-3v1l.4-.7v1.4h.2v1.1h.2l-1 .6v-.9h-.2v-.7l-.2-.2v-1l.4-.7zm-.6.5-.3-.7h.7l-.5.6zm.4.3v-1 1zm0-1z"
          />
          <path
            fill="#edb92e"
            d="M434 226.2c-1.2 1-1.5 1-2 1.6-.3.8 0 2 .3 3.3 1.5 5-1.4 4.4-5 2.6-1.6-1-3.6-3.2-5.2-4.4-1.5-1-2.6-1-3-1.6a118.7 118.7 0 0 1-1-4.3c0-.7-.5-2.4-1-4.4.4-.7 1.4-1 2.5-2.5 1-1.7 2.2-4.7 3.6-6 3-3.2 6-4.5 6 1.3 0 1.4.3 3 1 3.6.6.6 1 .3 2.5 1 1 .6 2 1.3 2.6 2 .7 1 .5 2 .7 2.8 0 1 .5 1.7.2 2.6-.5 1-1 1.7-2 2.4z"
          />
          <path
            fill="#21231e"
            d="m432.6 228-1-.5h.2v-.4h.4v-.2h.4v-.2h.2l.2-.2h.2v-.2h.2v-.2h.2v-.2l.8.8-.2.2h-.2v.2h-.2l-.2.2-.2.2h-.2v.2h-.4v.2h-.2v.2zm-1-.5zm1 3.4-.8.3v-.2l-.2-.2v-.7h-.2v-2.3h.2v-.2l1 .4v.2h-.2v2.1h.2v.7zm-5.4 3 .5-.8h.3l.3.3h.3l.3.3h.2l.3.2h.2l.3.2h.7l.2.2h.7v-.2h.2v-.4l.2-.3v-1.1l-.2-.3v-.3l-.2-.4 1-.4v.4l.2.4v.8l.2.3v1.1l-.2.4v.2l-.3.2-.2.2h-.2l-.2.2-.4.2h-1.2l-.3-.2h-.6l-.3-.3-.2-.2h-.3l-.3-.2-.4-.2-.3-.2h-.3zm-5.4-4.3.6-1 .2.2.3.2.2.3h.2v.3h.3v.3l.3.2.2.2h.2v.3h.3l.2.3.2.3.2.2.3.3h.2v.2l.2.2h.2l.2.2v.2h.3v.2h.2l.2.2.3.2-.5 1-.2-.2h-.2v-.2l-.3-.2h-.2l-.2-.2-.2-.3h-.2l-.2-.2h-.2v-.3h-.3l-.3-.3h-.2v-.3l-.3-.3h-.2l-.2-.3-.3-.3h-.2v-.2h-.3l-.2-.3-.3-.3-.3-.2-.3-.2h-.2zm.6-1zm-4-1 1-.2v-.2h.2v.2h.4l.2.2h.4v.2h.7l.2.2h.2l.2.2.3.2h.2l.2.2-.6 1v-.2h-.3v-.2h-.2l-.2-.2-.2-.2h-.3l-.2-.2h-.2v-.2h-.4l-.2-.2h-.2l-.2-.2h-.2v-.2h-.2v-.3zm.2.3v-.3.3zm-.6-4.2v-1l.5.4v.4l.2.2v1h.2v1.3h.2v1h.2v.5l-1 .2v-.7l-.2-.3v-.7l-.2-.3v-.7h-.2v-.8l-.2-.2v-.6l.4.4zm0-1h.5v.4l-.5-.4zm-.5.6 1-.2v-.2l-.5-.2v1h-.3l-.2-.5zm1-.2zm-1.8-4.5 1 .4v-.2 1.1h.2v1.1l.2.3v.8l.2.2v.9l-1 .2V222l-.2-.2v-.8l-.2-.3v-.7h-.2v-.8l-.2-.2v-.3zm0 .3v-.3.3zm2.4-2.8 1 .5-.2.2-.2.2-.2.3-.2.2-.2.2h-.2v.2h-.2l-.2.2h-.2v.2h-.2v.2h-.2v.2h-.2l-1-.3h.2v-.4h.2v-.2h.4v-.2h.2l.2-.2.2-.2.2-.2h.2v-.2l.2-.2.2-.2v-.2h.2v-.2zm3.7-6.2.8.7h-.2v.3h-.2v.3l-.3.3v.2l-.2.2v.2h-.2v.3l-.2.3v.4l-.3.2v.2l-.2.2v.2l-.2.2v.2l-.2.2v.3l-.2.3v.2l-.2.2v.2h-.2v.2l-.2.2-.2.2-1-.4.2-.2.2-.3v-.2h.2v-.3l.2-.2v-.2l.2-.2v-.2l.2-.2v-.2l.2-.2v-.3l.2-.2v-.2h.2l.2-.3v-.2l.2-.2v-.3l.2-.2v-.2l.3-.2v-.2l.2-.2.2-.3v-.2l.2-.2h.2v-.3zm6.8 1.8h-1v-1.4l-.2-.4v-.6l-.2-.2v-.4l-.2-.2h-.3v-.2h-1.2l-.3.2-.3.2h-.2l-.3.3-.2.3-.3.2-.2.2-.3.2-.2.2-.3.2-.2.3-.8-.7.3-.3.3-.3.3-.2.2-.3.3-.3.4-.2.3-.2.2-.2h.2l.3-.3h.2l.3-.2h.3l.2-.2h1.2l.3.2.3.3.2.2.2.2.2.3v.6l.2.5v.4l.2.3v1.5zm1 3.3-.8.8-.2-.2v-.2h-.2v-.2l-.2-.2v-.6l-.2-.2v-.7l-.2-.2V212h1v2h.2v.3l.2.2v.2h.2v.2l.2.2zm0 0zm2.2 1-.4 1-.3-.2h-.2l-.3-.2h-.4v-.2h-.9v-.2h-.4v-.2h-.2v-.2l.6-.7v.2h.4v.2h.8l.2.2h.4l.2.2h.2l.2.2zm2.8 2.2-.8.6h-.2v-.2l-.2-.2h-.2v-.4h-.2l-.2-.2h-.2v-.2h-.2v-.2h-.4v-.2h-.2l-.2-.2.3-1 .3.2h.2l.2.2.2.2h.2v.2h.2l.2.2h.2v.2h.2v.2h.2v.2h.2v.2h.2v.2h.2v.2zm-.8.6.4.5-.3-.5zm1.5 2.3-1 .2V220l-.2-.2v-.8h-.2v-.4l.7-.6v.2l.2.2v.2l.2.2v2.2h.2v.2zm0 3-.8-.4v-2.1l-.2-.2v-.4h1v1l.2.2v1.8zm-1.8 2.6-.7-.8h.2v-.2l.2-.2v-.2h.2v-.2h.2v-.2h.2v-.2l.2-.2v-.2l.2-.2v-.2h.2v-.2l1 .4-.2.2v.2l-.2.2v.2h-.2v.4h-.2v.2h-.2v.2l-.2.2-.2.2v.2h-.2l-.2.2-.2.2zm-.7-.8z"
          />
          <path
            fill="#21231e"
            d="m418 222.6-.2-1a14 14 0 0 0 7.8-5.3c-1.2 3-4.3 5.3-7.7 6.3zm.2 1.5c0 .4.2.7.3 1 3.4 0 6.4 1 9.2 3-2-2.3-5.8-3.8-9.5-4z"
          />
          <path
            fill="#edb92e"
            d="M432.7 233.3a11 11 0 0 1-3.4-1.5c-1.6-1.3-1.2-3.8.3-6.4.4-.8.5-2.2.2-3.5a6.3 6.3 0 0 0-1.4-3.5c-2.4-2.3-3.8-4.8-2.6-6.6.8-1.3 2-2 2.8-2.7.3.6.4 1.5.4 2.5 0 1.4.3 3 1 3.6.6.6 1 .3 2.5 1 1 .7 2 1.3 2.6 2 .7 1 .6 2 .7 2.8 0 1 .5 1.7.2 2.6-.5 1-1 1.7-2 2.4-1.2 1-1.5 1-2 1.6-.3.8 0 2 .3 3.3.3 1 .4 1.7.4 2.3z"
          />
          <path
            fill="#21231e"
            d="m429 232.2.6-.8h.2v.2h.2l.2.2h.2l.2.2h.2l.2.2h.4v.2h.4l.2.2h.4l.2.2h.2l-.3 1h-.4v-.2h-.4l-.2-.2h-.3v-.2h-.4l-.2-.2h-.2l-.2-.2h-.2v-.2h-.2l-.3-.2h-.2v-.2zm0-7 1 .5v.2h-.2l-.2.4v.2l-.2.2v.2l-.2.3v.4l-.2.2v.5l-.2.2v1.5l.2.3v.2h.2v.3l.2.2.2.2-.6.8-.2-.2-.3-.3v-.2h-.2v-.3l-.2-.2v-.4l-.2-.3V228h.2v-.7l.2-.3.2-.3v-.3l.2-.2v-.3l.3-.3v-.5zm.3-3.3 1-.2v.8h.2v1.9l-.2.2v.7h-.2v.2l-1-.4h.2v-.6h.2V222zm-1.3-3.2.7-.7v.2h.2v.4h.2v.2l.2.2v.2l.2.2v.2l.2.2v.5h.2v.7l.2.2v.8h-1v-1.2l-.2-.2v-.4h-.2v-.4h-.2v-.2l-.2-.2v-.2h-.2v-.2l-.2-.2zm0 0zm-2.7-7.2 1 .6h-.2v.7l-.2.2v.7l.2.2v.4l.2.2v.2l.2.2v.2l.2.2v.2l.3.2v.2l.2.2.2.2v.2l.3.3.2.3v.2l.3.2.2.2h.2l-.7.8-.2-.2-.2-.2-.3-.2-.2-.2v-.3l-.2-.2-.2-.2-.2-.2-.2-.2v-.2l-.3-.2-.2-.3h-.2v-.3l-.2-.2v-.3l-.2-.2v-.2l-.2-.3v-.4l-.2-.2v-1l.2-.3v-.2l.2-.2v-.2zm3.8-2.5-.8.4.7.3h-.2l-.2.2h-.2l-.2.2h-.2v.2h-.2v.2h-.2l-.2.2-.2.2-.2.2-.2.2-.2.2v.2h-.2v.2l-.2.2-1-.6h.2v-.2l.2-.2.2-.2v-.2h.2v-.2h.2v-.2h.2v-.2h.2l.2-.2.2-.2h.2v-.2h.2l.2-.2.2-.2h.2v-.2h1.1zm-.6 0 .5-.5v.6h-.6zm1 2.8h-1v-2.1h-.2v-.4l1-.3v1h.2v2zm1 3.3-.7.8-.2-.2v-.2h-.2v-.2l-.2-.2v-.7l-.2-.2v-.7l-.2-.2V212h1v1.7h.2v.6l.2.2v.2h.2v.2l.2.2zm2.3 1-.4 1-.3-.2h-.2l-.3-.2h-.4v-.2h-.9v-.2h-.4v-.2h-.2v-.2l.6-.7v.2h.4v.2h.8l.2.2h.4l.2.2h.2l.2.2zm2.8 2.2-.8.6h-.2v-.2l-.2-.2h-.2v-.4h-.2l-.2-.2h-.2v-.2h-.2v-.2h-.4v-.2h-.2l-.2-.2.3-1 .3.2h.2l.2.2.2.2h.2v.2h.2l.2.2h.2v.2h.2v.2h.2v.2h.2v.2h.2v.2h.2v.2zm-.8.6.4.5-.3-.5zm1.5 2.3-1 .2V220h-.2v-.8h-.2v-.4l.7-.6v.2l.2.2v.2l.2.2v2h.2v.2zm0 3-.8-.4v-2.2l-.2-.2v-.4h1v1l.2.2v1.8zm-1.8 2.6-.7-.8h.2v-.2l.2-.2v-.2h.2v-.2h.2v-.2h.2v-.2l.2-.2v-.2h.2v-.4h.2v-.2l1 .4-.2.2v.2l-.2.2v.2l-.2.2v.2h-.2v.2h-.2v.2l-.2.2-.2.2v.2h-.2l-.2.2-.2.2zm-.7-.8zm-1 2.2-1-.5v-.2h.2v-.2h.2v-.2h.4v-.2h.2l.2-.2h.2v-.2h.2v-.2h.2v-.2l.8.8-.2.2h-.2v.2h-.2l-.2.2-.2.2h-.2l-.2.2h-.2v.2h-.2v.2zm-1-.5zm1 3.4-1 .3v-.7h-.2v-3h.2l1 .4h-.2v2.6h.2v.2zm-1 .3zm.8 2.5.3-1-.6.5v-1h-.2v-.9l-.2-.2 1-.5v.9h.2v1h.2v.7l-.7.5zm.7-.5v.7l-.7-.2.7-.5zm-.5 0-.2.5.2-.5zm.5 0v.7l-.7-.2.7-.5z"
          />
          <path
            fill="#edb92e"
            d="M410.6 216.4c4 0 8 3.4 8.4 7.7.6 4.4-2.2 7.7-6 7.8-4 0-7.5-3-8.3-7.3-.7-4 1.8-8 6-8z"
          />
          <path
            fill="#21231e"
            d="m419.5 224-1 .2v-.8l-.2-.4v-.3l-.2-.4v-.3l-.2-.4-.2-.3-.2-.3-.2-.4-.2-.3-.2-.3-.3-.2-.2-.3-.3-.3-.2-.2-.3-.3-.3-.2-.3-.2-.4-.2h-.3l-.3-.3h-.4l-.3-.3h-.3l-.4-.2h-.3l-.3-.2h-1.5v-1h1.9l.4.2h.3l.4.3h.4l.4.3.4.2.3.2.5.2.3.3.3.2.4.2.3.3.3.3.3.3.3.4.2.3.2.4.3.4.2.4.2.4.2.4v.4l.2.4v.4l.2.4v.8zm-6.6 8.3v-1h.9l.2-.2h.6l.3-.2h.4l.2-.2.3-.2h.2l.2-.3h.2l.2-.3.3-.3.3-.2v-.2l.3-.3.2-.2v-.3l.3-.3.2-.4v-.3l.2-.3v-.7l.2-.3V224l1-.2v2.5l-.2.4v.8l-.3.4v.3l-.2.3v.4l-.3.3-.2.3-.3.3h-.2l-.2.4-.3.2-.3.3h-.3l-.3.3-.3.2h-.2l-.3.3h-.4l-.2.2h-.4l-.3.2H413zm-8.7-7.7 1-.2v.7l.2.5v.3l.3.4v.3l.3.3.2.4.2.3.2.3.2.3.2.3.3.3.2.3h.3l.2.3.3.3.2.2.3.2.3.2h.4l.3.3.3.2h.3l.3.2h.7l.3.2h1.2v1h-2l-.3-.2h-.4l-.4-.3h-.4l-.4-.3-.3-.2-.4-.2-.3-.2-.4-.2-.4-.2-.3-.3-.2-.2-.2-.2-.3-.3-.2-.3-.3-.3-.2-.4-.2-.3-.2-.3-.2-.4-.2-.3-.2-.4v-.4l-.2-.4-.2-.4v-.8zm6.2-8.7v1h-1l-.3.2h-.4l-.3.2h-.3l-.3.3h-.2l-.2.3-.3.2-.2.2v.2l-.3.2-.2.2-.2.3-.2.3v.2l-.2.3v.4l-.3.3v.6l-.2.3v.7l-.2.3v.7l.2.4v.8l-1 .2v-3.3l.2-.3v-.3l.2-.4v-.3l.3-.4v-.3l.3-.3.2-.3.2-.3.2-.3h.2l.2-.4.3-.2.3-.2.3-.2.3-.2.3-.2.3-.2h.3l.4-.2h.4l.3-.2h.9z"
          />
          <path
            fill="#edb92e"
            d="M411 218.6c2.8-.2 5.7 2.4 6 5.5.5 3.3-1.5 5.8-4.4 5.8-2.8 0-5.5-2.3-6-5.3s1.3-5.8 4.3-6z"
          />
          <path
            fill="#21231e"
            d="m417.6 224-1 .2v-.6l-.2-.3v-.2l-.2-.3v-.4l-.2-.2v-.2l-.2-.3-.2-.3v-.2l-.3-.2-.2-.2-.2-.3-.2-.2-.2-.2h-.2l-.2-.3h-.2l-.3-.3h-.2l-.2-.2-.4-.2h-.5v-.2h-1.1v-1h1.1l.4.2h.3l.2.2h.2l.3.2h.3l.2.3h.3l.2.2.3.2h.2l.3.3.2.3.2.2.2.2v.2l.3.3h.2v.4l.3.3v.3l.3.2.2.3v.3l.2.3v.8l.2.3zm-5 6.3v-1h1.1l.2-.2h.4l.2-.2h.2v-.2l.3-.2h.3v-.2l.3-.2v-.2h.2l.2-.3v-.2l.2-.2.2-.3v-.7l.2-.2v-1.6h1v2.2l-.2.3v.2l-.2.3v.2l-.3.3-.2.2v.3l-.3.2-.2.2-.2.2-.3.2-.2.2-.2.2h-.2l-.2.2h-.2l-.3.2h-.2l-.2.2h-1.5zm0-1zm-6.5-4.8h1l.2.4.2.4v.2l.2.3.2.3v.3l.3.2.2.2.2.2v.2l.3.2.2.2.3.3.2.2.2.2h.2v.3h.3l.2.2h.7l.2.2h1.1v1H411l-.4-.2h-.2l-.3-.2h-.2l-.2-.3h-.3l-.2-.3-.4-.3-.2-.3-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.3v-.2l-.3-.2-.2-.2-.2-.3v-.3l-.2-.3v-.3l-.2-.2v-.7zm1 0zm4-6.4v1h-.6l-.2.2h-.5l-.2.2h-.2l-.2.2-.2.2h-.2l-.2.3v.2l-.3.2-.2.3v.2h-.2v.3l-.2.2v.2l-.2.2v.7l-.2.2v1.7h-1V222h.2v-.4l.2-.3v-.2l.2-.2v-.2l.3-.3v-.2h.2l.2-.3.2-.2.2-.2.2-.2h.2l.2-.2h.3l.2-.3h.2l.2-.2h.6l.3-.2h.6z"
          />
          <path
            fill="#0c4076"
            d="M411.2 220.7c2 0 3.6 1.5 4 3.5.2 2-1 3.6-3 3.6a4 4 0 0 1-3.7-3.4c-.3-2 1-3.6 2.7-3.7z"
          />
          <path
            fill="#21231e"
            d="m415.6 224-1 .3v-.4l-.2-.2v-.4h-.2v-.3l-.2-.2-.2-.3-.2-.2-.2-.2h-.2l-.2-.2-.2-.2h-.2l-.2-.2h-.6v-.2h-.6v-1h1l.2.2h.2l.3.2h.3v.2h.3l.2.3v.2h.3l.2.2.2.2.2.3.3.2v.4h.2v.3l.2.3v.4l.2.2zm-3.3 4.3v-1h.7l.2-.2h.4v-.2h.2v-.2h.2v-.2h.2v-.2l.2-.2v-.5l.2-.2v-1.1l1-.3v2h-.2v.3l-.2.3-.2.3-.2.2h-.2v.2l-.2.2h-.2v.2h-.3l-.2.2h-.4v.2h-1zm-4.3-3.8 1-.2v.5l.2.3v.4h.2v.2l.2.2.2.2.2.3.2.2.2.2h.3v.2h.4l.3.2h.8v1h-1.3l-.2-.2h-.2l-.3-.2h-.2v-.2h-.2v-.2l-.3-.2-.3-.2v-.2h-.2v-.3h-.3v-.3l-.2-.2v-.2h-.2v-.5l-.2-.2v-.5zm2.7-3.8h1l-.5.5h-.7l-.2.2h-.2v.2h-.2l-.2.2-.2.2-.2.2v.2h-.2v.5h-.2v1.3l-1 .3v-1.8h.2v-.5h.2v-.3h.2v-.3h.3v-.3h.3v-.2h.3v-.2h.3v-.2h1l.2-.2h.4l-.5.5zm1 0v.5h-.5l.5-.5zm0 0h-1l.5-.5.5.5zm-1 0v-.5h.5l-.5.5z"
          />
        </g>
        <path
          fill="#fff"
          d="M482 183c4 0 7 3 7 7s-3 6.7-7 6.7c-3.6 0-6.7-3-6.7-6.8 0-4 3-7 6.8-7z"
        />
        <path
          fill="#21231e"
          d="M489.5 189.8h-1c0-2.3-1.4-4.6-3.5-5.6a6.3 6.3 0 0 0-3-.7v-1c2.6 0 5 1.3 6.4 3.5a7.4 7.4 0 0 1 1 3.8zm-7.4 7.4v-1c2.5 0 4.7-1.4 5.8-3.4a6.4 6.4 0 0 0 .7-3h1c0 2.6-1.5 5.2-3.7 6.5a7.3 7.3 0 0 1-3.7 1zM475 190h1a6.4 6.4 0 0 0 6.3 6.2v1a7.1 7.1 0 0 1-6-3.4 7.4 7.4 0 0 1-1.2-4zm7.3-7.5v1a6.3 6.3 0 0 0-5.5 3.5 6.4 6.4 0 0 0-.7 3h-1c0-2.7 1.4-5 3.5-6.4a7.3 7.3 0 0 1 3.8-1z"
        />
        <path
          fill="#fff"
          d="M482 171c4 0 7 3 7 7a6.8 6.8 0 1 1-13.7-.2c0-3.7 3-6.7 6.8-6.7z"
        />
        <path
          fill="#21231e"
          d="M489.5 178h-1c0-2.4-1.4-4.7-3.6-5.8a6.3 6.3 0 0 0-3-.6v-1c2.6 0 5 1.3 6.4 3.4a7.4 7.4 0 0 1 1 4zm-7.4 7.3v-1c2.5 0 4.7-1.4 5.8-3.4a6.4 6.4 0 0 0 .7-3h1c0 2.5-1.5 5-3.7 6.4a7.3 7.3 0 0 1-3.7 1zM475 178h1a6.4 6.4 0 0 0 6.3 6.3v1a7.1 7.1 0 0 1-6-3.4 7.4 7.4 0 0 1-1.2-4zm7.3-7.4v1a6.3 6.3 0 0 0-5.5 3.5 6.4 6.4 0 0 0-.7 3h-1c0-2.6 1.4-5 3.5-6.3a7.3 7.3 0 0 1 3.8-1z"
        />
        <path
          fill="#fff"
          d="M482 159.6c4 0 7 3 7 7a6.8 6.8 0 1 1-13.7-.2c0-3.7 3-6.8 6.8-6.8z"
        />
        <path
          fill="#21231e"
          d="M489.5 166.5h-1c0-2.4-1.4-4.7-3.6-5.7a6.3 6.3 0 0 0-3-.7v-1c2.6 0 5 1.5 6.4 3.6a7.4 7.4 0 0 1 1 4zM482 174v-1c2.5 0 4.7-1.5 5.8-3.6.4-1 .7-2 .7-3h1c0 2.6-1.4 5-3.5 6.4a7.3 7.3 0 0 1-4 1zm-7.2-7.5h1c0 2.4 1.4 4.7 3.6 5.7a6.3 6.3 0 0 0 2.7.7v1a7.2 7.2 0 0 1-6-3.6 7.4 7.4 0 0 1-1.2-4zm7.3-7.4v1a6.4 6.4 0 0 0-5.5 3.6 6.4 6.4 0 0 0-.7 3h-1c0-2.6 1.4-5 3.5-6.4a7.3 7.3 0 0 1 3.8-1z"
        />
        <path
          fill="#fff"
          d="M482 127c4 0 7 3.2 7 7s-3 6.8-7 6.8a7 7 0 0 1 .1-13.8z"
        />
        <path
          fill="#21231e"
          d="M489.5 134h-1c0-2.4-1.4-4.7-3.6-5.8a6.3 6.3 0 0 0-3-.6v-1c2.6 0 5 1.3 6.4 3.4a7.4 7.4 0 0 1 1 4zm-7.4 7.3v-1c2.5 0 4.7-1.4 5.8-3.4a6.4 6.4 0 0 0 .7-3h1c0 2.5-1.5 5-3.7 6.3a7.3 7.3 0 0 1-3.7 1zM475 134h1c0 2.3 1.4 4.6 3.5 5.6a6.3 6.3 0 0 0 2.8.7v1a7.3 7.3 0 0 1-6-3.4 7.4 7.4 0 0 1-1.2-4zm7.3-7.4v1a6.3 6.3 0 0 0-5.5 3.5 6.4 6.4 0 0 0-.7 3h-1c0-2.6 1.4-5 3.5-6.3a7.3 7.3 0 0 1 3.8-1z"
        />
        <path
          fill="#fff"
          d="M482 137.2c4 0 7 3 7 6.8s-3 7-7 7c-3.6 0-6.7-3.2-6.7-7s3-6.8 6.8-6.8z"
        />
        <path
          fill="#21231e"
          d="M489.5 144h-1c0-2.3-1.4-4.6-3.5-5.7a6.3 6.3 0 0 0-3-.6v-1c2.7 0 5.2 1.4 6.5 3.6a7.4 7.4 0 0 1 1 3.7zm-7.4 7.4v-1c2.5 0 4.7-1.4 5.8-3.4a6.4 6.4 0 0 0 .7-3h1c0 2.6-1.5 5-3.7 6.4a7.3 7.3 0 0 1-3.7 1zM475 144h1c0 2.4 1.4 4.7 3.5 5.7a6.3 6.3 0 0 0 2.8.7v1a7 7 0 0 1-6-3.5 7.4 7.4 0 0 1-1.2-4zm7.3-7.4v1a6.4 6.4 0 0 0-5.5 3.6c-.5 1-.7 2-.7 2.8h-1c0-2.5 1.4-5 3.5-6.2a7.3 7.3 0 0 1 3.8-1.2z"
        />
        <path
          fill="#fff"
          d="M482 148.2c4 0 7 3 7 6.8s-3 7-7 7c-3.6 0-6.7-3.2-6.7-7s3-6.8 6.8-6.8z"
        />
        <path
          fill="#21231e"
          d="M489.5 155h-1c0-2.3-1.4-4.6-3.6-5.7a6.3 6.3 0 0 0-3-.6v-1c2.6 0 5 1.3 6.4 3.4a7.4 7.4 0 0 1 1 4zm-7.4 7.4v-1c2.5 0 4.7-1.4 5.8-3.4a6.4 6.4 0 0 0 .7-3h1c0 2.6-1.5 5-3.7 6.4a7.3 7.3 0 0 1-3.7 1zM475 155h1c0 2.4 1.4 4.7 3.5 5.7a6.3 6.3 0 0 0 2.8.7v1a7.3 7.3 0 0 1-6-3.4 7.4 7.4 0 0 1-1.2-4zm7.3-7.4v1a6.5 6.5 0 0 0-5.5 3.5 6.4 6.4 0 0 0-.7 3h-1c0-2.5 1.4-5 3.5-6.3a7.3 7.3 0 0 1 3.8-1z"
        />
        <path
          fill="#edb92e"
          d="M487 195.5c1 1.6.7 2 1.4 2.4.8.6 2 .6 3.4.4 5.3-1 4.5 2.3 2.2 6-1 1.7-3.8 3.5-5.2 5-1.4 1.5-1.6 2.8-2 3.2h-9.2c-.5-.4-.7-1.7-2-3.2-1.5-1.5-4.2-3.3-5.3-5-2.4-3.7-3-7 2.2-6 1.3.2 2.6.2 3.4-.5.6-.6.3-1 1.3-2.5a7 7 0 0 1 2.2-2.3c1-.5 1.8-.2 2.6-.2 1 0 2-.3 2.8.2a7 7 0 0 1 2.2 2.3z"
        />
        <path
          fill="#21231e"
          d="m488.7 197.5-.7.8-.2-.2h-.2v-.4h-.2v-.4h-.2v-.4l-.2-.2v-.2l-.2-.2-.2-.3v-.2l.8-.6v.2h.2v.3l.2.2v.2h.2v.4h.2v.4h.2v.4h.2zm-.7.8-.3-.3.3.3zm3.8-.4v1h-2.4l-.2-.2h-.2l-.2-.2h-.3l-.2-.2.7-1v.2h.2v.2h.8l.2.2h1.9zm2.6 6.6-.8-.6.2-.3.2-.3.2-.4.2-.3v-.3l.3-.3v-.2l.2-.2v-.6l.2-.2v-1.3l-.2-.2h-.2v-.2h-.5l-.2-.2h-2l-.2-1h2.8l.3.2h.2l.2.2.2.2.2.2.2.2v.3l.2.3v1.7l-.2.3v.3l-.3.2v.4l-.3.3v.2l-.3.4v.3l-.3.2-.3.4zm-5.3 5.2-.6-.7.3-.2v-.2h.3l.2-.3v-.2h.3l.2-.2h.2v-.3h.2l.2-.3.2-.2h.2l.2-.3h.2v-.3l.3-.2h.2l.2-.3v-.2l.2-.2.2-.2h.2v-.3h.3v-.4h.3v-.3h.2v-.3l1 .6-.2.2-.2.3v.3l-.2.2h-.2l-.2.3v.2l-.3.2-.3.3v.2h-.3l-.2.3-.2.2h-.2l-.2.3-.2.2-.3.3-.3.3h-.2v.3l-.3.2h-.2v.3l-.3.2h-.2v.3h-.2l-.2.3zm-2.3 3.3v-1l-.3.2v-.2h.2v-.2l.2-.2v-.2l.2-.2v-.2l.2-.2v-.2l.2-.2v-.2h.2v-.2l.2-.2.2-.3.3-.3.8.6v.2l-.2.2-.2.2-.2.3v.2h-.2v.2l-.2.2v.2l-.2.2v.2h-.2v.4h-.2v.2l-.2.2v.2h-.5zm.3 0h-.2.2zm-5 .2v-1h4.7v1h-4.5zm0-1h.2zm0 0v1-1zm0 0zm-4.7.8.6-.8h-.4 4.2l.2 1h-4.7l-.3-.2zm.3 0h-.2.2zm-2.4-3.2.7-.7v.2l.2.2.2.3.2.3.2.2v.2h.2v.4h.2v.4h.2v.4h.2v.4h.2v.2l-.5.8-.2-.2v-.2l-.2-.2v-.2h-.2v-.4h-.2v-.4l-.2-.2v-.2h-.2v-.2l-.2-.3-.2-.2-.2-.3-.2-.2zm-5.4-5.2 1-.6v.2l.2.3h.2v.3l.2.2h.2v.3h.3v.3l.2.2h.2l.2.3.2.2v.2l.3.2h.3l.2.3h.2l.2.2v.2h.2l.2.3h.2l.2.3h.2v.3l.3.2h.2v.3h.3v.3l-.6.8-.2-.2-.3-.3-.3-.2-.3-.2v-.2l-.2-.2h-.2l-.2-.3h-.2l-.2-.2h-.2v-.3l-.3-.2h-.2l-.2-.3v-.2h-.3l-.2-.3v-.2h-.3l-.2-.3v-.2l-.3-.2h-.2v-.3l-.3-.2-.2-.2-.2-.2zm2.7-6.7v1l-.6-.2h-2.1l-.2.2h-.2v.2h-.2v.4l-.2.2v1.1l.2.2v.3l.2.3v.2l.2.3.2.4v.3l.3.3.3.4.2.3.2.3-1 .6v-.4l-.3-.3-.2-.4-.2-.4v-.3l-.3-.4v-.4l-.3-.3v-.4l-.2-.3v-.6l-.2-.3v-1l.2-.2v-.2l.3-.2.2-.2.2-.2.4-.2h.3l.3-.2h2.5zm3-.5.8.8-.2.2h-.2l-.2.2h-.4l-.2.2h-3v-1h2.5l.2-.2h.4v-.2h.2zm1.4-2.3.7.6v.3l-.2.2v.2h-.2v.4h-.2v.8h-.2v.2h-.2v.2l-.2.2-.8-.7h.2v-.4h.2v-.4h.2v-.2l.2-.2v-.4h.2v-.3h.2v-.3zm0 0 .2-.4-.3.4zm2.3-2.4.5.8-.2.2h-.2v.2h-.2v.2h-.2l-.2.2-.2.2-.2.2v.2h-.2v.2l-.2.2-.2.2v.2l-1-.6.2-.2.2-.2v-.2h.2v-.2l.2-.2h.2v-.2l.2-.2.2-.2h.2v-.2l.2-.2h.2v-.2h.2l.2-.2zm2.8-.3v1h-2.4l-.5-.7h.2v-.2h.4l.2-.2h2zm3 .3-.5.8h-.4v-.2H482v-1h2.5l.2.2h.2l.2.2zm0 0 .3.2-.3-.2zm2 3.2v-1l-.4.8-.2-.2v-.2h-.2v-.2l-.2-.2-.2-.2v-.2h-.2v-.2h-.2v-.2h-.2v-.2h-.4v-.2h-.2v-.2l.4-.8h.2l.2.2.2.2h.2v.2h.2v.2h.2v.2h.2v.2h.2v.2l.2.2.2.2v.2h.2v.2h.2v.2l-.4.8zm.4-.8.5.8h-1l.4-.8zm-.4-.2v1l-.4-.2.4-.8zm-.4.8-.5-.8h1l-.4.8z"
        />
        <path
          fill="#21231e"
          d="m481.4 212.8-1-.2c-.4-3.7-2-7-4.3-9.6 2.8 1.8 4.8 5.7 5.4 9.8z"
        />
        <path
          fill="#edb92e"
          d="M494.2 198.3c-.5 1-1 2.4-2 3.5-1.5 1.6-4 .5-6.5-1.6-.8-.6-2.2-1-3.6-1a6 6 0 0 0-3.4 1c-2.5 2-5 3.2-6.6 1.6-1-1-1.5-2.4-2-3.5h2.5c1.3.3 2.6.3 3.4-.4.6-.6.3-1 1.3-2.5a7 7 0 0 1 2.2-2.3c1-.5 1.7-.2 2.6-.2 1 0 2-.3 2.8.2.8.5 1.5 1.3 2.2 2.3 1 1.6.7 2 1.3 2.4 1 .6 2.2.6 3.5.4 1-.2 1.8-.2 2.4 0z"
        />
        <path
          fill="#21231e"
          d="m492.6 202-.7-.6v-.2l.2-.2.2-.2v-.2h.2v-.2l.2-.2v-.2l.2-.2v-.2l.2-.2v-.2l.2-.2v-.2l.2-.3v-.4l1 .5v.4l-.2.2v.2l-.2.2v.4h-.2v.2l-.2.2v.3h-.2v.2h-.2v.2h-.2v.3l-.2.2-.2.2h-.2zm-7.3-1.4.7-.7h.2l.2.2.3.2.2.2.3.3h.3l.2.2h.2l.2.2h.2l.2.2h.2l.2.2h.4l.2.2h1.6l.2-.2.2-.2h.2v-.2l.8.7-.2.3h-.2v.3h-.3l-.3.2h-.3l-.2.2h-1.9l-.3-.2h-.3l-.2-.2h-.3l-.2-.2h-.3l-.2-.2-.2-.2h-.3l-.2-.3h-.3l-.2-.3-.2-.2-.2-.2-.2-.2-.3-.2zm.7-.7.5.3-.5-.4zm-4-.2v-1h2v.2h.7v.2h.4l.2.2h.2l.2.2h.2v.2h.2l-.7.8h-.2v-.2h-.2v-.2h-1v-.2h-1v-.2h-1zm-3 .8-.7-.7v-.2h.2l.2-.2h.2v-.2h.2l.2-.2h.5v-.2h1.2v-.2h1v1h-1.5v.2h-.5l-.2.2h-.4v.2h-.2l-.2.2zm-7.3 1.5.7-.6.3.2.2.2h.2v.2h1.7v-.2h.5l.2-.2h.2v-.2h.3l.2-.2.2-.2h.3l.2-.3h.2l.2-.3.3-.2v-.2h.3l.7.6-.3.2-.2.2-.3.2-.2.2-.2.2h-.3l-.2.3h-.3l-.2.2h-.2l-.3.2h-.2l-.2.2h-.2l-.2.2h-.3l-.3.2H473l-.4-.2h-.2l-.2-.2-.2-.2-.3-.3zm-1.7-4 .2 1 .3-.7v.2l.2.2v.3l.2.2v.4l.2.2v.2h.2v.4h.2v.4h.2v.2h.2v.2h.2v.2l.2.2-.7.7h-.2v-.2h-.2v-.2h-.2v-.5h-.2v-.2h-.2v-.3l-.2-.2v-.2h-.2v-.4h-.2v-.4l-.2-.2v-.4h-.2l.4-.8zm-.4.7-.2-.6.6-.2-.4.7zm3-.6-.2 1-.2-.2H470l-.2-1h2.4zm3-.5.7.8-.2.2h-.2l-.2.2h-.4l-.2.2h-2.8v-1h2.3l.2-.2h.4v-.2h.2zm.7.8-.5.4.5-.4zm.6-3 .7.5v.3l-.2.2v.2h-.2v.4h-.2v.8h-.2v.2h-.2v.2l-.2.2-.8-.7h.2v-.4h.2v-.4h.2v-.2l.2-.2v-.4h.2v-.3h.2v-.3zm2.3-2.5.5.8-.2.2h-.2v.2h-.2v.2h-.2l-.2.2-.2.2-.2.2v.2h-.2v.2l-.2.2-.2.2v.2l-1-.6.2-.2.2-.2v-.2h.2v-.2l.2-.2h.2v-.2l.2-.2.2-.2h.2v-.2l.2-.2h.2v-.2h.2l.2-.2zm2.8-.3v1h-2.3l-.5-.7h.2v-.2h.4l.2-.2h2zm3 .3-.5.8h-.4v-.2H482v-1h2.5l.2.2h.2l.2.2zm0 0 .3.2-.3-.2zm2.4 2.4-.8.6-.2-.2v-.2h-.2v-.2l-.2-.2-.2-.2-.2-.2v-.2h-.2v-.2h-.2v-.2h-.4v-.2h-.2v-.2l.4-.8h.2l.2.2.2.2h.2v.2h.2v.2h.2v.2h.2v.2h.2v.2l.2.2.2.2v.2h.2v.2h.2v.2zm1.3 2.3-.7.8-.2-.2h-.2v-.4h-.2v-.4h-.2v-.4l-.2-.2v-.2l-.2-.2-.2-.3v-.2l.8-.6v.2h.2v.3l.2.2v.2h.2v.4h.2v.4h.2v.4h.2zm-.7.8-.3-.3.3.3zm3.8-.4v1h-2.4l-.2-.2h-.2l-.2-.2h-.4v-.2h-.2l.7-1v.2h.2v.2h.8l.2.2h1.9zm3 .5-1-.4.3.8H492l-.2-1h2.4l.5.7zm-.5-.7h.6l-.3.7-.4-.7zm0 .5.4.2-.5-.2zm0-.5h.6l-.3.7-.4-.7z"
        />
        <path
          fill="#edb92e"
          d="M482 211.7c4.4 0 8 3.4 8 7.7s-3.6 7.8-8 7.8-7.6-3.5-7.6-7.8 3.5-7.8 7.7-7.8z"
        />
        <path
          fill="#21231e"
          d="m483 212.8.8-.2c.5-3.7 2-7 4.3-9.6a14.7 14.7 0 0 0-5 9.8z"
        />
        <use
          xlinkHref="#rs-b"
          width={1350}
          height={900}
          transform="matrix(-1 0 0 1 964.3 0)"
        />
        <path
          fill="#edb92e"
          stroke="#21231e"
          d="M577 293.6c2 .3 3 1.5 3 2.8 0 1.3-1 2.6-3 3a8.7 8.7 0 0 1-1.6.2c-60.8 5.2-125.7 5.2-186.5 0a8.7 8.7 0 0 1-1.6-.3c-2-.3-3-1.6-3-3 0-1.2 1-2.4 3-2.7a8.6 8.6 0 0 1 1.5-.3c60.7-5.2 125.6-5.2 186.4 0 .6 0 1 .2 1.5.3z"
        />
        <path
          fill="#21231e"
          d="M412 298.4h-.2v-.2h-.2v-1h.4v-.2.2-.2h2.3l.7-.2h3l.7-.2h3l.7-.2h3l.8-.2h3.3l.7-.2h3.8l.7-.2h.8v1.2h-2.9l-.7.2H428l-.7.2h-2.7l-.8.2H421l.7.2h3.7l.7.2h2.9l.7.2h3.7l.7.2h1.5v1.2h-3.7l-.7-.2h-3.8l-.7-.2h-2.9l-.7-.2H420l-.6-.2h-2.9l-.7-.2H413l-1-.2v-.2.2zm.2-.7zm46.6-2.6v1.3H453l-.7.2h-6.6l-.7.2h-5l-1 .2h-3.5v-1.2h3.5l.8-.2h5.2l.7-.2h5.9l.7-.2h6.8zm23.3 0v1h-13.7l-.7.2h-8.8v-1h1.4l.8-.2H482zm23.5 0v1.3h-11.1l-.7-.2H482v-1h23.6zm23.3 1v1h-5.2l-.8-.2h-5.2l-.7-.2h-6.5l-.8-.2h-4.3V295h.7l.7.2h7.5l.8.2h5l.8.2h5.1l.6.2h2.3zm23.4 1v.2h.4v1h-.2l-.2.2h-3l-.7.2h-2.2l-.7.2h-3.8l-.8.2h-2.8l-.7.2H534l-.8.2h-3.6l-.8.2v-1.2h2.2l.7-.2h3.7l.8-.2h3.7l.7-.2h1.8-1.4l-.8-.2h-2.7l-.7-.2H533l-.6-.2h-3.6V296h6.5l.7.2h3l.8.2h2.8l.7.2h3l.7.2h3l.7.2h1.5zm0 .7zm-116.7.7h.2l.2.2v.8h-.2v.2h-.2v-1.2zm93.3 1.2h-.2l-.2-.2v-.2h-.2v-.8h.2v-.2h.4v1.2zm-50.3-36.2v-1h3.8v1h-4zm0-1zm-1.2 0h1.2v1h-1.2v-1zm0 1zm-.6-1h.6v1h-.6v-1zm-1 0h1v1h-1v-1zm0 0zm-.8 0h.6v1h-.7v-1zm0 1zm-.5-1h.4v1h-.5v-1zm0 0zm-.8 0h.8v1h-.8v-1zm0 0zm-1.2 0h1.2v1h-1.2v-1zm-1 0h1v1h-1v-1zm0 0zm-.2 0h.2v1h-.2v-1zm-1 0h1v1h-1v-1zm-2.5 1v-1h2.6v1h-2.5zm0-1zm-.3 0h.2v1h-.2v-1zm0 1zm-.2-1h.2v1h-.2v-1zm0 0zm-1 0h1v1h-1v-1zm0 1zm-.5-1h.4v1h-.4v-1zm0 0zm-.4 0h.4v1h-.4v-1zm0 1zm-1.2-1h1.2v1h-1.2v-1zm0 0zm0 0v1-1zm0 1h-.2.2zm-1.2-1h1.2v1l-1.2.2v-1zm-.4 0h.4v1.2h-.4v-1zm-.8.2h.8v1h-.8v-1zm0 0h.3-.2zm-.3 0h.3v1h-.3v-1zm0 1h-.5.5zm-1-1h1v1h-1v-1zm-1 0h1v1h-1v-1zm0 0zm-.2 0v1-1zm0 1zm-1-1h1v1h-1v-1zm-.6 0h.5v1h-.4v-1zm0 0zm0 0v1-1zm0 1zm-4.2.2v-1h3.5v-.2h.4v1h-2.7l-.2.2h-.8zm0-1zm-.6 0h.5v1h-.6v-1zm0 0zm-1.7 0h1.6v1h-1.7v-1zm0 1zm-.2-1h.3v1h-.2v-1zm0 0zm-1.3 0h1.4v1h-1.3v-1zm-1 0h1v1h-1v-1zm-.6 0h.7v1h-.6v-1zm0 0zm0 0v1.2-1zm0 1.2zm-1.6-1h1.5v1h-1.5v-1zm0 1zm0-1v1-1zm0 0zm-1.2 0h1.2v1h-1.2v-1zm0 0zm0 0v1-1zm0 1zm-1.2-1h1l.2 1H444v-1zm-.8 0h.8v1h-.7v-1zm0 0zm-1.6.2h1.6v1h-1.5v-1zm0 1zm0-1v1-1zm0 0zm-6.2 1.3v-1h1.7l.2-.2h3.9v1H436l-.2.2zm0 0zm-.4-1h.3v1h-.2v-1zm0 0zm-9 1.4v-1h1.3l.3-.2h3.2l.3-.2h3.5v1h-5.1l-.3.2H426zm0 0zm-.3-1h.2v1h-.3v-1zm0 0zm-.5 0h.5v1h-.4v-1zm-18.2 2.2v-1h1.8l.5-.2h1.7l.5-.2h2.4l.6-.2h2.6l.6-.2h2.2l.6-.2h2.8l.6-.2h1.2v1h-2.1l-.6.2h-2.7l-.6.2h-2.3l-.6.2h-2.8l-.6.2h-2.2l-.5.2H408l-.6.2h-.6zm0 0zm-.3-1h.3v1h-.2v-1zm0 0zm0 0v1-1zm0 1zm-26.3 2.4v-1h.7l1-.2h.8l.8-.2h1.6l.8-.2h1l.7-.2h1.6l.8-.2h1.8l.8-.2h.8l1-.2h1.7l.7-.2h1.7l.8-.2h1.8l.7-.2h1.6l1-.2h1.5l1-.2v1H405l-.7.2h-1.7l-.8.2H400l-.7.2h-.8l-1 .2H396l-.8.2h-1.7l-.8.2H391l-.8.2h-.8l-.8.2H387l-1 .2h-.7l-.8.2H383l-1 .2h-.8l-.8.2zm0 0zm0-7v1h-.5l-.5.2h-.5l-.3.2-.4.2-.3.2h-.2l-.3.3-.2.2-.3.3v.5l-.2.2v1.1h.2v.3l.2.2.2.2.3.3.3.2h.2l.3.2h.3l.4.2h1v1h-1.6l-.4-.2-.4-.2-.3-.2-.3-.2-.3-.2-.4-.2-.2-.3-.2-.2v-.3l-.3-.3-.2-.3v-1.6l.2-.3.2-.3.2-.4.2-.3.2-.3.4-.3.3-.2.4-.2.3-.2h.4l.5-.2h.6l.5-.2zm0 1zm26.3-3.3v1H405l-.7.2h-1.7l-.8.2H400l-.7.2H396l-.8.2h-1l-.7.2H392l-1 .2h-1.6l-.8.2h-.8l-.8.2h-1.7l-.8.2h-.8l-.8.2H381l-.8.2v-1h1.7l.8-.2h.8l.8-.2h.8l.8-.2h1.7l.8-.2h1.6l1-.2h.8l.8-.2h1.8l.7-.2h1.7l1-.2h.7l.8-.2h1.8l.7-.2h1.6l1-.2h2.5zm0 1zm0 0v-1 1zm0-1zm37-2.2v1.2H439l-1 .2h-2.3l-1.3.2H431l-1.2.2h-2.2l-1.3.2H424l-1.2.2h-2.3l-1 .2H417l-1.2.2h-1.2l-1 .2h-2.3l-1.3.2h-1l-1.2.2h-1.2v-1h2.2l1.2-.2h1l1.2-.2h2.2l1.3-.2h1l1.2-.2h2.3l1-.2h2.3l1.3-.2h2.4l1.2-.2h2.3l1-.2h3.5l1.2-.2h3.5l1-.2h2.5zm1 1-1 .2v-1h1v1zm0 0zm.2 0h-.3v-1l.2 1zm-.2-1zm.4 1h-.3l-.2-1h.4v1zm1.2 0h-1.2v-1h1.2v1zm0 0zm0 0v-1 1zm0-1zm15.4-.4v1h-5.5l-.5.2h-6.5l-.4.2h-2.6v-1h5l.5-.2h7.7l.5-.2h1.8zm.8 1h-.8v-1h.8v1zm0 0zm0 0v-1 1zm0-1zm1.4 1h-1.4v-1h1.4v1zm0 0zm.2 0h-.2v-1h.2v1zm0 0h-.2.2zm0 0v-1 1zm0-1zm1.2 1h-1.2v-1h1.2v1zm.5 0h-.6v-1h.4v1zm-.2-1zm.8 1h-.7l-.2-1h.8v1zm1 0h-1v-1h1v1zm0 0zm.2 0h-.3v-1h.2v1zm0-1zm.4 1h-.4v-1h.4v1zm3-1 .2 1H468v-1h3.3zm1.2 1h-1v-1l1-.2v1zm0 0v-1.2 1zm0-1.2zm1.3 1h-1.2v-1h1.2v1zm3.5-1v1h-3.5v-1h3.5zm0 0zm0 1v-1 1zm0 0zm1.3 0h-1.2v-1h1.2v1zm3.6-1v1h-3.5v-1h3.7zm3.8 0v1H482v-1h3.8zm1 1h-1v-1h1.2v1zm.2 0zm0 0v-1 1zm0-1zm3.6 0v1H487v-1h4zm1 1h-1v-1h1.2v1zm.2-1zm0 1v-1 1zm1 0h-1v-1h1v1zm3.3-1v1H493v-1h3zm.5 1h-.4v-1h.5v1zm0-1zm.3 1h-.3v-1h.3v1zm0 0zm1 0h-1v-1h1v1zm.6 0h-.7v-1h.8v1zm0-1zm.5 1.2h-.6v-1h.5v1zm1 0h-1v-1h1v1zm0-1zm0 1v-1 1zm0 0h.3-.2zm.3 0h-.2v-1h.3v1zm0 0zm1.3 0h-1.3v-1h1.4v1zm0-1zm0 1v-1 1zm0 0h.2zm1 0h-1v-1h1v1zm15.2-.6v1h-6l-.4-.2H504l-.6-.2h-.9v-1h6l.4.2h6.6l.4.2h1.7zm0 0zm0 1v-1 1zm0 0zm1.3 0h-1v-1h1v1zm.4 0h-.3v-1h.5v1zm0-1zm.2 1h-.2v-1h.2v1zm0 0zm1 .2h-1v-1h1v1zm37 1v1h-2.3l-1.2-.2h-1l-1.2-.2h-2.2l-1.3-.2H546l-1-.2h-1.3l-1-.2h-2.3l-1.3-.2H537l-1-.2h-4l-1-.2h-2.6l-1-.2H524l-1-.2h-2.4v-1h4.7l1.2.2h3.3l1.3.2h2.3l1.3.2h2.3l1 .2h2.4l1 .2h2.3l1.3.2h2.3l1 .2h2.3l1.2.2h1.2l1 .2h1.3l1 .2h1.3zm0 0zm0 1v-1 1zm0 0zm26.4 1.4v1H582l-.8-.2h-.8l-.8-.2H578l-.7-.2h-.8l-.8-.2H574l-.8-.2h-.8l-.8-.2h-1.8l-.7-.2h-1.5l-.8-.2H565l-.8-.2h-1.7l-.8-.2H560l-.8-.2h-1.6v-1h3.5l.8.2h1.6l1 .2h1.7l.7.2h1.7l.8.2h1.8l.7.2h.8l.8.2h1.8l.8.2h.8l.8.2h1.8l.7.2h.7l.8.2h1.8l.7.2zm0 1zm0 6v-1h1.6l.3-.2h.3l.3-.2.2-.2.2-.2h.2v-.3l.2-.2v-.2h.2v-1.4l-.2-.3v-.2h-.3l-.2-.3-.3-.2h-.2l-.3-.3-.4-.2h-.4l-.4-.2h-.4l-.5-.2v-1h.5l.6.2h.5l.5.3.4.3.4.2.3.2.4.3.3.3.2.3v.3l.3.2v.3l.2.3v1.3l-.3.3v.3l-.3.3-.3.4-.3.2-.3.2-.2.2-.3.2-.4.2h-.3l-.4.2H584zm0 0zm-26.5-2.4v-1h1.8l.8.2h1.8l.8.2h1.8l.7.2h1.7l1 .2h.7l.8.2h1.8l.7.2h1.6l.8.2h1l.8.2h1.6l.8.2h1l.7.2h1.5l.8.2h1l.7.2v1h-1l-.8-.2h-1.6l-.8-.2h-.8l-.8-.2h-1.7l-.8-.2h-.8l-1-.2h-1.6l-.8-.2h-.8l-1-.2h-1.4l-.8-.2H566l-.7-.2h-1.6l-1-.2H561l-1-.2h-1.6l-.8-.2zm0 0zm0-1v1-1zm0 0zm-.2 0h.3v1h-.4v-1zm0 1zM539 265v-1h2.9l.5.2h3l.5.2h2.3l.6.2h2.2l.6.2h2.3l.5.2h2.4l.5.2v1h-1.7l-.5-.2h-2.3l-.6-.2H550l-.7-.2H547l-.6-.2h-2.9l-.6-.2H540l-.6-.2h-.6zm-.4-1h.5v1h-.4v-1zm0 0zm-.2 0h.2v1h-.2v-1zm0 1zm-9.2-.5v-1h4l.3.2h3.2l.3.2h1.3v1h-1.6l-.3-.2H533l-.4-.2h-3.3zm0-1zm-.3 0h.2v1h-.3v-1zm0 1zm-6.4-.3v-1h4.5l.2.2h1.7v1h-4.4l-.2-.2h-1.7zm0-1zm0 0v1-1zm0 1zm-1.5-1h1.7v1H521v-1zm0 0zm-.7 0h.8v1h-.7v-1zm-1-.2h1v1H519l.2-1zm-.2 1zm0-1h.2v1-1zm0 0zm-1 0h1v1h-1v-1zm0 0zm-.2 0v1-1zm0 1zm-1.4-1h1.4v1h-1.4v-1zm0 1zm-.2-1h.2v1h-.2v-1zm0 0zm-.6 0h.6v1h-.7v-1zm-1 0h1v1h-1v-1zm-1.4-.2h1.4v1h-1.4v-1zm0 0zm-.2 0h.2v1h-.2v-1zm0 1zm-1.6-1h1.6v1h-1.6v-1zm0 0zm-.6 0h.6v1h-.6v-1zm-4.2 1v-1.2h3.3l.2.2h.8v1h-4.3zm0 0zm0-1.2v1-1zm0 0zm-.5 0h.6v1h-.5v-1zm-1 0h1v1h-1v-1zm0 1zm0-1v1-1zm0 0zm-1.3 0h1.2v1h-1.3v-1zm-1 0h1v1h-1v-1zm0 1h.6-.6zm-.2-1h.3v1h-.3v-1zm0 0h-.3.3zm-.8 0h.8v1h-.8v-1zm-.4 0h.4v1h-.4v-1zm-1.2 0h1.3v1H500v-1zm0 1h.2zm0-1v1-1zm0 0zm-1 0h1v1h-1v-1zm0 1zm-.5-1h.4v1h-.6v-1zm0 0zm-.4 0h.5v1h-.4v-1zm0 1zm-1-1h1v1h-1v-1zm0 0zm-.2 0h.2v1h-.2v-1zm0 1zm-.3-1h.3v1h-.3v-1zm0 0zm-2.6.8v-1h2.3v1H494zm-1-1h1v1h-1v-1zm-.2 0h.2v1h-.2v-1zm0 0zm-1 0h1v1h-1v-1zm-1.2 0h1.2v1h-1.3v-1zm0 0zm-.8 0h.8v1h-.8v-1zm0 0zm-.4 0h.4v1h-.5v-1zm0 1zm-.7-1h.7v1h-.7v-1zm0 0zm-1 0h1v1h-1v-1zm-.7 0h.6v1h-.6v-1zm0 1zm-1.2-1h1.2v1H486v-1zm0 0zm-3.7 1v-1h3.9v1h-4.1zm.4 1.8L460 276.6l-.4-1 22.7-11.3h.4v1zm-.5-1h.4-.5zm22.7 12.4-23-11.4.4-1 22.7 11.5v1h-.3zm.4-1 1 .6-1 .4v-1zm-23 11.6 22.7-11.5.4 1-22.6 11.4h-.5v-.8zm.4 1h-.3.4zM460 275.7l22.8 11.5-.5 1-22.8-11.6v-1h.4zm-.4 1-1-.5 1-.5v1z"
        />
        <path
          fill="#0c4076"
          d="M482 269c5.8 0 10.4 3.2 10.4 7s-4.6 7-10.3 7-10-3.2-10-7 4.5-7 10-7z"
        />
        <path
          fill="#21231e"
          d="M493 276h-1v-.3l-.2-.3v-.5l-.2-.3v-.3l-.3-.3-.2-.4v-.3l-.3-.2-.2-.2-.2-.3-.3-.2-.3-.3-.3-.2-.3-.2-.2-.2-.4-.2-.4-.2-.3-.2-.4-.2h-.5l-.4-.3h-.4l-.5-.2h-.8l-.5-.2h-1.9v-1.2h1.7l.6.2h.5l.5.2h.5l.5.2h.4l.5.3.4.2.5.2h.5l.4.3.3.2.4.2.3.3.4.3.3.2.3.3.3.3.2.4.3.3.2.4.2.4.2.4v.3l.2.5v.4l.2.2v.8zm-11 7.4v-1h1.6l.5-.2h1.1l.5-.2h.5l.4-.3h.4l.5-.3h.4l.3-.3h.4l.4-.3.3-.2.4-.3.3-.2.3-.2.3-.3.2-.3.2-.2.3-.3v-.3l.3-.3h.2v-.4l.2-.3v-.7l.2-.3v-.3h1v.4l-.2.4v.4l-.2.4v.3l-.2.3-.2.3-.2.4-.2.3-.3.3-.2.3-.3.2-.3.3-.3.3-.4.3-.3.3-.4.2-.4.3-.5.2-.4.2-.4.2h-.4l-.5.3h-.4l-.5.3h-.5l-.5.2h-1.1l-.5.2H482zm-10.6-7.4h1v1l.2.3v.3l.2.2.2.3v.4l.3.3.2.3.3.2.2.3.3.3.3.2.3.2.2.3.3.2.4.2h.2l.4.3h.4l.4.3h.5l.3.3h.9l.5.2h1.5l.6.2h.5v1h-1.9l-.5-.2h-.5l-.5-.2-.5-.2h-.4l-.5-.3h-.4l-.4-.3-.4-.2-.4-.2-.4-.3-.4-.2-.3-.2-.4-.2-.4-.3-.3-.3-.3-.3-.2-.4-.3-.3-.2-.3-.2-.4v-.3l-.2-.4-.2-.4v-.8l-.2-.4v-.4zm10.7-7.4v1h-1.3l-.5.2h-.3l-.5.2h-.5l-.4.2h-.4l-.6.3h-.4l-.4.3-.4.2-.3.2-.5.2-.3.2-.3.2-.4.2-.3.3-.3.2-.2.3-.3.3-.2.3-.2.3v.3l-.2.2v.3l-.2.3v.7l-.2.3v.3h-1V275l.2-.5.2-.4v-.2l.3-.4.3-.3.2-.3.3-.3.2-.3.3-.2.3-.3.3-.2.3-.3.3-.3.4-.2.4-.2.4-.2h.4l.4-.3.5-.2.5-.2h.5l.5-.2h1l.5-.2h1.1l.6-.2h.5z"
        />
        <path
          fill="#edb92e"
          d="M482 211.7c4.4 0 8 3.4 8 7.7s-3.6 7.8-8 7.8-7.6-3.5-7.6-7.8 3.5-7.8 7.7-7.8z"
        />
        <path
          fill="#21231e"
          d="M490.4 219.4h-1v-1l-.2-.3v-.4l-.2-.3v-.4l-.2-.4v-.3l-.3-.3-.2-.3-.2-.3v-.3l-.3-.2-.2-.3-.2-.2-.3-.2-.3-.2-.2-.2-.3-.2-.3-.2-.4-.2h-.3l-.3-.3h-.4l-.3-.2h-.4l-.4-.2H482V211l.6.2h1.2l.4.2h.4l.4.2.3.2.4.2h.4l.4.3.3.3.4.2.4.2.3.3.3.3.2.3.3.2.2.3.3.3.2.3.2.5.2.3v.4l.3.4v.8l.2.4v.8l.2.4v.4zm-8.3 8.3v-1h1.5l.3-.2h.3l.3-.2.4-.2h.3l.3-.2h.3l.2-.3.3-.2.2-.2.3-.2.3-.2.2-.3.2-.2.2-.2v-.3l.3-.3.2-.3.2-.4v-.3l.2-.4v-.7l.2-.4v-.8l.2-.4v-.4h1v1.2l-.2.4v.5l-.2.4v.3l-.3.4v.3l-.3.4-.2.3-.2.4-.3.4-.2.3-.3.3-.2.3-.3.3-.3.2-.3.3-.3.3-.3.2-.3.2-.3.2h-.4l-.3.2-.4.2h-.4l-.4.2H482zm-8-8.3h1v1.8l.2.3.2.3v.3l.2.3.2.3.2.2.2.3.2.3.2.3.2.3.2.3.3.2.2.3.3.3.3.2.4.2h.3l.3.3h.3l.4.3h.3l.3.2h.7l.4.2h.7v1h-1.6l-.4-.2h-.3l-.4-.3h-.4l-.4-.3-.4-.3-.3-.2-.5-.2-.3-.2-.3-.2-.4-.2-.3-.3-.3-.3-.2-.3-.3-.3-.2-.3-.2-.3v-.3l-.3-.4v-.3l-.3-.4v-.4l-.2-.5v-.4l-.2-.3v-1.4zm8-8.3v1.2h-1.3l-.4.2h-.3l-.3.2h-.4l-.3.3h-.3l-.3.2-.3.2-.2.2-.3.2-.2.3-.3.3-.2.2-.2.3-.2.3-.2.4-.2.3-.2.3-.2.3v.3l-.2.3-.2.3v.7l-.2.3v1.1h-1v-1.6l.2-.4v-.4l.2-.4.2-.4v-.4l.3-.3v-.4l.3-.2.2-.3.3-.3.2-.3.3-.4.3-.3.3-.3.2-.2.3-.2.4-.3.2-.2h.4l.3-.2.3-.2h.4l.4-.2h.5l.4-.2h1.1z"
        />
        <path
          fill="#edb92e"
          d="M482 213.7c3.3 0 5.8 2.6 5.8 5.7 0 3.2-2.5 5.8-5.7 5.8-3 0-5.5-2.6-5.5-5.8 0-3 2.5-5.7 5.6-5.7z"
        />
        <path
          fill="#21231e"
          d="M488.3 219.4h-1V218h-.2v-.7l-.2-.2v-.2l-.2-.3-.2-.2v-.2l-.3-.2-.2-.2-.2-.2-.2-.2h-.2l-.2-.3h-.4l-.2-.3h-.2l-.3-.2h-.6l-.2-.2H482v-1h1.8l.3.2h.3l.2.2h.3l.3.3h.4l.2.3h.2l.3.3.3.2.2.2.2.2.2.3v.2l.3.3v.2l.3.3v.2l.2.3.2.3v.6l.2.2v1.3zm-6.2 6.3v-1h1.1l.2-.2h.3l.2-.2h.2l.2-.2h.4l.2-.2.2-.2h.2l.2-.3.2-.2h.2v-.2l.3-.2v-.2l.3-.3.2-.3v-.2l.2-.3v-.2l.2-.3v-1.3h1v2l-.2.3-.2.3-.2.4-.2.3v.2l-.3.2v.2l-.3.2-.2.3h-.2l-.2.3h-.2l-.2.3-.3.2h-.2l-.2.3-.3.2h-.2l-.3.2h-.3l-.3.2h-1.4zm-6-6.3h1v1.3l.2.3v.2l.2.3v.2l.2.2.2.4.2.2v.2h.3l.2.3.2.3v.2h.3l.2.3h.3l.2.2h.2v.2h.4l.2.2h.2l.3.2h.9v1h-1.5l-.3-.2h-.3l-.3-.2h-.2l-.3-.3-.3-.2-.3-.2-.3-.2h-.2l-.2-.3h-.2l-.2-.4-.2-.2-.2-.2-.2-.3-.2-.3v-.3l-.2-.3h-.2v-.4l-.2-.3v-.6l-.2-.3v-.9zm6-6.2v1H481l-.2.2h-.4l-.3.2-.3.3h-.5l-.2.3h-.2v.3l-.3.2h-.2l-.2.3v.3l-.2.2v.2l-.2.3v.2l-.2.2v.2l-.2.3v.4l-.2.2v.7h-1V218l.2-.4v-.3l.2-.3.2-.3v-.2l.2-.3.2-.2.2-.3.2-.2.2-.3.2-.2.2-.2.2-.2.2-.2h.3l.2-.3h.2l.3-.2h.2l.3-.2h.3l.3-.2h.5l.3-.2h.6z"
        />
        <path
          fill="#0c4076"
          d="M482 215.8c2 0 3.7 1.6 3.7 3.6S484 223 482 223c-1.8 0-3.4-1.6-3.4-3.6s1.6-3.6 3.5-3.6z"
        />
        <path
          fill="#21231e"
          d="M486.2 219.4h-1v-.8h-.2v-.3l-.2-.2v-.2l-.2-.2-.2-.2-.2-.3h-.2l-.3-.2h-.2l-.2-.2h-.2v-.2H482v-1h1.4v.2h.5v.2h.3v.2h.3v.3h.3v.2l.2.2.2.3.2.3v.2l.2.2.2.3v.4l.2.2v.6zm-4 4.2v-1h.6v-.2h.5l.3-.2h.2l.2-.2v-.2h.2v-.2h.2v-.2h.2v-.2l.2-.2v-.2l.2-.2v-.4h.2v-1h1v1l-.2.2v.2l-.2.2v.2l-.2.2-.2.3-.2.2-.2.2-.3.2-.3.3h-.3l-.3.2-.3.2h-1l-.3.2zm-4-4.2h1v1.3l.2.2v.2l.2.2.2.2.2.2.2.2.2.2h.2v.2h.4l.2.2h.8v1.2h-.7l-.2-.2h-.3v-.2h-.5l-.2-.2-.3-.3h-.2v-.2l-.2-.2h-.2v-.2l-.2-.3-.2-.3v-.2l-.2-.2-.2-.3v-1.4zm4-4v1h-1l-.2.2h-.2l-.2.2h-.2v.2h-.2l-.2.3-.2.2-.2.2-.2.3v.4h-.2v1h-1V218l.2-.2.2-.3v-.2l.2-.2.2-.2.3-.3.2-.2.2-.2h.2l.2-.2h.2l.2-.2h.3l.3-.2h.9z"
        />
      </g>
      <path
        fill="#c6363c"
        d="M314.6 301.2v271.3c0 48.5 18.8 92.6 49.2 124.6A162.9 162.9 0 0 0 482 749a163 163 0 0 0 118.5-51.7c30.4-32 49.2-76 49.2-124.5V301.2h-335z"
      />
      <path
        fill="#fff"
        d="M313.4 300v277l.2 4.6.3 4.5.3 4.6.5 4.4.5 4.5.7 4.3.8 4.4 1 4.3 1 4.2 1 4.3 1.2 4.2 1.3 4 1.4 4.2 1.4 4 1.7 4 1.6 4 1.8 4 2 3.8 1.8 3.8 2 3.7 2 3.7 2.2 3.6 2.2 3.6 2.4 3.5 2.4 3.6 2.4 3.4 2.6 3.3 2.6 3.2 2.7 3.2 2.8 3 3 3.2 1.6-1.7-2.8-3-2.7-3-2.6-3.3-2.5-3.2-2.7-3.3-2.4-3.3-2.5-3.4-2.2-3.5-2.3-3.5-2-3.6-2-3.6-2-3.7-2-4-1.8-3.7-1.7-3.8-1.6-4-1.7-4-1.4-4-1.5-4-1.2-4-1.2-4.2-1-4-1-4.3-.8-4.3-.8-4.3-.7-4.3-.6-4.2-.4-4.5-.4-4.4-.2-4.5-.2-4.5V302.5h332.7V577l-.2 4.5-.3 4.4-.3 4.3-.5 4.5-.6 4.3-.7 4.4-1 4.3-.8 4.3-1 4.2-1 4-1.2 4.3-1.3 4-1.3 4-1.4 4-1.6 4-1.6 4-1.7 3.8-1.7 3.8-2 4-2 3.6-2 3.6-2 3.6-2.3 3.5-2.3 3.5-2.3 3.4-2.5 3.3-2.6 3.3-2.6 3.2-2.6 3.2-2.7 3-2.8 3-3 3-2.8 3-3 2.7-3 2.6-3.3 2.6-3 2.6-3.4 2.4-3.3 2.5-3.3 2.3-3.4 2.2-3.5 2.2-3.5 2-3.5 2-3.6 2-3.7 1.7-3.7 1.8-3.8 1.7-3.8 1.5-3.8 1.4-4 1.3-3.8 1.3-4 1-4 1-4 1-4 1-4.2.6-4 .6-4.3.5-4 .4-4.3.4-4.3.2H482v2.4h4.5l4.3-.2 4.3-.3 4.4-.4 4.2-.4 4.2-.6 4.2-.8 4-.8 4.2-1 4-1 4-1.2 4-1.2 4-1.4 4-1.4 3.8-1.6 3.7-1.6 3.8-1.7 3.7-2 3.7-1.8 3.5-2 3.5-2 3.6-2.3 3.4-2.2 3.4-2.4 3.3-2.5 3.3-2.4 3.2-2.6 3.2-2.7 3-2.7 3-2.8 3-3 3-3 2.8-3 2.8-3 2.7-3.3 2.6-3.2 2.5-3.3 2.5-3.4 2.4-3.5 2.3-3.4 2.3-3.6 2-3.6 2.2-3.7 2-3.7 2-3.8 1.7-4 1.8-3.8 1.6-4 1.6-4 1.4-4 1.4-4 1.3-4.2 1.2-4.2 1-4.3 1-4.2 1-4.3.7-4.4.7-4.3.5-4.5.5-4.4.4-4.5.3-4.4V577l.2-4.5V300z"
      />
      <g fill="#fff" stroke="#21231e">
        <path d="M483.7 734.8c1.4-.2 4 0 5.7-1.4 2.5-2 1.5-9.8 1.3-14.8-1-25.3-2.2-68-3.5-128-2-.2-3.6 0-5 .2a12 12 0 0 0-5 0c-1.4 59.8-2.5 102.5-3.6 127.8-.2 5-1.2 13 1.3 14.8 1.7 1.5 4.2 1 5.6 1.4h3z" />
        <path d="M499.6 734c-1.5 0-4 .5-6-.8-2.6-1.7-2.8-9.7-3-14.7a6148 6148 0 0 0-7.6-127.6c2-.6 3.6-.6 5-.5.3 0 .5 0 .7-.2 9.6 59.2 13.2 101.2 19.7 126.5 1 3.5 2.8 12.2-.2 15-1.7 1.7-4.2 1.6-5.6 2l-3 .3z" />
        <path d="M518.2 731.4c-1.5 0-3.8.8-6-.3-2.7-1.4-2.6-9.4-3.8-14.2-6.6-25.3-10.2-67.3-19.7-126.5 2-.7 3.6-.8 5-1h.2c15 57.6 19.6 98.2 31.4 123.2 1 3.5 4 12.7 1.2 16-1.5 1.7-4 1.8-5.4 2.3l-3 .6z" />
        <path d="M537 726c-1.5.3-4 1.6-6 .7-3-1.2-3.5-9.7-5.6-14.2-11.8-25-16.3-66-31.7-124 2-.8 3.5-1 5-1.3 1.3-.6 1-1 3-1.2 18 57.3 23.7 97 40.5 121.8 2.7 4 4.7 12 3 14.5-1.5 2-4 2.3-5.3 3l-3 .8zm-72.2 8c1.4 0 3.8.5 5.8-.8 2.7-1.7 3-9.7 3-14.7a7227 7227 0 0 1 7.7-127.6c-2-.6-3.6-.6-5-.5a25.4 25.4 0 0 0-.7-.2c-9.6 59.2-13.2 101.2-19.7 126.5-1 3.5-3 12.2 0 15 1.8 1.7 4.3 1.6 5.7 2l3 .3z" />
        <path d="M446 731.4c1.6 0 4 .8 6-.3 2.8-1.4 2.7-9.4 4-14.2 6.4-25.3 10-67.3 19.6-126.5-2-.7-3.6-.8-5-1h-.3c-15 57.6-19.6 98.2-31.4 123.2-1.2 3.5-4.2 12.7-1.3 16 1.5 1.7 4 1.8 5.4 2.3l3 .6z" />
        <path d="M427.3 726c1.5.3 4 1.6 6 .7 3-1.2 3.5-9.7 5.6-14.2 11.7-25 16.2-66 31.6-124-2-.8-3.5-1-5-1.3-1.3-.6-1-1-3-1.2-18 57.3-23.7 97-40.5 121.8-2.6 4-4.6 12-2.8 14.5 1.4 2 4 2.3 5.2 3l3 .8zm99.7-43c-1.3 0-3.3 1-5.4 0-2.8-1.4-4.6-9-6-14-12-23.5-23-65.3-40.8-123.4 1.8-.7 3-1 4.5-1 1-.5 2.4-1 4.3-1.2 19.3 57.5 28 99 46.7 122 3 3.8 5.4 12 4 14.4-1.2 1.8-3.4 2-4.6 2.6l-2.7.6z" />
        <path d="M512 685.8c-1.5 0-3.6.6-5.6-.5-2.6-1.6-3.5-9.4-4.5-14.3-5-25-13.7-67-26.3-126 1.8-.7 3.2-.8 4.5-.8 1.2-.4 2.6-.8 4.5-.8 15 58.7 18.3 102.6 32.4 125 2.6 4.2 4 12.5 2.3 14.8-1.3 1.7-3.5 1.7-4.8 2.2l-2.7.4z" />
        <path d="M496.4 687.6c-1.4-.2-3.5.3-5.4-1-2.4-1.7-2.4-9.6-2.8-14.6-2-25.3-6-68-11.6-127.6 2-.5 3.3-.4 4.6-.3 1.2-.2 2.6-.5 4.5-.4 8 59.6 12.8 102.8 18 127.2 1 5 2.4 12.6.4 14.8-1.4 1.5-3.6 1.4-5 1.8l-2.6.2z" />
        <path d="M437.2 682.8c1.4 0 3.4 1 5.5 0 2.8-1.4 4.6-9 6-14 12-23.5 23-65.3 40.8-123.4-1.8-.7-3-1-4.5-1-1-.5-2.4-1-4.3-1.2-19.3 57.5-28 99-46.7 122-3 3.8-5.4 12-4 14.4 1.2 1.8 3.4 2 4.6 2.6l2.6.6z" />
        <path d="M452.4 685.8c1.4 0 3.5.6 5.5-.5 2.5-1.6 3.4-9.4 4.4-14.3 4.8-25 13.6-67 26.2-126-1.8-.7-3.2-.8-4.5-.8a12 12 0 0 0-4.4-.8c-15 58.7-18.3 102.6-32.4 125-2.5 4.2-4 12.5-2.2 14.8 1.3 1.7 3.5 1.7 4.7 2.2l2.7.4z" />
        <path d="M468 687.6c1.3-.2 3.4.3 5.3-1 2.4-1.7 2.4-9.6 2.8-14.6 2-25.3 6-68 11.7-127.6-2-.5-3.3-.4-4.6-.3-1-.2-2.5-.5-4.4-.4-8 59.6-12.8 102.8-18 127.2-1 5-2.4 12.6-.4 14.8 1.5 1.5 3.7 1.4 5 1.8l2.7.2z" />
        <path d="M483.5 688c1.3 0 3.5.2 5.2-1.3 2.3-2 1.4-9.8 1.2-14.8-1.2-25.4-2-68-3.3-128a14 14 0 0 0-4.6 0c-1.2-.2-2.5-.3-4.4 0-1.2 60-2 102.6-3.2 128-.2 5-1 12.8 1.2 14.7 1.6 1.5 4 1 5.2 1.4h2.7z" />
        <path d="M516.5 648c-1 0-2.5 1-4 0-2.3-1.5-3.7-9.2-4.8-14-9.2-23.5-17.5-65.4-31.2-123.5 1.4-.7 2.4-1 3.4-1 .8-.5 1.8-1 3.3-1 14.7 57.4 21.3 99 35.7 121.8 2.4 3.8 4 12 3 14.5-.8 1.8-2.5 2-3.4 2.5l-2 .7z" />
        <path d="M505 651c-1 0-2.7.6-4.3-.6-2-1.5-2.7-9.4-3.4-14.3-3.7-25-10.5-67-20-126 1.3-.6 2.3-.7 3.4-.7 1-.4 2-.7 3.4-.8 11.5 58.7 14 102.6 25 125.2 2 4 3 12.4 1.6 14.6-1 1.7-2.7 1.8-3.6 2.2l-2 .5z" />
        <path d="M493 652.7c-1 0-2.6.4-4-1-2-1.7-2-9.6-2.2-14.5-1.5-25.4-4.5-68-9-127.7 1.5-.4 2.6-.4 3.6-.3 1-.3 2-.6 3.5-.4 6 59.6 9.7 102.7 13.6 127 .7 5 2 12.8.4 15-1.2 1.5-3 1.4-4 1.7l-2 .2z" />
        <path d="M447.8 648c1 0 2.5 1 4 0 2.3-1.5 3.7-9.2 4.8-14 9.2-23.5 17.5-65.4 31-123.5-1.2-.7-2.2-1-3.2-1-1-.5-2-1-3.4-1-14.7 57.4-21.3 99-35.7 121.8-2.4 3.8-4.2 12-3 14.5.8 1.8 2.5 2 3.4 2.5l2 .7z" />
        <path d="M459.4 651c1 0 2.6.6 4-.6 2.2-1.5 3-9.4 3.6-14.3 3.7-25 10.5-67 20-126a7.7 7.7 0 0 0-3.4-.7c-1-.4-2-.7-3.4-.8-11.4 58.7-14 102.6-24.8 125.2-2 4-3 12.4-1.7 14.6 1 1.7 2.7 1.8 3.6 2.2l2 .5z" />
        <path d="M471.3 652.7c1 0 2.6.4 4-1 2-1.7 2-9.6 2.2-14.5 1.5-25.4 4.5-68 9-127.7a9.5 9.5 0 0 0-3.6-.3c-1-.3-2-.6-3.6-.4-6.2 59.6-9.8 102.7-13.7 127-.7 5-2 12.8-.4 15 1.2 1.5 3 1.4 4 1.7l2 .2z" />
        <path d="M483.2 653.2c1-.2 2.7 0 4-1.4 1.7-2 1-9.7 1-14.7-1-25.3-1.6-68-2.5-128-1.5-.2-2.6 0-3.6.2-.8-.2-2-.4-3.4 0-1 59.8-1.6 102.5-2.4 128 0 5-.8 12.7 1 14.6 1.2 1.5 3 1.2 4 1.4h2z" />
        <path d="M475 559c-.2 4.4-.3 9-.3 14l-10.6 2.3c0 4.8 12 55.4 18 55.4 6.3 0 18.2-50.6 18.2-55.5l-10.6-2v-.2c0-5 0-9.6-.2-14-2.2 2-4.7 5.2-7.3 8-2.4-2.8-5-6-7-8z" />
      </g>
      <g id="rs-d">
        <path
          fill="#edb92e"
          stroke="#21231e"
          d="M412 584.5c-3 .2-7 2-18.5 12-5 10.2-10 20.5-17 29.4-2.4 1.4-4.2 2.5-6 3.2a84 84 0 0 1-17-.5c-4.4-4-11.3-1.2-9 3.2-1.8 1.6 2.2 7.8 5.3 5.2 3-2.4 13-.2 16.4-1.4-1.3 3-10.4 5-16.8 5.5-5.8.2-5.4 6-3 10.5 2.7 1.8.5-.4 1.4.8 2.6 4 8.2 3.4 8.4-.4.2-4 13.8-9 15.8-12-2.5 6-8.2 11.5-11 17.3-3 3-5 3.7-1 10 4.4-.6 4.6-1.7 7.3.8 6-.6 7-2.4 6-7.2-1-5 3.2-14 4.6-16.6 1.2-2.4 1.5-4.8 2.8-6.3 2.2-2.5 12.6-7.7 15.2-6.3 5 2.7 8.7 1 9.3-3.7-1.6-1.2-.4-8-3.8-8.2-2.8-.3-4.4.6-7 2.7-4 3.2-6 5-7.4 4.6-3-.7 5.8-5 13.8-15.6 11-14.5 11.8-22 11.3-27z"
        />
        <use
          xlinkHref="#rs-c"
          width={1350}
          height={900}
          transform="matrix(-1 0 0 1 801.6 0)"
        />
        <path
          fill="#edb92e"
          stroke="#21231e"
          d="M345.2 634.5c-4-2.3-6.3-2.2-8-.5-.7 1-1.8.5-1.2-1 2.7-6.3 7-7 10.7-4.2l2.8 2.7c-.6 1-3.8 2.3-4.3 3zm57.4-5.6c4.3-3 8.3-3.6 10.5-2 1.3 1 2.5.3 1.4-1.2-4.4-6.2-9.6-6.5-13.5-3-1.2 1-2 2-2.8 3 1.3 1.6 4.3 3.2 4.4 3zM369 664.4c.2-.2-1-5.4-2.6-7-1.4 1-3 2-4.3 3.5-4.2 4.5-4 11 2.5 16.7 1.6 1.5 2.4 0 1.7-1.7-1-2.7.3-6.3 3-11.5zM352.6 651c-4 1.6-5.4 3.7-5.2 6.4 0 1.5-1 2-1.5.3-4.8-11.2.2-13.3 7.5-13 .4 2-.7 6.2-.8 6.2z"
        />
        <path
          fill="#21231e"
          d="m384 621.3 1 .6h-.2v1.8h.2v.4h.2v.2h.2l.2.3.3.2v.2h.4l.2.3h.2l-.6 1h-.2l-.3-.2h-.2l-.2-.2-.2-.2-.3-.3-.3-.3v-.2h-.2v-.3l-.2-.2v-.2h-.2v-.2l-.2-.2V622l.2-.3v-.2zm6.5.8-.8 1-.2-.2-.3-.2-.2-.2-.2-.2h-.3l-.2-.3-.2-.3-.3-.2-.2-.2-.3-.2h-.7l-.2-.2h-.7v.2h-.2l-.2.2v.2h-.2v.3l-.2.2-1-.7v-.3l.2-.2.2-.2.2-.2.3-.3h.3l.2-.2h.4v-.2h.8l.2.2h.4l.2.2h.2l.2.2h.2l.2.3h.2l.2.3h.2l.3.3.2.3.2.2.3.2.2.2h.3z"
        />
        <path
          fill="#21231e"
          d="m387.3 617.6 1 .6v.4h-.2v.8l.2.2v.2l.2.2v.2l.2.2.2.3.3.2h.2l.2.2h.2l.2.2.2.2h.2l-.6 1h-.2l-.3-.2-.3-.3h-.2l-.2-.2-.2-.2-.2-.3v-.2h-.2l-.2-.2v-.2h-.2v-.5h-.2V618h.2v-.3zm6.5.8-.7 1-.2-.3h-.2l-.2-.3-.3-.2-.3-.3h-.2l-.2-.3-.2-.2-.3-.2-.3-.2h-.3v-.2h-.8l-.2.2-.2.2-.2.2v.2l-.3.2-1-.6.2-.3v-.2h.3v-.3h.3l.3-.3h.2l.2-.2h.2v-.2h1.4l.2.2h.2v.2h.3l.3.3h.2l.2.2h.2l.2.3h.2l.3.3v.2l.3.2.3.2.2.2z"
        />
        <path
          fill="#21231e"
          d="m391 612.8 1 .6-.2.2v.6h-.2v1l.2.3v.3h.2v.4h.2l.2.3v.2h.2l.2.2.2.2.3.3.3.2h.2l.2.2-.6 1-.3-.2-.2-.2-.2-.2-.3-.2-.2-.2v-.2l-.3-.2v-.2l-.3-.2v-.2l-.3-.2v-.4l-.2-.3v-.2h-.2v-.7h-.2v-1l.2-.3v-.4l.2-.3v-.2zm7 1-.8 1-.3-.3-.3-.2-.3-.3-.3-.2v-.2l-.3-.2-.3-.2-.2-.2-.2-.2-.2-.2h-.2l-.2-.2-.3-.2h-.2l-.2-.2h-.7l-.2.2-.2.2-.3.3v.2h-.2v.4l-1-.6v-.3l.2-.2.2-.3v-.2l.3-.2.2-.2v-.2h.3l.2-.2h.3l.2-.2h1.2l.2.2h.2l.2.2.3.2h.3l.2.3.2.2h.3l.2.3.3.2.2.2.3.2.2.2.3.2.2.3.3.2z"
        />
        <path
          fill="#21231e"
          d="m394.8 607.7 1 .5v.5l-.2.3v1.7l.2.2v.3l.2.2v.2l.2.2.3.3v.2l.3.2.2.2h.2l.2.3.2.2.3.2v.2l-.6.8-.3-.2v-.2l-.4-.2-.2-.3-.3-.3v-.2l-.3-.3-.2-.2v-.2l-.3-.3v-.2l-.3-.2-.2-.2v-.2l-.2-.2v-.3l-.2-.3v-2.1l.2-.2v-.2l.2-.3zm7.6 1.3-1 .8-.2-.3-.3-.3-.3-.2-.3-.3-.3-.3v-.2l-.4-.2-.2-.2-.2-.2-.2-.2-.2-.2h-.2l-.2-.2h-.2l-.2-.2h-.3v-.2h-.7v.2l-.3.2-.2.3-.2.2v.2l-.3.2v.2l-1.2-.5.2-.3.2-.3v-.2l.3-.3.2-.2.2-.2.3-.2.3-.2h.5l.3-.2h.8l.3.2h.2l.3.2h.2l.2.3.3.3.2.2.3.2.2.2h.3l.2.3.3.3.2.2.3.3.3.4.3.3.4.3z"
        />
        <path
          fill="#21231e"
          d="m399 602.6 1.2.6v.2l-.2.2-.2.3v2.1l.2.2v.2l.2.2.2.2v.2l.2.2.2.2.2.2v.2l.3.2.2.2.2.2.3.2.2.2.3.2-.8 1-.3-.3-.2-.3-.3-.2-.3-.3-.2-.2-.3-.2-.2-.3v-.2l-.3-.2-.2-.2v-.2l-.3-.2v-.3h-.2v-.4l-.2-.2v-.2l-.2-.3v-2.6l.2-.2v-.2l.2-.2v-.2zm7.7 1.4-1 .8-.2-.3-.3-.3-.2-.3-.3-.3-.3-.3-.2-.2-.2-.3-.3-.3-.2-.2h-.2l-.2-.3-.2-.2h-.2v-.2h-1.3l-.3.2v.2h-.2v.3l-.3.2-.2.3v.2l-1.2-.6.3-.3.2-.3.2-.2.2-.3v-.2l.4-.2h.2l.2-.2h.2l.2-.2h1.7l.2.2.2.2h.2l.2.3h.3l.3.3.2.3h.3l.2.3.3.3.2.2.3.3.3.4.4.3.3.3z"
        />
        <path
          fill="#fff"
          stroke="#21231e"
          d="m462.6 580.6-9.5-5.4c-4 3-6.8 13.5 0 22.2 8.5 11 12 18.7 14 27.5 6.2-8 8.3-16.3 4.4-24.5-5.3-11-8.7-17-8.8-20z"
        />
        <path
          fill="#fff"
          stroke="#21231e"
          d="m470.4 573-9.5-5.4c-4 3-12.5 13.2-5.6 22 8.5 10.8 17.3 19 19.4 27.7 6.2-8 8.8-16.2 5-24.4-5.4-11-9.4-17.2-9.4-20z"
        />
        <path
          fill="#fff"
          stroke="#21231e"
          d="m449.4 569.2-9.5-5.4c-4 3-7 13.5-.2 22.2a65 65 0 0 1 14 27.5c6.2-8 8.4-16.3 4.4-24.4-5.3-11-8.7-17-8.8-19.8z"
        />
        <path
          fill="#fff"
          d="M405.5 469c.2 8.7-1.4 66.5-1.8 74.7-.5 8.2-4 13.7-8 17-3.5-5-5.6-11.5-6-19.3-.4-4 .4-58.7.7-70 6.4-17 11.2-17.8 15-2.4z"
        />
        <path
          fill="#21231e"
          d="M404 543.8h-1l.2-1v-2.6l.2-1.7v-4l.2-2.3v-5l.2-2.7v-2.8l.2-3v-3l.2-3v-6.2l.2-3v-6.2l.2-3v-5.8l.2-2.7v-7.4l.2-2V469h1v11.7l-.2 2.5v8.3l-.2 2.8v6l-.2 3.2v3l-.2 3.2v6l-.2 3v3l-.2 2.8v5.3l-.2 2.5v2.3l-.2 2v3.6l-.2 1.5v2zm-8.7 17 .8-.5h-.6l.3-.4.4-.4.4-.3.4-.3.3-.4.5-.4.3-.3.3-.5.4-.4.4-.4.3-.4.4-.5.3-.4.2-.5.2-.5.3-.5.3-.5.2-.6.2-.5.3-.6.2-.5.2-.5v-.7l.3-.6v-.6l.3-.7v-.7l.2-.7v-.7l.2-.8v-1.5h1v2.3l-.2.7v.8l-.3.6v.8l-.3.7-.2.6-.2.8-.2.6-.2.6-.2.6-.3.6-.4.5-.2.6-.3.5-.2.5-.3.5-.3.5-.3.5-.4.4-.4.5-.3.4-.5.5-.3.4-.4.3-.3.4-.4.3-.2.4-.4.3-.4.3h-.7zm.7.2-.4.3-.3-.4h.7zm-7-19.5h1v.6l.2.8v1.4l.2.7v.6l.2.7v.6l.3.6v1.5l.3.5v.7l.3.6.2.6.2.6.2.6.2.5.2.7.2.6.2.5.3.6.2.5.3.4.2.6.3.5.3.5.3.5.2.4.3.4.3.5.3.3-.7.6-.3-.6-.4-.4-.3-.5-.3-.5-.3-.5-.3-.6-.2-.6-.3-.5-.4-.7-.2-.5-.3-.6v-.6l-.3-.5-.3-.5-.2-.6-.2-.7-.2-.6v-.7l-.3-.6-.2-.6v-.7l-.3-.5v-.7l-.2-.7-.2-.6v-.6l-.2-.7v-1l-.2-.8v-1.5zm1-70.2.8.3v8l-.2 2.3V492l-.2 2.7v11.6l-.2 3v19l-.2 2.2v11h-1v-20.9l.2-2.7v-14.6l.2-2.8V489l.2-2.6v-8.9l.2-2v-4.2zm0 0zm16-2.3h-1l-.4-1.3-.3-1.3-.4-1-.5-1.2-.4-1-.2-1-.4-.7-.4-.8-.4-.6-.4-.4-.4-.4-.4-.3-.3-.3h-.3l-.4-.2h-.7l-.4.3-.4.3-.5.5-.5.4-.5.5-.5.7-.5.7-.5.8-.5 1-.6 1-.5 1.2-.6 1.3-.6 1.3-.6 1.5-.6 1.6-1-.3.7-1.6.6-1.5.7-1.3.6-1.4.5-1.2.6-1 .5-1 .5-1 .5-.8.6-.7.5-.7.6-.6.6-.4.5-.4.6-.3.5-.2h1.1l.5.3.5.3.5.5.5.5.4.6.4.6.5.8.4.8.4 1 .5 1 .3 1 .4 1.4.4 1.3.4 1.4zm0 0z"
        />
        <path
          fill="#fff"
          d="m368 454.8-2.6 79.6c-.8 7 8.4 49 13.5 57.4 12.3-5.3 15-33.8 12.6-61.6-2.4-27.8.4-51.8 2.3-56.8 0-6.3-1-12.8-1-19.3-8 .5-17.2.4-25 .8z"
        />
        <path
          fill="#21231e"
          d="m365 534.4 2.4-79.6h1l-2.5 79.6h-1zm1 0zm12.7 57 .3.8-.6-.2-.5-1-.6-1-.5-1.2-.7-1.4-.5-1.6-.6-1.6-.6-1.8-.6-2-.5-2-.6-2-.7-2.2-.6-2.2-.6-2.3-.4-2.3-.6-2.3-.5-2.3-.6-2.3-.6-2.3-.4-2.2-.5-2.2-.4-2.2-.3-2-.4-2.2-.3-2-.3-1.8-.3-1.7-.2-1.6v-1.4l-.3-1.3v-2.8h1v4.1l.2 1.5.2 1.6.3 1.7.3 1.8.3 2 .4 2 .4 2.2.5 2.2.4 2.2.4 2.3.5 2.2.4 2.3.6 2.3.5 2.4.6 2.3.7 2.2.5 2.2.6 2 .6 2.2.6 2 .6 2 .5 1.7.7 1.5.6 1.5.5 1.4.5 1.2.5 1 .5 1-.6-.3zm.3.8-.4.2-.2-.4.6.2zm12-62h1l.3 2.5v2.7l.3 2.6v2.6l.2 2.6v12.5l-.3 2.4-.2 2.5-.2 2.3v2.3l-.4 2.3-.4 2.2-.3 2-.6 2-.4 2-.6 2-.5 1.7-.8 1.7-.6 1.5-.7 1.5-1 1.5-.7 1.3-1 1.2-1 1-1 1-1 1-1 .6-1.3.6-.3-1 1-.4 1-.7 1-.7 1-1 1-1 .7-1 .8-1.3.8-1.4.7-1.5.6-1.5.6-1.6.5-2 .5-1.7.5-2 .4-2 .3-2 .3-2 .3-2.3v-2.3l.4-2.3V558l.3-2.3V538l-.2-2.6-.2-2.6-.2-2.6zm2.4-56.8h1v.2l-.2.5-.2.7-.2.7-.2 1-.2.8-.2 1-.2 1.2v1.2l-.3 1.3-.2 1.3-.2 1.4v1.6l-.3 1.6v1.7l-.3 1.7v2l-.2 1.8v2l-.2 2V520l.2 2.5.2 2.5.2 2.6v2.5l-1 .2v-2.6l-.3-2.5-.2-2.5V520l-.2-2.5v-20.1l.2-2v-2l.3-2v-1.7l.2-1.7.2-1.8.2-1.6v-1.4l.3-1.5.2-1.3v-1.2l.3-1V477l.3-1 .2-.8.2-.7.2-.7.2-.5zm1 0v.2-.2zm-1.5-18.8v-1l.4.4v3.7l.2.6v2.5l.2.6v1.8l.2.6v2.4l.2.6v3.6l.2.6v2.4h-1V468l-.2-.5V465l-.2-.5v-1.9l-.2-.6v-1.7l-.2-.6v-3l-.2-.6V454l.5.6zm0-1h.4v.4l-.5-.4zm-24.6 1.2h-1l.4-.5h3.9l.8-.2h12.8l.8-.2h4.7l.8-.2h1.7v1h-4.1l-.7.2h-8l-.8.2h-7.1l-.8.2h-3.9l.4-.4zm-1 0v-.4h.4l-.4.4zm.5 0h.4-.5zm-.6 0v-.4h.4l-.4.4z"
        />
        <path
          fill="#fff"
          d="m353 468 1.8 79.5c-.4 7 11 48.5 16.4 56.5 12.6-9.8 10-49.8 8.2-62-4-24-3.2-52-2-56.5 0-6.3-.2-13.8-.6-20.4-8 1-15.8 2-23.7 2.8z"
        />
        <path
          fill="#21231e"
          d="m354.3 547.5-1.7-79.6 1-.2 1.7 79.6h-1zm1 0zm15.6 56 .5 1-.7-.2-.5-1-.6-1-.6-1.2-.5-1.2-.7-1.6-.6-1.6-.7-1.8-.7-1.8-.7-2-.5-2-.7-2.2-.7-2.2-.6-2.2-.7-2.3-.7-2.2-.7-2.3-.6-2.3-.6-2.3-.5-2.3-.6-2.2-.6-2.2-.5-2-.6-2-.4-2-.4-2-.4-1.6-.3-1.6-.3-1.3-.2-1.3v-1.2l-.2-1v-.8h1v1.8l.2 1 .2 1.3.2 1.5.2 1.5.3 1.7.4 2 .4 1.8.4 2 .5 2 .6 2.2.4 2.2.6 2.3.7 2.3.6 2.3.7 2.2.6 2.3.7 2.3.7 2.3.7 2.2.7 2 .7 2.2.8 2 .7 1.8.6 1.7.8 1.7.6 1.4.6 1.3.6 1.2.5 1 .6.7h-.7zm.5 1-.4.2-.2-.4h.7zM379 542l1-.2v1.2l.2 1.4.2 1.5.2 1.8.2 1.7v2l.3 2 .2 2v2l.2 2.3v12l-.2 2.4v2.3l-.3 2.4-.4 2.4-.3 2.4-.3 2.2-.4 2.2-.5 2.2-.4 2-.6 2-.7 2-.8 1.6-.8 1.7-1 1.5-1 1.3-1 1.4-1.2 1-.6-.8 1-1 1-1 1-1.4.8-1.4.8-1.6.8-1.7.6-1.8.6-2 .5-2 .6-2 .4-2.2.4-2.3.3-2.3.2-2.4v-2.3l.3-2.4V569l.2-2.2V560l-.2-2.3v-2.2l-.2-2v-2l-.2-2-.2-1.6-.2-1.8-.2-1.5v-1.3l-.3-1.2zm-2-56.7h1v.6l-.2.7-.2.7v1l-.2.8v2.4l-.2 1.3v2.8l-.2 1.6v15.2l.2 2v2.3l.3 2v2.4l.3 2.3v2.2l.3 2.2.4 2.3.2 2.4.3 2.2.2 2.3.3 2.2.4 2.3-1 .2-.5-2.3-.3-2.4-.3-2.3-.4-2.3-.2-2.4-.2-2.3-.2-2.3-.2-2.3-.2-2.2v-2.3l-.3-2.2V512l-.2-2v-16l.2-1.4v-1.3l.2-1.2v-2l.3-1v-.8l.2-.6v-.7.2zm1 0zm-1.2-20v-1l.5.6v3.4l.2.7v3.8l.2.6v6l.2.6v5.3h-1V480l-.2-.7v-5.7l-.2-.6v-4.5l-.2-.7v-2.4l.4.4zm0-1h.4v.6l-.5-.4zm-23.7 4v-1l.8-.2h.8l.7-.2h2.2l.7-.2h.8l.7-.2h.8l.7-.2h1.4l.7-.2h.8l.7-.2h.6l.8-.2h1.7l.6-.2h.7l.8-.2h.8l.7-.2h1.5l.8-.2h.7l.7-.2h.8l.7-.2v1h-.6l-.6.2h-.8l-.7.2h-1.6l-.7.2h-.8l-.8.2h-.8l-.7.2h-1.5l-.7.2h-.8l-.7.2h-.7l-.8.2H362l-.7.2h-.7l-.8.2h-.7l-.6.2H357l-1 .2h-.6l-.7.2h-.8l-.8.2zm.2 0zm0-1v1l-.6-.6.5-.6zm-.6.4v-.6h.5l-.4.5z"
        />
        <path
          fill="#fff"
          d="m342.2 486.7 21-.5c-2 8.6-.5 35.6 3.2 56.2 3.3 19.3 8 69.3-12 81.3-12.5-26.4-3-52-9.2-75-5-24.3-6-44.6-3-62z"
        />
        <path
          fill="#21231e"
          d="m363 486.7-20.8.5v-1l21-.5.4.6-.5.4zm0-1h.7v.6l-.6-.6zm3.8 56.6-1 .2-.3-2-.3-2-.3-2-.4-2-.3-2-.2-2-.2-2.2-.2-2-.2-2.2-.2-2-.2-2-.2-2-.2-2.2v-2l-.3-2v-2l-.2-2V499l-.2-1.7v-4.5l.2-1.4v-1.2l.2-1.2v-1l.3-1v-1l1 .3v.8l-.2 1v1l-.2 1.3v5.4l-.2 1.6v4.9l.2 1.8v4l.2 1.8v2l.3 2v2l.3 2 .2 2v2l.3 2.2.3 2 .2 2.2.3 2 .3 2 .3 2 .3 2.2.2 2 .3 2 .3 2zM354 624l.8-.6-.7-.2 2-1.2 1.5-1.4 1.5-1.6 1.4-1.8 1.3-2 1-2 1-2.3 1-2.6 1-2.5.6-2.8.6-2.7.4-2.8.4-3 .4-3 .3-3 .2-3v-3l.2-3v-6.2l-.2-3-.2-3v-3l-.4-3-.2-2.7-.3-2.7-.2-2.5-.4-2.5-.2-2.4-.3-2.2-.3-2-.3-2h.8l.4 1.8.3 2 .3 2.3.3 2.3.4 2.5.3 2.7.3 2.7.2 2.8.2 3 .2 2.8.2 3v15.5l-.3 3-.3 3.2-.4 3-.4 2.8-.5 3-.8 2.7-.7 2.7-.8 2.6-1 2.4-1 2.4-1.2 2.2-1.3 2-1.4 2-1.6 1.5-1.7 1.5-1.8 1.3h-.7zm.7 0-.5.4-.3-.5h.7zm-10-75.2 1-.2.5 2.2.4 2.2.4 2.2.3 2.2.3 2.2.2 2.3v2l.2 2.4v25.4l.2 2.4v2.4l.3 2.4.3 2.4.3 2.4.5 2.4.4 2.4.5 2.4.7 2.5.7 2.4.8 2.5 1 2.5 1 2.4-.8.5-1.2-2.6-1-2.5-.8-2.6-.8-2.5-.7-2.5-.5-2.5-.5-2.4-.4-2.5-.2-2.3-.3-2.5-.2-2.4V594l-.2-2.4V564l-.2-2.3-.2-2.3-.2-2.2-.4-2.2-.3-2-.5-2.3-.5-2v-.2zm0 0zm-2.5-62.6v1l.5-.4-.3 1.6-.2 1.7-.2 1.7-.2 1.7-.2 1.7v1.8l-.3 1.8v3.5l-.2 2v7.3l.2 2v1.8l.2 2v2l.2 2 .2 2 .2 2 .2 2 .3 2 .2 2 .3 2.3.3 2 .3 2.2.4 2.2.4 2.2.4 2 .4 2.4.4 2.2-1 .2-.4-2.2-.4-2.3-.4-2.2-.4-2-.3-2.3-.4-2.2-.3-2-.3-2.2-.2-2-.3-2.2-.2-2-.2-2-.2-2v-2l-.2-2v-2l-.2-1.8v-13l.2-1.8v-1.8l.2-1.7.2-1.7.2-1.7.2-1.7.2-1.7.3-1.7.5-.4zm-.5.4v-.4h.5l-.5.4zm.5 0v-.4.5zm-.5 0v-.4h.5l-.5.4z"
        />
        <path
          fill="#fff"
          d="M422 454.4c0 8.7-3.2 66.5-4 74.6-.7 8-4.5 13.6-8.4 16.6-3.4-5-5.3-11.5-5.5-19.3 0-4 2.3-58.7 3-70 7-17 11.8-17.4 15-2z"
        />
        <path
          fill="#21231e"
          d="M418.5 529h-1v-1l.2-1v-1.5l.2-1.7v-2l.2-2v-2.3l.3-2.4v-2.5l.3-2.7.2-2.8v-3l.3-3 .2-3 .2-3v-3l.3-3.2.2-3 .2-3.2v-3l.3-3V474l.3-3v-2.5l.2-2.4V464l.2-2v-2l.2-1.8v-3.7h1v5.6l-.2 2v2l-.2 2.3v2.6l-.3 2.6-.2 2.7v2.8l-.3 3-.2 3v3l-.3 3-.2 3v3.2l-.3 3-.2 3.2-.2 3v3l-.2 2.7-.2 2.6v2.6l-.3 2.4v2.3l-.3 2v2l-.2 1.5v1.5l-.2 1.2v1zm-9.3 17 .8-.6-.7-.2.4-.2.3-.3.4-.4.3-.3.4-.3.4-.4.4-.3.3-.4.4-.4.4-.4.3-.5.4-.4.3-.6.3-.4.3-.5.3-.5.3-.5v-.5l.4-.6.2-.5.3-.7v-.6l.3-.6.2-.5.2-.7.2-.6V532l.3-.8v-.8l.2-.7v-.7h1v1.6l-.2.7-.2.7v.7l-.2.7-.2.7-.2.8-.2.6-.2.6-.2.6-.3.6-.2.6-.3.6-.3.5-.2.5-.3.5-.3.5-.5.5-.3.5-.3.4-.4.4-.4.4-.3.4-.5.4-.4.4-.2.4-.4.3-.4.4-.3.4-.4.3-.4.3h-.8zm.7 0-.5.4-.3-.5h.7zm-6.4-19.7h1v2.8l.2.8v.7l.2.7v1.2l.3.6v.8l.2.6.2.7v.7l.3.6v.6l.3.5.2.6.2.6.2.6v.6l.3.5.3.6.2.4.2.5.3.5.3.5.2.5.3.4.4.4.3.5.3.4-.8.5-.3-.6-.4-.4-.3-.5-.3-.6-.3-.6-.3-.5-.3-.6v-.6l-.4-.5-.2-.6-.2-.6-.2-.4-.2-.6-.2-.6-.2-.6-.2-.6-.2-.7-.2-.6v-.7l-.3-.7v-.6l-.2-.7v-.6l-.2-.7v-1.4l-.2-.7v-1.5l-.2-.7v-1.5zm3-70 .8.3v-.2 2.6l-.2 1.6v2l-.2 2v2l-.2 2.4v2.5l-.2 2.6v2.8l-.3 2.8v2.8l-.2 3v2.8l-.2 3v3l-.2 2.8v3l-.3 2.7v2.7l-.2 2.7v7.3l-.2 2v3.8l-.2 1.6v3.3h-1v-6.8l.2-2V513l.2-2.4V508l.2-2.6.2-2.8v-2.8l.2-3V494l.2-3 .2-2.8v-3l.2-2.8v-3l.3-2.7V474l.2-2.5V469l.2-2.4v-4.2l.2-1.8V459l.2-1.5v-1.2zm-.2 0zm16.2-2h-1v.2l-.3-1.4-.3-1.2-.3-1.2-.4-1-.3-1-.4-1-.3-1-.4-.6-.5-.6-.4-.5-.2-.5-.4-.4h-.4l-.3-.2h-1.1l-.4.2-.5.2-.4.4-.5.5-.5.6-.6.7-.5.7-.5 1-.6.8-.5 1-.6 1.2-.7 1.2-.6 1.4-.6 1.4-.6 1.6-1-.4.7-1.6.8-1.4.6-1.4.6-1.2.6-1.2.6-1 .6-1 .6-1 .6-.7.5-.7.6-.6.6-.6.6-.4.5-.3h.6l.5-.3h1.2l.5.3.5.4.5.4.4.5.4.6.4.5.4.8.3 1 .4.8.3 1.2.3 1 .4 1.3.3 1.4.3 1.3zm0 0zm-.5 0h.6-.5zm.6 0z"
        />
        <path
          fill="#fff"
          d="M385 407.2c-.6 18.7-1 59-.8 62.6a51 51 0 0 0 6.7 22.6c4-3 7.7-8.5 8.4-16.6.6-6.7.8-39.5 1-56-4.3-2.6-8.7-6-12.2-9.7l-3.2-2.8z"
        />
        <path
          fill="#21231e"
          d="M384.7 469.8h-1v-23.4l.2-2.4v-19.6l.2-2.4v-9l.2-2v-3.8h1v7.8l-.2 2.4v9.4l-.2 2.5v12.5l-.2 2.4v25.4zm6 22.2.5.8h-.7l-.3-.6-.3-.5-.4-.6-.4-.4-.3-.6-.4-.6-.3-.7-.3-.6-.2-.6-.3-.7-.3-.7-.3-.7-.3-.7-.3-.8-.2-.7-.3-.7-.3-.8-.2-.8-.2-.7-.2-.8v-.8l-.3-.8v-.8l-.3-.8v-.8l-.2-.8v-.8l-.2-.8v-.7l-.2-.7v-1.5h1v2.5l.2.8v.8l.3.7v.8l.2.8.2.8.2.8v.7l.2.7.3.8.2.7.2.8v.8l.4.7.2.7.3.7v.7l.4.6.3.7.3.7.2.6.3.6.3.5.3.6.4.6.3.6.3.5.3.4h-.7zm.5.8-.4.3-.3-.3h.7zm7.7-17h1l-.2.8v.8l-.2.7v.8l-.3.7-.2.7v.7l-.2.5-.2.7-.2.6-.3.6v.6l-.4.6-.2.6-.3.5-.2.5-.3.6-.3.5-.3.5-.4.4-.4.5-.3.4-.5.6-.3.4-.4.4-.3.4-.4.4-.3.3-.3.4-.4.2-.4.3-.4.3-.6-.8.4-.3.3-.3.4-.3.4-.2.4-.4.4-.3.3-.3.4-.4.4-.4.3-.5.4-.4.3-.3.3-.5.3-.5.3-.4.3-.5.2-.6.3-.5.2-.5.3-.6.2-.6.2-.5.2-.6.2-.8.2-.6.2-.6v-.7l.3-.7v-.7l.2-.8v-.7l.2-.8zm1-55.5.6-.8.2.4v18.8l-.2 2.2v14.6l-.2 2v8.9l-.2 1.5v4.3l-.2 1v2.6h-1V471l.2-1.5v-6.3l.2-1.8v-12l.2-2v-20.8l.2-1.7v-5.1l.2.3zm.6-.8h.2v.4l-.2-.5zm-12.4-9.8v1l.4-1 .3.4.2.5.4.3.3.3.3.5.3.3.4.3.3.4.4.4.3.3.4.4.4.3.4.3.3.3.4.3.3.4.4.3.4.3.5.3.3.2.4.2.4.3.4.3.4.3.4.3.4.3h.4l.4.4.4.3.4.2.4.2.4.3-.6.8-.4-.3-.4-.2-.4-.3-.4-.3-.4-.2-.4-.3-.4-.3-.4-.3-.4-.2-.4-.3-.4-.3-.4-.3-.4-.4-.3-.3-.4-.3-.3-.3-.4-.3-.4-.3-.5-.2-.4-.3-.2-.3-.4-.4-.4-.3-.3-.3-.4-.3-.4-.5-.4-.3-.4-.3-.3-.5-.5-.3-.3-.4-.3-.3.2-.8zm-.3.8-1-.8h1.2l-.3.8zm-2.5-3.3h-1l1-.3.2.2.2.2v.2h.3v.3h.4v.2l.3.2.3.2v.2h.3v.2h.2v.2h.3l.2.2v.2h.2v.2l-.2.8v-1l-.3 1h-.2v-.2h-.2v-.2h-.2v-.2h-.2l-.2-.2v-.2h-.2l-.2-.2-.3-.3h-.3v-.3h-.3v-.2l-.2-.2h-.2v-.2h-.2v-.2h-.2v-.2h-.2l1-.4zm-1 0v-1.4l1 1-1 .4z"
        />
        <path
          fill="#fff"
          d="M400 419.3c-.4 20-.2 51.7 0 54.3a34 34 0 0 0 5.4 19.3c4-3.2 8-8.8 8.8-17 .5-5 2-26.4 2-42.8-5.3-1.7-12-10.4-16.3-14z"
        />
        <path
          fill="#21231e"
          d="M400.4 473.5h-1v-12.9l-.2-1.7v-33.7l.2-2v-4h1v14.5l-.2 2v37.1l.2.5v.3zm4.7 19 .7.8h-.7l-.3-.6-.3-.5-.3-.5-.2-.5-.3-.5-.3-.5-.2-.6-.3-.5-.2-.5-.3-.5-.2-.6-.2-.6-.2-.6-.2-.6-.2-.6-.2-.6-.2-.6v-.6l-.3-.7v-.6l-.3-.8v-.6l-.2-.7v-.8l-.2-.6v-.7l-.2-.8v-1.5l-.2-.7v-1.4h1v2.8l.2.7v.7l.2.7v.7l.2.7v.7l.2.6v.7l.3.6v.6l.3.5v.6l.3.7.3.6.2.6.2.5.2.5v.6l.4.5.2.7.3.5v.5l.4.5.2.5.3.5.2.5.3.5.3.4h-.7zm.7.8-.4.3-.3-.4h.7zm8-17.3h1v1.7l-.3.7v.7l-.3.8v.7l-.2.7-.2.7-.2.5-.3.7v.6l-.4.6-.2.6-.3.5-.2.6-.3.6-.4.6-.2.5-.3.5-.4.5-.2.4-.4.6-.3.4-.3.5-.3.4-.4.3-.4.3-.4.4-.3.3-.5.4-.4.3-.3.3-.6-.8.5-.3.3-.3.4-.4.4-.3.3-.4.3-.4.3-.4.4-.4.3-.4.4-.4.3-.5.3-.4.4-.4.3-.5.3-.3.3-.6.3-.4.2-.5.3-.5.2-.5.3-.6.2-.6.2-.6.2-.6.2-.7.2-.7.2-.7v-.7l.3-.8v-.7l.2-.7v-.8zm2.4-42.3.4-1 .3.5v7.9l-.2 1.6v5.1l-.2 1.6v1.7l-.2 1.7v4.6l-.2 1.6v2.9l-.2 1.3v1.4l-.2 1.3v2.5l-.2 1v2.2l-.2 1v1.6l-.2.7v1.1h-1v-2l.2-.8v-1.8l.2-1v-2.2l.2-1.2v-2.7l.2-1.3v-1.5l.2-1.4V457l.2-1.6v-1.6l.2-1.6V449l.2-1.6V443l.2-1.6V433l.5.5zm.4-1h.3v.5l-.3-.5zm-16-13.4h-1l.8-.4.5.2.4.4.5.4.5.4.5.5.4.4.4.4.5.5.4.6.5.4.4.5.5.4.5.6.5.5.5.5.5.6.6.5.5.6.7.5.5.6.5.5.6.5.5.5.5.4.6.4.4.4.5.3.4.3.5.3.4.3.5.2.4.2-.3 1-.5-.2-.5-.3-.5-.2-.6-.3-.6-.4-.6-.3-.5-.4-.6-.4-.5-.4-.6-.5-.5-.5-.5-.5-.5-.5-.6-.5-.5-.5-.7-.5-.5-.6-.5-.5-.6-.5-.5-.6-.5-.4-.5-.5-.5-.5-.5-.5-.5-.5-.5-.4-.4-.4-.5-.4-.4-.5-.6-.4-.4-.3-.4-.4.8-.3zm-1 0v-1l.8.6-.8.2z"
        />
        <path
          fill="#fff"
          d="M387 405.6 373 385c-2.8 10.2-6.3 82.8-2.2 88.8a36 36 0 0 0 6.4 19.3c4-3 9.8-8.5 8-16.7-1.6-8.2.4-62.3 2-70.7z"
        />
        <path
          fill="#21231e"
          d="m373.3 384.7 14.2 20.6-.8.5-14.3-20.5v-.4l1-.3zm-1 .2.4-1 .5.7-.8.2zm-1.2 88.7h-1l.2.3-.5-.8-.3-1.2-.3-1.5v-1.8l-.3-2-.2-2.5v-2.6l-.2-2.8v-20.3l.2-3.7V431l.2-4 .2-3.6v-3.8l.3-3.7.2-3.7.2-3.4.3-3.5.2-3.2.3-3 .2-3 .3-2.5.3-2.4.2-2 .3-2 .3-1.3.4-1 1 .2-.3 1-.2 1.5-.3 1.8-.3 2-.2 2.4-.3 2.5-.3 2.8-.2 3-.3 3.3-.3 3.3-.2 3.4-.2 3.6-.2 3.7v3.7l-.3 3.8v3.8l-.2 3.7v3.8l-.2 3.6v19.6l.2 2.6.2 2.3.2 2v1.8l.4 1.5.3 1 .3.7v.2zm0-.2v.2-.2zm5.7 19.2.6.8-.7-.2-.3-.4-.3-.6-.3-.5-.3-.6-.3-.5-.2-.6-.3-.6-.3-.5-.3-.6-.4-.5-.2-.6-.3-.6v-.6l-.4-.6-.2-.6-.2-.6-.3-.6-.3-.6-.2-.7v-.6l-.3-.5-.2-.7v-.7l-.3-.6v-.6l-.2-.7v-.6l-.2-.7v-1.5l-.2-.7v-.7h1v1.4l.2.7v.6l.2.6v.7l.2.6v.7l.2.6.2.6v.6l.3.6.2.7.2.6.2.7v.6l.3.6.2.5.3.6.2.6.3.6.2.5.3.6.3.5.3.5.3.6.3.4.2.5.3.4.3.4.3.5.4.5h-.7zm.6.8-.4.3-.4-.5.7.2zm7.4-17 1-.3v.8l.2.7v3l-.2.7-.2.7v.7l-.3.7-.2.6-.2.6-.2.6-.3.6-.3.5-.4.6-.3.4-.4.5-.5.4-.3.5-.4.4-.4.4-.4.4-.5.5-.4.4-.3.5-.4.3-.4.4-.5.3-.4.3-.3.4-.4.3-.6-.8.4-.3.5-.3.4-.2.3-.4.3-.3.4-.3.4-.4.4-.3.4-.4.4-.5.4-.3.4-.4.4-.5.3-.5.5-.5.3-.5.3-.5.4-.5.3-.5.2-.6v-.6l.3-.5.2-.5.2-.7v-.6l.2-.6v-3.1l-.2-.7v-.6zM387 406v-1l.6.7-.2 1-.2 1v1.4l-.3 1.7-.2 2-.2 2v2l-.3 2.4v2.5l-.3 2.6v2.8l-.2 2.7-.2 2.8v3l-.2 2.8v3l-.2 3v8.5l-.2 2.8v13.5l.2 2v1.5l.2 1.4v1l.2 1-1 .2v-1l-.2-1v-1.5l-.2-1.7v-4l-.2-2v-15.5l.2-3V441l.2-3v-2.8l.2-3 .2-2.7v-2.8l.2-2.7.2-2.5V419l.3-2.3v-2.2l.3-2v-2l.3-1.5.3-1.4v-1.2l.3-1 .5.7zm0-1h.7v.7l-.6-.6zm0 0v1l-.3-.2.4-.7zm0 1h-.2v-.2l.3.3z"
        />
        <path
          fill="#fff"
          d="M358 451.2c-.8 11.3-1.2 19-1 23 .2 7.6 2 14.2 5.5 19.2 4-3 9-8.5 8.4-16.6-2-31.5 1.4-61 5.4-89.6-3.4-2.5-9-5-12.5-7.6-6.8 38.3-9 62-6 71.6z"
        />
        <path
          fill="#21231e"
          d="M357.4 474h-1v-7.4l.2-.7V463l.2-.7V459l.2-1v-1.8l.2-1v-3l.2-1h1v2l-.2 1v2l-.2 1v2.8l-.2.7v3.2l-.2.7v4.2l-.2.6v4.3zm4.8 19 .6.8h-.7l-.3-.6-.3-.5-.3-.5-.2-.5-.2-.5-.3-.5-.3-.6-.2-.4-.3-.6-.2-.5-.3-.6-.2-.7-.2-.6-.2-.6-.2-.5-.2-.6v-.7l-.3-.6v-.7l-.3-.6v-.7l-.2-.6-.2-.6v-.7l-.2-.7v-1.4l-.2-.7v-1.5l-.2-.7v-.7h1v2.2l.2.7v1.2l.2.7v.6l.2.6v.7l.2.5.2.7v.6l.3.6v.6l.3.6.2.6.2.6.2.6.2.6.2.5.2.6.2.6.3.6.2.5.2.5.2.5.3.5.3.5.3.5.3.5.3.4h-.8zm.6.8-.4.3-.3-.3h.8zm7.6-17h1v3.7l-.3.7v.6l-.2.7v.7l-.4.6-.2.6-.2.6-.3.6-.3.6-.3.5-.2.6-.3.5-.4.5-.2.5-.4.4-.4.5-.4.4-.3.6-.4.4-.5.4-.4.4-.3.4-.4.3-.4.3-.5.4-.4.3-.2.3-.6-.8.3-.3.4-.3.3-.3.3-.2.4-.4.4-.3.4-.3.4-.4.3-.4.4-.5.3-.4.3-.4.4-.4.3-.5.3-.5.3-.5.2-.5.3-.5.3-.5.2-.6.3-.6.2-.5.2-.6.2-.8v-.6l.2-.6v-.7l.2-.6v-3.1zm5.7-89.2.7-.8.2.5-.5 2.6-.4 2.6-.3 2.7-.3 2.7-.4 2.7-.3 2.7-.3 2.7-.4 2.8-.3 2.8-.3 2.7-.3 2.8-.2 2.8-.2 2.8-.3 2.7-.2 2.8v3l-.3 2.7-.2 2.8-.2 2.8v2.8l-.2 3v8.5l-.2 3v8.6l.2 3v3l.2 2.8.2 3h-1l-.2-3v-3l-.2-2.8v-5.8l-.2-3V451l.2-2.8v-3l.2-2.7v-2.7l.3-3 .2-2.7.2-2.8V428l.3-2.7.3-2.8.3-2.8V417l.4-2.8.3-2.7.3-2.8.4-2.7.3-2.7.4-2.7.4-2.7.4-2.8.3-2.7.5-2.7.4-2.7v.6zm.7-.8.2.2v.3l-.3-.5zm-12.3-7-1-.3.8-.3.3.2.4.2.2.3h.3l.4.3.3.3.4.2.4.2.5.3.4.2.3.2.4.3.4.2.5.3.5.2.4.2.4.2.4.2.5.3.4.2.5.2.4.2.3.2.4.3h.4l.5.4.4.2.3.2.3.3.4.3.3.3.4.2-.6.8-.2-.2-.4-.3h-.3l-.3-.3-.3-.3-.4-.2-.4-.2-.4-.3-.4-.2-.4-.2-.4-.3-.4-.2-.4-.3-.5-.2-.4-.2-.4-.2-.5-.2-.5-.3-.4-.2-.4-.2-.4-.2-.4-.2-.4-.3h-.4l-.4-.4-.4-.2-.4-.2-.4-.3-.4-.3-.3-.3-.4-.2-.4-.2.8-.3zm-1-.3.2-.8.6.5-.8.3zm-6 71.4.8.6-.8-.2-.3-1v-1l-.3-1-.2-1.3v-1l-.2-1.4V443l-.2-1.6v-5l.2-1.8v-2l.2-2 .2-2 .2-2.3.2-2.3.2-2.5.3-2.4.3-2.5.3-2.6.4-2.8.4-2.8.4-3 .4-2.8.5-3 .6-3.2.5-3.2.6-3.3.6-3.5.6-3.5.6-3.5 1 .2-.6 3.5-.6 3.5-.6 3.4-.5 3.3-.4 3.3-.5 3-.4 3-.4 3-.4 3-.4 2.7-.3 2.7-.3 2.7-.3 2.5-.2 2.4-.3 2.4-.3 2.3v2.2l-.3 2v2l-.2 2v9.8l.2 1.4v1.2l.3 1 .2 1.2v1l.4 1-1-.3zm.8.6-.5.6-.3-.8.8.2zm0 0-.7-.7 1 .3-.3.3zm-.7-.7 1-1v1.3l-1-.4z"
        />
        <path
          fill="#fff"
          d="m343.6 471.8 4 14.7c.2 7.7 5 14 8.3 19 4-3 7.5-8 6.5-16-5.8-46.5-3.8-77.3 6-115-22 15-32.3 46.6-25 97.3z"
        />
        <path
          fill="#21231e"
          d="m347 486.6-3.8-14.7 1-.3 3.8 14.6-1 .3zm1-.3zm7.6 19 .6.7h-.7l-.3-.6-.3-.5-.4-.5-.4-.5-.3-.5-.5-.6-.3-.6-.4-.5-.3-.7-.4-.5-.2-.6-.4-.5-.3-.6-.2-.5-.4-.6-.3-.7-.2-.6-.3-.6-.3-.5-.3-.7-.3-.6-.3-.7-.2-.7-.2-.6-.2-.7-.2-.7-.2-.7v-.6l-.2-.7v-.8l-.2-.8v-.7h1v1.4l.2.7v.7l.2.7.2.6v.6l.3.7v.5l.4.7.2.6.3.6v.6l.4.7.3.6.3.6.3.4.3.6.4.6.3.6.3.5.4.6.3.5.4.5.3.6.3.4.4.5.3.4.4.5.3.4.3.5.4.3h-.8zm.6.7-.4.3-.3-.4h.8zm5.8-16.5h1v5.5l-.2.6v.7l-.3.6v.4l-.3.6-.2.6-.3.5-.2.6-.2.5-.3.6-.3.5-.3.6-.3.4-.2.4-.3.4-.4.5-.2.3-.3.4-.4.4-.3.3-.3.4-.4.4-.4.3-.3.3-.7-.8.4-.3.4-.4.3-.3.4-.3.4-.3.3-.4.4-.3.4-.4.3-.4.3-.4.3-.4.3-.4.3-.4v-.5l.4-.3.2-.5.2-.5.2-.5.2-.5.2-.5.2-.6v-.6l.2-.5v-.6l.2-.7v-5.1zm6.8-114.7-.6-1 .8.7-1 3.5-.8 3.5-.8 3.4-.7 3.4-.7 3.4-.7 3.3-.6 3.5-.6 3.4-.4 3.2-.5 3.3-.3 3.4-.4 3.2-.4 3.4-.4 3.3-.2 3.3-.2 3.4-.2 3.4v3.6l-.2 3.5v14.7l.3 3.7.3 4 .2 3.8.3 4 .4 3.8.3 4 .5 4.2.4 4.3.6 4.4h-1l-.6-4.2-.4-4.3-.5-4.2-.3-4-.4-4-.3-4-.2-3.8-.2-3.8v-3.7l-.2-3.7v-14.3l.2-3.4.2-3.4.2-3.4.2-3.4.3-3.3.3-3.4.4-3.3.4-3.3.6-3.4.5-3.3.7-3.4.6-3.3.7-3.4.7-3.4.8-3.5.8-3.4.8-3.5 1-3.6.8.6zm-.6-1 1-.6-.2 1.3-.8-.6zm-24 98h-1l-.7-4.6-.5-4.6-.5-4.5-.3-4.3-.3-4.2-.2-4.2v-8l.2-3.8.2-3.7.3-3.7.4-3.4.5-3.4.6-3.3.8-3.3.7-3 1-3 1-3 1-2.8 1-2.8 1.2-2.5 1.3-2.5 1.4-2.4 1.5-2.3 1.4-2 1.6-2.2 1.7-2 1.7-2 2-1.6 1.8-1.7 2-1.6 2-1.5.6.8-2 1.4-2 1.6-1.8 1.6-1.8 1.7-1.8 2-1.6 2-1.6 2-1.5 2-1.4 2.3-1.4 2.4-1.4 2.4-1.2 2.6-1 2.7-1 2.7-1 3-1 3-.7 3-.7 3-.6 3.4-.5 3.3-.5 3.5-.3 3.6-.3 3.7-.2 3.8v12l.4 4.4.3 4.3.5 4.5.5 4.6.6 4.7zm-1 0zm.4 0h.5-.4zm-.4 0z"
        />
        <path
          fill="#fff"
          d="m344.8 486.2-20.3-6.7c-2.5 20.2 1.4 45.6 7 79 4.6 29 2 51.6-1.5 66.2 21.6-3 30.7-30.7 20-83-3-13.7-5.8-31.3-5.2-55.5z"
        />
        <path
          fill="#21231e"
          d="m324.7 479 20.2 6.7-.4 1-20.2-6.7-.3-.6.7-.4zm-.6.4v-.6l.7.2-.6.4zm8 79-1 .3-.6-3-.5-3.2-.6-3-.5-3-.5-3-.5-2.8-.4-3-.4-2.7-.4-2.7-.4-2.7-.4-2.7-.3-2.7-.4-2.6-.3-2.6-.3-2.4-.2-2.5-.3-2.3-.2-2.4-.2-2.4v-2.4l-.3-2.3V500l-.2-2v-10.7l.2-2 .2-2v-2l.4-2 1 .3-.2 2-.2 1.8v2l-.2 2v4l-.2 2v4.3l.2 2.3v2.3l.2 2.3.2 2.3.2 2.2.2 2.4.3 2.4.2 2.5.3 2.5.3 2.5.3 2.6.4 2.8.4 2.6.3 2.7.4 3 .6 2.7.4 2.8.4 3 .5 3 .4 2.8.5 3 .4 3 .5 3.2zm-2 65.8v1l-.5-.6.4-1.4.2-1.4.3-1.5.3-1.5.3-1.6.4-1.6.3-1.7.2-1.8.2-1.7.2-1.8.2-2 .2-1.8v-2l.3-2 .2-2v-2l.2-2v-13.4l-.2-2.3-.2-2.4-.2-2.4-.2-2.5-.3-2.5-.3-2.6-.3-2.6-.4-2.6-.4-2.7 1-.2.3 2.7.4 2.7.3 2.5.3 2.6.3 2.6.2 2.5.2 2.6v2.4l.3 2.4v6.8l.2 2.3v4.3l-.2 2v2l-.2 2v2l-.2 2-.2 2-.2 1.8-.3 1.8v1.8l-.4 1.7-.2 1.8-.3 1.6-.2 1.6-.3 1.5-.3 1.5-.4 1.5-.3 1.4-.5-.8zm0 1h-.6v-.6l.7.6zm19.4-83.5 1-.2 1 5 .8 4.6.7 4.6.5 4.5.5 4.3.4 4 .3 4 .2 4v7.2l-.2 3.4-.2 3.2-.4 3-.4 3-.6 3-.6 2.6-.7 2.6-1 2.4-1 2.3-1 2.2-1 2-1.2 1.8-1.3 1.7-1.4 1.5-1.4 1.4-1.5 1.3-1.5 1-1.8 1-1.8.7-2 .7-2 .5-2 .2v-1l2-.3 1.8-.6 1.8-.6 1.7-.8 1.6-1 1.5-1 1.5-1 1.4-1.5 1.3-1.5 1.3-1.6 1-1.8 1.2-2 1-2 1-2.2.7-2.3.6-2.4.7-2.7.5-3 .4-2.8.4-3 .2-3.3v-3.5l.2-3.5v-3.7l-.3-3.8-.3-4-.3-4-.4-4.3-.7-4.4-.8-4.5-.8-4.7-1-5zm-4.8-55 .3-1 .3.5V503l.2 2 .2 1.8v2l.2 1.8v1.8l.2 1.8.2 1.7.2 1.8.2 1.7.2 1.7.2 1.6.2 1.6.2 1.6.2 1.5.3 1.5.3 1.5.3 1.5.2 1.4.3 1.4.3 1.4.3 1.4.3 1.3v1.3l.4 1.2-1 .2-.2-1.3-.3-1.3-.4-1.2-.2-1.4-.3-1.4-.2-1.4-.2-1.4-.3-1.5-.2-1.5v-1.5l-.4-1.6-.2-1.5-.2-1.6-.2-1.7-.2-1.7-.2-1.7-.2-1.8-.2-1.8v-1.7l-.3-2-.2-1.7v-2l-.3-1.8v-4l-.2-2v-13l.3.5zm.3-1 .3.2v.2l-.4-.5z"
        />
        <path
          fill="#21231e"
          d="M343.6 584h1v.7h-.8v-.2h-.2v-.4zm-4.3-40 1-.4.4 1.2.2 1.2v1l.4 1.3.2 1.3.2 1.2.2 1.2.2 1.2.2 1.3.2 1.3.2 1.2.2 1.3.2 1.3.2 1.2.2 1.3v1.4l.3 1.3v2.6l.3 1.3v1.3l.2 1.2v2.6l.2 1.3v9.1h-1v-7.6l-.2-1.2v-2.7l-.2-1.3V570l-.2-1.3v-1.3l-.2-1.3v-1l-.3-1.4v-1.3l-.3-1.3-.2-1.3v-1.2l-.3-1.3-.2-1.3-.2-1.3-.2-1.3v-1.2l-.4-1.2-.2-1.2-.2-1.2-.2-1.2-.3-1.2-.2-1.2-.2-1.2zm-5.5-50.4h1.2v6.4l.2 1.5v3.3l.2 1.5v1.6l.2 1.5v1.6l.3 1.5v3.1l.3 1.5.2 1.7v1.5l.3 1.6.2 1.5.2 1.6.2 1.4.2 1.6.3 1.5v1.6l.4 1.6.2 1.6.3 1.6.2 1.5.3 1.6.3 1.5.3 1.5.4 1.6-1 .3-.5-1.7-.4-1.6-.3-1.6-.3-1.5-.3-1.5-.2-1.6-.3-1.6-.2-1.5-.3-1.6-.2-1.6-.2-1.4-.3-1.6-.2-1.5-.2-1.6v-1.7l-.3-1.5-.2-1.6v-1.5l-.2-1.6v-1.4l-.2-1.6-.2-1.6V508l-.2-1.7V503l-.2-1.4v-6.4l-.2-1.6zm1.2 0h-1.2v-.2h.2v-.2h.2v-.2h.8v.2h.2v.4z"
        />
        <path
          fill="#fff"
          d="m344 367.3 13.2 2.2-4.6 23.3c-5 24.3-8.2 53-4.5 84.2 1.5 11.7 4 21.2 7.6 28.5-14.6-1.6-24-15.8-22.7-40.6-2.6-29-1.5-52 3.2-69.4 1.4-5 5.8-24.2 7.8-28.3z"
        />
        <path
          fill="#21231e"
          d="m357 370-13-2.3v-1l13.3 2.3.4.6-.6.4zm.3-1h.5v.6l-.5-.6zm-4.2 24-1-.3.2-.3v-.4l.2-.5v-.6l.2-.7v-.6l.3-.7v-.8l.2-.8v-1l.3-.7.2-1 .2-1v-.8l.2-1 .2-1 .2-1 .2-1 .2-1 .2-.8v-1l.3-.7.2-1v-.7l.3-.7v-.7l.3-.6v-.6l.2-.5v-.4l.2-.3v-.3l1 .2v.6l-.2.5v.5l-.3.6v.5l-.2.7-.2.8-.2.8v1l-.3.7-.2 1v.8l-.2 1-.2 1-.2 1-.2.8-.2 1-.2 1v1l-.3 1-.2.7-.2 1v.7l-.2.7v1l-.2.5-.2.6v.7l-.2.5v.7zm-4.4 84h-1l-.3-2.8-.3-3-.3-3-.2-2.8v-2.8l-.3-3V457l-.2-3v-11l.2-2.7v-2.7l.2-2.7.2-2.8.2-2.6.2-2.6.3-2.6.2-2.6.3-2.6.3-2.5.4-2.5.4-2.5.4-2.5.3-2.4.4-2.4.3-2.4.5-2.4.4-2.3.5-2.3.4-2.3 1 .2-.4 2.2-.4 2.3-.5 2.3-.4 2.4-.4 2.4-.5 2.4-.4 2.4-.2 2.4-.4 2.5-.3 2.5-.2 2.5-.3 2.6-.3 2.5-.2 2.5-.2 2.7-.2 2.6-.2 2.6v2.6l-.2 2.7v2.7l-.2 2.7v11.5l.2 3v2.7l.3 3 .2 2.7.3 3 .3 2.8.3 3zm7 29v-1l-.4.8-.4-.7-.3-.6-.3-.8-.4-.7-.3-1-.3-.6-.3-.8-.4-.8-.3-.8-.2-.8-.2-.8-.3-1-.2-.7-.3-1-.2-.8-.3-1-.2-1-.2-.8v-1l-.3-1-.2-.8-.2-1-.2-1v-1l-.3-1-.2-1v-1l-.3-1-.2-1v-1l-.2-1.2-.2-1 1-.2v1l.3 1v1.2l.2 1v1l.3 1 .2 1 .2 1v1l.2 1 .2 1 .2 1 .2 1 .3.8.3 1 .2.8.2 1 .3.7.2 1 .3.7.2.8.3 1 .3.7.3.8.3.7v.8l.4.8.4.7.3.7.4.7.3.6.3.7-.5.7zm.4-.7.4.8h-1l.6-.7zM332.4 465l1-.2v8.8l.2 2 .2 2 .3 2 .4 1.8.4 1.7.4 1.8.5 1.7.5 1.5.6 1.5.6 1.5.7 1.3.8 1.3.7 1.3.8 1 1 1 .8 1.2 1 1 1 .8 1 .8 1 .8 1 .7 1.2.6 1.2.4 1.2.5 1.2.3 1.2.3 1.3.3h1.4l-.2 1h-1.3l-1.4-.4-1.3-.4-1.3-.4-1.2-.5-1.2-.5-1.2-.7-1-.6-1.2-.8-1-.8-1-1-1-1-1-1-1-1.2-.7-1.2-.8-1.3-.8-1.2-.7-1.4-.7-1.5-.5-1.6-.6-1.6-.5-1.7-.4-1.6-.4-1.8-.3-2-.2-1.8-.2-2-.2-2v-8.9zm1-.2zm2.3-69.4 1 .3-.5 1.6-.4 1.7-.4 1.7-.3 1.7-.3 1.8-.3 1.8-.3 1.8-.2 2-.2 1.8-.3 2-.2 2v2l-.3 2v2l-.2 2-.2 2.3v4.3l-.2 2.2v9.6l.2 2.5v2.4l.2 2.5v2.5l.2 2.6.2 2.6.2 2.5.2 2.6.2 2.8h-1l-.2-2.6-.2-2.6-.2-2.7-.2-2.7v-2.5l-.2-2.6v-2.5l-.2-2.4v-18.5l.3-2v-2.2l.3-2v-2.2l.3-2 .3-2 .3-2 .2-1.8.3-2 .4-1.8.4-1.8.3-1.8.5-1.7.4-1.7.3-1.7.4-1.6zm8.3-28.6v1l.4-.3-.2.4-.2.4-.2.6-.2.6-.3.7-.2.8-.2 1-.2.8-.3 1-.3 1-.2 1-.3 1-.3 1-.3 1.2-.4 1-.3 1.2-.3 1-.2 1.2-.3 1-.3 1.2-.3 1-.3 1-.3 1-.2 1-.3 1-.3 1-.2.8-.2.8-.2.7v.6l-.2.6v.5l-1-.3v-.5l.2-.7.2-.6.2-.8v-1l.4-.7.2-1 .2-.8.3-1 .2-1 .3-1 .2-1.2.3-1 .3-1.2.3-1 .4-1 .2-1.2.3-1 .2-1.2.3-1 .3-1 .3-1 .4-1 .2-1 .3-1v-.8l.4-.8.2-.7.3-.7v-.6l.3-.5.2-.5.5-.2zm-.5.2.2-.3h.3l-.5.3zm.5.3v-.5.5zm-.5-.3.2-.3h.3l-.5.3z"
        />
        <path
          fill="#fff"
          d="m336 370.4 6.4 7.4c-1.8 1.4 1.3 7-.4 18-1 6.4-4.8 13.8-5.6 22-2.5 26.5-2.5 59.8 5.4 81-14.5-1.6-19.5-14.8-20-39.6-.4-20.6-.4-44.7 4.7-72.7 1-6.5 4.2-11.7 9.4-16z"
        />
        <path
          fill="#21231e"
          d="m342 378.2-6.5-7.5.8-.6 6.5 7.5v.7h-.7zm.8-.7.4.4-.5.2v-.7zm-.3 18.5h-1l.2-1.2v-1l.2-1V385l-.2-.6v-1.2l-.2-.6v-1l-.2-.4v-2.8l.2-.3.3-.4v-.2l.7.8v.2h-.2v.5h-.2v2.2l.2.4v1.1l.2.6v1.1l.2.7v8.1l-.2 1v1l-.3 1zm0 0zm-5.6 21.7h-1v-1.8l.2-.7.2-.7v-.7l.3-1v-.6l.3-.8.2-.7.2-.8.2-.7.2-.7.2-.7.2-.6.2-.7.2-.7.3-.7v-.7l.3-.6.2-.7.2-.7.2-.6v-.7l.3-.6.2-.6.2-.5.2-.7v-.6l.2-.6v-.6l.2-.6v-.5h1v1.2l-.3.6v.7l-.2.6v.7l-.3.7-.2.6-.2.6v.7l-.3.7-.2.6-.3.7-.2.6-.2.6-.2.7-.2.7-.2.7-.3.7-.3.7-.2.8-.2.7-.2.7v.7l-.2.6-.2.7v.7l-.3.8v.7l-.2.7v1.5zm4.8 81.6v-1l-.4.7-.8-2-.6-2-.7-2.3-.6-2.2-.5-2.3-.5-2.4-.5-2.4-.4-2.4-.4-2.5-.4-2.5-.3-2.5-.3-2.6-.2-2.7-.2-2.7-.2-2.6v-2.7l-.2-2.7V455l-.2-2.8v-10.9l.2-2.7V436l.2-2.8v-2.7l.3-2.6.3-2.7.2-2.6.2-2.6.2-2.4h1l-.3 2.6-.2 2.6-.2 2.5-.2 2.6v2.6l-.2 2.6v2.7l-.2 2.6v2.7l-.2 2.7V455l.2 2.7v2.7l.2 2.7.2 2.5.2 2.7.2 2.6.3 2.5.3 2.6.4 2.4.4 2.4.4 2.5.4 2.3.5 2.4.7 2.2.6 2.2.6 2.2.6 2 .7 2-.5.7zm.5-.6.3.7h-.8l.5-.7zm-21-39.5h1v2.2l.2 2.3v2l.2 2.2.2 2v2l.3 1.7.3 1.8.3 1.8.2 1.6.4 1.5.4 1.6.4 1.5.5 1.4.4 1.2.6 1.3.6 1.2.6 1 .7 1 .6 1 .8 1 .8 1 .8.6 1 .7 1 .7 1 .6 1 .5 1 .4 1 .4 1.3.3 1.3.2 1.3.2-.2 1-1.4-.2-1.3-.3-1-.4-1.3-.4-1.2-.5-1-.6-1.2-.5-1-.7-1-.7-.8-.7-1-1-.7-1-.7-1-.6-1-.7-1.2-.6-1-.5-1.4-.5-1.3-.5-1.5-.5-1.5-.4-1.5-.3-1.7-.4-1.5-.4-1.8-.3-1.8-.2-2v-2l-.3-2v-2l-.2-2.3v-2.2l-.2-2.3zm4.7-72.8 1 .2-.5 2.6-.4 2.6-.3 2.5-.4 2.6-.3 2.4-.4 2.5-.3 2.4-.3 2.4-.2 2.4-.2 2.5-.3 2.3v2.4l-.3 2.4-.2 2.3v2.4l-.2 2.2v2.3l-.2 2v4.5l-.2 2.2V459h-1v-26.9l.2-2.2v-2l.2-2.4v-2.3l.2-2.3.2-2.3.2-2.4.2-2.3.2-2.4.2-2.5.3-2.3.3-2.4.3-2.5.4-2.5.3-2.6.4-2.5.4-2.6.6-2.6.4-2.6zm1 .2zm9.3-16.5-.8.7h.7l-.4.5-.5.4-.5.4-.4.4-.4.5-.4.3-.4.4-.4.5-.4.4-.4.5-.3.5-.4.5-.3.5-.3.4-.3.4-.3.5-.2.4-.3.5-.2.4-.3.5-.2.4-.2.6-.2.5-.2.5-.2.6-.2.5-.2.7v.5l-.3.6v.6l-.2.6v.6l-1-.2v-.6l.2-.6.2-.6v-.6l.3-.6v-.6l.3-.5.2-.6.2-.6.2-.4.3-.6v-.5l.4-.5.2-.6.3-.5.2-.6.3-.5.3-.6.4-.5.3-.6.4-.5.2-.6.4-.4.4-.5.4-.4.4-.4.5-.4.4-.5.5-.4.4-.4.5-.6.6-.4h.7zm-.7 0 .4-.3.3.4h-.7z"
        />
        <path
          fill="#fff"
          d="m372.3 390-13.4-1.6c-2.6 12.7-4.5 21.7-5 26.2-1 9 1.8 17 5 23 5-3 7.2-9.4 9.2-18.6 2-9.2 2.7-19.2 4-29z"
        />
        <path
          fill="#21231e"
          d="m359 388 13.3 1.5v1l-13.5-1.6-.4-.7.5-.4zm-.6.3v-.4h.5l-.6.3zm-4 26.4h-1l.2-.6v-.8l.2-.6v-1l.2-.6v-.7l.3-.6v-.7l.2-.7v-.7l.3-.7v-1l.2-.7.2-.8.2-1v-.7l.3-1 .2-.8v-1l.2-1 .2-1 .2-1 .2-1 .2-1 .3-1 .2-1 .2-1.2.2-1.2v-1l.4-1.3 1 .2-.3 1.2v1l-.3 1.3-.3 1-.2 1.2-.2 1-.2 1-.2 1-.2 1-.2 1-.2 1v1l-.3 1-.2.8-.2.8v1l-.3.7v.8l-.3.7v.8l-.2.7-.2.7v.6l-.2.7v1.3l-.2.5v1.1l-.2.5v.9zm4.3 22.6.5.8h-.7l-.3-.7-.3-.6-.4-.6-.3-.5-.3-.6-.2-.7-.3-.7-.2-.6-.3-.7-.2-.7-.3-.7-.2-.8-.2-.7v-.7l-.3-.7-.2-.7-.2-.7v-.8l-.3-.7v-.7l-.2-.8v-.8l-.2-.7v-.8l-.2-.8v-6.1h1v6.6l.2 1v1.4l.3.7v1.6l.3.8.2.7v.8l.3.7.2.7.3.7.2.6.2.7.2.6.2.6.2.6.3.7.3.5.2.6.3.7.3.6.3.6.3.5-.7-.2zm.5.8-.5.4-.2-.5h.7zm8.6-19h1l-.3 1-.2.8-.2 1v.7l-.3.8-.2.7-.2.8-.2.7v.8l-.4.7-.2.7-.3.6v.7l-.4.6-.2.7-.3.6-.2.5-.3.5-.3.6-.3.5-.4.7-.3.5-.4.5-.5.4-.3.6-.4.4-.4.4-.4.4-.5.3-.4.5-.4.3-.4.3-.5-.7.4-.3.5-.3.4-.3.3-.4.4-.3.4-.4.4-.4.4-.5.3-.4.4-.4.4-.5.3-.4.4-.5.2-.4.3-.6.2-.5.3-.6.2-.7.3-.7.2-.6.3-.7.2-.6.2-.7v-.8l.3-.7.3-.7.2-.8.2-.8.2-.8.2-.8.2-.8.2-1zm4.5-28.5v-1l.5.5v1l-.3 1v.8l-.2 1v1l-.2.8v1l-.2.8v1l-.2 1v.8l-.2 1v1l-.2.8v1l-.2.8v1l-.2.8v1l-.2 1-.2.8v1l-.2.8-.2 1v.8l-.2 1-.2.8-.2.8v1l-.3.8v1l-.3.7h-1l.3-1v-.8l.3-1 .2-.7v-1l.3-.8v-1l.3-.8.2-1v-1l.3-.8v-1l.2-.8v-1l.2-.8v-1.8l.2-1v-1l.2-.8v-1l.2-.8v-1l.3-1v-1.8l.2-1v-.8l.2-1v-.8l.3-1v-1l.6.7zm0-1h.6l-.2.5-.5-.5zm0 0v1-1zm0 1z"
        />
        <path
          fill="#fff"
          d="M407 418.6h-11.8c-.4 11-.7 18.5-.5 22.3.4 7.5 2.3 14 5.5 18.7 3.6-3 7-8.3 7.6-16.2.6-8-.6-16.5-.7-25z"
        />
        <path
          fill="#21231e"
          d="M395.2 418.2h12v1h-12l-.5-.5.5-.5zm-.5.5v-.5h.5l-.5.5zm.5 22.2h-1v-11.4l.2-.8v-4.4l.2-.8v-5h1v7.8l-.2.7v5.6l-.2.7v7.7zm4.7 18.4.6.7h-.8l-.3-.5-.3-.4-.3-.4-.4-.5-.2-.4-.3-.5v-.4l-.4-.6-.2-.5-.3-.5v-.6l-.3-.6-.2-.5-.2-.6-.2-.6v-.5l-.2-.6-.2-.7-.2-.6v-.6l-.2-.6-.2-.6v-.7l-.2-.5v-.7l-.2-.7v-.5l-.2-.7v-2.6l-.2-.7h1v1.1l.2.7v1.4l.2.7v.7l.2.6v.7l.2.6v.6l.3.6v.7l.3.6v.7l.3.5v.6l.2.6.2.5.2.5.2.5.3.6.3.5.2.6.3.5.2.6.3.5.2.6.3.5.3.6.4.4.2.5h-.7zm.6.7-.5.5-.2-.5h.8zm6.7-16.6h1v1.6l-.2.7v1.4l-.3.8v.6l-.3.7-.2.7-.2.6-.2.6-.2.5-.2.5-.3.6v.5l-.4.7-.2.5-.3.5-.2.5-.3.4-.3.5-.3.5-.4.4-.3.3-.4.4-.4.4-.3.5-.4.3-.4.4-.4.3-.3.3-.4.3-.7-.6.2-.3.4-.2.3-.3.2-.4.3-.2.4-.3.2-.4.3-.3.3-.4.3-.4.4-.5.3-.4.2-.4.2-.4.3-.5.2-.5.3-.5.2-.5.3-.5.2-.6.2-.4v-.6l.3-.6v-.6l.3-.6v-.7l.3-.6v-1.4l.2-.7V444zm0-24.3v-1l.4.6v5.6l.2 1v4.6l.2.8v2.8l.2.8v9.2h-1v-11.8l-.2-.8V429l-.2-1v-3l-.2-1v-5.3l.4.5zm0-1h.4v.6l-.5-.5z"
        />
        <path
          fill="#fff"
          d="m420 424.2-12 .6c0 11 0 18.4.3 22.2a37 37 0 0 0 6.2 18.6c3.5-3 6.8-8.6 7-16.5.3-8-1-16.3-1.5-24.8z"
        />
        <path
          fill="#21231e"
          d="m408 424.3 12-.6v1l-12 .6-.4-.5.5-.5zm-.4.5v-.5h.5l-.4.5zm1.2 22.2h-1v-4l-.2-.6v-17.8h1V445l.2.4v1.6zm5.4 18.2.6.8h-.7l-.2-.5-.3-.5-.3-.5-.3-.5-.4-.5-.3-.5-.3-.5-.2-.5-.3-.5-.3-.5-.2-.6-.2-.5-.3-.7-.2-.6-.2-.6v-.4l-.3-.6-.2-.6v-.7l-.3-.6-.2-.5v-.6l-.3-.8v-.6l-.2-.7v-.8l-.2-.6v-.7l-.2-.8v-2h.8v.7l.2.7v1.4l.2.7.2.7v.7l.2.7v.6l.3.6v.7l.2.6v.5l.3.6.2.7.2.5v.6l.3.6.2.5.2.5.2.5.2.5.2.6.2.6.3.5.2.6.2.4.3.5.3.5.3.4.3.5.3.3h-.8zm.6.8-.4.4-.3-.5h.8zm6.2-17h1v2.3l-.2.7v.7l-.2.7-.2.6v.7l-.3.6v.6l-.2.5-.2.6-.2.7-.2.6-.3.5-.3.6-.3.5-.2.4-.3.5-.4.4-.3.4-.3.5-.3.4-.3.4-.3.5-.2.4-.3.3-.3.4-.4.3-.3.4-.3.3-.4.3-.6-.8.3-.3.3-.4.3-.3.4-.3.3-.4.4-.3.4-.4.2-.5.3-.4.2-.3.3-.4.3-.5.2-.4.3-.5.2-.6.3-.5.2-.6.2-.5.2-.6.2-.6.2-.6.2-.5.2-.6v-.5l.3-.7v-.6l.2-.7v-.6l.2-.8V449zm-1-25.3v1l.5-.5v2.4l.2.8v1.5l.2.7v3.4l.2.7v1.5l.2.8v.8l.2.8v2.5l.2.7v2.3l.2.8v5.3h-1v-7.4l-.2-.7v-1.6l-.2-.8V437l-.2-1v-1.5l-.2-.7v-1.6l-.2-.8v-1.6l-.2-.8v-1.6l-.2-.8v-2.2l.4-.6zm-.5.6v-.6h.5l-.5.6zm.5.4v-1 1z"
        />
        <path
          fill="#fff"
          d="m395 412.4-12-.8c-1.2 11-2 18.2-2.2 22-.2 7.7 1 14.2 4 19.3 3.8-2.8 7.7-8 8.8-15.7 1.2-8 .8-16.4 1.4-25z"
        />
        <path
          fill="#21231e"
          d="m383 411 12 1v1l-12-1-.4-.5.5-.4zm-.4.5v-.5h.5l-.4.5zm-1.3 22.2h-1V431l.2-.4V429l.2-.6v-1.2l.2-.6v-2.2l.2-.7v-1.4l.2-.8v-.8l.2-.8v-1l.2-.8v-1l.2-.8v-1l.3-1v-1l.2-1v-1l1 .2v2l-.3 1v1l-.2 1v.8l-.2 1v.7l-.2 1v.8l-.2.8v.8l-.2.8v1.3l-.2.7v1.4l-.2.6v1.1l-.2.6v1.7l-.2.5v2.7zm3.2 18.8.5.8-.7-.2-.2-.4-.2-.5-.2-.4-.3-.5-.2-.4v-.5l-.3-.5-.3-.5v-.6l-.3-.5v-.7l-.3-.6v-.6l-.3-.4v-.6l-.3-.7V443l-.2-.5v-.7l-.2-.6V440l-.2-.8v-5.5h1v6.8l.2.7v.7l.2.6v.6l.2.5v.6l.2.7.2.6v.6l.3.5v.5l.3.6.2.5.2.7.2.5.2.5.2.5.2.5.3.5.2.5.2.5.2.4h-.7zm.5.8-.4.3-.3-.5.8.3zm8.2-16h1l-.2.8v.8l-.3.7v.7l-.3.7-.2.6-.2.6-.2.6-.3.6-.2.6-.3.6-.2.6-.3.5-.3.6-.3.5-.4.5-.3.5-.3.4-.3.5-.3.4-.4.6-.3.4-.4.4-.3.3-.4.4-.3.5-.4.3-.5.3-.3.4-.4.3-.4.3-.3.3-.5-.8.3-.3.4-.2.3-.3.4-.3.2-.3.4-.2.3-.4.3-.3.3-.3.3-.4.2-.4.4-.5.3-.4.2-.3.3-.5.3-.5.3-.4.4-.5.2-.5.3-.6v-.5l.4-.6.2-.5.2-.5.2-.6.2-.7.2-.7.2-.6.2-.7v-.7l.2-.7.2-.8zm1.8-24.4v-1l.5.5v1.5l-.2.8v5.6l-.2.7v9l-.2.8v2.2l-.2.8v.7l-.2.8v1l-.2.6v.8l-1-.2v-.7l.2-.8v-1.5l.2-.7V432l.2-.8V428l.2-.8V421l.2-.7v-4.8l.2-.8v-2.3l.6.5zm0-1h.5v.5l-.5-.6z"
        />
        <path
          fill="#fff"
          d="m384 399.6-13.2-5.4c-2.2 8.8-5.2 37.8 0 50 4.5-3 9-8.4 10.3-17 1.6-9 2-18.2 3-27.6z"
        />
        <path
          fill="#21231e"
          d="m371 393.7 13 5.4-.3 1-13-5.4-.4-.6.7-.3zm-.7.3.2-.5.5.2-.7.3zm.3 50 .6.7-.7-.2-.5-1.2-.5-1.3-.3-1.4-.4-1.5-.3-1.5-.3-1.6-.2-1.7-.2-1.7v-1.8l-.2-1.8v-3.6l-.2-2V418l.2-2v-1.8l.2-1.8.2-1.8V409l.3-1.8.2-1.7V404l.3-1.6.2-1.5.3-1.4.2-1.3.2-1.2.2-1v-1l.3-1 1 .3-.2 1v.8l-.3 1.2-.3 1.2-.2 1.3-.2 1.4-.2 1.5-.2 1.6-.2 1.6v1.7l-.3 1.7v1.7l-.2 1.8v1.8l-.2 1.8v3.8l-.2 2v5.4l.2 1.8v1.7l.2 1.8.2 1.7.2 1.6.3 1.6.3 1.5.3 1.3.5 1.4.4 1.2.4 1h-.8zm.6.7-.5.3-.2-.5.7.2zm9.4-17.7h1v1l-.3.8-.2.8v.7l-.3.8-.2.8-.3.7-.2.7-.3.7-.3.5-.3.7-.2.6-.3.6-.3.6-.3.6-.5.5-.3.7-.4.5-.4.5-.3.5-.3.4-.4.5-.4.5-.5.4-.4.3-.3.4-.4.4-.4.4-.5.4-.5.3-.4.4-.4.3-.6-.8.4-.4.4-.3.4-.3.4-.3.4-.4.4-.3.4-.4.4-.4.4-.4.3-.4.4-.4.3-.5.3-.4.4-.4.3-.5.4-.4.3-.6.3-.5.3-.6.3-.6.2-.6.3-.7.3-.5.2-.6.3-.8.2-.7.2-.7.3-.7v-.7l.3-.7.2-.8v-.8zm3-27 .4-1 .4.6v1l-.2.8v1.7l-.2 1v1l-.2.8v1.8l-.2.8v1.7l-.2 1v1.7l-.2 1v1.6l-.2 1v.7l-.2 1v.8l-.2.8v1l-.2.7v.8l-.2 1v.8l-.2 1v.7l-.3.8v.8h-1v-.8l.2-1v-1.5l.2-.8v-1l.2-.8v-1l.2-.7v-1l.2-.7v-1l.2-.7v-1.6l.2-1v-.7l.2-1V410l.2-.8v-1.8l.2-.8v-1.8l.2-1v-1.5l.2-1v-.8l.2-1 .3.6zm.4-1 .4.3v.3l-.4-.5zm0 .6-.3.4.2-.4zm0-.5.4.3v.3l-.4-.5z"
        />
        <path
          id="rs-c"
          fill="#edb92e"
          stroke="#21231e"
          d="M387.8 701.2c8 6.3 15.2-8.3 8-27.6-5-14.2-30.6-8.7-16.4 10.5.7 1 1.6.6 1.5-.4-1-4 1.6-6.3 5.5-5.5 10.5 2 11 22-.6 17.6-2.2-.2-.4 4 1.7 5.6z"
        />
        <path
          fill="#edb92e"
          stroke="#21231e"
          d="M400 639.2c-1 3.4-5 7.6-8 10.8-4.5 4.8-3.4 12.2-.2 16 3.5 4.4 5 9.2 5.8 13 .5 2.3 1.5 7.4.8 15.5-.4 4-2.7 6-5 7.7-1 1 .5 3 4.3 6 .4.2 1.5 1 2 3 .2.4 2 .4 2.2 0 .4-2 1.6-2.8 2-3 3.7-3 5.4-5 4.2-6-2.2-1.7-4.6-3.8-5-7.7-.6-8 .3-13.2.8-15.5.8-3.8 2.3-8.6 6-13 3-3.8 4.2-11.2-.5-16-3-3.2-7-7.4-8-10.7 0-.8-.3-1-.7-1-.3 0-.7.2-.7 1z"
        />
        <path
          fill="#edb92e"
          d="M395 685.5h11.6c2 0 3.6 1.6 3.6 3.5 0 2-1.6 3.5-3.6 3.5H395c-2 0-3.5-1.5-3.5-3.5s1.6-3.5 3.6-3.5z"
        />
        <path
          fill="#21231e"
          d="M406.6 686H395v-1h11.6v1zm4 3h-1v-1l-.2-.2v-.2l-.2-.2v-.2h-.2v-.2h-.2v-.2h-.3v-.2h-.2v-.2h-.3l-.2-.2h-.5v-.2h-.6v-1h1l.2.2h.4v.2h.3l.2.2h.2v.2h.2v.2l.3.2.2.2v.2l.3.2.2.3v.3l.2.3v.4l.2.2v.8zm-1 0h1-1zm-3 4v-1h.8l.3-.2h.2l.2-.2.2-.2h.3v-.2l.2-.2v-.2l.2-.2.2-.3v-.3l.2-.2v-.8h1v1.2l-.2.2v.4h-.2v.3l-.2.3h-.2v.3h-.2v.3h-.3l-.3.2v.2h-.3l-.2.2h-.2l-.3.2h-.4l-.2.2h-.8zm-11.5-1h11.6v1H395v-1zm-4-3h1v1l.2.2v.3h.2v.2h.2v.2h.2v.2h.2v.2h.2l.3.2h.2l.2.2.3.2h.6v1h-1.2v-.2h-.3l-.2-.2h-.2l-.2-.2-.2-.2-.3-.2-.3-.3-.2-.3-.2-.3-.2-.2v-.2l-.2-.2v-.4l-.2-.2v-.8zm1 0h-1 1zm3-4v1H394v.2h-.3l-.2.2h-.2v.2h-.2v.2l-.2.2-.2.2-.2.2v.2l-.2.2v.5h-.2v.6h-1v-1.2l.2-.2v-.2h.2v-.3h.2v-.2l.2-.2v-.2h.2l.2-.2v-.2h.3v-.2h.3v-.2h.3l.3-.2h.2l.2-.2h.5l.2-.2h.7z"
        />
        <path
          fill="#fff"
          d="m417 579.2.5-11c-4.4-2.2-15.2 0-19.7 10.2a64.7 64.7 0 0 1-18 25.2c10 1.8 18.4-.2 23.7-7.4 7.3-9.8 11.2-15.7 13.6-17z"
        />
        <path
          fill="#21231e"
          d="m418 568.3-.4 11h-1l.4-11 .7-.5.3.5zm-.3-.5.3.2v.3l-.3-.5zm-19.5 10.8-1-.4.6-1 .5-.8.5-1 .6-.7.5-.8.5-.8.7-.7.6-.6.7-.7.7-.5.7-.6.6-.4.7-.5.8-.4.8-.4.7-.3.8-.3.7-.2.7-.3h.7l.8-.3h1.2l.7-.2h2l.7.2h.5l.6.2.5.2.4.2-.4 1-.4-.3h-.5l-.5-.2h-.5l-.5-.2h-3l-.7.2h-.6l-.7.3-.7.2-.7.2-.7.2-.8.3-.7.3-.7.4-.7.4-.5.5-.7.5-.7.6-.5.6-.6.6-.7.7-.6.6-.5.7-.6.8-.5 1-.3.7-.5 1zM380 603l-.2 1-.2-.8.6-.6.6-.5.7-.5.6-.6.7-.6.6-.6.5-.6.6-.6.6-.7.6-.7.5-.6.7-.7.5-.7.6-.7.5-.7.6-.8.4-.8.5-.7.5-.8.5-1 .5-.8.6-.8.6-1 .5-.8.6-1 .6-1 .5-1 .5-1 .5-1 .6-1 .5-1.2.5-1.2 1 .4-.6 1.2-.5 1-.6 1.2-.5 1-.4 1-.6 1-.5 1-.5 1-.6 1-.5 1-.6.8-.6.8-.5.8-.5.8-.6.8-.5.8-.6.7-.4.7-.6.8-.6.6-.5.7-.7.7-.6.6-.6.7-.4.6-.6.5-.6.6-.7.7-.6.5-.5.6-.6.6-.8.5-.2-1zm-.2 1h-1l.8-.8.2.8zm23.4-8 .8.5-.6.7-.5.6-.7.6-.6.6-.6.6-.5.5-.6.6-.7.5-.7.5-.7.4-.8.3-.7.4-.7.3-.7.3-.7.2-.7.3-.8.2-.8.2h-.8l-.8.2h-.8l-1 .2h-6.1l-1-.2-.8-.2-1-.2.2-1 1 .2.8.2h1l.8.2h6.6l.8-.3h.8l.7-.3.8-.2.7-.2.7-.3.7-.2.7-.2.8-.4.6-.3.7-.3.7-.4.6-.5.6-.5.5-.5.5-.5.6-.5.5-.6.7-.6.5-.7zm13.4-16.8h1l-.2.4-.2.2h-.2l-.3.3-.2.3-.3.2-.2.3-.3.3-.3.4-.3.3-.2.4-.4.5-.3.4-.3.3-.4.5-.3.5-.4.5-.5.6-.3.5-.4.5-.5.7-.5.6-.5.7-.5.7-.5.7-.5.6-.6.8-.6.8-.5.8-.6 1-.7.7-.7 1-.6.8-.8-.6.6-1 .7-1 .6-.7.7-1 .6-.7.6-.8.5-.7.5-.7.5-.7.5-.7.5-.8.5-.6.5-.6.4-.6.4-.6.4-.6.4-.5.4-.5.3-.5.3-.4.4-.5.3-.4.3-.4.3-.3.4-.3.3-.3.2-.2.3-.3.3-.2.4-.2h.2l.3-.2-.4.4zm1 0v.3h-.2l.2-.3z"
        />
        <path
          fill="#fff"
          d="m425.2 580.6-11.8-5c-5 10-8.2 16.6-9.5 20.2-2.8 7-3.5 13.8-2.3 19.5a22 22 0 0 0 14-11.6c3.8-7 6-15.3 9.5-23z"
        />
        <path
          fill="#21231e"
          d="m413.6 575.2 11.7 5-.3 1-11.8-5-.3-.8.6-.2zm-.7.2v-.4l.6.2-.7.2zm-8.7 20.6-1-.4.2-.3.2-.4.2-.5v-.4l.2-.3.2-.5.2-.4.2-.5.2-.5.3-.5.2-.5.3-.6.2-.5.3-.6.3-.5.3-.7.2-.6.3-.6.3-.7.4-.8.3-.7.4-.8.2-.7.4-.8.4-.8.4-.8.4-.8.4-.8.4-1 .4-.8.5-.8.4-1 .8.5-.4.8-.5 1-.5.8-.4.8-.3 1-.4.7-.4 1-.5.7-.4.7-.3.8-.3.7-.4.6-.3.7-.3.7-.3.6-.2.7-.3.6-.3.5-.3.6-.3.6-.3.6-.2.5-.3.5-.3.5-.2.5-.2.4-.2.5v.5l-.2.4-.2.3v.3l-.3.4zm-2.7 18.8.2 1-.6-.4v-.5l-.2-.7v-.6l-.2-.5v-1.7l-.2-.5v-3.7l.2-.6v-1.2l.2-.7v-.6l.2-.5v-.7l.2-.6.2-.7v-.6l.3-.8v-.6l.3-.7.2-.7.2-.7.2-.7.2-.7.2-.7 1 .4-.3.6v.7l-.4.6-.2.6-.2.6-.2.7v.5l-.3.6v.8l-.3.6v.6l-.2.7v.6l-.2.6v.5l-.2.6v1.9l-.2.5v3.5l.2.5v1.2l.2.5v.7l.2.5-.6-.4zm.2 1h-.5v-.4l.5.4zm13.5-12.4 1 .5-.5.6-.3.6-.4.6-.3.6-.4.6-.4.5-.5.6-.5.6-.4.5-.4.6-.5.4-.4.5-.5.4-.5.3-.4.4-.6.4-.5.4-.5.4-.5.3-.5.4-.5.3-.4.2-.5.2-.4.2-.5.2-.4.3h-.4l-.5.2-.5.2h-.5l-.4.3h-.5l-.2-1h.9l.4-.3h.4l.4-.3h.5l.4-.3.5-.2.4-.2.5-.2.5-.2.5-.3.5-.3.4-.3.4-.4.4-.3.5-.4.4-.4.4-.4.6-.4.4-.5.4-.4.5-.6.3-.4.4-.5.4-.6.5-.6.4-.5.2-.7.4-.6.4-.6.3-.6zM425 581l.3-.8.3.6-.3.7-.3.8-.3.7-.3.7-.3.8-.2.7-.3.7-.2.7-.3.7-.3.8-.3.7-.2.6-.3.8-.4.7-.3 1-.2.6-.2.7-.3.8-.3.8-.2.7-.3.7-.3.8-.3.7-.2.7-.3.7-.3.8-.3.7-.5.7-.3.7-.3.6-.5.6-.3.7-1-.6.5-.6.3-.7.3-.6.3-.6.4-.7.3-.6.3-.7.3-.7.2-.7.3-.7.2-.7.3-1 .3-.6.3-.7.3-.7v-.8l.4-.7.3-.7.3-.8.2-.7.3-.7.3-.8.3-.7.3-.7.3-.7.3-.7.2-1 .3-.6.3-.8.3-.7.4-.8.3-.8.3.7zm.3-.8.5.2-.2.4-.3-.6z"
        />
        <path
          fill="#fff"
          d="m428.6 580.6-12.7-2c-2.4 10.8-4 18-4.4 22-1 7.5 0 14 2.7 19.4 4.3-2.3 8.8-7 10.7-14.7 2-7.8 2.2-16.3 3.6-24.7z"
        />
        <path
          fill="#21231e"
          d="m416 578.2 12.6 2v1l-12.8-2-.4-.6.6-.4zm-.6.4v-.5l.6.2-.6.4zm-3.3 22h-1l.2-.5V599l.2-.6v-.5l.2-.6v-.5l.2-.6v-.6l.2-.5v-.6l.2-.6v-.6l.2-.6.2-.7v-.6l.3-.7v-.7l.2-.8v-.8l.3-.8.2-.8v-.8l.3-1 .2-.7.2-1 .2-.8.2-1 .2-1 .2-1 .2-1 1 .3-.2 1-.2 1-.2 1-.2 1-.2.8-.2 1-.2.7-.2 1-.2.7v.8l-.3.8-.2.8v.8l-.2.7v.6l-.2.7-.2.7v.6l-.2.6-.2.7v.4l-.2.6v.6l-.2.5v1.1l-.2.6v.4l-.2.4v1.2zm2 19 .5.8-.7-.2-.2-.5-.3-.5-.2-.5v-.6l-.3-.4-.2-.5-.2-.5-.2-.6v-.6l-.2-.6v-.6l-.3-.6v-.6l-.2-.6v-.6l-.2-.6v-2.8l-.2-.6v-5.4l.2-.7v-1.5h1v3.1l-.2.7v5.1l.2.6v1.2l.2.6v.6l.2.6v.6l.3.6v.5l.2.6v.7l.3.5v.5l.3.6.2.5.2.5.2.5.3.5.2.5-.7-.2zm.5.8-.5.3-.2-.5.7.2zm10-15.2 1 .2-.2.7-.2.8v.7l-.3.7-.3.7-.2.5-.3.6-.4.7-.3.6-.3.6-.3.4-.3.6-.4.5-.3.5-.4.5-.4.5-.4.4-.4.5-.4.3-.4.4-.4.4-.4.5-.4.3-.4.4-.4.3-.4.3-.4.3-.4.4-.5.3-.4.3-.4.2-.5.2-.5-.8.4-.2.4-.3h.4l.4-.4.4-.3.4-.3.4-.3.4-.3.4-.3.4-.3.3-.3.4-.4.4-.4.5-.4.3-.4.4-.5.3-.4.4-.6.2-.5.3-.6.3-.5.3-.6.4-.6.3-.5.3-.6.2-.6.3-.5.2-.6.3-.8.2-.7.2-.6.2-.8zm4-25v1l.5-.5v.8l-.2.8v.7l-.2.8v.8l-.2.8v.8l-.2.8v.7l-.2.8v.8l-.2.8v1.7l-.2.7v.8l-.2.8v.8l-.2.8v.7l-.2.8v1l-.2.6v.8l-.2.8-.2.7v.7l-.2.7-.2.8v.7l-.3.7-.2.7-1-.2.2-.8.2-.7v-.7l.2-.8v-.7l.3-.7v-.8l.2-.8v-.7l.2-.8v-1.5l.2-.8v-.7l.2-.8v-1l.2-.7v-.7l.2-.8v-1.6l.2-.8v-.8l.2-.7v-1l.2-.7v-.8l.2-.8v-.8l.2-1v-.7l.3-.8.5-.4zm-.4.3v-.4h.5l-.4.5zm.5.6v-1 1z"
        />
        <path
          fill="#fff"
          d="M430.4 563.4h7.6c4.4 2 9 12.2 3.7 22a65.8 65.8 0 0 0-9.5 29.2c-7.4-6.8-10.8-14.7-8.2-23.3 3.4-11.7 6.8-25.2 6.4-28z"
        />
        <path
          fill="#21231e"
          d="M438 564h-7.6v-1h7.8l-.2 1zm0-1h.2-.2zm4 22.5-.8-.5.5-1 .4-.8.4-.8.3-1 .3-.8.2-1v-.7l.3-1V574l-.2-1v-.6l-.3-.8-.2-.7-.3-.8-.2-.7-.3-.6-.3-.7-.3-.6-.3-.6-.3-.4-.3-.5-.4-.3-.4-.4-.3-.4-.4-.4-.5-.3-.4-.3-.3-.2.5-1 .4.4.5.2.5.4.4.4.4.4.4.4.4.5.4.6.3.6.3.6.3.6.3.7.2.7.3.7.2.6.2.8v.7l.3 1v.8l.2.8v3.5l-.2 1v1l-.4.8-.3 1-.3 1-.4.8-.4 1-.5 1zM432 615l.5-.7-.8.3v-.8l.2-1v-2.3l.3-1v-.7l.2-.8.2-1 .2-.8v-1l.2-.7.3-1 .2-.8.2-1 .2-.7.3-1 .3-.8.3-1 .4-1 .4-.8.4-1 .4-1 .4-1 .4-1 .5-1 .4-1 .5-1 .5-1 .5-1.2.6-1 .6-1.2 1 .5-.7 1-.6 1.2-.7 1-.5 1-.5 1.2-.5 1-.4 1-.5 1-.5.8-.4 1-.3 1-.3 1-.4.8-.3 1-.3.8-.2.8-.3 1-.4.8-.2.8-.2 1-.2.7-.2 1v.7l-.3.8v1l-.3.7v.8l-.2.8v1l-.2.7v1.8l-1 .2zm.7-.3v1l-.8-.7.7-.3zm-9.2-23.6 1 .4-.3.8-.2.8v.8l-.2.7v.8l-.2.8v3l.2.8.2.8v.7l.3.7.3.7.2.8.3.7.4.7.4.6.3.7.5.7.4.7.4.7.5.6.4.7.5.7.4.6.6.7.6.6.6.7.7.6.5.7-.6.7-.8-.6-.7-.7-.6-.7-.7-.6-.6-.7-.6-.7-.4-.7-.6-.7-.4-.7-.5-.8-.3-.7-.5-.7-.3-.8-.5-.7-.3-.7-.3-.8-.4-.7-.2-.7-.2-.8-.2-.7v-.8l-.2-.8v-.8l-.2-.8v-2.5l.2-.8v-.8l.3-.8.3-1 .2-.7zm7-28v1l.4-.7v1.8l-.2.5v1.1l-.2.7-.2.7v.8l-.3.8v.8l-.2 1-.2.8-.2 1-.3 1v1l-.4 1-.2 1-.3 1-.2 1-.2 1-.3 1.2-.3 1-.3 1.2-.3 1-.3 1.2-.3 1.2-.3 1-.3 1.2-.2 1-.4 1.2-1-.3.4-1 .3-1 .5-1.2.3-1 .3-1.2.4-1.2.3-1 .3-1.2.3-1 .3-1.2.3-1 .2-1 .2-1 .3-1.2.2-1 .2-1 .2-1 .2-.8.2-1 .2-.8.2-.8v-.8l.3-.7v-.8l.2-.7v-.6l.2-.6v-2l.4-.6zm-.6.5v-.6h.4l-.5.5zm.4 0v-.6.4zm-.5 0v-.6h.4l-.5.5z"
        />
        <path
          fill="#fff"
          d="m433.8 558.2-12-4.3c-4.3 10-7.2 16.8-8.4 20.5-2.3 7.3-2.6 14-1 19.6a21.3 21.3 0 0 0 14-11.6c3.3-7.3 4.5-16.3 7.4-24.2z"
        />
        <path
          fill="#21231e"
          d="m422 553.4 12 4.3-.4 1-12-4.4-.3-.6.6-.3zm-.7.3.2-.4h.4l-.7.4zm-7.4 21-1-.3v-.4l.2-.4v-.4l.3-.4v-.4l.3-.5.2-.5v-.5l.3-.5.2-.5.2-.6.3-.6.2-.5.2-.6.3-.6.2-.6.2-.6.3-.7.3-.6.3-.7.4-.7.3-.8.3-.8.3-.7.4-.8.3-1 .4-.8.3-1 .4-.8.5-1 .4-.8.3-1 1 .5-.5 1-.4 1-.4.8-.3 1-.4.8-.4.8-.4.8-.3.8-.4.8-.4.8-.3.7-.3.8-.3.8-.3.7-.3.6v.8l-.4.6-.2.6-.3.6v.6l-.3.6-.2.5-.2.5-.2.5v.5l-.3.5-.2.4v.5l-.3.4v.3l-.2.3v.4zm-1.8 19 .3 1-.6-.4-.3-.6v-.5l-.2-.6v-.5l-.2-.5v-.6l-.2-.7V583l.2-.7V581l.3-.6v-.7l.2-.6v-.6l.3-.6.2-.7v-.6l.3-.7.2-.6.2-.6 1 .3-.3.6-.2.7-.2.7-.2.6v.7l-.2.6v.7l-.2.6-.2.6v.6l-.2.6v1l-.2.7v6.5l.2.6v1.1l.2.4.2.6v.5l.2.5-.6-.3zm.3 1h-.5v-.4l.5.3zM426 582l.8.6-.3.6-.4.7-.2.5-.4.6-.4.7-.4.6-.4.5-.4.5-.4.5-.5.5-.5.5-.5.4-.4.4-.5.4-.4.4-.4.4-.5.3-.5.5-.5.3-.5.3-.5.4-.4.2-.5.3h-.5l-.5.4-.5.2-.5.2-.5.2h-.4l-.6.3-.4.2h-.5l-.3-.8.4-.2h.5l.5-.3.5-.2h.4l.5-.3.4-.2.4-.3.5-.2.5-.2.5-.3.4-.3.5-.3.5-.4.4-.3.6-.3.4-.4.5-.3.4-.4.4-.5.4-.4.4-.4.4-.4.4-.5.4-.5.4-.5.4-.5.4-.6.3-.6.3-.6.3-.6.3-.7zm7.6-23.4.4-1 .3.7-.3.8-.3.8-.2.8-.3.7-.2.8-.2 1-.2.6-.2.8-.3.8v.8l-.3.7-.2.8-.2.8-.2.8v1l-.3.6-.2.8-.2.8-.2.8v.7l-.3.8-.2.8-.3.7-.2.8-.2.7-.3.8-.3.7-.2.7-.3.8-.3.7-.3.7-.2.6-1-.5.4-.5.3-.7.3-.7.3-.6.3-.7.3-.8.2-.8.2-.7.3-.8.2-.7.2-.8.2-.7v-.8l.4-.8.2-.8.2-.8.2-.8.2-.8.2-.7.2-.7.2-.8.2-.8.2-.8.2-1 .2-.6.2-.8.3-.8.3-.8.2-.7.3-.8.3-.8.3-.7.3.6zm.4-1 .4.3v.3l-.4-.6zm-.2.6-.2.4.2-.4zm.2-.5.4.2v.3l-.4-.6z"
        />
        <path
          fill="#fff"
          d="m425.6 549.7-2.6-16.4c-2.8-.7-6.5 5.8-10 9.5-1 1-2 1.7-2.6 2.8a23.3 23.3 0 0 0-3.4 8 62.3 62.3 0 0 1-13 27.6c10.2-.2 18-3.8 21.8-12 5-11 7.7-17.7 9.8-19.5z"
        />
        <path
          fill="#21231e"
          d="m423.4 533.3 2.7 16.4h-1l-2.5-16.3.6-.6.4.5zm-.3-.4h.4v.2l-.3-.4zm-9.7 10.2-.8-.7.4-.4.2-.2.3-.4.4-.4.2-.4.3-.4.4-.4.2-.5.3-.4.4-.5.2-.4.3-.3.4-.5.2-.4.3-.4.4-.3.2-.3.3-.4.3-.3.4-.3.3-.4.3-.2.3-.2.4-.2.4-.3h.3l.4-.3h.3l.4-.2h1.1l-.2 1h-1l-.3.2-.2.2-.3.2-.3.2-.3.2-.3.3v.4l-.5.3-.3.3-.3.3-.4.4-.3.4-.3.5-.4.4-.3.3-.3.4-.3.4-.4.5-.3.5-.3.4-.4.4-.3.4-.4.4-.3.4-.4.4-.4.4-.3.4zm-2.5 2.7-.8-.7v-.2h.2l.2-.2v-.2h.2v-.2h.2v-.2h.2v-.2h.2v-.2l.2-.2h.2v-.2l.2-.2h.2v-.2h.2v-.2h.2v-.2l1 .6h-.2l-.2.2v.2h-.2v.2h-.2l-.2.2v.2h-.2l-.2.2v.2h-.2v.2h-.2v.2h-.2v.2h-.2v.2l-.2.2v.2h-.2zm-3.3 7.7-1-.2v-.6l.2-.4v-.3l.2-.3v-.8l.2-.3v-.3l.2-.3v-.3h.2v-.4l.2-.3v-.2l.2-.2v-.2l.3-.3v-.2l.2-.2v-.2l.3-.2v-.3h.2v-.3l.3-.3v-.2l.3-.2v-.2l.2-.3.2-.2.8.6-.3.3v.2l-.2.2-.2.2v.4l-.2.2-.2.2v.3l-.2.3v.2l-.2.3-.2.2v.2l-.2.3v.2l-.2.3v.2l-.2.3v.2l-.2.3v.5l-.2.3v.2l-.2.3v.5l-.2.3v.7zm-13.4 27v1l-.3-.8.5-.8.5-.7.5-.6.5-.8.5-.7.5-.7.4-.6.6-.7.4-.7.5-.8.4-.7.4-.7.4-.8.4-.7.4-.7.4-.8.4-.8.4-.8.4-1 .4-1 .3-.8.3-1 .3-.8.4-1 .3-1 .4-1 .3-1 .3-1.2.3-1 .3-1.3.2-1.3.3-1.2 1 .2-.3 1.2-.3 1-.4 1.3-.3 1.2-.4 1-.4 1-.3 1.2-.4 1-.4 1-.4 1-.3 1-.5.8-.4 1-.3.8-.4.8-.4 1-.5.8-.4.8-.3.7-.5.8-.4.8-.5.8-.4.7-.6.7-.5.7-.5.7-.5.7-.5.8-.5.7-.5.6-.5.8-.5.7-.4-.8zm0 1h-1l.7-.8.4.7zm21.3-12.8 1 .4-.5.7-.4 1-.4.6-.4.7-.5.7-.4.6-.5.6-.5.6-.5.6-.6.5-.6.4-.6.5-.7.4-.6.4-.8.4-.7.4-.7.4-.7.3-.7.3-.8.3-.8.2-.8.2-1 .2-.7.2-1 .2-.7.2h-1l-.8.2h-1l-.8.2h-2v-1h2.8l1-.2h.8l.8-.2 1-.2h.7l1-.3.7-.2.7-.3.8-.2.7-.3.7-.3.7-.3.6-.3.7-.3.6-.4.7-.5.6-.4.6-.4.5-.4.6-.6.5-.5.5-.4.5-.6.5-.6.4-.7.5-.6.4-.6.3-.7.3-.8zm9.8-19.2h1v.3l-.3.3v.2l-.3.2-.2.2-.2.2-.2.3-.3.4-.2.2-.2.4v.4l-.4.5-.2.5-.3.5-.2.5-.3.6-.2.6-.3.6-.3.6-.4.7-.3.8-.3.8-.4.7-.3.8-.4 1-.4.7-.4 1-.4.8-.4 1-.4 1-.5.8-.3 1-.5 1-1-.4.6-1 .4-1 .5-1 .4-1 .5-1 .4-.8.3-1 .4-.7.4-.8.4-.8.4-1 .3-.6.4-.7.4-.7.3-.6.4-.7.3-.6.2-.4.2-.6.3-.5.2-.5.3-.4.2-.5.3-.3.2-.4.2-.3.2-.4.2-.3.2-.3.2-.2.3-.2.3-.2-.2.4zm1 0v.3-.3z"
        />
      </g>
      <use
        xlinkHref="#rs-d"
        width={1350}
        height={900}
        transform="matrix(-1 0 0 1 964.3 0)"
      />
      <path
        fill="#fff"
        stroke="#21231e"
        d="M536.4 415a38 38 0 0 0 4.8-1.5 66.2 66.2 0 0 1-21.4-22c-7.8-12 3.3-33 8-44.3a53 53 0 0 0 21.2-31c1-7.3-19-4.7-33 2-17 8-19.3 5.7-25.4 7-2.2 10.5 2.4 11.4 6.7 11-9.4 15-13.3 29.8-15 51.4-2-21.6-6-36.5-15.3-51.5 4.3.6 9-.3 6.7-10.7-6-1.4-8.4.8-25.4-7.2-14-6.5-34-9-33-1.8 3 13.7 11.8 24 21.3 31 4.6 11.2 15.7 32.4 8 44.2a67.3 67.3 0 0 1-21.5 22c1.7.7 3.3 1.2 5 1.5-1.2 1.5-11 4.5-12.3 3.7-7.6-5.3-15-18-21.4-25.2-18.2-20.8-27.3-36.7-24-49.6 4.5-14 20.8-29.6-.8-27-21.7 2.8-39.6 32.5-45.4 68.3-2 13.2-3.3 24.4-4.7 33.5 11.8-4.3 17-8.5 20.2-13.7-1.4 5-2.5 9.7-3.2 14.2 9.7-1.7 16.7-6.4 19.2-15 1-3.6 2.3-6.5 3.6-9 3 1 7 1 11.6 0 1.7 4 15 19 22.2 30 8 12.2 20.2 21.6 24.2 22 2 .4 2.7-4 2.2-10.2 21 .2 42.3.3 63-.4 20.7.7 41.8.6 63 .4-.6 6 0 10.6 2 10.3 4-.5 16.2-10 24.3-22.2 7-10.8 20.5-25.7 22.2-30a20 20 0 0 0 11.6.2c1.3 2.5 2.5 5.4 3.5 9 2.5 8.6 9.5 13.3 19.2 15-.7-4.5-1.8-9-3.2-14 3.2 5 8.4 9.3 20.2 13.6-1.4-9-2.7-20.3-4.8-33.5-5.8-35.8-23.7-65.5-45.4-68.2-21.6-2.6-5.3 13-.7 27 3.3 12.8-5.8 28.7-24 49.5-6.5 7.3-13.8 20-21.4 25.2-1.2.8-11-2.2-12.2-3.8z"
      />
      <g id="rs-e">
        <path
          fill="#edb92e"
          d="M440.6 356.8c-2 1.8-8.8 1.8-18 2.4-14.8.5-23.4-4-25.3-13.5 5.6 6.6 12.2 10 19.7 8 10.2-2.5 16-4.3 18.3-3.8 1.6.4 4 3.3 5.3 6.8z"
        />
        <path
          fill="#21231e"
          d="M422.6 359.7v-1h1.8l.7-.2h2.5l.8-.2h2.8l.8-.2h3l.5-.2h1l.4-.2h.5l.4-.2h.4l.5-.2h.3l.3-.2h.4l.3-.2h.2v-.3h.3l.6.7h-.3l-.3.3-.3.2h-.2l-.3.3h-.4l-.3.2h-.4l-.4.2h-.5l-.5.2h-1l-.5.2h-1.5l-.6.2H432l-.6.2h-2.8l-.8.2h-2.3l-1 .2H423zm0 0zm-25-14.3-.7.6.8-.4.2 1 .2.7.3.8.3 1 .3.6.5.7.4.7.4.6.5.6.4.6.6.6.6.5.6.4.7.5.6.3.8.5.8.4.8.3 1 .4.8.2 1 .3 1 .2 1 .2h1l1 .3h1.2l1.2.3h6.6v1H416l-1-.2h-1.3l-1-.3h-1.2l-1-.3-1-.3-1-.3-1-.2-1-.4-.8-.3-.8-.4-1-.4-.7-.5-.7-.5-.7-.5-.7-.6-.6-.5-.6-.6-.4-.8-.5-.7-.3-.7-.4-.8-.4-.7-.4-1-.3-.7-.3-1-.2-.8 1-.4zm19.3 8 .2 1h-.8l-.7.2h-1.4l-.7.2h-2.8l-.6-.2-.7-.2h-.7l-.6-.3h-.7l-.6-.3-.8-.3-.6-.3-.6-.2-.6-.3-.6-.4-.6-.3-.6-.4-.6-.4-.6-.6-.6-.4-.6-.5-.5-.6-.6-.6-.4-.6-.6-.5-.5-.6-.6-.7.7-.6.5.6.5.6.6.6.5.5.5.5.6.5.4.5.6.5.6.4.5.5.7.4.6.3.6.3.4.3.6.2.6.3.6.2.7.2h.5l.6.3.7.2h.6l.7.2h4.7l.6-.3h.7zm18.5-4-.3 1h-2.6l-.4.2h-.9l-.5.2-.5.2h-.5l-.6.2h-.5l-.6.3h-.5l-.7.3-.7.2h-.6l-.7.3-.7.2-.8.2-.8.2h-.8l-.8.3-1 .3-.8.2-1 .2-.8.3-.3-1 1-.2.8-.2 1-.2.7-.2 1-.2.7-.2.8-.2.7-.2.8-.2.7-.2.7-.2.6-.2h.6l.6-.3h.6l.6-.3h.6l.5-.2h.6l.5-.2h.6l.4-.2h.9l.3-.2h2zm0 0zm5.4 7.8-.7-.8-.2.6v-.7l-.3-.3v-.3l-.3-.3v-.3l-.3-.2v-.3l-.2-.2-.2-.3v-.3l-.3-.2-.2-.3v-.2l-.2-.2-.2-.3v-.2l-.3-.2h-.2v-.3h-.2l-.2-.3v-.2h-.3l-.2-.2v-.2h-.2v-.2h-.4v-.2h-.2l.3-1h.2l.2.2.2.2h.2l.2.2.2.2h.2v.3l.3.2.2.2h.2l.2.3v.2l.2.2.2.2.2.2.2.2.2.3v.2l.3.2.2.3.2.3v.3l.3.4.2.3v.3l.3.3v.3l.3.3v.3l.2.3v.6zm0-.6.2.3-.3.2v-.6zm-21.5-35.4v1.5h-.4v-.4h-.2v-.7l.2-.2h.2v-.2h.2zm15.3 4-.5 1.3-.6-.2-.5-.2h-.6l-.5-.2-.4-.2-.5-.2-.4-.2-.5-.2-.4-.2h-.5l-.4-.3-.5-.2h-.4l-.4-.3h-.5l-.4-.3h-.5l-.4-.2h-.4l-.5-.2h-.4l-.3-.2h-1.3l-.4-.2H420v-2h2.9l.5.2h1l.4.2h.5l.3.2.5.2h.5l.4.2.5.2h.5l.4.3h.6l.5.3.6.2h.5l.6.3.5.2.6.2h.5l.6.3.6.2.5.2.6.2h.5zm9 2.5v1.5H442l-.3-.2h-.4l-.3-.2h-.3l-.4-.2h-.3l-.4-.2h-.4l-.3-.2h-.5l-.3-.2-.4-.2h-.3l-.4-.2h-.2l-.3-.2h-.3l-.3-.3h-.7l-.2-.2h-.4l-.2-.2.4-1.5h.2l.2.2h.2l.2.2h.3v.2h.4l.3.2h.3l.3.2h.4l.3.2.3.2h.4l.3.2h.4l.3.2h.4l.4.2h.3l.4.2h.4l.3.2h.6l.3.2h1zm0 1.5v-1.5h.4v.2h.2v.2h.2v.9h-.2v.2h-.2v.2h-.2zm23.4 7.5.2-1.2h.2v.2h.2v.8h-.6zm-10-2 .4-1.2h.5l.3.2h.4l.3.2h1.1l.2.2h.6l.2.2h.6l.3.2h.7l.4.2h.8l.3.2h.9l.2.2h.9l.5.2h.8l-.2 1.3h-.9l-.4-.2h-.6l-.4-.2h-.7l-.4-.2h-1.4l-.3-.2h-.7l-.3-.2h-.6l-.3-.2h-.5l-.4-.2h-.5l-.3-.2h-.5l-.2-.2h-.5l-.2-.2zm.4-1.2-.3 1h-.2v-.8h.8z"
        />
        <path
          fill="#21231e"
          d="m431.5 332-.7 1.3-.4-.3-.4-.2-.4-.3-.3-.2-.4-.3-.4-.3-.3-.3-.4-.3-.4-.2-.3-.4-.3-.3-.2-.3-.3-.3-.3-.4-.2-.3-.3-.4-.2-.3-.3-.4-.2-.4-.2-.3-.3-.5-.2-.4-.2-.2v-.4l-.3-.4-.2-.3-.2-.4-.2-.3v-.4l-.2-.3-.2-.3-.2-.4 1.4-.7.2.2.2.4v.3l.3.2.2.4.2.3v.3l.3.3.2.4.2.3.2.4v.3l.3.4.3.3.2.4.2.4.2.4.3.3.2.4.3.4.2.3.3.4.3.3.3.3.3.2.3.3.3.3.2.2.4.3.3.2.2.2.3.2zm7.6-5.3 1.5.8-.2.4-.2.3-.2.4-.2.4-.3.5-.3.4-.2.2-.3.4-.3.3-.3.2-.3.3-.3.3-.3.3-.2.4-.3.2-.3.2-.4.2-.3.2-.3.2h-.3l-.5.2h-.3l-.3.2h-2.2l-.4-.2-.3-.2h-.2l.7-1.5h.5l.2.2h1.7l.3-.2h.2l.3-.2h.2l.3-.3.2-.2.3-.2h.2l.3-.3.2-.3.3-.2.2-.3.3-.4.2-.3.3-.3.2-.4.2-.3.3-.4.2-.5.2-.4v-.3z"
        />
        <path
          fill="#21231e"
          d="m429.6 331-2.2-2.3c-1-1.3-.5-3 2-5.4 1.5.7 3 1.3 4.2 2-1 3-2.2 4.8-4 5.6zm-6.3 82-.4 1h-.4v-1h.8zm23.8-3.6 1 1-.7.5-.6.4-.7.5-.6.4-.7.5-.7.3-.7.4-.7.4-.7.4-1 .3-.6.3-.8.2-.7.2-1 .2-.7.2h-.8l-.8.2h-5l-1-.2h-.8l-.8-.3h-1l-.8-.4h-1l-.7-.3-1-.3-.8-.3.3-1 .8.2 1 .3 1 .3.7.2 1 .2.7.2h.8l1 .2h.7l.7.2h4.8l.7-.2h1l.6-.3.7-.2h.7l.7-.4.7-.3.7-.3.8-.3.6-.4.7-.4.7-.5.6-.5.6-.5.5-.5.6-.6zm3-2.8 1 .8h-.2v.2h-.2l-.2.2v.2h-.2v.2h-.2v.2h-.2l-.2.2-.2.2v.2h-.2v.2h-.2l-.2.2-.2.2-.2.2-.2.2v.2h-.2l-1-.8h.2v-.2h.2v-.2h.2l.2-.2.2-.2.2-.2v-.2h.2v-.2h.2l.2-.2.2-.2.2-.2v-.2h.2l.2-.2.2-.2v-.2h.2zm1 .8-1-.8.2-.2h.7v.2h.2v.8z"
        />
        <path
          fill="#21231e"
          d="m452.2 401.3-1.2-.2v-.2h.2l.2-.2h.6v.4h.2v.2zm-5.5 16 .3 1-.7-.8.2-.4.2-.4.2-.5v-.4l.3-.4.2-.5.2-.5v-.5l.3-.4.2-.5.2-.5v-.5l.3-.5v-.5l.3-.5v-.5l.3-.5v-.5l.3-.5v-.5l.2-.5.2-.6v-.5l.2-.6v-.5l.2-.4v-.6l.2-.6v-.5l.2-.7v-.6l.2-.6 1.2.3v.6l-.2.5v.6l-.2.6v.6l-.2.6v.5l-.2.6-.2.4v.6l-.2.5v.6l-.3.6v.5l-.3.6v.6l-.3.5v.5l-.2.5-.2.5v.5l-.3.5-.2.5v.5l-.2.4-.2.5-.2.6-.2.5-.2.6-.2.5-.2.5-.2.5-.7-.8zm-.4.2 1 .5v.2h-.2v.2h-.4l-.2-.2v-.2h-.2v-.4zm15.2-9.5 1 .7-.3.4-.4.6-.3.4-.4.4-.2.4-.4.4-.4.4-.4.4-.4.3-.4.4-.5.3-.4.4-.6.3-.4.3-.5.3-.5.3-.5.3-.5.2-.5.3-.5.3-.6.2-.5.3-.7.2-.5.3-.6.2-.6.2-.6.2-.6.2-.6.2-.6.2-.6.2-.6.2-.3-1.2.6-.2h.6l.5-.3.6-.2.6-.2.6-.2h.6l.5-.3.6-.3.4-.2.5-.2.4-.3.5-.2.4-.3.5-.3.4-.4.5-.3.3-.3.5-.3.4-.3.4-.3.4-.2.4-.4.4-.3.4-.3.4-.3.3-.4.3-.4.3-.4.3-.4.2-.4.3-.4zm1 .7-1-.7h.2v-.2h.7v.2h.2v.7z"
        />
        <path
          fill="#21231e"
          d="M461.3 400.2H460v-.2h.2v-.2h1v.4zm4.4 15.7.7 1-.8-.3-.3-.4-.3-.4-.2-.5-.3-.5-.2-.4-.3-.4-.2-.5-.3-.5-.2-.4-.2-.5v-.5l-.3-.5-.2-.5-.2-.5-.2-.5v-.5l-.2-.5-.2-.5v-.6l-.3-.5v-.5l-.3-.6v-.4l-.2-.6v-.6l-.2-.5v-.7l-.2-.6v-.6l-.2-.5v-1.2h1v.5l.2.6v.6l.2.5v1.4l.2.5.2.6v.5l.2.5v.6l.3.5v.4l.2.5.2.4v.5l.2.4.2.5.2.4.2.5.2.4.2.4.2.5.2.4.2.5.3.4.3.4.2.4.3.5.2.3.3.4.3.3h-1zm0 .7 1-.7v.8l-.2.2h-.2v.2h-.4v-.2h-.2zm7.6-12.6 1 .4v.6l-.2.5v.5l-.2.5-.2.5-.2.5-.2.5-.2.5-.2.4-.2.4-.2.4-.3.5v.4l-.4.4-.2.5-.3.4v.3l-.4.3-.3.4-.3.4-.2.3-.3.3-.3.4-.3.3-.4.3-.3.3-.3.3-.3.2-.3.3-.3.4-.3.2-.3.3-.7-1 .3-.3.3-.2.3-.3.3-.2.2-.3.3-.3.2-.2.3-.3.3-.4.3-.3.2-.4.3-.4.4-.3.2-.4.3-.4v-.4l.4-.3.2-.5.3-.4v-.3l.3-.4.2-.4.2-.6.2-.4v-.5l.3-.4.2-.4.2-.5v-.4l.3-.5v-.4l.3-.5zm1 .4-1-.3v-.2h.8v.2h.2v.4z"
        />
        <path
          fill="#edb92e"
          d="M406 317.8c-16.7 1.8-16 12.6-.4 28 3 3 4 3 4.6-.2 1.2-5.3 7-8.5 10.2-4.4 2 2.7 1.6 4.3 8.6 3.3 9 7.5 16.2 12.8 4.5 12.3-5-.2-9 2.8-15.7 2.5 2 4 2.3 4.3 3.4 4.6 6.5 1.2 13.3-2.8 19.8-1.6 14.3 2.6-23-38.6-22.4-40.3 1-4-9-11.5-12.7-4.2z"
        />
        <path
          fill="#21231e"
          d="m406 345.5-.7.7-1.4-1.5-1.5-1.4-1.2-1.4-1.2-1.4-1-1.3-1-1.3-.8-1.3-.8-1.2-.8-1.2-.6-1.2-.5-1-.5-1.2-.3-1-.3-1v-1l-.2-1v-1l.2-1 .2-.8.4-.8.4-.8.6-.7.6-.7.8-.6.8-.6 1-.5 1-.5 1-.4 1.4-.4 1.3-.3 1.3-.2 1.6-.2v1l-1.5.2-1.4.2-1.2.3-1.2.3-1 .4-1 .5-1 .4-.6.5-.7.7-.6.6-.4.6-.4.6-.4.7-.2.8-.2 1v1.7l.2.8.2 1 .4 1 .4 1 .5 1 .5 1.3.7 1 .8 1.3 1 1.4.8 1.2 1 1.3 1.2 1.3 1.2 1.3 1.4 1.4 1.4 1.5zm3.8 0 1 .2v.3l-.2.3v.5l-.2.2v.2l-.2.2v.2l-.2.2-.3.3v.2h-.3l-.2.2H408l-.2-.2h-.2l-.2-.2h-.2l-.2-.3-.2-.2h-.2l-.3-.4h-.2l-.2-.3-.3-.3-.2-.2.7-.7.2.2.3.3.2.2.3.2.2.2.2.2h.2l.2.2.2.2h.3v.2h.6l.2-.2v-.2l.2-.2v-.2l.2-.4v-.4l.2-.3zm11-4.6-.8.5-.3-.4h-.3l-.3-.4-.2-.2-.3-.2h-.3l-.3-.2h-.5l-.3-.2h-1.5l-.3.2-.4.2h-.2l-.4.3-.3.2-.2.2-.4.2-.3.2-.2.3-.3.3-.2.4-.3.3-.2.4-.3.5-.2.4-.2.3v.5l-.2.4v.5l-1-.2v-.5l.2-.5.2-.5.2-.5.3-.5.2-.4.2-.4.3-.4.3-.4.3-.4.4-.3.4-.3.4-.3.4-.2.3-.2.3-.2.5-.2h.4l.4-.2h.4l.4-.2h1l.4.2h.6l.4.3.4.3.3.2.4.3.4.5.4.4zm8.6 3.2-.7.7h.4-.5l-.6.2h-4.5l-.2-.2h-.3l-.2-.2h-.2l-.2-.2-.2-.2-.2-.2h-.2v-.3l-.3-.3v-.2l-.3-.2v-.2h-.3l-.2-.3-.2-.3v-.2l-.3-.2v-.3l-.3-.2.8-.6h.2v.4l.3.2.2.3.3.3v.2l.2.2.2.2.2.2.2.2.2.2h.2v.2h.3l.2.2h.2l.2.2h5.4zm-.4 0 .2-.2.2.2h-.4zm4.5 13v-1h4.1l.5-.2h.4l.3-.3h.2v-1l-.2-.3-.2-.4-.3-.5-.4-.4-.5-.4-.4-.4-.4-.5-.6-.5-.6-.6-.6-.6-.7-.5-.6-.6-.7-.7-.7-.7-.8-.6-.8-.7-.8-.7-1-.7.8-.8.8.7.8.5.8.7.8.7.7.5.8.6.8.7.7.6.6.6.7.4.6.6.5.5.5.5.4.5.4.4.4.4.3.4.2.4v2.3l-.4.3-.3.2-.4.3-.6.2h-.6l-.7.2h-3.6zm-15.2 2-1 .4.5-.8h3.4l.6-.2h.5l.5-.2h.5l.5-.2h.5l.4-.2h.5l.5-.2.4-.2h.6l.4-.2.5-.2h.4l.4-.2h.5l.3-.2h.5l.4-.2h.5l.5-.2h2.6v1H431l-.4.2h-.9l-.4.3h-.8l-.4.2h-.5l-.4.3h-.6l-.5.2h-.5l-.5.3h-.5l-.5.2h-.5l-.5.2h-.5l-.6.2h-.6l-.6.2h-3l.5-.7zm-1 .4-.3-.8h.8l-.4.8zm4 4-.2.8h-.4v-.2h-.2l-.2-.2h-.2v-.2h-.2v-.2h-.2v-.2l-.2-.3-.2-.2-.3-.3-.2-.2v-.2h-.2v-.4l-.3-.2v-.3h-.3v-.4l-.3-.3v-.4l-.3-.4 1-.5v.5l.2.3.2.3v.4l.3.3.2.2v.2l.3.2v.2l.2.2v.2h.2v.3l.2.2v.2l.2.2h.2v.2h.4v.2h.4zm-.2.8zm20-2.5v1l-.7-.2h-4.7l-.6.2h-.7l-.6.2h-.7l-.6.2-.6.2h-.6l-.6.2h-.7l-.7.3-.6.2h-.6l-.6.2h-.6l-.6.2h-4.6l-.6-.2.3-1 .6.2h4.8l.6-.2h.6l.5-.2h.6l.7-.2.7-.2h.6l.6-.2.6-.2h.7l.5-.2h.6l.7-.2h.7l.6-.2h4.9zm-23-40 1 .3.3.3.5.7.6.8.8 1.2 1 1.2 1 1.3 1 1.5 1.3 1.5 1.3 1.7 1.4 1.8 1.4 1.8 1.5 1.8 1.5 2 1.5 1.8 1.4 2 1.4 2 1.3 1.7 1.3 2 1.2 1.7 1 1.7 1 1.6.8 1.5.6 1.4.4 1.3.3 1.2v2l-.6.7-.8.5H441v-1h2l.4-.3.3-.4V360l-.3-1.2-.4-1.2-.6-1.3-.8-1.5-1-1.6-1-1.7-1-1.8-1.3-1.8-1.4-2-1.4-2-1.4-1.8-1.5-2-1.4-1.8-1.5-1.8-1.4-1.8-1.3-1.8-1.3-1.6-1.2-1.6-1-1.5-1.2-1.3-1-1.2-.7-1-.6-1-.5-.7-.3-.4v-.6zm-12-3.7v-1l-.5.2.4-.6.3-.7.5-.6.5-.4.5-.3.6-.3.5-.2.5-.2h2.6l.6.2.6.2.5.3.6.2.6.3.4.4.5.2.4.4.4.4.5.5.4.4.3.4.3.4.3.5.2.5.2.5v.5l.2.5v1l-1-.3v-1l-.2-.4v-.4l-.3-.4-.2-.4-.3-.4-.3-.4-.5-.4-.3-.4-.5-.4-.4-.4-.5-.3-.4-.3-.5-.3h-.7l-.5-.3-.5-.2h-.5l-.6-.2h-2l-.4.3-.5.2-.4.3-.5.5-.4.4-.3.4-.3.6-.4.3zm.4-.3-.2.2h-.2l.4-.2zm-.5-.2v.5-.5zm.4.2-.2.2h-.2l.4-.2z"
        />
        <path
          fill="#21231e"
          d="m407 317.2-1.3.4v-.6h.2v-.2h.8v.2h.2v.2zm7.6 10.6-.8 1-.4-.4-.3-.4-.3-.3-.3-.3-.4-.3-.3-.2-.3-.4-.3-.3-.2-.2-.3-.4-.3-.3-.3-.2-.4-.4-.3-.3-.2-.2-.2-.4-.2-.3-.3-.3-.2-.3v-.4l-.4-.3-.2-.4-.2-.4-.2-.4-.2-.4v-.4l-.3-.3-.2-.4v-.3l-.3-.3v-.4l-.3-.4 1.2-.4v.7l.3.3v.3l.3.4v.3l.3.4v.3l.3.4.2.3.2.3.2.4v.3l.3.3.2.4.3.3.2.3.3.4.2.3.3.3.3.3.4.4.2.3.3.3.2.3.3.3.4.2.2.3.3.3.4.4.2.3.4.3zm-.8 1 .8-1v.2h.2v.7h-.4v.2h-.7zm-9.5-4.6c.8 0 1.3.7 1.2 1.5s-.8 1.3-1.5 1.2c-.8-.2-1.3-.8-1.2-1.6s.8-1.3 1.5-1.2zm-45.9 38.4h.2v-.2h.4v.2h.2v.2l.2.2v.4h-.2l-.8-.8zm-22.7 56 .2-1V416l.4-1.5.3-1.5.4-1.7.6-1.8.5-2 .7-2 .6-2 .6-2 .6-2.2.8-2.2.7-2.2 1-2 .7-2.3 1-2.3.7-2.2 1-2.2.8-2 1-2.2.8-2 1-2 .8-2 1-1.7.8-1.5 1-1.6.7-1.5 1-1.3.7-1.2.8-1 .8-.8.8-.6.7 1-.6.5-.7.8-.7 1-.8 1-1 1.3-.7 1.5-1 1.5-.7 1.7-1 1.7-.8 2-1 1.8-.8 2-1 2-.8 2.3-1 2-.7 2.3-1 2.3-.7 2.3-.8 2.2-.7 2.2-.8 2.2-.6 2-.6 2-.6 2.2-.6 2-.5 1.8-.4 1.8-.4 1.6-.5 1.6-.2 1.4-.2 1.3v1H336zm5.6 80.5-.7-2-.7-2-.7-2.2-.6-2.2-.6-2.2-.4-2.4-.4-2.3-.5-2.4-.4-2.5-.3-2.4-.3-2.5-.3-2.7-.2-2.6-.3-2.6-.2-2.5-.2-2.6v-3l-.2-2.7v-18.5l.3-2.7v-2.5l.2-2.6v-2.7l.3-2.6.2-2.5.2-2.5h1.2l-.3 2.6-.2 2.5-.2 2.6-.2 2.6v2.6l-.2 2.6v2.6l-.2 2.7v18.8l.2 2.6v2.6l.3 2.6.3 2.6.3 2.6.3 2.5.2 2.5.3 2.5.4 2.4.3 2.5.5 2.3.5 2.3.5 2.3.6 2.2.6 2 .7 2.2.7 2-1 .4zm1-.4v.8h-.8v-.2l1-.6z"
        />
      </g>
      <use
        xlinkHref="#rs-e"
        width={1350}
        height={900}
        transform="matrix(-1 0 0 1 964.3 0)"
      />
      <path
        fill="#21231e"
        d="M473 398.4h-.2v.5h-.2v.8l.2.7v1.6l.2.8.2.8v.7l.3.8v.8l.3.7.2.8.3.7.2.7.2.7.3.7.3.8.3.7.3.7.2.7.3.6.4.6.2.7.4.5.4.7.4.7.4.5.5.6.4.8.5.6.4.6.5.6.6.6.2.2h.8v-.2l.6-.6.5-.6.5-.6.4-.6.5-.7.5-.5.4-.6.3-.8.4-.6.3-.7.4-.8.4-.6.3-.7.4-.8.3-.7.3-.7.3-.7.3-.6.2-.7.3-.7.3-.7.2-.8v-.7l.3-.7.2-.7v-.7l.3-.8v-1.4l.2-.8v-2.1h-1v.4l-.2 1v1.4l-.2.7v.7l-.2.7-.2.7v.8l-.3.7-.2.7-.2.7v.6l-.3.7-.3.7-.2.7-.3.7-.4.6-.2.7-.4.7-.3.6-.3.7-.4.6-.4.7-.3.6-.4.6-.5.6-.4.6-.4.7-.4.7-.4.6-.5.6h-.2l-.5-.7-.4-.6-.4-.6-.4-.6-.4-.6-.4-.6-.4-.6-.4-.6-.3-.7-.4-.6-.4-.7-.3-.6-.3-.7-.4-.7-.2-.6-.3-.7-.2-.7-.2-.7-.2-.7-.2-.7-.2-.8-.2-.7-.2-.7v-.7l-.3-.6v-.8l-.2-.7v-2.3l-.2-.8v-.4h-.2v-.2h-.5z"
      />
      <path
        fill="#c6363c"
        d="M549.2 422v108.6a72 72 0 0 1-19.7 49.8 65 65 0 0 1-94.7.1 72.9 72.9 0 0 1-19.7-49.8V422h134.2z"
      />
      <use
        xlinkHref="#rs-f"
        width={1350}
        height={900}
        transform="matrix(-1 0 0 1 964.3 -90)"
      />
      <path
        fill="#fff"
        stroke="#21231e"
        d="M549.2 488.6v28h-53v83a63.8 63.8 0 0 1-14 1.5 59 59 0 0 1-14-1.5v-83h-53v-28h53V422h28v66.6h53z"
      />
      <use
        xlinkHref="#rs-f"
        width={1350}
        height={900}
        transform="translate(0 -90)"
      />
      <path
        id="rs-f"
        fill="#fff"
        stroke="#21231e"
        d="M459 567.3V528c-8.4-2.3-29.3-10.6-30.3 7.6-.5 8.4 10.4 14 13.3 6.5 1.4-3.4 0-6-2-6.7-2.4-.8-4.6 1-4 3.6-8.8-4.7 8-14.6 15.5-1.7 2.2 3.7-3.7 7.6-3.7 10.4 0 2.7 5.8 7 3.7 10.3-7.7 12.8-24.3 3-15.5-1.6-.6 2.7 1.6 4.5 4 3.6 2-.8 3.4-3.3 2-6.8-3-7.5-13.8-2-13.3 6.5 1 18.2 22 10 30.4 7.6z"
      />
      <use
        xlinkHref="#rs-f"
        width={1350}
        height={900}
        transform="matrix(-1 0 0 1 964.3 0)"
      />
      <path
        fill="#21231e"
        d="M414 421v113.3l.2 1.7v2l.4 1.7.2 1.8.3 1.7.4 1.8.3 1.8.4 1.7.6 1.7.5 1.7.6 1.5.6 1.7.5 1.6.7 1.6.7 1.6.7 1.6.8 1.6.8 1.5.8 1.5 1 1.5.8 1.5 1 1.4.8 1.4 1 1.4 1 1.4 1 1.3 1 1.5 1.2 1.2 1 1.3 1.2 1.2 1.2 1.2 1.2 1.2 1.2 1 1.3 1.3 1 1 1.4 1 1.3 1 1.4 1 1.5 1 1.4 1 1.3.8 1.4.8 1.5.8 1.4.8 1.6.7 1.5.6 1.5.7 1.5.6 1.6.5 1.6.5 1.5.5 1.6.5 1.8.4 1.6.4 1.7.4 1.8.2 1.7.3 1.7.2h1.7l1.6.2h8.9l1.7-.3 1.8-.3 1.7-.3 1.7-.2 1.7-.4 1.5-.4 1.7-.4 1.6-.5 1.6-.5 1.6-.5 1.5-.6 1.6-.7 1.6-.7 1.6-.7 1.5-.8 1.4-.8 1.6-.8 1.4-1 1.5-.7 1.4-1 1.2-1 1.4-1 1.3-1 1.2-1 1.3-1 1.2-1.3 1.2-1 1-1.3 1.3-1.2 1.2-1.2 1-1.3 1.2-1.2 1-1.4 1-1.2 1-1.4 1-1.4 1-1.4 1-1.4.7-1.5 1-1.5.7-1.5.8-1.5.8-1.6.7-1.6.6-1.6.6-1.6.6-1.6.5-1.7.5-1.6.5-1.8.4-1.7.6-1.7.3-1.8.2-1.8.3-1.7.3-1.8v-.9l.3-2 .2-1.7V421H414zm2.3 2.2H548V536l-.3 1.6-.2 1.8-.2 1.7-.3 1.8-.3 1.7-.4 1.7-.3 1.7-.5 1.5-.4 1.7-.4 1.6-.5 1.6-.5 1.6-.6 1.5-.8 1.6-.7 1.6-.7 1.5-.7 1.6-.7 1.4-.8 1.5-.8 1.4-1 1.3-.8 1.4-1 1.3-1 1.3-1 1.3-1 1.3-1 1.2-1.2 1.2-1 1.2-1.2 1-1.2 1.3-1.2 1-1.2 1-1.2 1-1.3 1-1.2 1-1.4 1-1.4 1-1.3.8-1.4 1-1.5.7-1.4.8-1.3.7-1.5.8-1.5.6-1.4.7-1.5.7-1.6.5-1.5.6-1.5.5-1.6.4-1.6.4-1.6.5-1.6.3-1.6.3-1.7.4H489l-1.8.3h-1.7l-1.6.2h-3.6l-1.6-.2H477l-1.6-.3h-1.6l-1.7-.4-1.5-.2-1.6-.3-1.7-.4-1.6-.3-1.6-.4-1.4-.5-1.6-.6-1.5-.5-1.5-.6-1.5-.6-1.4-.6-1.4-.8-1.4-.7-1.4-.8-1.4-.8-1.4-1-1.3-.7-1.4-1-1.3-1-1.2-1-1.3-1-1.2-1-1.2-1-1-1-1.3-1.3-1-1-1.2-1.3-1-1.2-1-1.3-1.2-1.4-1-1.3-1-1.3-1-1.3-.8-1.4-.8-1.4-1-1.5-.7-1.5-.8-1.4-.7-1.5-.8-1.4-.6-1.5-.6-1.5-.6-1.5-.5-1.6-.6-1.6-.5-1.6-.5-1.7-.4-1.6-.4-1.8-.4-1.7-.3-1.7-.3-1.7-.2-1.6-.2-1.8-.2-1.7v-5.4z"
      />
    </g>
  </svg>
)

export default RsFlag
