// This file is generated by @lib/ui/country/codegen/generateFlags.ts
import { SvgIconProps } from '@lib/ui/icons/SvgIconProps'

const MpFlag = (props: SvgIconProps) => (
  <svg
    width="1em"
    height="0.75em"
    xmlns="http://www.w3.org/2000/svg"
    id="flag-icons-mp"
    viewBox="0 0 640 480"
    {...props}
  >
    <defs>
      <clipPath id="mp-a">
        <path fillOpacity={0.7} d="M0 0h640v480H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#mp-a)">
      <path fill="#0071bc" fillRule="evenodd" d="M-160 0h960v480h-960z" />
      <path
        fill="#fff"
        fillRule="evenodd"
        stroke="#000"
        strokeWidth={1.9}
        d="M370 365.7s15.2-16.1 29.8-13c4.4-17 21-18.4 21-18.4s-1.7-18.7 19.5-22.8c.6-12.7 13.5-23.3 13.5-23.3s-2.6-19.7 10.8-24.3c-8.2-15.6 2.8-27 2.7-27.3-.2-.3-14-24.8-1.6-31.8-13-11-8.8-23.4-8.8-23.4s-14.2-3.7-9.1-20.7c-11.7-2-14-20.9-14-20.9s-18 3.7-20.2-12c-12 1.9-13.2-9.8-13.4-9.8-.1 0-23.5 6.3-28.2-11.4-9.1 4.7-13-3.7-13-3.7s-13 6.5-20.8-6c-15.5 9.7-24.2-.4-24.2-.4s-20.3 13.4-27 3c-12 12.2-22.8 7-22.8 7s-9 16-23.7 12c-3.3 14.9-20.2 15.2-20.2 15.2s1.8 13.1-18.4 16.7c-2.6 15.5-13.2 18-13.2 18s1 15.2-8.5 20c3.4 8.5-5.4 18.9-5.4 18.9s9.4 11.7-3.4 24.9c12.3 3.2 3.4 24.4 3.4 24.4s17 7.6 6.3 21.7c12.2 4 8.4 13.6 8.5 19.3 7.8 3.5 14.6 1.8 11.3 17.4 23.8 2.7 12.6 15.8 12.6 15.8s11 .5 6.7 9.3c20.3-.5 23.3 15.2 23.3 15.2s18.8-5 21.3 2.3-8.2 56.7-8.2 56.7-16 0-27.8-12.8c-27.8-.7-21.6-19-22-19-.5 0-9.3 3.4-13.8-11.9-18.6 3.8-18-11.8-18.2-12-.1-.1-8.3-3.8-5.3-11.5-19.1 1.7-17.7-17-17.7-17-4.2-1.7-5.7-5.6-5.1-9.5-2.5-.9-19.5-1.2-10.7-23.6-16.2-9.8-6.1-21-6.1-21s-22.4-11.6-5.1-25c-13-19 1-28.5 1-28.5s-17.9-18.1.3-31c-3-27.5 13.4-34.1 13.4-34.1s-8.6-22.4 14.8-31.8c1.5-22.7 17.9-23.3 17.9-23.3s.4-18 26.2-16.2c5-16.1 22.5-12.9 22.5-12.9s5.4-19.5 29.3-10.1c12.1-23.7 30.2-11.6 30.2-11.6s11.4-7.4 17-5c7.3-12.5 22.8-.6 32.7 1.9 3.7-1.5 16.6-11.2 26.5 1 13.2-8.5 24.5 7 24.5 7s18.1-9.2 26.6 11.8c38.5-3.5 33 21.7 33 21.7s30.2-6.9 23.6 23.3c27.6 1.9 24.8 20 24.8 20s17.4 13.2 9.8 25c15.5.8 9.8 15.7 9.8 15.7s11.9 4.6 2 23c22.7 18.1 4.4 36.2 4.3 36-.2-.1 12.1 14.6 1 31.6 3.4 27-10.2 33.8-10.2 33.8s3.5 17.5-11.7 22.4c-.3 20.5-19.7 23-19.7 23s5.2 9-14 18.3c-.8 13.7-20.8 14.8-20.8 14.8s-1.9 25.2-27.4 18.4c-6.1 20.2-36 14.2-36.6 14-.5-.3-5.7-43.4-5.7-43.5z"
      />
      <path
        fill="#217900"
        fillRule="evenodd"
        stroke="#000"
        strokeLinejoin="round"
        strokeWidth={1.9}
        d="M185 124s6.4 5.6 5.2 14c-1.2 8.3-6 19.9-5 28.5.6 3.5.3 9.7.3 9.7s-5.7-8.2-5.8-17 6.2-17.1 6.2-23.6-1.1-11.7-1-11.5zm-3.2 2.6s-8.4 8-9.5 15.7c-.8 4-1 22.7-1.2 31-.2 2.5-1.2 12.5-1.4 16.2-.3 3.6 6.1-6.2 6.5-14.3-.2-8.3-.2-25.8.6-28.5.8-3.4.6-7.1 1.8-10.5l3.2-9.6z"
      />
      <g fill="#ffd200" fillRule="evenodd" stroke="#ef8a10">
        <path
          strokeWidth={1.9}
          d="M366 100.5s10.8-5 14-14.4-9.5-9.4-11.1-6.4c-1.7 3 1.4 10.3.6 12.3-.8 2-5.2 6.6-3.5 8.4z"
        />
        <path
          strokeWidth={2.5}
          d="M269.8 103.9s7-9.7 5.2-19.4c-1.9-9.6-12.8-3.6-12.8-.2s6.2 8.3 6.5 10.4c.3 2.1-1.3 8.4 1 9.1zm-19.1 5.7s7-9.7 5.2-19.3c-1.8-9.7-12.8-3.7-12.8-.3 0 3.4 6.3 8.4 6.6 10.5.2 2-1.3 8.3 1 9.1zm-21.1 6.5s7-9.6 5.2-19.3c-1.9-9.7-12.8-3.7-12.8-.3 0 3.4 6.2 8.4 6.5 10.5.3 2-1.3 8.3 1 9.1zm-15 14.9s7.1-9.7 5.3-19.3c-1.8-9.7-12.8-3.7-12.8-.3 0 3.4 6.3 8.4 6.5 10.5.3 2-1.3 8.3 1 9.1zM199 145.4s7-9.7 5.2-19.4-12.8-3.6-12.8-.2 6.3 8.3 6.6 10.4c.2 2.1-1.3 8.4 1 9.2z"
        />
        <path
          strokeWidth={1.9}
          d="M235 61.7s-9.4 7.4-10.2 17.2c-.8 9.8 11.3 7 12.2 3.7 1-3.3-3.7-9.7-3.4-11.8.3-2 3.5-7.7 1.4-9zm31.3-9.6s-9.3 7.4-10.2 17.2c-.8 9.8 11.3 7 12.3 3.7.9-3.3-3.8-9.8-3.5-11.9.3-2 3.5-7.7 1.4-9zm-116.7 84.5s2 11.8 10.2 17.3c8.2 5.4 11.5-6.6 9.1-9s-10.3-1.4-12-2.6c-1.7-1.3-5-6.8-7.3-5.7zm-15.6 40s0 12 7.3 18.7c7.2 6.6 12.4-4.7 10.4-7.4s-10-3-11.4-4.5c-1.5-1.6-4-7.5-6.3-6.7zm36 44.8s-4.2-11.2-13.3-15c-9.1-3.6-10 8.8-7.2 10.7 2.9 1.8 10.4-.7 12.3.2 2 .9 6.3 5.6 8.3 4zm-7.4-19.4s7.2-9.5 5.6-19.1c-1.7-9.7-12.7-4-12.8-.6 0 3.4 6 8.5 6.3 10.6.2 2.1-1.5 8.3.9 9.2zm225.6-91.9s10.8-5 14-14.3-9.5-9.4-11.1-6.5c-1.7 3 1.4 10.4.6 12.3-.8 2-5.2 6.7-3.5 8.5zm32.8 16.4s6.4-10.1 3.9-19.6c-2.5-9.5-13-2.8-12.8.6.2 3.3 6.8 7.9 7.2 10 .4 2-.7 8.4 1.7 9zm89.6 93s-4.3-11.1-13.4-14.9c-9.1-3.7-10 8.8-7.2 10.6 2.9 1.9 10.5-.7 12.3.2 2 1 6.3 5.7 8.3 4.1zm-43.8 7s.2-12 7.5-18.6c7.3-6.6 12.4 4.9 10.4 7.6-2.1 2.7-10 2.8-11.6 4.3-1.4 1.5-4 7.4-6.3 6.6zm-7-126.8s-11.3-4.3-20 0c-9 4.4-.2 13.4 3 12.5 3.3-1 6.4-8.3 8.4-9.1 2-.8 8.4-1 8.5-3.4zM434 78.3s-11.1-4.3-20 0c-8.8 4.4-.1 13.4 3.2 12.5 3.2-1 6.4-8.3 8.3-9.1 2-.8 8.4-1 8.5-3.4zm-38-20.4s-9.5 7.3-10.4 17c-1 9.8 11.2 7.1 12.2 3.9 1-3.3-3.7-9.8-3.4-11.9.4-2 3.6-7.6 1.6-9zm-24.8-6s-4.4 11.1-.1 20c4.3 8.9 13.3.2 12.4-3-.9-3.3-8.2-6.5-9-8.4-.8-2-.9-8.5-3.3-8.6zm-70.5 43s7.7-9.2 6.6-19c-1.1-9.7-12.5-4.5-12.7-1.1-.3 3.4 5.6 8.8 5.7 10.9.1 2-1.9 8.2.4 9.1z"
        />
      </g>
      <path
        fill="#8c8a8c"
        fillRule="evenodd"
        stroke="#000"
        strokeWidth={1.9}
        d="M342.8 114.4s18.5 1.2 19.4 11.8-4.4 17.1-4.4 17.1 2.3 23-15.8 29.7c-19.4 2.3-49.9.5-49.9.5s-9 2.2-12.6-16.3a305 305 0 0 1-4.6-31.6s1.8-10.4 14.9-11c13-.7 52.8 0 53-.2z"
      />
      <path
        fill="none"
        stroke="#000"
        strokeLinecap="round"
        strokeWidth={1.9}
        d="M357.7 143.2s-10 12.4-9 17.5"
      />
      <path
        fill="#8c8a8c"
        fillRule="evenodd"
        stroke="#000"
        strokeWidth={1.9}
        d="M344.3 172.3c2.5 2.1 4.8 4.4 5.3 12l1 15.4 13 116.6 11.4 84.3.8 13s-2.7 9.7-10.4 10.5c-5.5 11.6-35.7 15-38.7 14.9-2.7-.2-12.3-4.2-18.1-3.7-5.9.5-16 4.4-20.5 3.8-4.5-.7-14.8-4.2-16.6-11.6-12.7-4-14.7-13.7-14.7-13.7l13.7-97.5 13.3-123.4s1.6-16.4 8.2-18.9c6.9-.6 42.4.7 52.3-1.7z"
      />
      <path
        fill="none"
        stroke="#000"
        strokeWidth={1.9}
        d="m274.4 341.1-2.7 86.3m86.5-74.9 7.6 71.2"
      />
      <path fill="none" stroke="#000" d="m136.6 296.3-.3 1m358.7-4.1.3 1" />
      <path
        fill="none"
        stroke="#6b18b5"
        strokeLinejoin="round"
        strokeWidth={1.9}
        d="M127 179.8s5.6 7.9 6.7 12.4c1 4.5 2.9 13.4 5.3 17 2.5 3.7 16.6 23.9 17.4 32.3.1 5.6-5.9 15-14.7 15.2-5.6-.2-19.8-3.8-20.4-16-.6-12.3 4.3-12.5 5-20 .5-7.4.7-40.7.7-40.9z"
      />
      <path
        fill="none"
        stroke="#6b18b5"
        strokeLinejoin="round"
        d="M224.5 72.8s-6 .4-10.4 2.9c-3.5 2.1-9.5 5.3-13.6 11-10.6 8.2-26.5 12-31.5 19-3 4.6-2.8 15.7 4.7 20.5 4.8 2.7 19 7 25.8-3.1 6.8-10.2 2.7-13 6-19.6a117.4 117.4 0 0 1 19-30.7zM367 58s-4.4-4-9.3-5.5c-4-1-10.6-.6-17.5-1.3-13.3-1.8-27-11.4-35.3-10.2-5.4 1-13.3 9-11.5 17.6 1.3 5.4 7.3 16.2 19.4 14.1 12-2.1 12-4.8 19-7 17.4-9.7 35-7.7 35.2-7.7zm141.4 137.4c1-2.3-.9-6.6-2.2-11.5-1.2-4-3.1-10-7.7-15.5-5.4-12.2-4.5-29-10-35.4-3.7-4-14.6-6.6-21-.4-3.9 4-11.4 16.6-3.2 25.7 8.2 9 11.8 5.7 17.4 10.5 13.5 9 20 25 26.7 26.6zM503.5 302c1.9-2.5 5.2-7.4 4.8-11.5-.3-3.2 1.5-13 1.7-17.3 1.2-13.3 9.5-24.2 7.2-35.7-1.3-5.4-9.2-13-17.8-10.8-5.2 1.6-17 8-14.3 20 2.7 12 6.6 11.7 9.1 18.7 7.3 14.5 2.7 31.7 9.3 36.6z"
      />
      <path
        fill="none"
        stroke="#000"
        strokeWidth={1.9}
        d="M405.5 386.8s-2.3 4.4 6.8 8.2m11.3-18.4s10-2.5 16.8 0m13.2-25.4c0 .2-1.4 4.5 6.6 10.8m-.8-22s5.9 4.3 15.8 4m-75.4 8.6s.3 11.5-5.6 16.8m25.4-34.5s9.7 2.4 17.7-1.6m44.6-15.3s2.1 3 12.9 2.5m-54.9-9.3c.3.2 12.7 4.2 20.5.6m4.2-47.8s.5-.7 4.3 12.7m5.2-50.4s-.5 7.1-6.2 10.2m42.9-39.4s-8.4 6.8-6.8 9.5m-34.7-14.4s4.3 7.3-2.8 12.3M448.2 161s7.5-.3 10.8 6.1m-24.8-27.3h5.7m24-26c0 .1 1.5 1.5-1.4 4.5m-52-3.8s4 6.2 3.3 13.9m19.8-35.1c1.8-.2 7.7-2.8 7.7-2.8m-33.4-22c-.1 0-2.2 7.7 1.6 10.5m-11.1 25c0 8.4 6.6 6.3 2 14.3M382.2 97a57 57 0 0 0-10.4 9.4m-16.4-13.7s4.4 4.3 3.3 10.2m-16-13.7s-2.2 6.6-5.1 8.3m-18-10c-.1.3-3.6 7.8-6 9.1m-25.6-9c.2 0 3.5 7-.8 12m-6.5-48c.2.2.7 5.4-2.6 10m-28.7 1.9c0 .1 1.4 5.9-7.8 7.8m-9.9 45.2c.2.3 8.9 1.7 8.9 1.7M210 136.6c.2-.2 10.6-3.3 10.6-3.3m-27.4 16.3c.3 0 7.3 1.3 9 .4m-14 6s2.3 1.3.4 13m-34.2-43.5 4.2 6.2m-18.5 26c0-.2 4.2 6.2 9.8 7.4m23 25.2a49 49 0 0 0 8-2M170 213.8c.2 0-.1-4.3 5.2-7.3M163 224.7c0 .2 5 6.4 8.5 7.3m-11.5 4.7c.6-.2 6-4.9 12.2-4.5m-13.9 20.6s.2 5.4 16.2 4m-14.6 15c0-.2 4.7-10.8 14.2-14.8m-1.4 28.4s1.4-4.6 9.4-7.7m-.5 25.5s5.7-4.7 7.8-5.3m-.7 19.3s3.5 3.6 12.2-2.7m-54 5.6c1-.2 13.7-3.1 18 3.5m-13 7s13.4-1.8 15.1-.4m32.7 3.1s-1.8 3.7 14.7-2.4m5.8 9c-3 5 .7 9-3.2 11.3m-47-4.3c.5-.4 6-2.3 5.2-10.3m-.2 22.3c.7-.2 9.9-4.2 11.8-2.1m6.3 13.7s1.2-8.2 3.8-9m10 21.3s7.7-.1 11-2.6m3.8-25c.2.2 7.1 3.8 22 .2m-16.4 33s2 10.6 2 13"
      />
      <g fill="#de2010" fillRule="evenodd" stroke="#000" strokeWidth={1.5}>
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(1.60885 -.2011 .2072 1.65762 94.8 75)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(1.60885 -.2011 .2072 1.65762 93.4 57.3)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(1.58497 -.3417 .35206 1.633 78 74)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(1.4455 -.73446 .7567 1.4893 55.9 163)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(1.4455 -.73446 .7567 1.4893 48.9 147.1)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(1.3781 -.85423 .88011 1.41987 40 167.4)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(1.28907 -.98346 1.01327 1.32812 33.8 193)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(1.1329 -1.15994 1.19508 1.16722 35.3 239)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(1.02138 -1.25922 1.29739 1.05234 34.3 262.7)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(.79817 -1.41132 1.45408 .82236 51.9 315)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(.66642 -1.4781 1.52289 .6866 56.8 337.4)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(.56582 -1.51945 1.5655 .58296 57.9 352.4)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(.4482 -1.5582 1.60543 .46178 63 370.4)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(.20288 -1.60864 1.65738 .20903 94.7 408.9)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(.06506 -1.62008 1.66918 .06703 106.3 427.4)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(.06506 -1.62008 1.66918 .06703 88.8 428)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(-.36132 -1.5806 1.62852 -.37226 172.5 473.5)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(-.49045 -1.54542 1.59227 -.50531 188.3 485.8)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(-.67103 -1.476 1.52073 -.69138 221.9 499.1)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(-.7945 -1.41337 1.4562 -.81858 241.4 508.3)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(-.94339 -1.31867 1.35863 -.97197 271.6 515.4)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(-1.05159 -1.2341 1.27151 -1.08344 292.4 520.2)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(-1.13737 -1.15553 1.19056 -1.17183 308.9 526.1)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(-1.2301 -1.05628 1.08829 -1.26738 331.4 529.6)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(-1.33573 -.91908 .94693 -1.3762 362.5 526.1)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(-1.47374 -.67597 .69645 -1.51841 415.9 504)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(-1.52895 -.53958 .55593 -1.5753 438.7 497.5)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(-1.61445 -.12005 .15429 -1.33344 500.5 406)"
        />
        <path
          d="M232.8 119c0-2-.8-4-2-5-1.4-1.1-3-1.1-4.2 0s-2.1 3-2.1 5c0 2.1.8 4 2 5.1 1.4 1.1 3 1.1 4.2 0s2.2-3 2.1-5z"
          transform="matrix(-1.58082 -.36035 .37125 -1.62873 468.4 480.8)"
        />
      </g>
      <path
        fill="#ffe300"
        fillRule="evenodd"
        d="M480 194.7c2.2-2.3 4.2-3 6.7-2.1-1-6.1-2.8-8.2-5.2-7.4-2.3.7-3.4 3.8-1.5 9.5zm3.3 18.2c2.3-2.1 4.3-2.6 6.8-1.6-.4-6-2.2-8.3-4.6-7.7-2.4.5-3.6 3.6-2.2 9.3zm-7.8-35c1.5-2.7 3.3-3.8 6-3.7-2.5-5.6-4.8-7.1-7-5.8-2 1.3-2.2 4.6 1 9.6zm-8.1-16.6c1.5-2.8 3.3-3.9 6-3.7-2.5-5.7-4.9-7.2-7-5.9-2 1.3-2.2 4.6 1 9.6zm-19.5-30.5c1-3 2.6-4.4 5.2-4.6-3.3-5.2-5.9-6.3-7.7-4.7s-1.5 5 2.5 9.3zM435 117.5c1-3 2.4-4.4 5-4.8-3.4-5-6-6-7.8-4.4-1.8 1.7-1.4 5 2.8 9.2zM408.3 95c0-3.2 1-5 3.3-6.2-4.8-3.7-7.7-3.8-8.8-1.7s.2 5.1 5.5 7.9zm14 10.5c.4-3.1 1.7-4.8 4.3-5.5-4.2-4.5-6.9-5.2-8.4-3.3-1.5 2-.7 5.1 4 8.8zm-30-19.3c-.3-3.1.5-5 2.7-6.5-5.2-3.2-8-3-9-.8-.9 2.3.8 5.1 6.4 7.3zM376.2 79c-.8-3-.3-5 1.7-6.8-5.6-2.4-8.4-1.9-9 .5-.6 2.4 1.5 4.9 7.3 6.3zm-17.5-5.4c-1.1-3-.8-5 1.1-7-5.8-1.9-8.5-1.1-9 1.3-.3 2.4 2 4.8 7.9 5.7zm-17.3-3.4c-1.2-2.8-1-5 .7-7-6-1.5-8.6-.5-8.8 2-.3 2.4 2.2 4.6 8.1 5zm-18.2-1.4c-1.6-2.7-1.6-4.8 0-7-6.1-.9-8.7.4-8.6 2.8 0 2.5 2.7 4.4 8.6 4.2zm-35.7 2.7c-2.2-2.2-2.7-4.3-1.8-6.8-6 .6-8.2 2.4-7.6 4.8.6 2.4 3.7 3.6 9.4 2zm17.6-2.3c-1.9-2.5-2.2-4.6-.9-7-6.1-.2-8.5 1.3-8.2 3.8.3 2.4 3.2 4 9 3.2zm-34.9 6c-2.4-1.9-3.3-3.8-2.7-6.4-6 1.5-7.8 3.6-6.9 5.8 1 2.3 4.2 3 9.6.6zm-33 15.2c-2.8-1.4-4-3.1-3.9-5.8-5.6 2.6-7 5-5.6 7 1.3 2 4.6 2.2 9.5-1.2zm16-8.1c-2.7-1.7-3.6-3.6-3.2-6.2-5.9 1.8-7.6 4-6.5 6.2 1.1 2.2 4.4 2.8 9.6 0zm-45.6 28.8c-3-.8-4.6-2.3-5-5-5 3.8-5.8 6.4-4.1 8.1 1.8 1.7 5 1.2 9-3.1zm14.1-11.6c-3-1-4.4-2.6-4.6-5.2-5.2 3.2-6.3 5.8-4.7 7.7 1.6 1.8 5 1.5 9.3-2.5zm-26.7 24c-3-.6-4.7-1.9-5.4-4.5-4.6 4.1-5.2 6.9-3.3 8.4 1.9 1.6 5 .7 8.7-4zM183.7 138c-3.2-.2-5-1.3-5.8-3.8-4.2 4.5-4.6 7.2-2.6 8.6 2 1.4 5.1.2 8.4-4.8zm-9.4 15c-3.2.2-5-.7-6.4-3-3.4 5.1-3.4 8-1.2 9s5.1-.6 7.6-6zm-8.3 16c-3 .6-5 0-6.7-2.2-2.7 5.5-2.3 8.3 0 9 2.3.8 5-1.2 6.7-6.9zm-6.6 16.3c-3 1.1-5 .8-7-1-1.8 5.8-1 8.5 1.5 8.9 2.4.3 4.7-2 5.5-8zm-4.5 18.2c-2.8 1.3-4.9 1.2-7-.5-1.4 6-.4 8.5 2 8.7 2.5.3 4.7-2.2 5-8.2zm-1.8 15.2c-2.6 1.4-4.7 1.6-7 .5-.7 4.9.6 6.8 3 6.6 2.4-.2 4.3-2.4 4-7.1zm307-72.2c1.1-3 2.7-4.4 5.3-4.6-3.2-5.2-5.7-6.3-7.6-4.8-1.9 1.6-1.6 5 2.3 9.4zm25.2 85c2.3-2.2 4.4-2.7 6.8-1.6-.4-6.1-2.2-8.3-4.6-7.8-2.3.6-3.6 3.6-2.2 9.4z"
      />
      <path
        fill="#217900"
        fillRule="evenodd"
        stroke="#000"
        strokeLinejoin="round"
        strokeWidth={1.9}
        d="M461.3 132s-7 6.9-5.7 15.2c1.2 8.3 6.5 18.6 5.5 27.3-1 8.6-2.5 14.3-2.5 14.3s8-9.1 8-18c.2-8.7-5.4-20.3-5.4-26.7s.3-12.2.1-12zm12.7 28s-5.3 4-4.8 13c.5 9.1 10 25.8 10 25.8s6.8 14 6.5 17.7c-.2 3.7 1.3-3.5.6-11.5s-11-25.8-11-25.8-2.2-3.6-2-9.7c.2-6 .8-9.4.8-9.5z"
      />
      <path
        fill="#6b18b5"
        fillRule="evenodd"
        d="M313 47.4c0-1.8-2.2-3.4-4.8-3.4s-4.7 1.6-4.7 3.4 2 3.4 4.7 3.4 4.7-1.5 4.7-3.4zm2 8c0-1.8-2.2-3.3-5-3.3-2.6 0-4.8 1.4-4.8 3.2s2.2 3.3 4.9 3.3 4.8-1.5 4.8-3.3zm6-9.4s-5.6 4.1-3.3 5.8c2.3 1.7 8.6-3.6 8.6-3.6L321 46zm163.3 95.4c0-1.2-.5-2.3-1.4-2.9a2.6 2.6 0 0 0-3 0c-.9.6-1.4 1.7-1.4 2.9s.5 2.3 1.4 2.9a2.6 2.6 0 0 0 3 0c.9-.6 1.4-1.7 1.4-2.9zm-2.1-8c0-2-1.4-3.5-3-3.5s-3.1 1.6-3.1 3.6 1.4 3.5 3 3.5 3.1-1.6 3.1-3.5zm1.5 16.2c0-1-.6-1.8-1.2-1.8s-1.2.8-1.2 1.8.5 1.9 1.2 1.9 1.2-.9 1.2-1.9zm4.9-14.4c0-1.2-.6-2.1-1.2-2.1-.7 0-1.2.9-1.2 2s.5 2.2 1.2 2.2c.6 0 1.2-1 1.2-2.1zm-13.4 1.4c0-1-.6-1.7-1.2-1.7s-1.2.8-1.2 1.7.5 1.8 1.2 1.8 1.2-.8 1.2-1.8zm2.1 11.4c0-1.5-1.1-2.7-2.5-2.7s-2.5 1.2-2.5 2.7c0 1.6 1 2.8 2.5 2.8s2.5-1.2 2.5-2.8zm-6.6-5c0-1.3-1-2.4-2.1-2.4-1.2 0-2.2 1-2.2 2.4s1 2.4 2.2 2.4c1.1 0 2-1 2-2.4zm-1-6.8a2 2 0 0 0-1-1.7 1.8 1.8 0 0 0-1.9 0 2 2 0 0 0-.9 1.7 2 2 0 0 0 1 1.8 1.8 1.8 0 0 0 1.8 0c.6-.4 1-1 1-1.8zm30.1 34.4c-2.7-3.6-7.1-5.1-9.8-3.4-2.6 1.7-2.6 6 .2 9.7 2.7 3.6 7 5.1 9.7 3.4 2.7-1.8 2.7-6 0-9.7zm7.8 66.7c.5-4.5-1.6-8.4-4.8-8.8-3.2-.3-6.2 3-6.8 7.4-.5 4.4 1.7 8.3 4.9 8.7 3.2.4 6.2-3 6.7-7.3zm1.6 38.8c1-4.4-.9-8.5-4-9.2-3.2-.6-6.5 2.4-7.4 6.8-.9 4.3 1 8.4 4 9 3.2.7 6.5-2.3 7.4-6.7zm7.5-36.4c0-1.7-1.2-3.1-2.6-3.1s-2.7 1.4-2.7 3.1c0 1.8 1.2 3.2 2.7 3.2s2.6-1.4 2.6-3.2zm-6.5 7.3-5.4 6.2s-5.1.1-4.8 1.8c.2 1.6 7 6.6 7 8.6-.1 2 4.4-.5 4.4-.5l3.7-11.1s-.2-7.7-2.2-7.6c-2 .2-2.5 2.5-2.7 2.6zm-357.4-2.4a2.6 2.6 0 1 0-5.1 0 2.6 2.6 0 0 0 5.1 0zm2.5-8c0-1.4-1.2-2.6-2.6-2.6s-2.6 1.2-2.6 2.7 1.2 2.7 2.6 2.7a2.7 2.7 0 0 0 2.6-2.7zM134 199.2c-1-2.2-3-3.4-4.5-2.7-1.5.7-2 3-1 5.2s3 3.4 4.5 2.7c1.6-.7 2-3 1-5.2zm6.5 23.4c-1.4-2.8-4.1-4.4-6.2-3.5s-2.7 3.9-1.4 6.7 4 4.4 6.2 3.5 2.7-3.9 1.4-6.7zm6.8 17.2c.5-3.5-1-6.8-3.2-7.2-2.3-.5-4.4 2-4.9 5.5-.4 3.5 1 6.7 3.3 7.2 2.2.5 4.4-2 4.8-5.5zm-11 2.5c1.4-3.3.9-6.8-1.1-7.8s-4.8.7-6.2 4-.9 6.7 1.2 7.8 4.7-.7 6.1-4z"
      />
      <path
        fill="#6b18b5"
        fillRule="evenodd"
        d="M131.3 234.8c0-1.7-1.3-3-2.9-3s-2.9 1.4-2.9 3 1.3 3 3 3 2.8-1.3 2.8-3zm-2.3-7.5c0-1.5-1.2-2.7-2.6-2.7a2.7 2.7 0 0 0-2.6 2.8c0 1.4 1.2 2.7 2.6 2.7s2.6-1.3 2.6-2.8zm2.4-14.3c0-2.6-1.1-4.6-2.5-4.6s-2.5 2-2.5 4.6c0 2.5 1.1 4.6 2.5 4.6s2.5-2 2.5-4.6zm7.8-1.1c.3-2.5-.5-4.7-2-5-1.3-.1-2.7 1.8-3 4.3-.4 2.5.5 4.7 1.9 4.9 1.3.2 2.7-1.7 3-4.2zm55-110c1.1-3.6 0-7.2-2.3-8-2.3-.9-5 1.3-6 4.9-1 3.6 0 7.2 2.3 8 2.3.9 5-1.3 6-4.9zm-10.4 15.9c3-2.7 4.4-6.3 3-8.1-1.5-1.9-5.2-1.2-8.3 1.4s-4.3 6.2-2.9 8c1.5 1.9 5.2 1.3 8.2-1.3zm-6-8.8c3-2.3 4.2-5.4 2.8-7s-5-1-8 1.2c-3.1 2.3-4.4 5.4-3 7s5 1 8.1-1.2zm23.5-15.5c2-1.6 2.9-3.8 2-4.9-1-1-3.5-.7-5.6.9s-2.9 3.7-1.9 4.8c1 1.1 3.4.7 5.5-.8z"
      />
      <path
        fill="#6b18b5"
        fillRule="evenodd"
        d="M189 108.5c1.4-2.2 1.5-4.5.2-5.2-1.3-.7-3.5.4-4.9 2.6s-1.5 4.5-.2 5.2c1.3.7 3.5-.5 4.9-2.6zm17.7-9.3c2.2-1.9 3-4.3 2-5.5-1.2-1.2-4-.6-6.2 1.2s-3 4.3-1.9 5.5c1.2 1.2 3.9.6 6.1-1.2zm-32 21.6c2 0 3.6-1.1 3.4-2.3 0-1.1-1.9-2-4-1.9-2 .1-3.6 1.2-3.4 2.3.1 1.2 2 2 4 2zm38.7-33.1c1.4-2.2 1.5-4.5.2-5.2-1.2-.7-3.4.4-4.8 2.6s-1.5 4.5-.2 5.2c1.3.7 3.4-.4 4.8-2.6z"
      />
      <path
        fill="#ffd200"
        fillRule="evenodd"
        stroke="#ef8a10"
        d="M446.8 153.4s6.4-10.1 4-19.7c-2.5-9.5-13-2.7-12.8.7.2 3.3 6.8 7.9 7.2 10 .4 2-.8 8.3 1.6 9z"
      />
      <path
        fill="#217900"
        fillRule="evenodd"
        stroke="#000"
        strokeLinejoin="round"
        strokeWidth={2.3}
        d="M324.9 69.3s23 .9 23.1 15.8c0 2.3 0 5-.8 11.7 4.6-2.5 7.6-9.3 7-13.7.1-15.1-20.5-25.5-29.3-13.8z"
      />
      <path
        fill="#217900"
        fillRule="evenodd"
        stroke="#000"
        strokeLinejoin="round"
        strokeWidth={2.3}
        d="M310.3 68.6s18.5-3.8 18.7 11c.1 15-6 17.3-6 17.3s14.3-3 14.4-18.1c0-15.2-18.3-21.9-27.1-10.2z"
      />
      <path
        fill="#f7df73"
        fillRule="evenodd"
        stroke="#000"
        strokeLinejoin="round"
        strokeWidth={2.5}
        d="M373.3 390s86.8-24.6 113-131C471 368.1 376 403 376 403l-2.8-13z"
      />
      <path
        fill="#8c1800"
        fillRule="evenodd"
        d="M382.2 396.6c2.7 0 9.3-7.4 13.1-8.2 3.8-.8 4.2-4.7-.1-4.8-4.4-.2-8.2 5-8.2 5s-3.8 3.2-7.8 3.6c-4 .4-1.4 5.4 3 4.4z"
      />
      <path
        fill="#8c1800"
        fillRule="evenodd"
        stroke="#8c1800"
        strokeWidth={2.5}
        d="M432.2 359.3s-9 5.2-7.8 6.5c1.3 1.3 9.3-5 9.5-5 .1-.2 3.4-4.2-1.7-1.5z"
      />
      <path
        fill="#8c1800"
        fillRule="evenodd"
        d="M400.7 383s-2.7-1 4.2-3.6c7-2.7 6.5-5.8 8.8-7.1 2.2-1.3 7-4.7 8-2.7s-5 6-6.5 6.4c-1.4.4-8.3 6.8-10.3 7.3-2 .6-3.4.3-4.2-.3z"
      />
      <path
        fill="none"
        stroke="#8c1800"
        strokeLinecap="round"
        strokeWidth={3}
        d="M445.6 346c-6 6.7-6 6.5-6 6.5"
      />
      <path
        fill="none"
        stroke="#8c1800"
        strokeLinecap="round"
        strokeWidth={2.8}
        d="m454.5 335.2-5.7 6.9"
      />
      <path
        fill="none"
        stroke="#8c1800"
        strokeLinecap="round"
        strokeWidth={2.5}
        d="m463.4 321-6.4 10.2"
      />
      <path
        fill="none"
        stroke="#8c1800"
        strokeLinecap="round"
        strokeWidth={2.3}
        d="m470.9 306.6-5.3 10.5m8.6-18-1.6 3.6"
      />
      <path
        fill="none"
        stroke="#8c1800"
        strokeLinecap="round"
        strokeWidth={1.4}
        d="m478 289-1.4 4.4"
      />
      <path
        fill="#f7df73"
        fillRule="evenodd"
        stroke="#000"
        strokeLinejoin="round"
        strokeWidth={1.5}
        d="M160.3 216s52-14.7 67.6-78.5c-9.1 65.5-66 86.2-66 86.2l-1.6-7.7z"
        transform="matrix(-1.65528 0 0 1.70062 524.8 20.4)"
      />
      <path
        fill="#8c1800"
        fillRule="evenodd"
        d="M250.7 394.4c-2.7 0-9.2-7.5-13-8.3-3.8-.9-4.2-4.8.1-5 4.4 0 8.1 5.1 8.1 5.1s3.8 3.3 7.7 3.8c4 .4 1.4 5.4-2.9 4.4z"
      />
      <path
        fill="#8c1800"
        fillRule="evenodd"
        stroke="#8c1800"
        strokeWidth={1.5}
        d="M195.5 197.6s-5.4 3.2-4.6 4c.7.7 5.5-3 5.6-3.1.1-.1 2-2.5-1-.9z"
        transform="matrix(-1.65528 0 0 1.70062 524.8 20.4)"
      />
      <path
        fill="#8c1800"
        fillRule="evenodd"
        d="M232.4 380.6s2.6-1-4.2-3.7-6.5-6-8.7-7.2c-2.2-1.3-7-4.7-8-2.7s5 6 6.5 6.4c1.4.5 8.2 7 10.2 7.5 2 .6 3.3.3 4.2-.3z"
      />
      <path
        fill="none"
        stroke="#8c1800"
        strokeLinecap="round"
        strokeWidth={1.8}
        d="m203.5 189.7-3.5 3.9"
        transform="matrix(-1.65528 0 0 1.70062 524.8 20.4)"
      />
      <path
        fill="none"
        stroke="#8c1800"
        strokeLinecap="round"
        strokeWidth={1.7}
        d="m208.9 183.2-3.4 4.1"
        transform="matrix(-1.65528 0 0 1.70062 524.8 20.4)"
      />
      <path
        fill="none"
        stroke="#8c1800"
        strokeLinecap="round"
        strokeWidth={1.5}
        d="m214.2 174.7-3.8 6.1"
        transform="matrix(-1.65528 0 0 1.70062 524.8 20.4)"
      />
      <path
        fill="none"
        stroke="#8c1800"
        strokeLinecap="round"
        strokeWidth={1.4}
        d="m218.7 166.1-3.2 6.3m5.2-10.9-1 2.2"
        transform="matrix(-1.65528 0 0 1.70062 524.8 20.4)"
      />
      <path
        fill="none"
        stroke="#8c1800"
        strokeLinecap="round"
        strokeWidth={0.8}
        d="m223 155.5-.9 2.7"
        transform="matrix(-1.65528 0 0 1.70062 524.8 20.4)"
      />
      <path
        fill="#217900"
        fillRule="evenodd"
        stroke="#000"
        strokeLinejoin="round"
        strokeWidth={2.3}
        d="M490.4 239.3c.5 6.7 7 13 4.4 24.7-3.2 13.3-14.8 44.7-12.8 50.2-3.4-4.7-2.8-9-3-15.6-.4-6.5 9.4-30.9 10.3-39.1 0-7.4.7-17.5 1.1-20.2z"
      />
      <path
        fill="#217900"
        fillRule="evenodd"
        stroke="#000"
        strokeLinejoin="round"
        strokeWidth={2.3}
        d="M490.4 239.4s10.7 13.5 10.1 24.2c-.5 10.7-6.5 23.2-4.5 28.7a21.7 21.7 0 0 1-4.6-14.2c-.3-6.5 5.3-13.8 4.1-20.9-1.1-7-5.2-17.8-5-17.8zm-349.3 3c-.4 6.7-5.4 12.7-2.8 24.3 3.2 13.3 15 30 13 49.2 3.5-4.7 4.5-10 4.8-16.5.2-6.5-13-28.5-13.8-36.8 0-7.4-.8-17.5-1.2-20.2z"
      />
      <path
        fill="#217900"
        fillRule="evenodd"
        stroke="#000"
        strokeLinejoin="round"
        strokeWidth={2.3}
        d="M141.1 242.6s-10.4 13-9.8 23.7c.1 7.1 13.2 36.8 11.2 42.4 3.5-4.7 4.4-4.1 4.3-11.2-3.8-18.3-10.7-29.9-9.5-37 1.1-7.1 4-18 3.8-18z"
      />
      <path
        fill="#fff"
        stroke="#000"
        strokeDashoffset={1}
        strokeLinecap="square"
        strokeLinejoin="round"
        strokeWidth={1.7}
        d="m100 125.8 22 68.2h72l-58 42.2 22.1 68.2-58-42.1-58 42.1 22-68.2L6 194h71.8z"
        transform="matrix(1.16516 0 0 1.16534 202 -23.6)"
      />
    </g>
  </svg>
)

export default MpFlag
