// This file is generated by @lib/ui/country/codegen/generateFlags.ts
import { SvgIconProps } from '@lib/ui/icons/SvgIconProps'

const MeFlag = (props: SvgIconProps) => (
  <svg
    width="1em"
    height="0.75em"
    xmlns="http://www.w3.org/2000/svg"
    id="flag-icons-me"
    viewBox="0 0 640 480"
    {...props}
  >
    <path fill="#d3ae3b" d="M0 0h640v480H0z" />
    <path fill="#c40308" d="M24 24h592v432H24z" />
    <path
      fill="#b96b29"
      d="M424.5 236.1a58 58 0 0 0 19.4-9.2c7-5.6 8.3-10.1 8.8-12.5.6-2.4.8-4.3-1-3-1.8 1.4-7.1 5.6-10.7 7.6-3.7 2-7 3-9 3.6-2 .5-3.6.9-1.7.1 2-.7 8.1-2.9 13-7.7 4.7-4.8 8.5-12 8.6-16.4 0-4.4-.3-4-1.7-3-1.4 1.1-6.4 7.3-9.3 9.7a90 90 0 0 1-9.7 6.9c-2.3 1.3-5.5 2.8-1-.3 4.5-3 13-10.3 16.5-19.7a35.4 35.4 0 0 0 2.7-15.8c0-1-.8-2.8-1.6-1.1-.8 1.7-6.5 13-11 18-4.6 4.8-3.5 3.9-4.6 4.7-1 .8-2.7 2.2-.5-.6a51.2 51.2 0 0 0 12.2-31.7c0-3.6-1.5-8.6-2.2-10.1-.7-1.5-1.4-2.6-1.7-.9a191 191 0 0 1-5.8 18.4 75 75 0 0 1-6.7 12.8c-.8 1.1-2.8 3.6-.6-.5a77.4 77.4 0 0 0 7-27.6 44 44 0 0 0-2.6-20.9c-1.6-3.1-3-4.2-3-4.2s.3 7.8-2 19-5.7 17-5.7 17-1.5 1.7-.5-1a62.4 62.4 0 0 0 1.4-34.5c-2.3-7.5-6.2-11.3-6.2-11.3-1 10.7-.9 24.5-4.8 35.7-.7-.7-1.7-1.9-2.1.6a63.1 63.1 0 0 1-7 19.4c-4.8 8.8-6.8 10-6.8 10l-1.5-3.4c-.6-1.2-1-1.8-1.8-.2s-3.5 7.8-9.4 14.6-9.2 10.2-9 15.3c.1 5 2.8 7.7 6.4 10 3.6 2.3 4.2 3.6 3.7 6.4-.6 2.8-3.8 3.7-6.6 3.8-2.7.1-6.2-.1-7.5.6-1.2.7-1.3 2.5-2.6 3.7-1.2 1.3-1.8 2-3 2.2l-1 .1c-.2-13.5 5-19.5 5-19.5l-14.6-17.1a50.8 50.8 0 0 1-2.2 1 4 4 0 0 0-.4-.6 11 11 0 0 1-2.6-7.8c.7 0 2.2.6 3.5.3 1.3-.2.3-1.6 0-2.8-.5-1.3-.9-5.7-.6-7.3l.4-2.3s2.1 2.3 3.4 2.3c1.3 0 1.2-1.3 1.4-2.8.3-2.2 1.3-5 3-6.5 0 0 2.4 1.6 5 1.6s6.2-.7 9-3.5c3-2.7 2.9-3.3 2.9-3.3s5.3 1.8 9.3 2c4 .2 8.3-.4 10.4-4.7 2-4.2-.6-8.2-1-8.8-.6-.7-1.9-1.2-1.9 0s.1 4.4-2.4 6c-2.4 1.6-4.3 1.5-6.6.8a20.5 20.5 0 0 0-13.1-.4 17 17 0 0 1 6.1-4.2c3-.9 4.8.4 5.8 1.6 1 1.2 1.9 3 2.7.3.8-2.8.3-6-1-8a7.6 7.6 0 0 0-7.2-3c-3 .2-4 .7-4 .7s-1.5-4.3-5.3-5a21 21 0 0 0-14 3s-3.1.7-6.4-.2a21 21 0 0 1-5.4-2.8l1.1-3.5 1.9-.6c1-.4.7-.7.9-1.5.1-.8-1.8-2.2-1.8-2.2s-.3-2.5 2.9-4.1l2.8-1.4s1.9.3 2.6-.2c.8-.6.8-1 .8-1s1.4-.4 2-1.2c.4-.9.5-2.1.2-3.1-.4-1-.9-1.2-.4-1.7s1-1.6 1-2.4l.1-1s1.1-.4 1-2c0-1.7-.9-2.3-1.4-2.5l-.9-.1s0-1-.9-2.3c-.8-1.4-1.4-2-1.4-2s.6-.4.3-1.5-1.1-1.7-1.9-2c-.7-.2-1.5 0-1.5 0l-3.7-2.1-1.5-.8s0-1-.4-1.6c-.5-.5-1.5-.8-2-.8s-1 .3-1 .3l-6-1.4c-1.8-.2-1.9-.4-1.9-.4s-3.8-1.8-5.2-2l-2-.5s1.6-1.8 1.7-4a6 6 0 0 0-2.8-5l-1.6-.8V93l2.8.3.2-4.6-2.7.3.4-2.7h-5.8l.4 2.7-2.8-.2.3 4.5 3-.4-.4 1.7s-1 .2-2 .9a5.4 5.4 0 0 0-2.6 4.7c0 2.2 1.3 4 1.3 4l-1.8.4c-1.5.3-5.3 2.1-5.3 2.1s0 .2-1.8.4l-6 1.4s-.6-.3-1-.3-1.6.3-2 .8c-.4.6-.5 1.6-.5 1.6l-1.4.8-3.7 2.1s-.8-.2-1.6 0c-.7.3-1.5 1-1.8 2-.3 1.1.3 1.6.3 1.6s-.6.5-1.5 1.9a6 6 0 0 0-.9 2.3l-.8.1c-.6.2-1.5.8-1.5 2.5 0 1.6 1 2 1 2v1c.1.8.6 2 1.1 2.4.5.5 0 .7-.3 1.7-.4 1-.3 2.2.2 3 .5 1 2 1.4 2 1.4s0 .3.7.9 2.6.2 2.6.2l2.9 1.4c3.2 1.6 2.9 4 2.9 4s-2 1.5-1.8 2.3c.1.8 0 1.1.9 1.5l1.9.6 1 3.5a21 21 0 0 1-5.4 2.8c-3.2.9-6.4.2-6.4.2a21 21 0 0 0-13.9-3c-3.8.7-5.4 5-5.4 5s-1-.4-4-.8c-3-.3-5.8 1-7.1 3-1.4 2.1-1.8 5.3-1 8.1s1.6.9 2.6-.3 2.8-2.5 5.8-1.6c3 1 6 4 6.2 4.2 0 0-.5-.3-3.9-.8-3.7-.5-6.9.4-9.2 1.2-2.3.7-4.2.8-6.7-.8-2.4-1.6-2.4-4.8-2.4-6 0-1.2-1.3-.7-1.8 0-.4.6-3 4.6-1 8.8 2 4.3 6.3 5 10.4 4.7 4-.2 9.3-2 9.3-2s0 .6 2.8 3.3a13 13 0 0 0 9 3.5c2.7 0 5-1.6 5-1.6 1.7 1.5 2.7 4.3 3 6.5.2 1.5.1 2.8 1.4 2.8 1.4 0 3.5-2.3 3.5-2.3l.4 2.3a26 26 0 0 1-.6 7.3c-.4 1.2-1.4 2.6 0 2.8 1.3.3 2.7-.2 3.5-.3 0 3.2-.7 5.3-2.6 7.8a4.4 4.4 0 0 0-.4.6 53.9 53.9 0 0 1-2.2-1l-14.6 17.1s5.3 6 5 19.6a20.6 20.6 0 0 1-1-.2c-1.2-.2-1.8-1-3-2.2-1.3-1.2-1.4-3-2.6-3.7-1.3-.8-4.8-.5-7.5-.6-2.8 0-6-1-6.6-3.8-.5-2.8.1-4 3.7-6.4 3.6-2.3 6.3-5 6.4-10 .2-5.1-3-8.5-9-15.3-5.9-6.8-8.6-13-9.4-14.6-.8-1.6-1.2-1-1.8.2l-1.5 3.3s-2-1.2-6.8-10a63 63 0 0 1-7-19.3c-.4-2.5-1.4-1.3-2-.6-4-11.2-3.8-25-4.9-35.7 0 0-3.9 3.8-6.2 11.3-2 6.8-2 14.9-1.3 22 .6 6.7 2 10.7 2.7 12.5 1 2.7-.5 1-.5 1s-3.4-5.8-5.7-17c-2.3-11.2-2-19-2-19s-1.4 1-3 4.2a44 44 0 0 0-2.6 21 77.4 77.4 0 0 0 7 27.5c2.2 4 .2 1.6-.6.5a71 71 0 0 1-6.7-12.8c-2-5.5-5.6-16.6-5.8-18.4-.3-1.7-1-.6-1.7.9s-2.3 6.5-2.2 10.2a51.2 51.2 0 0 0 12.2 31.6c2.2 2.8.5 1.4-.5.6-1-.8 0 .1-4.5-4.7a91.7 91.7 0 0 1-11-18c-.9-1.7-1.6.1-1.7 1.1-.1 1-.7 6.5 2.7 15.8 3.5 9.4 12 16.7 16.5 19.7 4.5 3.1 1.3 1.6-1 .3a90 90 0 0 1-9.7-6.9c-2.9-2.4-7.9-8.6-9.3-9.7-1.4-1-1.7-1.4-1.7 3 .1 4.4 3.9 11.6 8.7 16.4 4.8 4.8 11 7 12.9 7.7 1.9.8.3.4-1.7-.1a40.2 40.2 0 0 1-9-3.6 93 93 0 0 1-10.7-7.6c-1.8-1.4-1.6.6-1 3 .5 2.4 1.9 6.9 8.8 12.5a57.7 57.7 0 0 0 19.4 9.2c2.9.8.9.8.9.8l-6.8-1.4a71.3 71.3 0 0 1-16.7-7.3c-2.3-1.5-2.7-2-2.4 1a20 20 0 0 0 8.9 12.9 49.6 49.6 0 0 0 17.2 4.8c2.5.1 1.8.4.7.5a50.5 50.5 0 0 1-19.2-3.2l-.5-2c-.2-1.2-.9-1-1.2-.8-.4.3-.7.5-2 1.1-1.3.7-1.3-.1-1.4-.5l-.3-3c0-.8-.5-.9-1.1-.6l-4.7 2c-1 .4 0 1.3.5 2.3a147.3 147.3 0 0 0 1.5 2.6l-3.7 1c-.8.2-.6.8-.3 1.4l1.9 4.6c.3.8 1.1.3 1.1.3l2.7-1.6 1 3.7s-1.3.3-2.7 1.2c-1.3 1-1 2.3.7 2.7 1.6.5 3.6 1.4 5.7 5.3 2.2 3.9 2.7 10.9 4 22 1.4 11 8.4 16.6 9.4 17.3 1 .7.4 1.3.4 1.3s-1 1.4-.5 3.5a5.3 5.3 0 0 0 3.2 3.8c1 .3.7 1.3.7 1.3s-.5 2.3 0 6.7c.5 4.3 4 9.1 5 10 1 .8 1 1.2 1 1.6-.2.3-.9 0-2 1a12.2 12.2 0 0 0-3.4 3.6c-.8 1.6-.5 2.5-.2 4.5.2 2.1 3.3 4 3.3 4s-.6.1-.7 1.7c-.1 1.5 1 3.2 2.4 4.4 1.3 1 4 1.6 4 1.6l.3 2.2c.2 1 1.9 1.9 3 2.5 1.1.6 3.3.3 4.2-.2.9-.4 1.5.1 2 1 .6 1 .4 4.4.4 5.8 0 1.4-.8 2.8-.4 3.5.5.7 1.8.2 3.2-.5 1.3-.8 1.6-.2 2.8.5a9 9 0 0 0 3.5 1.4c.5 0 .3-1.3.3-2.3s.2-3.4.7-3.8c.2-.2 2.3-.3 3.8-1 .7-.3 1.7-.6 1.7-1.3.1-.7-1-.7-3.2-1.9-2.3-1.1-2.7-1.8-4.2-2.8-1.4-1-.7-1.3-.7-1.8 0-.4.7-.9 1-1.4.2-.6 0-1.8 0-1.8l1.8-1.8 2-2.3c.8-.6 2-3.6 2.7-4.5.8-1 2.5-2 3.6-3.4a29.7 29.7 0 0 1 11.3-7.6s-.1 2.6 1 3.9 2.6-1 7.5-4.5c5-3.5 8.6-4.7 8.6-4.7l2.4 3.3c1.3 1.6 2.5-.1 8.5-8.5 4.8-6.5 11-12.6 13.5-14.8l1.3.6-.4 1c-.5 1.8-1.4 3-2.6 5.3-1.1 2.4-3 3-5 6.2s-2.4 5.5-2.6 8.8c-.2 3.3 1.7 4 1.7 4s-3 3-4 5.2c-.9 2.2-1.3 6.7-1.3 6.7s-.5.2-1.6 2.5-3.1 2.6-6 5.5c-3 3-6.2 4.2-7.7 5-1.5 1-1 1.9-.7 3 .4 1.2 2.5 2.4 5 3.3 2.3.9 3.2.5 4.8.5 1.7-.1.4 1.2-.3 1.9s-1.6 3.1-1.5 5.8c.2 2.7 2.2 2 4.7 1.6a28 28 0 0 0 5.3-1.6l-.2.8c-.3.7-.4 1.3-.4 3.4 0 2.1.3 3.2 1 3.7.5.6 1.8-.6 2.7-.9.9-.2 2.4-1.1 4.6-1.6 2.2-.5 3-1.5 3-1.5s-.5.7-.6 2.2c-.2 1.6-.1 3.8.2 5.2a9.4 9.4 0 0 0 2.9 4.2c1.5 1.4 1.8.8 3-1 1-1.7 3.3-3.9 3.3-3.9l1.7 5.5c1.5 4.9 6.5 9 6.5 9s5-4.1 6.5-9l1.6-5.5s2.3 2.2 3.4 4c1.1 1.7 1.5 2.3 3 1a9.4 9.4 0 0 0 2.8-4.3c.3-1.4.4-3.6.3-5.2-.2-1.5-.7-2.2-.7-2.2s.8 1 3 1.5 3.8 1.4 4.7 1.6c.9.3 2.1 1.5 2.7 1 .6-.6 1-1.7 1-3.8 0-2.1-.1-2.7-.4-3.4l-.3-.8s2.9 1.2 5.4 1.6c2.5.5 4.5 1 4.6-1.6a10 10 0 0 0-1.4-5.8c-.7-.7-2-2-.4-2 1.7.1 2.5.5 5-.4 2.3-1 4.4-2.1 4.8-3.3.4-1.1.9-2-.7-3-1.5-.8-4.7-2-7.6-5-3-2.9-5-3.2-6-5.5-1.1-2.3-1.6-2.5-1.6-2.5s-.5-4.5-1.4-6.7c-1-2.2-4-5.2-4-5.2s2-.7 1.7-4c-.2-3.3-.5-5.5-2.5-8.8-2.1-3.2-4-3.8-5-6.2-1.3-2.4-2.2-3.5-2.7-5.2l-.4-1a146 146 0 0 1 1.8-.8c2.4 2.2 8.7 8.2 13.5 14.8 6 8.4 7.2 10.1 8.5 8.4l2.4-3.2s3.7 1.2 8.6 4.7c5 3.5 6.4 5.7 7.5 4.4.6-.6.8-1.7.8-2.6a104 104 0 0 1 11.8 4.2c4.3 1.8 4.7 2.8 8.1 5.4 3.4 2.7 8.2 2.5 12.8 1a304 304 0 0 0 21.6-7.5c4.9-2 8.4-4 9-4.9.4-1 1-3.7 1-4.7s-1-2.4-1.4-2.7c-.4-.2-.2-1-.1-1.6 0-.6-.3-2.5-1-3.3-.8-.8-.7-1.1-.6-3.5.2-5-3.4-11.4-8.4-13.4 0 0-.2-.6-.6-1l-1-.6v-3.5c0-.6.2-.5.6-.4.3.2.9.9 1.7 1.1.8.2 1.3-.4 1.5-1.3.2-1 .8-2.8 1.2-3.7.3-1-.1-1-.5-1.2l-2.2-.4c-.6-.1-.6-.2-.4-.5l1-2c.8-1 .1-1.1-.6-1.4a58.4 58.4 0 0 0-4.9-1.3c-.9-.2-1 .6-1 1v2.6c0 .6-.5.4-.9.3a12.6 12.6 0 0 1-1.7-1.2c-.7-.4-1 0-1.3.7l-1.3 4.3c-.2.9-.1 1.5.2 1.6.3.2 2 0 3 0 .9 0 .3.6.3.6l-1.3 2.3c-.4.7-1 .8-1.8.8h-2s-5.3.2-9.2 3-5 5.3-5.6 6.7c-.6 1.4-1.3 1.1-1.9 1.6-.6.5-2.3 2.3-2.3 3.4s.4 1.7-1.3 2.8c-1.7 1.1-3 5.9-.8 8.3 2.3 2.5 3.2 5 4 6.2.6 1.2 0 1.7-.7 1.7s-1.8-1-2.9-1.8l-8.5-6.5c-2.3-1.7-.6-1.5-.6-1.5s.6 0 1.9-.5c1.3-.6 1.5-1.3.2-1.7a16.7 16.7 0 0 1-4.6-2.6c-.7-.7-1-1.4.3-2.1 1.3-.7 4.2-2.6 2-3.2-2.4-.7-5-1.1-7.3-1.8-2.2-.6-2.4-1.2-2.4-1.2l1.5-2.1s1.1-1.7-.2-1.9c-1.4-.2-4.8-.6-7.8-2a18.8 18.8 0 0 1-11.3-12.5v-.1c1.2 2.2 3.8 6.4 7.8 6.5 5.5.2 6.1-1.5 4.9-3.3-1.3-1.8-2.7-3.4-3-4-.4-.5-.5-1.2 1 .2 1.4 1.3 4 5.9 12.3 5.4 8.2-.6 8.2-2.2 8.2-2.6 0-1.6-1.7-1.9-2.7-2.9-.5-.5-.8-1.2.9-.6s5.7 1.4 11.3.2c2.1-.5 8-3 8.5-6 0 0-3.7-.2-6.3-1.3-2.5-1-4-2-1.3-1.4 2.7.5 8 1.6 12.7 0 2.7-.9 6.2-3 6.2-7.1 0 0-5-1-6.9-1.8-1.9-.6-2.5-1.2-2.5-1.2s7.3 2.3 13.8-1c6.6-3.3 6.9-7.9 6.9-9 0-1-.2-1.3-.2-1.3s-6 1.4-10.4 1.4c-4.5 0-5.9-.4-5.9-.4s12.5-.4 18.8-4.2c6.3-3.9 6.7-11.5 6.7-11.5s-7.1 2.6-11.6 3.1-7.2.5-8.3.4c-1.1 0-1.8-.4.7-.5a49 49 0 0 0 17.2-4.8c5.3-3.1 8.6-9.7 8.9-12.8.3-3.1 0-2.6-2.4-1-2.3 1.4-11 5.9-16.7 7.2l-6.8 1.4s-2.2-.1.7-.9zm-225.2 14.4-2.5 1.4-1.3-2.7c-.2-.6-.1-.8.2-.8l2.3-.4h.3c.3.7.6 1.6 1.1 2.4h-.1zm76.8 45a20.1 20.1 0 0 1-8.8 7c-3 1.4-6.3 1.8-7.7 2-1.4.2-.2 2-.2 2l1.4 2s-.2.6-2.4 1.3c-2.2.6-5 1-7.2 1.7-2.3.6.6 2.5 2 3.2 1.2.7 1 1.5.2 2.1-.7.7-3.2 2.2-4.6 2.6-1.3.4-1 1.1.2 1.7 1.4.5 5 1.2 5 1.2l-2.3 1.8a18.9 18.9 0 0 1-8.7 3c-2.5.1-6.6.3-11.7 0l-5.8-.3-.5-4.3a21.5 21.5 0 0 0-3-7.8l-3.7-5 .2-1.5c.2-.8 0-1.7-.5-3.3-.6-1.5-3.6-3.8-3.6-3.8l-.2-3.2c0-1.6-1-7.7-2-10.6-1-2.9-5.7-10.5-7.8-14a39.2 39.2 0 0 1-4.3-19.8l.5-1.3a12.9 12.9 0 0 0 3.5 3.2c6.3 3.8 18.8 4.2 18.8 4.2s-1.4.4-5.9.4-10.4-1.4-10.4-1.4-.2.3-.2 1.4c0 1 .3 5.6 6.9 9 6.5 3.2 13.8 1 13.8 1s-.6.5-2.5 1.1c-1.8.7-7 1.8-7 1.8 0 4 3.6 6.2 6.3 7.2 4.7 1.5 10 .4 12.7-.1 2.8-.6 1.2.3-1.3 1.4-2.6 1.1-6.3 1.3-6.3 1.3.6 3 6.4 5.5 8.6 6 5.5 1.2 9.6.4 11.2-.2 1.7-.6 1.4.1.9.6-1 1-2.7 1.3-2.7 2.9 0 .4 0 2 8.2 2.6 8.2.5 11-4 12.4-5.4 1.4-1.4 1.3-.7 1-.1-.4.5-1.8 2.1-3 4-1.3 1.7-.7 3.4 4.8 3.2 4 0 6.6-4.4 7.8-6.6v.1l.3.3a51.7 51.7 0 0 1-2.4 5.3zm66.4-178.2-1.1-2s3 1.4 5 3.5c1.8 2 1.7 3.2 2 4.2.3 1 0 2.9-.3 4.7-.3 1.7-.3 2.8.1 3.4.3.7.7 1 .7 1l-2.7.8c-1.3.6-3 1-4 .2-.9-.8-1.1-1.3-.5-1.8.6-.5 2.8-1.2 3-5 .3-3.7-1.5-7.6-2.2-9zm-17 10.3c.8-1.8 1-3.5.5-7.2-.4-3.1-1-5.7-1.2-9 0 0 2.3.4 5.6 3.4s4 6.1 4 7.6-.7 3.4-.9 4.8c0 1.5.4 2.8.4 2.8s-1.1.5-2.2 1.3c-1.1.7-1.9 1.2-3.5 1-1.7 0-2.7-.7-3.7-1.2l-1.5-.6s1.9-1.1 2.6-3zm-16-12.8a14 14 0 0 1 5.6-3.5c-.1 3.4-.7 6-1.2 9-.5 3.8-.3 5.5.5 7.3.7 1.8 2.6 2.9 2.6 2.9s-.6 0-1.6.6c-1 .5-2 1.2-3.6 1.3-1.7 0-2.4-.4-3.5-1.1a14 14 0 0 0-2.3-1.3s.5-1.3.4-2.7c-.1-1.5-1-3.3-1-4.8.1-1.6.8-4.6 4.1-7.7zm-11.8 18.3c-1 .8-2.7.4-4-.2l-2.6-.8s.3-.3.6-1c.4-.6.4-1.7.1-3.4-.3-1.8-.5-3.7-.3-4.7.3-1 .3-2.2 2.1-4.2 1.9-2.1 5-3.6 5-3.6l-1.2 2.1c-.7 1.4-2.5 5.3-2.2 9 .3 3.8 2.5 4.5 3 5 .6.5.4 1-.6 1.8zm43.8 31.7c-3.2 1.7-5 1.3-5 2.7.2 1.3 3.1 2.3 3.1 2.3s-3 3.2-5.3 4.6c-2.3 1.5-5 2.4-5 2.4s-1 .2-.4 1.6a5.4 5.4 0 0 0 2.2 2.9l1.1.5s-4 4.3-5.8 5.7a15.3 15.3 0 0 1-4.3 2.5c-1.4.6-.7 3-.4 4 .4 1 1.6 2.5 2.4 2.7.7.2 1 .8 0 2.2-.7 1.1-3 4-4 5.6h-.1l-4.2-5.6c-.9-1.4-.6-2 0-2.2.8-.2 2-1.6 2.4-2.7.3-1 1-3.4-.4-4a15.2 15.2 0 0 1-4.2-2.5 80.2 80.2 0 0 1-5.8-5.7l1-.5a5.4 5.4 0 0 0 2.3-2.9c.5-1.4-.4-1.6-.4-1.6s-2.7-1-5-2.4c-2.4-1.4-5.4-4.6-5.4-4.6s3-1 3-2.3c.2-1.4-1.6-1-4.9-2.7-3.2-1.8-4.3-4.1-4.3-4.1s3.8-1.3 5.7-5a7 7 0 0 0 .7-3.6h.1c6 2 13.1 2.8 19.4 2.8a63 63 0 0 0 19.3-2.8h.2a7 7 0 0 0 .7 3.6c1.9 3.7 5.6 5 5.6 5s-1 2.3-4.3 4z"
    />
    <path
      fill="#d4af3a"
      d="M361.2 237.8c0-10.2 4.7-16.7 4.7-16.7l-12.7-14.6c-12.2 4.7-23.3 5-33.2 0-9.9 5-21 4.7-33.1 0L274 221.1s4.7 6.5 4.7 16.6-2 17.8-3.1 22.7c-1.2 5-2.1 14.1.5 20.7a26.3 26.3 0 0 0 16.7 17c11.3 4.8 17.3 7.3 21.2 10.6 4 3.2 5.9 5.9 5.9 5.9s2-2.7 6-6c3.9-3.2 9.8-5.7 21-10.4a26.4 26.4 0 0 0 16.8-17.1c2.7-6.6 1.7-15.8.5-20.7-1.1-5-3-12.5-3-22.6z"
    />
    <path
      fill="#b96b29"
      d="M357.2 242c-1.6-9.8 4-18.3 4-18.3l-10.9-12.8c-8.4 4.7-20.1 4.1-30.3-.6-10.1 4.7-21.8 5.3-30.2.6l-11 12.8s5.7 8.5 4 18.3c-1.5 9.7-5 25-4.1 31.3.9 6.3 5.3 13.6 9.8 17.4a58 58 0 0 0 16.2 8.7 46.7 46.7 0 0 1 15.3 10s1.5-1.5 3.7-3.2c2.3-1.7 7-5 11.7-6.8a59 59 0 0 0 16.1-8.7c4.6-3.8 9-11.1 9.9-17.4.8-6.3-2.6-21.7-4.2-31.4z"
    />
    <path
      fill="#1d5e91"
      d="M356.1 243.1a32.5 32.5 0 0 1 3.2-19l-9.8-11c-8.4 4.4-18.5 3.3-29.5-.6-11 3.9-21.1 5-29.4.7l-9.9 11s4.7 8.4 3.2 18.9-4 22.4-3.6 29.4l.2 1.4h9s.5-.6 1.5-1 1.3-.7 1.3-.7.2-1.8 1.2-2.2c1.1-.4 1.6-.4 2-.4.5 0 .8-.1 1.3-.6.5-.6 2-1.8 2.6-3.6.6-1.9 1-2.6 1-3.8 0-1.2.4-3 .4-3s-.2-.6-1.1-.3c-1 .3-1-.6-1.2-1.5 0-.9 0-2.7.5-3.6l.7-1.1-.4-1.5s-5.7 1.2-6.7-3.3-1.1-6.5-1.3-7c-.1-.5-.3-.7-1-.7-.8 0-2.4-.4-3.6-2.7-1-2.3-1.2-3.3-.8-4.2.3-.9.9-.5 1-.3.3.3 1.8 2.5 2.4 1.9.6-.6.3-.6-.6-2.3-.8-1.8-.5-2.3-.4-3.2l-.3-2.5c0-.4.5-.8 1-.6.6.3 1 .6 1.3 1 .2.2.3.6.8.4.5-.3.2-1.9.2-2.4 0-.6.6-1 1.3-.5a2.2 2.2 0 0 1 1.2 1.8c0 .6 0 1.1.3 1.1s.6-.9.7-1.4c0-.6.4-1.5.9-.7.5.7.7 1.7.5 2.8-.2 1.1.2.5-.2 2.4-.4 2-.6 2.8-.5 4.2 0 1.5 0 2.3.8 4 .7 1.8 1.3 3.8 2.6 3.9h1.7s1.5-2.8 2.6-3.5c1.2-.6 2.8-.7 4-.9 1-.1 1.5-.5 1.5-.8 0-.2-.3-.3-1.7-.5s-2.5-.5-2.6-1.6c0-1 .3-2-.6-2-1 0-3.2-.8-4-2.2-.8-1.5-.6-1.8-.5-2.7 0-.8 1.1-2.4 1.8-.9.7 1.6 1.1 1.8 1.7 2 .5.4 1.3.5 1-.5-.5-1-.7-1.7-.6-2.5 0-.8.6-1.1 1.2-1.2l3.4-1 1-.2s.1-.7 1.4-1a9 9 0 0 1 3-.5c.8 0 1.5.1 2.7-.4a5.7 5.7 0 0 1 2.9-.7 3.7 3.7 0 0 1 1.9.8c.5.3.4.9.4 1.4 0 .5 0 .8.8.8.9 0 1.6 0 2.3.3.8.3 1.8.7 1.2 1.5-.7.8-.7 1.7-1.2 1.7-.4 0-.4.4-.5.7-.2.3-.4.5.1.8.5.3.5.6 1.2 1.2.6.6 1.6 1.3.6 2.3-1 1-2.7 1.8-2.7 1.8s-1 .5.1 1.1c1.2.7 1.7 2 2.1 2.3l1.2.8c.3.1.2 1 .2 1l-1.5.8c-.8.4-1.7.8-2.5.8s-1.3 0-1 .7c.4.8 1 1.6 1.1 2l.3 1.2s1.4.3 2.6.3l4.3-.2c2.6-.3 3.4-.4 5.9-.1 2.5.2 2.9.2 3.5.4l1.4.6s3.5 0 5.5-.5c2-.4 2.4-1.7 2.1-2.4-.3-.6-.2-1.6-3.6-2-3.5-.6-4.8-.4-7.5-.9-2.8-.5-7-1.9-7.7-5.3-.8-3.4 2-4.8 3.3-5.5l5.8-2.3c1.4-.5 3.9-1 6.5-.7 2.7.4 4.2 1 5.3.5 1-.7 1.9-.2 1.7.8-.2 1-1.3 2.9-4.3 3.8-3 .9-6.6 1-8.5.5-2-.6-3.4-1.3-4.6-.9-1.2.4-2.5 1.9-1.3 3.7 1.3 1.7 7.9 2.3 9.6 2.4 1.8.2 8.3-.2 10.2 3 1.8 3.2.3 6.9-1.8 7.7a29 29 0 0 1-5.7 1.5l-1.7.3s.8 1.7.8 2.4-.1 2 .7 2.6c.8.5 2 .9 3.3.7 1.4-.1 3 .8 3.1 2 .1 1.3.5 3 .6 5.5.2 2.5 0 4.5 0 4.5s0 1-.4 1.9c-.3 1-2 4.4-2 4.4h9.5l.2-1.4c.4-7.1-2-19-3.6-29.5z"
    />
    <path
      fill="#6d8c3e"
      d="M281.6 278.6a27.4 27.4 0 0 0 11.6 14.3c8.2 5 11.8 4.3 19.5 9.3 7.7 5 7.2 5.8 7.3 5.8.1 0-.4-.8 7.3-5.8s11.3-4.4 19.5-9.3a27.4 27.4 0 0 0 11.6-14.3h-76.7z"
    />
    <path
      fill="#d4af3a"
      d="M288.3 237.2c.9 1 1.5 1.2 2.9 1 1.3 0 1.7.9 1.9 2 .2 1 .2 3.5 1.2 5.8s4.2 2.5 4.2 2.5c0-1.1.5-2.6 1-3.9 0-.2.5-1.2-.7-1.2s-1.1-.5-1.8-1.6c-.7-1-2-4-2.4-6a16 16 0 0 1 .6-5.7c.4-1 .4-1.7 0-1.9h-1s.2 1-.1 1c-.3.2-.6-.4-.8-1-.3-.7-.5-.6-1-.6s-.5.5-.1 1c.3.4.1 1.3.1 1.3l-1.4-1c-.5-.2-1.4.2-1.5.8-.1.5.3 2 1.2 2.7s1 2.2.6 3c-.2.6-1.5.5-1.8.2a.8.8 0 0 0-1.2 0c-.4.5-.8.7.1 1.6zm-.5-2.5-.7-.6a35.1 35.1 0 0 1-.5-.7l-.1.7c0 .5.6 1.2.6 1.2l.7-.6zm2-6.4c.4-.1.7-.2.4-.7-.4-.5-.6-1-1-1-.3-.2-.6-.1-.6-.1l.5 1.3c0 .5.2.7.6.5zm2.4-2c0 .5 0 .7.4.5.4-.2.5-.7.3-1a2 2 0 0 0-.6-.7l-.3-.2s.2 1 .1 1.5zm3.4.6-.1-1s0 .6-.3 1c-.2.3-.1.2 0 .5.3.2.4 0 .4-.5zm5.4 23.5c.7 1.6 2.4-.9 4-2.9s1.5-.4 1.3 1.2a7.6 7.6 0 0 0 1 4.5c.7 1 1.2.4 1.5-.4.2-.7.5-2.4 1-3.2.5-.7 1 0 1 .6.1.7 1 2.2 1.7 3.1.8 1 1.2-.3 1.5-1.4l.7-3.5c.2-.6 1 0 1 0l1.6 1.5c1 1 1.1-.6 1.2-1.4.1-.8-.1-2.5.2-2.8.3-.3 1.2.4 2.5 1 1.4.7 1.3-.6 1.2-1.3a7.4 7.4 0 0 0-2-3.4c-1.2-1-1.3-2-1-2.5.4-.5 1.7 0 2.6-.1l1.8-.3c.7-.2.7-.8.7-.8s-.5-.8-1.4-1.6c-.9-.8-1.4-1.4-2.5-1.6-1.1-.3-2.6 0-2.6 0l-.2-.4c-.1-.3-.4-.3-.6 0l-1.2 1.1c-.4.4-.7.6-1 .5-.2-.2.3-.6.3-.6s.5-.4 1-1.4c.6-1 .7-2 .3-2.6-.4-.4-1.5 0-2.2 0-.6 0-1 .2-1-.2 0-.3.6-.1 1.4-.2.8-.1 1.3-1 1.5-1.9s.5-.6 1-.2c.4.5.9.4 1 0l1-1.8c.5-.8.8-1.9.3-2.6-.6-.8-2-.7-2.6-.2-.6.5-1 1-1.1 2.1-.2 1.2-.5.5-.5.2 0-.4-.4-1-.2-1.5.2-.4 0-1 0-1s-.1-1-1.2-1.1a8.6 8.6 0 0 0-3.5.3c-1 .2-.9 1.2-.9 1.2l-1.7.1c-.9.1-2 .5-2.8.7-.8.2-1.1.3-1.1.7l.1 1.1s.7 0 1 .3.2.5-.2.7c-.4.2-.6.2-.6.7s.2.7.7.7c.4 0 1.3 0 2.3.4s1.3 1.4 1.2 2c0 .5-1.5 1.2-2.3 1.2s-1 .1-1 .6 1 .4 1 .4l2.6.3c1.7.2 2 .6 2.8 1.2.7.7.2.9-.2 1-.4.3-1 .8-1.5 1-.6.2-1 .6-1.5.7-.5.1-1.8 0-4.2 1-2.4 1-3.3 4.1-3.3 4.1l1.4-.7c1.1-.5 2.5-1.2 3.8-2 1.2-.7 1.2.4.6 1.5s.6.9 1 .6l2-1.3c1.2-.6.8.4.8.4s-.4.7-.5 2.5c-.1 1.7 1.7 0 2.5-1 .9-1.1 1.2 0 .6 1.2-.6 1.3-1.8 2.3-2.5 2.3s-1.2-.8-1.3-1.2c0-.4.3-1.7-.1-2-.5-.3-1.7 0-2.6.6-.9.5-1 .1-1.3-.4-.2-.4.3-.6.1-1-.2-.2-.6 0-1 .2l-2.8 1.5c-1.7.9-1.6 1.3-1.6 2.5s.3 1.5 1 3z"
    />
    <path
      fill="#d4af3a"
      d="m316.7 224.2 1-.5 1.5-.3c.7 0 .6-.5.4-.8-.1-.4-.4-.5-1.4-.5-.9 0-1.5.5-2 .7l-1.1.4.4.6c.4.5.9.6 1.2.4zm3.8 3.7.8-.2 1.3-.6c.6-.2.8-.3 1.2-1 .4-.8-.4-.8-1.5-1-1-.3-1.6 0-1.7.5-.1.4 0 .8-.5 1.6s0 .7.4.7zm-.3 1c-1 0-2.3 1.5-2.7 1.8-.4.3-.2.6-.2.6l.4 1.2c.2.7.2 1.7.2 1.7h.8c.6 0 1-.2 1.6-.7a4 4 0 0 1 1.8-.7c.9-.2 1.3-.3 2.2-.8 1-.5-.5-1.4-1.5-2.2a3.7 3.7 0 0 0-2.6-1zm-14 3.6c.8-.1 1.2-.5 1.2-1s-.4-1-1.5-.9c-2.6.3-5.1-.7-5.6-3.2 0 0-.8 1.6.8 3.4 1.6 1.8 4.3 1.8 5.1 1.7zm-8.9 41 .5.4h4c.7-.2.7-.8.7-1.2 0-.5.4-2 1-4.7.5-2.6 1.5-4.5 1.9-5.6.4-1-.4-1.4-.7-2l-.8-2.5c-.1-.6-1-.5-1.6-.5-.5 0-.6.9-.7 1.7 0 .8-.4 3.1-.8 5.1-.4 2-2.7 4.7-3.3 5.3-.6.6-1.2.8-1.6.8-.4 0-1.4 0-1.8.3a2.4 2.4 0 0 0-1 1.6c0 .6.9 1 .9 1l1-.8c.3-.4 1-.5 1.5-.6.7-.1.7.1.5.4-.2.3-.1.4.3 1.2zm-6-.2c-.4 0-.6.4-.7.6h2.6a1.4 1.4 0 0 0-.3-.7c-.3-.3-1.1-.1-1.7 0z"
    />
    <path
      fill="#d4af3a"
      d="M294.8 273.2a3 3 0 0 0-1 .7h2.9c0-.2.1-.6-.2-.9-.7-.5-1.3 0-1.7.2zM319 272c-.3 0-.6.3-1 .6-.5.3-.6.8-.7 1.2a.3.3 0 0 0 0 .1h1.3a.2.2 0 0 0 0-.1c0-.4.2-.7.7-1.1.5-.5 0-.7-.3-.7zm2.3 1.3c0-.4-.1-.7-.4-.7-.2 0-.7.5-1 .8a2.4 2.4 0 0 0-.5.5h1.7l.2-.6z"
    />
    <path
      fill="#d4af3a"
      d="M332.3 260.4c.8-.6.7-.8.7-1.5 0-.6 0-.8-.3-1a5.9 5.9 0 0 0-2.8-.8c-1.1 0-3.4.3-4.2.8-.9.6-1.3 2.7-1.3 3.8 0 1 .2 1.2.5 1.2s.8-.8.8-.8l1.8 2.5c.7 1 .4 1.4 0 2.2-.2.8-1.4 2.9-2.2 3.3-1 .5-1.6 0-2.6-.1-1.1-.2-1.7.1-2.3.7s0 1.1.4 1.1c.3 0 .8 0 1.2.5.3.3.1 1.2 0 1.6h5.2c.9-.4 1.5-1.6 1.7-2.3.3-.7 1.4-1.7 2-2.2.5-.5.5-.8.5-2s-.2-1.7-.6-2.5c-.5-.8-.8-2-.6-2.6 0-.7 1.2-1.4 2-2z"
    />
    <path
      fill="#d4af3a"
      d="M323.7 247.4c.6.9.3 1-.4 1.2a8.5 8.5 0 0 1-2.8.2c-1.1-.1-1.1 0-1.1.6a5 5 0 0 1-.8 2.7c-.7 1-1.6.6-2 .2-.6-.3-.9-.2-1 .4l-1.2 2.1c-.5 1-.9 1-1.3.9-.4-.1-.7-.7-1.1-.7-.4 0-1-.8-1.6-1.8-.6-.9-.9.1-1.3 1-.4.8-.7 1.3-1.5 1.2-.7 0-1.6-1.5-2-2.3-.4-.8-.7-1.6-1.3-1.6-.7 0-1.7 1.4-2.4 1.7-.7.4-1 .3-1.3-.2-.3-.4-.7.2-1.1 1.2-.4 1.1 0 2 .6 2.3.6.3 1.7-.5 2.5-1 .8-.6 1.1-.5 2-.5.8 0 .7 1.4 1 3.3.4 2 1.5 2.2 1.5 2.2s.4.3 1.3-1.1c.9-1.5 1-3 1.8-3 .9 0 1 .2 1.8 1.4.8 1.1 1.5 2 2 1.1.5-.8.9-2.1 1.5-2.6.5-.4 1-.6.4.3-.5.8-.8 1.7.4 1.4 1.2-.4 5.7-2.2 7.6-2.6l4.7-.5 4-.3c1 0 1 0 1.1-.7 0-.7-.5-.5-2.3-.5-1.8 0-3 .2-4.3.4-1.3.2-1.8.2-1.6-.2.2-.3.6-.5 2-.7a58 58 0 0 1 6-.5c1.6 0 1 .5 1 1.5-.2 1 0 2.6.2 3.5 0 1 .1 1.3 1 2.7s3.7 2.2 4.5 2.6c.9.5.7 0 .7-.8s.7-.8 1.4-.3c.7.4 2 .7 2.9 1 .8.2 1 .4 1 .8 0 .5 0 1.5.2 2.4 0 1 0 1.2-.4 1.8l-2 2.3s-.8 0-2.3.4c-1.6.3-2.1 1.1-2.3 1.7-.1.7.3.9.4 1.1v.8h.4c0-.2.3-.5.5-.8.6-.7 2-.9 2.9-.5.6.3.6 1 .5 1.3h3.6l2-3.9a6 6 0 0 0 .6-2.6c0-1.2.2-5.8 0-6-.3-.3 0-1.1 0-2.4-.1-1.3 0-2.3-2.4-2.5-2.4-.2-3.2-1.2-4-2-.8-.8-.6-2.7-1.2-5-.7-2.2-2.3-2.6-5-3.1a23.3 23.3 0 0 0-7-.5c-2.2.2-4.8.5-6.2.4-1.5-.2-1.2.2-.7 1z"
    />
    <path
      fill="#d4af3a"
      d="m337.3 273.4-.5.5h2.4a1 1 0 0 0-.2-.7c-.4-.4-1-.2-1.7.2zm4.4-.2a2.2 2.2 0 0 0-.8.7h2.5a1 1 0 0 0 0-.3c-.1-.4-.9-.8-1.7-.4zm-61 1.6a24.1 24.1 0 0 0 .5 2.3h77.6l.6-2.3h-78.8zm52.3-37.1c2.4 1.6 10.2 1.7 13.9 2.4 3.6.8 3.4 3.6 2.3 5-1.2 1.5-6.3 1.7-7.2 1.8.5.3 1.2 1.4 1.2 1.4l2.1-.2a11 11 0 0 0 6.1-2c1.9-1.6 1.8-4 .1-5.8-1.6-1.6-4.3-1.8-7-2.1-2.8-.3-5-.5-8-1-3.2-.6-4.7-1.8-4.7-3.6s1.7-2.8 2.9-3.1c1.2-.4 3.1-.9 4.9-.2 1.7.6 3.7.7 7.1.3 3.4-.5 4.2-2.8 4.2-2.8s-.4.2-2.2.2c-1.7 0-3-.7-6-.7-3.2 0-4.3 1-5.8 1.6-1.5.5-5.4.9-6.5 3.4-1.2 2.5.1 3.7 2.6 5.4z"
    />
    <ellipse cx={312.6} cy={226} fill="#b96b29" rx={1.5} ry={1.4} />
    <path
      fill="#b96b29"
      d="M344 228.4c-2-.2-4.5.4-4.5.4s.5.4 1.2.3c.6 0 1.8 0 3.7.3 1.9.3 3.2-.6 3.2-.6l-3.6-.4z"
    />
    <path
      fill="#1d5e91"
      d="M325.6 264.6c-.5-.8-.6-.7-1.2-.2-.5.4-1-1.2-1.1-2.2l.4-4.1s-2.6.5-4 1l-4 .9c-1.1.2-1.8.5-2.4.4-.6-.2-1.9-.2-2.9-.2s-1 .2-2 1.2-1.3 1.5-2 3.4a20 20 0 0 0-1.4 6 15.6 15.6 0 0 1-.7 3.1h12.2l.5-1.2a3 3 0 0 1 1.4-1.4c.5-.2 1-.2 1.2-.8.2-.5.8-1 1.4-1.2.7-.3 1.8-.2 2.8.1 1 .3 1.4-.4 1.7-.8.3-.4.4-1 1-1.6.5-.7 0-1.3 0-1.3l-1-1.1zm19.5.3c-.1-.7 0-.8-.5-.9-.4 0-1.1-.2-1.7-.5-.6-.2-.5 1.4-.5 1.4s-1.5.2-3.1 0-3.5-1.7-4.2-2.2a5.5 5.5 0 0 1-1.4-1.5l-1 .7c-.5.3-.8 1.3-1 2.4 0 1 1.3 2.2 1.4 3.2 0 1-1.2 3.1-1.8 4a9 9 0 0 0-1.2 2.4h5.9a3 3 0 0 1 .6-1c.6-.6 1.6-.7 1.6-.7l.2-.8c.2-.5.9-1.2 2.3-1.8 1.5-.5 3.3-.6 3.3-.6s.7-.6 1.2-1.4c.5-.8 0-2 0-2.7z"
    />
    <path
      fill="#d4af3a"
      d="M296.2 329.6c1.1.4 3.2-.4 4.2-1.6 1-1.3 1.4-3.2 2.1-4.3l1.3-1.9s-.2 1.8-1.2 4.3a15.5 15.5 0 0 0-.8 6.8c.4 2.7 2.2 3.1 3.2 2.7.8-.2 2-1.4 3-3.2l1-2c.6-1.3 1.2-3.5 1.5-3.4.7.1.3 1.6 0 2.6-.5 2-1.5 5-1.6 7 0 1.7.2 5 2 5.2 1.8.1 2.8-1.5 3.8-5.2s1.2-5 1.7-5c.4 0 .4 2.6.4 3.7a18.2 18.2 0 0 0 1.6 7.4c.9.8 1.6.7 1.6.7s.7.1 1.6-.7c.9-.8 1.6-6.3 1.6-7.4 0-1 0-3.6.5-3.6s.6 1.2 1.6 4.9 2 5.3 3.8 5.2c1.9-.2 2-3.5 2-5.3 0-1.8-1.1-4.8-1.6-6.9-.5-2 .2-1.9 1.6.8l1.3 2.5c1 1.6 2 2.5 2.6 2.7 1 .4 2.8 0 3.2-2.7.5-2.7-1.6-10.5-1.6-10.5l1 1.3c.7 1.1 1 3 2 4.3 1 1.2 3.1 2 4.2 1.7 1-.4 1.2-2.4.4-6.1s-4-5.7-6.4-8.6a31.6 31.6 0 0 1-4-8.2 27 27 0 0 0-7.9 5.6l-5.9 6.3s-1-1.3-5.8-6.3a27 27 0 0 0-8-5.6c-.2.6-2.2 5.2-4.4 7.9-1 1.3-2.5 2.3-3.6 3.6a12.4 12.4 0 0 0-2.4 5.3c-.8 3.6-.6 5.7.5 6z"
    />
    <path
      fill="#d4af3a"
      d="M296 342c1.5-1.2 2.2-2 2.2-2s1-.8.8.9c-.3 1.6-.8 5-.5 6.4.4 1.4.5 2.7 2.3 1.6 1.8-1 2.3-1.7 3.1-2.6.9-.9 1.8-1.3 1.6.1-.3 1.4-.9 3.6-.6 6.4.3 3 1.7 3.3 3.6.9a32.3 32.3 0 0 0 3.5-5.9c.5-1.2 1.6-2.2 1.6 0 0 4.8 1.1 11.8 6.4 13.6 5.3-1.8 6.4-8.8 6.4-13.6 0-2.2 1.1-1.2 1.7 0a32.4 32.4 0 0 0 3.5 5.9c1.8 2.4 3.2 2 3.5-.9.3-2.8-.3-5-.5-6.4-.2-1.4.6-1 1.5-.1s1.3 1.5 3 2.6c1.9 1 2-.2 2.4-1.6.3-1.5-.2-4.8-.5-6.4-.2-1.7.8-.8.8-.8l2.1 2a6 6 0 0 0 3.4 1.2s.9-5-1.2-8c-2-3-2.9-4-2.9-4s-1.1 0-2-.4c-1-.3-1.8-1-1.8-1v2.8l3.1 3.1c.6.8 1.8 2 0 .8a50.5 50.5 0 0 1-3.1-2.4s-.4 2.5-1.1 3.2c-.7.6-1.8.7-2.2.5l-.4-.1-.2 1s1.6 3 1.8 4.1c.3 1.2 0 1-.8-.5-.7-1.5-2.2-3.5-2.8-4.5-.6-1.1-1.6-1.8-1.5-.5.1 1.4-.5 3.9-1 4.8-.4.9-.7 1.2-.7 1.2l1.1 4c.1.7 0 1.5-.5.6-.6-.8-2.1-4.2-2.1-4.2s-2.1 0-2.7-.7c-.6-.6-1.6-2.9-1.6-2.9s-.8 3-1.5 4c-.7.9-2.4 1.8-2.4 1.8l-.2 6c-.2 1-.2 1.3-.6 1.3s-.4-.4-.5-1.3l-.3-6s-1.6-1-2.3-1.9c-.7-1-1.6-3.9-1.6-3.9s-1 2.3-1.5 3c-.6.5-2.7.6-2.7.6s-1.6 3.4-2.2 4.2c-.5.9-.6.1-.5-.5l1.1-4.1s-.3-.3-.7-1.2c-.5-1-1-3.4-1-4.8.1-1.3-.8-.6-1.5.5s-2 3-2.8 4.5-1 1.7-.8.5c.2-1.2 1.8-4.1 1.8-4.1l-.1-1-.5.1c-.4.2-1.4.1-2.2-.5-.7-.6-1-3.2-1-3.2l-3.2 2.4c-1.8 1.2-.6 0 0-.8l3.2-3.1v-2.8s-1 .7-1.8 1c-1 .4-2.1.4-2.1.4l-2.9 4c-2 3-1.2 8-1.2 8s2 0 3.4-1.3zm25.8 33.5L320 373s-.4.8-1.8 2.4a43 43 0 0 1-4.5 4s.3 4.2 1.8 6.5c1.3 1.9 2.5 3.6 4.5 5 2-1.4 3.3-3.1 4.5-5 1.6-2.3 1.9-6.5 1.9-6.5s-3.2-2.4-4.6-4z"
    />
    <path
      fill="#b96b29"
      d="M319.4 380.6c0 1 0 3.4.6 3.4s.5-2.4.6-3.4l.2-3.3h-1.6s0 2.3.2 3.3z"
    />
    <path
      fill="#d4af3a"
      d="M320 151.3c-5.7.1-12.3-.7-16-2l-3.8.8a52 52 0 0 0 19.8 3.3c8.8-.1 13.8-1 19.8-3.3l-4-.8a50.7 50.7 0 0 1-15.8 2zm20.5-4.7c-.4-.4-3-2.2-3.7-2.5-.6-.4-.1-1.3 0-1.6.1-.4 3-1.2 4.6-1.7 1.6-.4 1.4-.7 1.4-.7s-1-1.1-6.8-1.7c-5.8-.7-16-.5-16-.5s-10.2-.2-16 .5c-5.8.6-6.8 1.7-6.8 1.7s-.2.3 1.4.7a19 19 0 0 1 4.6 1.6c.1.4.6 1.3 0 1.6a45 45 0 0 0-3.7 2.6c-.5.4-.5 1 .2 1s.7 0 2.7-.4a94.4 94.4 0 0 1 35.2 0c2 .4 2 .4 2.7.4.7 0 .7-.6.2-1z"
    />
    <path
      fill="#d4af3a"
      d="M333.9 149c-4-.4-6.5-1-13.9-.9-7.4.1-10 .5-13.9 1 2.5 1 6.6 1.5 13.9 1.5s11.4-.5 13.9-1.5zm-15-57.5-.1 2.8 3-.2-.3-2.7 3.3.5.1-2.6-3.4.3.6-2.9h-3.8l.7 2.9-3.3-.3v2.6zm6.5 7.1h-4v-3.4a6 6 0 0 0-1.3-.2l-1 .1v3.5h-4.3a4.6 4.6 0 0 0-.2 2h11v-.6a5.4 5.4 0 0 0-.2-1.4z"
    />
    <path
      fill="#1d5e91"
      d="M320.1 105a5.5 5.5 0 0 0 5.2-3.4H315a5.5 5.5 0 0 0 5.2 3.5zm2.3-9.5v2.4h2.7a5.3 5.3 0 0 0-2.7-2.4zm-4.5 0a5.3 5.3 0 0 0-2.8 2.4h2.8v-2.4z"
    />
    <path
      fill="#b96b29"
      d="m323.3 140-3.3-1.5-3.3 1.7c-1.2.5-1 .4-1.4 1.2-.3.9 0 1.2.6 1.4l4.1 2 4.6-2c.8-.4.7-.8.4-1.5-.2-.6-.7-.8-1.7-1.3z"
    />
    <path
      fill="#d4af3a"
      d="m320 139.3-3.5 1.7 3.6 1.9 3.5-1.9zm0-12.3s-.3 1.2-.7 1.8c-.4.5-.7 1-.6 1.7 0 .6.8 1 1.3 1 .4 0 1.2-.4 1.3-1 0-.7-.2-1.2-.6-1.7-.4-.6-.7-1.8-.7-1.8z"
    />
    <circle cx={320} cy={132.8} r={0.7} fill="#d4af3a" />
    <path
      fill="#d4af3a"
      d="M317.6 129.4s1.1-1.3 1.6-2.2l.8-1.5.8 1.5c.4.9 1.6 2.2 1.6 2.2s1.6-1 2.6-4c1-3.2-.3-6.6-.7-10.1a208 208 0 0 1-.8-9.8 7.3 7.3 0 0 1-3.5 1 7.3 7.3 0 0 1-3.6-1s-.3 6.2-.8 9.8c-.4 3.6-1.6 6.9-.6 10 1 3.2 2.6 4 2.6 4z"
    />
    <ellipse cx={320} cy={122.3} fill="#b96b29" rx={2.8} ry={2.7} />
    <ellipse cx={320} cy={115.8} fill="#b96b29" rx={2.7} ry={2.6} />
    <ellipse cx={320} cy={109.7} fill="#b96b29" rx={2.6} ry={2.5} />
    <ellipse cx={320} cy={121.8} fill="#d4af3a" rx={1.5} ry={1.4} />
    <circle cx={320} cy={115.4} r={1.4} fill="#d4af3a" />
    <ellipse cx={320} cy={109.2} fill="#d4af3a" rx={1.3} ry={1.2} />
    <path
      fill="#b96b29"
      d="M319.9 336c.2.1.2-.3.2-1.2l.4-4c.2-1.2-.3-1.1-.6-1-.3 0-.5.9-.5 1.4l.1 4.2c0 .6.2.6.4.7z"
    />
    <path
      fill="#d4af3a"
      d="m290.4 359.1 5.2-3.6a11.8 11.8 0 0 0 4-4h-1c-.6 0-1-.7-1.1-1.5 0-.8 0-2.3.2-4.1.2-1.8-.3-3.3-.3-3.3s-1.2 1.1-3 2c-2 1-2.7.6-2.7.6l-.4-1.9-2 3.7c-1.1 2-4.2 4.2-6.4 5.8a28.6 28.6 0 0 1-6.4 4c-1.8.7-.7 1.5-.7 1.5s1.8 1.8 6.5 2.7c4.6.8 6.9-1 8.1-1.9z"
    />
    <path
      fill="#d4af3a"
      d="M306.8 357.3c-1.7-.2-2.7-.8-3-2.6-.2-1.2 0-5.7 0-5.7l-1.1 1.2c-.7.8-2 1-2 1l-1 1.6a9.3 9.3 0 0 1-3 3.2 50.7 50.7 0 0 0-4.6 3.2 28.1 28.1 0 0 1-4.3 3.1 7 7 0 0 0-3.6 4.7c-.5 2.4 0 3.1 1.8 3 1.8-.1 2 0 5-.7 3-.8 7.3-4.1 10.4-6 3-2 5.4-6 5.4-6z"
    />
    <path
      fill="#d4af3a"
      d="M315 360s-1.2-1.6-1.7-3.4l-1.3-5.4-1.5 3.3c-1 2.1-2.7 2.7-2.7 2.7s0 .9-1.5 2.7a21 21 0 0 1-5.7 4.8c-2.1 1.2-5 3-6.4 5.1-1.5 2.2-1.7 4.4-1 5.4.8 1 1.8-.1 3.2-.9 1.4-.7 5.5-1.3 11.2-4.4 5.6-3 7.4-9.9 7.4-9.9z"
    />
    <path
      fill="#d4af3a"
      d="M317.5 372.7c1.5-2.4 1.8-8 1.8-8l-1.3-1c-.8-.7-2.2-2.9-2.2-2.9l-2 3.8c-1 1.8-1.5 2.4-3.6 4.3-2.1 2-5 3.9-6.2 6-1.2 2-.5 6.1.3 7.5.8 1.5 2 1 3-.1l3.7-3.3c2.1-1.8 5-4 6.5-6.3z"
    />
    <path
      fill="#b96b29"
      d="M299 325.3c.8-1.7 1.7-3.7 2.5-4.8a15 15 0 0 0 1.3-2.2s-2 1.8-2.8 3.1c-.8 1.4-1.3 2.6-1.7 4-.3 1.4-.2 1.6.7 0zm8 1.5.5-1.9s.3-1 .1-1.1c-.2-.1-1 .6-1.6 2.5-.5 1.8-1.4 4.5-1.2 4.6.2 0 1.8-3 2.2-4.1zm6.3 5 .3-.8s.7-2 .7-2.5c0-.4-.2-1-.8.1s-.6 2.2-.7 2.6c0 .5-.7 2.1-.5 2.3.2.1.6-.9 1-1.7zM293.7 351l-.8-.5-1.3 1.5c-.7.7-1.5 1-2 1.7a8 8 0 0 1-2.7 2.3c-1.3.7-1.8 1-1.6 1.1.3.2 1.2-.3 1.2-.3s.3 0 1.9-1c1.6-.9 2-1.4 3-2.3 1-.9 2.3-2.5 2.3-2.5zm6.8 8.1c.6-.6 1.3-1 1-1.4-.4-.3-.8-.3-1.4.2l-2.8 2.6-2 1.5c-.7.6-2.3 1.4-3 1.8-.8.5-.1.5-.1.5l1.2-.5 2.5-1s.7-.3 1.6-1c1-.7 2.4-2 3-2.7zm7.9 5.5c.5-1 0-.8-.9-.4-.8.3-2.7 2.4-3.8 3.1-1.1.8-2 1.1-3 1.6-.9.4-.9.7-.8.9 0 .2.4.2.8 0l1.6-.9 1-.2c.6 0 1.3-.6 2.4-1.6 1.2-1 2.2-1.5 2.7-2.5zm3.7 7.2c-1.4.8-3.8 2.7-4.5 4-.6 1.2-1 2.1-.8 2.3.2.2.9-.2 1.2-.7l.9-1.2s2.4-2.4 3.3-3a8.3 8.3 0 0 0 2.6-3c.4-1 .1-1.4.1-1.4s-1.5 2.1-2.8 3z"
    />
    <path
      fill="#c52126"
      d="M275 170a22.3 22.3 0 0 0-8.3-2.6c-3.7-.3-6.5.2-9.5 1-2.2.6-4 .7-5.7.3-2.6-.7-4.6-3-5.3-6 0 0-2.4 3.1 0 6.5a7.2 7.2 0 0 0 4.4 2.9c5 1 10-2 14.3-2.4 4-.2 7.3 2.4 7.3 2.4s1 .8 2.3 0c1.4-.8 1.8-1.4.5-2.2z"
    />
    <path
      fill="#d4af3a"
      d="m260.3 317.5-1.2-.2c-.7 0-2.2-.6-2.7-.8-.4-.2-1.1-.2-1.6.3-.4.5-4 2.7-4 2.7h6c2 0 3.5-2 3.5-2z"
    />
    <path
      fill="#d4af3a"
      d="M277.4 316.4v-.5l-.8-1.8s-1 .6-1.9 1.5c-1.2 1.3-2.4 3-3 3.7-1 1.3-2.4 2.5-1.2.5s1.6-3 2.6-4.4c1-1.3 1.7-2 1.5-2l-3.4-.5c-2.5-.3-4.1-1.3-5.3-2l-3.3-1.9s-4.3 1.9-5.9 2.3c-1.6.4-2.6.6-1 1.4 1.6.8 2.9 1 3.7 1.5a11 11 0 0 0 4.6 1.2c1.4 0 3.9 0 3 1-1 1.1-2.1 3-3.2 6a20.3 20.3 0 0 0-1 7v2.5s1.8-2 6.6-5 6.6-4 7.5-4.4c.9-.4 1.3-.4 1.1-1.5l-.6-4.6z"
    />
    <path
      fill="#d4af3a"
      d="M295.6 302a68.5 68.5 0 0 1-.9-.4 1 1 0 0 0-.2 0 15 15 0 0 0-4.6 4.2c-1.2 1.9-2.4 2-1.1 0a17.9 17.9 0 0 1 3.2-4.2 23.5 23.5 0 0 1 1-.8 53.3 53.3 0 0 1-7.3-4.2l-1.6 2.5c-1 1-3.3 2-3.3 2s1.8-2 2.4-3.3l.8-2.5a31.6 31.6 0 0 1-4.8-4.6 17.8 17.8 0 0 1-4.1 7.4c-3.8 4.2-11.3 6.3-11.3 6.3s-2.6.3-.5.9c2.2.5 3.7 1.5 7.8.8l5-1.1c.6-.2 2 0 0 .7-2 .8-6.9 1.5-8.7 1.4-1.9-.2-4.4-.6-1.8.8 2.7 1.4 3.8 2 5.4 2s2.3.5 3.9.5 2-.3 3-.5c1.2-.3 2 .1 2 .6 0 .4-1.6 1.7-1.5 4.7 0 3.1.3 5.1.5 6 .3 1 1 2.4 1.4 3.2.5.8.7 1.7 1.1-.1.5-1.8 1.5-4.4 1.9-6.1.3-1.7.6-1.8.7-2.7.2-.9 1.2-1.6.7 0a133.4 133.4 0 0 0-1.3 5.2c-.3 1.5-1.1 4.2.2 2 1.4-2 6.4-7.7 7.3-8.8l2-2.8c.7-.8 2.4-1.9 3.3-3.1a28.5 28.5 0 0 1 3.9-4l-4.5-2zm-69.5-129.2c0 3.1 3.5 9 5.5 12.2 1.9 3.1 2.4 4.4 2 4.6-.2.2-1-1.4-2.1-2.8s-3.2-4.7-5-7.2c-1.6-2.5-4.2-8.4-4.5-8.9-.4-.5-.5-.9-1.4-.2-.8.7-2.5 7.2-.5 11.6 2 4.4 5 7.6 6.3 9.2 1.3 1.5 3 4 2.7 4.1-.3.2-.8-.4-2.3-2L221 187a51.6 51.6 0 0 1-3.8-6c-.2-.5-.6-.4-.8-.2-.5.6-1.4 1.9-1 5.4a17 17 0 0 0 5.3 10.2c2.3 2.4 4.6 4.5 4.2 4.9-.3.3-2.7-1.8-4.3-3.3-1.6-1.6-5.5-5.4-6.4-6.5-.9-1-2.1-.5-2 3.7 0 4.3 4.7 8.5 6.6 10.9 2 2.3 4.4 3.7 4.2 4.2-.2.5-2.2-.7-3.4-1.6l-7-4.6c-1-.7-1.4.6-.2 4.6 1.2 4 4.7 7.2 6.8 8.7 2 1.5 5.4 3.3 5.2 3.8-.2.4-1.6-.2-3.6-1.1a39.4 39.4 0 0 0-6-2.3c-1.6-.5-1.6.7-1.6.7s-.3 3.5 2.2 6.2a13.3 13.3 0 0 0 8 4.3c2.6.5 3 .6 3 1-.1.4-.4.5-1 .5l-5.4.2c-2.2 0-3.4.6-3.4 1.6s-.1 2.3 3.3 4.6 7.2 2.6 8.8 3c1.6.3 1.7.4 1.4.9-.4.5-1.1.4-3.6.7-2.6.2-4.1 1.2-4.5 2-.3.6.2 2.6 2.3 4 2 1.4 4.8 1.9 8.8 1.6 4-.3 5-.3 5.1.3.2.7-1.2 1-3.2 1.2-2 .4-3.5.4-4.7 1.3-1.1 1-.2 2.9 1.7 4.3 2 1.4 6.8 1.4 8.8 1.3 2-.2 5-.9 5.3-.4.2.6-1.5 1.4-3.6 2.1-2 .8-2.7 1.2-3 2.1-.5.9-.1 1.7 2.3 2.6 2.5 1 6.1 1 8 0 1.9-.8 2.9-1.1 3.2-.8.4.3 0 .7-.4 1.1-.4.5-2 1.8-4 2.3-2.1.6-2.3.6-3 2.2-.8 1.7 1 3 4.8 3.2 3.8.1 8.8-1.4 10.4-2.3 1.6-1 2.2-1.1 2.5-.8.2.3.2.5-.6 1.1-.8.6-3.4 2.5-4.7 2.8-1.2.3-1.4 1.3-1.4 2.1 0 1-.3 2.6 3 3.5 3.4.8 7.3.2 11-2.4a8.3 8.3 0 0 0 2.2-2 28 28 0 0 1 .2-8c-.7 0-2-.3-3.4-.9-2-.8-2.8-2.6-3.3-3.6-.4-1-1.1-1-2-.8-.7.3-1.5.6-2.6.6a7.9 7.9 0 0 1-5.3-2.8c-1.8-2-1.4-4-1.5-5 0-1-1.7-.3-2.5-.3s-3.1-.4-5.3-1.9c-2.1-1.4-2.1-3.4-2.3-4.3-.2-.8-1-1.3-1.7-1.6-.7-.2-1.8-.5-3.3-1.7a6.9 6.9 0 0 1-2-4.4c-.1-.8-1-.8-4-2.4-3-1.5-2.7-4.7-2.6-6 .1-1.3 1.5-2.3 1.5-2.8s-1-.6-2-1.2-3.5-1.6-3.6-5.4c0-3.7 2.4-4.1 2.4-4.1l-1.4-.8c-1-.6-3.8-2.5-3.8-4.7s1-3.2 1.8-3.8 2.7-1 2.7-1-1.3-.9-1.8-2.6c-.5-1.7-.7-3.9.5-5.4 1.3-1.6 3.4-1.6 4.6-1.6 1.1 0 2.1.6 2.5.3.4-.3.5-.6 0-1.5a6.6 6.6 0 0 1 0-3.7c.3-.8.4-2.2 3.2-3.2 2.9-.9 6 1 6.9 1.6.9.5.5-.8.5-1.7 0-1-2-3.3-4.2-6.6a73 73 0 0 1-5.6-10.2 65.7 65.7 0 0 1-4.5-13.4c-.3-1.6-1-.8-1-.8s-.6.2-2.2 4.1a25 25 0 0 0-1.6 10.5z"
    />
    <path
      fill="#d4af3a"
      d="M276.5 241.4c-1.7-.1-4-1-5.7-3.6-1.7-2.5-4.3-3-8.8-3-4.4.1-6.5-2-7.6-5.2-1.1-3 .1-6.6 4.7-8.9 4.6-2.2 6.7-4.7 6.8-8.6.2-3.9-4.5-8.7-9.3-14.1-4.7-5.5-8.4-13.2-8.4-13.2s-1.4 1.8-1.4 3.7c0 1.8.7 3.7 0 4.2s-1-.8-3.7-2c-2.8-1.2-5-1.4-6.7.6-1.8 2 0 5.4 1.5 7 1.6 1.7 2.9 3 2.4 3.5-.4.6-2.7-.9-3.5-1.4-.8-.5-2.6-2.5-5.3-2.3-2.6.3-3.6 1-3.8 3.3-.3 2.3 2.4 4.2 4.1 5.1 1.7.9 2.4 1.6 2 2-.5.3-.9 0-1.7-.3a8 8 0 0 0-4.3 0c-1.4.6-3.6 2.5-1.5 4.8s6.4 3.2 7.2 3.3c.9.2 1.3 0 1.4.6 0 .7-1.8.7-4.1.8-2.4.1-3 2.4-2.7 4 .3 1.8 4.2 3.7 6.4 4 2.1.4 2.9 0 3 .7.2.6-.2.8-1.4 1.2-1.2.3-3.5.6-4 2.5-.4 1.9-.5 2.7 1.3 4.4 1.8 1.6 4.8 1.4 5.6 1.2.9-.2 2-1.1 2.8-.3.9.9-.8 1.6-2.3 2.6-1.4 1-1.3 3 1.2 4.4 2.5 1.4 5 .9 6 .5 1-.3 2.4-2 3.1-1 .7 1.1-2.2 1.5-3.4 3-1.2 1.4-.7 3.8 1.7 5.3s6.4.4 7-.2c.7-.6 1.6-.8 2.1-.3s-.2 1.9-.8 3c-.5 1.3-1.4 4.8 2.2 6.2s6.9-1.7 7.5-2.3c.6-.6 1.2-.7 1.7-.5.5.3.3.8-.1 1.4-.5.6-1.4 3.2 1.2 5a6.3 6.3 0 0 0 4.7 1l2-7.2h-.6c-.3 0-.4.5-.4.7 0 .2 0 .4-.2.4-.3 0-.4.2-.8.5-.5.3-.9.7-1.1.5-.3-.2 1-.8 1.2-1.2.3-.4 1-1 1-1.4 0-.4.2-.6.9-1.1l.4-.6a100.5 100.5 0 0 0 1.7-12.7h-1.2zM203 187.6a37.3 37.3 0 0 0 9.3 12.1l-1-3.2c-.4-1.4-.2-2.9-.2-2.9s-1.3-1.7-3.8-5.6c-2.6-3.9-3.9-9.6-3.9-9.6s2.4 5.7 4.2 8.8c1.8 3 4 5.5 4 5.5s.6-2.7 1.2-2.8c.5-.2.9.2 1.3.8.5.6.9.6.9.6l-1.6-2.8-1.5-2.2c-1.5-2.3-4.6-6.6-6.1-10.9-1.6-4.3-5.1-15.1-5.7-18.3-.6-3.2-1.2-1.4-1.8.9a27.6 27.6 0 0 0-1 10.7 53.5 53.5 0 0 0 5.7 18.9zm5 21a135.9 135.9 0 0 0 3.5 2.5l-.6-1.7-.3-2.9-2.8-2.5a41.7 41.7 0 0 1-5.6-6c-3-3.6-.6-1.4 1.8 1.2s7 6.3 7 6.3v-.8a3.1 3.1 0 0 1 .7-1.9c.4-.6.2-.6-2.4-2.6a74.5 74.5 0 0 1-17.6-24.4s-1.4 9 4 18.7c5.4 9.9 10.8 13 12.2 14.1zm28.5 56.3c3-1.2 2.1-4.1 2.1-4.1s-1.8.5-3.5 1.2c-1.7.6-5.8 1.8-7.4 1.8-1.7 0-1.7-.2-1.7-.4s1.2 0 3.6-.4a29 29 0 0 0 7.2-3.1c.7-.5.6-.6-.4-.7a4.5 4.5 0 0 1-2.4-.9c-.4-.3-1.5.1-4.2.8a50.8 50.8 0 0 1-21.5.7c-.6-.2-1.3.2.7 3.7 2.1 3.5 9.4 5.3 14.4 5.3s10.1-2.8 13-3.9zm-13.4-7.2c5.2 0 7.1-1.5 7.1-1.5l-.7-1.3c-.7-1-.6-2.9-.6-2.9l-3.4.6c-2.1.3-4.6.6-7.4.1-2.8-.5-1.6-.8.6-.5 2.2.2 6.4-.6 7.8-1 1.4-.5.8-1-.1-1.3-1-.3-3.5-1.9-3.5-1.9s-6.3.8-12.1.2c-6-.7-9.6-2.2-10.8-2.4-1.2-.2-1.2.3-1.2.3s-.3.6 1.8 3.7c2 3.2 6 5.3 9.3 6.3 3.4 1 8 1.6 13.2 1.6zm-1.4-12.2-.5-1.3c-.3-1 .6-1.9.6-1.9s-1.2-.3-5.1-.8c-3.9-.5-4.1-.8-6.5-1.3-2.4-.6-4-1.3-4-1.5.1-.3.9 0 2.3.6 1.4.5 7.4 1.2 9.9 1.5 2.5.4 3.9.6 4.3.4.5-.3 2-.7 2-.7l-2.4-.5a8.4 8.4 0 0 1-3.2-1.3c-.7-.5-.9-.6-4-1-3.3-.3-5.8-1.3-11.5-3.4-5.7-2-10-4.6-11.1-5.5-1.2-1-1-.3-.8 1 .3 1.1.3 2.6 3.2 6 2.8 3.3 4.2 4.8 11.5 7.4 7.2 2.7 15.3 2.3 15.3 2.3zM200.2 228a40.6 40.6 0 0 0 15.5 6.4c.4-.4-.4-2 0-2.8.4-1.1 1-1.1 2.6-1.2 1.6-.1.5-.4.2-.4l-3-.7c-2.6-.7-5.2-1.1-8.7-2.4-3.5-1.4-4.6-2.3-4.5-2.6.1-.3 1.6.8 5 2 3.2 1.3 7 1.8 9 2.3 2.1.4.3-.5-.7-1-1-.6-2.3-2.8-2.3-2.8s-2.3-.4-6-1.5a48.8 48.8 0 0 1-10-4.2c-1.1-.6-2.2-1.4-3.3-2.2l-5.1-3.7c-1.3-1-1-.2-.8.4s1 3.2 3 6.1c2 3 2.7 3.8 9.1 8.3zm-1-12.7c6.3 5 11.7 6.6 12.6 7 1 .4.9-.2.7-.7-.2-.5-.3-2.2-.3-2.2l-4.8-2.8a79.6 79.6 0 0 1-7.1-4.7c-1.9-1.3-.8-1.2-.2-.7.6.5 3.1 2 5.7 3.6l6.4 3.9s.1-.9.7-1.4c.5-.5 1.8-.4 1.8-.4l-1-1.3c-.4-.6-2.5-1.3-4.9-2.4a57.5 57.5 0 0 1-9.6-6.8c-3-2.6-9-9.1-9.5-9.7-.4-.5-.6-.4-.7.3 0 .6-.2 1 .4 4 .7 3 3.5 9.4 9.8 14.3zm22.3-47.2c.7 1.5 1.5 2.6 2 3.6a52 52 0 0 1 1.4 2.4s.2-.5 0-1.4c-.1-.8-.2-2 0-3.5l.3-2.3c0-.7-.4-1.4-.5-1.9l-1.5-7c-.5-2.7-1-6.4-.9-9.7 0-3.2.5-1.6.5 0a62.2 62.2 0 0 0 2.8 17.2s0-.9.5-2.1c.5-1.3 1.3-2.7 2-4.2.5-1.6.3-1.9.3-1.9s-2.2-10.6-2.8-15.6c-.6-5-1.5-18.1-1.5-18.1-3.3 3.2-5.7 11.8-6 20-.4 6 .6 11.7.9 14 .5 4.5 1.3 8 2.5 10.5zm-7.2 16.8c.1-2.4.7-4.3 2.2-4.8 0 0-1.3-2.4-2.5-5.8a45.7 45.7 0 0 1-1.9-7.7c-.8-5.6-1.5-11.5.2-2 1.7 9.7 3.7 13 3.7 13l2.5 4a17.3 17.3 0 0 1-.4-4.9c.1-1.9.4-4.5 1-6.5 0 0-3-6-4.9-13a82.2 82.2 0 0 1-3.2-22.7s-3 2.3-4 13.9a69 69 0 0 0 7.3 36.5zm33.3 88.6-2-1.3c-1.4-.9-1-3.7-1-3.7l-1.4 1a19.2 19.2 0 0 1-3.7 2.2c-1.5.6-2.2 1-3 1.2-1 .3-.8 0 0-.5.8-.4 1-.7 3-1.4 1.9-.8 5.7-4.2 5.7-4.2l-2.5-.1c-1.6 0-3.6-.9-3.6-.9s-1.6 1.4-8 4.2a50 50 0 0 1-11.8 3.5s.7 3.2 3.8 4.3c2.5 1.1 6 1.8 12.9.2a43.5 43.5 0 0 0 11.6-4.5zm8.4 6.5c.5-2.7-1-4.6-1-4.6l-1.3 1.1c-1 .9-2.4 2.5-5 3.9-2.8 1.3-3.7 1.2-1.1-.2s6.4-5.3 6.4-5.3l-1-.4c-1-.4-2.8.3-10 4.6s-11.4 4.5-11.4 4.5 3.2 3.9 12 3.6c8.7-.3 11.8-4.5 12.4-7.2zm16.5-3.1s-1 1.3-2.3 2.2c-1.3.9-4.7 1.4-4.7 1.4l-.8 1.2c-.7 1-2.2 3-3.7 4-1.6 1.2-4 2-4.1 1.6-.1-.3 1.4-.8 2.9-1.8 1.5-.9 2.8-2.6 3.8-3.7 1-1.2-.4-1-.4-1h-3.5c-1.7-.2-1.4 0-1.9.7l-2.4 3-4.4 5.1c-1 1.2-.2 1.5-.2 1.5s.4.7 4.3 1.2c2.4.2 5 0 7.8-1.6a23 23 0 0 0 5.2-4.5c4.6-5.1 4.4-9.3 4.4-9.3zm2 10.5-1.4 1.8 1.2-3c.3-.6.7-1 1-1.4-.7-1.4-1.3-3-1.6-4.7-.5 1.4-1.8 5.5-3.4 8.1-2 3.2-3.8 4.4-2.7 5.3 1.2.8 3.4 1 6-.2 2.4-1.2 3.1-3.3 3.5-5a24.8 24.8 0 0 1-1.2-2.1 5 5 0 0 0-1.3 1.2z"
    />
    <ellipse cx={274} cy={158.6} fill="#d4af3a" rx={1.8} ry={1.6} />
    <path
      fill="#d4af3a"
      d="M270.3 155.5c1.6 0 2.4-.8 4.2-.6 2.2.2 5 1.4 8.6 3.3a14.6 14.6 0 0 0 9.8.9c1-.3 2-.9 2.9-1.4 4.2-2.4 3.2-7.1 3.2-7.1a16.7 16.7 0 0 1-10.7 3.2l1 .8c.5.6 1.7 1.4 1.3 1.7-.4.3-2-1.2-3.2-2.2a19.4 19.4 0 0 0-6.5-3.2c-3.3-1-7-1-9.5.4-2.5 1.3-2.7 3-2.3 3.7.2.4.6.5 1.1.5zm46.2 34.7c-.8-.2-2.1-.4-3.8-2a71.4 71.4 0 0 1-6.3-7c-.5-.8-.3-1.5.9-2 1.1-.5 2-2 2-2s-2.6-1-4.3-2.2a44 44 0 0 1-6.2-5.7c-.6-1-.3-1 .5-1.3.8-.3 1-.8 1-.8s-1.8-1.2-3.5-2.6a71 71 0 0 1-4-3.6c-2.6 1-6.7.6-8.9.2-3.8-.7-6.6-2.3-6.6-2.3l-.6 1.8c-.5 1.2-2.3 1.8-4 .7-1.8-1.2-1.4-3.7-1.4-3.7s-1.5-1-4.4-2c-3-1.1-5.4-1.3-7.8-.2-2.4 1.1-3.6 4.4-3.6 7 0 2.4 1.4 1.3 1.6 1 .3-.3.9-2.1 3.9-2.6s5.7 1 9.2 3.8c3.4 2.8 4.1 3 5.9 4.8 1.7 1.8.3 2.7-2.6 3.7-3 1-6.8-1-6.9-.9-.6.3 1.3 3 3.8 4 2.6 1 5.8.3 8.3-.8 1.7-.6 2 0 2.6.6a15 15 0 0 1 4 9 4 4 0 0 0 2.6-3c0-.6.2-1.8 1.2-1 1 1 1.7 6 1.7 8.2s-.7 5.3-.7 5.3h.7l2.3-1.2c1.1-.7 1.2 0 1.2 1.3s.4 3.6 2 7.8c1.7 4.2 4.1 5.5 4.1 5.5s.5-.8 1-2.5.8-4.8.8-7.7c0-2.8-.8-8.8-.8-8.8s3.5 4.2 7 5.2c3.6 1 7.2.4 8.7-1.3 1.5-1.7.1-2.5-.6-2.7z"
    />
    <path
      fill="#d4af3a"
      d="M293 201s-1 2.5-1.7 3.3l-.8 1s1 1 2.6 1.4l3 .8s-1.8-2.4-2.4-4.1l-.7-2.3zm21.4-1.3a71.6 71.6 0 0 0-.8-2.1 15 15 0 0 1-8.2-1.7s1.7 3.3 3.3 4.5l1.9 1.2s-1.7.3-3.9-2c-2.2-2-3.1-4.6-3.1-4.6s.5 5.8-.4 9.3l-1.1 4s4.6.9 9.8-.6c5.2-1.4 5.6-1.9 5.6-1.9s.6-.1-.2-1.2a28 28 0 0 1-2.9-5z"
    />
    <path
      fill="#b96b29"
      d="M305 187a11 11 0 0 1-1.8-2.3s-.5.5 0 1.3a15 15 0 0 0 4.3 3.7 11.1 11.1 0 0 0 3 1.2v-.4s-3.9-1.7-5.5-3.5zm-6.3 12-.4-8.3c0-1-.7-.8-.7-.8l-.8.3 1.6 10.6c.1 1.2.7 1 1 1-.6-.3-.7-2.5-.7-2.8zm-9.8-31.4c-.6-.6-2-1-.7.4s3 3.2 3.5 4.7c.5 1.4.8 3.3 0 2.9-.9-.4-1.5-.4-2.4-1.2a15 15 0 0 0-3.2-2.1c-.7-.2-2 0-1 1a24.8 24.8 0 0 0 4 3.6c1.8 1.3 3 2 4 2.6a36.9 36.9 0 0 0 1.9 1.3s-.9-6-2.5-8.5a26.3 26.3 0 0 0-3.6-4.7zm-32 99.2a7 7 0 0 1-2.8 1.3s-.8 0-.8.2 1 0 1.8-.1a8 8 0 0 0 2.6-1.4c.5-.4 1.2-.8 1-1.4-.3-.6-.6.5-1.8 1.4zm10.3 5.5-2.2 1.8-1.3.7c-.7.2-.9.6-.9.6s.2.2.9 0 2.7-1.7 3.4-2.3c.7-.6 1-.7.7-1s-.4 0-.6.2zM225.3 198c.4.4.8 1 1 .9.2-.2 0-.5-.5-1l-.8-.9-1.1-1.5c-.4-.4-1-.7-.3.3l1.7 2.2zm-3.2 7 1.4 1.3c.5.5.8 1.1 1.1.8.3-.3-.7-.9-1.2-1.5a7.5 7.5 0 0 0-1.4-1.4 10 10 0 0 0-1.2-.8l1.3 1.6zm1.2 11.2c.8.9 2 1.1 2.1.8.2-.4 0-.6-.7-1a24 24 0 0 1-2.3-1.4l-1.4-1.1c-.4-.4-.8-.7-1-.6-.1.1 1.1 1.5 1.5 1.7.4.2 1 .8 1.8 1.6zm2.3 9c0-.3 0-.5-.6-.5a26.9 26.9 0 0 1-1.6-.2s-1.3-.5-1.3-.2c-.1.3 1 .8 1.5.8l1.4.4c.3.2.6 0 .6-.3zm1 9.8c-1.4 0-2.6-.3-2.7 0-.1.1.6.5 1.3.7.8.3 2 .3 3 .4 1 0 1-.2 1-.6 0-.5-1.2-.5-2.6-.5zm11 10.8c-.2-.2-.7 0-1.5 0-.8.3-2 .5-2.8.5l-2.4-.1-.9.2c0 .2 1.2.2 3 .4 1.7.2 2.9-.2 3.7-.3.8-.2 1.1-.5 1-.7zm4.6 7.6a5.6 5.6 0 0 1-2.2.4l-2.2.3s-.8 0-.6.4c0 .3.3 0 1-.1h2.3c1.1 0 1.8-.4 2.5-.5.7-.1 1.5-.5 1.2-1-.4-.4-1.2.2-2 .5zm8.9 5.8-2.4 1.8-1.2.6c-.7.4-.7.6-.6.8.2.2.6-.3 1-.5.5-.1 1.8-1 2.5-1.6.7-.6 1.6-1 1.5-1.5-.2-.4-.3-.1-.8.4zm-14.8-74.8 1.7 2.3c1.6 1.9.7.1.3-.4l-3.4-4.5c-.8-.9-.9-.5-.5 0l1.9 2.6zm-3.2 9.8c.2-.2-.3-.4-1.2-1.5l-2.6-3.3s-.5-1-.7-1c-.1.1.6 1.8 1.3 2.5.7.7 1.7 2 2.2 2.7.5.6.7.9 1 .6zm4.2 18.5c0-.5-1.7-.5-2.5-.6l-2.2-.5s-1.6-.3-1.7 0c0 .1.3.3 1.2.5l3.4.8c1 .1 1.8.3 1.8-.2zm-4.2-10c1.1 1 1.9 1.4 2.5 1.7.6.4 1 .8 1.4.5.3-.4-.3-.7-1.3-1.1-1-.5-1.4-.9-1.4-.9l-1-.5c-.6-.3-1.4-.6-.2.3zm9.9-6.5-1.4-1s-.8-.8-1-.5c-.2.3 1 1 1.5 1.6.6.5 1.6 1.9 2 1.6.6-.3-.4-1.1-1.1-1.7zm-6.5 25.7-1.6.4c-.6.2-.7.4.5.4 1.1 0 1.5-.3 2.7-.5 1-.2 1.5-.3 1.3-.7-.2-.3-.8-.2-1.2 0l-1.7.4zm1.7 9.3c0 .2.8 0 1.4-.2.6-.2 1.8-.9 2.5-1 .7-.3.7-.4.7-.8s-.8 0-1.7.2c-.9.3-2 1.2-2 1.2s-.8.4-.9.6zm12 5.6c.9-.5 1-.8.7-1-.3-.3-.5-.3-1.2.2a51 51 0 0 1-2 1.5l-1 .5c-.6.2-1.2.7-1 1 .1.1 1.2 0 1.7-.6s2-1 2.8-1.6zm5.7 7.5c.3-.3 1.3-.6 1.8-1 .4-.3.7-1.3.3-1.4-.3-.1-.5.4-1.3 1l-3.5 2.4-.7.3c-.8.2-.4.5.2.4.6-.1 1-.1 1.8-.7l1.4-1zm8.3 7.1a10 10 0 0 0 2.3-1.7c.5-.4 1.1-1 .7-1.3-.3-.3-.7.1-1.3.6l-2.1 2.2s-.3 0-1 .7c-1 .7 0 .5.2.3a3 3 0 0 1 1.2-.8z"
    />
    <path fill="#d4af3a" d="m295.2 143.5 3.2 1.4 3.4-2.4-4-1z" />
    <ellipse cx={309.2} cy={142.1} fill="#b96b29" rx={3.2} ry={3.1} />
    <circle cx={309.2} cy={141.4} r={1.9} fill="#d4af3a" />
    <path
      fill="#d4af3a"
      d="M302.4 131.4c.9.3 2 .2 2 .2s.3-1.4-.5-2.1l-2-1.7-.5-.6-.1 2c0 .8.3 1.9 1.2 2.2z"
    />
    <circle cx={304.2} cy={133} r={0.6} fill="#d4af3a" />
    <path
      fill="#d4af3a"
      d="m299.8 132.4-.8.9s.6 0 1.2.4c.5.4 1.2.7 1.8.6.7 0 1-.7.8-1-.1-.5-.4-1-1.5-1.3-1-.4-1.3 0-1.5.4zm2.2 3.7c-2 .2-4.7-2-4.7-2-.2 1.8-1.3 2.7-3 3l.1.1s1.6.8 3.5 1.1a7 7 0 0 0 2.5-.2c1-.2 2.3-.5 3-1 1.2-.7.8-2.6.8-2.6s-.2 1.5-2.2 1.6zm-7.9-2c-.8-.3-2-.9-2.6-1-.5 0-1.2 0-1.1.9.1 1 1.1 1.4 2 1.4 1 0 1.5-.3 2.1-.6.6-.3.5-.4-.4-.7zm-6.3-3.4c-.9-.7-1.7-.9-1.7-.9s-.6 1.6-.3 2.6c.4 1 1 1.2 2 1.2.8 0 2-.5 1.7-1.2a5 5 0 0 0-1.7-1.7z"
    />
    <ellipse cx={288.6} cy={135.1} fill="#d4af3a" rx={0.7} ry={0.5} />
    <path
      fill="#d4af3a"
      d="M290.6 127.3a11 11 0 0 1 2-9.3c2.5-3.6 7-5.1 7-5.1l1.5-1.8c1.4-1.5 4.2-3.4 4.2-3.4l-5.2 1.5a2.3 2.3 0 0 1-2.2 2.4c-.5 0-1-.2-1.3-.4-1 .1-4.4 2.2-5.3 2.9l.3 1.2a2.3 2.3 0 0 1-2.2 2.3c-.4 0-.7 0-1-.2a9.6 9.6 0 0 0-.3.5 23.4 23.4 0 0 0-1.7 3.7c.6.4 1 1.1 1 2 0 1.3-.9 2.3-2 2.3a7.9 7.9 0 0 0 0 1.5c.1.7.4 1.2 1.7 1.6 1.3.3 3.1 2.6 3.1 2.6.1 0 1-1.6.4-4.3z"
    />
    <path
      fill="#d4af3a"
      d="M298.6 110.3c.5-.4.6-1 .2-1.4-.4-.3-1-.3-1.5.1s-.6 1-.2 1.4c.3.3 1 .3 1.5-.1zm-8.5 5.7c.6-.5.7-1.3.3-1.7-.5-.4-1.2-.4-1.8.1s-.6 1.3-.2 1.7c.4.4 1.2.4 1.8-.1z"
    />
    <circle cx={285.1} cy={123.2} r={1.3} fill="#d4af3a" />
    <path
      fill="#d4af3a"
      d="M313.3 105c-.7.2-2 .6-3.8 1.6 1.3 0 2.3.8 2.3 1.9 0 1-1.1 2.2-2.4 2.2a2.2 2.2 0 0 1-2.2-2.2l.1-.7-1.7 1.2a17.6 17.6 0 0 0-7.2 8c-2 3.8-2.8 8-2 10.4 1 2.5 4.2 3 4.3 3 0 0-.4-.3-.5-.8l.3-1.6v-2.1s.8-.1 1.2.4l1.4 1.7 1.6 1.5s.6-1 .6-2.1-.7-2.3-.9-4.3c-.1-2 1-5.5 2.8-8 2-2.6 5.5-5 6.6-5.5a2.1 2.1 0 0 0 1.3-1.7l.3-2c0-1.2-1-1.1-2-.9z"
    />
    <path
      fill="#d4af3a"
      d="M309.2 109.5c.7 0 1.4-.7 1.4-1.3 0-.6-.6-1-1.3-1-.8 0-1.4.4-1.4 1s.6 1.3 1.3 1.3zm6.2 24.4c1 .4 2.1.1 2.6-.2.6-.4.7-1.3.1-1.8a2 2 0 0 0-2.1-.2l-2 1.3s.4.5 1.4.9z"
    />
    <path
      fill="#d4af3a"
      d="M318.6 135c-.4.6-.7.9-1.8 1-1 0-2.3 0-3-.8a7.7 7.7 0 0 1-1.3-1.7h-1.2s-.4 1.7-1 2.1c-.5.5-2.5.6-3.3 0-.9-.7-1.6-1.4-1.8-1.3-.1 0 0 .7.9 1.4s1.5 1.3 2.9 1.3h8s1.6 0 2-1c.5-.9.5-1.5.3-1.7-.2-.3-.4.1-.7.7z"
    />
    <path
      fill="#d4af3a"
      d="M306.4 133.7c1.2.6 1.9.2 2.3-.3l.6-.8-1.7-.7c-.6-.4-1-.7-1.5-.6l-.6.1s-.3 1.6 1 2.2z"
    />
    <ellipse cx={300.7} cy={121.9} fill="#b96b29" rx={2.7} ry={2.6} />
    <path
      fill="#b96b29"
      d="M305.3 112.7c-1-.7-2.6-.4-3.5.6-.9 1.1-.7 2.6.4 3.3 1 .7 2.6.4 3.5-.6.8-1.1.7-2.6-.4-3.3z"
    />
    <ellipse cx={300.6} cy={121.5} fill="#d4af3a" rx={1.6} ry={1.5} />
    <path
      fill="#d4af3a"
      d="M304.2 113a1.8 1.8 0 0 0-2 .8c-.3.6.1 1.2 1 1.4 1.7.3 2.5-1.8 1-2.2zm-40.7 206s-4.1 2-5.4 2.3l-1.6.4s-2.8 2.5-4.9 3.8a18.3 18.3 0 0 1-7.1 2.4c-3.2.4-12 .3-16 .1-4-.1-6.4.8-8.1 2.7-1.7 2-2.1 4.7 0 6.8 2.2 2.1 4.6 1 5.4-.2.8-1.3.4-3 0-3.7-.3-.8.7-1 1.8-1.1a24.3 24.3 0 0 1 10.7 2.3c1.3.7.6.8-.3.7-1-.2-2-.5-3.5-1.1-1.6-.6-3-1-4-1s-.7.5-.5.9l1 1.6c.1.4-.3 1.9-.3 1.9l.5 1 .8-1.5c.2-.5-.1-1.5.1-2 .2-.4 1-.4 1.7.4a6.7 6.7 0 0 1 1.8 3.5c.3 2-.3 3.3-.3 3.3s.8.7 1 1.1l-.3 2.3s.6.3 1-.7c.6-1 1.2-3 1.3-3.6.2-.7.6-1.9 1.4-1 .8 1 1.4 2 1.5 2.6l.2 1s1.8-1.7 2.4-2.8a17 17 0 0 1 3.6-3.9c1.7-1.4 4.6-4.2 6-5.2 1.5-1 5.2-3 6.4-3.6 1.1-.7 1.3-.8 1.5-2.7.2-2 1.2-3.8 1.6-5.1l.6-1.9zm-65.8-73.7c0-.4-.7-1.5-.8-2.1-.2-.6-.8-.3-.8-.3s-1.3.8-2.3 1c-1 .3-1 0-1.2-.6l-.5-3.2c-.2-1-.4-1-.8-.8l-2.4 1c-.9.3-.6.7-.3 1.2l1.6 3.1c.5.7 0 1-.4 1.3l-2.3.6c-1 .4-1 .6-.8 1 0 .3.8 1.7 1.1 2.3.4.6.7.2.7.2s1.1-1 2-1.4c.9-.4 1-.3 1.2.4l1.5 4.8c.2.7.5.6 1 .4l1.6-.4c.5-.2.7-1.3.7-1.3l-2.5-4.4c-.5-1 0-1.1.4-1.2.4 0 1.6-.2 2.6-.5 1-.2.7-.8.7-1.2zm22.3 96.5c-.1-.8 0-1.7-.6-2.3a8.1 8.1 0 0 1-1.8-3c-.3-1 .3-1.6.2-2.2-.1-.6-1-.6-1.7 0-.8.7-1.9 1.3-1.9 3.2 0 2 .7 4.2 3.4 5 2.6.8 2.6.2 2.4-.6zm2.7-.9s-.5-.3-.8.2c-.2.5-.2.7.5 1.9.7 1 1.2 1.3 2 1.8s.2-.5.1-.8c0-.3 0-.7-.2-1s-.3-.5-.3-1.3-1.3-.8-1.3-.8z"
    />
    <path
      fill="#d4af3a"
      d="M226 350c.5-.8 1-1 2.1-1.5a15.3 15.3 0 0 1 4.2-1c.7 0 2.5-1.4 2.2-3-.3-1.4-1.4-2-2.3-2.2-1-.3-1.8-.3-2.1.2-.3.5-.9 1-2 1.4s-1.1.7-1.8 1c-.6.1-.1.5-.7 1-.5.4-1.3 0-2.1-.3-.9-.2-1-.4-1.9-.4l-3.4-.2h-.7c-.6 0-.6 0-.9.6s.1 2.1.7 2.9c.6.7 2.6 1 3.9 1.5l3 .8c1.2.1 1.3 0 1.8-.8zm12.2 1.2c1-.7.4-2 .2-2.7-.3-.7-1.7-.9-2.5-.9-.7 0-1.1 0-1.5.4-.4.3-1 .8-2 1.2-1.2.3-2 .7-3.6 1.3-1.5.6-2 1.6-2.6 2-.6.4-1.9 0-1.9 0s-.9-.2-1.2 0c-.3.3 0 .8.6 1.5.6.6 1.8.6 3 1 1.4.4 1.6 0 2.1-.3s1-1 1.8-1.6c1-.6 3-.7 3.9-.8 1-.1 2.6-.4 3.7-1.1zm0-4.6c.4.4 1 1 1.3.3.4-.6 1-2 .6-2.8-.4-.8-1-1.5-1-1.5l-1 3c-.4.5-.4.6 0 1zm-4-7c0-1.2-1-2.8-1-2.8s-.3 1.2-.9 2.2c-.5 1-1 1.6-1 1.6l1.7.4c.5 0 1.1 0 1.1-1.3zm-7.6 2.8c1.4-.2 2.1-.8 2.7-1.3.6-.5 1-1.9.6-2.6-.4-.7-1.4-1.4-1.8-1.4h-.8s-.4 1.3-1 2c-.5.6-1.1 1-1 1.9 0 .8-.1 1.7 1.3 1.4zm2.8-6.3a2.4 2.4 0 0 0-.6-1.9l-.8-.7-.2 1.6-.1.6.7.6c.4.1 1 .4 1-.2zm-17.3-35.7 1-6a39 39 0 0 0-6.3-15.4c-2.4-3.8-5-10-6-13.2a37.4 37.4 0 0 1-2-10c0-2.3 1-3.5 1-3.5s.5-.6.1-1-1 0-1.7.6a7.5 7.5 0 0 0-1.5 2.6l-.3 1.1s-1.2-.3-3.3-.1c-2 .2-3 .3-3 .8 0 .4.3.7 1.7 1.4 1.5.6 2.4.9 3.1 1.7.8.9 2.6 5.2 3.2 7.3.6 2.1 1.8 7.8 2.3 12.2a49 49 0 0 0 4 14.4c.8 1.5 4.5 8.5 7.7 7zm3.7 10.4c-1.4.8-1.3 6.4-.7 9.3.6 2.9 3.4 6.5 4.3 7.5.9 1 1 1 1.5.7l.7-.2s1.2-.5 2.1-1.2c1-.7.6-2.5.4-4-.1-1.6-1.4-4.8-3.6-8.5-2.2-3.6-3.3-4.4-4.7-3.6zm1.5-4.5c0-1.9-1.6-3.2-3.4-3.2-.9 0-1.6.2-2.1.6-1.9 1.7-.7 5.8 2 5.8.9 0 2-.1 2.7-.8.7-.6.8-1.6.8-2.4zm26.5 52.7a7 7 0 0 1-2.2-1.2 10 10 0 0 1-3.1-3c-.3-.7-.3-.7-1.4-.4-1 .4-2.5.3-3.6.4-1 0 .2 1.3 1 2.4.7 1.2.4 5.1.4 5.1l-.1.9c-.2.6 0 1 .2 1 .3.2.5 0 1.3-1 .8-.9 2.2-3.2 2.2-3.2l1.4.3c1.2.3 3.1.1 4.1-.2 1-.3.6-1-.2-1.1z"
    />
    <path
      fill="#d4af3a"
      d="M239.2 362c-.5 0-.7-.1-1 .2l-.6 1.4c-.1.3 0 .6.2.9l.8.5s.4.5.8.7c.5.2.5-.4.5-.9l.3-1.9c0-.6-.4-.8-1-.9z"
    />
    <path
      fill="#1d5e91"
      d="M435 324.2c-1.3-.3-1.9-.8-1.9-.8s-.5 0-1 .7c-.3.8-2 1.8-2 1.8s-2.2.6-2.5 2.2c-.3 1.5.8 2 1.8 1.9 1.1-.2 3.7-.7 4.9-2.1 1.1-1.4 1.3-2.2 1.5-2.7.2-.5.4-.7-.9-1zm3.5-12.4a15 15 0 0 0-7.4-9.9l-2.1 7.5c-.5 1.8-.5 1.7.9 2l6.7 1.6c.9.3 2.4 1 1.9-1.2zm-20.6-3.2c1 .1 1-.3 1.3-1.7l2.1-8.2s-4.5-.1-8.5 1.8c-3.9 1.9-5.6 5.4-5.6 5.4s1 .4 3.7 1 6 1.5 7 1.6zm-10.5 9.3-2.2-.4s1 3.8 2.7 6c1.7 2.2 3.5 3.2 7 3.3 3.5 0 6-1.9 6.5-3.4.4-1.5 1.1-2.6 1.1-2.6s-6.2-.8-8.8-1.4l-6.3-1.5z"
    />
    <path
      fill="#d4af3a"
      d="m406.3 315.5 15.5 3c1 .3 2 .5 2.2.2.3-.3.5-.5 1.6-.9 1.2-.4 1.1-1.5 1.1-1.5l.4-2.2c.2-1 .8-1.4 2-.1 1.3 1.3 1.5 3.2 1.7 5 .3 2 3.2 2.4 4.4 2.6 1.1.2 1.6-.2 2.3-1.3.7-1 1-3.2 1.2-4.6.2-1.4 0-1.2-1.4-1.6l-9.3-2.2c-1.2-.2-1-1-.7-1.9.1-.8 2.8-9.2 2.8-9.2a18.9 18.9 0 0 0-7.7-2.3l-2.3 10c-.3 1.3-1.2 1.3-2.5 1-1.4-.2-11.3-2.5-11.3-2.5l-.8 1.8a15.5 15.5 0 0 0-1.1 5.2c0 1.2.4 1.2 1.9 1.5z"
    />
    <path
      fill="#d4af3a"
      d="M440.3 323.3c-1.3-.9-2.3-1.1-3 .5-.7 1.6-.7 4-2.4 5.6-1.8 1.7-4.2 3.4-6.6 3.2-2.4-.2-3.7-.7-3.2-3.5.6-2.7 4.3-3.6 5.1-5 .9-1.5.7-3.1-.6-4.2-1.3-1.1-3.1-1.3-3.6-1a8 8 0 0 0-2.8 3.7c-.7 2-1.2 3.7-2.8 5a12.2 12.2 0 0 1-9 2c-3.1-.8-4.3-1.8-5.5-5-1.2-3.1-2.6-8.3-3.2-9-.7-.5-1.5-1-2.8 0-1.4 1-1.5 2.4-1.7 3.6-.2 1.1 0 2.5 1.4 4.1 1.4 1.7 2.8 3.3 3.3 5 .5 1.8 2 4.4-.1 4.5-2.2.2-3.2.2-4.8-1.4-1.7-1.6-8.2-6-10-7.4a29 29 0 0 0-2.5-2c-3 0-6-1.2-9-3.3 0 0 1.8 4.4 2.1 6.1.4 1.7.3 2.6.3 2.6l9.1 4.6a168 168 0 0 1 10.3 5.8c2.5 1.5 4.7 4 9.1 3 4.5-.9 13.5-3.6 16.5-4.5 2.9-.9 11-2.9 14-5 3-2 3.2-1.9 3.7-4 .5-2 0-3.1-1.3-4zm-17.2-31 2.2-.3c1.5-.1 1 1.3.7 1.9l-1.4 2.7c-.6 1 .2 1.2.6 1.4l2.3.6c1.3.3 1-.6 1-1l.3-3.8c.1-.9 1-.6 1.2-.5l1.7 1c.6.3 1 0 1-.4l.8-2c.2-1-.4-.8-1-.8h-2.4c-1 0-.4-1-.4-1l1.3-2.1c.6-.9.4-1-.2-1.2l-2.8-.7c-.5-.1-.7 0-.7.3l-.1 2.7c0 .7 0 1-1 1-.8.1-1.3-.4-2-1.1-.7-.8-1-.5-1-.2l-.8 3c-.2.7.1.6.6.6zm4.8 21.8s-.1 1.7-.3 2.3c-.2.7-.6 1.6.1 1.8.8.2 1.4.5 1.8.4.5-.1.3-1 0-1.7a6.4 6.4 0 0 0-1.1-2.2l-.5-.6zm10.5 7c.2.5.7.6 1 .7.4.1 1 .1 1-.5s0-1.5-.5-2.2c-.5-.8-.8-1.3-1.1-.2-.4 1-.6 1.6-.4 2.2zm-36.7-7 1.4.4s0-1.7.3-2.8c.2-1.2.7-2 .3-2-.4 0-.7.4-1 .9-.3.5-1.1.6-1.4 2-.3 1.3.1 1.4.4 1.4z"
    />
    <circle cx={408.9} cy={311.2} r={2.3} fill="#b96b29" />
    <circle cx={415.5} cy={312.8} r={2.4} fill="#b96b29" />
    <circle cx={434.6} cy={316.9} r={2.4} fill="#b96b29" />
    <circle cx={422.1} cy={314.4} r={2.4} fill="#b96b29" />
    <circle cx={423.8} cy={308.6} r={2.4} fill="#b96b29" />
    <circle cx={425.5} cy={302.9} r={2.4} fill="#b96b29" />
    <circle cx={409.1} cy={310.9} r={1.2} fill="#d4af3a" />
    <circle cx={415.6} cy={312.6} r={1.2} fill="#d4af3a" />
    <circle cx={434.8} cy={316.6} r={1.2} fill="#d4af3a" />
    <circle cx={422.2} cy={314.1} r={1.2} fill="#d4af3a" />
    <circle cx={424} cy={308.4} r={1.2} fill="#d4af3a" />
    <circle cx={425.7} cy={302.6} r={1.2} fill="#d4af3a" />
    <path
      fill="#d4af3a"
      d="m349.5 359.1-5.2-3.6a11.8 11.8 0 0 1-3.9-4h1c.6 0 1-.7 1-1.5.1-.8 0-2.3-.2-4.1-.2-1.8.3-3.3.3-3.3s1.3 1.1 3.1 2c1.9 1 2.6.6 2.6.6l.5-1.9 2 3.7c1 2 4.1 4.2 6.3 5.8 2.2 1.7 4.6 3.4 6.4 4 1.8.7.8 1.5.8 1.5s-1.8 1.8-6.5 2.7c-4.7.8-7-1-8.2-1.9z"
    />
    <path
      fill="#d4af3a"
      d="M333.2 357.3c1.7-.2 2.7-.8 3-2.6.2-1.2-.1-5.7-.1-5.7l1.2 1.2c.6.8 2 1 2 1s.2.6.9 1.6a9.3 9.3 0 0 0 3 3.2c1.6 1 3.5 2.2 4.7 3.2a28.1 28.1 0 0 0 4.2 3.1 7 7 0 0 1 3.6 4.7c.6 2.4.1 3.1-1.7 3-1.9-.1-2 0-5-.7-3-.8-7.3-4.1-10.4-6-3.1-2-5.4-6-5.4-6z"
    />
    <path
      fill="#d4af3a"
      d="M325 360s1.2-1.6 1.6-3.4l1.4-5.4 1.4 3.3a4.9 4.9 0 0 0 2.8 2.7s0 .9 1.5 2.7a21 21 0 0 0 5.6 4.8c2.2 1.2 5 3 6.5 5.1 1.5 2.2 1.6 4.4 1 5.4-.8 1-1.8-.1-3.2-.9-1.5-.7-5.6-1.3-11.2-4.4-5.6-3-7.5-9.9-7.5-9.9z"
    />
    <path
      fill="#d4af3a"
      d="M322.5 372.7c-1.6-2.4-1.8-8-1.8-8l1.3-1c.7-.7 2.2-2.9 2.2-2.9l2 3.8c1 1.8 1.4 2.4 3.6 4.3 2 2 5 3.9 6.1 6 1.3 2 .6 6.1-.2 7.5-.8 1.5-2 1-3.1-.1L329 379c-2.1-1.7-5-4-6.5-6.3z"
    />
    <path
      fill="#b96b29"
      d="M341 325.3c-.8-1.7-1.8-3.7-2.5-4.8a15 15 0 0 1-1.3-2.2s2 1.8 2.8 3.1c.8 1.4 1.3 2.6 1.6 4 .4 1.4.2 1.6-.6 0zm-8 1.5-.5-1.9s-.3-1-.2-1.1c.2-.1 1 .6 1.6 2.5.6 1.8 1.5 4.5 1.3 4.6-.2 0-1.9-3-2.2-4.1zm-6.3 5-.4-.8s-.6-2-.6-2.5c0-.4.2-1 .7.1s.6 2.2.7 2.6c.1.5.7 2.1.5 2.3-.1.1-.5-.9-1-1.7zm19.5 19.2.9-.5 1.2 1.5c.7.7 1.5 1 2 1.7a8 8 0 0 0 2.8 2.3c1.3.7 1.8 1 1.5 1.1-.2.2-1.1-.3-1.1-.3s-.4 0-2-1c-1.5-.9-1.9-1.4-2.9-2.3l-2.4-2.5zm-6.8 8.1c-.6-.6-1.2-1-.9-1.4.4-.3.8-.3 1.3.2l2.9 2.6 2 1.5c.7.6 2.3 1.4 3 1.8.8.5 0 .5 0 .5l-1.2-.5-2.4-1-1.7-1c-1-.7-2.4-2-3-2.7zm-7.8 5.5c-.5-1 0-.8.8-.4.9.3 2.8 2.4 3.9 3.1 1 .8 2 1.1 3 1.6.8.4.8.7.8.9 0 .2-.4.2-.8 0l-1.7-.9-1-.2c-.5 0-1.3-.6-2.4-1.6-1.1-1-2.1-1.5-2.6-2.5zm-3.7 7.2c1.4.8 3.8 2.7 4.4 4 .6 1.2 1 2.1.9 2.3-.3.2-1-.2-1.2-.7l-1-1.2s-2.4-2.4-3.2-3a8.3 8.3 0 0 1-2.7-3c-.3-1 0-1.4 0-1.4s1.4 2.1 2.8 3z"
    />
    <path
      fill="#c52126"
      d="M365 170a22.3 22.3 0 0 1 8.3-2.6c3.6-.3 6.4.2 9.5 1 2.1.6 3.9.7 5.6.3 2.6-.7 4.6-3 5.3-6 0 0 2.4 3.1 0 6.5a7.2 7.2 0 0 1-4.3 2.9c-5.1 1-10.1-2-14.3-2.4-4.1-.2-7.3 2.4-7.3 2.4s-1 .8-2.4 0c-1.3-.8-1.7-1.4-.4-2.2z"
    />
    <path
      fill="#d4af3a"
      d="m379.6 317.5 1.2-.2c.7 0 2.2-.6 2.7-.8.5-.2 1.2-.2 1.6.3.5.5 4.1 2.7 4.1 2.7h-6c-2.1 0-3.5-2-3.5-2z"
    />
    <path
      fill="#d4af3a"
      d="M362.6 316.4v-.5l.8-1.8s1 .6 1.8 1.5c1.2 1.3 2.5 3 3 3.7 1 1.3 2.5 2.5 1.3.5s-1.6-3-2.6-4.4l-1.6-2 3.4-.5c2.5-.3 4.2-1.3 5.3-2l3.3-1.9s4.3 1.9 6 2.3c1.6.4 2.5.6 1 1.4-1.6.8-3 1-3.7 1.5a12 12 0 0 1-4.6 1.2c-1.5 0-4 0-3 1a22 22 0 0 1 4.2 13l-.1 2.5s-1.8-2-6.6-5a71 71 0 0 0-7.4-4.4c-.9-.4-1.3-.4-1.2-1.5l.7-4.6z"
    />
    <path
      fill="#d4af3a"
      d="M344.4 302a68.5 68.5 0 0 0 .8-.4h.3c.5.3 3.4 2.3 4.6 4.2 1.2 1.9 2.4 2 1 0a17.9 17.9 0 0 0-3.2-4.2 23.4 23.4 0 0 0-1-.8 53.3 53.3 0 0 0 7.3-4.2c.4.6 1 1.7 1.7 2.5 1 1 3.2 2 3.2 2s-1.8-2-2.4-3.3l-.8-2.5a31.7 31.7 0 0 0 4.8-4.6c.3 1.3 1.3 4.2 4.2 7.4 3.7 4.2 11.2 6.3 11.2 6.3s2.6.3.5.9c-2.1.5-3.6 1.5-7.8.8l-5-1.1c-.5-.2-2 0 0 .7 2.1.8 7 1.5 8.8 1.4 1.8-.2 4.4-.6 1.7.8-2.6 1.4-3.7 2-5.3 2s-2.3.5-4 .5c-1.5 0-2-.3-3-.5-1.2-.3-1.9.1-1.9.6 0 .4 1.5 1.7 1.5 4.7 0 3.1-.3 5.1-.6 6-.3 1-1 2.4-1.4 3.2-.4.8-.6 1.7-1-.1-.5-1.8-1.5-4.4-1.9-6.1l-.8-2.7c-.1-.9-1.1-1.6-.6 0a133.4 133.4 0 0 1 1.2 5.2c.4 1.5 1.1 4.2-.2 2-1.3-2-6.4-7.7-7.2-8.8l-2.1-2.8c-.7-.8-2.4-1.9-3.2-3.1a28.5 28.5 0 0 0-4-4l4.5-2zm69.5-129.2c-.1 3.1-3.5 9-5.5 12.2-2 3.1-2.5 4.4-2.1 4.6.3.2 1.1-1.4 2.2-2.8l4.9-7.2c1.7-2.5 4.2-8.4 4.6-8.9.3-.5.4-.9 1.3-.2s2.6 7.2.5 11.6c-2 4.4-5 7.6-6.2 9.2-1.3 1.5-3 4-2.7 4.1.3.2.7-.4 2.3-2a47.3 47.3 0 0 0 9.6-12.5c.2-.4.5-.3.8 0 .5.5 1.4 1.8 1 5.3a17 17 0 0 1-5.3 10.2c-2.3 2.4-4.6 4.5-4.3 4.9.4.3 2.7-1.8 4.3-3.3 1.6-1.6 5.6-5.4 6.4-6.5 1-1 2.2-.5 2.1 3.7 0 4.3-4.7 8.5-6.7 10.9-2 2.3-4.3 3.7-4.1 4.2.2.5 2.1-.7 3.4-1.6l7-4.6c.9-.7 1.3.6.1 4.6-1.2 4-4.6 7.2-6.7 8.7-2 1.5-5.4 3.3-5.2 3.8.2.4 1.6-.2 3.5-1.1 2-1 4.3-1.8 6-2.3 1.6-.5 1.6.7 1.6.7s.4 3.5-2.1 6.2a13.3 13.3 0 0 1-8 4.3c-2.6.5-3 .6-3 1s.4.5 1 .5l5.3.2c2.3 0 3.5.6 3.5 1.6s0 2.3-3.3 4.6c-3.5 2.3-7.3 2.6-8.9 3-1.6.3-1.6.4-1.3.9.3.5 1 .4 3.6.7 2.5.2 4 1.2 4.4 2 .3.6-.2 2.6-2.3 4-2 1.4-4.7 1.9-8.7 1.6-4-.3-5-.3-5.2.3-.1.7 1.2 1 3.2 1.2 2 .4 3.6.4 4.7 1.3 1.2 1 .3 2.9-1.7 4.3-1.9 1.4-6.7 1.4-8.7 1.3-2-.2-5.1-.9-5.3-.4-.2.6 1.5 1.4 3.5 2.1 2.1.8 2.7 1.2 3.1 2.1.4.9 0 1.7-2.4 2.6a12 12 0 0 1-8 0c-1.8-.8-2.8-1.1-3.2-.8-.3.3 0 .7.4 1.1.4.5 2 1.8 4.1 2.3 2 .6 2.3.6 3 2.2.8 1.7-1.1 3-4.9 3.2-3.7.1-8.7-1.4-10.3-2.3-1.6-1-2.2-1.1-2.5-.8-.3.3-.2.5.6 1.1.8.6 3.3 2.5 4.6 2.8 1.3.3 1.4 1.3 1.4 2.1 0 1 .4 2.6-3 3.5-3.3.8-7.3.2-10.9-2.4a8.3 8.3 0 0 1-2.2-2 28 28 0 0 0-.3-8c.7 0 2-.3 3.4-.9 2-.8 2.8-2.6 3.3-3.6s1.2-1 2-.8c.8.3 1.6.6 2.7.6a7.9 7.9 0 0 0 5.3-2.8c1.7-2 1.4-4 1.5-5 0-1 1.6-.3 2.4-.3.8 0 3.2-.4 5.3-1.9 2.2-1.4 2.2-3.4 2.4-4.3.2-.8 1-1.3 1.7-1.6.7-.2 1.7-.5 3.2-1.7 1.5-1.2 2-3.5 2-4.4.2-.8 1-.8 4-2.4 3-1.5 2.8-4.7 2.6-6 0-1.3-1.5-2.3-1.5-2.8s1-.6 2-1.2 3.6-1.6 3.6-5.4c0-3.7-2.4-4.1-2.4-4.1l1.5-.8c1-.6 3.7-2.5 3.7-4.7s-1-3.2-1.7-3.8c-.7-.5-2.7-1-2.7-1s1.2-.9 1.8-2.6c.5-1.7.7-3.9-.6-5.4-1.2-1.6-3.4-1.6-4.5-1.6-1.2 0-2.2.6-2.6.3-.4-.3-.4-.6 0-1.5.4-.8.4-3 .1-3.7-.3-.8-.4-2.2-3.3-3.2-2.9-.9-5.9 1-6.8 1.6-1 .5-.5-.8-.5-1.7 0-1 1.9-3.3 4.1-6.6 2.2-3.4 3.2-5.1 5.7-10.2A65.7 65.7 0 0 0 409 159c.4-1.6 1-.8 1-.8s.7.2 2.2 4.1a25 25 0 0 1 1.7 10.5z"
    />
    <path
      fill="#d4af3a"
      d="M363.4 241.4c1.7-.1 4-1 5.7-3.6 1.7-2.5 4.3-3 8.8-3 4.5.1 6.6-2 7.7-5.2 1-3-.2-6.6-4.8-8.9-4.5-2.2-6.6-4.7-6.8-8.6-.1-3.9 4.6-8.7 9.3-14.1 4.8-5.5 8.5-13.2 8.5-13.2s1.4 1.8 1.4 3.7c0 1.8-.7 3.7 0 4.2s.9-.8 3.7-2c2.7-1.2 5-1.4 6.7.6 1.7 2 0 5.4-1.6 7-1.5 1.7-2.8 3-2.4 3.5.4.6 2.8-.9 3.5-1.4.8-.5 2.6-2.5 5.3-2.3 2.7.3 3.6 1 3.9 3.3.2 2.3-2.4 4.2-4.2 5.1-1.7.9-2.4 1.6-2 2 .5.3 1 0 1.7-.3a8 8 0 0 1 4.3 0c1.4.6 3.6 2.5 1.6 4.8-2.1 2.3-6.4 3.2-7.3 3.3-.8.2-1.3 0-1.4.6 0 .7 1.8.7 4.2.8 2.3.1 3 2.4 2.7 4-.4 1.8-4.3 3.7-6.4 4-2.2.4-3 0-3.1.7-.2.6.2.8 1.4 1.2 1.2.3 3.6.6 4 2.5.4 1.9.5 2.7-1.3 4.4-1.8 1.6-4.7 1.4-5.6 1.2-.9-.2-1.9-1.1-2.8-.3-.8.9.8 1.6 2.3 2.6 1.5 1 1.4 3-1.1 4.4-2.5 1.4-5 .9-6 .5-1-.3-2.5-2-3.2-1-.7 1.1 2.2 1.5 3.4 3 1.2 1.4.8 3.8-1.6 5.3-2.5 1.5-6.4.4-7.1-.2-.7-.6-1.6-.8-2-.3-.6.5.2 1.9.7 3 .5 1.3 1.5 4.8-2.2 6.2s-6.9-1.7-7.5-2.3c-.6-.6-1.2-.7-1.7-.5-.5.3-.2.8.2 1.4.4.6 1.4 3.2-1.2 5a6.3 6.3 0 0 1-4.7 1c-.6-2-1.3-4.2-2-7.2h.5c.4 0 .5.5.5.7 0 .2-.1.4.2.4.3 0 .3.2.8.5.4.3.8.7 1 .5.3-.2-.9-.8-1.2-1.2-.3-.4-1-1-1-1.4 0-.4-.2-.6-.8-1.1a2.4 2.4 0 0 1-.5-.6 97.9 97.9 0 0 1-1.2-7.2 57.1 57.1 0 0 1-.4-5.5h1.1zm73.7-53.8c-3.9 7.8-9.3 12.1-9.3 12.1l1-3.2c.3-1.4.1-2.9.1-2.9s1.4-1.7 3.9-5.6c2.5-3.9 3.8-9.6 3.8-9.6s-2.3 5.7-4.1 8.8c-1.9 3-4 5.5-4 5.5s-.7-2.7-1.2-2.8c-.5-.2-1 .2-1.4.8-.4.6-.8.6-.8.6l1.5-2.8 1.6-2.2c1.4-2.3 4.5-6.6 6-10.9a169 169 0 0 0 5.7-18.3c.7-3.2 1.3-1.4 1.9.9.6 2.3 1.4 5.7.9 10.7a53.5 53.5 0 0 1-5.6 18.9zm-5 21a135.9 135.9 0 0 1-3.5 2.5l.5-1.7.3-2.9 2.9-2.5a41.7 41.7 0 0 0 5.6-6c2.9-3.6.5-1.4-1.9 1.2-2.3 2.6-6.9 6.3-6.9 6.3v-.8a3.1 3.1 0 0 0-.7-1.9c-.4-.6-.2-.6 2.3-2.6a73.8 73.8 0 0 0 17.6-24.4s1.5 9-4 18.7c-5.4 9.9-10.8 13-12.2 14.1zm-28.5 56.3c-3-1.2-2.2-4.1-2.2-4.1s1.8.5 3.5 1.2a36 36 0 0 0 7.5 1.8c1.6 0 1.6-.2 1.7-.4 0-.2-1.3 0-3.7-.4a29 29 0 0 1-7.2-3.1c-.7-.5-.6-.6.5-.7a4.5 4.5 0 0 0 2.3-.9c.4-.3 1.5.1 4.2.8a50.6 50.6 0 0 0 21.5.7c.7-.2 1.4.2-.7 3.7-2 3.5-9.3 5.3-14.4 5.3-5 0-10-2.8-13-3.9zm13.4-7.2c-5.2 0-7.2-1.5-7.2-1.5l.7-1.3c.7-1.1.6-2.9.6-2.9l3.4.6c2.2.3 4.7.6 7.5.1s1.6-.8-.6-.5a29 29 0 0 1-7.8-1c-1.4-.5-.9-1 0-1.3 1-.3 3.5-1.9 3.5-1.9s6.3.8 12.2.2c5.9-.7 9.6-2.2 10.8-2.4 1.1-.2 1.1.3 1.1.3s.3.6-1.7 3.7c-2 3.2-6 5.3-9.4 6.3a50.3 50.3 0 0 1-13.1 1.6zm1.3-12.2.6-1.3c.3-1-.6-1.9-.6-1.9s1.2-.3 5-.8c4-.5 4.2-.8 6.5-1.3 2.4-.6 4-1.3 4-1.5 0-.3-.8 0-2.2.6a94 94 0 0 1-14.3 1.9c-.4-.3-2-.7-2-.7l2.4-.5a8.4 8.4 0 0 0 3.2-1.3c.7-.5 1-.6 4.1-1 3.2-.3 5.8-1.3 11.5-3.4 5.6-2 10-4.6 11-5.5 1.2-1 1.1-.3.8 1-.3 1.1-.2 2.6-3.1 6-2.9 3.3-4.3 4.8-11.5 7.4-7.3 2.7-15.4 2.3-15.4 2.3zm21.4-17.6a40.5 40.5 0 0 1-15.5 6.4c-.3-.4.4-2 0-2.8-.3-1.1-1-1.1-2.6-1.2-1.5-.1-.5-.4-.1-.4l3-.7c2.5-.7 5.1-1.1 8.6-2.4 3.6-1.4 4.6-2.3 4.5-2.6 0-.3-1.6.8-4.9 2-3.2 1.3-7 1.8-9 2.3-2.2.4-.4-.5.6-1 1-.6 2.4-2.8 2.4-2.8s2.3-.4 6-1.5a48.8 48.8 0 0 0 10-4.2l3.2-2.2 5.2-3.7c1.3-1 .9-.2.7.4s-1 3.2-3 6.1c-2 3-2.7 3.8-9 8.3zm1-12.7c-6.2 5-11.7 6.6-12.6 7-1 .4-.8-.2-.7-.7.2-.5.3-2.2.3-2.2l4.8-2.8c2.5-1.4 5.3-3.4 7.2-4.7 1.8-1.3.7-1.2.1-.7-.5.5-3.1 2-5.7 3.6l-6.4 3.9s0-.9-.6-1.4c-.5-.5-1.9-.4-1.9-.4l1-1.3c.5-.6 2.6-1.3 4.9-2.4 2.3-1 6.5-4.2 9.6-6.8 3.1-2.6 9.1-9.1 9.5-9.7.4-.5.7-.4.7.3 0 .6.3 1-.4 4s-3.4 9.4-9.7 14.3zM418.5 168c-.7 1.5-1.5 2.6-2 3.6L415 174v-1.4c.1-.8.3-2 0-3.5 0-.8-.3-1.6-.2-2.3 0-.7.3-1.4.4-1.9l1.6-7c.4-2.7.9-6.4.8-9.7 0-3.2-.5-1.6-.5 0s-.1 4-.6 7.8c-.5 3.7-2.1 9.4-2.1 9.4s-.1-.9-.6-2.1l-1.9-4.2c-.6-1.6-.4-1.9-.4-1.9s2.3-10.6 2.8-15.6c.6-5 1.6-18.1 1.6-18.1 3.2 3.2 5.6 11.8 6 20 .4 6-.6 11.7-1 14-.5 4.5-1.3 8-2.5 10.5zm7.2 16.8c0-2.4-.6-4.3-2.2-4.8 0 0 1.4-2.4 2.6-5.8a45 45 0 0 0 1.8-7.7c.9-5.6 1.6-11.5-.1-2-1.7 9.7-3.8 13-3.8 13l-2.4 4c.3-1.7.4-3 .3-4.9 0-1.9-.3-4.5-1-6.5 0 0 3-6 5-13a81.4 81.4 0 0 0 3.1-22.7s3 2.3 4 13.9a68.4 68.4 0 0 1-7.3 36.5zm-33.2 88.6 1.9-1.3c1.5-.9 1-3.7 1-3.7a48.7 48.7 0 0 0 5.2 3.2c1.4.6 2.1 1 3 1.2 1 .3.7 0 0-.5-.8-.4-1-.7-3-1.4-2-.8-5.8-4.2-5.8-4.2l2.5-.1c1.6 0 3.6-.9 3.6-.9s1.6 1.4 8 4.2a50 50 0 0 0 11.8 3.5s-.6 3.2-3.7 4.3c-2.6 1.1-6 1.8-13 .2a43.5 43.5 0 0 1-11.5-4.5zm-8.4 6.5c-.6-2.7 1-4.6 1-4.6l1.3 1.1c1 .9 2.3 2.5 5 3.9 2.7 1.3 3.7 1.2 1-.2a39.3 39.3 0 0 1-6.3-5.3l1-.4c1-.4 2.7.3 10 4.6 7.1 4.3 11.4 4.5 11.4 4.5s-3.2 3.9-12 3.6c-8.7-.3-11.9-4.5-12.4-7.2zm-16.6-3.1s1 1.3 2.3 2.2c1.3.9 4.8 1.4 4.8 1.4l.8 1.2c.6 1 2.1 3 3.7 4 1.5 1.2 4 2 4 1.6.2-.3-1.3-.8-2.8-1.8-1.5-.9-2.9-2.6-3.9-3.7-1-1.2.5-1 .5-1h3.5c1.7-.2 1.3 0 1.8.7l2.4 3 4.4 5.1c1 1.2.3 1.5.3 1.5s-.5.7-4.4 1.2c-2.4.2-5 0-7.7-1.6a23.4 23.4 0 0 1-5.2-4.5c-4.7-5.1-4.5-9.3-4.5-9.3zm-2 10.5 1.5 1.8s-.7-2-1.3-3l-.9-1.4c.7-1.4 1.2-3 1.6-4.7.4 1.4 1.7 5.5 3.4 8.1 2 3.2 3.8 4.4 2.6 5.3-1.1.8-3.4 1-6-.2-2.4-1.2-3-3.3-3.4-5a24.8 24.8 0 0 0 1.2-2.1c.3.2.8.5 1.3 1.2z"
    />
    <ellipse
      cx={-365.9}
      cy={158.6}
      fill="#d4af3a"
      rx={1.8}
      ry={1.6}
      transform="scale(-1 1)"
    />
    <path
      fill="#d4af3a"
      d="M369.7 155.5c-1.6 0-2.5-.8-4.3-.6a26 26 0 0 0-8.5 3.3 14.6 14.6 0 0 1-9.8.9c-1-.3-2-.9-2.9-1.4-4.3-2.4-3.2-7.1-3.2-7.1a16.7 16.7 0 0 0 10.6 3.2l-.9.8c-.6.6-1.7 1.4-1.4 1.7.4.3 2-1.2 3.3-2.2 1.3-1 3.2-2.2 6.5-3.2s7-1 9.4.4c2.5 1.3 2.7 3 2.4 3.7-.2.4-.7.5-1.2.5zm-46.2 34.7c.8-.2 2-.4 3.8-2a69 69 0 0 0 6.3-7c.5-.8.3-1.5-1-2-1-.5-1.9-2-1.9-2s2.5-1 4.3-2.2c1.7-1.2 5.6-4.8 6.2-5.7.5-1 .3-1-.5-1.3-.9-.3-1-.8-1-.8s1.8-1.2 3.5-2.6a71 71 0 0 0 4-3.6c2.6 1 6.6.6 8.8.2 3.8-.7 6.7-2.3 6.7-2.3l.6 1.8c.5 1.2 2.2 1.8 4 .7 1.8-1.2 1.4-3.7 1.4-3.7s1.4-1 4.4-2c3-1.1 5.3-1.3 7.7-.2 2.4 1.1 3.6 4.4 3.6 7 0 2.4-1.3 1.3-1.6 1-.3-.3-.8-2.1-3.8-2.6s-5.8 1-9.2 3.8c-3.4 2.8-4.2 3-6 4.8-1.6 1.8-.3 2.7 2.7 3.7s6.7-1 6.9-.9c.5.3-1.3 3-3.9 4-2.5 1-5.8.3-8.3-.8-1.7-.6-2 0-2.5.6a15 15 0 0 0-4 9 4 4 0 0 1-2.6-3c-.1-.6-.3-1.8-1.2-1-1 1-1.8 6-1.8 8.2s.7 5.3.7 5.3h-.7l-2.3-1.2c-1-.7-1.2 0-1.2 1.3s-.4 3.6-2 7.8c-1.7 4.2-4 5.5-4 5.5s-.5-.8-1-2.5a33 33 0 0 1-.8-7.7c0-2.8.7-8.8.7-8.8s-3.4 4.2-7 5.2-7.1.4-8.6-1.3c-1.5-1.7-.2-2.5.6-2.7z"
    />
    <path
      fill="#d4af3a"
      d="M347 201s1 2.5 1.6 3.3c.6.9.9 1 .9 1s-1.1 1-2.7 1.4a35.5 35.5 0 0 1-3 .8s1.8-2.4 2.4-4.1l.7-2.3zm-21.5-1.3a71.6 71.6 0 0 1 .9-2.1 15 15 0 0 0 8.1-1.7s-1.6 3.3-3.3 4.5l-1.8 1.2s1.6.3 3.8-2c2.2-2 3.2-4.6 3.2-4.6s-.5 5.8.4 9.3l1 4s-4.6.9-9.8-.6c-5.2-1.4-5.6-1.9-5.6-1.9s-.6-.1.2-1.2a28 28 0 0 0 3-5z"
    />
    <path
      fill="#b96b29"
      d="m335 187 1.7-2.3s.6.5 0 1.3a16 16 0 0 1-4.2 3.7c-1.6.9-3.1 1.2-3.1 1.2v-.4s4-1.7 5.5-3.5zm6.3 12 .4-8.3c0-1 .6-.8.6-.8l.8.3-1.5 10.6c-.2 1.2-.7 1-1 1 .5-.3.6-2.5.7-2.8zm9.8-31.4c.6-.6 1.9-1 .6.4-1.3 1.4-3 3.2-3.4 4.7-.5 1.4-.8 3.3 0 2.9.8-.4 1.4-.4 2.3-1.2 1-.7 2.6-2 3.3-2.1.7-.2 2 0 1 1a24.8 24.8 0 0 1-4 3.6l-4 2.6a36.9 36.9 0 0 1-2 1.3s1-6 2.6-8.5a26.3 26.3 0 0 1 3.6-4.7zm32 99.2c1.2 1 2.8 1.3 2.8 1.3s.7 0 .7.2-.9 0-1.8-.1a8 8 0 0 1-2.6-1.4c-.4-.4-1.1-.8-.9-1.4.2-.6.6.5 1.8 1.4zm-10.4 5.5 2.3 1.8 1.3.7c.6.2.8.6.8.6s-.1.2-.8 0c-.7-.2-2.8-1.7-3.5-2.3-.6-.6-1-.7-.7-1 .3-.2.4 0 .6.2zm42-74.4c-.4.4-.9 1-1 .9-.3-.2 0-.5.4-1l.8-.9 1.1-1.5c.4-.4 1-.7.3.3l-1.7 2.2zm3.1 7-1.3 1.3c-.5.5-.9 1.1-1.2.8-.3-.3.7-.9 1.2-1.5a7.5 7.5 0 0 1 1.4-1.4 10 10 0 0 1 1.3-.8l-1.4 1.6zm-1.2 11.2c-.8.9-2 1.1-2 .8-.2-.4 0-.6.7-1a24.4 24.4 0 0 0 4.6-3c.2 0-1 1.4-1.4 1.6-.4.2-1 .8-1.9 1.6zm-2.2 9c0-.3-.1-.5.5-.5l1.6-.2s1.3-.5 1.4-.2c0 .3-1 .8-1.6.8l-1.4.4c-.3.2-.5 0-.5-.3zm-1 9.8c1.4 0 2.6-.3 2.7 0 0 .1-.7.5-1.4.7-.7.3-2 .3-3 .4-.9 0-1-.2-1-.6 0-.5 1.3-.5 2.7-.5zm-11 10.8c.1-.2.6 0 1.4 0 .8.3 2.1.5 2.8.5l2.4-.1 1 .2c0 .2-1.3.2-3 .4-1.8.2-3-.2-3.8-.3-.8-.2-1-.5-.9-.7zm-4.6 7.6a6 6 0 0 0 2.1.4l2.3.3s.7 0 .6.4c-.1.3-.4 0-1-.1h-2.4c-1.2 0-1.8-.4-2.5-.5-.7-.1-1.5-.5-1.1-1 .4-.4 1.1.2 2 .5zm-9 5.8 2.5 1.8 1.1.6c.8.4.7.6.6.8-.1.2-.6-.3-1-.5a16.4 16.4 0 0 1-2.5-1.6c-.7-.6-1.6-1-1.4-1.5.1-.4.3-.1.8.4zm14.9-74.8-1.7 2.3c-1.6 2-.7.1-.4-.4l3.4-4.5c.8-.9 1-.5.5 0l-1.8 2.6zm3.2 9.8c-.2-.2.3-.4 1.1-1.5l2.7-3.3.6-1c.2.1-.6 1.8-1.3 2.5-.7.7-1.6 2-2.1 2.7-.5.6-.8.9-1 .6zm-4.3 18.5c0-.5 1.8-.5 2.6-.6l2.2-.5s1.6-.3 1.6 0c0 .1-.3.3-1.2.5l-3.3.8c-1 .1-1.9.3-1.9-.2zm4.3-10a15.3 15.3 0 0 1-2.5 1.7c-.6.4-1.1.8-1.4.5-.4-.4.2-.7 1.2-1.1l1.5-.9 1-.5c.5-.3 1.3-.6.2.3zm-10-6.5 1.4-1s.9-.8 1-.5c.2.3-1 1-1.5 1.6-.5.5-1.5 1.9-2 1.6-.5-.3.5-1.1 1.2-1.7zm6.6 25.7 1.5.4c.7.2.7.4-.4.4s-1.6-.3-2.7-.5-1.5-.3-1.3-.7c.1-.3.7-.2 1.2 0l1.7.4zm-1.8 9.3c.1.2-.8 0-1.4-.2-.5-.2-1.7-.9-2.4-1-.7-.3-.7-.4-.7-.8s.7 0 1.6.2c1 .3 2 1.2 2 1.2l1 .6zm-12 5.6c-.8-.5-1-.8-.7-1 .3-.3.6-.3 1.2.2a51 51 0 0 0 2 1.5l1.1.5c.5.2 1.2.7 1 1-.2.1-1.2 0-1.7-.6s-2-1-2.9-1.6zm-5.6 7.5c-.4-.3-1.4-.6-1.8-1-.5-.3-.8-1.3-.4-1.4.4-.1.6.4 1.4 1l3.5 2.4.7.3c.7.2.4.5-.2.4-.7-.1-1-.1-1.8-.7l-1.4-1zm-8.4 7.1a9.2 9.2 0 0 1-2.2-1.7c-.5-.4-1.2-1-.8-1.3.4-.3.8.1 1.4.6l2.1 2.2s.2 0 1 .7c.9.7 0 .5-.3.3a3 3 0 0 0-1.2-.8z"
    />
    <path fill="#d4af3a" d="m338.2 142.5 4-1 2.5 2-3.1 1.4z" />
    <ellipse
      cx={-330.8}
      cy={142.1}
      fill="#b96b29"
      rx={3.2}
      ry={3.1}
      transform="scale(-1 1)"
    />
    <circle
      cx={-330.8}
      cy={141.4}
      r={1.9}
      fill="#d4af3a"
      transform="scale(-1 1)"
    />
    <path
      fill="#d4af3a"
      d="M337.5 131.4c-.8.3-1.9.2-1.9.2s-.3-1.4.5-2.1l2-1.7.5-.6v2c.1.8-.3 1.9-1.1 2.2z"
    />
    <circle
      cx={-335.8}
      cy={133}
      r={0.6}
      fill="#d4af3a"
      transform="scale(-1 1)"
    />
    <path
      fill="#d4af3a"
      d="m340.2 132.4.8.9s-.7 0-1.2.4c-.6.4-1.2.7-1.9.6a.9.9 0 0 1-.8-1c.2-.5.5-1 1.5-1.3 1-.4 1.3 0 1.6.4zm-2.2 3.7c2 .2 4.6-2 4.6-2 .3 1.8 1.4 2.7 3 3v.1s-1.7.8-3.5 1.1a7 7 0 0 1-2.5-.2 10.6 10.6 0 0 1-3-1c-1.2-.7-.9-2.6-.9-2.6s.2 1.5 2.2 1.6zm7.8-2c.8-.3 2-.9 2.6-1 .5 0 1.3 0 1.1.9 0 1-1 1.4-2 1.4s-1.5-.3-2-.6c-.6-.3-.5-.4.3-.7zm6.3-3.4c1-.7 1.7-.9 1.7-.9s.6 1.6.3 2.6-1 1.2-1.9 1.2c-.8 0-2.1-.5-1.8-1.2.4-.6.8-1 1.7-1.7z"
    />
    <ellipse
      cx={-351.3}
      cy={135.1}
      fill="#d4af3a"
      rx={0.7}
      ry={0.5}
      transform="scale(-1 1)"
    />
    <path
      fill="#d4af3a"
      d="M349.4 127.3c.5-2.7.4-5.6-2-9.3a16 16 0 0 0-7-5.1L339 111c-1.4-1.5-4.3-3.4-4.3-3.4l5.2 1.5a2.3 2.3 0 0 0 2.3 2.4c.4 0 .9-.2 1.3-.4 1 .1 4.4 2.2 5.2 2.9a2.3 2.3 0 0 0-.3 1.2 2.3 2.3 0 0 0 2.3 2.3c.3 0 .7 0 1-.2l.3.5a23.4 23.4 0 0 1 1.6 3.7c-.6.4-1 1.1-1 2 0 1.3 1 2.3 2 2.3v1.5c0 .7-.4 1.2-1.7 1.6-1.3.3-3 2.6-3 2.6-.2 0-1.1-1.6-.4-4.3z"
    />
    <path
      fill="#d4af3a"
      d="M341.3 110.3c-.4-.4-.5-1-.1-1.4.3-.3 1-.3 1.5.1s.6 1 .2 1.4c-.4.3-1 .3-1.6-.1zm8.5 5.7c-.5-.5-.6-1.3-.2-1.7.4-.4 1.2-.4 1.7.1.6.5.7 1.3.2 1.7-.4.4-1.2.4-1.7-.1z"
    />
    <circle
      cx={-354.8}
      cy={123.2}
      r={1.3}
      fill="#d4af3a"
      transform="scale(-1 1)"
    />
    <path
      fill="#d4af3a"
      d="M326.6 105c.7.2 2 .6 3.8 1.6-1.3 0-2.3.8-2.3 1.9 0 1 1.2 2.2 2.5 2.2s2.2-1.1 2.2-2.2c0-.2 0-.5-.2-.7l1.8 1.2c4.2 2.8 5.1 4.1 7.2 8 2 3.8 2.8 8 1.9 10.4-.9 2.5-4.2 3-4.2 3s.4-.3.4-.8l-.2-1.6c-.2-1 0-2.1 0-2.1s-.8-.1-1.2.4l-1.5 1.7-1.5 1.5s-.7-1-.7-2.1.8-2.3 1-4.3c0-2-1-5.5-2.9-8a22 22 0 0 0-6.6-5.5 2.1 2.1 0 0 1-1.3-1.7l-.2-2c-.1-1.2 1-1.1 2-.9z"
    />
    <path
      fill="#d4af3a"
      d="M330.8 109.5c-.8 0-1.4-.7-1.4-1.3 0-.6.5-1 1.3-1 .7 0 1.3.4 1.3 1s-.5 1.3-1.2 1.3zm-6.2 24.4c-1 .4-2.2.1-2.7-.2-.5-.4-.7-1.3 0-1.8a2 2 0 0 1 2-.2l2 1.3s-.3.5-1.3.9z"
    />
    <path
      fill="#d4af3a"
      d="M321.4 135c.3.6.6.9 1.7 1 1.1 0 2.3 0 3-.8a7.7 7.7 0 0 0 1.3-1.7h1.3s.4 1.7 1 2.1c.5.5 2.4.6 3.3 0 .8-.7 1.6-1.4 1.7-1.3.2 0 0 .7-.8 1.4s-1.5 1.3-3 1.3H323s-1.6 0-2-1c-.5-.9-.6-1.5-.3-1.7.2-.3.3.1.7.7z"
    />
    <path
      fill="#d4af3a"
      d="M333.5 133.7c-1.2.6-1.9.2-2.3-.3l-.5-.8 1.7-.7c.5-.4.9-.7 1.5-.6l.6.1s.2 1.6-1 2.2z"
    />
    <ellipse
      cx={-339.3}
      cy={121.9}
      fill="#b96b29"
      rx={2.7}
      ry={2.6}
      transform="scale(-1 1)"
    />
    <path
      fill="#b96b29"
      d="M334.7 112.7c1-.7 2.6-.4 3.5.6.8 1.1.7 2.6-.4 3.3-1 .7-2.6.4-3.5-.6-.9-1.1-.7-2.6.4-3.3z"
    />
    <ellipse
      cx={-339.4}
      cy={121.5}
      fill="#d4af3a"
      rx={1.6}
      ry={1.5}
      transform="scale(-1 1)"
    />
    <path
      fill="#d4af3a"
      d="M335.8 113c.7-.2 1.5.2 1.9.8.3.6 0 1.2-1 1.4-1.7.3-2.5-1.8-1-2.2z"
    />
  </svg>
)

export default MeFlag
