// This file is generated by @lib/ui/country/codegen/generateFlags.ts
import { SvgIconProps } from '@lib/ui/icons/SvgIconProps'

const KyFlag = (props: SvgIconProps) => (
  <svg
    width="1em"
    height="0.75em"
    xmlns="http://www.w3.org/2000/svg"
    xmlnsXlink="http://www.w3.org/1999/xlink"
    id="flag-icons-ky"
    viewBox="0 0 640 480"
    {...props}
  >
    <path fill="#006" d="M0 0h640v480H0z" />
    <path fill="#012169" d="M0 0h320v240H0z" />
    <path
      fill="#fff"
      d="m37.5 0 122 90.5L281 0h39v31l-120 89.5 120 89V240h-40l-120-89.5L40.5 240H0v-30l119.5-89L0 32V0z"
    />
    <path
      fill="#c8102e"
      d="M212 140.5 320 220v20l-135.5-99.5zm-92 10 3 17.5-96 72H0zM320 0v1.5l-124.5 94 1-22L295 0zM0 0l119.5 88h-30L0 21z"
    />
    <path fill="#fff" d="M120.5 0v240h80V0zM0 80v80h320V80z" />
    <path fill="#c8102e" d="M0 96.5v48h320v-48zM136.5 0v240h48V0z" />
    <g
      stroke="#fff"
      strokeLinejoin="round"
      strokeWidth={9.6}
      transform="translate(-306.8 -21.2) scale(.87136)"
    >
      <use xlinkHref="#ky-a" />
      <use xlinkHref="#ky-b" />
      <use xlinkHref="#ky-c" />
      <use xlinkHref="#ky-d" />
      <use xlinkHref="#ky-e" />
      <use xlinkHref="#ky-f" />
      <use xlinkHref="#ky-g" />
    </g>
    <g
      stroke="#000"
      strokeWidth={1.4}
      transform="translate(-306.8 -21.2) scale(.87136)"
    >
      <g id="ky-b" fill="#fcea83">
        <path d="M754.4 449.6c2.9 7.6 23.5 17.7 47.5 4.8 16.3-9.2 26.8-22 36.9-45 2.8-5.8 4.3-13-2.4-17.3-5.3-3.9-14-8.2-17.8-12-1.9-2-3.8-3.4-5.2-4.8 1 1 1.9 1.9 2.8 3.3 9.6 11.5-.4 28.3-11 38.4-7.7 7.2-21.5 24.9-41.7 8.1-4.3-3.8-14.4 12-9 24.5zm291.4 0c-3.4 7.6-24 17.7-47.5 4.8-16.2-9.2-26.8-22-37.3-45-2.4-5.8-3.9-13 2.8-17.3 5.3-3.9 14-8.2 17.8-12 1.9-2 3.3-3.4 5.2-4.8-1 1-1.9 1.9-2.8 3.3-9.6 11.5.4 28.3 10.5 38.4 7.7 7.2 22 24.9 42.2 8.1 4.3-3.8 13.9 12 9 24.5z" />
        <path d="M900.1 490.8c38.3 0 97.3-17.3 129-77.7 5.2-10 0-15.3-6.3-18.6a73 73 0 0 1-19.2-14c7.7 7.7 6.2 13 1 21.6-24.5 40.8-58 61.4-104.5 61.4s-80-20.6-104.5-61.4c-5.2-8.6-6.7-13.9.5-21.5a66 66 0 0 1-19.2 13.9c-6.2 3.3-11.5 8.6-6.2 18.6 31.6 60.4 91 77.7 129.4 77.7z" />
      </g>
      <path
        id="ky-c"
        fill="#c8102e"
        d="M811.4 409.8c-1-4.8-7.1-2.9-9 2.9a68.4 68.4 0 0 1-6.8-10.6c-5.7-8.6-6.7-14.4 1.5-22.5 3.8-3.8 11.5-8.2 16.7-3.4 11 9.1 5.3 24-2.4 33.6zm176.9 0c1-4.8 7.7-2.9 9.6 2.9 2.4-3.4 4.8-6.7 6.7-10.6 5.7-8.6 6.7-14.4-2-22.5-3.3-3.8-11-8.2-16.7-3.4-10.6 9.1-5.3 24 2.4 33.6zm-233.9 39.8c-4.8-7.2-8.6-26-9.6-30.7-1.4-4.3-1.9-8.2 3.4-10 5.3-2 10 4.7 12.4 10.5 2.4 5.7 6.3 14.3 10.6 24.9-10.6-6.2-19.2-2-16.8 5.3zm291.4 0c4.3-7.2 8.1-26 9.6-30.7 1-4.3 1.9-8.2-3.4-10-5.3-2-10 4.7-12.4 10.5-2.4 5.7-6.3 14.3-10.6 24.9 10.6-6.2 18.7-2 16.8 5.3z"
      />
      <g fill="#00493d" stroke="none">
        <path d="m782.2 406.4-3.8 2c-1 .4-1 1.4-1 1.9h-.5L775 406h.5c0 .4.5 1 1.4.4l8.2-4.3c1-.5 1-1 .5-1.4l.4-.5 2.4 4.8h-.4c-.5-.5-1-1-2-.5l-3.3 2 1.4 2.8 3.9-1.4c1-.5.4-1.5.4-2h.5l2 4.4c-.5-.5-1-1-2-.5l-8.1 4.3c-1 .5-1 1-.5 1.4l-.5.5-2.4-4.3.5-.5c.5.5 1 1 2 .5l3.8-2zm8.2 6.3c1-.5 1-1 .4-2h.5l4.8 7.2-3.3 2.4v-.4c1.9-1.5 1.9-3.4 1.4-3.9s-1-1-1-1.4c-.4 0-.4-.5-1.4.5l-3.4 2.4c.5.4 1 1.9 3.4.4h.5l-5.3 3.9v-.5c2.4-2 1.4-3.4 1-3.8l-3.4 2.4c-1 .4-1 1-1 1.4.5 0 .5.5 1 1 .5 1 2 1.9 4.3 1l.5.4-3.8 1.4-4.8-7.6h.5c.4.4 1 1 1.9.4zm7.6 18.2-3.3 2.8c-.5.5-.5 1.5 0 2h-.5l-3.4-3.4.5-.5c.5.5 1 1 2 0l6.2-6.2c1-.5 1-1 .4-2l3.4 4c-.5-.6-1.4-.6-2 0l-2.8 2.8 2.4 2.4 2.9-2.4c1-1 .5-1.4 0-2l.5-.4 3.3 3.8h-.5c-.4 0-1-.4-1.9.5l-6.2 5.8c-1 1-1 1.4-.5 1.9v.5l-3.3-3.9c.4 0 1.4.5 1.9 0l3.3-3.3zm7.2 10.1 1.5 1.4 1.9-4.3s-1.5.4-3.9 1.9l.5 1-.5.4-1-1c-.4.5-.9.5-1.4 1-1.4 1-1 1.5-.4 2v.4l-2.4-2.4h.4l2-.5 9.5-5.2.5.4s-.5.5-4.8 10.1c0 1-.4 1.4 0 2.4l-3.8-3.3.5-.5c.5 1 1.4 1 1.9 0 0-.5.5-1.5.5-2l-1.5-1.4.5-.5zm3.8 9.5.5-.5c.5.5 1 .5 2 0l6.2-8.1-.5-.5c-1-.5-2.4-.5-3.8 1v-.5l1.9-2.4 7.2 5.3-2.4 2.8h-.5c1.4-1.4 1-3.3 0-3.8v-.5l-6.2 8.2c-1 .5-.5 1.4 0 1.9h-.5z" />
        <path d="m821.5 452.4-2.4 3.4c-.5 1 0 1.4.5 2l-.5.4-3.8-2.9v-.5c1 .5 1.4.5 1.9-.4l5.3-7.2c.4-1 0-1.5-.5-2l.5-.4 3.8 2.8v.5c-1-.5-1.4-.5-2 .5L822 452l2.9 1.9 2.4-3.4c.4-1 0-1.4-.5-1.9l.5-.5 3.8 2.9v.5c-.5-.5-1.4-.5-2 .5l-4.7 7.6c-1 .5-.5 1 0 1.5v.4l-4.3-2.8h.5c.4 0 1 0 1.4-.5l2.4-3.8zm9.6 13.5.5-.5c.5.5 1.4.5 1.9-.5l3.8-8.1c.5-1 0-1.5-.5-2l8.2 3.9-2 3.8-.4-.5c1.4-1.9 0-3.8-.5-4.3-.5 0-1-.5-1.4-.5-.5 0-.5 0-1 1-.5.5-1.9 3.3-1.9 3.3.5.5 1.4 1.5 3.4-1h.4l-2.8 5.8-.5-.4c1.4-3-.5-3.4-1-3.4l-1.9 3.8c-.5 1 0 1.5.5 1.5v.5zm13.9 6.7c-1.4-1-1.4-3.9 0-6.7 1-3 2.9-5.3 4.8-4.4 1.4.5 1 3.4 0 6.3-1.5 3.3-3.4 5.2-4.8 4.8h-.5c3.4 1.4 5.8-.5 7.2-3.9 1.4-2.8 1-6.2-2-7.6-2.8-1.5-5.7.4-7.1 3.8-1.4 3.4-1 6.7 2 7.7zm14.8.9 2-5.7c.4-1 0-1.5-.5-2l2.4.5v.5c-.5 0-1 0-1.5 1l-1.9 5.7c-1 2.4-2.4 4.3-5.2 3.4-2-.5-3.4-2.9-2.4-5.3l2.4-6.2c.4-1 0-1.5-.5-2v-.4l4.3 1.9v.5c-.5-.5-1.4-.5-1.4.5L855 472c-.5 1.9-.5 3.8 1 4.3 1.4.5 2.8-.5 3.7-2.9zm4.4-6.2c0-.5 0-.5-.5-.5l3.3.5 3 9.1 1.4-5.8c.4-1 0-1.4-.5-1.9l2.8.5-.4.5c-.5 0-1 0-1.5 1l-2.4 10.5h-.4l-3.9-11.5-2.4 7.7c0 1.4.5 1.4 1 1.9v.5l-2.9-1v-.5c.5.5 1.4 0 1.4-1l2.4-8.6zm16.3 9.6c-1 4.3-3 5.3-3.9 5.3h-1s-.4-.5 0-1l1.5-9.6c.5-.5.5-1 1-.5h1c.9 0 1.8 2 1.4 5.8l1.4.5c1-4.8-1-6.8-3.4-7.2-1.9-.5-4.8-1-4.8-1v.5c.5.5 1.5.5 1 2l-1.4 8.5c-.5 1-1 1.5-1.5 1.5h-.4l4.7 1c2.4.4 4.8 0 5.8-5.3zm4.3-3.9c0-1-1-1.4-1.5-1.4v-.5l8.7 1-.5 3.8c0-2.4-1.5-3.3-2.4-3.3-.5-.5-1-.5-1.5-.5-.4 0-.4 0-.4 1.4l-.5 3.9c.5 0 1.9.4 2.9-2.4l-.5 6.2h-.5c0-2.9-1.4-2.9-2-2.9l-.4 4.3c0 1 0 1 .5 1l1 .5c1.4 0 2.8-.5 3.8-3.4h.5l-1 3.8-9.1-1c1 0 1.4-.4 2-1.3zm15.8 5.8c0 4.3-1.5 5.7-2.9 5.7-.5-.4-.5-.4-1-.4l-.4-.5.5-10c0-.6 0-.6.4-.6h1c1 0 2.4 1.5 2.4 5.8h1.9c0-4.8-2.4-6.2-4.8-6.2-2-.5-4.8-.5-4.8-.5v.5c.5 0 1.5.4 1.5 1.4l-.5 9.1c0 1-.5 1.4-1 1.4v.5h4.3c2.4 0 4.8-1 5.3-6.2h-2zm13.9 3.8c0 1 .5 1 1.4 1v.5l-5.3.4c.5-.4 1.5-1 1.5-1.9l-1-9c-.5-1-1-1-1.9-1v-.5l5.3-.5c-.5.5-1.5 1-1 2zm4.8 1v-.5c.5 0 1-.5 1-1.4l-2-10h-.5c-1 .4-1.9 1.3-1.4 3.3h-.5l-.5-3.4 8.7-1.4.4 3.3h-.4c0-1.9-1.5-2.4-3-2.4h-.4l2 10c0 1 .4 1.5 1.4 1.5v.5zm20.6-9.6-2-5.7c0-1-.9-1-1.4-1v-.5l2.4-1v.5c-.5.5-.5.5-.5 1.5l2 6.2c.4 2 .4 4.8-2.4 5.8-2 .4-4.3-.5-4.8-3.4l-2-6.2c-.4-1-.9-1-1.4-1l-.5-.5 4.8-1.4v.5c-.4.5-1 1-.4 1.9l1.4 6.2c.5 2 2 2.9 3.3 2.9 1.5-.5 2-2.4 1.5-4.8zm5.3-3.4c2.3-1 1.9-2.3 1.4-3.8-.5-1.4-1.4-2.4-2.4-1.9-.5 0-1 .5-.5 1l1.5 4.7.4.5 1 3.9c.5 1 1.4 1 2 .4v.5l-4.4 2-.5-.5c1-.5 1-1 1-2l-3.4-8.1c-.5-1.4-1-1-1.9-1v-.4l4.8-2c2-.4 3.8 0 4.8 2 .5 2.4-.5 3.8-2.4 4.8-.5 0-1 .4-1 .4z" />
        <path d="M957.1 472c-1.4.6-3.3-1.4-4.8-4.7-1.4-2.9-1.4-5.8 0-6.2 1.5-.5 3.4 1.4 4.8 4.3 1.5 2.9 1.5 5.7 0 6.7 3-1 3.9-4.3 2.4-7.7-1.4-2.9-4.3-4.8-7.2-3.8a5.6 5.6 0 0 0-2.4 7.7c1.5 3.3 4.4 5.2 7.2 3.8zm.5-13.3h-.9l2.8-2 8.7 4.8-3-5.2c-.4-1-1.4-1-1.8-1v-.5l2.4-1c-.5.6-1 1 0 2l4.8 9.6-.5.5-10.6-5.8 3.9 7.2c.4 1 1.4 1 1.9.5v.5l-2.4 1.4v-.5c.5-.5.5-1 0-1.9l-3.8-7.7-1.5-1zm21.6 1.4v-.5c0-.5.5-1 0-1.9l-5.8-8.1h-.5c-1 .4-1.4 2.4 0 3.8l-.4.5-2-3.4 7.2-4.8 2 3c-1.5-1.5-3-1.5-3.9-1l-.5.4 5.8 8.2c.5 1 1.4 1 2 .5v.4z" />
        <path d="m984.5 448.6 2.8 3.4c.5.4 1.5.4 2 0v.4l-3.9 3.4v-.5c.5-.5.5-1 0-1.9l-5.7-7.2c-.5-1-1-.5-2-.5l3.9-3.3v.5c0 .4-.5 1 0 1.9l2.4 2.8 2.8-1.9-2.3-3.3c-.5-1-1.5-.5-2-.5l3.9-3.4v.5c-.5.5-.5 1 0 2l5.7 7.1c.5.5 1 .5 1.5 0l.4.5-3.8 3.4-.5-.5c.5-.5 1-1 .5-2l-2.9-3.3zm4.3-10.1c-.5-.4-1.5-.4-2 0v-.4l6.3-5.8 2.9 2.9h-.5c-1.5-2-3.4-1-4.3-.5 0 .5-.5.5-1 1 0 0 0 .4.5 1.4l2.9 2.9c.4-.5 1.9-1.5 0-3.9h.4l3.9 4.4v.4c-2.4-2.4-3.4-1-3.9-.4l3 2.8c.4 1 .9 1 .9 1l1.4-1.4c.5-.5 1-2 0-4.8h.5l1.9 3.3-6.2 6.2-.5-.4c.5-.5 1-1 0-2zm11.5-13.4c-.5.5-.5 1.5.4 2 1 .9 2 .9 3.9 0 1-.5 2.8-1 4.3.4 2.4 2.4 1.4 4.3 1 5.3-.5.5-1.5 1-2 1.4-.5 0-.5 0-.5.5v.5l-3.3-2.9h.5c1.9 1 3.8 1.4 4.8 0 1-1 0-2-.5-2.4-1-1-2-1-3.4 0-1.4.5-3.3.5-4.8-.5-1.9-1.9-1.9-3.3-1-4.8l2-1.4c.5 0 .5 0 0-1l3.4 2.4h-.5c-2.4-1-3.9-.4-4.3.5zm4.3-3.8c-1-.5-1.5 0-2 .5h-.4l5.3-7.7 3.3 2.4-.5.5a3.3 3.3 0 0 0-4.3 0c0 .5-.5 1-.5 1.4-.4 0-.4.5.5 1 .5.5 3.4 2.4 3.4 2.4.5-.5 1.4-1.5-.5-3.4v-.5l4.8 3.9c-2.9-1.5-3.4 0-3.8.4l3.3 2.4c1 .5 1.4.5 1.4.5 0-.5.5-1 1-1.4.5-1 1-2.4-1-4.3l.5-.5 2.4 2.9-4.8 7.2h-.5c.5-1 .5-1.5-.4-2.4zm12.9-8.6-1.4 2.4c-2-2-2.9-3.4-2.9-3.4l4.3 1h1c.5 0 1.4.4 1.9.4 1.4.5 1 1 .5 2h.5l2.4-4.4c-1 1-1.5.5-2.4.5-10.1-1.9-11-2.4-11-2.4v.5l7.6 8.6c.5.5.5 1.5.5 2h.5l1.4-2.4-.5-.5c-.5 1-1 1.4-1.9 0l-1-1 1.5-3.3zm-2.9-10.6c-.4.5-.4 1.5 1 2 1.4.4 2 0 3.4-1s2.8-2 4.7-1c3 1.5 2.4 3.9 2 4.8l-1.5 2v.9l-3.8-2c2.4.5 4.3 0 4.8-1.4.5-1-.5-1.9-1-2.4-1-.4-1.9 0-3.3 1-1.5 1.4-3 2-4.8 1-2-1-2.9-2.4-2-3.9 0-1 1-1.4 1.5-1.9 0-.5 0-.5-.5-1v-.4l3.9 1.9h-.5c-2.4-.5-3.9.5-3.9 1.4z" />
      </g>
    </g>
    <g
      stroke="#000"
      strokeWidth={1.4}
      transform="translate(-306.8 -21.2) scale(.87136)"
    >
      <g id="ky-d" fill="#073163">
        <path
          fill="#fff"
          d="M863.2 232.5c-6.2 1.4-10.5 1.9-16.3-3.4-3.8-3.8-2.9-10.5 1-13 4.3-2.8 8.1-4.7 13.4-3.3 5.3 1.5 19.2 14.4 15.8 14.9-3.4 0-8.6 3.3-13.9 4.8zm14.8-23c2-1.5 4.4-2.4 10.6-3 5.8-.4 10-.4 11.5 4 2 5.2 3.4 11.4 7.2 14.3-2.4 1.4-14.4 2.9-18.7.5-5.7-2.9-7.2-14-10.5-15.8zm41.3.5c1.9-1.5 4.3-1.5 10.5-1s8.6 1 10 5.3c1.5 4.8 0 11 3 15.3-3 1-12.5 1-15.9-2.4-5.2-3.8-4.8-14.9-7.6-17.3z"
        />
        <path d="M948 212.8c-4.3-1-7.2-1.4-9 0 2.3 2.9.4 14.4 5.2 18.2 3.3 2.4 12 3 13.9-2.4 2.4-4.8 2.4-12-10-15.8zm-49.3-4.8c1.4-1.4 4.3-1.9 10-1.9 6.3 0 10 1 12 4.8 2 4.8 1.4 11 4.8 14.9-1.4 1.9-14.4 1.9-18.2-1-5.3-3.4-5.8-14.4-8.6-16.8zm-40.7 4.3c0-2.4 3.3-2.8 12-3.3 8.5-1 9-.5 11.9 5.7 1.4 3.4 3.3 9.1 7.2 11-10.6 2.5-14 3.9-19.7.5a29.2 29.2 0 0 1-10-10.5c-.5-1.4-.5-2.9-1.5-3.4z" />
      </g>
      <g fill="#f9d050" strokeWidth={0.6}>
        <g id="ky-f">
          <path d="M881 163.5c-10.1-7.7-22.1-14.9-33.1-16.3a280 280 0 0 1 32.6 25.4" />
          <path d="M886.7 156.3c-12-8.2-25.9-17.3-39.3-18.2a124 124 0 0 1 33 27.8m21.6-23a93 93 0 0 1 23.5-32.2c-4.8 10.1-10 30.7-12.5 38.9" />
          <path d="M912.6 140.5A48.4 48.4 0 0 1 937 115a101.2 101.2 0 0 0-18.2 35" />
          <path d="M916.9 150a84.5 84.5 0 0 1 37.8-31.6c-12 12-29.7 34-34 42.7m2.9-.5c8.6-4.8 25.9-12.5 38.3-10-7.6 2.8-30.6 13.3-40.7 23" />
          <path d="M921.7 157.2c8.1-8.6 23-21.5 38.8-26.8-11.5 11-36 36-39.3 39.8M898.7 152c-5.8-17.8-14.4-34.5-27.3-39.8a130.9 130.9 0 0 1 21 48.9m-4.8-9.6c-9.5-11.5-22.5-23-37.3-25.4a90.1 90.1 0 0 1 33 38.8" />
          <path d="M893 151c-12-21.6-21.2-25.4-26.4-29.7 4.3 8.1 14.8 29.7 21 38.8" />
          <path fill="none" d="M869 149.6a57.7 57.7 0 0 1 17.2 16.7" />
          <path d="M869 159.6c2.8 2.4 8.1 5.3 12.9 9.6m44.1-2.4c4.8-3.8 15.3-10 20.6-12m-24 8.7c4.8-6.3 14.4-14.9 17.8-17.8m-4.4-12a286.9 286.9 0 0 0-18.2 22.6m5.8-26.9a157 157 0 0 0-12 21.1m-25.9-20.1c2.9 7.7 8.2 20.6 10 25.9m-14.3-17.8c2 3 5.8 9.6 7.2 14.4" />
        </g>
        <g id="ky-g">
          <path d="M897.7 136.1c0-4.3 2.9-9 5.8-9 3.3 0 5.7 5.7 5.7 9 0 3.9-2.9 7.2-5.7 7.2-3 0-5.8-2.8-5.8-7.2z" />
          <path d="M891.5 140c.5-4.8 3.8-8.6 6.7-8.2 2.9.5 4.3 6.3 3.8 9.6-.5 3.8-3.8 6.7-6.2 6.2-2.4 0-4.8-3.3-4.3-7.6zm12.9 1.4c-1-4.3 1-9 3.9-9.6 2.8-.4 5.7 4.3 6.2 8.2 1 3.8-1.5 7.6-3.9 7.6-2.3.5-5.7-1.9-6.2-6.2z" />
          <path d="M897.2 145.2c0-4.7 2.9-9 5.8-9 3.3 0 5.7 5.2 5.7 9 0 3.9-2.8 7.2-5.7 7.2-2.9 0-5.8-2.8-5.8-7.2z" />
          <path d="M888.6 147.6c0-4.3 3.4-9 6.2-9 3 0 5.8 5.7 5.8 9 0 3.9-3.4 7.2-5.8 7.2-2.8 0-6.2-2.8-6.2-7.2zm17.7-1.9c0-4.3 3-9 5.8-9 3.3 0 5.7 5.7 5.7 9 0 3.9-2.8 7.2-5.7 7.2-2.9 0-5.8-2.9-5.8-7.2z" />
          <path d="M904.4 149.6c0-4.8 3.4-9.1 6.2-9.1 3 0 5.8 5.2 5.8 9 0 3.9-2.9 7.3-5.8 7.3-2.8 0-6.2-3-6.2-7.2z" />
          <path d="M896.8 153.9c0-4.8 2.8-9.1 5.7-9.1 3.4 0 5.8 5.7 5.8 9 0 4-3 7.3-5.8 7.3-2.9 0-5.8-3-5.8-7.2zm-12 0c0-4.8 2.4-9.1 4.8-9.1s4.3 5.7 4.3 9c0 4-2.4 7.3-4.3 7.3-2.4 0-4.8-3-4.8-7.2zm26.8-.9c0-4.4 2.4-8.7 4.8-8.7s4.8 5.3 4.8 8.6c0 4.3-2.9 7.2-4.8 7.2-2.4 0-4.8-2.9-4.8-7.2z" />
          <path d="M914.5 161c1-4.7 3.8-8.6 5.7-8 2 .4 2.4 6.1 1.5 9.5-.5 4.3-3.4 6.7-5.3 6.2-2-.4-2.9-3.8-2-7.6z" />
          <path d="M905.4 159.6c.5-4.3 3.3-8.6 5.7-8.1 2.9 0 4.3 5.7 3.9 9-.5 4.4-3 7.3-5.3 6.8-2.4 0-4.8-3.4-4.3-7.7zM892 161c-1.5-4.7-4.4-8-6.3-7.6-1.9.5-2.4 6.2-1.4 9.6 1 3.8 3.8 6.2 5.7 5.7 1.5-.4 3-3.8 2-7.6z" />
          <path d="M888.6 160.1c0-4.3 2.4-8.6 4.8-8.6 2.9 0 4.8 5.3 4.8 8.6 0 4.3-2.4 7.2-4.8 7.2-2 0-4.8-2.9-4.8-7.2z" />
          <path d="M895.8 162c0-4.8 2.9-9 5.7-9 3.4 0 5.8 5.2 5.8 9 0 3.9-2.9 7.2-5.8 7.2-2.8 0-5.7-2.9-5.7-7.2zm2.4-52.7c-1 3.8-4.3 7.2-2 12.5-4.2-1.5-8-2-11.4 1.9 4.3-.5 8.1 1 10 3.8-3.8-.5-5.7 1.5-6.7 3.9 3.4-1 6.7-2 8.2-1.5-1.5 1.5-3.9 3.8-4.3 5.8 2.8-2.4 6.2-2 8.1-3.4-1.4 3.4 1.4 6.7 3.8 10-.4-4.7 2.4-8 1-10.5 4.3 1 4.8 4.8 11 4.8-2.4-1.4-3.8-6.2-6.7-6.2 1.4-.5 7.2-1 8.2 0-1-2-4.4-3.8-6.3-3.8 2-2 5.3-5.8 7.7-6.8-3.4.5-8.6 1-10.5 3.9 4.7-3.9 3.8-11 9-12-2.8-.5-7.1 1.4-10.5 4.8 1.5-2.9 1.5-6.7 3.4-7.7-3.9 1-8.2 5.8-9.6 8.2a18 18 0 0 0-2.4-7.7z" />
          <path d="M900.6 117c0 1.4 0 4.3-.5 5.2m6.7-5.7c-1 1-2.9 4.3-2.9 7.2" />
          <path fill="none" d="M909.7 122.2a7.6 7.6 0 0 0-3.4 4.4" />
        </g>
      </g>
      <g id="ky-e" fill="#059334">
        <path d="M858.9 169.7c-3.4 0-6.2-1.4-8.2-3.8-3.3-4.4-12.4-6.3-16.3-2.4-1.4 1-3.3 1-4.7 1.4-2.4 0-5.3 2.4-4.4 7.2 2-1.5 2.4 0 3.9 0 1-.5.5.5.5 1.4 0 2.4 5.2 7.2 10 6.7 5.3 0 7.7 2 8.6 3 1.5 1.3.5.9 1.5 3.3 1.4 1.4 1.9 1.9-.5 3.8a9.7 9.7 0 0 0 0 14.9c6.2 4.7 22 12 39.8-2 17.2-13.4 44-5.7 46-1 2.4 4.9 3.3 7.7 3.8 10.1.5 2 2.9 3.9 6.3 3.4 3.3 0 7.1 1.4 9 2.9 2.5 1.4 5.8 1 4.9-3.4-2-13.4-10.1-15.3-11-21.5 4.7.4 8 .4 10-1.5 1.4-1.9 3.3-5.3 5.3-6.2 1.4-1 1.4-2-.5-1.5-2.4.5-3.8 1.5-8.2 1-22-2.4-83.8-19.2-95.8-15.8z" />
        <path
          fill="#000"
          d="M956.7 186a34.8 34.8 0 0 0-9.2 9.6c-4.7 6.2-19.1 12.4-36.9 12.4-17.2 0-27.7-2.8-35.4-9a60.6 60.6 0 0 0-10.6-6.8c-5.2-2.4-6.2-7.7-4.8-12-1.4 2.4-2.3 4.8-5.2 4.3-2 0-5.8 0-4.8 2-.5-1-.5-2.4-1-3l-1-.9c1.5 1 4.9-1.9 7.3-1.9 1.9.5 4.3-1.9 3.8-4.8l-1.4-6.2c3.8-2 54.1 7.2 64.2 8.1 10 .5 38.8 4.8 35 8.2z"
        />
        <path d="M865.6 167.8c4.8-4.8 10.5-7.2 16.3-5.8h1.4c3-2.4 9.6-2.9 13.5-1h1.9c5.7-1.9 16.7 0 20.6 3.9l1.4 1c13-1 20.6 4.7 29.7 13.9 1 1 2.4 2.8 4.8 3.3 2.9.5 3.4 2 1 3.4a37.8 37.8 0 0 0-10 9c-4.4 5.8-18.3 11.6-35.6 11.6-16.7 0-26.8-3-34.5-8.7-4.3-3.3-7.6-5.2-10-6.7-2.9-1-6.7-4.8-5.3-8.6 1-3.8-1.4-8.6-3.3-13.4 1.4-1 5.2-2.4 7.1-1.4z" />
        <g fill="#00493d">
          <path d="M950.4 179.8c-9-9.2-16.7-14.9-29.7-14 0 .5 0 2-.5 3a66.3 66.3 0 0 1 23.5 17.7c2-2 5.3-4.3 6.7-6.7zm-31.1-14.9c-3.9-3.8-14.9-5.8-20.6-3.8 0 1.9 0 4.8-1 6.7 3.4 1.4 6.2 4.8 9.1 8.1 2-.5 6.7-1.9 9.1-2.4a44 44 0 0 0 3.4-8.6zm-22.5-3.9c-3.9-1.9-10.6-1.4-13.5 1-1 2-1.4 5.8-1.4 7.7 2 0 4.8 1.4 5.7 2.4 3-1 6.8-2.9 8.2-4.3.5-2 1.4-4.8 1-6.7zm-31.2 6.8c4.8-4.8 10.5-7.2 16.3-5.8-1 1.5-1.4 4.3-1.4 7.2-5.3-.5-12 1-14.9 2.9z" />
          <path d="M941.8 187.4a64.2 64.2 0 0 0-22-16.8c0 .5-1 2.4-1.5 3.9 2.9 4.3 8.6 13.9 11 19.2 2.4-1 9.1-3.9 12.5-6.3zM905.4 198a179 179 0 0 0 1.4-19.7c2.4-.5 7.2-1.9 9.1-2.4 2.4 3.9 8.2 14 10.6 18.7-5.8 1.4-15.4 3.8-21.1 3.4zm-16.8-23c2.4-1 5.8-3 8.1-4.8 2 1.4 5.8 4.8 7.2 6.7 0 4.3-1.4 16.8-1.9 21-3.8 0-10-.9-13.4-2.8.5-7.2 1-15.3 0-20.1zm-24 5.7c.5-1 1-4.3 1-5.7 3.8-2.4 13.4-4.8 20.6-1 .5 4.8 0 16.8-.5 19.7a96.4 96.4 0 0 0-21-13z" />
        </g>
        <g fill="none">
          <path
            fill="#000"
            stroke="none"
            d="M840.7 172c-1 0-1.5-2.8-3.4-2.8-.5 0-1.9.5-2.4 0 0 1 .5 2 1 2.4.5 1.4 2.9.5 4.8.5z"
          />
          <path d="M840.7 180.2c5.7 0 6.7-7.2 9.6-7.6m-6.3 8.1c4.3 2 7.7-8.1 11-7.7m-19.6-4.7c1.4 0 2.4-2 4.8.4 1 1 2.4 1.5 3.4 1.5m-1 5.2c-2 3-5.3 4.8-7.2 3.9m-1-15.8c-1.4 1-2.3 2.8-3.3 4.3m-1.4 2.8v2.4" />
        </g>
      </g>
    </g>
    <g strokeWidth={1.4} transform="translate(-306.8 -21.2) scale(.87136)">
      <path
        id="ky-a"
        fill="#fff"
        d="M989.7 233v93.4c0 81-38.3 108.8-89.6 130.8-51.3-22-90-49.8-90-130.8v-93.5h179.6z"
      />
      <path
        fill="#c8102e"
        d="M900.1 312c4.3 0 11-3.8 16.8-9.6 6.2-6.7 16.8-9 27.8 0 11 9.1 17.7 5.3 23.5 0 5.7-5.2 10.5-7.2 21.5-7.2V233H810v62.3c11 0 15.8 2 21.6 7.2 5.7 5.3 12.4 9.1 23.5 0 11.5-9 21.5-6.7 28.2 0 5.3 5.8 12 9.6 16.8 9.6z"
      />
      <path
        fill="#0b50a0"
        d="M900.1 360c5.8 0 17.3-6.3 20.1-7.7 10.6-6.3 18.2-.5 24.5 2.4 6.7 2.8 19.1 6.2 26.8 0 7.7-6.3 12-5.8 17.3-5.8 1-7.2 1-14.4 1-22.5v-5.8c-6.8-1.4-10.1.5-17.3 6.8-7.2 6.2-15.4 4.8-26 1-10-4.4-20-12-30.1 0a24.2 24.2 0 0 1-16.3 8c-7.2 0-13.4-4.7-16.3-8-10.5-12-20.1-4.4-30.2 0-10.5 3.8-19.2 5.2-26.3-1-6.7-6.3-10.1-8.2-17.3-6.8v5.8c0 8.1.5 15.3 1.4 22.5 5.3 0 9.2-.5 16.8 5.8 7.7 6.2 20.6 2.8 26.9 0 6.7-2.9 14.3-8.7 24.9-2.4 2.9 1.4 13.9 7.6 20.1 7.6zm0 20.6a51 51 0 0 0 23.5-7.2c9.6-5.3 16.3-3 25.9 1.9 10 4.8 18.2 3.3 24 0 2.8-2 5.2-5.8 11.4-4.3-2.8 12-7.2 22.5-12.4 31.1a32.5 32.5 0 0 1-25-1.9c-10-4.8-22.5-7.7-29.2-3.4a36 36 0 0 1-18.2 5.8c-5.3 0-12-2-18.2-5.8-6.7-4.3-19.2-1.4-29.2 3.4a32.5 32.5 0 0 1-25 2c-5.2-8.7-9.5-19.3-12.4-31.2 6.2-1.5 8.6 2.4 11.5 4.3a23.9 23.9 0 0 0 23.5 0c10-4.8 16.7-7.2 26.3-2a51 51 0 0 0 23.5 7.3zm0 76.6a191.9 191.9 0 0 0 51.3-29.7c-3.9-1.4-6.2-.5-9.6-2.9-3.4-2.4-13.4-3.3-22 1.5a39 39 0 0 1-39.3 0c-8.7-4.8-18.7-3.9-22-1.5-3.4 2.4-5.8 1.5-9.7 3a184.7 184.7 0 0 0 51.3 29.6z"
      />
      <g stroke="#000">
        <path
          fill="#f9d050"
          d="M887.6 256.4c.5 1-.4 3.4 0 4.3 1 2 1 3 2.4 3.9h3.4c10.5 0 23-4.3 33.5-4.3 10.1 0 16.3 3.3 22 3.3 3.4 0 6.3-2.4 6.3-4.8s-3.8-3.8-12-3.8c-11.5 0-17.7 2.9-27.3 2.9-14.4 0-16.8-5.3-16.8-7.7 0-2.4 2.4-5.7 10.1-5.7 2.4 0 4.3-.5 5.3-1.5.5-1 1.9-2.9 4.8-4.3 3.3-2 10 0 13.4-2.4 0 2-2.9 4.8-5.3 5.8 4.8-1.5 10-1.5 11 2.4-2.4-1.5-6.2-.5-7.6 0-2 .4-2.9 1-4.8 1.4 1.9-.5 2.9 3.3 5.7 3.3-2.8 2.4-7.6 2.4-12.4.5-1.5-.5-5.3-1.9-7.7-1.9-4.8 0-7.7 1-7.7 2.9 0 2.4 3 3.8 11.5 3.8 8.7 0 13.5-2.4 26.4-2.4-1-1.4.5-2.9-1.4-4.3 4.8 0 10 1.4 12 4.8-.5-3.4 2.3-6.2 1.4-9.1 2.9.5 5.3 3.3 5.7 5.7 0-1.4 2-1.4 2-2.8a7.4 7.4 0 0 1 3.8 7.6c1.4-2.4 2.9-1.4 3.8-4.3 1 2 .5 7.7-2.9 9.6 3-2 7.2-2 10.1 1.4-2.9-.4-4.3 1-5.7 1.5A44.4 44.4 0 0 1 948 267c-7.6-.5-8.6-2-13.4-2 2.9.5 8.6 6.3 14 6.3 3.3 0 5.7 0 7.1-.5 1.4-.5 3.8 0 5.7 1 1.5 1.4 4.4 2.8 6.3 2.4-.5 1.9-1.5 2.8-2.9 3.3 2.4 1.5 1 2.4 3.4 4.3-1 0-2 1-3.4.5 1.4 1.4 1.4 3.4 2.9 4.3-.5 0-2 .5-2.9 0 1.4 2 0 4.3 1.4 5.3 1.5 2-1.4 4.3-3.8 2.4.5 1.4-1 2.9-2.4 2.4s-2.4-2-2-2.4c0-.5 0-.5.6-1-1 1.5-2.9 1.5-3.9 1-.4-.5-1-1-1-1.4-3.3 1-4.7-2-4.2-3.4.4-1.4 3.3-2 4.3-1.4 1 .4 1.9 1 2.9 0 1-.5 1.4-1.5 1.4-2.4 0-1.5-1.4-5.8-7.7-5.3-7.2.5-18.7-1.4-24.4-3.4-.5-.4-1-.4-1.5-1 0 2-1.9 3-1.9 4.9 0 2.4 1 4.3 3.9 5.2-1.5 2.4-3.9 2-4.8.5 0 1.5-2 2.4-2 4.3-.4-1-1-1.4-1.4-2.4-1.4 3.4-5.3 5.3-7.2 4.4-2.4 1.9-5.2 1.4-6.2-.5-1.4 1-3.4 1-4.3 0 0 1.4-1 1-1.5 2.9 0 1-1.9 1.4-2.8 1-1-.6-1.5-2.5-.5-3.4-1.4 1-2.9 1-3.8 0 0-1 0-2.4 1-3h.9c-1-.4-2.4 0-3.4-.4-1-1-1-2-.5-2.9.5-.5 2-1.4 3-.5l.4.5c0-1 .5-1.9 1-1.9 1-.5 2.3-.5 3.8 1 1 1.4 1.9 1.4 4.8 1 2.4 0 6.2-2.5 9-4.9-8-1.4-3.3-6.7-.9-8.6-1.9-.5-4.8-.5-6.7.5-10 5.3-20.6 11.5-27.3 9.6a6 6 0 0 0 1 2.8c-1.5 0-4.4 0-5.3-1.4-.5 1-1.4 3.4-.5 5.3-1-1-3.8-2-5.3-2.4 1 1 0 2.9.5 4.3-1.4-1.4-3.8-2.4-4.8-1.4s-2.9 1.4-4.3 1a7.5 7.5 0 0 1-3.8 2.8c0-1 0-2.4-.5-2.9-.5 1.5-2 3.4-3.8 4.3 0-1 0-2.4-.5-3.3 0 1.9-3.8 2.9-4.3 4.3.5-1.4.5-2.9.5-3.8a7.3 7.3 0 0 1-4.8 3.3c.4-1 1-2 .4-2.9-.4 2-3.3 3-5.7 2.4 0 1-2 2.4-4.3 1-1.5-.5-2.4-2-1.5-2.9-1.9 0-3.8-1.9-2.8-3.3 0-.5.4-1 .4-1.5-1.4-1-1.9-2.9-.4-4.3.4-.5 1.9-.5 2.8-.5 0-3.8 3.4-3.8 4.8-1 1 1.5 3.9 3.9 6.3 3.4 1 0 1.4-.5 2.4-.5a43 43 0 0 0 12-6.2c.4-1.4.4-2.4.4-3.3-1.9 1-3.8 1.9-4.8 3.3v-1.4c-1.4 0-3.8-.5-4.8-.5.5-.5 1-2.9 2-3.4-2.4.5-4.8 0-6.8-.4 1-1 1-2.4 1.5-3.9-1 .5-3.4-.4-5.3 0 .5-1.4 1-3.3 2.4-3.8-2 .5-4.3 0-6.7-1 2 0 2.9-2.4 4.3-2.4-3.8 0-4.8-1.9-6.7-2.8 1.4.4 2.4-1 3.8-1-1.4-.5-3.8-2.9-2.8-4.3-.5.5-1 1.4-2 2-1 .4-2.8 0-4.3-1.5-1-2-.5-4.3 1.5-4.8a2.3 2.3 0 0 1-1.5-3.9c.5-1 2.4-2.3 3.4-1l1.4 2c-.5-1-.5-2.9-.5-4.3.5-1.4 1.5-1.4 3-2 1.3 0 2.3 1.5 2.3 3 0 1.4.5 2.3 1 4.3l.4-2c0-1.9 2.4-1.4 3.9-1 1.4.6 1.9 3.4 0 4.9-1 1-.5 2.4.5 3.3 3.3 5.3 9 9.6 13.9 10.1 0-2 1-3.8 2.4-5.3 0-1 .4-2.4 1-3.3.4-2.9 1.8-4.3 3.7-3.4-.4-.5-1-1-1-1.4-1.4-1.5-2.8-3.9-1.8-5.8 1-1.9 3.8-1.4 4.8-.4-.5-3 2.8-5.3 2.8-6.8.5 1.5 1.5 3.4 1 4.8.5-1.9 3.8-4.3 6.2-5.2-1 1.4 2 3.8 1.5 5.2 1-2.4 4.8-3.8 7.6-3.8-1 1-1 2.9-1 3.8 1.5 0 4-.4 4.9-1.9 0 2-1 3.9-2 4.8.5-.5 2.4-.5 3.9-.5-1.5 1.5-1 3-2.4 3.9 1.9-1 4.3-1 4.8 1 1 1.4-.5 3.8-1.5 5.2-1 .5-1.9 1.4-2.4 1.4z"
        />
        <g fill="none">
          <path d="M858 262.2c-3.4 1.4-4.4 4.8-4.9 6.7" />
          <path d="M857.5 265.5c-4.8 3-6.8 5.3-5.8 10.6m8.1 3.9c3-1 4.8-2 7.2-6.3" />
          <path d="M865.6 275.6c-1 2 0 5.3-1.4 6.7a8.8 8.8 0 0 0 4.8-6.7" />
          <path d="M866.6 280.9c1.9-1 4.8-3.9 6.2-7.2-.5 1.4 0 3.8-1 5.3 2.4-2.4 3.4-3.9 3.9-6.3l.4 2c1-1 2-2 2-3.9m-.1 1.4v2.4c2-1.4 2.5-3.3 2.5-5.7" />
          <path d="M880 271.8c2.9-2 3.3-4.8 3.3-9.1m0 4.8c2-1.5 2.4-2.4 2.4-6.8m-6.2-12.9c-1 0-2 .5-2 2 0 .9-1.4 2.3-1.4 3.8-.4 1.9-1.4 2.4-2.8 1.9-1.5-1-1.5-1-1.5-2.4 0-2 2.4-2.4 2.4-4.3.5-1 1-2.4 1.5-2.4-2.4 1.4-5.8.4-6.3-2.4" />
          <path d="M883.8 249.2c-1 .5-2-1-3.3-.4-.5 0-2 .4-2.4 0" />
          <path d="M877.1 251.6c.5.5 2.9 1.5 5.3.5-2 .5-3.4-1.9-1.5-3.3m-8.1-2c-2 0-3.4 1.5-2.9 3 .5 1.4 2.4 1.4 3.8.4m-4.3 20.6c.5-.5 1-1.4 1-2 1 0 2-.4 2.4-.9 1.9 0 3.3-1.4 3.8-2.8 1 0 1.5-2.4 2-3.4.4.5 1.4 0 1.9-2 1 .6 2.4 0 2.8-1.4m-19.6-3.3c0 .5-1 1.4-2 2 .5.9 0 3.3-.9 3.7.5 1 0 2.4-.5 3.4 0 .5.5 2 .5 2.4m4.8-21.1c-1 2.4-.5 5.3 1.4 5.8" />
          <path d="M866.6 253c-.5 2.5-.5 5.8-1 7.3-.5 1-1.4 4.3 2.4 5.2 4.3 1 6.7.5 9.1-6.7m7.2 18.7c0 .5-.5 1.5-1.4 1.5m4.7-2.4c0 1-1 2.4-1.4 2.8m4.8-3.8c0 1 0 2.4-1 2.9m-28.2-32.6c.4 0 1 1 1.4 1.9-1.4-1-2.9 1.4-2 2.9m-.9 3.3-1.9 1.5m.5 2.8c-.5 0-1 .5-1.4.5m-21.6-9.1c0-.5 0-.5.5-1m-4.8-.4c-.5 0-.5 0-1-.5m1.4 7.2h1m-2.9-2.9a5 5 0 0 0-2.8-1.4m29.2 19.2c-3.4 2.8-4.8 5.2-5.3 8.6m8.6-6.3a11 11 0 0 1-3.8 4.4m-14.8 10a11 11 0 0 1-9.6-1.4c-.5-.5-1-.5-1.5-1m25.4-4.2c-.4 1.8-1 4.2-1.9 4.7 3.9-2 7.2-4.8 7.7-9.1M827.7 289c1.5-.5 3 .5 3.9-.5m79.5-15.3c1 .5 2.4 1 2.9 1.4.5-1 2.4-2.4 3.8-2.8m-40.7 11.5c-.5-2 .5-4.3 3.4-5.3m-22.1 13.4c.5-1 .5-2.4 1-3.3m-22.1 4.8c-.5 1-1.4 1.9-1.4 2.8m-5.8-1.9s0-.5.5-.5c1-.4 2.4-1.4 2.9-2.4m61.8-3.8c-1 .5-1.4 0-1.9-.5m1.4 2.9s-.4.5-1 .5m3.4 1.9c-.5.5-1 1-1.4 1m15.3 0c1-.5 1.5-1.5 2-3.4m-8.2 2.9c1.4-.5 2.4-1.5 3.8-2.9m9.6-1c0-1 0-1.9.5-2.8m35 7.2c-1-1-1-2.4.5-3.4 1-.5 1.4-1 2.4-1.4" />
          <path d="M924.5 276c-7.6-3.3-7.1-7.6-13.4-7.1m47.5 22.1c.5.4 0 1.9 0 2.3m4.3-2.3c-.5 1.4-.5 1.9-.5 3.3M926 245.9h-4m-36.3 16.3c0 1 1.5 2.9 5.3 2.9-.5 0-1-.5-1-.5m-2.4-8.2c-.4.5-1 0-1 0-.9-1 .6-2.8 2-3.8-1.4.5-2.4.5-3.4.5-1 2.9-3.8 4.3-5.7 2.4-.5 1.9-2.9 4.3-4.8 3.8-2-1-2.4-2.4-2-3.8-2.3 2.8-5.2 1-6.1 0-.5-1 0-3.4 1-6.3" />
        </g>
        <path
          stroke="none"
          d="M918.3 274.6c-1.4 1-2.9 0-4.3 1.5-1 1 .5 1.4 1.4 1.4-.4 1.5-.4 2 2 2-1 1.4 1.9 1.9 1.4 3.8a4.6 4.6 0 0 0 1-4.8c-.5-1.5-3-2.4-1.5-3.9z"
        />
        <path
          fill="#073163"
          stroke="none"
          d="M874.7 259.3c-2-1-2.4-2.4-2-3.8-.4 1-1.3 1.4-2.3 1.4-2 4.3-4.3 8.2-7.2 8.2-3.4.4-2.9 3.8-.5 3.8 5.3 1 7.7-1 12-9.6zm-47.4-11.5c1.4-1.4.4-2.9-.5-3.3-1.5-.5-4.3 0-5.8 2.3 1.5-.4 3-.4 3.4.5.5 1 1.4 2 2.9.5zm2.4-8.6c3.3 0 4.3.5 4.7 1.9.5 1-.4 2.4-1.4 2.4-1.4 0-2.9-1-2.4-1.4.5-1 .5-2.4-1-3zm9.5 7.6c2.4.5 3.4-1 2-2.8-.5-1.5-2-2.4-4.4-2 2.4 1.5 0 3.9 2.4 4.8zm-17.7 8.2a4 4 0 0 0 4.8 2c1.4-.6 2-2 1.4-3-1-1.4-2.4-1.9-2.8 0-1 2-2.4 1.5-3.4 1zm7.2 29.2c-1-1.9-3.8-1.9-6.2 0 1-.5 2.8 0 3.3 1s1.5 1 2 1c.4-.5 1.4-1 .9-2zm3.8-2.8c0-2.4-3.3-3-5.2-2 1 0 2.4 1 2.4 2 .4 1 1.4 1.4 1.9 1.4 1-.5 1.4-1 1-1.4zm-4.8 8.6c-2.8-.5-4.3 2.9-4.3 5.2.5-1.4 2-2.3 3.4-1.9 1.4 0 1.9-.4 1.9-1.4.5-1 0-1.4-1-2zm.5 8.1c1 .5 2-.5 2.4-1.9 0-1 2-1 2.4-.5 1 .5 1 2.4-.5 3.4-1 .5-3.3 1-4.3-1zm66.6-14.4c-1-.4-3.3-1.4-5.2 0 1.4-.4 2.4.5 2.8 1.5 0 1 1.5 1.4 2 .5.4-.5 1-1.5.4-2zm-4.3 3.4c-1.9-1-4.3 1.4-4.8 3.4a7 7 0 0 1 3.4-1.5c1 .5 1.9 0 1.9-1 .5-.4.5-.9-.5-.9zm2.5 3.9c-1.5 0-3.4 1.9-3.4 3.8.4-1 1.4-1.5 2.4-1 1 0 2.4-.5 2.4-1.4 0-1-.5-1.5-1.5-1.5zm4.2 3.8c-1-.5-2.4 0-2.4 1.4s0 2.9-.4 3.4c1-1 1.9-1.5 2.8-2 .5-.4 1-1.9 0-2.8zm54.2-4.3c-1-1-2.4-.5-2.9.4-.5 1-1 3.4 0 5.3 0-1 1-2.4 2-2.4 1.4-.5 1.8-2.4.9-3.3zm2.9 1.9c-2 1-2 4.3-.5 6.2 0-1 .5-2.4 1.4-2.9 1.5 0 2-1.9 1.5-2.8-1-1-2-.5-2.4-.5zm5.7 1.9c-1-.5-2 .5-2 1.4-.4 1.5.6 3.4 2 4.3 0-1 .5-1.9 1-2.4 1.4-1 1-2.8-1-3.3zm4.3-.5c-1 0-1.9 1.4-1 2.9.5 1 1.5 1.4 3.4 1-.5 0-1.4-1.5-1-2 .5-1 0-1.9-1.4-1.9z"
        />
      </g>
      <g id="ky-h">
        <path fill="#f9d050" d="m831.1 383.4 24-73.8 24 73.8-62.9-45.5H894Z" />
        <path
          fill="#024919"
          d="m835.9 376.7 49.8-36.4h-61.3l49.3 36.4-18.6-58.4z"
        />
      </g>
      <use xlinkHref="#ky-h" x={90.1} />
      <use xlinkHref="#ky-h" x={45} y={52.2} />
      <path
        fill="none"
        stroke="#000"
        d="M989.7 233v93.4c0 81-38.3 108.8-89.6 130.8-51.3-22-90-49.8-90-130.8v-93.5h179.6z"
      />
    </g>
  </svg>
)

export default KyFlag
