// This file is generated by @lib/ui/country/codegen/generateFlags.ts
import { SvgIconProps } from '@lib/ui/icons/SvgIconProps'

const HrFlag = (props: SvgIconProps) => (
  <svg
    width="1em"
    height="0.75em"
    xmlns="http://www.w3.org/2000/svg"
    xmlnsXlink="http://www.w3.org/1999/xlink"
    id="flag-icons-hr"
    viewBox="0 0 640 480"
    {...props}
  >
    <path fill="#171796" d="M0 0h640v480H0z" />
    <path fill="#fff" d="M0 0h640v320H0z" />
    <path
      fill="red"
      d="M0 0h640v160H0zm320 364.1c51.3 0 93.3-42 93.3-93.3V160H226.7v110.8c0 51.4 42 93.4 93.3 93.4z"
    />
    <path
      fill="#fff"
      d="M320 362.6a91.8 91.8 0 0 0 91.6-91.5V161.8H228.5V271a91.8 91.8 0 0 0 91.5 91.5z"
    />
    <g fill="red">
      <path d="M267.1 165.2H232v38.7h35.2zm0 77.4h35.3v-38.7H267zM232 270.9c0 3.5.2 7 .6 10.4h34.6v-38.7H232v28.3zm105.7-28.3h-35.2v38.7h35.2zm0 77.4h35.2v-38.7h-35.2zm35.2 21.2A89.2 89.2 0 0 0 393 320h-20v21.2zM267.1 320h35.3v-38.7H267zm-20.1 0a89.2 89.2 0 0 0 20.1 21.2V320H247zm79.1 38.7c4-.3 7.7-.8 11.5-1.6V320h-35.2v37.1a87 87 0 0 0 11.4 1.6c4.1.3 8.2.2 12.3 0z" />
      <path d="M407.4 281.3c.4-3.4.6-6.9.6-10.4v-28.3h-35.2v38.7h34.6zm-69.8-38.7h35.2v-38.7h-35.2zm0-77.4h-35.2v38.7h35.2zm70.4 38.7v-38.7h-35.2v38.7z" />
    </g>
    <path
      fill="#fff"
      d="m410 158.8 21.8-49.5-16.6-26.8-27.6 10.2-19.4-22.2-25.4 14.7L320 66.5l-22.7 18.6-25.5-14.6-19.4 22.2-27.6-10.3-16.6 27 21.8 49.4a217.8 217.8 0 0 1 90-19.3c32 0 62.5 6.9 90 19.3z"
    />
    <path
      fill="#0093dd"
      d="m253 94.8-27.4-10-15.3 24.7 5.9 13.3 14.8 33.7a219.7 219.7 0 0 1 34.6-12L253 94.8z"
    />
    <path
      fill="#fff"
      stroke="#000"
      strokeWidth={0.3}
      d="M251.4 119.3a13.3 13.3 0 0 1 1.6 6.2c0 7.3-6 13.3-13.4 13.3a13.4 13.4 0 0 1-13.1-10.8 13.4 13.4 0 0 0 11.7 6.9 13.4 13.4 0 0 0 13.2-15.6z"
    />
    <path d="m227.6 114 1-4.9-3.8-3.2-.1-.1.2-.1 4.6-1.6 1-4.8v-.2l.2.1 3.7 3.2 4.6-1.6h.2v.2l-1 4.8 3.7 3.2.2.2h-.3l-4.6 1.6-1 4.8v.2l-.1-.1-3.7-3.2-4.6 1.6h-.3z" />
    <path
      fill="#f7db17"
      d="m233.6 107.6 3.5 3 4.3-1.5zm0-.2 7.8 1.6-3.4-3zm-8.3-1.6 7.8 1.5-3.5-3zm7.8 1.7-7.8-1.5 3.4 3zm.4-.3 5.2-6-4.3 1.5zm-5.6 6.4 5.2-6-4.3 1.5zm5.3-5.9-5.2 6 4.3-1.5zm5.6-6.4-5.2 6 4.3-1.5zm-5.6 6-2.6-7.6-.9 4.5zm2.7 8-2.5-7.5-.9 4.5zm-2.4-7.6 2.6 7.5.9-4.5zm-2.7-8 2.5 7.5 1-4.5z"
    />
    <path
      fill="#171796"
      d="M297.5 87.4 272.1 73 253 94.9l12.6 49.6a219.8 219.8 0 0 1 36.1-6l-4.2-51.1z"
    />
    <path
      fill="red"
      d="M262.5 132.2a232.3 232.3 0 0 1 38.2-6.4l-1-12.9a245.6 245.6 0 0 0-40.4 6.7l3.2 12.6zm-6.3-25a258 258 0 0 1 42.4-7l-1.1-12.7a270.7 270.7 0 0 0-44.5 7.4l3.2 12.3z"
    />
    <g transform="translate(-160) scale(.00237)">
      <path
        fill="#0093dd"
        d="m212105 36890-23 13-9517-7794-9497 7778 1788 21560c2543-210 5113-322 7709-322 2608 0 5190 113 7744 325l1795-21560z"
      />
      <g id="hr-a">
        <path d="M202545 46585c-18-2-44 10-69 45-186 250-359 469-545 720-195 61-242 180-167 348-261-26-291 193-302 432-250-379-522-482-814-307-11-230-187-338-439-392-180-10-319-65-436-145-60-42-110-64-170-106-126-88-226-5-172 74 267 434 535 868 802 1302-14 80 6 151 88 204 47 133 93 265 140 397-11 38-21 75-32 113-221-105-443-118-664-133-170-8-287-50-361-137-54-63-91-26-92 82-3 534 162 1014 599 1492-231 4-462 11-694 21-79 6-95 39-73 104 126 304 339 579 822 766-208 112-327 285-357 520-9 224-75 382-212 455-60 32-81 65-24 106 253 185 565 193 895 112-157 270-226 553-198 850 208 56 412 15 614-52-29 61-44 175-52 309-7 115-41 229-104 343-32 33-65 84 4 102 336 91 648 52 915-47 0 243 2 487 76 727 18 58 70 102 125 26 155-214 322-396 527-517 31 90 75 168 156 215 96 55 147 170 153 343 0 30-2 60 35 90 149 7 514-380 589-597 206 121 284 246 439 461 55 76 99 29 128-25 62-243 67-481 66-724 267 99 579 138 915 47 69-19 36-70 4-102-62-114-105-250-113-365-9-133-14-226-43-287 202 68 405 108 614 52 29-297-53-579-211-850 330 80 655 73 908-112 57-41 35-74-24-106-136-73-203-231-212-455-30-235-149-409-357-520 483-187 696-463 822-766 22-66 6-99-73-104-231-10-480-24-711-27 437-478 606-961 604-1495-1-108-38-146-92-82-74 87-179 137-348 146-222 15-435 24-656 128-11-38-21-75-32-113 46-132 106-260 153-393 82-53 102-123 88-204 267-434 513-868 781-1302 54-79-46-162-171-74-60 42-110 64-170 106-117 80-257 134-437 145-251 54-417 167-428 397-293-175-564-73-814 307-11-239-41-457-302-432 75-168 17-291-178-352-186-250-458-470-644-720-31-35-51-47-69-45z" />
        <g fill="#f7db17">
          <path d="M205075 47978c-51-26-124 17-162 95s-33 170 19 196c40 20 84-6 119-56l22-36c2-3 4-6 5-9 38-78 49-163-2-188zm-5008 0c52-26 124 17 162 95s39 165-13 191-103-24-141-102-60-158-9-184zm4539 905c-32 0-59 27-59 59s26 59 59 59 59-26 59-59c0-32-26-59-59-59zm-4032 0a59.1 59.1 0 1 0 .2 118.2 59.1 59.1 0 0 0-.2-118.2zm4294-304c-754-91-1506-133-2260-133s-1509 41-2269 115c-26 8-21 90 14 86 756-73 1507-113 2256-113 743 0 1485 40 2228 129 39 4 54-80 32-84z" />
          <path d="M200319 48495c768-75 1530-117 2289-116 754 0 1507 42 2261 133l111-184c-32 10-62 9-90-5-76-38-92-161-36-274 56-114 164-175 240-138 39 19 62 62 68 114l446-739c-204 130-328 214-581 252-281 41-409 139-368 307 38 156-57 133-201 54-314-171-541 71-652 353-73 186-159 181-168-13-4-70 0-131-7-200-21-223-89-286-216-224-161 78-175 25-137-58 28-60 86-128 66-221-9-67-66-92-151-98-182-244-467-483-649-727-182 244-374 483-556 727-86 5-142 30-152 98-20 93 52 157 80 217 38 82 23 135-137 57-127-61-186-3-207 220-7 69-10 139-13 209-9 194-95 199-168 13-111-282-352-524-667-353-145 79-203 102-182-54 23-172-107-266-388-307-253-37-377-122-581-252l419 682c12-25 29-45 53-57 76-38 184 24 240 138 56 113 40 237-36 274-10 5-21 8-32 10l100 163zm4389 911c-7 3-7 4-24 11-46 19-80 66-134 124-57 60-128 125-211 188-12 10-25 19-44-6s-7-35 6-44c80-62 149-124 204-182 30-32 56-63 77-92-95-11-190-21-284-30-79 24-157 55-222 95-59 35-107 77-137 125-8 14-16 27-44 11-27-16-19-30-11-44 35-58 91-107 158-147 33-20 69-38 106-54-107-9-214-18-321-25-22 13-42 29-61 47-20 19-39 42-56 67-9 13-18 26-44 8s-18-31-8-44c19-29 41-54 64-77l9-9c-80-5-161-10-241-14-2 2-5 5-8 7a340.4 340.4 0 0 0-93 126c-6 15-12 29-41 18-29-12-23-26-17-41 12-29 27-55 45-81 8-11 18-22 27-33-115-5-230-9-344-12-4 5-9 8-14 11-25 15-47 32-66 51s-35 40-48 63c-8 14-16 28-43 12-28-16-20-29-12-43 16-28 35-54 59-77 7-7 14-13 21-19-122-2-244-4-365-4-120 0-240 1-360 3 8 7 15 13 22 20 23 23 42 49 59 77 8 14 16 27-12 43s-35 2-44-12c-13-23-29-44-48-63s-41-36-66-51c-6-3-12-7-15-12-115 2-230 6-345 11 11 11 20 23 29 35 19 25 33 52 45 81 6 15 12 29-17 41s-35-3-41-18c-9-24-22-46-38-67-15-21-34-41-55-59-4-3-7-6-10-10-81 4-162 8-243 13 4 4 9 8 13 12 24 23 45 48 64 77 9 13 18 26-8 44s-35 5-44-8c-18-26-36-48-56-67s-41-35-64-49c-1-1-3-2-5-3-110 7-220 14-330 23 43 18 85 38 122 61 67 40 124 89 158 147 8 14 16 27-11 44-27 16-35 3-44-11-29-48-78-90-137-125-72-44-159-77-246-102h-2c-90 7-179 15-268 24 22 33 51 68 86 106 55 58 124 120 204 182 13 9 25 19 6 44s-32 15-44 6c-83-64-155-128-211-188-37-38-99-111-135-140-196-90-354-127-575-147-153-14-318-9-458-79 36 85 75 164 126 229 53 68 120 121 209 147 8 2 21 16 22 25 28 157 84 286 169 386 52 60 114 110 188 149-75-81-132-166-172-251-67-142-90-286-77-420 1-16 3-32 34-29 32 3 30 19 29 35-11 123 9 256 72 387 56 118 159 237 291 346 24 19 0 63-29 55-154-44-290-123-383-231-89-104-149-237-180-397-94-32-165-90-222-164-47-60-85-131-118-205 28 428 182 801 456 1137 61 75 165 182 255 216 92 35 95 100-20 101-34 1-69 1-105 1 84 31 164 66 233 105 127 73 217 162 224 273 1 16 2 32-29 34-32 2-33-14-34-29-6-86-82-160-192-223-113-65-259-117-402-160-154 0-312-1-459 3 39 28 80 57 131 84 82 44 188 86 343 122 89 21 166 52 233 91 71 42 130 93 177 150 10 12 20 25-5 45s-34 8-45-5c-42-52-95-98-159-135-61-36-133-64-216-84-161-38-272-81-358-128-75-40-131-82-184-123 180 393 450 573 835 689 23 7 43 13 61 19 3 1 6 1 9 2 86 21 175 40 266 55 92 15 166 28 261 37 16 1 32 3 29 34-3 32-19 30-34 29-99-9-174-22-266-38-58-10-115-21-171-33-26 6-64 9-107 12-232 14-420 225-435 494 0 5 0 11-1 16 88-80 179-157 273-212 117-68 239-103 364-69 15 4 31 8 22 39-8 31-23 27-39 22-106-28-212 3-316 63-108 63-213 158-315 253-24 147-82 285-205 377 61 34 104 65 163 45 86-39 172-78 261-108 91-31 184-52 282-57 16-1 32-1 33 31s-14 32-31 33c-91 4-179 24-264 53-75 26-149 58-222 91 221 47 460-1 667-79 60-22 105-42 133-41 51-30 112-53 172-79 66-28 132-51 182-57 16-2 32-4 35 28 4 32-12 33-28 35-112 13-127 21-222 79 0 21-66 57-126 96-36 24-70 52-87 67-95 86-144 181-188 287-29 70-52 145-68 224 55-108 121-211 201-303 94-108 208-201 345-265 14-7 29-13 42 15 13 29-1 35-15 42-129 60-236 147-324 250-90 103-161 222-219 345-31 64-8 1-42 86 110-122 212-224 323-307 132-100 283-157 418-133 15 3 31 6 26 37s-21 28-37 26c-116-21-250 32-369 121-121 92-244 223-366 361 184 26 366-26 542-85 91-30 183-135 239-152 19-24 38-46 57-67 33-37 67-71 102-100 12-10 24-20 45 4s8 34-4 45c-33 28-65 60-96 94-32 35-62 73-92 113-6 8-13 17-24 16-60 70-151 162-172 240-57 210-25 370-122 576 71-38 128-81 175-134 53-60 94-135 128-230 37-104 95-195 167-270 75-77 165-136 261-172 15-5 30-11 41 19s-4 35-19 41c-87 32-169 86-238 157-66 68-119 151-153 247-37 102-81 183-141 250-44 50-95 91-156 127 52-3 78-10 121-7 79-6 211-66 279-119 66-51 116-120 154-206 6-15 13-29 42-16s23 27 16 42c-42 96-99 174-173 231-56 43-121 75-196 93 161-5 311-42 467-100 65-24 87-168 127-208 32-58 66-112 105-158 47-56 101-101 164-127 15-6 29-12 41 18 12 29-3 35-17 41-52 21-98 60-139 108-36 42-68 93-98 147 10 73-51 228-53 305-7 205-2 409 53 612 53-71 107-134 162-192 0-5 0-10 1-15 18-106 33-219 40-332 7-112 7-223-6-329-2-16-4-32 27-35 32-4 34 12 35 28 14 111 14 226 7 340-6 90-16 180-30 269 54-51 53-51 77-103 37-80 59-159 67-237 9-80 5-157-13-230-4-15-7-31 24-38s35 8 38 24c19 80 25 165 14 252-8 65-24 132-49 199 56-42 114-82 178-122-4-75-5-153-3-227 2-68 7-134 18-190 4-20 7-40 47-33s37 27 33 48c-9 50-14 111-16 177-2 78 0 162 4 243 5 82 49 185 125 230 103 62 158 163 186 274 16-145 17-280 3-400-17-143-55-267-114-368-8-14-16-27 12-44 27-16 35-2 43 12 63 110 104 241 122 393 17 146 13 310-13 488 102-82 381-258 352-594-7-27-16-52-28-75-7-14-14-28 14-42s35 0 42 14c17 33 30 69 39 110 5 24 8 49 11 76 13-7 45-43 51-39 24 16 58 38 80 54-21-60-35-120-42-178-10-87-5-172 14-252 4-15 7-31 38-24s27 23 24 38c-18 73-22 151-13 230 9 77 31 157 67 237 4 8 8 16 5 25 24 21 47 42 70 65-13-84-22-170-28-255-8-115-7-230 7-341 2-16 4-32 35-28s29 20 27 35c-13 106-13 217-6 329 7 113 22 225 40 332 1 2 1 5 1 7 54 59 95 120 152 196 55-203 73-407 66-612-2-76-69-227-65-302-30-55-63-107-100-151-41-49-87-87-139-108-15-6-29-12-18-41 12-29 27-24 41-18 62 26 117 71 164 127 38 45 72 98 103 154 57 7 78 179 143 212 154 57 298 94 453 100-75-19-140-50-195-93-74-57-131-135-173-231-6-15-13-29 16-42s35 2 42 16c38 86 88 156 154 206 85 66 289 124 400 127-61-37-113-78-157-128-59-67-104-148-141-250-34-95-87-179-153-247a642 642 0 0 0-238-157c-15-6-29-11-19-41 11-29 26-24 41-19 96 36 186 94 261 172 72 74 130 166 167 270 34 95 75 169 128 230 47 54 105 98 177 135-98-207-66-367-122-577-35-129-232-277-193-320 45-51 133 88 248 127 175 59 357 111 540 85-122-138-244-269-366-361-119-90-237-140-352-120-16 3-31 6-37-26-5-31 10-34 26-37 135-24 269 32 401 132 111 84 201 175 311 298-18-47 0-14-30-77-59-123-130-241-220-345-89-102-196-189-324-250-14-7-28-13-15-42 13-28 28-22 42-15 137 65 251 157 345 265 81 93 147 198 203 307-15-81-39-157-68-227-44-106-93-201-188-287-62-56-209-140-208-179-29-15-33-11-63-24-61-26-121-46-164-52-16-2-32-4-28-35 4-32 19-30 35-28 50 6 115 28 182 56 33 14 66 43 98 60 53 4 139 47 208 74 206 78 446 126 666 79-73-33-147-65-223-91-85-29-172-49-264-53-16-1-32-1-31-33s17-31 33-31c98 4 191 26 282 57 89 30 175 69 261 108 59 27 101-7 163-45-123-92-181-230-205-376l-2-2c-102-95-207-190-315-253-104-60-210-91-316-63-15 4-31 8-39-22-8-31 7-35 22-39 125-33 247 1 364 69 94 55 186 132 274 213 0-6-1-11-1-17-15-270-203-480-435-494-78-5-189 21-186-32 4-59 97-44 234-86 385-116 655-296 836-690-54 41-110 83-186 124-86 47-198 91-358 128-82 19-154 48-216 84-64 38-117 84-159 135-10 12-20 25-45 5s-14-32-5-45c47-57 106-108 177-150 67-39 145-70 233-91 155-36 261-78 343-122 51-27 92-55 131-84-148-4-305-3-459-3-143 44-289 96-402 160-110 63-186 136-192 223-1 16-2 32-34 29-32-2-31-18-29-34 8-111 97-200 224-273 69-39 149-74 233-105-35 0-70 0-104-1-116-2-112-66-20-101 90-34 190-141 251-216 271-334 412-714 456-1130-33 72-69 140-115 198-57 73-128 131-222 164-31 160-91 293-180 397-92 108-216 185-369 230-29 8-52-35-29-55 132-109 221-226 278-344 62-131 83-264 72-387-1-16-3-32 29-35 31-3 33 13 34 29 12 134-10 278-78 420-40 85-97 170-172 251 73-39 136-89 187-149 85-100 141-229 170-386 1-8 14-22 22-25 89-27 155-79 209-147 51-65 90-143 126-228-140 69-304 64-457 78-213 19-369 68-554 152z" />
          <path d="M204649 49231c-680-88-1359-113-2041-114-684 0-1369 40-2058 112-20 6-15 33-14 46 2 28 37 35 121 27 643-60 1285-93 1932-93 674 0 1351 21 2038 102 33 9 77-85 22-81z" />
          <path
            fillRule="evenodd"
            d="M200570 49160c683-71 1362-110 2038-110 675 0 1349 40 2025 127l31-127c-17 9-37 15-58 15a123 123 0 1 1 113-171l60-170c-724-84-1446-122-2171-122-729 0-1459 38-2193 107l58 164c22-32 59-54 101-54a123 123 0 1 1 0 246c-12 0-25-2-36-6l33 94-2 7zm3067-416a123 123 0 1 0 0 246 123 123 0 1 0 0-246zm0 64a59.1 59.1 0 0 0 0 118c32 0 59-27 59-59s-26-59-59-59zm-1082-91a123 123 0 1 0 123 123c0-68-55-123-123-123zm0 64a59.1 59.1 0 1 0 .2 118.2 59.1 59.1 0 0 0-.2-118.2zm-1064-40a123 123 0 1 0-.2 245.8 123 123 0 0 0 .2-245.8zm0 64c-33 0-59 26-59 59s26 59 59 59a59.1 59.1 0 0 0 0-118z"
          />
        </g>
        <path d="M202601 47974c-14-68-49-129-100-175-51-47-116-78-187-88-33-4-39-58-7-68 60-20 114-67 157-133 45-69 79-157 95-256 5-34 64-35 69-1 15 84 51 153 97 208 55 66 125 112 193 138 31 12 25 63-8 68-59 9-105 42-141 87-50 62-81 145-100 221-8 33-62 31-69-2zm33-118c20-52 47-103 81-146 28-34 60-64 99-84-51-30-100-70-143-120-28-34-53-73-73-116-19 59-45 112-75 158-31 47-67 86-108 116 50 19 95 47 134 82 34 31 63 68 85 110zm799 5115-515 206c-17 7-35 14-48-21-14-34 4-41 21-48l515-206c17-7 35-14 48 21 14 34-4 41-21 48zm59-326-604 328c-16 9-33 18-51-15s-1-42 15-51l604-328c16-9 33-18 51 15s1 42-15 51zm-1826-65 604 328c16 9 33 18 15 51s-34 24-51 15l-604-328c-16-9-33-18-15-51s34-24 51-15zm51 322 515 206c18 7 35 14 21 48-14 35-31 28-49 21l-515-206c-17-7-34-14-21-48 14-35 31-28 48-21zm224 434c137 33 261 48 358 31 88-16 155-60 191-146v-493c-107-1-212-15-303-41-109-31-170-98-201-178-41-107-27-235-4-329 5-18 9-36 45-27s32 27 27 45c-20 82-33 194 1 284 23 60 69 110 152 133 91 25 198 38 307 38 107 0 214-13 304-40 82-24 148-69 192-123s65-117 57-176c-5-36-24-62-49-80-34-24-82-35-128-37-47-2-94 7-142 16-25 5-50 9-77 13-19 2-37 5-42-32s14-40 32-42c23-3 48-8 73-12 52-10 105-20 159-18 60 2 121 18 168 51 42 29 72 72 80 131 11 80-16 163-73 233-53 65-131 119-229 147-83 24-178 38-274 42v483c3 5 3 11 2 16 37 82 102 125 188 141 97 18 221 2 358-31 18-5 36-9 45 27 8 37-9 41-28 45-146 35-279 51-388 32-92-17-165-58-215-132-49 74-124 115-215 132-109 20-242 4-388-32-18-4-37-8-28-45 8-36 27-32 45-27zm356 210 402-9c19 0 38-1 38 37 1 38-18 38-37 38l-402 9c-19 0-37 1-38-37s18-38 37-38zm593-3082c151-125 293-227 423-297 133-72 254-111 359-106 19 1 37 1 36 39-1 37-20 37-39 36-92-4-200 32-322 97-125 67-263 166-410 289-14 12-29 24-53-5s-9-41 5-53zm-605 56c-141-130-298-240-445-314-139-71-268-108-363-100-19 2-37 4-40-34-4-37 15-39 34-40 110-10 252 31 404 107 152 77 315 191 461 325 14 13 28 25 2 53-25 27-39 15-53 2zm-213 1004c37-83 83-155 136-219 53-63 112-119 174-170 14-12 29-24 52 5 24 29 9 41-5 53-59 48-114 101-164 160-49 59-91 125-125 201-8 17-15 34-49 19s-27-32-19-49zm371-1734c49 66 88 139 114 223 26 82 40 175 39 279 5 80 6 165-7 249-13 86-42 170-97 246-43 60-101 97-165 113-53 13-109 10-164-7 29 100 51 208 6 308-8 18-33 27-51 18-43-22-86-43-128-62s-84-36-127-51l-1-1c-95-37-173-73-236-112-65-39-115-80-150-124l1 2c-44-49-72-106-88-170-14-55-20-114-22-174-72-39-138-78-194-116-64-43-118-87-161-131-13-14-26-27 1-53s40-12 53 1c39 40 89 80 150 121 60 40 128 81 204 121 124 13 247 51 370 109 106 50 211 115 317 192 13 7 19 16 27 20 8 6 16 13 25 19 51 22 104 28 152 16 47-11 90-39 122-84 48-66 72-139 84-214 12-77 11-157 6-234v-2c1-97-12-183-35-258-24-76-58-142-102-201-11-15-22-30 7-52s41-7 52 7zm-375 1047c-104-77-207-141-311-190-105-49-210-83-314-98 2 48 8 93 18 135 13 52 35 99 71 138l1 1c30 37 73 72 130 107 60 36 134 71 225 106l-1-1c45 16 89 34 133 54 31 14 61 28 93 44 19-83-10-179-37-267-2-8-5-15-9-29zm776-1003c-44 59-79 125-102 201-24 76-36 161-35 258v2c-5 77-6 158 6 234 12 75 37 148 84 214 32 45 75 72 122 84 48 12 101 6 152-16l25-19c6-4 13-12 27-20 105-77 211-143 317-192 123-58 246-95 370-109 75-40 144-80 204-121s111-81 149-121c13-13 26-27 53-1s14 39 0 53c-43 44-97 88-161 131-57 38-122 77-194 116-2 61-8 119-22 174-16 63-44 121-88 170l1-2c-35 44-85 85-150 124-63 38-141 75-237 112l-1 1c-43 15-85 32-127 51-43 19-85 40-128 62-18 9-43 0-51-18-45-100-23-208 6-308-55 18-111 20-164 7-64-15-122-53-165-113-55-76-84-160-97-246-13-85-12-169-7-249-1-104 13-196 39-279 26-84 65-158 114-223 11-15 22-30 52-7 30 22 19 37 7 52zm940 715c-105 15-209 49-314 98-104 49-207 113-311 190-4 13-6 21-8 29-27 88-56 184-37 267 31-15 62-30 93-44 44-20 87-38 133-54l-1 1c91-35 165-70 225-106 58-34 100-70 131-107l1-1c35-39 57-86 71-138 11-42 16-87 19-135z" />
        <path
          fillRule="evenodd"
          d="M203459 50602a216.4 216.4 0 0 0 0 433 216.6 216.6 0 0 0 0-433zm0 69c-81 0-147 66-147 147s66 147 147 147 147-66 147-147-66-147-147-147zm0 60a87 87 0 1 0 .1 174.1 87 87 0 0 0-.1-174.1zm-1697-124c119 0 217 97 217 216s-97 217-217 217a216.6 216.6 0 0 1 0-433zm0 69c81 0 147 66 147 147s-66 147-147 147-147-66-147-147 66-147 147-147zm0 60a87 87 0 1 1-.1 174.1 87 87 0 0 1 .1-174.1z"
        />
      </g>
      <use xlinkHref="#hr-a" transform="rotate(-2.2 -55532.8 156275.8)" />
      <use xlinkHref="#hr-a" transform="rotate(2.2 459865.8 156275.8)" />
    </g>
    <path
      fill="#171796"
      d="m387.2 94.9-19.3-22-25.2 14.5-4.3 51.1a219.7 219.7 0 0 1 36.2 6L387.2 95z"
    />
    <path d="M347.7 98c.8-.2 1.7-.2 2.6.3.3.1.6.3.8.6.4-.3.7-.6 1.2-.8a4 4 0 0 1 1.8-1c.9-.5 1.8-.8 2.7-.9h2.8c.8 0 1.6.2 2.3.6l2 1c.8.4 1.5.8 2.2 1a9.1 9.1 0 0 0 4.5.5c.4-.2.7.1.2.4-3.3 2-5.9.2-8.1-.6a16.2 16.2 0 0 1 2.1 1.7c.8.8 1.8 1.6 3.5 2.4a8.4 8.4 0 0 0 5 .7l.4.1-.1.5a4.8 4.8 0 0 1-2.6.7 10 10 0 0 1-5.2-1.3c-1.4-.7-2.3-1.6-3.3-2.4a7.5 7.5 0 0 0-3-1.4 6 6 0 0 0-2.9 0c.3.1.5.2.6.4.5.3 1 .4 2 .5.4 0 .2.3-.5.7a2 2 0 0 1-1.6.8c-1 .6-1.3.2-1.7-.2 0 .3 0 .5-.2.8a.6.6 0 0 1 0 .4l.2.7c0 .2 0 .3.2.4.2.2.3.4.3.7 0 .2.1.3.3.4l.6.6c.6.2.8.7 1 1.2.4.2.6.5.7.9.2 0 .4.2.6.4l2.6.1c.8.1 1.4.6 2 1.2h1.2a4 4 0 0 1 1.3-.3h2.3c.5.2.9.4 1.2.8.5.5 1.2.4 1.8.2a2.7 2.7 0 0 1 2.4 0 2.3 2.3 0 0 1 1-.2c.4-.3.7-.4 1-.4.6 0 1 0 .9.8 0 .2-.2.4-.3.4-.3.6-.7.7-1.3.7-.1.4-.3.7-.5.8.3.9 0 1.3-.7 1.2 0 .3-.3.4-.6.4a1.4 1.4 0 0 1-1 .5l.4.6c.4.7-.2 1-.8 1v1.2c.7.4.8.8.2 1.2.4.7.3 1.3-.5 1.6 0 .4 0 .8-.3 1-.2.2-.5.3-.3.6.3.5.2 1.1-.2 1.2l-.2.1-.2.2a9.6 9.6 0 0 0-1.5 1c-.1 0-.2.1-.2 0a9.6 9.6 0 0 1-1.8 2.4c0 .5-.4 1-1 1.1a.4.4 0 0 1-.3.4c.3.3.5.6.2 1a3 3 0 0 1-1.3.8c-1 .3-1.7.2-2-.2-.4-.3-.3-.6 0-.7-.7 0-.8-.2-.8-.7 0-.2.1-.2.3-.1.4 0 .7-.2 1-.3l.5-.6c0-.7.5-1 1.1-1.3.5-.2 1-.6 1.4-1.2l.9-1.5a1.2 1.2 0 0 1-.3-.7 1.5 1.5 0 0 1-.5-.6c-.5 0-.7-.2-.7-.5a1.1 1.1 0 0 1-.3 0c-.3.1-.5.3-.7.2a6.9 6.9 0 0 1-1.1 1c-.2.3-.4.5-.7.5-1 .1-1.5 1.2-2 1.7-.2.1-.3.4-.4.7 0 .6-.1 1-.4 1h-.4a1.2 1.2 0 0 0-.4 0c.3.3.3.6 0 .9-.1.3-.4.4-.8.4a3.6 3.6 0 0 1-1.6-.2c-.4-.2-.5-.5-.5-.7-.3-.2-.4-.3-.3-.5 0-.2.2-.3.4-.2l.6-.2a5.2 5.2 0 0 1 1.8-1.4 3 3 0 0 1 .7-.7c0-.5.5-1 1-1.4l.1-.6v-.3c-.2-.3-.3-.7-.1-1a1.3 1.3 0 0 1 0-.6c-1.1.6-1.5.4-1.6-.1-.4.3-.8.5-1 0-.4.1-.8.3-1.2.1l-.8.2-.4.7c0 .5-.2 1-.5 1.5a9.3 9.3 0 0 1-.7 1.5 1 1 0 0 1-.1.5c0 .6-.2.9-.5 1a2.4 2.4 0 0 1-.4.8v.2c.1.3.1.7-.2 1l-1 .6h-1c-.4-.3-.4-.4-.3-.6a.6.6 0 0 1-.5 0l-.4-.3c-.1-.2-.1-.4.1-.5l.9-.6c0-.2.2-.3.4-.4.2-.4.4-.6.6-.7l.7-1.5c.1-.1.2-.3.1-.4l.1-.3s.2-.1 0-.2a1.4 1.4 0 0 1 .2-1.2c.3-.4.6-1.4.3-2v-.8h-.3c-.2-.2-.4 0-.6.2l-.4.6c-.1.8-.5 1.5-1 1.6v1.2c0 .4 0 .7-.2.7s-.4.2-.5.5a1 1 0 0 0-.1.3c.3.3.2.7-.1 1-.6.6-1.4.5-2.2.3-.6-.3-.8-.5-.7-.8-.8 0-.7-.7 0-.9.8-.2 1.4-.7 1.9-1.4 0-.8.2-1.3.7-1.4 0-.5.2-1 .4-1.4.2-.4.3-.8.2-1.3-.4-.3-.4-.6 0-1 .1 0 .1 0 0-.2-.3 0-.3-.3-.3-.5s0-.2-.2-.2c-.6-.1-.5-.4-.2-.7.1 0 .2-.3 0-.4l-.1-.4c-.4-.3-.2-.6 0-.9l-.4-.8c-.7 0-1-.4-.6-.9a3.4 3.4 0 0 1 .7-.6c.1-.3.3-.6.2-.8-.2-.6.5-1 1-1.4a.9.9 0 0 1-.1-.4c-.3-.3-.2-.6.1-.8a1 1 0 0 1-.1-.5c-.8.2-.8-.3-.4-1-.5-.3-.4-.8.5-1.5a1 1 0 0 1 0-.4 2 2 0 0 0-1 .3c-.3.3-.6.2-.9.1a1.5 1.5 0 0 0-.4-.4.6.6 0 0 1-.2-.6c-1 0-1.1-.7-.6-1 .3-.3.6-.6.7-.9.2-.6.7-1 1.3-1.5v-.5a1.6 1.6 0 0 0-.7-.3 1.2 1.2 0 0 0-.6-.7c-.1 0-.2-.2 0-.4-.6-.4-.5-.7-.3-1z" />
    <g fill="#f7db17">
      <path d="M364.5 122a1.4 1.4 0 0 1-.2 0 8.4 8.4 0 0 1-.8.7c-.2-.3-.5 0-.2.1l-.2.2c0 .3-.2.4-.5.4h-.1a3 3 0 0 1 0-.3 3.5 3.5 0 0 1 0-.4 3.9 3.9 0 0 0-.1.4 2.8 2.8 0 0 0 0 .4c-.8.3-1.3 1.1-1.9 1.7l-.4.8c0 .2 0 .9-.3.9h-.2c0-.1-.2-.1-.4 0h-1c-.2.2.4.2.7.3.1.1.2.3.1.5-.2.7-1.8.5-2.3.2-.2-.1-.2-.3-.2-.5h.3c.2 0 .4 0 .5-.2 0 0 .1 0 0-.1 0-.1 0-.1 0 0a1.3 1.3 0 0 1-.5 0 2.6 2.6 0 0 1-.5 0h-.2c0-.1.2 0 .2 0l.7-.3a5.3 5.3 0 0 1 1.9-1.4l.8-.7c0-.7.4-1 .8-1.5l.3-.7v-.3c-.2-.4-.3-.7-.1-1a1.5 1.5 0 0 1 0-.8.3.3 0 0 0 0-.1 6.2 6.2 0 0 1 .8-.6v.8a1.3 1.3 0 0 0-.2.3.5.5 0 0 0 0 .2v.1a.4.4 0 0 1 0-.3l.3-.2.7-.4.7-.6v1l-.6.7v.1h.1a2.3 2.3 0 0 1 .5-.7 3.2 3.2 0 0 1 1-.6v1a1.5 1.5 0 0 0 .5.9z" />
      <path d="m349 113 .2-.2.4-.6a4 4 0 0 1 .5-.6 4 4 0 0 0-.4.7 5.8 5.8 0 0 0-.4.5v.2c.1.3.1.5.3.7l.3-.4a1.6 1.6 0 0 1 .4-.4 1.8 1.8 0 0 0 .5-.6h.1l-.2.4a2 2 0 0 1-.3.3l-.4.3a1.3 1.3 0 0 0-.2.4v.3c-.2.3-.5.5 0 .7a.6.6 0 0 0 .1.5l-.1.7c-.3.2 0 .2.1.2l.4-.4a4.3 4.3 0 0 1 .3-.4l.4-.5.1-.5h.1a1.4 1.4 0 0 1-.1.6 2 2 0 0 1-.5.5 3.8 3.8 0 0 0-.2.4 2.6 2.6 0 0 0-.3.4c.2.1.2.4.2.7h.1l.2-.2.2-.4h.1l-.2.4-.2.3c.2.1.2.3 0 .5-.4.3-.3.4 0 .7v1.2l.1.3h-.1v-.3c-.4.7-.6 1.1-.7 1.8-.6.1-.5.8-.6 1.3a3.9 3.9 0 0 1-1.9 1.5c-.1 0-.5.1-.5.3 0 .1.2.3.4.2.4-.5.7-.2.2.2v.3c.5.4 1.6.5 2.2.2.3-.3.5-.5.2-.9 0-.5.2-1 .8-1.2v-.4l.1-1.3.2-.1c.2 0 .6-.7.7-1.3v-.4c.1-.2.2-.2.3 0 0-.2 0-.3.2-.4.2-.3.5-.6.8-.4a3 3 0 0 1-.1-.8 2.7 2.7 0 0 1 0-1l.2-.2.3-.7.3-.7h.1l-.3.7-.3.8v.1a2.5 2.5 0 0 0-.1 1l.2.9.2.4v.6c.4.6 0 1.7-.3 2.2a1 1 0 0 0-.1.8c.2.2 0 .4-.1.6v.1c0 .2 0 .4-.2.5l-.7 1.6c-.4.1-.5.3-.6.7-.3.1-.3.2-.4.4a2.7 2.7 0 0 1-.9.6c-.3.1 0 .2.2.4.2.1.4-.2.6-.4.2-.3.3-.2.2 0a2 2 0 0 0-.2.7l.7.3c.4 0 .9-.4 1.2-.6.3-.2.2-.5.1-.8a2 2 0 0 1-.5 0 3.4 3.4 0 0 1-.5-.3 2.8 2.8 0 0 0 1 .2v-.3a2.7 2.7 0 0 0 .5-.8c.4-.2.4-.4.4-.9l.1-.5a10 10 0 0 0 .7-1.6c.4-.4.5-.9.5-1.4 0-.2.1-.3.3-.3a3.8 3.8 0 0 0 .3-.5l.1-.4a.8.8 0 0 1 .2-.2 1 1 0 0 0 0-.5 1.1 1.1 0 0 0-.1-.4.5.5 0 0 1-.1-.2v-.2h.1c.1 0 0 0 0 0v.1a.5.5 0 0 0 0 .2c.2.2.2.3.2.5a1 1 0 0 1 0 .5.7.7 0 0 0-.2.2 1.7 1.7 0 0 0 0 .3l.6-.1.4-.5.2-.6c.1 0 0 0 0 0a2 2 0 0 1-.1.7l-.3.3c.4.2.7 0 1 0V119l.4-.7c.1 0 .1 0 0 0l-.2.8v1c.1.4.2.5.5.3l.4-.2v-.1a18.2 18.2 0 0 1 1.8-1.6c.1.1 0 .1 0 .1a6.5 6.5 0 0 0-.8.7l-.8.7v.3c0 .3.1.5.6.3l.6-.2a1.3 1.3 0 0 1 .3-.2 8 8 0 0 1 .5-.3l.5-.3a3 3 0 0 1 .1-.6l.7-1.3a2.3 2.3 0 0 0 1.1-1.1h.1l-.4.7a2.5 2.5 0 0 1-.7.5l-.7 1.2a2.7 2.7 0 0 0-.1.5v.1a2.8 2.8 0 0 0 0 .8c.2 0 .4 0 .7-.3l.7-.7a1.7 1.7 0 0 1 .2-.5 1 1 0 0 1 .4-.4h.1v.1a.9.9 0 0 0-.4.3 1.7 1.7 0 0 0-.2.5v1.1l1-.5v1c0 .3.2.6.4.8a2.8 2.8 0 0 1 .5-.6l.3-.3.2-.2.3-.2-.2.3-.2.2-.3.2v.5h.6c0 .5 0 .6.5.6a3.2 3.2 0 0 1 0-.5l.1-.5h.1a1.9 1.9 0 0 0-.1.5 3.1 3.1 0 0 0 0 .5c.2.3.3.4.7.6l.2-.5a1.4 1.4 0 0 0 0-.4h.1v.5l-.3.5v.5a3 3 0 0 1 .2-.3l.3-.4c.1 0 .1 0 0 0 0 .2 0 .3-.2.4a4 4 0 0 0-.2.4l.2.2c-.6 1-1.3 2.5-2.5 3-.6.2-.9.5-1 1.2a1 1 0 0 0-.5.6l-1.2.3c0 .3 0 .4.3.4l.7-.3c.1 0 0 .5-.5.8v.1c.4.6 1.4.4 1.9.2.4 0 1-.5 1.2-.9.1-.2 0-.4-.2-.6-.8.1-.6-.6 0-.3.2 0 .3 0 .3-.3.6-.2.9-.5 1-1 .6-.7 1.2-1.4 1.6-2.1.1-.2.2-.4.1-.5a1 1 0 0 0 .2-.5l.1-.4h.1v.5a4.5 4.5 0 0 1-.2.3c0 .1 0 .2.2.2l1.5-1c0-.3.2-.4.4-.4l.2-.1c.1-.4 0-.6-.2-.8-.1-.4.1-.5.4-.7.2-.2.2-.7.2-1v-.2a2.6 2.6 0 0 0 0-.3l.1.3v.1c.3-.1.6-.3.7-.6 0-.3-.1-.6-.3-.8a9.6 9.6 0 0 1-.6.2 10.2 10.2 0 0 0 .7-.4 1.3 1.3 0 0 0 .3-.2c.2-.3-.3-.5-.5-.6l-.7-.7v-.1l.7.6v-1.1l-.2-.4a1.1 1.1 0 0 1-.5-.4 1 1 0 0 1-.1-.5l.2.4.4.4h1c.3-.3-.2-.7-.3-.9l-.1-.5h.1a1 1 0 0 0-.2-.2.6.6 0 0 0-.1 0v-.2a.7.7 0 0 1 .2.1l.2.2a.9.9 0 0 0 .1 0c.3 0 .5-.2.7-.5a3.6 3.6 0 0 0-.3-.4 10 10 0 0 0-.5-.3v-.1h.1a4 4 0 0 1 .8.8c.4 0 .4 0 .6-.3a1.5 1.5 0 0 0-.2-.4 2.5 2.5 0 0 0-.3-.4c0-.1 0 0 0 0 .2 0 .3.2.4.3l.2.5.4-.1c.3-.2 0-.8 0-1a2.8 2.8 0 0 0-.1 0l-.2-.2c0-.1 0 0 0 0h.2l.2.1.4-.6c0-.4 0-.2.5-.3.4 0 .6 0 .9-.6.1 0 .2 0 .2-.3s0-.4-.3-.4c-.5 0-.8 0-1 .3v.3c0 .1 0 0 0 0l-.2-.2c-.4 0-.7 0-1.1.2h-.2l.2.3.1.4a1 1 0 0 0-.2-.4 1.8 1.8 0 0 0-.3-.4 2.6 2.6 0 0 0-1-.2l.2.1.2.2v.1a7.7 7.7 0 0 1-.2-.2 6.5 6.5 0 0 1-.2-.2 2.7 2.7 0 0 0-.9.2l-.6.2.4.5.2.6a2.1 2.1 0 0 0-.3-.6 1.9 1.9 0 0 0-.4-.4 1.8 1.8 0 0 1-.5 0l.2.3-.3-.4a1.4 1.4 0 0 1-.5-.2 8.3 8.3 0 0 1 .2 1.5 7.8 7.8 0 0 0-.2-.9 4.7 4.7 0 0 0-.1-.7 1.7 1.7 0 0 1-.2-.2 2.1 2.1 0 0 0-.6-.4 1 1 0 0 1-.2.7c-.1 0 0 0 0 0a.8.8 0 0 0 .1-.8 3.1 3.1 0 0 0-1-.2 5.3 5.3 0 0 1 .5.8l.3.5v.5a2 2 0 0 0-.1-.5.7.7 0 0 0-.3-.4 5.6 5.6 0 0 0-.3-.5 4.6 4.6 0 0 0-.3-.4h-.4.1a.6.6 0 0 1 0 .3.5.5 0 0 0 0-.2.7.7 0 0 0-.2-.1h-.8a5 5 0 0 1 1 2.3 4.8 4.8 0 0 0-.4-1.2 5.1 5.1 0 0 0-.7-1h-.6a1.7 1.7 0 0 1 .4.4c0 .1 0 .1 0 0a1.6 1.6 0 0 0-.3-.1 2.4 2.4 0 0 0-.3-.2 5 5 0 0 0-.3 0l-.1.1a4.7 4.7 0 0 1 1 1.1c0 .1 0 0 0 0a3.8 3.8 0 0 0-.6-.6 4.7 4.7 0 0 0-.6-.4h-.6a5 5 0 0 1 .5 1.7h-.1a3.5 3.5 0 0 0-.2-.8 6.2 6.2 0 0 0-.3-.9 8 8 0 0 1-.4 0 9.1 9.1 0 0 1 .3 1.6v.1a9.3 9.3 0 0 0-.2-1 9.3 9.3 0 0 0-.3-.8 3.9 3.9 0 0 0-1.3-1 1.7 1.7 0 0 1 .4 1.1v.1a1.6 1.6 0 0 0-.2-.7 1.7 1.7 0 0 0-.4-.6 2 2 0 0 0-.3 0 15.6 15.6 0 0 0-1 0c.2.1.4.4.4.6 0-.2-.3-.5-.6-.7h-.6l.3.3.2.5.2.6.4.4s.1 0 0 0c0 .1 0 .1 0 0a1.1 1.1 0 0 1-.5-.3 1.5 1.5 0 0 1-.2-.7 1.3 1.3 0 0 0-.2-.4 2.7 2.7 0 0 0-.3-.4h-.7l.2.8.1 1h-.1a7.1 7.1 0 0 0 0-1 4.5 4.5 0 0 0-.3-.8 1 1 0 0 0-.6-.5.6.6 0 0 1 0 .3h-.1a.5.5 0 0 0 0-.3c-.2-.5-.3-.7-.6-.8v.4l-.2.4h-.1l.1-.5v-.4c0-.6-.2-1-.8-1.2v.2l-.1.5h-.1v-.5a1.9 1.9 0 0 0 0-.3l-.5-.5a2.3 2.3 0 0 1 0 .7 3 3 0 0 1-.4.8h-.1a3 3 0 0 0 .3-.8 2.2 2.2 0 0 0 .1-.8 1 1 0 0 1-.2-.3v.2h-.1v-.2l.1-.1v-.1a.7.7 0 0 0-.3-.5 1.5 1.5 0 0 1-.2.5h-.1c-.1 0 0 0 0 0l.1-.3.1-.3a1 1 0 0 1-.1-.2.8.8 0 0 1-.1.2 1.2 1.2 0 0 1-.2.2c-.1-.1 0-.1 0-.1l.1-.2a.7.7 0 0 0 .1-.2v-.2c0-.3 0-.4-.2-.7a.9.9 0 0 0-.3 0 2.8 2.8 0 0 0-.5.4v-.1a3.2 3.2 0 0 1 .4-.3.9.9 0 0 1 .4-.1.4.4 0 0 0 0-.2l-1 .3a1.6 1.6 0 0 1-.9-.2h.8c.3 0 .7 0 1.1-.2l.2-.6a1.7 1.7 0 0 1-.5 0l.6-.1v-.2c0-.2.3-.2.4 0 .2 0 .3.2.4.3.3.2.6 0 .9-.2h-.2v-.1h.3c.6 0 1 0 1.4-.5a7 7 0 0 1-1 0c-.2 0-.4 0-.6-.2l.7.1h1l.5-.3a5.4 5.4 0 0 1-2-.6 1.4 1.4 0 0 0-.6-.3c-.5 0-1 0-1.4.3l-.3-.3-.4-.2h-.6s-.1 0 0 0h1.2a4.5 4.5 0 0 1 1.7-.3 5.7 5.7 0 0 1 1.7-.2v-.2c.3-.3.4-.6.3-.9-.1-.2-.4-.5-.8-.7h-1.3a4 4 0 0 0-.8.1l.6.4.4 1v.1h-.2a2 2 0 0 0-.4-1c-.1-.2-.6-.3-.7-.4l-1.3.2-.7.4c.3-.1.6 0 .8 0 .3.2.5.4.6.8v.1h-.2a1 1 0 0 0-.5-.7c-.4-.2-1.2 0-1.6.3a4.2 4.2 0 0 0-.6.6h-.2v-.2l.7-.6.7-.4a2 2 0 0 1 1-.5l1.3-.2a1 1 0 0 0-.5-.5 1.4 1.4 0 0 0-.8 0c-.5.1-1 .4-1.5.7h.5l.1.2h-.5a1.4 1.4 0 0 0-.4 0l-1.5 1.2c-.5 0-.8 0-1 .2l-.1.6-.2.7c-.5.5-1 .9-1.3 1.5a1.4 1.4 0 0 1-.3.5.5.5 0 0 1 .3.1v-.2l.2-.4h.1a1.2 1.2 0 0 0-.1.4v.5h-.2a.3.3 0 0 0-.1-.2.5.5 0 0 0-.3 0l-.3.2-.2.3c0 .3.2.3.5.3.6 0 .1.4.4.7l.5.4h.5c0-.4 0-.6.2-.6a.8.8 0 0 1 .2-.4.8.8 0 0 0 0 .2.8.8 0 0 0-.1.2v.4a2.4 2.4 0 0 1 1-.2c.7-.8 1-.6.4 0l-.1.2a1.4 1.4 0 0 0-.2.6c-.2.1-1 .8-.7 1 .2 0 .4 0 .3.2-.1.2-.4.6-.3.9h.3a6.2 6.2 0 0 0 .7-.6 3.8 3.8 0 0 0 .5-.8h.1a9 9 0 0 1 .3-.8c0-.2.1-.5.3-.7l.3.3a.4.4 0 0 0 .2 0 .4.4 0 0 0 .3 0l.2-.3h.1a1.2 1.2 0 0 1-.3.4.5.5 0 0 1-.3 0 .5.5 0 0 1-.2 0 1.1 1.1 0 0 1-.3-.3 12 12 0 0 0-.5 1.4v.1a5.6 5.6 0 0 1-1.2 1.4l.2.5 1-1 .8-1a6 6 0 0 1-.3.6v1.1h-.1v-.9l-.3.3a11.6 11.6 0 0 1-1 1c-.3.3-.6.3-.2.7l.3-.3.4-.3h.1v.1l-.4.3-.4.3a.6.6 0 0 0 .1.3.5.5 0 0 1 .1 0l.8-.6c.1 0 0 .1 0 .1l-.7.6a.7.7 0 0 1-.1 0c-.3.3-1.2.8-1 1.2l.6-.2.6-.5c.1 0 0 0 0 .1a2.5 2.5 0 0 1-.6.5v.2-.1a3.6 3.6 0 0 1-.7.1c.1.4 0 .7-.3 1 0 .1-1 .9-.6 1a1 1 0 0 0 .3.2z" />
      <path d="M349.4 100.1a2.2 2.2 0 0 0-.6-.3 1.4 1.4 0 0 0-.5-.5c-.2-.2-.2-.1-.1-.3l.2-.1a.9.9 0 0 1 .3 0 .4.4 0 0 1 .2.2h.1c.1 0 0 0 0 0a.5.5 0 0 0-.2-.2 1 1 0 0 0-.4-.1.7.7 0 0 0-.4 0l-.2-.5.4.1.2.1a.7.7 0 0 0-.2-.2 2 2 0 0 0-.2 0 2.9 2.9 0 0 1 2.1.2c.4.1.6.3.8.6l-.2.2c-.5 0-.8 0-1 .2-.2.1-.2.4-.2.6z" />
    </g>
    <path d="m365 121.8-.4.2c0-.3.2-.4.3-.6v.2l.1.2zm2 4.2a2.3 2.3 0 0 1-.4.4 4 4 0 0 1-.5.4v-.1l.4-.4.4-.4zm1.3-1.6-.2.3h-.1l.2-.3zm-.7 0a1.1 1.1 0 0 1-.2.3 1 1 0 0 1-.5.4v-.1a1 1 0 0 0 .4-.3 1 1 0 0 0 .1-.4h.1zm1.2-1.6a1 1 0 0 0-.1.2 1.1 1.1 0 0 0-.1.2h-.1a1.1 1.1 0 0 1 .3-.5zm1 0v.5l-.3.5c-.1 0 0 0 0 0l.1-.5.2-.5zm-.4-6c.3.5.4 1 .4 1.5a7.3 7.3 0 0 1 .1-.6 1.4 1.4 0 0 0 .3-1.1c0-.1.1 0 .1 0v.6a1.7 1.7 0 0 1-.3.6l-.2 1h-.1v-.1c0-.6 0-1.2-.4-1.8v-.1zm-.8 1v.3h-.1v-.4h.1zm-.2 1.4a6.2 6.2 0 0 1 .2 1.4 1 1 0 0 1 .1-.1l.3-.3h.1a1 1 0 0 0-.3.3.7.7 0 0 0-.2.4 5 5 0 0 0-.1-.9 5.9 5.9 0 0 0-.2-.8zm1 .5a3.6 3.6 0 0 1 .1 1.2v-.6a3.6 3.6 0 0 0-.1-.6zm1-.2v.6a1.5 1.5 0 0 1 0 .5 1.2 1.2 0 0 0 0 .6l.1.6a2.5 2.5 0 0 1-.3-.6 1.3 1.3 0 0 1 0-.6 1.4 1.4 0 0 0 .2-.5 2.3 2.3 0 0 0 0-.6zm.5-1.5-.1.3v.2h-.1v-.6h.1zm-.5-2.6v.2c.1 0 .1 0 0 0 0 .1 0 0 0 0v-.2s-.1 0 0 0c0-.1 0 0 0 0zm.2-2v.8a.8.8 0 0 0-.2.3 1.4 1.4 0 0 0 0 .6h-.1a1.4 1.4 0 0 1 0-.6.9.9 0 0 1 .3-.4v-.7zm-2-.7c.4.2.6.4.8.7.2.2.3.5.3.9l-.6-.2v1.8c-.2.5-.5.8-1 1a3.8 3.8 0 0 0 0-1.8h.1a3.6 3.6 0 0 1 0 1.6 1.5 1.5 0 0 0 .7-.8 3.7 3.7 0 0 0 .1-1.9l.6.2c0-.3-.1-.5-.3-.8a2.5 2.5 0 0 0-.7-.6v-.1zm5.2-1v.2h-.1v-.2s0-.1 0 0h.1zm-1.2 0 .3.1a.8.8 0 0 1 .1.2v.1a.8.8 0 0 0-.2-.2.6.6 0 0 0-.2-.2zm-1.8.5.3.5v.6c-.1 0-.1 0 0 0l-.1-.6a1 1 0 0 0-.3-.5h.1zm-6 .5v.4l-.1.1v-.5zm1-.6.2.4v.1h-.1v-.1l-.1-.3zm2.4 1.6v.1a1.1 1.1 0 0 1 0 .2.8.8 0 0 0 0-.2.6.6 0 0 0-.1 0v-.1zm.8-1.8v.2a.2.2 0 0 1 0 .2.1.1 0 0 0 0-.2c-.1-.1-.1-.1 0-.1zm-5.5.3a1 1 0 0 0 .2.7c.2.1.2.3.3.4v.4h-.1v-.4a.9.9 0 0 0-.2-.3 1 1 0 0 1-.2-.4 1.1 1.1 0 0 1-.1-.4zm2.2 1.5.2.7v.7c0 .3 0 .6.2.8l.6.7a2.9 2.9 0 0 1-.1-1l.3-1c.2 0 .2-.2.3-.3v-.4h.1v.4a1.5 1.5 0 0 1-.3.5 1.6 1.6 0 0 0-.3.9c0 .3 0 .6.2 1h-.1c-.4-.2-.6-.5-.8-.8a1.3 1.3 0 0 1-.2-.8v-.7a1.8 1.8 0 0 0-.2-.6c0-.1.1 0 .1 0zm-.9 1.4c0 .2 0 .5-.2.7a3.4 3.4 0 0 1-.4.6h.3a2.2 2.2 0 0 0 .7-.6l.3-.3c.1 0 0 0 0 0a3.6 3.6 0 0 1-.2.4 2.5 2.5 0 0 1-.3.2 24.5 24.5 0 0 1 0 .4v-.2a1.5 1.5 0 0 0-.1-.1 2.2 2.2 0 0 1-.4.2l-.4.2v-.1l.4-.7.2-.7h.1zm-1 0v.1h-.1c-.1 0 0 0 0 0v-.2z" />
    <path d="M363 113.7c.2.3.2.6.2 1a1.9 1.9 0 0 1-.4.8 1.9 1.9 0 0 0-.5.6 2.6 2.6 0 0 0-.2.6l.2-.3.5-.3a4.6 4.6 0 0 0 1.1-.9h.1c.1 0 0 0 0 0a4 4 0 0 1-1.2 1 1 1 0 0 0-.4.3 2.3 2.3 0 0 0-.4.5c0-.4 0-.7.2-1l.5-.6.4-.8c0-.3 0-.6-.2-.9h.1zm2.3 3.5.1.4.1.1c.2.3.3.5.3.8l-.1 1h-.1a1.8 1.8 0 0 0-.4-1 3.4 3.4 0 0 0-.8-.6v-.1c.4.2.7.4.9.7l.3.6a3.4 3.4 0 0 0 0-.6 1.3 1.3 0 0 0-.1-.7l-.1-.2c-.2-.2-.3-.3-.2-.4zm1 0 .1.2c0 .1 0 0 0 0h-.1l-.2-.2h.1zm1 .3-.2.7-.2.7.2-.7.2-.7zm.7 4v.1a.3.3 0 0 1 0-.2zm-.7-1.2v.3l-.2.4v-.4l.1-.4h.1zm-1 0h.1v.1h-.1v-.1zm-1.1-.6a7.3 7.3 0 0 1-.1.2v.2h-.1a5 5 0 0 1 0-.2 5 5 0 0 1 0-.2h.1c.1 0 0 0 0 0zm-1.7 1.8a.7.7 0 0 0-.1.2 1.3 1.3 0 0 0 0 .2s-.1.1-.2 0v-.2a.8.8 0 0 1 .2-.3h.1zm-4.8 4.6a.7.7 0 0 1 0 .2 1.1 1.1 0 0 1-.2.1c-.1 0-.1 0 0 0a.8.8 0 0 0 .1-.3h.1zm.8-.4a.3.3 0 0 1-.1.2.6.6 0 0 1-.2 0 .4.4 0 0 0 .1-.1.3.3 0 0 0 0-.1h.2zm1-.6a.5.5 0 0 1 0 .1.5.5 0 0 1-.2.1.4.4 0 0 0 0-.2h.2zm1.5-3.8-.1.4a1.4 1.4 0 0 0 0 .4h-.1a1.4 1.4 0 0 1 0-.4v-.5h.1zm1-10.3a.9.9 0 0 1-.1.3 1.4 1.4 0 0 1-.2.3h-.1l.2-.3a.8.8 0 0 0 0-.3l.1-.1zm-1-1a1.9 1.9 0 0 1 .1 1 1.8 1.8 0 0 0 0-.5 1.5 1.5 0 0 0-.2-.4c0-.1 0 0 0 0zm-1.4 1.7a1.5 1.5 0 0 1-.4-.4.7.7 0 0 1-.1-.4l.2.4.3.4zm1.5 2.6v.2h-.1v-.2zm-2-2 .6 1 .1.8c.2 0 .3-.1.4-.3v-.9a1.9 1.9 0 0 0 .3-.6 3.5 3.5 0 0 0 .1-.5h.1l.4.8.3.9h-.1a2.9 2.9 0 0 0-.3-.9 3.9 3.9 0 0 0-.3-.6 2.9 2.9 0 0 1 0 .4 2 2 0 0 1-.3.5l-.1 1-.4.3v.4h-.1c0-.4 0-.8-.2-1.2a2 2 0 0 0-.5-1zm1.2 5v.3l-.1.4h-.1v-.8h.1c.1 0 .1 0 0 0zm-2.2.9v.3l-.1-.3c0-.1.1 0 .1 0zm1.9-2.5a2.3 2.3 0 0 1-.2.6l-.3.5a1.1 1.1 0 0 0-.3.6 1.8 1.8 0 0 0 0 .7c0 .1 0 0 0 0a1.9 1.9 0 0 1-.1-.7c0-.2.1-.5.3-.7a2.1 2.1 0 0 0 .3-.5 2.1 2.1 0 0 0 .2-.6c.1 0 0 0 0 0zm-.5-.8v.6a2.2 2.2 0 0 1-.5.6 1.8 1.8 0 0 0-.4.5l-.2.5h-.1l.2-.6.5-.5a2 2 0 0 0 .3-.5 1 1 0 0 0 .1-.6h.1zm-2.4 1.2c0 .4 0 .7-.2 1-.1.3-.3.6-.6.8h-.1v-.1c.3-.2.5-.5.6-.8.2-.2.2-.6.2-1zm-3 1.7v.2l.1.1v.1h-.1l-.1-.2v-.2s-.1 0 0 0zm-1.3 0a2.7 2.7 0 0 0 0 .7l.4.6.1.5v.4l.4-.5a1.4 1.4 0 0 0 .2-.6 1.6 1.6 0 0 1 0 .6l-.5.6h-.1a3.3 3.3 0 0 0 0-.5 1.8 1.8 0 0 0-.2-.4 2 2 0 0 1-.3-.7 2.7 2.7 0 0 1-.1-.7zm.2 4.2a2.6 2.6 0 0 1 .1-.8h.1a2.5 2.5 0 0 0-.1.8h-.1zm-.2 1.1v-.4s0-.1.1 0v.4zm-.8 2 .2-.3.2-.3h.1a4 4 0 0 1-.2.4l-.2.2c-.1 0-.1 0 0 0zm-1.1-6.6v.2h-.1v-.2zm-2 4.5a2.9 2.9 0 0 0 0-.1v-.2h.1v.3zm5-8-.3 1c0 .3.1.6.3.7.3.2.4.4.5.7v-.4c.1-.1.1-.3 0-.4h.1a2.7 2.7 0 0 1 0 1h-.1a6 6 0 0 1 0-.2l-.5-.6c-.3-.2-.4-.4-.4-.8l.2-1h.1zm-.4-1.3a2.5 2.5 0 0 1 0 .8 4 4 0 0 1-.3.7 2.4 2.4 0 0 0-.2 1c0 .4.1.7.3 1v.1a2.5 2.5 0 0 1-.2-2.1 3.8 3.8 0 0 0 .2-.7c0-.3.1-.5 0-.8h.1c.1 0 0 0 0 0zm-2.3 3.3a.8.8 0 0 0 0 .4l.1.5c0 .1 0 0 0 0a1.5 1.5 0 0 1-.3-.5.9.9 0 0 1 .1-.5h.1zm-1-.4v.3a.9.9 0 0 1 0 .3.4.4 0 0 0-.1.3l.1.2v.1a.8.8 0 0 1-.2-.3.5.5 0 0 1 0-.4.8.8 0 0 0 .1-.2v-.3h.1zm5.8-8.6a2.3 2.3 0 0 0 .3 1.5 2.6 2.6 0 0 1-.4-.7 2.3 2.3 0 0 1 0-.8h.1zm-.7.7a4 4 0 0 1 .5 1.7h-.1a3.8 3.8 0 0 0-.5-1.6v-.1zm-3.6.1c-.4.5-.5 1-.6 1.3l.2.9.2.8a2.6 2.6 0 0 1-.2.8c-.1 0 0 0 0 0v-.8a2.3 2.3 0 0 0 0-.8 1.7 1.7 0 0 1-.3-1c0-.3.2-.7.6-1.2.1 0 0 0 0 0zm3.3-1.4v.5l-.4.4a.8.8 0 0 0-.3.4v.7c0 .1 0 0 0 0a1.9 1.9 0 0 1 0-.7 1 1 0 0 1 .3-.5 1 1 0 0 0 .3-.4.6.6 0 0 0 0-.4h.1zm-3.5.3v.7c0 .2-.2.4-.4.6a1.2 1.2 0 0 0-.4.6 2.9 2.9 0 0 0-.1.7h-.1a3 3 0 0 1 .1-.8c0-.2.2-.4.4-.6l.4-.6a1 1 0 0 0 0-.6zm2 .1a.8.8 0 0 0 0 .2.5.5 0 0 0 .1.3.6.6 0 0 1-.2-.2.8.8 0 0 1 0-.3h.1zm0-.5a.8.8 0 0 0-.5.4l-.2.7.2.5v.7a2.4 2.4 0 0 0 0-.7l-.3-.4a2 2 0 0 0-.5 1.2c0 .5.1 1 .5 1.5h-.1a2.7 2.7 0 0 1-.5-1.5c0-.5.2-.9.6-1.3 0-.3 0-.6.2-.8a1 1 0 0 1 .5-.4zm-.7-.8v.1c0 .3 0 .6-.2.7a.8.8 0 0 0-.2.3 1.6 1.6 0 0 0-.1.4h-.1a1.7 1.7 0 0 1 0-.4 1 1 0 0 1 .3-.4c.2-.1.2-.4.2-.6a2.7 2.7 0 0 0 0-.1h.1zm5.7 6 .1.5v.4a1.4 1.4 0 0 0 0-.4 1.9 1.9 0 0 0-.2-.4h.1zm0 2v.6l-.2.6-.3.6.2-.6a2.1 2.1 0 0 0 .2-.6 1.6 1.6 0 0 0 0-.7h.1zm-1.2-1.8a2.5 2.5 0 0 1 .7 2.5h-.1a2.4 2.4 0 0 0-.6-2.4v-.1c0-.1 0 0 0 0zm0 2a5.3 5.3 0 0 1-1 1.4 2.5 2.5 0 0 0-.5 1 1.4 1.4 0 0 0-.1-.6 1.9 1.9 0 0 0-.2-.4 1.4 1.4 0 0 1-.3-.9l.3-.8.3-.6a2.4 2.4 0 0 0 0-.6h.1c.1 0 0 0 0 0a2.6 2.6 0 0 1-.3 1.3 1 1 0 0 0-.3.7c0 .3 0 .6.2.8a2 2 0 0 1 .3.8 2.6 2.6 0 0 1 .5-.8 5 5 0 0 0 .5-.6l.3-.7h.1zm-3.2-1a2.8 2.8 0 0 0 .4 1.4v.1h-.1a2.3 2.3 0 0 1-.3-.7 3 3 0 0 1 0-.7zm-1.7 1v.3h-.1v-.3zm.6-1.6-.1.5a1.4 1.4 0 0 1-.3.5c-.1 0 0 0 0 0l.2-.5a1.4 1.4 0 0 0 0-.5h.1zm-1.6 3.1a3.3 3.3 0 0 1-.3-1.7c0-.5.3-.8.6-1l.4-.7c.1-.2.2-.5.1-1s.1 0 .1 0v1l-.6.7a1.9 1.9 0 0 0-.5 1c0 .5 0 1 .3 1.7h-.1zm-1-1.1a.7.7 0 0 0 0 .3l.1.4a1 1 0 0 1-.2-.4.8.8 0 0 1 0-.4h.1zm4.6-3.2c.1.2.3.5.3.8 0 .3 0 .6-.2.9h-.1c-.1 0 0 0 0 0l.2-.9a1.5 1.5 0 0 0-.3-.8zm1.4-1.1a2.4 2.4 0 0 1 0 1.7 1.8 1.8 0 0 0-.2-.8 1.5 1.5 0 0 0-.5-.5c0-.1 0-.1.1 0a1.6 1.6 0 0 1 .6 1v-.6a2.3 2.3 0 0 0-.1-.8zm.8-1.2.4.8v1a2 2 0 0 0 0 .5 1 1 0 0 0 .2.4 1 1 0 0 1-.2-.4 2.3 2.3 0 0 1 0-.5 3.5 3.5 0 0 0-.1-1 1.5 1.5 0 0 0-.4-.7c0-.1 0 0 .1 0zm-2.2-.2a1 1 0 0 0-.3.5v.7a2 2 0 0 1 0-.7c0-.2 0-.4.2-.5.1 0 .1 0 0 0zm-4.4 3a2 2 0 0 1-.3 1 2.5 2.5 0 0 1-.8.7c-.1 0 0 0 0 0l.7-.7c.2-.3.3-.6.3-1l.1-.1zm0-1.6v.5a2.2 2.2 0 0 1-.3.5l.1-.5v-.5h.1zm2.9-.2v1h-.1v-1zm.7-1.3c-.2.3-.3.5-.3.8l.2.7.3 1.2c0 .4-.2.7-.4 1.1l.3-1.1a1.9 1.9 0 0 0-.3-1.2l-.2-.7c0-.3 0-.6.3-.8.1 0 0 0 0 0zm-4.6-8.1a2 2 0 0 1 1-.5c.4 0 .8 0 1.2.3h.8-.8c-.4.5-.8.7-1.1.7a1 1 0 0 1-.9-.2c0-.1 0-.1 0 0a1 1 0 0 0 .9 0c.2 0 .6-.1 1-.5a1.9 1.9 0 0 0-1-.1 2 2 0 0 0-1 .4c-.1 0 0 0 0-.1z" />
    <path d="M351.6 101a.3.3 0 0 1 .3.3.3.3 0 0 1-.3.2.3.3 0 0 1-.2-.2.3.3 0 0 1 .2-.3zm1.8 1.6a2.2 2.2 0 0 0 .8-.7c.1 0 0 0 0 .1a2.3 2.3 0 0 1-.2.3l-.5.4c-.1-.1 0-.1 0-.1zm3.7-1.6a.5.5 0 0 1 .3 0 .8.8 0 0 1 .3.2.7.7 0 0 0-.3 0 .5.5 0 0 0-.2 0l-.1-.1zm-2 .1a.8.8 0 0 1 .3-.4l.7-.1v.1a1 1 0 0 0-.7 0 .7.7 0 0 0-.3.5c-.1 0-.1 0 0 0zm.2.4a.4.4 0 0 1 0-.3.6.6 0 0 1 .3-.1h.1a.5.5 0 0 0-.3.2.3.3 0 0 0 0 .2h-.1zm-3.6 1.1-.1.3a.8.8 0 0 0 0 .3l-.1.1a1 1 0 0 1 0-.4c0-.1 0-.2.2-.3zm1 .5v.2-.2zm-.6-1.1a1 1 0 0 0 .3 0h.3a1.4 1.4 0 0 1-.3.1 1 1 0 0 1-.3 0s-.1 0 0-.1zm.6-2a.3.3 0 0 0-.2.1.4.4 0 0 0-.1.2h-.1a.5.5 0 0 1 .2-.3.4.4 0 0 1 .2 0h.1zm-1 .2a.8.8 0 0 0-.2 0 .3.3 0 0 0 0 .2h-.1c-.1 0 0 0 0 0a.4.4 0 0 1 0-.2.9.9 0 0 1 .3-.1zm-.7 0a.8.8 0 0 0-.1.1.7.7 0 0 0-.1.2h-.1a.7.7 0 0 1 .1-.2.9.9 0 0 1 .2-.2v.1zm-.8.7a1.7 1.7 0 0 0-.4.4v-.1a2 2 0 0 1 .4-.4zm0 .9v.1l-.2.2c-.1 0-.1 0 0 0v-.2l.2-.2c.1 0 .1 0 0 0zm-.7.2v.3l-.1.1c-.1 0 0 0 0 0v-.4zm1 1.4v.6h-.1v-.6h.1zm-.6-.4v.3h-.1v-.3h.1zm-.6-4.5a.7.7 0 0 1 .5.4v.1h-.1a.7.7 0 0 0-.2-.3.7.7 0 0 0-.2-.1v-.1zm5.2 6.7a1.6 1.6 0 0 1 0 1.4h-.1a1.6 1.6 0 0 0 0-1.3v-.1zm-1.7 2c0-.3.2-.5.3-.7l.4-.6c.2-.2.3-.4.3-.7a1.8 1.8 0 0 0 0-.7h.1a2 2 0 0 1-.3 1.5 6.3 6.3 0 0 0-.4.5l-.3.7h-.1zm-2.2-.6a.7.7 0 0 1 .2-.3.9.9 0 0 1 .3-.1.8.8 0 0 0-.2.2.6.6 0 0 0-.2.2zm-.4-.2.3-.3.3-.2v.1a1 1 0 0 0-.3.2 2 2 0 0 0-.2.3c-.1 0-.1 0 0 0zm2.3-2.2h.2a.8.8 0 0 0 .3 0v.1a.8.8 0 0 1-.6 0c0-.1 0-.1 0 0zm-1.2-.1.1-.1c.1 0 .1 0 0 0v.1c-.1 0 0 0 0 0zm24.2 7a1.1 1.1 0 0 1 .2.3h-.1a.8.8 0 0 0 0-.1.8.8 0 0 0-.2-.2c0-.1 0 0 0 0zm-26.8 12.5.3.3a1 1 0 0 0 .5 0v.1a1 1 0 0 1-.5 0 1.7 1.7 0 0 1-.4-.3c0-.1 0-.1 0 0z" />
    <g fill="red">
      <path d="M368.9 99.6a8.2 8.2 0 0 0 1.7 0c-.6.3-1.2.6-2 .7a.8.8 0 0 0 .3-.4.4.4 0 0 0 0-.3zm-1.4-.1h1.2v.4s0 .2-.2.3c0 0-.1 0 0 .1a5.6 5.6 0 0 1-1.3 0 1 1 0 0 0 .3-.5.6.6 0 0 0 0-.4zm-10.5-3c.7-.2 1.3-.2 2-.2a1 1 0 0 1 .5.4c.1.2.2.5.1.8l.1.1h.1l-.1-1a1 1 0 0 0-.3-.2h.2a5 5 0 0 1 2.1.6c.2.2.3.3.2.5l-.3.5v.2h.2l.3-.7a.7.7 0 0 0 0-.3l1.7.8a.5.5 0 0 1 0 .5 1 1 0 0 1-.5.3v.1l.1.1c.3 0 .5-.2.6-.4a.6.6 0 0 0 0-.4l1.2.6v.3c0 .2-.1.3-.3.4 0 0-.1 0 0 .1 0 .1 0 0 0 0 .3 0 .5-.2.6-.4a.5.5 0 0 0 0-.3l.4.1a8.1 8.1 0 0 0 1.3.4.5.5 0 0 1 .1.4.7.7 0 0 1-.2.3v.2c-1.4-.1-2.7-.9-4.1-1.4l-.5-.2-1.6-.6-.1-.1a8.5 8.5 0 0 0-1.5-.4 6.1 6.1 0 0 0-1.6 0h-.1l-.1-.8a1.3 1.3 0 0 0-.5-.4z" />
      <path d="M354.6 97a8.7 8.7 0 0 1 2-.5c.4.1.6.3.7.5v.6a4.2 4.2 0 0 0-1.7.2 1.2 1.2 0 0 0-.7-.6 1.2 1.2 0 0 0-.3-.1zm7.4 3.9a9.4 9.4 0 0 0-.5-.4 7 7 0 0 0-3-.8c.3-.4.4-.8.3-1.1a1.7 1.7 0 0 0-.7-.8h1a8 8 0 0 1 2 .6c0 .3.1.6 0 .8 0 .3-.2.5-.5.7 0 0-.1 0 0 .1 0 .1 0 .1 0 0 .4-.1.6-.4.7-.7v-.8l1 .6 1 .8c0 .4 0 .6-.3.8h-.9v.2z" />
      <path d="m364 102.4-1.8-1.4c.4 0 .7 0 1-.2.1-.1.3-.4.3-.8l1.1 1 .6.5v.4a.5.5 0 0 1 0 .2.6.6 0 0 1-.4.2h-.7z" />
      <path d="M366.2 103.8a11.8 11.8 0 0 1-2-1.3h.7a.8.8 0 0 0 .4-.2l.1-.4a1 1 0 0 0 0-.2 10.5 10.5 0 0 0 2.1 1.4c0 .3 0 .4-.3.5a3 3 0 0 1-1 .1z" />
      <path d="M368.4 104.7a11.9 11.9 0 0 1-2-.8c.4 0 .7 0 1-.2.2 0 .3-.2.3-.5a10.8 10.8 0 0 0 1.3.6v.4l-.5.4s-.1 0 0 0z" />
      <path d="M373.2 104.2s.4-.1.2 0c-1.4 1-3.1 1-4.8.5.3-.1.5-.2.6-.4a.6.6 0 0 0 0-.5l1.7.4a.4.4 0 0 1-.1.3l-.5.3s-.1 0 0 .1c0 .1 0 0 0 0 .3 0 .5-.2.6-.3a.6.6 0 0 0 .2-.4 9 9 0 0 0 2 0zm-9.7 24-.2.4-1.2.3c0 .3 0 .4.3.4l.7-.3c.1 0 0 .5-.5.8v.1c.4.6 1.4.4 1.9.3a3 3 0 0 0 1.3-1l-.3-.6c-.4.1-.6 0-.5-.2a3.9 3.9 0 0 0-1.5-.2zm-15.1-4.8c-.3.3-.7.5-1 .6-.2 0-.6.1-.6.3 0 .1.2.3.4.2.4-.5.7-.2.2.2v.3c.5.4 1.6.5 2.2.2.3-.2.6-.5.2-.9a1.7 1.7 0 0 1 0-.2h-.6l-.4-.3-.4-.4zm10 3.5h-.1c-.2.2.3.2.6.3.2.1.2.3.2.5-.3.7-1.9.5-2.4.2-.2-.1-.2-.3-.2-.5h.3c.2 0 .4 0 .6-.2v-.2h-.2a1.3 1.3 0 0 1-.4.2 2.6 2.6 0 0 1-.5 0l-.2-.2h.2l.7-.2.1-.1c.5 0 1 0 1.3.2zm-7.2-.4-.2.3a2.7 2.7 0 0 1-.9.6c-.2.1 0 .2.2.4.2.1.5-.2.6-.4.2-.3.3-.2.2 0l-.2.7.7.3c.4 0 1-.4 1.2-.6.3-.2.2-.5.1-.8a2 2 0 0 1-.5 0 3.4 3.4 0 0 1-.5-.3l-.7-.2zm2.8-26.4h.3l.6.1a4.5 4.5 0 0 1 1.7-.3 5.7 5.7 0 0 1 1.7-.2v-.2c.3-.3.4-.6.3-.9-.1-.2-.4-.5-.8-.7h-1.3a4 4 0 0 0-.8.1l.6.4.4 1c-.2.1-.2 0-.2 0 0-.4-.2-.6-.3-.9l-.8-.4a9 9 0 0 0-1.3.2c-.3 0-.5.2-.7.3l.8.1c.3.1.5.4.6.8-.1.1-.1 0-.1 0a1 1 0 0 0-.5-.6c-.4-.2-1.3 0-1.7.2a4.2 4.2 0 0 0-.6.6l2 .4zm-2.3-.4v-.1l.7-.6.7-.4a2 2 0 0 1 1-.5l1.3-.2a1 1 0 0 0-.5-.5l-.8-.1-1.5.8h.5l.1.2h-.4a1.4 1.4 0 0 0-.4 0h-.1l-1.3 1c.3.1.6.2.7.4z" />
    </g>
    <path
      fill="#0093dd"
      d="m409 156.5 20.8-47-15.3-24.7-27.3 10-12.7 49.8a219.4 219.4 0 0 1 34.5 11.9z"
    />
    <path
      fill="#fff"
      d="M382.6 113a251.7 251.7 0 0 1 39.6 13.7l-8 18.2a232 232 0 0 0-36.5-12.7z"
    />
    <path
      fill="red"
      d="m415.4 142 5.4-12.2a248.6 248.6 0 0 0-39-13.5l-3.2 12.4a235.9 235.9 0 0 1 37 12.8l-.1.4z"
    />
    <path d="M385.6 125.8c.3-.3.7-.2 1.1-.1.3-.2.7-.2 1-.2l.6-.2c.2 0 .2-.2 0-.3a.6.6 0 0 1 0-.3c-.7-.4-1-1-1.2-1.5-.3 0-.5-.2-.5-.3h-.5c-.8 0-1-.3-1.3-.5a1 1 0 0 1-.6-.4l-.3-.3c-.2-.3-.1-.7.2-.7h.7a2 2 0 0 1 .9-.1c.3 0 .5-.3.9-.6v-.4s0-.2.2-.1a1 1 0 0 1 .8.5c.5 0 1 .3 1.2.7.7 0 1.1.3 1.2.5 0 .2-.2.4-.5.6v.2l.4.4 1 .7c1-.1 2.6.6 4.8 2a18.6 18.6 0 0 1 4.1 1.2h.9c2.4-.4 4.7 0 6.8 1.5.8.1 1.5.4 2.2.7.5.2 1 .3 1.6.3a8 8 0 0 1 2.6.7c1 .2 1.9.6 2.4 1.2.4.5.3 1-.2 1.2-.3.6-.9.6-1.8.3-.6.1-1.3-.4-2-.9-.8-.2-1.6-.8-2.4-1.3l-1.3-.6h-.8v.2c.2.2.4.4.4.8v1c0 .4.3.6.7.9l1 .4c.2 0 .3.1.3.3l.4 1.7.4.3c.6.5.2 1-.3 1a3.1 3.1 0 0 1-1.3.8c-.4.2-.6 0-.7-.2a.5.5 0 0 1-.4-.2c-.5-.4-.1-1 1-.7l.2-.2a1.5 1.5 0 0 1 0-.9l-.3-.2a2.8 2.8 0 0 1-1-.6c-.6-.5-1.5-1-2.4-1.4-.7 0-1.2-.4-1.8-.7h-.8c-.2 0-.4 0-.5.2-.2.3-.5.2-.8.2h-1.6c-.4 0-.7 0-1 .3-.2.2-.4.2-.7 0a1 1 0 0 1-.3-.2c-.3 0-.5 0-.5-.2-.5-.1-.6-.2-.6-.4-.6-.1-.3-.6 0-.6l1.4.1c.4.1 1 0 1.2-.2l.5-.5a4 4 0 0 1-1.8-.5c-1.1-.7-2-.9-2.8-.3-.2.2-.3.2-.6.1a1 1 0 0 0-.5 0c-.5.1-.9 0-1.3-.1a4 4 0 0 1-1.8 0c-.6.3-1 .4-1.2.2a8.6 8.6 0 0 1-.6-.4c-.4-.1-.5-.2-.5-.3-.4 0-.5-.2-.5-.4-.2-.2 0-.3 0-.4.4-.2.7-.2 1 0 .3 0 .5.2.6.3h.6c.1-.2.5-.2 1-.2l.7-.2v-.2c-.4 0-.6-.4-.9-.7a3 3 0 0 1-1.5-.5c-.4 0-.7-.1-1-.3h-.7a2.5 2.5 0 0 1-1.4 0h-.8a1 1 0 0 1-1 .2 1.5 1.5 0 0 0-.8-.5c-.3-.1-.4-.2-.4-.4-.4-.2-.3-.4 0-.5.3-.1.5-.2 1 0l.5.2z" />
    <path
      fill="#fff"
      d="M401.2 130.5s0-.2-.3 0c-.8 0-1.6 0-2.2-.4-.7-.4-1.3-.8-2-.8l.7-.4h1.5c.7 0 1.4.2 2 .4.4.2.8.5 1 .8a3.4 3.4 0 0 1 .8.7 2.5 2.5 0 0 1-.7 0 2.9 2.9 0 0 1-.8-.3z"
    />
    <path d="M403 94.7v.2l.9 4.9-3.7 3.2-.2.1.2.1 4.7 1.6 1 4.9v.2l.2-.1 3.7-3.3 4.6 1.6h.3v-.1l-1-4.9 3.7-3.2.2-.2h-.3l-4.6-1.6-1-4.9V93l-.2.1-3.7 3.3-4.7-1.6z" />
    <path
      fill="#f7db17"
      d="m400.6 103 3.5-3 4.4 1.4zm8.5-1.7 3.4-3 4.4 1.5zm7.8-1.3-3.4 3-4.4-1.5zm-8.4 1.6-3.5 3-4.3-1.5zm-5-6.4 4.3 1.4.8 4.6zm5.5 6.4 4.4 1.5.9 4.5zm5.1 6.1-4.3-1.5-.9-4.5zm-5.6-6.4-4.3-1.5-.9-4.5zm3-7.7 1 4.6-3.5 3zm-2.7 8.1.8 4.6-3.4 3zm-2.8 7.5-.9-4.5 3.5-3zm2.8-8-.9-4.6 3.5-3z"
    />
  </svg>
)

export default HrFlag
