// This file is generated by @lib/ui/country/codegen/generateFlags.ts
import { SvgIconProps } from '@lib/ui/icons/SvgIconProps'

const GsFlag = (props: SvgIconProps) => (
  <svg
    width="1em"
    height="0.75em"
    xmlns="http://www.w3.org/2000/svg"
    xmlnsXlink="http://www.w3.org/1999/xlink"
    id="flag-icons-gs"
    viewBox="0 0 640 480"
    {...props}
  >
    <defs>
      <linearGradient id="gs-b">
        <stop offset={0} stopColor="#d5dfff" />
        <stop offset={1} stopColor="#fff" />
      </linearGradient>
      <linearGradient id="gs-a">
        <stop offset={0} stopColor="#474747" />
        <stop offset={1} stopColor="#f50" />
      </linearGradient>
      <linearGradient
        xlinkHref="#gs-a"
        id="gs-c"
        x1={109.3}
        x2={110.9}
        y1={218.5}
        y2={173.4}
        gradientTransform="matrix(1.178 0 0 .50849 388 38.3)"
        gradientUnits="userSpaceOnUse"
      />
      <linearGradient
        id="gs-d"
        x1={125.9}
        x2={126}
        y1={316.4}
        y2={337.2}
        gradientTransform="matrix(.96067 0 0 .6235 388 38.3)"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset={0} stopColor="#b50000" />
        <stop offset={1} stopColor="#ffc500" />
      </linearGradient>
      <linearGradient
        xlinkHref="#gs-b"
        id="gs-e"
        x1={407.9}
        x2={456.4}
        y1={149.4}
        y2={147.4}
        gradientTransform="matrix(.4361 0 0 1.37349 388 38.3)"
        gradientUnits="userSpaceOnUse"
      />
      <linearGradient
        xlinkHref="#gs-a"
        id="gs-f"
        x1={215.8}
        x2={229}
        y1={103}
        y2={103}
        gradientTransform="matrix(.57794 0 0 1.03641 388 38.3)"
        gradientUnits="userSpaceOnUse"
      />
      <linearGradient
        xlinkHref="#gs-b"
        id="gs-g"
        x1={117.6}
        x2={78.2}
        y1={1040.4}
        y2={1003.7}
        gradientTransform="matrix(1.9991 0 0 .29962 388 38.3)"
        gradientUnits="userSpaceOnUse"
      />
      <linearGradient
        xlinkHref="#gs-b"
        id="gs-h"
        x1={264.7}
        x2={255}
        y1={246}
        y2={226.4}
        gradientTransform="matrix(.69142 0 0 .86628 388 38.3)"
        gradientUnits="userSpaceOnUse"
      />
    </defs>
    <path fill="#006" d="M0 0h640v480H0z" />
    <path
      fill="#6a4c2d"
      stroke="#000"
      d="M471 345s-2.6 6.8-4 6.8c-1.6 0-7-3-7-3s-3.9 6.4-6 6.7c-2 .4-7.4-.9-7.4-.9s-5.2 0-5.4-.7c-.2-.8.2-2.3.2-2.3s-7.5 6-9.1 5.6c-1.7-.3-7.3-7.4-7.3-7.4l-1 3.7-10.6-.4-9.3-6s-5.2 8.6-5.4 8.4c-.2-.1-9.1 2.1-9.1 2.1l-.6-1.7-6-3.5s4.7-6.5 4.7-6.7c0-.2-2.2-1-2.2-1l-3.4 2.8-6.9 4.5-6.9-3.2 3-5.6.4-4 5.4-8.3 66.2-64.3 32.6 60.2z"
    />
    <path
      fill="#fff"
      stroke="#000"
      d="m518 348.8 17.3-.6-7.4-3.6 65.7-2.5-9.3-3.5-8.2-11.2-34-2.5s-2.6-2-6.7-1c-.2-2.6-3.4-6-3.4-6l-21-1.7-13 9 8.8 22.6z"
    />
    <path
      fill="url(#gs-c)"
      stroke="#000"
      d="m451 156 1.8-6s3-5 3-7.4c0-2.2 2.3-4.9 2.3-4.9s6.9-2 8.4 2.3c7.4-11.3 16.2-.6 16.2-.6l2.4-2.8 5-6s7 6.5 7 7.6c.2 1.2 1.3.4 1.3.4l7.6-.6a9 9 0 0 0 2.9 8.2c2.7 1.6 5.1 11 5.1 11z"
    />
    <path
      fill="#656263"
      stroke="#000"
      d="M518 226.1c1.4-.8 5.5-2.1 5-8.2-.5-6-5.7-6.8-8.7-6.6-3 .2-5.5 2.8-5.5 2.8l-9.8-6.2s4.9-30.7 10-32.6c5-3.5 5.8-5 5.8-5.8 0-.9-1.8-2.9-1.8-2.9l-31.7-3.7-30 3.5s-2.2 3.6-2 5c.4 1.4.5 2.9 5.8 7 6 4.6 10 30.8 10 30.8s-8.3 4.2-8.9 3.6c-.5-.5-3-1-4.3-.8-1.3.2-5.7 2.5-5.7 8.2 0 5.8 4.4 9.1 4.4 9.1s28.6-3.3 32.9 4.6c4.1-9.5 31.3-6.2 34.6-7.8z"
    />
    <path
      stroke="#000"
      strokeLinejoin="round"
      d="M548.9 194.2s.3-3.3 2.7-4.9c2.4-1.6 18.2-2.4 22 0 3.8 2.4 5.2 14.1 5.2 14.1s2.4 4.1 2.6 7.2c.1 3 .5 5 .5 5s12.6 16.5 12.8 31.4c1.4 10.1 1.1 37.2-2.9 47.5a43.4 43.4 0 0 1-5.5 21.3s1.3 2.2 1.1 4.6c-.2 2.3-1.4 4.6-1.4 4.6l18.5 9.1-6.8-2.5 6.8 5.7-7.7-3.6 4.5 4.6c-.1-.2-11.2-5.1-11.2-5.1l5 4.7-8.5-4s5 5.5 5 5.2a91 91 0 0 0-7.4-3.2l.4 2.7s-5.8-.3-5.8-4.6a19 19 0 0 1-4.7-3.8l-13.2-2.2-14.9-44.6 3.5-75.2 1-3.8z"
    />
    <path
      fill="#fb0"
      stroke="#000"
      d="M539 434.8s-7.7-16-11.5-16.3c-3.4-6.6 12-60 41.7-63.1 16.3 1.3 1.3 18.8-9.4 13.4a44.7 44.7 0 0 0 6.7 11.5s-21.3 9.2-27.6 54.5zm-102.3 2.3s6.3-18.3 10.1-18.5c3.9-.2-10.1-60.9-40.6-61.3-16.4 1.3-1.3 18.9 9.5 13.5a44.8 44.8 0 0 1-6.8 11.5s21.5 9.2 27.8 54.8z"
    />
    <path
      fill="#00713d"
      stroke="#000"
      d="M464.6 323c0-.2-7.6 2.3-2.7 10.5.3-3.2 3.7-5 3.7-5s-5.1 6 .3 11.1c.7-4.8 3.8-6.3 3.8-6.3s-3.9 11.2 0 13.5c.5-4.5 3.3-6.5 3.3-6.5s-3.4 10-.3 12.3c.3-3.8 2.9-5.5 2.9-5.5s-1.5 10.5 2.5 11.2c0-3.7 3-7.3 3-7.3s-1.3 8.5 5 8.9c0-3.2 1.2-6.9 1.2-6.9s2.9 9 7 7.6v-7.7s2.7 8.6 7.7 7c-.7-2.4.3-5.3.3-5.3s2.6 5.4 7.4 3.6c.8-1.6-.2-4.8-.2-4.8s7 7.2 9 2.9c2.2-4.3-5.5-5.8-5.5-5.8h5.2s-1.7-4.4-8.7-5.4c2.4-1 4.9-.2 4.9-.2s-1.5-5.5-8.7-6.1c2.8-1 6-.3 6-.3s-1-5.2-9-6.7c1.3-1.4 4.7-1 4.7-1s-3.2-4.9-6.8-4.6c-3.6.3-36-3.3-36-3.2z"
    />
    <path
      fill="none"
      stroke="#3ec26d"
      strokeLinecap="round"
      d="M496.6 349.5s3 1.4 2.8 2.6m-1.1-4.9s3.7 2.6 3.6 4.5m-.3-5.8s2.9 1.8 3 4.7m1.9-3.6s1.4 3.2 1 3.8m1.9-2.1c.2 2.5-.2 2.8-.2 2.8m-36-18.5s3.5 2.2 3.2 5.3m-3.4-2.7s1.6 1.6 1.3 2.6m3-5.2s2.3 3.2 1.5 5.4m2.4-3.3s1 2 0 3m1.8-2.1s1.2 2 .1 2.7m-1.5 3.9s3.2.7 3.7 3.1m-1.8-5.3s3.4.2 3.8 3.8m.7-5.1s2.3 4 1.9 5.2m2.4-4.8s.9 3.7.2 5m2.6-3.5v4.3m-4.2-10.2s2 .8 2 2.9m-.1-4.8s2.7 1.5 2.5 4.5m.7-5.7s2.3 2.7 1.5 5.8m2.5-5.2s-.8 3.5-.4 4.9m3-2.5s-1.5 1.1-.7 2.6m-12.7 10.8s.5 2.6 0 3m-3.3-4.6s1.6 3 1 4.4m-4.6-4.5s1.9 2.2 1.8 4m-4.8-3.6s1.8 1.7 1.6 2.7m-3.1-.1s1.7 1.8 1.6 2.1"
    />
    <path
      fill="#fff"
      stroke="#000"
      d="m441.3 229.3 24.3-.5s16 0 17.7 5.2c3-6.9 17-6.5 17-6.5l25-.8.5 60.6c-5 23.6-22 40.2-40.7 47.3a62.3 62.3 0 0 1-41.2-47.7l-2.6-57.6z"
    />
    <path
      fill="#006b00"
      stroke="#000"
      d="m450 229 35.3 94.2 32-96.2c-10 .6-31.2-1.6-33.9 7.5-4-8.1-26.4-4.9-33.5-5.5z"
    />
    <path
      fill="#ffc900"
      stroke="#006b00"
      strokeLinecap="round"
      strokeWidth={0.5}
      d="M474 280c1.4.7 1.3-25.5 3.1-26.3l1.4-5.5c-1.5-2.7-8.4-2.6-11-.2l1.7 4.8c3.5 5.6 2.8 27.8 4.8 27.2z"
    />
    <path
      fill="#cdad56"
      stroke="#000"
      strokeLinejoin="round"
      d="M464.5 77s2.5-2.9 2.6-3.5c.2-.7 11.4-1.2 18-13.7 3.8-6.5 0-2.7 0-2.7L485 54s4.6-4.4 3-6.8c-1.8-2.4-1.2 3-4 3-2.7-.1-1.2-6-1.2-6s-.2-.6-1-1c-1.1.2-.8 2.2-1.8 2.4-1 .3-2-4.7-2-4.7s-1.7-2.3-3.1 4.8c.8 7.7 5.6 6.2 5.6 11.2 0 5-4.3 8.8-5.5 9-1.3 0-.8-4.3-.8-4.3s-.7-2-1.1-2c-.5 0 2.5-.5 2-6.1-1-6.8-1.8 1.6-3.6 1.2-1.9-.3-.5-6.2.2-7 .7-.6-.8-3.4-4.8 3.8-.3 3.6-.8-.9-1.6-.6-1.3 2.8-1.1 4.8.8 7.4 2.9 2.7 4.7 5.3 4.6 6.6-.1 1.4-1.6 4.5-3.7 4.5-2 0 .1-3.8 0-5 0-1.3-3.5-5.8-3.5-5.8s-2.4-3.9-2.1-4c.2-.1-.3-.7-1.4 3.3-1.1 4-2.5-2.6-2.5-2.6s-1.6 4.9 1.8 7.8c-2.6-.3-2.8.7-2.8.7 0 1.4 3.5 2 4 4.3.4 2.4-3.7 3.8-3.7 3.8s1.7 2.3 6.5-2.3c.1 3-1.8 5-1.8 5 1.6.7 2.8.6 3 2.5z"
    />
    <path
      fill="#cdad56"
      stroke="#000"
      strokeLinejoin="round"
      strokeWidth={0.9}
      d="M449 77s-2.2-3.2-2.3-3.8c0-.6-10.4.8-15.3-11.8-3.2-6 0-2.5 0-2.5l.2-2.9s-3.4-4.1-2-6.3c1.5-2.2 1 2.8 2.8 2.8 2.3-.1 1-5.4 1-5.4s.2-.6 1-.9c.9.1 1.3 3.2 2.1 3.4.9.2 2.7-3.6 3.3-4.4.8-.1.7-3.2 2 3.3-.7 6.9-6.4 5.5-6.4 10 0 4.6 3.6 8.1 4.7 8.2 1 .2.7-3.8.7-3.8s.6-1.8 1-1.8c.3 0-3.4.7-3-4.5.8-4.8 2.7.3 4.3 0 1.5-.3-.2-5 .2-5.8.1-.8 2.4-3.9 3.3 3 .3 3.3 2-2.7 2.7-2.5 1.2 2.6-.5 6-2.1 8.4-2.4 2.4-3.5 5-3.4 6.2 0 1.3.6 2.8 2.4 2.8 1.7 0 .5-2.2.6-3.3.1-1.1 3-4.8 3-4.8.6-1 .1-2.6.7-3.4 1 0 1.4-1.3 2.3 2.3 1 3.6 2.1-2.4 2.1-2.4s1.4 4.5-1.5 7.2c2.2-.3 2.4.6 2.4.6 0 1.2-1 1.7-1.4 4a3.7 3.7 0 0 0 1.1 3.3s-1.4 2.2-5.5-2a7 7 0 0 0 1.6 4.5c-1.4.7-2.4.6-2.6 2.3z"
    />
    <path
      fill="#ffc900"
      d="M511.3 243c-2-1.8-2.3-.2-3.4-.6-.5-.2-.9-.7-1.3-1.1-.4-.4-.9-.6-1.4-.8l-.6 1.7c-.2.6.6 1.5.6 2.4-.2 1.3-.7 2.3-2.3 2.7.5-.9.7-.9.6-2 0-.5-1.6-1.5-1.4-2 .2-.9.7-1.8.4-2.7-.7.5-1.5.2-2.2.5-.5.3-.6 1.3-1.3 1.7-.8.4-2.5.2-4-.6.9-.7 1.6-.2 2.5-1 .4-.2.4-1.7.9-2l1.9-1c-.4-.5-.4-1.2-.8-1.6-.4-.5-2.1-.4-2.5-.8-.8-1-.7-2.1-1.4-3 2 .7 1.7 1.7 2.2 1.6 1-.5 2-.5 2.5-.3s1.4 1.5 2 1.7l.6-1.9c.2-.6-.8-1.5-.7-2.1.4-1.1 1.4-2.1 1.8-3.3l.4 3.1c.1.6 1.2.9 1.2 1.4.1.6-.5 1.8-.5 2.4.6-.1 1.5 0 2-.2.7-.1 1-1.5 1.6-1.6 1.2-.2 2-.1 3.3 0-1 .9-1.6.8-2.1 1.6-.5.3.1 1.4-1.1 2.2-.5.3-1.8 0-2.2.3l1.2 1.3c.4.5 2.1.7 2.5 1.2.8.8 1.2 2 1 2.9zm-54.3 1c2-1.9 2.3-.2 3.4-.7.5-.2.9-.6 1.3-1 .4-.5.9-.6 1.4-.9l.6 1.8c.2.5-.6 1.5-.6 2.3.2 1.3.7 2.3 2.3 2.8-.5-1-.7-1-.6-2 0-.6 1.6-1.6 1.4-2.1-.2-.8-.7-1.8-.4-2.6.7.4 1.5.2 2.2.4.5.3.6 1.3 1.3 1.7.8.4 2.5.2 4-.6-.9-.7-1.6-.2-2.5-.9-.4-.3-.4-1.8-.9-2-.4-.4-1.5-.8-1.9-1.1.4-.5.4-1.2.8-1.6.4-.5 2.1-.4 2.5-.8.8-1 .7-2.1 1.4-3-2 .7-1.7 1.7-2.2 1.6-1-.4-2-.5-2.5-.3s-1.4 1.5-2 1.7l-.6-1.9c-.2-.5.9-1.5.7-2-.4-1.2-1.4-2.2-1.8-3.4l-.4 3.2c-.1.5-1.2.8-1.2 1.3-.1.6.5 1.9.5 2.4-.6-.1-1.5 0-2-.2-.7 0-1-1.4-1.6-1.6-1.2-.2-2-.1-3.3.1 1 .8 1.6.8 2.2 1.5.4.4-.2 1.5 1 2.2.5.3 1.8 0 2.2.3l-1.2 1.4c-.4.4-2.1.6-2.5 1-.8 1-1.2 2-1 3z"
    />
    <path
      fill="#ffc900"
      stroke="#006b00"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeWidth={0.5}
      d="M509.4 249.2c-1.9 1.5-14.3 4.6-14.4 15.3-.1 10.8 2.2 13.2-.1 13.5-4.5 0-5.1-12-5-17.3.1-5.3.3-4.5.3-4.5s3 .8 2.8 3.4c-.3 2.6 3-6.4 1.9-8.8 2 2 4.7 1.2 4.7 1 0 0-1.5-1.7-2.2-3-.6-1.1 2.3.8 2.3.8s.2-2-2.4-2c-3.3 0 .5-1 .5-1s2 1.7 3.2-.2a11 11 0 0 0-3.4-2.3s-1.8-3.4-4.2-4c-2.8-.7-2.5 1.2-5.7.9-.6 1.2-.6 1.4.7 1.8-2.2 1.5-1 4.4-1 4.4s3.4-1.4 3.3 1c-.1 2.5-2 2-3.3.5-1.2-.6-1.6.7-1.6.7l1.8 2s-3.4-.2-4.3 2.1c1.9-.1 3 .4 3 .4s-4 1.8-4.4 2.7c-.4 1-.5-1-.7-1l-3.8-1.4-1.3 5.9s2.6 2.5 4 1.7 4-3.3 5.5-2.6c-4.5 3.4-9 8.3-11.4 9-.6-.6-2.8-2.7-3.7-1.6-.9 1-.2 2.4 1 2.3 1-.2-3.8 1-2.8 3.1 1 2 1 1.9 1.8 1.4 1-.6-.7-.7 2.6-1.7s3.2-1.9 3.2-1.9-.7 1.5-2.5 2c-1.7.3-3.1.3-2.8.9.4.5 1.2 1.5 1 2-.3.6 3.6-2.8 4.7-.1 2.6-.2 4.4-3.4 3.1-5.3.2 2 1.4 2.7.7 3.7-.8.9 6-3.2 2.7-5.6.8 2 1 3.6 1 3.6s1.5 0 1.9-.6c.4-.6-.8 1.5-.3 1.9.5.4 3 2.7 2 4.3-.7-1-.8-2.4-1.6-2.3-.8.1-4 2.5-5.9 2.6-1.9.1 2.3 7 2.3 7s-2.9-.3-3.3 0c-.4.2-2.3-2.5-2.6-.9-.7 2 .6 1.2.6 1.2s-1.7-.8-2.6.2c-.9 1-1.7 1.9-1.1 2.3.6.4 3.4.4 3.8.3.4-.2-3.2.2-3.4.6-.3.4-.8 2 0 2.5.7.5 2.7-.3 2.8-.7.1-.4.2 1.5.2 1.5s3.3.3 3.3-3.1.3 2.4.3 2.4 3.3.6 3.4-2.8c.2-3.4.4 2.3.4 2.3s2.2-.7 2.2-1.2c0-.6-.1 6.7-1.7 8.8-2.4-1.6-4 1-4 1s.2 4 0 5c-.3 1 1.6-.6 1.7-1 .2-.4 2.5-1.5 2.6-1.7l.8-1.7s-.6 2-1.4 2.2c-1 .3-1.8 1.2-1.4 2 .3.9 1.7 1.4 2.2 2.2.6.8 2.3-4.7 2.3-4.7l.2 1.2s2.3-.6 2.5-1.7c.3-1-2.4-2-.2-3.8 2.1-1.7 0 1.7 0 1.7s.7 2.6 1.2 2.6c.6 0 1.8-5 .6-6.2-1.3-1.2 1.9 1.5 1.9 1.5s1.8-5-.2-5.7l-2.8-1s1-1.3.5-1.4c-.5-.2 2.7 3 3.2 2.1.5-.8 1.3-3.2-2.4-4.6-3.7-1.3-.1-5.1-.1-5.1s2.3 2.7 4 1.2c1.6-1.5-.2-1.5-.2-1.5s4.7-3 4.9-4.5c-1-.1-2.5.1-2.5.1s2.7-1.7 2-4.6c-1 1.5-2.4 1.5-2.4 1.5s2.3-2.3 2-4.5c-1.4 1.1-1.3 2-2.2 1.7-.9-.3-2.4-8.9 1.1-9.4 3.6-.6 1.7 4.2 1.8 4.2.2 0 5.4-2.2 0-5.7 1.3-.4 4 2 4 2s-1.2-6-7-2.3c1.5-1.5 2.4-2.4 3.5-2.2 1.2.3 5.3-.1 5.3-1.3-1-.8-3.2.4-4.4 0-1.1-.4 8.2-1.1 7.4-5.7z"
    />
    <path
      fill="none"
      stroke="#006b00"
      strokeLinecap="round"
      strokeWidth={0.5}
      d="M469 252.7s5.1-2.9 7.6.7m2.1 5.4c-.1 0-1.8 1.8-2.2 1.8m5.6 3.9s4.8.4 7.8-4.6"
    />
    <path
      fill="none"
      stroke="#006b00"
      strokeLinecap="round"
      strokeWidth={0.5}
      d="M487.2 263s.4 2.7 1.2 2.7c.7 0-1.3.7-2 .2.8 1.2 1.3 3.4 0 4.2"
    />
    <path
      fill="#e80000"
      stroke="#006b00"
      strokeLinecap="round"
      strokeWidth={0.5}
      d="M484.8 297.3s-1.6 1.9-3.7 2"
    />
    <path
      fill="none"
      stroke="#006b00"
      strokeLinecap="round"
      strokeWidth={0.5}
      d="M486.7 288.6s-1-5.5-.4-6.8c.4-1.8 2-2.5 3.4-4.8"
    />
    <path
      fill="none"
      stroke="#006b00"
      strokeLinecap="round"
      strokeWidth={0.5}
      d="M486.2 284.6s-1.3 3.3-6.9 2.2m8.4-10.3s.4 4.3-4.7 2.7m-1.5-22.2s-2 1.8-1.3 4.4"
    />
    <path
      fill="#006b00"
      d="M489.1 252.1s2.7-1 3.2-1.6a8 8 0 0 0 1.7-2.4c.2-.8-1.8-2-.8-3.8.7-.9 1.6-1 3 0 1.6 1-1.3-3-2.8-3.2-1.6-.1-2.6 1.1-3 .8-.4-.2.1 1.1-.5 1.1s1.3 1.1 1.2 1.8c-.2.7 2 3 1.9 3.5-.2.6-3.2 3.7-3.9 3.8z"
    />
    <path
      fill="#ffc900"
      stroke="#ffc900"
      strokeLinecap="round"
      strokeLinejoin="round"
      strokeWidth={0.5}
      d="M491 243.2c1.2-.3 1.4 0 1.2 1a3 3 0 0 1-1.1-1z"
    />
    <path
      fill="#e80000"
      stroke="#006b00"
      strokeLinejoin="round"
      strokeWidth={0.5}
      d="M483 303.7s-.5 2.9.5 3.1c0-1 .3-1.8.5-2.1l-1-1zm-2.5-3.5c-1-.1-2.5.8-2 1.8.7-.7 1.4 0 2-.7v-1zm0-2s-1.5-.2-1.7.9c1-.2 1.4-.3 1.7 0v-.9z"
    />
    <path
      fill="#e80000"
      stroke="#006b00"
      strokeLinejoin="round"
      strokeWidth={0.6}
      d="M474.1 282.2s1 .3 1.2 1.3c.7-.4 1-2.6-1.2-1.3zm-2.3 2.4s2-1.2 2.1 0c-.4.3-.5.6-.8.7-.3 0-.8-.8-1.3-.7zm-.1 3.9s1.2-1 1.6-.4c.5.8-.4.7-.4.7l-1.2-.3zm-1.7-21.9s-1.5-.6-2.1.5c1 .2 1.3.5 1.8.9-.2-.5-.4-1.2.3-1.4zm-2.9 8.3s0-1.9 1-2.6c.4.3.5.7.8 1.2-.6.2-1.4.2-1.8 1.4zm3.9-1.3s-1.6.8-1 1.7c.5-.7 1.1-.5 1.1-.5v-1.2z"
    />
    <path
      fill="#ffc900"
      stroke="#006b00"
      strokeLinejoin="round"
      strokeWidth={0.6}
      d="M468.7 255.8c-.6.7.7 2.2 2.1 2 .4-1.6-1.7-2.5-2-2z"
    />
    <path
      fill="none"
      d="M468.7 252.6c-.3.8.9 1.9 1.5 1.6.3-.8-1.2-2.2-1.5-1.6z"
    />
    <path
      fill="#e80000"
      stroke="#006b00"
      strokeLinejoin="round"
      strokeWidth={0.6}
      d="M470.2 254.6s.3 1.3 1.5 1a4 4 0 0 0-1-1.9c0 .3.1.8-.5.9zm.8 3.7s.7.8 2-.7c-.6.1-1.6-.4-1.6-.4s0 1-.4 1.1z"
    />
    <path
      fill="#ffc900"
      stroke="#006b00"
      strokeLinejoin="round"
      strokeWidth={0.6}
      d="M468.6 252.8c-.5.7.3 1.7 1.7 1.5.3-1.7-1.3-2-1.7-1.5z"
    />
    <path
      fill="url(#gs-d)"
      d="M469.2 246.3s5.5-1.6 8.4.8c3 2.3 3 .2 3 .2s4.2 1.6 5.4 1.2c1.2-.3-.9.2.8-.9 1.7-1-3.4.3-3.8-1.9-.8-1.3 0-3-1.7-2.4-1.2-1.6.8-2.7.3-4.4-1.2 1-1.9-.3-2.9 2-2.3-.5-.3-3.8-2.9-4.1 0 2.3-1.9 2.4-2 3.8-1.1.8-6 3.7-4.6 5.7z"
    />
    <path
      fill="#c01500"
      stroke="#000"
      d="M406 425c3.6-1 22.9 4.2 30.3 12.2-1.6-14.3-5.5-25.1-5.5-25.1s-11.5-3.3-13-1.7a80.8 80.8 0 0 0-11.8 14.5zm-5.9-65.7c-1.3.2-2.7 1.1-4 3.4-1.6 3.8-2.7 13.5-5 15.8-2.2 2.2-4.3 2.4-4.3 4.5 0 2 .3 6.7 6.3 8.5 6.1.3 15.8-9.7 15.8-9.7s5-5.4 7-11.2c-11.7 4-20-6.8-15.8-11.3zm169.6 63.4a53 53 0 0 0-30.4 12.1c1.6-14.1 5.5-25 5.5-25 1.3-.3 11.3-3.2 12.8-1.6 2.3 2.4 9.7 9.7 12.1 14.5zm5.5-65.3c1.3.2 1.8 2 3 4.2 1.5 3.9 3 9.4 5.3 11.6 2.3 2.3 4.3 5.6 4.3 7.6s-.5 4.8-6.5 6.6c-6 .2-14.8-7.6-14.8-7.6s-5-5.3-7-11.2c11.7 4 19.2-6.3 15.7-11.2z"
    />
    <path
      fill="#fb0"
      stroke="#000"
      d="M393.4 412.5s12.1 8.4 12.4 12.2c32.7-48.5 116.1-63.6 163.7-3.4 6.3-8.3 12.8-11 12.8-11-50-65.4-149.7-57.3-189 2.2z"
    />
    <path
      fill="#1e5aa6"
      stroke="#000"
      d="m517.4 227 4.8-.1-8.5 10.8 10.2 11.9-20.1 25.3 19 22.8a57.9 57.9 0 0 1-7.8 14l-10.9-12L524 275l-16.2-18.4zm-68.1 2.2h-5l9.5 10.4-10.1 12.6 21 22.8-17.4 23.3c2 5 5 10.8 8.3 15l10.3-13.1-21.2-23.6 15.5-19.7z"
    />
    <path
      fill="#1e5aa6"
      stroke="#000"
      d="m473 290.4-7.6 10 26.8 31c4.8-2.4 8.5-5.1 12.5-8.4l-14-16.1 5.7-16.7 8.2 9.4-25.5 32.6c-4.3-1.8-9-4.6-13.3-8.2l13.5-17.1zm-8.3-15.5 4.8 6.1-3.1-8.3zm34.9 5.4 4-5.2-1.5-2z"
    />
    <path
      fill="none"
      stroke="#fff700"
      strokeLinecap="round"
      d="M556 195s4.8-4 8.1-4"
    />
    <path
      fill="none"
      stroke="#fff700"
      strokeLinecap="round"
      d="M556.7 194.5c.1-.1 28.1-4 29-5m-28.9 5.2 31.4-2.7m-31.5 2.8s33.3-1.5 35.3.2"
    />
    <path
      fill="none"
      stroke="#fff700"
      strokeLinecap="round"
      d="M556.6 194.7s32.6.3 33.2 1m-33.1-1 31.4 2.6m-31.7-2.3s32 2.8 35 6.8"
    />
    <path
      fill="none"
      stroke="#fff700"
      strokeLinecap="round"
      d="M593.1 207.5c0-.1-10.8-12.9-36.8-12.7"
    />
    <path
      fill="none"
      stroke="#fff700"
      strokeLinecap="round"
      d="M556.4 195s18 1.3 23.7 7.6"
    />
    <path
      fill="none"
      stroke="#fff700"
      strokeLinecap="round"
      d="M556.7 194.8s11.7-2.2 23.9 12.5"
    />
    <path
      fill="url(#gs-e)"
      stroke="#000"
      d="M549.4 208.2s16.1.6 16.1 2.2-12 4.6-12.2 11.2c-.1 6.7 9.2 7.2 9.9 15.6.6 8.4-7.3 9.6-9 11.9-1.5 1-5.3 13-4.8 20 .5 6.9 2.5 30.5 6.2 35.3 2.8 2.2 7 9.3 11.7 7 4.6-2.1 1.4-10.2 1-12.4-.5-2.2 1.8-5.9 1.8-9.2 0-3.4-1.7-6-1.5-6.8.1-.8 12.8 3 12 15.5-.8 12.5-5.9 8.7-5.9 8.7s1.6 15.4-2.3 17.4c-7.2 3.8-12.4-.8-12.4-.8l.7 3.2-5.5-2.8s-7-10-8.5-14.5a126 126 0 0 1-2.9-28.5c.7-4.3 1.1-29.3.8-30.6-.3-1.2-1.6-22.1-.8-25.3.8-3.2 5.7-17.1 5.6-17.1z"
    />
    <path
      fill="#ff7000"
      stroke="#000"
      d="M532 204s11.2-10.9 17.7-9.6c3.3 0 .2 2.4.2 2.4s5.7.4 6.5 3c.1 1-2.7 1.4-2.7 1.4s2.3.5 2.5 2.5c.2 2.1-24 .5-24.3.4z"
    />
    <path fill="none" stroke="#000" d="M532.6 203.6s12-1.6 17.1-6.7" />
    <path fill="none" stroke="#000" d="M544.8 200.3s8.9-.4 8.9 1" />
    <path
      fill="#fff"
      stroke="#000"
      strokeLinejoin="round"
      d="M576.3 329.9s7.6-1.8 9.7-4.5c1.2-1 7.9 10-9.7 4.5z"
    />
    <path
      fill="none"
      stroke="#fff"
      strokeLinecap="round"
      d="M574.3 267s1 5.8-1.8 9.8c-1.4 1.6-5.7 4.3-5.7 6.2 0 1.9 1.6 4.4 1.3 6.6-.3 2.2-2.7 4.5-2.6 6.4 0 1.9 2.7 12 2.4 12.2m-7.6-60.2s-6 2-7.3 8"
    />
    <path
      fill="#c75b00"
      stroke="#000"
      d="M557.8 200.3s2 5.7 8.7.3c-4.3-5.9-8.7-.2-8.7-.3z"
    />
    <path d="M562.7 200c0 .3-.3.6-.7.6-.4 0-.7-.3-.7-.6s.3-.5.7-.5c.4 0 .7.2.7.5z" />
    <path
      fill="#fff"
      stroke="#000"
      d="M503.4 187s12.6 13.7 20.7 13.5c1.5 4-3.7 7.8-5.7 9.5-4.2-1.3-8 .3-17.6-11.6.6-7.6 2.7-11 2.6-11.4zm17-31.8c1.7-5 5-9 7.8-9.5-.8-3.8 5.9-20.9 25.3-27.4 1.2 8.7-8.3 17.4-8.3 17.4s28.7-5 34.5-12.2c-.6 3.2-6.4 23.6-37 23.4 11.6 11-3.7 19.8-10.2 17.1 12-9.2-3.5-14.7-12-8.8z"
    />
    <path
      fill="#cccccd"
      stroke="#ccc"
      d="M530.2 148.1c5.8-3.7 7.9-3.7 12.7-3l-3.5.6s-.3.5 1.8 2.4c-2.4-.6-4.4-2-11 0z"
    />
    <path fill="none" stroke="#000" d="M528 145.7s11.4-6 17.8-10.2" />
    <path
      fill="#00f"
      stroke="#000"
      d="M518.2 210s15.7 4.3 17.5-18.2c-3.4-9.8-8.1-31-.9-37-6.6-4.6-14 .2-14 .2-.4 1-6.3 9.5 1.7 24.3-19-5-11.3 13-11.3 13 .8-3 10.9-5.6 13.4 8.8 1 3.6-6.8 9-6.4 9z"
    />
    <path
      fill="#00f"
      stroke="#000"
      d="M535.9 192s16.6-9 16.2-30c-14.2.4-19.2 18.6-19.2 18.6z"
    />
    <path
      fill="#fff"
      stroke="#000"
      d="M461.3 190.9s-12.3 10.7-19.3 7.3c-5.1 3-11.2-2.4-11.2-2.4s7 26.3 32.6 7.3a60.5 60.5 0 0 0-2-12.2z"
    />
    <path
      fill="#00f"
      stroke="#000"
      d="M441.9 197.7c1-5.5 5.3-8.2 8.8-3 4.6 1 9.2-18-7.2-14.8 4.6-24.7-9.2-33.9-9.2-33.9s-4.9 27.4-2.6 32.4c2.2 5-3.3-9.3-21-13.4-.3 20.7 19.8 30.3 19.8 30.3s5.6 5.2 11.4 2.4z"
    />
    <path
      fill="none"
      stroke="#000"
      d="M443.5 179.7s-7.7 6.6-6 15.5m-5.7-16.3s-1.8 6.3 2 15.4"
    />
    <path fill="none" stroke="#000" d="M430.6 196.4s3.6-5.8 11.3 1.6" />
    <path
      fill="#fff"
      stroke="#000"
      d="M432.1 156.3c0-.2-11.7 0-4.8 11.9-5.1 1.6-16.7-6-8.7-16-26.3-.7-37-13.3-37-24.9 7.7 8 26.2 4.8 32.7 9.7-8-7.4-6.4-17.7-6.4-17.7s22.4 6.7 26.4 26.6c-1.3 3.9-1.9 10.7-2.2 10.4z"
    />
    <path fill="none" stroke="#000" d="M414 136.5c4.4 4.4 15.5 5.7 21.1 10.6" />
    <path
      fill="#cccccd"
      stroke="#ccc"
      strokeWidth={0.7}
      d="M419.2 149.5s9.2-1.2 11.9 2c-3.6 0-4.8-.9-10 1 1.4-.7 1-2 1.8-2s-3.3-1-3.7-1z"
    />
    <path
      fill="#923f00"
      stroke="#000"
      d="M465 77.5s5.1-4.5 10.6-.5c-2.5 7.4-11.4 4.6-11.4 4.6s.3 3.7-.6 5.5c1.8 1.4 3.2 5.8 3.2 5.8s9.2-2.2 11.2 1.8c3.5-.5 6 0 6 0s7.2-1.8 9.7-1.8c2.5 0 10.5 2 11.3 3.6.7 1.4 3.4 11.4 5.2 11.2 1.8-.1-4.3 2.4-6-.1-1.6-2.5-1.1 3.3-1.1 3.3s5 5.3 5.6 6.5c.6 1.2-3.1 10.8-.3 17.5-2.5.2-2.7 2.8-2.7 2.8-.1 3-3.8 3.7-3.8 3.7l-1-4-2.4 1.5 1-3.1s3.4-8.3 3.7-11c.3-2.7-3.1-7.4-5.8-7.4-2.7 0-4.6 8.5-4.6 8.5s-1.3 6.3-.9 7l-1.8-2.1s-1.1 3.8-2 5c-1 1.2-2.9 1.6-2.9 1.6s-1.3-3.8-.8-5.3c.4-1.5 7.2-7.3 6.6-11.4-.6-4.2 0-3.2-.1-3.3-.2-.2-3.6-3.1-3.7-4.8-.2-1.6-4.5 2.1-10.1 1-1.7 3-2 10.5-2 10.5s-.5 9 .6 10c1.2 1.1-3 3.3-3 3.3l-2.9 4-1-2.3-2.1 1.5 1.2-3c-.1-2.3 2.9-8.4 2.9-13.6 0-5.2.3-10.8.3-10.8s-5.4-.3-5.3 5.4c.1 5.6-1.3 6-1 7.5.3 1.7 1.7 6.3 1.3 7.6-.4 1.4-2.2 1.8-2.2 1.8l-.5.7s-5.5 2.6-5.3 3.6l-.2-3-.3-4.3s3.3-2 3.3-7.2-.7-6-.6-7.2c.1-1.2.9-5.5.7-6-.1-.4-3 1.3-4 1.3-.9 0 1.7-3.1 2-5.4.3-2.2-3 2.1-5.7-.4 1.3-2.7 3.1-3.6 3.4-5.6.3-2.1-2 1.7-4.1.2.2-2 2.2-3.7 2.2-3.7s-1.7-.2-2.4 0c-1.3-.4 1.5-2.5 1.7-5.5.1-3-1.7-4.1-1.7-4.3 0-.1-3-2.6-3.4-3.7-.4-1-.4-2.2-.4-2.2s-5 3.6-10.7-4c5.3-4.5 11-1.2 11-1.2s1.5-4.2 8.3-3.9c6.8.3 8.2 4.2 7.9 3.8z"
    />
    <path
      fill="#00f"
      stroke="#000"
      d="M502.4 154.2c.1 0 12.6.4 12.7 7.1.2 6.7-3.8 5-4 5l-9-1.2z"
    />
    <path
      fill="#fffeff"
      stroke="#000"
      d="M490.3 152.4s15.6-.1 14.7 6.7c-.9 6.8-4.8 5.4-4.8 5.4l-7.6-.6z"
    />
    <path
      fill="#00f"
      stroke="#000"
      d="m481.5 151.7 9 .7s5.5.7 5.2 6c-.2 5.1-5.5 5.2-5.5 5.2l-8.8-.5z"
    />
    <path
      fill="#fff"
      stroke="#000"
      d="M460.4 154.2c-.2 0-12.6.4-12.8 7.1 0 6.7 3.9 5 4 5l9.1-1.2z"
    />
    <path
      fill="#00f"
      stroke="#000"
      d="M472.5 152.4s-15.6-.1-14.7 6.7c.8 6.8 4.8 5.4 4.8 5.4l7.5-.6z"
    />
    <path
      fill="#fff"
      stroke="#000"
      d="m481.3 151.7-9 .7s-5.5.7-5.3 6c.3 5.1 5.6 5.2 5.6 5.2l8.8-.5z"
    />
    <path
      fill="#5e0043"
      stroke="#000"
      d="M505.4 226.7s6.5-9.5 9.3-8.5c2.4.8.5 8.2-.6 8.9zm-44.4 1.7c-2.1-2.8-5-10.7-7.8-8.5-2.4.8-.6 8.2.6 8.9z"
    />
    <path
      fill="none"
      stroke="#000"
      d="M465.2 209.5s12.7 7.8 16.8 8c4.2.2 17.3-10.1 17.3-10.1"
    />
    <path
      fill="#5e0043"
      stroke="#000"
      d="m466.5 179 2.4-3 12.1 6 12.4-5.5 2.4 2.6-13.8 9.7z"
    />
    <path
      fill="#474747"
      stroke="#474747"
      strokeLinejoin="round"
      d="M456.8 178.8a51 51 0 0 1 10.3 18.7c1.4 7.9-.8-10.9-.8-10.9s9.7 4.8 10 7.8c.3 3 4.6-.2 4.8-.7l-28-18.2zm48-.5s-10.2 13.4-9 28c-2.1-7-.4-18.5-.4-18.5l-2.2 1.4s-2.4 9.9-5.3 11.4c-.5-1.2-.4-1.6-.4-1.6s-3.1 4-3.7 4.4c-.6.4.2 13.7.2 13.7s1 9.6 2.2 9.5a41 41 0 0 0-3 1.7l-1.3-25.6 2.9-2.9s3.8-4.7 4.1-9.2c-1.6 1.4-3.5 1.8-3.5 1.8s-.5 6.5-2 7.4c-1.6 1-1.6 2.6-1.6 2.6l-.4-8.5z"
    />
    <path
      fill="none"
      stroke="#000"
      strokeLinecap="round"
      d="m481.4 193.8 2 40.5"
    />
    <path
      fill="none"
      stroke="#000"
      d="M456.5 213.2s4.7 2.7 6.4 11c15.2-1.1 20 4.2 20 4.2s12.4-6 18.2-4.8c2-4.3 7.8-9.7 7.8-9.7"
    />
    <path
      fill="#b4b6b9"
      stroke="#000"
      d="m450.2 173.5 31.2 20.4 28.2-18.9s5.8-3.2 5.3-5.5c-.5-2.4-2.5-1.5-3.5-1-1 .3-29.5 20.5-29.5 20.5l-30.2-19.2s-2.2-.7-2.6.8c-.4 1.4.8 2.2 1.1 2.9z"
    />
    <path
      fill="#474747"
      stroke="#474747"
      strokeLinejoin="round"
      d="M506 168.2s-8-3.4-8-.5c0 3 .3 3.3 1.6 5.2 1.3 1.8-1 3-1 3l-.8-2c-.4-1.3-4.7-2.2-5-3.8-.5-1.5.8-3.9-1.7-4.2-2.6-.3-5.1 1-5.6 4a61 61 0 0 1-3.9 9.8l.5-15.6c5.6.4 16 1.6 24.1 2.6-2.4-.4 1 .1.8 1-.2.6-1 .7-1 .5zm-28.2-3.9a37 37 0 0 0-10.4 1.9c-1.8 1 3 2.7 2.3 4-.6 1.5-.7 4.4-3 3.8-2.2-.6-9.8-4.4-10-5.7-.3-1.2-1.8-1.3-1.8-1.3s21.8-3 22.9-2.7z"
    />
    <path fill="none" stroke="#000" d="M481.2 162.5v19.1m-14.7-41.7-9 14.6" />
    <path
      fill="url(#gs-f)"
      stroke="#000"
      d="M482.6 139.5s3.8 5.2 3.4 6.7c1.5 1.2 3.3 6 3.3 6"
    />
    <path fill="none" stroke="#000" d="M497.3 138.7s-8.2 11.6-8 12.5" />
    <path d="M455.1 83.4c-.2.6-1.2.9-2.3.6-1.1-.4-1.9-1.2-1.7-1.8.2-.7 1.3-1 2.4-.6 1 .3 1.8 1.1 1.6 1.8zm3.4-.2c.2.6 1.2.9 2.3.5 1.1-.3 1.9-1.1 1.7-1.8-.2-.6-1.3-.9-2.4-.5-1 .3-1.8 1.1-1.6 1.8z" />
    <path
      fill="#ff7000"
      stroke="#000"
      strokeLinejoin="round"
      d="M555 324s-3.2.5-3 .8c0 .3-9 .6-9.1.3-.2-.3-1.4 1.5-1.4 1.5l1.5-.9s2.2 2.3 2.8 2.1c.7-.1-.3 1 0 1.1.1.2.8-.4.8-.4l14.8-.2zm5.4 4.5-12 .4s-3.1 2.8-3.3 3.4c-.2.7 2 .9 2 .9l.6 2.3 1.6-.6s10.3 1.5 19.7-.6c4.8-1.6 5.7-3.6 2.3-4.9-3.3-1.2-10.8-.8-10.9-.9z"
    />
    <path
      fill="url(#gs-g)"
      stroke="#000"
      d="m519 353.4 21.7-1-4-3.4 59-2.4-2-4.7-66.1 2.7 8 3.7-18 .5.6 1.9-4.7-.2s5.3 2 5.4 3z"
    />
    <path
      fill="url(#gs-h)"
      stroke="#000"
      d="M543.4 232.9c-1.7-.9-9.4-2-17.9 3.6l.4 19.6s12.5-6.7 18.5-5.2c-.3-6-.3-13.8-1-18z"
    />
    <path
      fill="none"
      stroke="#000"
      d="m422.7 292.4-51.4 51m74.4-50.7-41.8 55m39.9-69.3-55.7 67.5m-1.7-.9 5.4-6.4m62.6-26.3-21.6 29.8m-.9 3.9.5 11.4m31.9-34.7-23 28.8m18.9-2.3 9.3-15.3m-5.7-2.9-11.2 12.6m7.8-24.6-7.6 9.3m-2.3-22.9s-23.3 34.1-22.9 37m20.5-41.4c-.6.3-20.1 26.2-20.1 26.2m-1.1 8.2-3.6 4.3m-4.5 6.5-5.4 7.1"
    />
    <path
      fill="#8a9396"
      stroke="#2b2b2b"
      d="M420.2 213.8s-1.6 5 0 7.5 11.5 22.5 11.5 22.5 6.8-8.3 9.3-8.5c2.4-.3 1.3 21.6 1.3 21.6s-4 3.8-6.5 3.6c-2.5-.2 6 8.6 5.8 16-.2 7.5-11.2 44.5-15.3 45.1-4 .7 1.8-6.7 1.6-8.8-.3-2-1.4-.6-2.3-2.9-.9-2.2 1.4-5.6 1-7.9-.5-2.2-2.6-1.8-2.8-3.4-.2-1.6 1.4-2 1.1-3.8-.2-1.8-2.7-1.4-2.4-3 .2-1.5.4-.8.2-3.8-.2-2.9-.7 2-3.2 2.3-2.5.2-4.5 5.9-4.5 5.9s-5 7-9.9 3.8c3 6.3.7 9-.5 9.2-1 .3 1 5-1.8 5.2-2.7.2 2 10.6-1 11.5 3.3 1.6.6 3.6.6 3.6s-7.8.7-6.1 10.9c-23-8.2-34.3-22.1-34-36.4.2-14.2 4.7-27 15.7-31.7 3.2-11.8 8.6-24.4 8.6-24.4s-.9-5.2-.2-8.6a17 17 0 0 1 3.8-6.7s-.4-8.2-.2-12.2 1.8-5.9 2-8.1c.2-2.3-.7-13.8 1.6-15.8 2.2-2 6.5-1.8 8.8-3.2 2.2-1.3 5.2-3.8 8.1-3.6 3 .2 5.4 2.3 5.4 2.3s11 0 11.7 4.2c.7 4.3-2.2 6-2.2 6s1.6 6-5.2 11.6z"
    />
    <path
      fill="#cecfcf"
      stroke="#2b2b2b"
      d="M410.4 198.2c.3.7-.5 1.8-1.8 2.5-1.4.7-2.7.8-3 .2-.4-.7.4-1.8 1.7-2.5 1.4-.8 2.7-.8 3-.2z"
    />
    <path d="M408.5 199.4c0 .4-.4.7-.8.7-.5 0-.9-.3-.9-.7 0-.5.4-.8.9-.8.4 0 .8.3.8.8z" />
    <path
      fill="none"
      stroke="#2b2b2b"
      strokeWidth={0.5}
      d="M425 206.8s2.7 12.2-.5 20.7m1.4-26s5.3 7 4.6 15.8m-4.1-17.3c.1 0 4.5 3.7 4.3 6.3m-3.3-7.9s3 2 3.6 4.1"
    />
    <path fill="none" stroke="#000" d="M426 197.2s-10.5 17-9.1 27.7" />
    <path
      fill="none"
      stroke="#2b2b2b"
      strokeWidth={0.5}
      d="M426.7 196.6s-14 8.3-16.5 35.4"
    />
    <path fill="none" stroke="#000" d="m425.2 201.6-5.6 4.2" />
    <path
      fill="none"
      stroke="#2b2b2b"
      strokeWidth={0.5}
      d="M405 233.5s7.8-32.2 21.5-36.9"
    />
    <path
      fill="#2b2b2b"
      stroke="#2b2b2b"
      d="M431.9 244.4s7.4-9.3 9.1-9c1.7.4 1.2 21.6 1.2 21.6s-5.5 4.1-6.7 4c-1.2-.2 6.2 10 6 13.7-.1 3.8-.3 3.8-.3 3.8s0-2.2-1.7-5.8c-1.8-3.7-.7-7.8-12-17-2.7-5.6 5.6 3.5 7.3 2.1 1.7-1.3-3-13.2-3-13.4z"
    />
    <path
      fill="none"
      stroke="#2b2b2b"
      d="M418.7 192s-3.1.8-3.5 2c-.5 1.4-2.3 2.6-3.3 2.2-1-.4-2.8-2-2.8-2"
    />
    <path
      fill="#2b2b2b"
      stroke="#2b2b2b"
      strokeLinejoin="round"
      d="M401 202.9s-4.7 4.6-2.4 5.2c2.3.6 4.7-3.7 4.7-3.7s0 7.3 2 6.1c2-1.1 7.7-5.2 7.7-5.2s2-.2 2.5 0c.4.1 5.3 4.4 8.6 2.8-1.9 4.8-4 5.4-4 5.4s-3.4 4.4-7.8 3.4c-4.4-1-5.5-2.8-5.5-2.8s-3.7.2-4.8-1.5l-1.6-2.6s-2 2-2.7 1c-.5-1 0-6.7 3.3-8.1z"
    />
    <path
      fill="none"
      stroke="#2b2b2b"
      d="M427.5 196.4s-8.6-2.6-11.6 1.7c-3 4.2-2.3 6.6-.7 7"
    />
    <path d="M428.8 196.1c0 1-.7 1.9-1.6 1.9-1 0-1.6-.9-1.6-1.9 0-1 .7-1.8 1.6-1.8.9 0 1.6.8 1.6 1.8z" />
    <path
      fill="#2b2b2b"
      stroke="#2b2b2b"
      d="M403.7 218.2s3.5 5.4 7.7 6.9-3 2.7-7.1 0c-3-4.2-2.2-7.2-2.2-7.2s.8-.8 1.6.3zm30.1 31.9s-9.9-13.7-12.7-14.5c-2.9-.7 2.2-1.3 5.2 1.6 3 3-.8-4.7-.8-4.7z"
    />
    <path
      fill="#2b2b2b"
      stroke="#2b2b2b"
      strokeLinejoin="round"
      d="M402.7 329.6c3.8-1 20.4 9.5 24 12.1 3.8 2.7 11.6 1 11.6 1s-3.6 2.2-5.8 2.7c-2.3.5 6.6.5 6.6.5s-21.1 5.9-42.6-5.4c-2-8.8 4.6-10.8 6.2-10.9z"
    />
    <path
      fill="#2b2b2b"
      stroke="#2b2b2b"
      d="M427 253.5s-2.9-.5-4.3-2.1c-1.4-1.7-3.4-5.7-5.5-7.4-2.1-1.6-12.6-7.4-16.4-7-3.8.4-5-.4-5.5-.9-.4-.5-2 .2-1.7 2.2.3 2-3 6.3-1.8 8.3a62 62 0 0 0 7.7 10.6c1 .3.4 4.8.4 4.8s4.8 4.9 6 5.1c1.2.3 2.5 1.2 2.3 2.4-.1 1.1-5.3 7.4-5.3 7.4s-5.5 3-5.6 4.5c0 1.7 1.4 5 5.8 6.1a41 41 0 0 0 16.8-.8c.6-1 1.6-7 1.2-7.7-.4-.6-3.3-2.4-4.8-2.2-1.5.3-2.9 1.5-2.7 1.8.1.3-2.1 1.4-2.1.3 0-1 4.4-6 4.8-5.5.4.4 6.6 1 7.8 4.1 1.1 3.1 1.1 5.4 4.4 5 3.2-.3 7.8-3.3 8.2-9.5a13 13 0 0 0-4.7-11c-1-.7-4.4-2.7-4.7-3.7-.2-1-1-4-.4-4.8z"
    />
    <path
      fill="#2b2b2b"
      stroke="#2b2b2b"
      d="M368.3 281s10.5-2.7 13.2-2.6c2.7 0 13 4.8 16 7.7 3 3 9 9.8 13 9.2 4-.6 5.2-1.4 5.2-1.4l-1.6 3s-3.2.9-4.9.5c-1.6-.4-4.8-1.5-8-4.6-3.1-3-13-11.5-21.3-10.9-8.3.6-13.1 8.8-13.1 8.8s0-4 .4-4.9c.3-.8-1.8 2-1.8 2z"
    />
    <path
      fill="#2b2b2b"
      stroke="#2b2b2b"
      d="M407 289.2s2.6.7 7 .7c4.3 0 6.6-1.9 6.6-1.9l-.3-1.7.7-2.3s3.3 3.3 3.3 4c0 .7-1.4 1-1.4 1l-.5-1.7-1.1 1.5s-6.3 5-9.8 4.2c-3.4-.7-6.6-3-5.7-3.5.9-.5 1.3-.3 1.2-.3zm-15.3 8.8s-3.8 0-5.5.8c-1.7.8-2.3 1.8-3.5 1.7-1.1-.2-2-1.6-1.7-2.2.5-1 2.8-2.2 7-1.9 4.3.4 3.7 1.6 3.7 1.6zm13.3 10.3c0-.2-.3-5.5-2.4-7.7a6.4 6.4 0 0 0-5.8-1.9c-1.2.3 4.2 2.7 4.8 4.2.5 1.6 2.3 6 1.8 7-.5 1-1.3-3-4.7-4.2-3.3-1.2-7.9-.5-7 1 1 1.4 4.7 0 6.6 3.3a60 60 0 0 1 3.3 6.5l.7-2.3 1.6-.4.3-4.4z"
    />
    <path
      fill="#2b2b2b"
      stroke="#2b2b2b"
      strokeLinejoin="round"
      d="m402.3 325.7-3.5-7s-1-4.3-4-5.5c-3-1.3-6.8-1-6.8.4-.1 1.5 6.2 3.4 6.6 4.2.4.8.2 2.2-.3 2.3-.6 0-3.4-1-4.8-.7-1.4.3-2.2 2.2-4.3 1.6-2.1-.5-3.9-7.2-3-8 .7-.6-1.6 1.3-2.1-.5-.5-1.7.7-7.2-.1-7.9-.8-.7-4.8-3-4.8-3.5-.1-.5.2-27 22.3-5-9.5-11.3-13.2-10-15-10.1-1.2 0-9.9.7-12 11.7-2.2 11-4.8 4.1-4.8 4.1s-.4 4.8 1.9 6.1c2.3 1.4-1.1 5.3-1.1 5.3s-4.2-10-3.5-14.5c-.9 3.5-.8 12.3 4.4 21.8a71.2 71.2 0 0 0 27.2 19.1c8-12.3 7.7-13.8 7.7-14z"
    />
    <path
      fill="#8a9396"
      stroke="#2b2b2b"
      strokeLinejoin="round"
      d="M387.8 325.8s4.4.5 5.6 2.8c1.3 2.3 1.8 5.8 1.8 5.8.8-1.5 1-2.7 2.6-3.8 1.5-1.1 2.6-1.3 2.5-2 0-.9-4.8-5.8-7.1-6.1-2.4-.3-6.5 2.6-6.5 2.6s-.8 1 1 .7z"
    />
    <path
      fill="none"
      stroke="#8a9396"
      strokeLinecap="round"
      d="M398 337.4s11.6 5.3 30.6 5.6"
    />
    <path
      fill="none"
      stroke="#2b2b2b"
      strokeLinecap="round"
      d="M436.7 283.6s-1 9.7-8.5 29"
    />
    <path fill="none" stroke="#2b2b2b" d="M435.2 289.6s-2.3 7-8.5 12.2" />
    <path d="m401.3 410.3 2-2.2.6.5-.1.2-.2.3v.2l.2.2 2.6 2.3.2.2h.2l.1-.2q.4-.4.5-.8.2-.4.1-.8 0-.5-.4-1l.8-.4 1.2 2-3.2 3.6-.6-.5.2-.3.1-.2v-.2l-.2-.2-2.6-2.3-.3-.2h-.1l-.3.2-.2.2-.6-.6zm4.4-4.9 3.7-3.6 1.8.9-.3.7-1-.2-.6.2q-.3.1-.6.5l-.7.6 1 1.1.3-.2q.3-.2.3-.4v-.2l-.2-.3-.2-.2.6-.6 1.8 1.9-.6.5-.2-.1-.3-.3h-.2l-.4.3-.2.2 1 1 .2.2h.1l.2-.2.4-.3.6-.8q.2-.4.1-1 0-.4-.3-.9l.8-.4 1 2.3-3.8 3.7-.6-.6h.2l.2-.4v-.2l-.2-.3-2.4-2.4-.3-.2h-.2l-.2.1-.2.2-.6-.6zm7.7-7.4q1.2-1 2.4-.9 1.3.1 2.2 1.2.6.7.8 1.5.2.9-.1 1.6-.3.8-1.1 1.5-1 .9-2.2.9-1.4 0-2.4-1.2-1-1-.8-2.3.1-1.3 1.2-2.3zm.7.7q-.5.5-.5 1.2 0 .8.7 1.6t1.5 1q.6 0 1.1-.4.6-.4.6-1 0-.9-.8-1.7-.4-.5-1-.8-.4-.2-.9-.2-.4 0-.7.3zm6.1-6.2.5-.3.1.1 2.9-2v-.2l.4-.3 1.9 1.3-.5.7-.7-.3q-.4-.2-.8-.1l-.4.1-.1.1v.2l2.1 3 .2.3h.3l.5-.3.4.7-2.4 1.8-.5-.7.1-.1.3-.3v-.2l-.1-.3-2.1-3-.2-.2-.1.1q-.2.1-.3.4-.2.3-.2.7l.1.8-.8.2-.6-2.2zm5.6-3.5 4.4-2.8 1.7 1.3-.6.7-.8-.4h-.7q-.3 0-.7.3l-.8.5.8 1.3.2-.2.4-.2v-.3l-.1-.4-.1-.2.7-.4 1.3 2.3-.7.4-.1-.3-.3-.3h-.2l-.4.2-.3.1.8 1.3.1.2h.1l.3-.1.4-.3.8-.6.3-.9v-1l.8-.2.5 2.4-4.6 2.8-.4-.7.1-.1.3-.3q.1 0 0-.2v-.3l-1.8-2.9-.3-.3h-.1l-.3.1-.2.1-.5-.7zm6.2-3.8 3.5-1.8.7-.3q.4-.2.9-.1.4 0 .7.2l.5.6q.4.7.1 1.3-.2.6-.8 1l1.8.8h.1l.3.1h.3l.2-.1.3-.1.3.7-1.7 1-3-1.5-.5.2.6 1.1.2.4h.5l.2-.2.4.8-2.7 1.4-.4-.8.3-.1.2-.2.1-.2-.1-.3-1.6-3.1-.2-.2q0-.1-.2 0h-.3l-.2.1-.4-.7zm2.6-.2.7 1.4.8-.4q.5-.2.7-.5l.2-.4v-.5l-.4-.3h-.4l-.7.2-1 .5zm4.4-3.4 3.6-1.6.7-.2h.9q.4 0 .7.2l.5.7q.3.6 0 1.2t-.9 1l1.8.9.4.1h.5l.2-.2.4.8-1.8.8-3-1.6-.4.2.5 1.1.2.4h.4l.3-.1.3.7-2.7 1.3-.4-.8.3-.1.2-.2.1-.2-.1-.3-1.4-3.2q0-.2-.2-.3h-.5l-.2.2-.3-.8zm2.6 0 .6 1.5.9-.4.7-.4q.2-.2.2-.5v-.4l-.3-.4h-.5l-.7.2-1 .4zm6.8-3.9 1.3-.5 3.4 3.9.4.3h.5l.2.8-2.7 1-.3-.8.2-.1q.2 0 .3-.2v-.2l-.2-.2-.4-.5-1.7.6v1l.3.1.4-.1.3.8-2.3.8-.3-.8q.2 0 .3-.2l.1-.1v-.4l.2-5.2zm1 3.2 1.1-.4-1.1-1.4v1.8zm3.8-4.9 2.7-.8 2.1 3.3v-4l2.8-.7.2.8-.3.1q-.2 0-.3.2v.4l1 3.4.1.2.2.1h.6l.2.7-2.9.9-.2-.9h.2q.3 0 .3-.2l.1-.1v-.3l-1-3.7-.1 5.4-.8.2-2.8-4.4 1 3.7.1.1.2.1h.3l.3-.1.2.8-2.4.7-.3-.8h.3l.3-.2v-.5l-1-3.3v-.3l-.2-.1h-.6l-.3-.7zm12.4-3.3 3.2-.6h1q.5 0 .8.2.4.2.6.5l.3.7q.1.8-.4 1.4-.5.7-1.5.9l-1 .2.2 1.1v.3h.8l.1.8-3 .6v-.8h.1l.4-.2v-.5l-.6-3.3v-.4l-.2-.1h-.6l-.2-.8zm2.4.6.4 1.7h.5l.7-.3.3-.4v-.5q0-.4-.4-.6-.3-.1-.8 0h-.7zm4.2-1.8 3.8-.5h.8l.8.2q.4.2.6.5.3.3.3.7.1.7-.3 1.2-.5.5-1.1.8l1.4 1.3.3.2.2.1h.6v.8l-1.9.3-2.3-2.4h-.5l.2 1.2v.4l.2.2h.6v.8l-3 .4v-.9h.2l.3-.1.2-.2v-.3l-.5-3.5v-.3h-.8l-.1-.9zm2.4.7.2 1.6h1l.7-.3.4-.3v-.5l-.1-.4-.4-.2h-.8l-1 .1zm8.8-1.9q1.4-.1 2.4.7 1 .9 1 2.3 0 1-.3 1.7-.4.7-1 1.2-.8.4-1.8.5-1.4 0-2.3-.6-1.1-.9-1.2-2.4 0-1.4.8-2.4.9-1 2.4-1zm0 1q-.7 0-1 .6-.6.6-.5 1.7 0 1 .6 1.6.4.5 1.1.5.7 0 1.1-.6.5-.6.4-1.7 0-.7-.3-1.2-.2-.5-.6-.7-.4-.3-.8-.2zm4.6-1.1h3.4l1 .1.7.4.4.6.2.8q0 .8-.6 1.3t-1.7.5h-1v1.5l.4.1h.3v.9h-3v-.9h.5l.1-.1v-.4l.1-3.4v-.4l-.1-.1h-.6v-1zm2.3 1v1.8h.6l.7-.1.3-.3q.2-.2.2-.5 0-.5-.3-.7-.3-.2-.8-.2h-.7zm4.5-1 3.8.3.8.1.8.4q.3.2.5.6l.1.8q0 .7-.6 1-.5.5-1.2.6l1.2 1.5v.1l.2.3h.2l.3.1h.3v.9l-2-.1-1.9-2.8h-.5v1.6h.6v1l-3-.3v-.8h.6l.2-.2v-.3l.2-3.5v-.3l-.3-.2h-.4v-.9zm2.2 1.2-.1 1.6h.9q.5.1.8 0 .3 0 .4-.2.2-.2.2-.5v-.4l-.4-.3-.8-.1h-1zm5.4-.6 3 .4v.9h-.3q-.3-.1-.4 0l-.2.4-.4 3.4v.4h.1l.3.2h.3l-.1.9-3-.4.1-.9h.2q.3.1.4 0h.1l.1-.3.4-3.5v-.5h-.4l-.3-.1.1-.9zm6.5.9 1.4.3 1 5q0 .4.2.5l.4.2-.2.8-2.9-.5.2-.8h.5l.1-.1v-1l-2-.3-.3.6v.2q-.1.1 0 .2h.1l.4.2-.1.8-2.4-.4.1-.8h.4l.2-.1.2-.3 2.7-4.5zm-.8 3.3 1.3.2-.3-1.8-1 1.6zm5.9-2.4 2.7.7.2 4 2-3.4 2.7.7-.2.8h-.3q-.2-.2-.3 0-.2 0-.2.3l-.9 3.4v.4l.3.1.3.1-.2.9-2.9-.8.2-.8h.3l.3.1h.2v-.4l1-3.7-2.7 4.7-.8-.3-.3-5.1-.9 3.6v.2l.1.2h.3l.3.1-.2.9-2.5-.6.2-.9h.3l.3.1h.1l.2-.4.8-3.4v-.4l-.3-.1-.3-.1.2-.9zm12.5 3.5 3 1.1 1 .5.5.6.2.7-.1.8q-.3.7-1 1-.8.3-1.8 0l-1-.4-.4 1v.5l.3.2h.3l-.3.9-2.9-1 .3-.9h.2l.4.2h.1l.2-.4 1.2-3.2v-.5l-.3-.2h-.2l.3-.9zm1.7 1.7-.6 1.7.5.2.7.1.5-.1.3-.5q.1-.4-.1-.7-.2-.3-.6-.4l-.7-.3zm4.6.6 3.5 1.6.7.4q.4.2.6.6l.3.7-.2.8q-.3.7-.9.9h-1.3l.5 1.9.2.3.1.2.3.2h.2l-.3.9-1.8-.8-.8-3.3-.5-.2-.5 1.1v.6l.2.1.3.2-.4.7-2.7-1.2.3-.8.3.1.3.1h.2l.1-.3 1.4-3.2.1-.3v-.2l-.2-.1h-.2l-.2-.1.4-.9zm1.7 1.9-.7 1.5.9.3q.4.3.7.3l.5-.1q.2-.1.3-.4.1-.2 0-.4l-.1-.4-.7-.4-1-.4zm8.5 2.9q1.3.7 1.7 1.9.4 1.2-.3 2.5-.4.8-1.1 1.2-.7.5-1.6.5-.8 0-1.7-.5-1.2-.6-1.7-1.7-.5-1.3.3-2.6.6-1.3 1.9-1.7 1.2-.3 2.5.4zm-.4.9q-.6-.4-1.3-.1-.7.3-1.2 1.3-.5.9-.4 1.7.1.6.8 1 .6.3 1.2 0 .7-.3 1.2-1.2.4-.7.4-1.2 0-.6-.2-1l-.5-.5zm5 1.5.5.3v.2l3 1.9.1-.1.5.3-.5 2.2-.8-.2v-.8q0-.4-.2-.7l-.3-.4h-.2l-.1.2-1.9 3-.2.4v.1l.1.1.4.3-.4.7-2.6-1.6.5-.7.1.1.4.2h.1l.3-.4 2-3v-.3h-.1q-.2-.2-.6-.2l-.6.1-.7.4-.6-.6 1.8-1.5zm5.6 3.8 4.2 3-.6 2-.8-.2v-1l-.2-.6q-.2-.3-.6-.5l-.7-.6-1 1.3.3.2.4.2h.3l.2-.4.2-.2.6.5-1.5 2.1-.6-.4.1-.2.2-.4v-.2l-.4-.4-.3-.1-.8 1.1-.1.3.2.3.4.3 1 .4q.4.1.8 0 .5-.1 1-.5l.4.7-2 1.4-4.3-3 .5-.8.1.1.4.2h.2l.2-.3 2-2.8.2-.3v-.1l-.3-.3-.2-.1.5-.7zm6.9 8.8 2.3 2-.5.6-.2-.1-.2-.2h-.2l-.3.3-1.2 1.5-.7-.6.1-.5-1-.2-.7-.5q-.7-.6-1-1.3-.2-.8 0-1.6 0-.8.6-1.6.6-.7 1.4-1 .8-.3 1.6-.1.8.1 1.5.6l.5.6.4.7.3-.1.5.4-.9 2-.8-.4v-1.1l-.1-.7-.4-.5-.8-.3-.9.2q-.4.2-.9.8l-.6 1v1.1q.1.4.5.7l.5.3h.5l.4-.2.1-.2.2-.3v-.1l-.3-.3-.2-.2.5-.7zm6.7 2 1 1-1.9 4.8q-.2.3-.1.5l.2.3-.6.7-2-2 .5-.7.1.2.3.1h.2l.2-.3.2-.5-1.4-1.3-.6.3-.2.1v.3l.3.3-.6.6-1.7-1.6.6-.6.2.2h.2l.4-.1 4.7-2.3zm-2.4 2.3.9.9.7-1.7-1.6.8zm6.5 1.4.4.4-.1.2 2.4 2.5h.2l.4.3-1 2-.8-.3.2-.8v-.7q0-.3-.2-.5h-.2l-.2.1-2.5 2.5-.3.3v.2l.3.4-.6.6-2-2.2.6-.6v.2l.4.2h.2l.3-.2 2.6-2.5.1-.2v-.1l-.5-.3h-.7l-.8.2-.3-.8 2-1z" />
    <path fill="#012169" d="M0 0h320v240H0Z" />
    <path
      fill="#fff"
      d="m37.5 0 122 90.5L281 0h39v31l-120 89.5 120 89V240h-40l-120-89.5L40.5 240H0v-30l119.5-89L0 32V0Z"
    />
    <path
      fill="#c8102e"
      d="M212 140.5 320 220v20l-135.5-99.5Zm-92 10 3 17.5-96 72H0ZM320 0v1.5l-124.5 94 1-22L295 0ZM0 0l119.5 88h-30L0 21Z"
    />
    <path fill="#fff" d="M120.5 0v240h80V0ZM0 80v80h320V80Z" />
    <path fill="#c8102e" d="M0 96.5v48h320v-48ZM136.5 0v240h48V0Z" />
  </svg>
)

export default GsFlag
