// This file is generated by @lib/ui/country/codegen/generateFlags.ts
import { SvgIconProps } from '@lib/ui/icons/SvgIconProps'

const DoFlag = (props: SvgIconProps) => (
  <svg
    width="1em"
    height="0.75em"
    xmlns="http://www.w3.org/2000/svg"
    xmlnsXlink="http://www.w3.org/1999/xlink"
    id="flag-icons-do"
    viewBox="0 0 640 480"
    {...props}
  >
    <path fill="#fff" d="M0 0h640v480H0Z" />
    <path fill="#002d62" d="M0 0h272v192H0Zm368 288h272v192H368Z" />
    <path fill="#ce1126" d="M0 288h272v192H0ZM368 0h272v192H368Z" />
    <path
      fill="#201b18"
      d="M307.4 196.6a34.9 34.9 0 0 0-19 4.9c-2.6 1.6-3.2 2.1-1.8 4.7l-3.3 1.1a38 38 0 0 0-6 2.7c-1.2.7-1.6 1.2-2.5 2.1l5.3-.4-.7 1.2c-1 1.3-1.5 2.3-2.3 3.7 1.5-1 2.9-2 4.6-2.8 3.8-2 10.7-2 13.5-5.4.7-.9.3-1.4-.3-2.8 2-.6 2.9-1.1 5.4-1.7 6.1-1.4 10.3.3 13.3-.5 1-.2 1.8-.7 1.9-1.7l-.5-3h10c0 1.7-1.7 4 1.4 4.7 2.8.8 8.4-.8 13.3.5l5.4 1.8-.5 1.3c-.3.6-.2 1 .2 1.4.5.6 1.2 1.2 2 1.6a22.3 22.3 0 0 0 5.6 2c5.7 1.3 6.2 1.7 10.5 4.6-.3-.9-2.3-3.9-3-5l5.3.5c-1-1.4-3.7-2.9-5.3-3.5l-6.5-2.4c.6-1 1-2 .5-3a24 24 0 0 0-7.7-4.3 68.4 68.4 0 0 0-7-1.6l-6.8-.7c-.3-.3.6-2-.8-3.3-.8-.6-2-.9-3.3-1-5-.5-11.6-.3-16.6 0-1.5.1-2.5.3-3.3 1-1 1-1.1 1.5-1 3.3z"
    />
    <g fill="#002d62">
      <path d="M308.7 200.1c.8-.6.9-.8 2-1.2 2.6-.9 6.6-.8 9.3-.8 2.2 0 4.3 0 6.5.2s3.4.5 4.9 1.7c.3-1.5.6-2.8.6-4.5.1-1.8-1-2.3-2.5-2.6-2.6-.6-7-.5-10-.5a63 63 0 0 0-9.7.6c-1.2.4-2.2 1.4-2 3 0 .9.6 3.6 1 4.1z" />
      <path d="M289.4 208.7c.4-.4.1-.8 2.2-2a34.8 34.8 0 0 1 9.3-3.4c2.6-.5 5.3-.5 8-.3 1.2.1 2.8.3 4 .1 0 0 1.3-.3 1.7-.6.4-.4.4-1.4.4-1.4-.9-.7-3.4 1.8-5.6 1-.7-.2-1-1.4-1.2-2.3l-.8-2.7a35.1 35.1 0 0 0-15 2.8c-1.8.8-4.6 2.2-5.7 3.3-1 1 0 2.4.6 3.1.6.9 1.6 2 2 2.4zm35.6-7.6c-.2 1.4.8 1.8 2.1 2 2.7.4 6.7-.8 12 .2a35.2 35.2 0 0 1 6.4 2c.8.4 3.6 1.6 4.1 2.2l1 1.2c.3-.1 1.8-2 2.1-2.4.7-.7 1.5-2 .6-3.1a25 25 0 0 0-5.7-3.3 38.8 38.8 0 0 0-7.8-2.1c-2.5-.4-7.6-.8-7.6-.8s-.3 4.7-1.6 5.1c-2.5.8-3.8-1.4-5.6-1z" />
      <path d="M345 207c-.2.6-.5.7.9 1.8 3 2.6 8.4 2.7 11.6 4.1 1.7.8 2.6 1.4 4.1 2.3-.1-.5-2-3.2-2.5-4l4.9.2-.2-.2c-2.2-1.9-7.9-3.7-10.7-4.6l-2.5 2.8c-.3.3-.6.6-1.3.4-.8-.3-1.5-1-2-1.5-.6-.5-1.6-1.3-2.3-1.4zm-20-6.4c1.7.1 1.9.4 3 1l1.8.2c.9 0 1-.2 1.2-.9.3-1-1.3-1.6-2-1.7l-3.5-.6zm-10 0-.4-2c-1 0-6 .8-5.6 2.3.2.7.3.8 1 1 2.2.1 2.6-1.2 5-1.3zm-25.2 8.4c.7 1.3 2.6-1 3.7-1.8.6-.5.7-.4 1.4-.7l-.4-.7-2.7 1.3c-.8.5-1.8 1-2 2z" />
      <path d="M345.1 206.5c.3 0 .5.1.8.3 1.6.9 3.5 3.3 4.3 2.4.4-.5-1.3-1.7-1.8-2l-2.8-1.3a1.6 1.6 0 0 0-.5.6zm-50.2.5c.2.7.5.8-.8 1.9-3.2 2.5-8.4 2.7-11.7 4.1-1.7.7-2.6 1.3-4 2.2 0-.4 2-3.2 2.5-4l-5 .3.3-.2c2.2-2 7.8-3.7 10.6-4.7l.9 1a37 37 0 0 0 1.6 1.9c.4.3.6.5 1.3.3.9-.2 1.6-1 2-1.4.6-.5 1.6-1.4 2.3-1.4z" />
    </g>
    <path
      fill="#eac102"
      d="M295.7 199.8c-.5 0-.9.2-1.3.3-.1 0-.5.2-.2.3.2.1.2.4.3.6l.3.9.5 1.4c0 .1 0 .4.2.3l.8-.3c.3-.1.6-.3.8-.7l.2-.5a.8.8 0 0 0 0-.4c0-.2 0-.4-.2-.6a1.8 1.8 0 0 0-.4-.8c-.2-.2-.4-.4-.7-.4a.8.8 0 0 0-.3-.1zm-.2.3c.2 0 .5.2.6.5l.4.7.2 1.3c0 .2-.3.3-.5.5-.2 0-.4-.1-.4-.3l-.2-.6-.4-1a4.7 4.7 0 0 1-.2-.8c0-.2.2-.3.4-.3zm1.7-.9.3.3.2.6.1.5.2.7.2.6v.6s0 .2.1 0h.5c.1 0 .3 0 .3-.2l-.2-.3-.2-.8-.2-.5-.1-.4-.3-.9v-.3c0-.2-.2 0-.3 0l-.6.1zm3-.8c-.3 0-.6.1-.8.3l-.3.9v.8l.6 1.2.7.4h.6c.3-.1.6-.4.7-.7l.1-.8v-.7a2.6 2.6 0 0 0-.4-.7l-.5-.5a1.1 1.1 0 0 0-.7-.2zm0 .2c.2 0 .4.3.5.6l.4 1.2.1.5v.7c-.2.2-.5.3-.7.1l-.4-.5-.2-.8-.1-.6c0-.3-.2-.6 0-1l.3-.2zm2.3-.5-.3.5.1.7a.8.8 0 0 0 .4.4l.9.5c.2 0 .4.2.4.4v.5c0 .1-.2.3-.4.2a.7.7 0 0 1-.4-.2 1.2 1.2 0 0 1-.4-.6l-.2.1v.6l.4.2.5.2c.2 0 .4 0 .6-.2.2 0 .3-.2.4-.4a1 1 0 0 0 0-.7 1.1 1.1 0 0 0-.6-.8 4 4 0 0 0-.6-.3l-.6-.5c0-.2 0-.5.2-.5h.6l.3.5c0 .2.2.1.1 0 0-.2.2-.5 0-.6a1.4 1.4 0 0 0-.6-.2 1 1 0 0 0-.6.1l-.2.1zm11.2-4.4-.9.2-.4.1a.7.7 0 0 1 .2.4v1.5l.1.8v.6c-.2.1 0 .2.2.1h.6c.2 0 0-.2 0-.3l-.1-.6v-.6l.6-.1c.4-.1.8-.4.9-.8a1.1 1.1 0 0 0-.4-1 1.4 1.4 0 0 0-.8-.3zm0 .3c.2 0 .4.2.4.5v.5c0 .3-.2.5-.5.6-.1 0-.3 0-.3-.2v-.6c0-.3-.2-.5 0-.7h.3zm2.6-.4c-.2 0-.4.1-.3.3l-.2.7a9.9 9.9 0 0 1-.2 1l-.3 1.2c0 .1-.2.3 0 .3h.5c.2 0 0-.2 0-.3v-.5s0-.2.1-.1h.8v.6c0 .1 0 .3.2.3h.7c.2-.1 0-.3-.1-.4l-.2-.7-.3-.9-.1-.5a9.3 9.3 0 0 1-.3-1h-.3zm-.2.8.4 1.3c.1.1 0 .2-.2.2-.1 0-.5.1-.5-.1l.1-.5a6.9 6.9 0 0 0 .2-.7v-.2zm3-1h-1.3a.8.8 0 0 1 0 .5l-.1.4.3-.3c.1 0 .2-.3.4-.2h.3v2.9l-.1.2h.9c.1 0 .1-.1 0-.1v-3c0-.1.1-.2.3 0h.2l.2.4h.2l-.1-.5c0-.1 0-.3-.2-.3h-1zm2.8 0h-.8s-.2 0-.1.1c.2.1.1.3.1.5v2.5c0 .1 0 .3-.2.4h1c0-.1-.2-.2-.1-.3v-1.2c.2 0 .3.1.3.3l.2.5c0 .2.2.3.3.5.2 0 .3.2.5.3l.3.1-.2-.3-.3-.8a2 2 0 0 1-.2-.5c0-.2.1-.1.2-.2a1 1 0 0 0 .5-.4v-.6l-.2-.5c-.1-.2-.3-.2-.4-.3a3.3 3.3 0 0 0-.6-.1h-.3zm.3.2c.2 0 .3.1.4.3a.8.8 0 0 1 .2.4v.4c-.1.2-.3.4-.5.4h-.5v-1.3c0-.2.2-.2.4-.2zm2.2.4v1.2l-.1 1.4a.8.8 0 0 1-.2.4s0 .1 0 0l.4.1h.5c.2 0 0 0 0-.2v-2.7c.1-.1 0-.3.2-.4v-.2h-1l.2.4zm2.5-.2-.3.9-.1.5-.3.8c-.1.4-.2.8-.4 1-.2 0-.1.3 0 .2h.5c.1.1.2 0 0 0v-.6c0-.2.1-.3.3-.2h.6l.1.6c0 .2-.2.4 0 .4h.7s.2 0 0 0l-.1-1-.2-1-.1-.9a1.9 1.9 0 0 0-.1-.5s0-.2-.2-.1h-.4zm0 .8c.2.2.1.4.2.6v.8c.2.3-.2.1-.3.1-.2 0-.4 0-.3-.2l.1-.4.2-.5.1-.4zm6.5 3.5c0 .2.2.3.1.4v2.9a.3.3 0 0 1 0 .3h1.9v-.8c0-.1 0 0 0 0-.2.3-.4.5-.7.5h-.5v-.5a31.7 31.7 0 0 1 0-2.4l.1-.4zm2.3 3.6h1l-.2-.4v-2.9l.2-.3h-1c0 .2.2 0 .2.3v2.9l-.2.4zm1.5-3.7c0 .2.2.3.1.4v1.2a26.1 26.1 0 0 1-.1 1.4l-.1.5s-.2.1 0 .1l1.1.2c.3 0 .6 0 .8-.2.4-.2.5-.7.4-1 0-.2-.2-.3-.3-.5a13 13 0 0 0-.4-.3.8.8 0 0 0 .7-.5c0-.3 0-.6-.2-.8l-.2-.2-.5-.1-1.3-.2zm.8.4.6.1c.2.3.2.6 0 1l-.2.1h-.5v-.8l.1-.4zm-.2 1.5c.3 0 .6 0 .8.3.2.2 0 .5.1.7 0 .4-.3.6-.6.6-.2 0-.3-.1-.3-.3a9 9 0 0 1 0-1.3zm1.8 2 .3.2.9.2.8.1.2-.5c0-.2-.1-.3-.2-.1a1 1 0 0 1-.9.1c-.2 0-.3-.2-.3-.4l.2-1.2.4.1c.2 0 .3.2.4.4l.1-.3v-.7c-.1 0-.2.4-.4.2-.2 0-.5 0-.4-.2l.1-.8c.3-.1.7 0 .9.3l.3.3v-.7l-.5-.2-1.3-.3c-.3 0 0 .2 0 .3l-.2 1.7-.2 1.2a.5.5 0 0 1-.2.3zm3-2.8v.6l-.3 1.6-.2 1c0 .1-.4.2-.1.3l.7.2c.2 0 0-.2 0-.3l.2-.7.1-.4c.2 0 .1.3.2.4 0 .4.2.8.3 1.1l.6.5-.2-.5v-1.4c.1 0 .3 0 .5-.2.2-.3.3-.7.2-1a1.3 1.3 0 0 0-.6-.8l-1.2-.4a1.2 1.2 0 0 0-.2 0zm.8.4a.7.7 0 0 1 .6.4c.1.4 0 .8-.1 1.1-.2.2-.4.2-.6.1-.2 0-.4 0-.3-.2l.2-1a.7.7 0 0 1 .2-.4zm1.5 1.2.5-.2s.3-.1.4 0c.1.1 0 .3 0 .4l-.1.7-.4 1.6-.3.4c0 .2.2.2.3.2l.6.2c0-.1-.1-.2 0-.4l.2-1.2a31.3 31.3 0 0 1 .4-1.6c.2 0 .4.2.5.3l.2.5c.1 0 0-.2 0-.4l.1-.4-.8-.3-.6-.3-.7-.2-.3.6a.3.3 0 0 0 0 .1zm3.4.7c-.2 0-.2.2-.3.4 0 .2-.2.3-.3.5l-.9 1.4a1.1 1.1 0 0 1-.4.4c-.2.2.1.2.2.3.1 0 .3.2.4.1 0-.2-.2-.3 0-.5 0-.1 0-.4.3-.3l.6.4v.5c0 .1-.3.2-.2.4l.5.3s.3.2.2 0v-.8l.1-.5v-.8l.2-1.2c0-.2.1-.4 0-.4l-.4-.2zm-.3.7s.1.1 0 .2v1.3c0 .2-.3 0-.4 0-.1-.1-.4-.2-.2-.4l.4-.6.2-.5zm2.2.5-.1.6-.4.6-.4.7-.5 1h-.2l.5.5.6.6c.3.2.8.3 1.1.1l.5-.5a3.4 3.4 0 0 0 .3-.6v-1c0-.4-.2-.9-.5-1.2l-.6-.6-.3-.2zm.6.9c.3.2.5.5.4.8 0 .5-.2 1-.5 1.4-.2.3-.4.6-.7.6-.2.1-.5 0-.6-.3l.2-.6.8-1.4c0-.2.2-.4.3-.5h.1z"
    />
    <path
      fill="#006300"
      d="m308.8 279.2 2.5 1 1.8 3.4c.7.5.6.4 1.3.6l-4.3 1.8c-1.2.4-.7 1.5-.1 1.7.6.2 2-.3 2.4-.5 2.1-1 4-2 6-3.3.3-.2 1.7-1.1 2-1l7.6 4.2c.6.3 1.7 1 2.3.6.3-.2.6-.6.5-1-.1-.5-.4-.6-.8-.7l-4.1-1.8.9-.3c.3-.2-.2-.7.2-.6l1.9-3.1 2.3-.9c0-2.1-17.8-3.5-22.4-.1z"
    />
    <path
      fill="#ff0"
      d="M310 286.5c-.6.2-.5 1.4.8 1 .9-.3.2-1.3-.8-1zm19 0c-.3.5-.3.7.2 1 .5.1.7.1 1-.2.5-.4.1-.6-.2-.8-.4-.2-.1-.2-.4 0h-.7z"
    />
    <path
      fill="#006300"
      stroke="olive"
      strokeWidth={0.2}
      d="M345.8 216v.3c1.7 3.2 1 1.7 2.4 5.9l-.8-1.1a30.2 30.2 0 0 1-2-3 1.3 1.3 0 0 0-.4-.6c-.2.3.4 2 .6 2.5.5 2 2.1 4.4 3.3 6.3l-.9-.7c-1-.8-.7-.6-1.3-1.7a20.3 20.3 0 0 1-1.4-3 51.6 51.6 0 0 0-.8-2.2l-.2.2v.9l.6 3.6c-.8-.3-.6-.4-1.3-1-.2 0-.4-.6-.6-.6l-.7-.8c-.1.4 1 2.4 1.2 2.6.4.6 1.8 1.6 2 2a14 14 0 0 0 2.1 3.7l.9 1.1-1.9-1.8a33 33 0 0 0-3.4-3c0 .4.6.8.9 1l2.3 2.6c.7 1 1.6 1.8 2.2 2.8l1.5 2.5a13.8 13.8 0 0 0-.8-1.1l-2.3-2.8c-.8-1-1.6-1.6-2.6-2.4a25.6 25.6 0 0 0-2-1.4c0 .3 1.9 2.7 3.2 3.4l1.2 1.3 1.2 1.3a36.3 36.3 0 0 1 1.9 3l.9 1.5c-.7-.2-4-4-4.7-4.7-.7-.7-1-1-1.8-1.5 0 .4 2.3 3 2.8 3.5l.5.6 1 1.1c.6.8 1.8 2.2 2.2 3l.7 1.4a20 20 0 0 0-1.5-2 7.8 7.8 0 0 0-.9-1c-.7-.8-1.9-2.2-2.8-2.8l-2.2-1.3c-.1.2.4.6.6.8l.9.8a21.7 21.7 0 0 1 3.1 3.4c.6.6 1 1.2 1.4 2a3.1 3.1 0 0 1-.7-.7l-.7-.7-1.6-1.2-3.6-1.8c0 .3 1.3 1 1.6 1.2.7.5 2 1.2 2.5 1.9l.7.7c.5.5 1 1 1.3 1.6l1.2 1.7 1 2 1.3 4.5c-.4-1.5-1.2-3-1.7-4.6-.4-1-1.4-3.8-2.8-3.3-.5.2-.8.8-1 1.2-.3.7-.8-.2-2 2a18.1 18.1 0 0 0-1.2 4.3v.7c.3-.1.5-.9.6-1.2.5-1.4 1-2.3 1.9-3.6l-1.1 4.9c.4-.1.5-.7.6-1l1.4-3.7c1.6 1.1 2 7.2 2.3 9.3a21.4 21.4 0 0 0-1.1-3l-1.7-2.8c-1 .1-1 1.4-1.2 2.1-.3-.4-.6-1-1.3-1-.5 0-.8.8-.9 1.4a7.7 7.7 0 0 0 0 2.2l.4 1.6.2.2.3-4.1c.6.3 1.8 3 1.6 4-.6 4-1 5.3-3.1 8.6l-1.2 1.7a10 10 0 0 1-.6.8l-.7.8c1.1-2 1.6-2.7 2.4-4.9a24 24 0 0 0 1.2-5v-.9c-.3 0-.3.4-.4.7-1.8 5.7-2.1 6-5.1 11l.5-3.3c-.2 0-.2.2-.3.6l-.2.6a17.8 17.8 0 0 1-1.6 3.6c0-.3.3-.8.4-1.1a26 26 0 0 0 .7-3.4v-.7c-.3 0-.4.6-.5 1-.4 1.2-1 2.2-1.4 3.3v-.3c0-.7.3-1.8.1-2.5v-.3c-.3.1-.4.7-.5 1l-.3 1c-.7 1.9-1.5 3.1-2.5 5-.6-.1-.2 0 0 0a209.5 209.5 0 0 0 5.7 1.1c2.8-.1 4.6-.3 7.4 0 .4 0 2.1.3 2.4 0-.8-.4-1.6-.6-2.5-.9l-2.7-.6 7.5-.2-.6-.4c-1.3-.5-4.6-.7-6-.8 2.5-.2 4.4-.4 6.8-.4.7-.2 2.9.5 2-.5-1-.6-3.8-.7-4.7-.6l4.4-.2c.7-.2 5.3.8 3.7-.2-1.3-.7-4-1.2-5.4-1.4.8-.5 1.5-1 2.3-1.3a40.7 40.7 0 0 1 5.3-1.7c2-.3 3.5-1.3.9-.9-1.6.2-3.5.7-5 .8l1.3-.7c1.3-.6 2.7-.9 4-1.3.3-.1.2 0 .3-.2l-.2-.1h-.8a65.1 65.1 0 0 0 7-2c.3 0 .7 0 .9-.2l-.2-.1a86 86 0 0 0-6.4.8l-2 .3 5-2c.4 0 1.6-.2 1.8-.5-.3-.2-.6-.1-1.1 0a36 36 0 0 0-4.7 1.2l-1.8.5c5.6-2.1 3.4-1.5 8.6-2.5.6-.1 1 0 1.1-.4l-3-.2c-1 0-2 .2-2.7.3l2.2-1.9c.6-.5.3-.7 1.4-.7h2c-.8-.9-1-.5-1.8-.9l1-1 .5-1c.1-.1.1-.1 0-.2h-.3l-2.3 2c-.4.2-.3.2-.9.2l-3 .6a24.7 24.7 0 0 1 3-2.1l1.7-1c.5-.2 1.6-.6 1.7-.8l-3.6.9a19.2 19.2 0 0 0-3 1.5 45.8 45.8 0 0 1 5.8-5.2c.2-.1.8-.4.9-.7h-.3c-1 .2-3.2 1.7-4 2.1a36.3 36.3 0 0 0-3.8 2.8 27.9 27.9 0 0 1 2.7-2.6l.5-.5 1.1-1c.8-.6 1.5-1.2 2.2-2l1.1-.9c.3-.2 1-.7 1-1a55.3 55.3 0 0 0-4.4 2.7l-2.1 1.5-2.1 1.6c.9-1.4 1.8-2.9 2.9-4.1a45.6 45.6 0 0 1 4.7-4.4c.4-.3.8-.8 1.2-1v-.2c-.4 0-1.6.9-1.9 1.1a38.5 38.5 0 0 0-4.7 4l-.7.8a15 15 0 0 0-2 2.4 62 62 0 0 0-2.4 3.6c.5-2.2 2-4 3.2-5.2l2.7-3 .4-.5a10 10 0 0 0 3-5.8l-1.3 1.8-.7.7-5.4 6.3c.2-.9 1.3-2.8 1.8-3.5a63.3 63.3 0 0 1 5.6-7.5l.3-.3c0-.3.4-.5.8-.9l1-.8c-.5-.5-2.4.6-2.7.9-2.4 1.6-4.1 3.9-5.9 6.1a26.1 26.1 0 0 1 2.4-5.7c.5-.8 1-1.8 1.6-2.5l1.6-2.4c-.4 0-.8.5-1 .8l-.5.4c-2 2.3-3.3 4.8-4.8 7.5.1-1.3 1.3-3.7 2-4.8l2.8-4.2c-.5-.1-2 1.6-2.3 2-.6.8-1.3 1.6-1.8 2.6a31 31 0 0 0-2.7 5.5l-.2.4c.1-1.8 2-6.1 2.7-7.6l1.6-2.2.5-.7 1.1-1.4 1.1-1.5c-.7-.2-3.2 2.6-3.7 3.2l-1.7 2.5c.3-1.4 1.3-3.3 2.1-4.5l2.1-2.7.7-1c-.8 0-4 3.7-4.7 4.5l-.7 1.1-1.1 1.7-.2.3-.2.3a37 37 0 0 1 1.4-5.3l2-4.5c-.5 0-1.6 1.4-1.9 1.8l-1.2 2.5c.1-1.2 1.8-5 2.4-6.5-.3 0-.5.6-.8 1l-2.3 3.8c.1-1.3 1-2.6 1.5-3.7-1 .4-2.8 4.2-3.2 5.3l-.5 1.6-.2.6c0-2.8.5-5.7 1-8.5-.3 0-.4.3-.5.6l-.3.7-.6 1.6-.8 3.4c-1.2-1.7-1.5-4.8-3.9-8.4-.7-1.1-1-1.2-2-2zm1.3 33.8c1 2.8 1.3 3.7 2 6.6a.7.7 0 0 0-.2.3l-.4 1.2-.8-2.5c-.2-1 .2-2.8-.2-3.1-.2.5-.2.5-.2 1.4l-.5-1c-.5-1.6-.6-1.1-.2-2 0-.3.2-.7.5-.9z"
    />
    <g fill="#008f4c">
      <path d="M354.4 245.1c.4-3.8 5-12.8 6.5-13 .2 0-1.6 2.5-2.8 5a56.7 56.7 0 0 0-3 7.3 17 17 0 0 1-.7 2.6v-2zm10.2-2.3s-.8.9-1.9 1.8a44.3 44.3 0 0 0-9.6 13.8c-2 5-1.5 3.7-.9 1.3a35.3 35.3 0 0 1 9.7-15.1c1.4-1.2 2.8-2.1 2.7-1.8zm-11.8-8.6c0-3.4.4-4.6 2.4-8.8 1.2-2.7 1.7-3.5 1.9-3.3 0 .1 0 .6-.3 1a50 50 0 0 0-3.4 11.7 5.5 5.5 0 0 1-.4 1.7 7 7 0 0 1-.2-2.3zm-5.6 19.4a20.2 20.2 0 0 1-1.4 8.8c-.7 1.8-3.5 6-4.2 6.4-.3 0-.2 0 .5-1a22.1 22.1 0 0 0 5-13.4c-.2-2.6 0-3 .1-.9z" />
      <path d="M355.8 250.3c.4 1.2.5 4 0 5.5a11 11 0 0 1-7.2 7.5 5.7 5.7 0 0 1-1.3.3 5.4 5.4 0 0 1 1.2-.7 12.4 12.4 0 0 0 7.3-11c0-1-.1-1.4-.2-1.6 0-.4-.1-.7 0-.8l.2.8z" />
      <path d="m365.7 257.9-4.4.8a194.8 194.8 0 0 0-9.3 1.6.9.9 0 0 1-.1-.3 168.7 168.7 0 0 1 13.8-2.1zm-18.5-39.7c1.5 1.8 1.8 2.6 2.6 5.7.5 2 .6 2.6.5 2.6l-.4-.7a34.4 34.4 0 0 0-3.2-7.7 3.8 3.8 0 0 1-.6-1 5 5 0 0 1 1 1zm-1.6 2.2c.6 2.2 1.1 3 3.3 5.3 1.4 1.4 1.9 1.9 1.9 1.7 0 0-.1-.4-.4-.6a34 34 0 0 1-4.6-6.9 3.8 3.8 0 0 0-.6-1s0 .7.4 1.5zm13.4 7c-2.4 2.2-6.3 9.2-5.7 10.3.1.1 1.1-1.5 2.2-3.6a48.4 48.4 0 0 1 3.4-5.8l1.4-2-1.3 1.1zm1 1.8c-2.6 2.4-6.9 10.2-6.3 11.4.1.2 1.2-1.6 2.4-4a54.3 54.3 0 0 1 3.9-6.4 15.7 15.7 0 0 0 1.5-2.1l-1.4 1.1zm-15.2-7.1c.4 2.3.8 3 2.6 5.6 1.2 1.7 1.7 2.2 1.7 2 0 0 0-.4-.3-.6a34.3 34.3 0 0 1-3.7-7.5 3.8 3.8 0 0 0-.5-1.1l.2 1.6z" />
      <path d="m348.4 226.7 2.6.7c0-.2-.4-.3-.7-.4-1.7-.5-6.4-2.6-6.5-3.4l-1-1.5s4 4 5.6 4.6zm16.2 8.3c-3.6 2.5-10 11.2-9.5 12.8 0 .3 1.7-1.7 3.6-4.4a65.8 65.8 0 0 1 5.7-7.3 19 19 0 0 0 2.1-2.3s-1 .5-1.9 1.2zm-.5 5.3c-1.6 3.2-7.7 9.3-9 9a15 15 0 0 1 3.1-3.3 51.8 51.8 0 0 0 5-5.4 15.6 15.6 0 0 1 1.6-2c0 .2-.3 1-.7 1.7zm-21.4 22c-.6 3.1-4.5 9.8-5.7 9.9-.1 0 .7-1.7 2-3.7a47.3 47.3 0 0 0 3-5.8l1-2-.3 1.6zm10-18.9c-.7-2-2.5-4.4-5-6.6-2.4-2.2-3.2-2.5-1-.5a29 29 0 0 1 6.3 8.8s0-.8-.3-1.7zm1.8 25.5c-2.8-.8-10-.7-10.5.1 0 .2 1.6.2 3.8.1a47.3 47.3 0 0 1 8 .3l-1.3-.5zm-3 1.2c-2.9-.7-10-.3-10.5.6h3.7a47 47 0 0 1 8.2-.1l-1.4-.4zm-3.2 1.6c-2.8-.7-10 0-10.5.8l3.8-.2a47.8 47.8 0 0 1 8.1-.2l-1.4-.4z" />
      <path d="M346.4 273.5c-2.3-1-8.6-1-9-.3-.2.2 1.3.3 3.2.2a36.1 36.1 0 0 1 5.2.3l1.8.3a9 9 0 0 0-1.2-.5zm11.2-8.9c-6 1.7-13 2.7-13.4 4.1 0 .2 2.6-.2 5.2-1.2a56.4 56.4 0 0 1 7.5-2.4c1.5-.3 2.7-.6 2.7-.8 0 0-1 .4-2 .3zm7.6-3.7-5.2 1a213 213 0 0 0-8 1.5c-2.4.5-2.9.6-3 .3a1 1 0 0 1-.2-.3 197.6 197.6 0 0 1 16.4-2.5zm-1.8-1.5-4.3 1.2a174.5 174.5 0 0 0-9 2.5.9.9 0 0 1-.2-.2 168.8 168.8 0 0 1 13.5-3.5z" />
      <path d="M362 252.4c-4.1 1.7-12.2 8.8-12 10.5 0 .3 2-1.3 4.4-3.6a64.4 64.4 0 0 1 7-5.8 18.7 18.7 0 0 0 2.6-1.8l-2 .8z" />
      <path d="M365 254.4c-4 .3-13.3 4.4-13.5 6 0 .3 2.1-.5 4.9-2a56 56 0 0 1 7.8-3.2l2.8-.8h-2z" />
      <path d="M364.8 254.8c-10.3 8.7-16.1 13-18.2 12-.3 0 3.8-2.4 7.3-4.7a78 78 0 0 0 9.4-7l3-2.7a18 18 0 0 1-1.5 2.4zm-11 2.8c2-3.4 3-4.4 7.5-7.2 2.9-1.8 3.9-2.4 4-2l-1 .8a56.1 56.1 0 0 0-11.8 10.7l1.3-2.3zm1.1-9.8c.4-3.8 6.8-16.5 8.2-16.7.2 0-1.5 2.5-2.7 5a57 57 0 0 0-3 7.3 74 74 0 0 1-2.8 7l.3-2.6zm-2.7-14.6c-1.1-2.6-1.2-3.6-.4-7.2.5-2.3.8-3.1 1-3v.9a28.7 28.7 0 0 0 .2 11s-.5-.8-.8-1.7zm2 13.9a15 15 0 0 0-4.5-6c-2.2-2-2.9-2.3-.9-.4a26 26 0 0 1 4.9 6.6l.7 1.3-.2-1.5zm-10 2.9c2-7.4 3.7-6.1 3.7-6.1 4.4 4.2 2.2 18.7 2.2 18.7 0-29.6-5.9-12.6-5.9-12.6z" />
      <path d="M345.9 249.5c2-7.4 2.5-7 2.5-7 3.7.7 3.5 17 3.5 17-1.6-28-6-10-6-10zm-2 5.7c0-5.3 1-4.5 1-4.5 3 2.7 4 13 4 13-4.6-20.8-5-8.5-5-8.5zm9-15.5c-.8-2.9-3.6-5.8-6.4-9.5-3.5-3.2-4.6-3.7-1.5-.7 2 1.2 6 7 7.2 10.5.6 1.2 1.1 2.1 1.2 2 .2 0 0-1.1-.4-2.3z" />
      <path d="M352.7 237.2a18 18 0 0 0-5.2-7.4l-1.6-1.5A60 60 0 0 1 353 239c.1 0 0-.9-.3-1.8zm-15 29.3c-.1 1.5-1.8 5.1-2.4 5.2l.8-2a24 24 0 0 0 1.7-4v.8zm-1.4.9c-.2 1.6-1.9 5.1-2.5 5.2l.8-1.9a24.1 24.1 0 0 0 1.8-4.1v.8zm2.2.1c-.2 1.6-1.9 5.2-2.5 5.2l.9-1.9a24 24 0 0 0 1.7-4.1v.8z" />
    </g>
    <path fill="#00873f" d="M284 227c0 .8.2 1 .6 1.5V227c-.2-.2-.3 0-.6 0z" />
    <g
      fill="none"
      stroke="#006300"
      strokeWidth={0.6}
      transform="translate(-106.1 -20.4) scale(.85227)"
    >
      <path d="m455.2 304-.9-.8m1.8-4.6-.8-1m-1.7 13.5c-.3-2.1-1.5-2.8-1.5-2.8m11.3 30c-5.4-6-7.1-16.7-7.1-16.7 1.7-4.6 4-5.6 4-5.6m-4 5.5c-1.8-7-1.3-14.2-1.3-14.2a70.8 70.8 0 0 1 3.4-16.8m-3.5 19.3c1.4-6.6 6.9-5.8 6.9-5.8" />
      <path d="M454.8 311c5-2 4.3-6.3 5.2-8 1.3-2.7 2.3-3.5 2.3-3.5m-2.6 32.9c-1.7-4.2.3-5 .3-5m-1 3.6c-2.1-2.7-4.8-2.5-4.8-2.5m3.9-10.3c1.3-2.4 0-4.8 0-4.8m.6 16.3-3.8-4.9m2.3-30.4c.5-2-1-2.9-1-2.9" />
      <g transform="translate(442 224.2) scale(.1567)">
        <path
          id="do-a"
          fill="red"
          strokeWidth={2}
          d="M91.4 426a6 6 0 1 1-12 0 6 6 0 0 1 12 0z"
        />
      </g>
      <use xlinkHref="#do-a" transform="matrix(.1567 0 0 .18128 444.6 235.3)" />
      <use xlinkHref="#do-a" transform="translate(443.7 248.3) scale(.1567)" />
      <use xlinkHref="#do-a" transform="translate(440 252) scale(.16899)" />
      <use xlinkHref="#do-a" transform="translate(438.7 256.2) scale(.16899)" />
      <use xlinkHref="#do-a" transform="translate(440.3 257.8) scale(.16899)" />
      <use xlinkHref="#do-a" transform="translate(463.2 286) scale(.12289)" />
      <use xlinkHref="#do-a" transform="translate(464.3 287.3) scale(.12289)" />
      <path d="M458.8 316.6a1.8 1.8 0 0 0-1.1-1.2m14.7 24.1c1.6 1.2 2 .5 2 .5" />
    </g>
    <g fill="#006300">
      <path d="M298.2 271.8c-.9-3-.7-3.6-.7-3.6m-6.5-1.7s-.5-1.2.4-1.9c.4-.4 2.5.8 3.6-3.9 0 0-.7 0-2.1.7v-.4s-.4-1-.2-2.3c0 0 .7-1.1.7-1.6 0 0-1.3-.5-4 2.9 0 0-.2-.7-2.1-2 0 0-1 3-.5 4.6.4 1.3.4 1.8 1.8 2.7 0 0 1 .5 1.2 2l1.2-.1v-.7zm-2 3.4c-.3.2-.5.5-1.3.6-3.3.4-5.2-4-5.2-4-.1-1 .3-.5 1-.2.9.3 1.2 0 2.2 0 1.4-.2 2.9 1.1 2.9 1.1.8.8 1 2.3 1 2.3-.2.2-.5.2-.5.2zm-4-8c-3.4-1.5-5.5.2-5.5.2-.2.2.2.3.2.3 2.2.3 1.5.1 2.4 1.4 1.6 2.2 4.4 1.7 4.4 1.7.5.2 1.1.8 1.1.8-.2-1.9-2.5-4.4-2.5-4.4zm-6-14c-.7-.5-.6.4-.6.4-1.4-2.5-5.3-2.7-5.3-2.7a.7.7 0 0 1-.5-.3c-.6 0 .2 1.3.2 1.3 1.1 3.1 2.2 3.5 2.2 3.5-1.3.7-3.4-.9-3 .3 2.1 2.1 3.5 2.4 3.5 2.4 2.6.7 3.7 0 3.7 0 .6 1.1 1 1.3 1 1.3 2.4.7 2.9 2 2.9 2 0-2.6-1-5.7-1-5.7a12 12 0 0 0-3.1-2.5z" />
      <path d="M297.2 272.7c-1.3.4-1.4 1.3-1.4 1.3-1.2 1.7-5.6 0-5.6 0-1.4-.3-1-.7-1-.7a5.6 5.6 0 0 0 1.6-1 8.6 8.6 0 0 1-2.7-5c3.6-.7 4.7 0 4.7 0-.2-1.4-1.4-1.4-1.4-1.4-.3-.5.3-.5.3-.5a7.8 7.8 0 0 1 5 2.3c1.2 1.7.8 3.4.8 3.4.3 1.7-.3 1.6-.3 1.6zM282.3 258c-1.8-.5-2.8 0-2.8 0-1 .4-2.6-.6-2.6-.6-2.2-1.9-2.6-3-2.6-3 0-.3 1.9-.3 1.9-.3 2.6 0 3.2.5 3.2.5 1.3.7 1.2 1.4 1.6 1.7a5 5 0 0 1 1.4 1c.3.5.4.9-.1.7zm3.4 1c1.3-1.5 3-.5 3-.5 2.5.3 3.3-2.6 3.3-2.6l1-1.7c.1-.7-1.1-.1-1.1-.1-2.2.5-2.3.7-2.3.7l.4-3.4c0-.6-.6-.2-.6-.2-3.1 1.8-3.5 3.1-3.5 3.1l-1.3-2.4c-.4-1-.7.1-.7.1-.6 3-.3 3.2-.3 3.2.4 1.6.8 2 .8 2 .7 1 .7 1.4.7 1.4z" />
      <path d="M304.2 267c-.5.1-1.8 2.2-1.8 2.2-1.6-3-3.7-3.4-3.7-3.4-.4.1 0 .8 0 .8.7 1.6 0 2.8 0 2.8-.2 1.2 0 1.4 0 1.4-2.5-1.3-2.6-1.1-2.6-1.1 0 1.6 1.8 4.5 1.8 4.5l4.5-1 1.5-.2c1.2-3.6.3-6 .3-6zM284 250.8c1.6.7 1.7 1.8 1.7 1.8.4 1.3 4.1 1.7 4.1 1.7 3-.3 2.7-1 2.7-1-1.7-1.4-1.2-1.3-2-2-1.3-1.3-3-1.4-3-1.4-2.3.4-2.8 0-2.8 0-.9.4-.7.9-.7.9zm-3.6-5.4c-.7-2.7 1.7-6 1.7-6 2 3.8 1.7 4.8 1.7 4.8a24.6 24.6 0 0 1-1.7 4.5c-.4-2-1.4-2.3-1.7-3.3z" />
      <path d="M279 246.5c-2.5 0-5-2.9-5-2.9 3.9-1 4.7-.4 4.7-.4a22.7 22.7 0 0 1 3.6 2.5c-1.8 0-2.3.8-3.2.8z" />
      <path d="M277 242.8c-1.6.3-3-1.3-3-1.3-2.2-3-1.5-4-1.5-4 .2 0 .4.3.4.3.7.6 2 .8 2 .8-3.6-2.2-1.2-7.1-1.2-7.1.4-.5.6.7.6.7a4.6 4.6 0 0 0 1.8 2c.8 1 .8 1.4.8 1.4.3-1.6.8-1.2.8-1.2.4 1.3 1.9 2.3 2 3.2.6 2.5.2 2.8.2 2.8-.3 1.4-.3 2.5-.3 2.5-1.4-.5-2.5 0-2.5 0zm8.4 6c.8-1.2 0-3.3 0-3.3-.3-2.3 3.1-4.5 3.1-4.5 1 1.9.9 3 .9 3l3.2-.8c.1 1.4-1.3 3.6-1.3 3.6 2.1.6 2.9-.4 2.9-.4-1 4.7-5.6 3.8-5.6 3.8a8.8 8.8 0 0 0-3.2-1.4z" />
      <path d="M278.3 234.9c.3-2.9.8-3 .8-3 .3.1.4 1.4.8 1.6 1.8.8 1.8 2.8 1.8 2.8 0 2.3-.4 2-.4 2-2.5 0-3-3.4-3-3.4zm8.3.6c.9-3.3.3-3.6.3-3.6-.3 0-1 1.3-1.6 1.4-2.3.1-3 2.3-3 2.3-1 2.5-.5 2.4-.5 2.4 2.8 1 4.5-1.4 4.8-2.5z" />
      <path d="M278.4 229.5c.3-3.3 1-3.5 1-3.5.3.2.5 1.7 1 1.9 2 1 2 3.2 2 3.2 0 2.7-.4 2.5-.4 2.5-3 0-3.7-2.9-3.6-4zm9.4.8c1-3.2.4-3.5.4-3.5-.4 0-1.1 1.3-1.6 1.3a3.7 3.7 0 0 0-3.2 2.2c-.9 2.5-.4 2.5-.4 2.5 2.7 1 4.4-1.3 4.8-2.5zm3.8 9c2.7-2 2.5-2.6 2.5-2.6-.3-.2-1.7.4-2.1.2-2-1.3-3.9 0-3.9 0-2.2 1.4-1.8 1.6-1.8 1.6 1.6 2.5 4.4 1.6 5.3.9z" />
      <path d="M291.5 241.1c2.6-1.1 2.5-1.6 2.5-1.6-.2-.3-1.5 0-1.8-.3-1.4-1.2-3.1-.6-3.1-.6-2.1.8-1.8 1-1.8 1 .9 2.2 3.3 2 4.2 1.5zm-8.7-15.4c-1-3 2-7 2-7a40.5 40.5 0 0 1 1 3.4c2.4-2.5 4.6-2.9 4.6-2.9l-.1 2a6.8 6.8 0 0 0 2.3-.6c-.4 2.4-3.4 4.9-3.4 4.9-1.2.7-2.6.4-2.6.4-2.2.7-2.7 2.1-2.7 2.1-.2-1.3-.4 0-1.1-2.3zm4.4 10c1.4-1.7 3.5-1 3.5-1 2 .2 3.7-1.8 3.7-1.8a5.6 5.6 0 0 1 1.4-1.8c0-.5-.6-.4-.6-.4l-1.1.3c.9-3.3.4-3.4.4-3.4-.3 0-.5.2-.5.2-.5 1.5-2.6 1.4-2.6 1.4-.1-2.2-.6-1.9-.6-1.9-.3.6-1 1-1 1-2.1 2-2.1 2.9-2.1 2.9.1 2.4-.5 4.6-.5 4.6z" />
    </g>
    <g fill="#00863d">
      <path d="m286.8 247.7 1.4-1c.5-.3.3-.2.5-.7l.5-.7-.3.9 1.4-.8c0 .3-.5.5-.9.8a22.6 22.6 0 0 1-1 .6l-1.9 1.6c1.8-.4 1.4-.1 2.3-.2 1.9-.3 2.8-3 3.4-4.5a9.9 9.9 0 0 0-3.5 1.1c-1.2.8-1.2 1.6-1.9 3zm-4.8 6.7c0-.3-.4-.8-.6-1-.5-1-.5-1.2-1.2-2.3l-.5-1c.2 0 .6.8.9 1v-1c.3 0 .2.3.2.6 0 1 0 .9.6 2l1.3 2.2c0-.4-.2-.7-.3-1-.4-1.4.5-3.1-3-5.2l-.9-.5c0 1.7.3 4.5 1.8 5.4l1 .4.7.4zm-.8-21.5c0-.4-.3-.8-.4-1.3-.2-.4 0-.3-.4-.5l-.4-.5.5.2a3.3 3.3 0 0 0-.4-.8c-.3-.4-.2-.1-.5-.7.6-.1 1.2 1.7 1.3 2.1.5 1.4.4 1.2 1.3 2.3 0-.2-.4-.5-.4-.8-.2-.7.6-1.7-.2-3.4-.5-1-1.5-1-2-1.9l-.4-.8a7.6 7.6 0 0 0-.4 1.8c0 1.2.2 2.7 1 3.5.3.3 1 .7 1.4.8zm4.5-8.5c.2 0 .5-.5.8-.8l.8-.7-.1-.8c.2 0 0 0 .3.5l1-1.4c0 .3-.4 1-.6 1.2-.2.4-.4.7-.8 1l-1.6 2 1-.3c1-.2 1.4-.3 2.1-1.5a10 10 0 0 0 1.2-3.8c-1.5.6-3.1 1.3-3.9 2.7-.3.5-.2 1-.2 2zm-9.5 14.3c-.5-1-1.7-2.4-1.8-3l-.2-1.3c.3 0 .2 0 .2.2l.2 1 .5 1c0-.7 0-.4.2-1 .3.4-.1 1 .2 1.6l.8 1.2c0-1 .6-2.4-.4-3.7-.4-.5-.8-.7-1.3-1l-.9-1.4c-.7 1.5-.5 4.5.9 5.5l.8.5.4.2.4.2zm6.8-6c.6-.4.4-.6 1.8-1.7l.9-.9.9-.9c.1.3-.8 1.2-1.1 1.6h.6c-.1.4-.5.1-1 .3-.3 0-1.4 1.3-1.7 1.6l.8-.2c.9-.2 1.5 0 2.4-1.2.8-1 1-2.3 1.5-3.5-1.2.3-2.7 1-3.4 1.6-1 1-.9 1.7-1.2 2.6l-.5.8zm-4.8 9.3a4.9 4.9 0 0 0-.8-.8c-.5-.3-.6-.3-1.2-.4l-2-1.1c.2-.2.3.1.8.4l1 .4-.2-.5c.2 0 .2 0 .3.2v.3c1 .1.8.1 1.7.7 0-.4-.1-.4-.4-.6l-.5-.5-.4-.6c-.8-1.2-1.7-.7-2.2-.8l-1.5-.6a5.6 5.6 0 0 0 1.7 3.1c.4.4.9.8 1.6.9l2.1-.2zm-.8 7.5a8.1 8.1 0 0 0-1-.7c-.2-.2-.3-.2-.6-.2l-.7-.2h.7l-.3-.3-1-1c.2-.1.3 0 .5.2l2.3 1.8 1.1.6c0-.6-1-2.4-1.8-2.8l-3.7-1a15 15 0 0 0 1.5 2.8c1 1.5 1.2 1 2 .9h1zm1.8-8.1-1.4-4.6c.2.1.2.4.3 1l.4.9.3-.7c.2.2 0 .6 0 .9-.2.4-.2.3 0 .8l.6 1.6v-1c.3-1 .5-1.6 0-2.8-.5-1-1.3-1.7-2-2.5l-.3 1.8c-.2 1.2-.1 2.8.8 3.5.8.6.3.1 1.3 1zm2.7 5.8v-4.7c.2.1.2.3.2.4v1.5l.4-.7c.3.1 0 .4-.1.6l-.4.8.1 2.1.4-.8c.5-.7 1-1.8.8-2.8l-1.2-3.4-.8 1.6a7.3 7.3 0 0 0-.5 1.9c-.3 1.6.2 1.9.7 2.7l.4.8zm1.9-20.3c0-.4.2-2.5.1-2.7l-.2-.4-.2-.9c.3 0 .2.3.4.6v.1l.1-.6c0-.4 0-.2.2-.6.2.1 0 0 .1.2a3 3 0 0 1 0 .3c-.2 1.4-.2 3-.3 4.3l.4-.8c.3-.7 1-2 .9-2.8l-.8-4.1-.8 1.6c-.5 1.1-1 2.8-.7 4l.7 1.6v.2zm-11 23.6 1.1 1c.7.5 2.3 1.2 3.1 1.2l1.8-.4-.2-.8-1 .1a6.7 6.7 0 0 1-1.2 0 14.8 14.8 0 0 1-1-.2c-.6-.2-.4 0-.9-.4l2 .3c-.6-.4-.4-.2-.8-.7.3 0 .9.5 1.2.7l1.6-.1-.1-1c-.8-.3-2-.3-2.9 0-1.7.6-1 .4-2.7.3zm2.2 4.3c0 .3 1.8 2.3 2.2 2.5l3.9.1a16.1 16.1 0 0 0-1.7-.7c-.8-.3-.8-.2-2 0 0-.3.3-.3 1-.4l-1.5-.5-.2-.2h.5l4 1.5a4.5 4.5 0 0 1-1.1-1c-1.6-2-3.2-1.4-5.1-1.3zm13.3-21.3.5-1c.3-.7-.1-.7 0-1.5.3 0 .2 0 .3.7l.7-1.6c.2.6-.9 2.6-1.1 3.2l-.4 1c1-1 2-1.5 2.2-2.4l.1-4c-.6.5-1.5 1.4-2 2.1-.6 1-.6 2-.4 3.5zm-1.8 24.2 1-.5c1.5-.4.9.3 1.8-1l-.2.7c.7-.3.8-.7 1.3-1.2.2.3-.2.7-.4.9-.9.8-1.7.5-2.2.7l-1 .5c1.1-.2 1 0 2 .2 1.8.3 2.4-1.6 3-2.8l.5-.8a9.6 9.6 0 0 0-4.5 2.2l-.6.6c-.3.2-.5.2-.7.5z" />
      <path d="M286.4 247.5c.6-.6.5-2.1 1-3 0-.2.2-.3.3-.4.1-.2 0-.2.3-.2.1.2-.3.4-.4.7l-.3 1 .1-.1a.9.9 0 0 0 .1-.2c.5-.6.9-.8 1.6-1.2l-.7-2.4-1.2 1a5.6 5.6 0 0 0-1 1.2c-.8 1.5.1 2.2.2 3.6zm-.4 10 1.6-2.6v-1.2c.2 0 .1-.1.3.7.5-.8.2-.7.8-1a6 6 0 0 1-.8 1.4l-1.5 2.5c.4 0 .9-.6 1.1-.9l.6-.5.7-.4.7-3.6a10 10 0 0 0-2.7 2c-1 1.2-1 1.6-.8 3.6zm3.5-9 2-.3c0 .3-.3.3-.9.4l-3.6.1.9.5.8.4c.7.4 1.4.3 2.1 0l2.7-2.4c-1.4.3-.6.4-2.5 0l-1 1-.5.2zm-14.5-5c.6 1.2 2.3 2.6 3.8 2.4.7 0 .8-.3 1.2-.7h-.1a.7.7 0 0 0-.2-.1c-1.2-.3-1.3-.2-2.5 0l.5-.3-.9-.2-.8-.4c.2-.1.1-.1.4 0 1.5.5 1.9.4 3.6.7-.2-.5-1.5-1.2-2.2-1.3-1.2-.1-1.6.5-2.8-.1zm10 13.6-.5-3.3c.3 0 .2.2.3.9l.6 3c0-1.2.4-2 .1-3.2l-1.2-2.2a9 9 0 0 0-.3 2.7c0 1 .3 1.3.8 1.9l.2.2zm4.5-33.7.4-.5.5-.4c0 .3-.4.6-.6 1-.4.5-.7.6-.9.8-.7 1-.6.8-1.8 1.3 2.4.2 3.8-2.4 4.8-4.2-2.3.3-1.9.5-2.1 1.2l-.3.8zm.8 10.4.7-1.1c.4-.6.6-.2 1.3-.8-.2-.2-.2-.1-.9.1l1.2-1.5c-.7.1-2 2.3-2.3 2.8l-.8.9c.5-1.4.3-2.7 1-3.3l3.7-2.3c-.1.9-.5 2.1-.9 3-.6 1.1-1.5 1.6-3 2.2zm-9.2 4.4-1.1-1.6-.5-2.2c.3 0 .3.6.3.9l.3 1c.2-.8-.1-.3.3-1 .2.5-.3 1.1 0 1.5l.7 1c.3-1 .3-2.3-.3-3l-1.7-1.8c-.4.6-.4 2.4 0 3.3.3 1 .7 1.2 1.3 1.5l.7.4zm1.4-.3c.5-.5 1.5-1 1.7-1.3l1.4-2c-.3-.1-.5.5-.7.7l-.6.9c0-.8.2-.2 0-1-.4.4-.2 1.2-.6 1.5l-1.1.8c0-1.1.5-2.5 1.4-3l2.5-1.4c.2.9-.5 2.8-1.1 3.6-.8 1-1.2 1-2 1l-.9.2zm4.6.3c.6 0 2.5 0 3-.4l.8-.3c0 .2 0 0-.3.4h1.1c0 .1.2.1-.6.2l-2 .2-2.7.3c1.8.6 2 1.6 4 .8 1.6-.6 2-1.2 3-2.4-2.6.6-2.8-1.5-5.2 0l-1.1 1.2z" />
      <path d="M290.4 239.7c.6 0 .3 0 .9.2-.3.2-1.4 0-1.8 0h-1.8c.6.8 1.6 1.2 2.9 1 1.3-.1 1.7-.4 2.7-1l-2-.7zm-.8 11.5a3.2 3.2 0 0 0-.9-.5c-1-.5-2 0-2.5 0l-1.3-.2a6 6 0 0 0 2.4 1c1.7.3.5.7 2.3-.3zm.2 1.2.5.5c-.1 0-.3 0-.5-.2l-.1 1.2 2.3-.3a17 17 0 0 0-2-2.2l-.2 1zm-3 .7 1.4-1c-.3-.4-1-.3-1.5-.5l-1.3-.5.7 1 .7 1zm6.7-20.6c-.6.4-1 .9-1.7 1.2-.9.4-1.8 0-2.4.6 1.5-.1 2.5.5 3.7-.6.8-.7 1.4-1.7 2-2.6a2.7 2.7 0 0 0-1.2.4l-.3.5c-.3.4 0 0 0 .5zm-5 35 1 2.2 1.6 2 1-.7 1.3-.4c-.7-.3-.7-.6-1.1-.7h-1.7c.1-.3 0-.2.8-.2h.8c-.5-.5-1.1-.8-1.6-1.2l1.6.9v-1.1c.4 0 .1.7.3 1.3.1.2.6.6 1 .7.5.3.7.2 1.2.4l1.3.4c-.5-.8-.2.1-1.1-1.8a3.4 3.4 0 0 0-1.4-1.6c-1.5-.9-3.3-.3-5-.2zm1.9-2.3v-2.7l-.3-2.1c.2 0 .2.1.3.4l.1.6c.2-1 .3-1 .8-1.6 0 .2-.5 1-.6 2l-.1 2.7.2-.3.3-.3.5-.6c1.3-2 .5-3.2.5-3.8l.4-2a9.5 9.5 0 0 0-1.8 1.3c-1 1-2 2.8-1.3 4.3l.5 1 .4 1.1z" />
      <path d="m289.7 273 1.8.6c1.1.4 3 .5 3.8-.6.5-.6.8-.7 1.3-1.2-.8 0-1.5.4-2.2.5-.6.2-.6.6-1.1 1l-.4.3c0-.3.5-.8.8-1.1h-1.8c0-.3.6-.2 1.3-.2 1.5-.2 1.8-.6 3.4-.8a.7.7 0 0 0 .3 0c-2.4 0-3-1.7-5.9.4zm11-1.5v-1.2c-.5-.4-.5-.6-.8-1.2.3 0 .4.5.9.8 0-.6-.3-1.6-.5-2.2.3 0 .4.8.5 1.1.4 1.4 0 2.5.3 3l.7 1c.2-1 1.3-1.7 0-4.1-.7-1.5-1.3-1.8-2.5-2.7.1.7.3 1 .2 1.8l-.4 1.6c-.2 1.3.3 1.2.5 1.3l1.2.8zm-12-2.3-.3-.8c-1 0-1.3.4-2.8-.6-.3-.2-.3-.2-.5-.6l1.6 1-.6-1c0-.1 0-.2.1 0h.2l.7 1h1l-.2-.7c-.1-.4 0-.4-.3-.6a2.8 2.8 0 0 0-1.4-.6l-1.6.2-1.6-.3c0 .3.7 1.3.8 1.6.7 1 2.5 2.3 4 1.7l1-.3zm-8.4-7.5h.1l.2.1a3 3 0 0 1 1.1.8c.5.4.5.7 1.1 1.2 1 .9 2.1.8 3.5 1a7.2 7.2 0 0 0-.6-.7c-1.1-1.2-1-1.1-1.6-1H283c0-.2.7-.2 1.2-.3a3.1 3.1 0 0 0-.7-.3c-.6 0-.2 0-.9-.2.3-.4 1.8.2 2.5.8l1.6 1.8-.8-1.7c-.8-1.5-3-2-4.5-1.7a4 4 0 0 0-1 .2zm9.5 3.9c-.5-1.8-1.5-2.6-1.7-3.7-.2-.7-.1-.7 0-1.4.4.5-.3.8.8 2.6 0-.6-.2-.8-.1-1.5l.4-1.4c-.1-.3-1.4-1.5-1.7-1.9-.2 1.6-.6 3-.1 4.6.5 1.6 1.4 1.3 2.4 2.7zm8.6 8 1.1-.2a6.3 6.3 0 0 1-.7-1c-.5-.7-.4-.7-.2-1l.1.6.4.4c.2.4.4.6.8.9 0-.6-.2-.8 0-1.2.2.1 0 0 .1.2l.1 1 1.3-.4c-.9-1.5-2.5-2-4-2.6l.4 1.8.6 1.6zm-2-3.2-.5-1c-.4-1-.4-1.3-1.2-2.2l-.4-.4-.3-.3v-.1c.2 0 .8.6 1 .8.5.4 1.6 2.8 2 3.5-.1-.3-.3-.7-.2-1 .4-1-.5-2.4-1-2.7l-3.5-1.5c.4.4.7.6 1 1.2.2.6.3.1 1.2 1 1 1.1 1 2.4 2 2.7z" />
      <path d="m302.9 270.4.1-.5c.2-.3 0-.2.3-.4.2.2 0 .3-.1.7l-.7 2.5c.8-.1.7-.1 1-.7.3-.4.4-.9.5-1.3l-.1-3.3-1 1.3c-.5.7-.2.3 0 1.7zm-10.6-7.5c.3-.1.8-.8 1.1-1 .1.2-.5.9-.7 1-.6.6-.2 0-1 1 1.6.2 2.2-1.8 2.7-2.8l-1.5.4c-.2.1-.1 0-.2.3l-.1.4c0 .3-.2.5-.3.8z" />
    </g>
    <g fill="#ce1126" stroke="#000" strokeWidth={0.2}>
      <path d="m307.6 281.8 1.9 1-1.1 2.1c.8-.1 3.6-1.1 4.6-1.4-.3-.7-.4-.7-.3-1.6l-.3-1.5-2.3.8a19.2 19.2 0 0 1-2.5.6zm24.8-.3-1.9 1 1.1 2c-.8 0-3.6-1-4.6-1.3.3-.7.4-.8.3-1.6l.3-1.5 2.3.8 2.5.6z" />
      <path d="M314.4 284.8a12.4 12.4 0 0 0 4-1.4c.4.3 2.1 0 2.1 0a8.8 8.8 0 0 0 1.1-.2 10.1 10.1 0 0 0 3.8 1.6c1.9-.1 2-1.6 2-1.6l-.3-1.3c1-1.6 0-2.8 0-2.8-.6-.6-3.5.3-3.5.3-2 1-2 .5-2 .5-.6-.8-2.6-.7-3.5 0l-2.5-.6c-2.2-.9-2.5-.4-2.5-.4-.8 1-.5 2-.5 2l.1 1c-.4 2.8 1.8 3 1.8 3z" />
      <path d="M321.6 282.4c4.7 1.1 4.4 1.8 4.4 1.8-.3.5-1.7-.2-1.7-.2-3.6-1.2-2.7-1.6-2.7-1.6zm-2.9 0c-4.7 1.1-4.3 1.8-4.3 1.8.3.5 1.6-.2 1.6-.2 3.7-1.2 2.7-1.5 2.7-1.5z" />
      <path
        fill="#aa241e"
        d="M319 279.3c-2 .3-.5 1.8-.4 2.8 0 .5-.5 1.3 0 1.5.5.3 1.5 0 2.1 0 .8 0 1.3 0 1.2-1 0-.7-.3-1-.3-2 0-.6.1-1.4-.6-1.4a12.5 12.5 0 0 0-2 0z"
      />
      <path
        fill="none"
        d="M321.7 280.4c5.3 0 5-.9 5-.9m-5 2.5c5.4.7 4.7 1.5 4.7 1.5m-7.9-1.6c-5 1-4.5 1.9-4.5 1.9m4-3.5c-5.1.3-4.6-.5-4.6-.5"
      />
    </g>
    <path d="M298.1 274c-2.7 1-4.5 1.6-7 3.1l-3.3-5a7 7 0 0 0-2.2-1.8c-1.5-.7-2-.5-3 .3l-.6-1.3c-1.3-2.3-2.7-3.3-4.1-5.2l-1.4-1.5-.4-.5c.5 1.9 1 3.6 1.3 5.7-.8-.5-1.6-1-2.4-1.3a9 9 0 0 0-3-.5l1 .9a11.8 11.8 0 0 1 3.3 5.5 16.7 16.7 0 0 0 4.2 6.5 7.9 7.9 0 0 0 2 1.5c2 .8 1.9 0 2.6-.3a31.2 31.2 0 0 0 4.2 5.8 8 8 0 0 0 7.5 1.9c1.2-.3 2-.7 3-1.2 3.4-2 1.7-3.6 1.3-5.2a109 109 0 0 1 7.2-2c5.6-1 16-1.2 22.7-.2.6.1 7.3 1.9 8 2.3a5.4 5.4 0 0 0-.6 2.9c0 1.1 1 1.7 2 2.2a10 10 0 0 0 6.4 1.3 7.7 7.7 0 0 0 4.9-3.2c1.8-2 2.3-3.2 3.2-4.7 0 0 .5.5.9.6.3.1 1.5 0 1.8-.2.8-.3 1.4-1 2-1.5a15.5 15.5 0 0 0 4.1-6.6 12 12 0 0 1 4.3-6.3c-2.8.1-3.8.9-5.4 1.8l.6-3 .7-2.7-3.5 4c-.5.8-1.1 1.4-1.7 2.1-1.1 1.8-.9 1.8-1.3 2.4-4-2.2-5.8 3.1-8.4 6.4-5-2.8-9.3-3.6-15.2-4.7l-3.5-.4a88.7 88.7 0 0 0-22.7.2c-3.8.5-6.1 1.2-9.5 2z" />
    <g fill="#ce1126">
      <path d="M293 285.5c.5-1.3 1-1.6 2.2-2.1 3.6-1.7 5.4-2.4 9.5-3.5a53.1 53.1 0 0 1 7.2-1.3 67.4 67.4 0 0 1 12.3-.4 54.5 54.5 0 0 1 20.6 5.1c1.5.7 1.3.8 2.2 2.2 1-.8 1.9-2.4 2.5-3.4l1-2c.4-1.1-.3-1.5-.8-1.9-1.8-1.6-5.3-3-8.3-3.8a86.5 86.5 0 0 0-42.7 0 24.8 24.8 0 0 0-9 4.4c-.8.9.4 2.5.8 3.2l1 2 1.5 1.5z" />
      <path d="M280.5 274.2c1.4.3 2 .7 2.9 2 2 2.8 2.1 4.8 5.6 8.6a6 6 0 0 0 2.6 2.1 7.5 7.5 0 0 0 4.2.6 9 9 0 0 0 3.5-1.2s1.3-.7 1.7-1.2c.3-.4.4-1.5.4-1.5-1-.3-3 1.7-4.2 2.5-2.2 1.5-3 1-4.7-.5-1.3-1.1-1.8-2.4-2.7-4-.4-.6-1-1.5-.8-2.5l1.7-1.7-2.1-3.2c-.8-1.3-1.3-2.2-2.4-3-.6-.5-1.9-1.2-2.8-.7l-2 2c-.3.5-.7 1-.9 1.7z" />
      <path d="m278.1 268.8-2.1-1.3-2.7-1 1.5 1.7c1.6 2 1.6 3.8 3 6.4a16.3 16.3 0 0 0 4.2 5c1 .8 1.9 1 2.4.3.1-.5-1.1-1.3-1.7-1.6a11 11 0 0 1-2.1-1.4c-1.6-1.6-.4-3.5.8-4.9l.8-1c.2-.6-1.1-2.4-1.8-3.3-.7-.9-2.5-3-3.4-3.8l.5 2.5.6 2.4zm23.2 14.3-.6-1.5c-.9.1-5.1 2-6.1 2.6-.3.2-1.5 1.1-1 1.7 1.7 1.8 4.2-.8 5.6-2a3.1 3.1 0 0 1 2-.8z" />
      <path d="M285 279.7c-.3-.1-.3-.6-1.2-1.3-.4-.3-2.6-1.5-3-1.9 0 0-.6-.5-.6-1.2.1-.6.6-.7.6-.7 2 0 4.2 4.8 4.1 5zm74.6-5.4c-1.5.3-2 .7-2.9 2-2 2.8-2.1 4.8-5.6 8.6-.8.9-1.4 1.6-2.7 2.1a7.5 7.5 0 0 1-4.1.6 9 9 0 0 1-3.6-1.2s-1.3-.7-1.6-1.2a3.8 3.8 0 0 1-.4-1.5c1-.4 3 1.7 4.1 2.5 2.3 1.5 3.1 1 4.7-.5 1.4-1.1 1.9-2.4 2.8-4 .4-.6 1-1.5.8-2.5l-1.7-1.7 2-3.2c1-1.3 1.4-2.2 2.5-3 .6-.5 1.9-1.2 2.8-.7l1.9 2c.3.5.8 1 1 1.7z" />
      <path d="m362 268.9 2.1-1.3 2.6-1-1.4 1.7c-1.7 2-1.7 3.8-3 6.4a16.5 16.5 0 0 1-4.2 5c-1 .8-2.1.8-2.4.3-.1-.5 1-1.3 1.7-1.6.8-.4 1.5-1 2.1-1.4 1.6-1.6.4-3.5-.8-4.9l-.8-1a9 9 0 0 1 1.8-3.3l3.3-3.8c0 .7-.3 1.7-.5 2.5l-.5 2.4zm-23.2 14.3.6-1.5c.9.1 5.1 2 6.1 2.6.3.2 1.5 1.1 1 1.7-1.7 1.8-4.2-.8-5.7-2-.5-.3-1.1-.8-2-.8z" />
      <path d="M355.2 279.8c.2-.1.2-.7 1.1-1.4.4-.3 2.6-1.4 3-1.8 0 0 .6-.5.5-1.2 0-.6-.5-.7-.5-.7-2 0-4.2 4.8-4.1 5z" />
    </g>
    <path
      fill="#eac102"
      d="M297.4 277h-.6l-.9.4v.3c.2 0 .1.3.2.5l.2.6.2.8.2.8c0 .1-.2.4 0 .3l.7-.2c.1 0 .3-.2 0-.2-.1-.1 0-.4-.2-.6l-.1-.6c0-.2.3 0 .3.1l.5.5.6.3a.8.8 0 0 0 .6 0c-.3-.2-.6-.4-.7-.7l-.5-.6c.2-.2.5-.5.5-.8a1 1 0 0 0-.4-.9 1.3 1.3 0 0 0-.6 0zm-.2.2c.2 0 .3.2.4.3.1.2.2.4.1.7a.6.6 0 0 1-.3.4c-.1.1-.4.3-.5 0l-.2-1c0-.2.1-.3.3-.3a1 1 0 0 1 .2 0zm1.4-.7c0 .1.3.2.2.4l.2.7.2.7v.5l.2.6c0 .1-.2.3 0 .3l1.8-.5c.2 0 .2 0 .2-.2v-.6c-.2 0-.2.3-.3.4l-.9.4c-.1 0-.2-.1-.2-.3l-.1-.4-.2-.7h.7c.1 0 .2.2.3 0v-.5c-.1 0-.1-.4-.3-.3 0 .1 0 .3-.2.4a1.5 1.5 0 0 1-.5.1l-.1-.5c0-.2-.1-.5.1-.5a.8.8 0 0 1 .8 0c.1 0 .3.3.3 0 0-.1 0-.4-.2-.5h-.5l-1.5.5zm4.1-1.1h-.7l-.8.3c-.2.1.2.2.2.4v.5l.2.5.1.8.1.7v.4c.2 0 .5 0 .7-.2.2 0 .2-.1 0-.2v-.5l-.2-.6a2 2 0 0 0 1-.5.9.9 0 0 0 .4-.7 1.1 1.1 0 0 0-.2-.7 1 1 0 0 0-.4-.2h-.4zm.5 0zm-.8.2a.5.5 0 0 1 .5.4l.1.7c0 .1-.1.3-.3.3l-.4.2-.1-.4-.2-.8c0-.2 0-.3.2-.3a.8.8 0 0 1 .2 0zm3.3-.9.3.3v.5l.2.6v.5l.1.7a.6.6 0 0 1-.7.5.4.4 0 0 1-.3-.2 1 1 0 0 1-.2-.5l-.1-.7a7.9 7.9 0 0 0-.1-.7l-.1-.5c0-.1.2-.3 0-.3l-.8.1c-.2.2.1.2.1.4l.1.5.2 1v.5c0 .2.2.3.3.5.1.1.3.3.5.3.4 0 .8 0 1.1-.3l.3-.5-.1-.8-.1-.8-.1-.6a.5.5 0 0 1 0-.3c0-.1.2-.3 0-.3h-.4a.2.2 0 0 0-.2.1zm2.6-.5-1 .2-.5.1.2.4c0 .4 0 .8.2 1.1v.7l.1.8c0 .1-.2.3 0 .3l.5-.1a4.2 4.2 0 0 1 .6 0 3.8 3.8 0 0 0 .7-.3l.3-.3a.6.6 0 0 0 .2-.4c0-.2 0-.5-.3-.7l-.4-.2c-.1 0-.3-.1 0-.2a.8.8 0 0 0 .3-.5.6.6 0 0 0-.1-.5c0-.2-.3-.3-.5-.3a2 2 0 0 0-.3 0zm-.5.3c.3 0 .5 0 .7.2v.6c0 .2-.2.3-.4.4-.1 0-.4.1-.4-.1v-.5a4 4 0 0 1 0-.5zm.3 1.5.5.1c.2.1.2.4.2.6l-.1.5-.6.2c-.2-.1-.2-.4-.2-.5v-.9a.5.5 0 0 1 .2 0zm1.7-2s.2 0 .1.2l.1.6v.5l.1.7v1.2c-.1.1.1 0 .2 0h1.2l.6-.1v-.9c0 .2-.2.3-.3.4a.7.7 0 0 1-.3.2h-.3l-.4-.1v-.7l-.1-1.2v-.7c0-.1.2-.3 0-.3h-.4l-.4.1a.8.8 0 0 0-.1 0zm2.5-.3.1.2.1.4v.4l.2 1.6v.4s-.2.2-.1.3a4 4 0 0 0 1-.1l-.1-.2-.1-.4-.1-.7v-.6l-.1-.8v-.5s.2-.2 0-.2a5.5 5.5 0 0 0-.9.1zm4 2c-.2 0-.3.2-.4.3 0 .2-.3.2-.4.3-.3 0-.4-.1-.6-.3a1.6 1.6 0 0 1-.3-.5v-.5a3.4 3.4 0 0 1 0-.9c0-.2 0-.4.2-.5.2-.1.5 0 .7.1l.2.5c.2.2.2-.1.2-.2l.1-.4a1 1 0 0 0-.5-.2 1.2 1.2 0 0 0-1.1.2 1 1 0 0 0-.3.3 1 1 0 0 0-.1.4l-.2.6.3 1.2c0 .2.2.3.4.5l.5.2a1 1 0 0 0 .7-.2c.2 0 .3-.3.4-.4a1 1 0 0 0 .2-.4zm1.3-2.5h-.4l-.1.8-.2.5-.2 1.3-.3.7v.1h.7l-.2-.3v-.5c0-.2.3 0 .4 0l.5-.1.2.6s-.2.3 0 .3h.7c.2-.1 0-.3 0-.4l-.3-.8-.3-1-.3-1-.1-.2zm-.3.8.4 1.3-.2.1h-.4c-.1-.1 0-.3 0-.4l.1-.6.1-.4zm4.3-1-1 .1.2.3v2.9c0 .1-.4.3-.1.3h1.4a1 1 0 0 0 .4-.3l.4-.5.1-.7a2.7 2.7 0 0 0 0-.7l-.2-.6-.3-.4a1.7 1.7 0 0 0-.4-.2l-.5-.1zm0 .3c.3 0 .5.1.6.3a1 1 0 0 1 .1.5v1.4a1.4 1.4 0 0 1-.2.6l-.3.2-.5-.1v-2.6c0-.2.2-.3.4-.3zm3-.1a.8.8 0 0 0-.5.1l-.5.6-.2.8v.8l.2.5a1.1 1.1 0 0 0 1 .8c.3 0 .6-.2.8-.4l.4-.7v-1.2a2 2 0 0 0-.2-.6l-.4-.6a.9.9 0 0 0-.5-.1zm0 .2c.3 0 .5.3.5.5l.1.6v.9l-.1.6a1 1 0 0 1-.3.5c-.1.1-.3.2-.4 0-.2 0-.2-.3-.3-.4v-1.9c0-.2 0-.4.2-.6a.4.4 0 0 1 .4-.2zm1.4 3.5h.6c.1-.1-.2-.2-.1-.4a2 2 0 0 1 0-.6l.1-.6.1-.6.1-.5.1.5v.7l.2.6v.6c.1.2 0 .5.3.4.2 0 .1-.2.2-.3l.2-1 .2-.5.3-.9v2.5c0 .1-.3.3 0 .3h.6c.2.1.1 0 0-.1v-3.1s.2-.2 0-.2h-.7l-.2.5a9 9 0 0 1-.2.7l-.1.7s-.1.2-.1 0v-.6c0-.1-.2-.3-.1-.4l-.2-1c0-.2-.2 0-.4-.2h-.4v1.2l-.2 1.3-.1.5c0 .2-.1.3-.3.4zm3.3.3.6.1h.3l-.2-.4v-.6l.2-.5a22 22 0 0 1 0-1.1 1.3 1.3 0 0 1 0-.5l.2-.2c.1-.2-.1-.1-.2-.1l-.7-.1s.2.2.1.3v1.7l-.1.5a2.5 2.5 0 0 1 0 .5l-.2.4zm1.1.3h.5c.1 0 .3.1.2 0a.8.8 0 0 1-.1-.5v-.9a2 2 0 0 1 .1-.6v-.6c.2.1.2.3.3.5l.8 2c0 .2 0 .4.2.4s.2-.1.2-.3v-.5l.1-.5v-.6l.2-.6v-.6s.4-.2.2-.3h-.6l.2.4-.1 1.1-.1.6-.2-.5-.3-.6-.2-.6-.3-.7a3.5 3.5 0 0 1-.6-.1c-.2 0 0 .2 0 .4.1.3 0 .6 0 .8a4.2 4.2 0 0 1 0 .6l-.1.6-.1.6c0 .2-.2.3-.3.4zm3-3c.1.2.3.3.2.4v.5a3.1 3.1 0 0 1-.1.5l-.1.7v.5l-.1.3v.3l-.2.2c-.1.1.2 0 .3.1l.5.1s.1 0 0-.1v-1l.1-.5v-.4c.1-.2 0-.4.2-.6v-.4c0-.1 0-.3.2-.4a1.2 1.2 0 0 0-.4 0l-.4-.2a.2.2 0 0 0-.1 0zm1.1 2.4a2 2 0 0 0 .4 1.3c0 .2.3.2.4.3h.6c.1 0 .3 0 .4-.2l.3-.5c0-.2-.2.1-.3.2-.2.1-.5.2-.7 0a.8.8 0 0 1-.3-.4v-.5a7 7 0 0 1 0-.7v-.5l.3-.5a.5.5 0 0 1 .3-.2c.2 0 .3.2.4.3a.8.8 0 0 1 .1.5c0 .1.1.3.2.1l.2-.5c0-.2-.2-.3-.3-.4l-.3-.2h-.8a1.2 1.2 0 0 0-.3.4c-.2.1-.3.4-.4.6a2.6 2.6 0 0 0-.1.7v.2zm3.5-1.3-.6 1.4c0 .1 0 .3-.2.5l-.3.7-.3.4c-.1 0-.1.2 0 .2l.5.1c.2 0 0-.2 0-.3v-.4c.2-.2.4 0 .5 0h.4v.8c-.1 0 0 .2 0 .2l.5.2c.1 0 .3 0 .2-.1-.1-.3 0-.5 0-.8l-.1-.6v-2.1l-.5-.2zm0 .8v1.5l-.6-.1c-.1-.2.1-.3.1-.5l.4-.7v-.2zm1.5 3.3v-1.4l.2-.5v-.6c.2-.2.2 0 .2.1l.3 1 .2.6.2.9c0 .1.1.4.3.3l.2-.6.1-.6.2-1 .2-.8s.4-.2.1-.3c-.1 0-.3-.2-.5-.1l.1.4v.6a4.6 4.6 0 0 0-.2.5l-.1.6c-.2-.1-.1-.3-.2-.5l-.2-.7a6 6 0 0 1-.2-.7 2.1 2.1 0 0 1-.1-.5c-.1-.2-.4-.2-.5-.3-.2 0-.3 0-.2.2v1l-.3 1-.1.6-.3.4c-.2.2.2.2.3.3a.7.7 0 0 0 .3 0zm3.4-2.3-.3.7-.4.7-.8 1.3s-.2.2 0 .2l.5.2v-.8l.5.1c.1.1.4 0 .4.3l-.1.6c-.1 0-.2.1 0 .2l.3.1c.2 0 .3.2.4.1v-3.6l-.5-.1zm0 .7v1.6l-.5-.2s-.3 0-.2-.2l.3-.7.3-.5z"
    />
    <g transform="matrix(.89273 0 0 .89274 -125.5 -33.3)">
      <path
        fill="#fff"
        d="M474.5 281v40.6c0 3.6 0 5.9 1.8 8.1a11 11 0 0 0 6 4.2c1.7.3 7.7.2 9.8.2 4.6-.3 5.2.8 7 3 2-3.1 4.1-3.2 8.2-3 2 0 6.6.1 8.4-.3a9.4 9.4 0 0 0 5.4-3.3c2.4-2.7 2.2-6 2.2-9.6v-38.3c0-1.8-.2-1.3.7-2.2l5.8-6H468l6.4 6.7z"
      />
      <path fill="#002d62" d="M493.8 299v-24.7h-25.5l6.3 6.7v18z" />
      <path
        fill="#ce1126"
        d="M504 299v-24.7h26l-6.7 7.1v17.7zm-10.2 10.3h-19.3l-.1 15.6c.9 6.8 6 9.2 10.4 9.1h9z"
      />
      <path fill="#002d62" d="M504 309.3h19.4V325c-.5 6.8-6 9.2-10.5 9.1h-9z" />
      <path
        fill="none"
        stroke="#000"
        strokeWidth={0.5}
        d="M474.6 281v40.6c0 3.6 0 5.8 1.8 8.3a9.2 9.2 0 0 0 6 4c1.7.3 7.7.2 9.8.2 2.7 0 3.9-.2 5.7 1.6.6.6.7.8 1.1 1.5a8.1 8.1 0 0 1 3-2.8c1.4-.5 3.8-.3 5.4-.3 2.1 0 6.6.1 8.4-.3a10.6 10.6 0 0 0 5.4-3.3c2.4-2.7 2.2-6 2.2-9.6v-38.3c0-1.8-.2-1.3.7-2.2l5.8-6h-61.7l6.4 6.7z"
      />
      <path
        fill="#eac102"
        stroke="#000"
        strokeWidth={0.3}
        d="M498 280.4v2.8h-3v2.3h2.8v10h2.3v-10h2.9v-2.3h-2.9v-2.8z"
      />
      <g id="do-b">
        <path
          fill="#fff"
          d="M481.9 284v4.6l-1.9-2 .3 32c0 4.7 3.4 8.6 7.6 8.6 4.2 0 7.6-3.8 7.7-8.5l-.3-16.4-2-2.2-.1-1.7z"
        />
        <path
          fill="#002d62"
          d="M481.9 284.2v4.6l-1.9-2 .2 18.2 8.2 7.9v-17.4l-.2-.4v-3z"
        />
        <path
          fill="#ce1126"
          d="m490.8 295.5 2.4 3v1.1l-2.4-2.5zm4.5 7 .2 11.4c-1.2 2.2-3.6 1-3.6 1l.1-15.8z"
        />
        <path
          fill="#002d62"
          d="M495.6 319.6c-3.2 2.4-4-1-4-1a4.4 4.4 0 0 0 4-3z"
        />
        <path
          fill="#ce1126"
          d="M480.2 309.7a54 54 0 0 0 8 7.5c1 7.7 5.5 5.1 7.1 4-1 3.6-3.9 6.2-7.4 6.2-4.2 0-7.6-3.9-7.6-8.6z"
        />
        <path
          fill="none"
          stroke="#000"
          strokeWidth={0.3}
          d="M493.2 299.6v-1.1L481.9 284v4zM480 286.7l.3 31.9c0 4.7 3.4 8.6 7.7 8.6 4.1 0 7.5-3.8 7.6-8.5l-.3-16.4z"
        />
        <g fill="#eac102" stroke="#000" strokeWidth={0.1}>
          <path d="M486.2 281.2c-.8-1.4-.6-2-.1-2.6l-3-3 .9 4.2c.8-.2 1.4 0 2.2 1.4zm-3-5.6 3 5.6" />
          <path d="m498 300.7-.7.3-12-20.4.8-.4z" />
          <path d="M485 280.6c-.1-.2 0-.5.5-.7.3-.2.7-.2.8 0 0 .2-.1.5-.5.7-.3.2-.7.2-.8 0zm-4 1.6c-1-1.3-.9-2-.4-2.6l-3.3-2.6 1.4 4c.8-.3 1.4-.1 2.3 1.2zm-3.7-5.2 3.7 5.2" />
          <path d="m495.3 300-.7.4-14.4-18.7.6-.5z" />
          <path d="M479.8 281.8c-.2-.2 0-.6.3-.8.4-.3.7-.3.9-.1 0 .1 0 .5-.4.7s-.7.3-.8.1zm.4 4.6c-1.1-1.3-1.1-2-.7-2.6l-3.6-2.2 1.8 3.9c.8-.4 1.4-.4 2.5.9zm-4.3-4.8 4.3 4.7" />
          <path d="m495.7 302.9-16.4-17 .6-.5 16.4 17z" />
          <path d="M478.9 286c-.2-.1 0-.5.3-.8.3-.3.6-.4.8-.2.1.2 0 .5-.3.8-.3.3-.7.4-.8.2z" />
        </g>
      </g>
      <use xlinkHref="#do-b" transform="matrix(-1 0 0 1 998.3 0)" />
      <g stroke="#000" strokeWidth={0.2}>
        <path
          fill="#ce1126"
          d="m496.7 314.5-.6 10.1c-.6 0-1.9-.1-2-1 0-.4 1.3-8.7 1.3-9.5l1.3.4z"
        />
        <path
          fill="#002d62"
          d="m495.8 314.1-.3 3.1c.2 1 1.4.8 2 .9l.2-5.2a16.5 16.5 0 0 1-2 1.2z"
        />
        <path
          fill="#002d62"
          d="M495.9 327c1.6-2 4.8-.5 4.8-.5 3.4.8 2.5-3.1 2.5-3.1-.7-7.8-1.5-13.2-1.5-13.2l-5 3.4z"
        />
        <path
          fill="#002d62"
          d="M495.9 327.2c-.4 2.3 2 2 2 2 2.7 0 1.9-3 1.9-3-3-.9-4 1-4 1z"
        />
        <path
          fill="#ce1126"
          d="m497.8 312.7-.2 9c.1 2.1 2.5 1 2.5 1 .6-.3 1.2-.1 1.2-.1v-2.8c4-.3 3-2.6 3-2.6-1.6-7.6-1.8-7.3-1.8-7.3z"
        />
        <path fill="none" d="M501.3 319.8c-2.5 0-3.6 1-3.6 1v.2" />
        <path
          fill="#fff"
          d="m501 326.4-.9-15.1 1.8-1.2 1.5 14.2v.1c0 2.7-2.4 2-2.4 2z"
        />
      </g>
      <g fill="#fff" stroke="#000">
        <path
          fill="#000"
          stroke="none"
          d="m488.2 302.2 6.8 12.4 14.7-9.7-7.7-11.2z"
        />
        <path strokeWidth={0.3} d="m488.5 302.1 13.7-8 7.6 10.8-14.6 9.4z" />
        <path
          fill="#000"
          stroke="none"
          d="m495.4 313.5 13.7-8.8-1-1.7-6.9-9.3-5 4-6.3 3.5-1.1-.7.2 1.5z"
        />
        <path
          strokeWidth={0.1}
          d="M496.2 297.8c-2-1-4.4 2-5 2.6-.8.6-2.1.3-2.1.3l6.2 11c1.8.8 3-1.5 3.8-2.3 1.6-1.3 3.4-1.2 3.4-1.2z"
        />
        <path
          strokeWidth={0.1}
          d="M496.4 297.9c0-2.4 3-3.1 3.7-3.6.8-.4 1-1.9 1-1.9l7 10.6c-.2 2-2.6 2.3-3.6 2.8-1.8 1-2 2.5-2 2.5zm-1.4 13.9a595.6 595.6 0 0 0-6.1-11v1.2c4.6 7.5 6.5 11.5 6.5 11.5l-.4-1.7z"
        />
        <path
          fill="#000"
          stroke="none"
          d="M490.9 302.2v.2l.1-.1.2.1h-.2l.1.2.2-.2-.3.3-.2-.4h-.1l.4-.3v.2h-.2zm.4-.3.2.4v.2c-.1 0 0 0 0-.1l-.1-.1-.2-.3zm.5-.3v.1h-.2v.1h.4v.3a.2.2 0 0 1-.2 0v.1l-.1-.1h.2c.1 0 .1-.1 0-.1h-.1l-.2-.1v-.2a.2.2 0 0 1 .1 0v-.1zm.5.2v.1h-.2v-.1l.1-.1v-.1h-.1v.1c-.1 0 0 0 0 0a.2.2 0 0 1 0-.2l.2.1v.2h.1-.1zm0 0v-.1l-.1.1zm.1-.4.1-.1h.1l.2.2-.1.2v-.1l-.1-.1v-.1h-.1v.2h.1l-.1.2v-.2l-.1-.1h-.1l.1-.1zm.3-.4.1.1h.1v.3h.1-.1l-.2-.2a.5.5 0 0 0 0-.2zm.3 0a.2.2 0 0 1 .2 0 .2.2 0 0 1 .1.1.2.2 0 0 1 0 .2.1.1 0 0 1-.2 0 .2.2 0 0 1-.1-.3zm0 0v.1l.2.2v-.3h-.1zm-1.6 2 .1.2v-.1l.2.2h-.2l.1.1h.1l.1-.1v-.1.2l-.3.2v-.1l-.2-.3.3-.3v.1h-.1zm.7.2-.3-.2.1-.1v.1h.2c0-.1 0-.2-.1-.1v-.1.2l.1.2zm.3-.3v.2h-.2v-.2l.1-.1c0-.1-.1 0-.1 0a.2.2 0 0 1 .1-.2l.1.1.1.2zm0 0zm.2-.4c.1-.1.2 0 .2 0l.1.1v.2c-.1 0 0 0 0 0l-.2-.2v-.1.4l-.1-.2-.1-.1v-.1zm.4-.3h.1v.3h.2v.2a.4.4 0 0 1-.2 0l-.1-.1v-.1a.1.1 0 0 1-.1 0v-.2a.2.2 0 0 1 .1 0zm0 0v.2c.1 0 .1 0 0 0a.3.3 0 0 0 0-.1zm.2.4s-.1 0 0 .1l.1-.1h-.1zm.3-.5h-.2l.1.2.1-.1a.2.2 0 0 1 0 .1h-.2a.3.3 0 0 1 0-.1c-.1 0 0-.2 0-.2a.1.1 0 0 1 .1 0 .3.3 0 0 1 .1 0zm-.1 0h-.1.1zm0-.4.3.4h.1l-.2.1v-.1l-.2-.3v-.1zm.2-.1h.1v.1l-.1-.1zm.2.1.1.3v.1c-.1 0 0 0 0 0l-.1-.1-.1-.2zm.2-.1a.2.2 0 0 1 .1 0l.1.2a.2.2 0 0 1 0 .1.1.1 0 0 1-.2 0 .2.2 0 0 1 0-.3zm0 0v.3h.2v-.2h-.2c0-.1 0-.1 0 0zm-2 2.2.1.2c0-.1-.2-.1-.2 0h.2l.2.1v.2a.2.2 0 0 1-.2.1l-.2-.1h.3v-.1h-.4a.2.2 0 0 1 0-.3.2.2 0 0 1 .2 0zm.6 0-.2.2h.2a.2.2 0 0 1 0 .1h-.2a.2.2 0 0 1-.1 0v-.3a.1.1 0 0 1 .2 0zm-.1.1h-.1zm.2-.3h.1v.1a.2.2 0 0 1 0 .1v.1h.2v.1a.4.4 0 0 1-.2.1l-.1-.1a.2.2 0 0 1 0-.1.1.1 0 0 1-.1 0v-.3a.2.2 0 0 1 .1 0zm0 0v.2s.1 0 0 0a.3.3 0 0 0 0-.2zm.2.4s-.1 0 0 0c0 0 .1 0 0 0zm.2-.7.2.3-.2.2-.2-.3.2.2h.1v-.1l-.1-.2zm.3-.1v-.1h.2l.1.2-.1.2v-.2l-.1-.1s-.1 0 0 0v.4c-.1 0 0 0 0 0l-.2-.2v-.2zm.6-.6v.1h-.2v.1h.4v.3a.2.2 0 0 1-.2 0v.1l-.1-.1h.2v-.1h-.3a.2.2 0 0 1 0-.3.2.2 0 0 1 .1 0v-.1zm.5.2-.1.1h-.1a.2.2 0 0 1 0-.2v-.1.1c-.1 0 0 0 0 0a.2.2 0 0 1 0-.2.1.1 0 0 1 .2 0v.2h.1v.1h-.1zm0 0-.1-.1v.1zm.1-.4.1-.1h.1l.2.2-.1.2-.1-.2v-.1h-.1v.2h.1l-.1.2v-.2l-.2-.1.1-.1zm.4-.5.3-.1.1.3v.2a.2.2 0 0 1-.1.1h-.1v-.1h.1v-.2l-.2-.2zm.7-.2.1.3h.1-.1l-.1.2a.1.1 0 0 1-.1 0l-.2-.3h.1l.1.2h.1v-.4h-.1zm.4.1v.1h-.2v-.3.1c-.1 0 0 0 0-.1h.2v.1h.1v.1h-.1zm0 0v-.1l-.1.1zm.1-.4.1-.1h.1l.2.2-.1.1-.1-.1v-.1h-.1v.2h.1l-.1.2v-.3h-.2l.1-.1zm-2.7 4.7.1.1a.2.2 0 0 0-.2 0 .2.2 0 0 0-.1.2l.1.2h.3v-.2.1a.2.2 0 0 1 0 .2.2.2 0 0 1-.3 0 .3.3 0 0 1-.1-.4.3.3 0 0 1 .2-.1v-.1zm.6 0-.2.2v.1c.1 0 0 0 0 0v.1-.2l-.1-.4.4.3a.1.1 0 0 0 .1 0l-.2.1v-.1zm0 0h-.3v.2l.2-.1zm.2-.2.1.2h.1l-.2.1v-.1l-.1-.3h-.1l.2-.2h.1c.1 0 .1.1 0 .2a.3.3 0 0 1 0 .1zm0 0 .1-.1a.1.1 0 0 0 0-.2l-.2.1.1.2zm.6 0h-.2l-.1-.4h-.1l.1-.1v.1l.2.3h.1zm.1-.8.1.1h-.2l.2.4h.1l-.2.2c.1 0 0-.1 0-.2l-.1-.3h-.1v.2l-.1-.1.3-.3zm.4-.2h.2v.3l.1.1a.3.3 0 0 1-.2.2.2.2 0 0 1-.2-.1v-.2h-.2l.2-.2v.1l.1.2.1.1a.2.2 0 0 0 .2 0 .1.1 0 0 0 0-.2l-.2-.2c0-.1 0 0 0 0zm.7 0 .1.1-.4.2c.1 0 0 0 0 0l-.1-.4h-.1l.2-.1v.1l.1.3h.1l.1-.1v-.1zm.1-.5h.3a.3.3 0 0 1 .1.3.3.3 0 0 1-.3.2.3.3 0 0 1-.2-.1.3.3 0 0 1 0-.3.3.3 0 0 1 .1-.1zm0 0a.1.1 0 0 0 0 .2.4.4 0 0 0 0 .2h.2a.2.2 0 0 0 .2-.1.4.4 0 0 0-.1-.2.2.2 0 0 0-.2-.1zm1-.6h-.1v.7l-.4-.3h.1l.3.2v-.3s0-.1-.1 0l.1-.2zm.4.3-.2.2v-.2l-.2-.3.1-.1v.1l.2.3h.1zm.2-.1-.1.1v-.1l-.2-.3h-.1l.2-.2v.2l.1.3h.1zm.3-.2-.2.2v-.1l-.2-.4h-.1l.2-.1v.1l.2.3zm-4 4.2v-.2h.2v.1a.1.1 0 0 1 .2.1.2.2 0 0 1 0 .2.3.3 0 0 1-.1.1c.1-.1.1-.2 0-.2h-.1a.1.1 0 0 0 0-.2h-.1zm.4-.3v-.2l.3.4h.1l-.1.2v-.2l-.2-.2h-.1zm.7-.5.2-.1v.4c0 .1 0 .1.1 0v.1l-.2.1v-.2l-.3-.1.1-.2v.1l.2.1v-.2zm.8 0v.1h-.2a.2.2 0 0 1 0-.3v-.2l.3.3v.1zm0 0v-.2h-.2v.1l.1.1h.1zm.1-.3.2.1v-.1h.1v.2a.1.1 0 0 1-.2 0 .3.3 0 0 1-.1-.2.2.2 0 0 1 0-.1.1.1 0 0 1 .2 0zm0 0h.2l-.1-.1s-.1 0 0 .1zm.6-.2a.2.2 0 0 1 0 .2.1.1 0 0 1-.2 0l-.1-.1v-.2a.1.1 0 0 1 .2 0h-.1v.1a.2.2 0 0 0 0 .1.1.1 0 0 0 .2 0v-.1zm-.1-.4zm.1.1.2.3c-.1 0 0 0 0 0h-.1l-.1-.2zm.4.1v.1h-.2v-.1a1 1 0 0 1 .1-.1.1.1 0 0 0 0-.1h-.1v.1-.1h.1l.2.2zm0 0v-.1l-.1.1a.2.2 0 0 0 .1 0zm.1-.6.2-.1.1.3v.2s-.1 0 0 0v-.1l-.2-.3zm.4 0 .2.2.1-.1v.1a.1.1 0 0 1-.2 0 .2.2 0 0 1 0-.1.2.2 0 0 1 0-.2h.2zm0 0h.2s0-.1-.1 0zm.4-.3c-.1.1 0 .2 0 .1h.1a.1.1 0 0 1 .1.1v.1h-.2.1v-.1h-.2v-.1a.2.2 0 0 1 0-.1h.1zm.4-.2.1.2v.1c-.1.1-.2.1-.2 0l-.2-.1v-.1l.2.2h.1v-.2h-.1zm.2-.2c0 .1 0 0 0 0-.1.1 0 .2 0 .2h.1a.1.1 0 0 1 .1 0v.2h-.2c0-.1 0 0 0 0h.2v-.2h-.3v-.1h.1v-.1zm.6 0v.1h-.2v-.1l.1-.1a.1.1 0 0 0 0-.1h-.1v.1-.1h.1c.1 0 0 0 0 0l.2.2h-.1zm0 0v-.1h-.2l.1.2a.2.2 0 0 0 0-.1zm-4.5 3.5.2.4h.1-.1l-.2-.3s-.1 0 0 0v-.2zm.3 0a.2.2 0 0 1 .2 0 .2.2 0 0 1 0 .1.2.2 0 0 1 0 .2.1.1 0 0 1-.1 0 .2.2 0 0 1-.2-.2.2.2 0 0 1 .1-.1zm0 0a.3.3 0 0 0 .1.3h.1v-.2l-.1-.1zm.4-.3v.1h-.1s0 .1 0 0h.2a.1.1 0 0 1 0 .2v.1h-.2.2v-.2h-.2v-.2h.1zm.2-.3s.1 0 0 0zm.1.1.2.3v.2c-.1 0 0 0 0 0v-.3l-.2-.1zm.4-.2.2.2v.1l-.2.1-.2-.1v-.2l.2.2s.1 0 0 0v-.2zm.5 0-.1.2h-.2a.2.2 0 0 1 0-.3h.1v-.2h-.1l.3.3v.1zm0 0h-.2v-.1c-.1 0-.1 0 0 .1v.1h.1zm-.1-.5c0 .1 0 0 0 0zm.1.2.2.2v.1c-.1 0 0 0 0 0h-.1l-.1-.2v-.1zm.2-.2a.2.2 0 0 1 .2 0 .2.2 0 0 1 .1.2.2.2 0 0 1 0 .1.1.1 0 0 1-.2 0 .2.2 0 0 1-.1-.2.2.2 0 0 1 0-.1zm0 0v.1a.3.3 0 0 0 .1.2h.2v-.2h-.2zm.4-.2v.1h.2v.2h-.1s0 .1 0 0h-.1.2v-.1h-.3a.1.1 0 0 1 0-.2h.1zm.5-.4.3.4v.2c-.1 0 0 0 0 0v-.2h-.4a.2.2 0 0 1 0-.2v-.1h.1zm.1.3v-.1h-.2l.1.2a.1.1 0 0 0 .1 0zm.3-.5.1.3v.1h-.2l-.1-.2h-.1.1l.1.2h.1v-.3h-.1zm.2 0 .1.2.1-.1v.1a.1.1 0 0 1-.2 0 .2.2 0 0 1 0-.1.2.2 0 0 1 0-.2.1.1 0 0 1 .1 0l-.1.2zm0 0h.1l-.1-.1v.1zm.3-.5.3.4v.1c-.1 0 0 0 0 0l-.1-.1-.2-.3v-.1zm.3.2h.2v-.1h.1v.2a.1.1 0 0 1-.2 0 .2.2 0 0 1-.1-.1.2.2 0 0 1 0-.2.1.1 0 0 1 .2 0zm0 0 .2-.2h-.1s-.1 0 0 .1zm-3.7 3.1.1.3.1-.2a.1.1 0 0 1 .1 0l.1.2h.1l-.1.2v-.2l-.1-.1h-.1v.3h.1-.1v-.1l-.2-.3zm.7.2c-.1.1-.2.1-.2 0a1 1 0 0 1 0-.2c0 .1-.1.1-.1 0 .1 0 .1-.1.2 0l.1.1c.1 0 0 0 0 0 0 .1 0 .1 0 0zm0 0-.1-.2v.2zm0-.4.1-.1h.2a.2.2 0 0 1 0 .3c-.1 0-.1.1-.2 0l-.2-.3zm0 0 .2.2h.1v-.2h-.2zm.3-.4zm.1.1.2.3-.1.1v-.1l-.1-.1v-.1zm.4.2h-.2v-.1a1 1 0 0 1 .1-.1h-.1l.1-.1.2.2s0 .1 0 0zm0 0v-.2l-.1.1v.1h.1zm.1-.4v-.1h.2l.1.2v.1l-.2-.2v.2h.1l-.1.1-.1-.2h-.1a.2.2 0 0 1 0-.1zm.8-.3a.2.2 0 0 1 0 .2.1.1 0 0 1-.2 0h-.1v-.3a.1.1 0 0 1 .2 0h-.1l-.1.1a.2.2 0 0 0 .1.2.1.1 0 0 0 .2 0v-.2zm0-.3v.1-.1h.1v.4h.1l-.1.1-.1-.2s-.1 0 0 0v-.2zm.2 0 .2.1v-.1h.1v.2a.1.1 0 0 1-.2 0 .2.2 0 0 1-.1-.2.2.2 0 0 1 0-.1.1.1 0 0 1 .2 0zm0 0h.2l-.1-.1s-.1 0 0 0a.1.1 0 0 0 0 .1zm.2-.5v.1zm.1.2.2.2v.2c-.1 0 0 0 0 0l-.1-.2-.1-.1v-.1zm.5 0-.1.2h-.2a.2.2 0 0 1 0-.3h.1v-.2h-.1l.3.3s.1 0 0 0v.1zm0 0h-.1l-.1-.1v.2h.2zm0-.4a.2.2 0 0 1 .3 0 .2.2 0 0 1 0 .2.2.2 0 0 1 0 .2.2.2 0 0 1-.2 0 .2.2 0 0 1 0-.3zm0 0v.2a.3.3 0 0 0 .2.1h.1v-.1l-.1-.1h-.1zm-1-9.2.2.1a.1.1 0 0 0-.3 0v.1h.3a.1.1 0 0 1 .1.2h-.1l-.1.1v-.1h.1v-.1h-.2c-.1-.1-.1-.2 0-.2v-.1zm.2-.1zm0 0 .2.3h.1l-.1.1-.1-.2v-.1zm.3 0 .1-.1.2.2v-.3.4l-.2-.2zm.4-.3a.1.1 0 0 1 .2 0v.3a.2.2 0 0 1-.2-.1.1.1 0 0 1 0-.2zm0 0v.2h.2v-.1s-.1-.1-.1 0zm.4-.2h-.1v.1h.2v.2h-.1c.1 0 0-.1 0-.1h-.1v-.2zm.2-.1a.1.1 0 0 1 .1 0l.1.2s-.1.1-.2 0a.2.2 0 0 1-.1 0 .1.1 0 0 1 0-.2zm0 0v.2h.2v-.1l-.2-.1zm.1-.3v.1h.2v.2c.1 0 0 0 0 0 0 .1 0 0 0 0l-.1-.1c-.1 0 0 0 0 0v-.2zm.3 0s.1 0 0 0v.2h.2l-.2.1v-.2h-.1zm.2-.1a.1.1 0 0 1 .1 0l.1.2h-.1a.2.2 0 0 1-.2 0 .1.1 0 0 1 0-.2.1.1 0 0 1 .1 0zm0 0v.1l.1.1h.1v-.1l-.2-.1zm.3-.2v.1h.1s.1 0 0 .1v.1a45 45 0 0 1-.1 0h.2l-.1-.1h-.1v-.2zm-2 2.4v-.1h.1c0-.1.1-.1.1 0l.1.1a.1.1 0 0 1-.1.1v.1h.1l-.1.1-.2-.3zm0 0h.2c0 .1 0 .1 0 0v-.1h-.1zm.3-.2h.2v.1a.1.1 0 0 1-.1 0 .2.2 0 0 1-.1-.1.1.1 0 0 1 0-.2.1.1 0 0 1 .2 0zm0 0 .2-.1h-.2zm.3-.3s.1 0 0 0v.2h.2l-.2.1v-.2h-.1zm.2 0v-.2h.2c0-.1.1 0 .1 0l.1.1v.1-.1l-.1-.1h-.1v.2h.1l-.1.1v-.2h-.2l.1.2a54.8 54.8 0 0 1 0 .1v-.1l-.2-.1v-.1h.1zm.6-.2c-.1.1-.2 0-.1 0v-.1c0-.1 0-.1 0 0h-.1v-.1h.1l.2.1v.1zm0 0v-.1a.3.3 0 0 0-.1 0v.1a.2.2 0 0 0 .1 0zm.1-.3v-.1h.2v.2h.1-.1v-.1h-.2l.1.2-.1-.2h-.1zm.3-.1h.2a.1.1 0 0 1-.2 0 .1.1 0 0 1 0-.2.1.1 0 0 1 .1 0zm0 0 .1-.1h-.1zm.5-.2v.1a.1.1 0 0 1-.2 0h-.1a.1.1 0 0 1 0-.2h.2-.2a.2.2 0 0 0 0 .2h.2v-.1zm0-.2.1.1h.1v-.1.2a.1.1 0 0 1-.2 0 .2.2 0 0 1 0-.2.1.1 0 0 1 0-.1.1.1 0 0 1 .1 0zm0 0h.1c0-.1 0-.1-.1 0zm.2-.2.1-.1v.4h.1c-.1 0 0 0 0 0l-.2-.2zm.3 0h.2a.1.1 0 0 1-.2 0 .2.2 0 0 1-.1 0 .1.1 0 0 1 0-.2.1.1 0 0 1 .2 0zm0 0v-.1zm0-.5c.1 0 .2 0 .1.1zm.2.2.1.2h.1-.1l-.1-.1v-.1zm.2-.2c0 .1 0 0 0 0v.1h.1s.1.1 0 .2h-.1.2s0-.1-.1 0h-.1v-.4zm-2.7 3h.2v-.1.1a.1.1 0 0 1-.1 0 .2.2 0 0 1-.1 0 .1.1 0 0 1 0-.2.1.1 0 0 1 .1 0zm0-.1h.1c0-.1 0-.1-.1 0zm.3-.2v-.1h.1l.1.1v.1l-.1-.2h-.1v.2h.1v.1l-.2-.2zm.4-.3v-.1h.2v-.1h.1l.1.2-.1-.2h-.1v.4h.1a51.1 51.1 0 0 1-.1 0v-.1h-.2l.1.2h-.1v-.2h-.1zm.3-.5s.1 0 0 0c0 .1 0 0 0 0zm.1.1.2.3c-.1 0 0 0 0 0h-.1v-.2h-.1zm.2 0 .1-.1v-.1h.2s.1.2 0 .2a.1.1 0 0 1 0 .1v.2l-.2-.3zm.2 0c0 .1.1.1.1 0v-.1h-.1zm.4-.1c-.1.1-.1 0-.1 0v-.2.1h-.1v-.1h.2v.1h.1s0 .1 0 0zm0 0v-.1h-.1c0 .1 0 .2.1.1zm0-.5.2.3v.1l-.2-.3v-.1zm.5.2-.1.1h-.1v-.2s-.1 0 0 0v-.1l.2.2zm0 0-.1-.1v.2a.2.2 0 0 0 0-.1zm0-.3v-.1h.2a.2.2 0 0 1 0 .2.1.1 0 0 1 0 .1h-.1l-.2-.3.1.1zm0 0 .1.2h.1v-.2h-.1zm.3-.2c.1 0 .1 0 0 0l.1.2v.1l-.1-.2v-.1zm.4 0v.1h-.2l.1-.2h-.1c0 .1 0 0 0 0h.1l.1.1zm0 0h-.1s0 .1 0 0zm-2.6 2.4c-.1.1 0 .1 0 .1h.1v.2a45 45 0 0 1-.1 0h.1v-.1h-.2v-.2h.1zm.2 0h.2v.1a.1.1 0 0 1-.2 0 .2.2 0 0 1 0-.1.1.1 0 0 1 0-.1.1.1 0 0 1 .1 0zm0 0v-.1zm.2-.3h.1v.2h.1a67.3 67.3 0 0 0-.1.1l-.1-.2zm.2 0 .1.1h.1v-.1.1a.1.1 0 0 1-.1 0 .2.2 0 0 1-.1 0 .1.1 0 0 1 0-.2.1.1 0 0 1 .2 0zm0 0h.1c0-.1 0-.1 0 0zm.2-.4zm0 .1.2.3-.1-.2s-.1 0 0 0zm.3-.1c-.1.1 0 .1 0 .1h.1v.2h-.1.1v-.1h-.2v-.2h.1zm.2-.1.1-.1.2.2v-.2h-.1v-.1l.1.3-.2-.1h-.1zm.4-.2.1.1h.1v-.1.2a.1.1 0 0 1-.2 0 .2.2 0 0 1 0-.2.1.1 0 0 1 0-.1.1.1 0 0 1 .1 0zm0 0h.1c0-.1 0-.1-.1 0zm.2-.3v.1l.1-.1v.4h.1c-.1 0 0 0 0 0l-.2-.2zm.5 0a.1.1 0 0 1-.1.2.2.2 0 0 1-.2 0 .2.2 0 0 1 0-.3h.1v-.2l.2.3v.1zm0 0h-.1c0-.1-.1-.1-.1 0v.1h.2zm.2 0h-.1v-.2h-.1.2c0 .1.1 0 .1 0v.2zm0 0v-.2l-.1.1s0 .1.1 0zm.3-.3a.1.1 0 0 1 0 .1.2.2 0 0 1-.2 0 .2.2 0 0 1 0-.2v-.2l.2.3h.1zm0 0v-.1h-.2l.1.2h.1zm0-.2.2.1h.1v-.1.1a.1.1 0 0 1-.2 0 .1.1 0 0 1 0-.2.1.1 0 0 1 .1 0zm0 0h.2c0-.1 0-.1-.1 0zm.3-.3h.1v.2h.1l-.1.2v-.1l-.1-.2zm.4 0v.2l-.1-.1v-.2.1h-.1v-.1h.2v.2h.1zm0 0h-.1c0 .1 0 .2.1.1zm.1-.2v-.1h.2v-.1h.1l.1.2c.1 0 0 0 0 0l-.1-.2h-.1v.4h.1c-.1 0 0 0 0 0h-.1v-.1h-.2l.1.2-.1-.2zm.5-.2h.2v.1a.1.1 0 0 1-.2 0 .2.2 0 0 1-.1-.1.1.1 0 0 1 0-.2.1.1 0 0 1 .2 0zm0 0v-.1zm.2-.2v-.2h.2v.2h.1v.1l-.1-.2h-.1v.4l-.1-.2v-.1zm.2-.4v.1h.1v.2h.2-.2v-.1h-.1a.2.2 0 0 0 0-.2zm.3.1v.1h.2v-.1.2a.1.1 0 0 1-.2 0 .2.2 0 0 1 0-.2.1.1 0 0 1 0-.1h.1zm0 0c0-.1 0-.1 0 0zm-4.5 3.8v-.1h.2v-.1h.1l.1.2-.1-.1h-.1v.2h.1a51.1 51.1 0 0 1-.1 0v-.1h-.2l.1.2-.1-.2h-.1zm.3-.5s.1 0 0 .1zm.1.2.2.2c-.1 0 0 0 0 0h-.1v-.1h-.1v-.1zm.3-.2c0 .1 0 0 0 0l-.1.1h.2v.2h-.1c.1 0 0-.1 0 0h-.1v-.3zm.5 0a.1.1 0 0 1 0 .1.2.2 0 0 1-.2 0 .2.2 0 0 1 0-.2v-.2l.2.2s.1 0 0 0v.1zm0 0v-.1c-.1 0-.2-.1-.2 0l.1.2.1-.1zm0-.5c0 .1 0 0 0 0zm0 .1.2.3-.1-.2h-.1zm.3-.1h-.1v.1h.2v.2h-.1.1v-.1h-.2v-.2zm.4 0v.1a.1.1 0 0 1-.2 0 .1.1 0 0 1 0-.2h.1-.2a.2.2 0 0 0 .1.2h.1v-.1zm-.1-.4zm0 .1.2.3h.1-.1l-.1-.2zm.2 0 .1-.1h.2v.2a.1.1 0 0 1 0 .1h-.1v.1h.1-.1l-.2-.3zm0 0 .2.2c.1 0 0-.1 0-.2h-.1zm.2-.4s.1 0 0 0c0 .1 0 0 0 0zm.1.1.2.3-.2-.2zm.1-.2.2.4h.1-.1l-.2-.3zm.3 0a.1.1 0 0 1 .1 0l.1.2-.1.1a.2.2 0 0 1-.2-.1.1.1 0 0 1 0-.2.1.1 0 0 1 .1 0zm0 0v.2h.2v-.1h-.2zm.3-.2c0 .1 0 0 0 0v.1h.1s.1.1 0 .2a45 45 0 0 1-.1 0h.2s0-.1-.1 0h-.1v-.4zm-1.7 4.3v-.2a.1.1 0 0 1 .1 0v.1a.1.1 0 0 1 .2.1.2.2 0 0 1 0 .2h-.1c.1 0 0-.1 0-.2h-.1v-.1h-.1zm.6-.1-.2.2v-.4h-.1v.1-.1a.1.1 0 0 1 .1 0h.1v.3h.1v-.1zm.2 0zm.2-.7.2-.1v.6-.1l-.1-.1-.3-.1.1-.2v.1l.2.1v-.2zm.7 0a.1.1 0 0 1-.1.1l-.1-.1a.1.1 0 0 1 0-.2h.2s0 .1-.1 0c0 0-.1 0 0 .1a.2.2 0 0 0 0 .1h.1zm.1-.3a.1.1 0 0 1 .1 0l.1.1-.1.2a.2.2 0 0 1-.2-.2.1.1 0 0 1 0-.1.1.1 0 0 1 .1 0zm0 0v.1l.1.1h.1v-.2h-.2zm.3-.1v-.2h.1l.1.2v.1l-.1-.2h-.1v.2h.1v.1l-.2-.2v-.1zm.3-.3a.1.1 0 0 1 .1 0l.1.2s0 .1-.1 0a.2.2 0 0 1-.2 0 .1.1 0 0 1 0-.2zm0 0v.3l.2-.1v-.1c-.1 0-.2-.1-.2 0zm.5 0a.1.1 0 0 1-.2.1v-.1a.1.1 0 0 1 0-.2h.1l-.2.1a.2.2 0 0 0 .1.1h.1zm0-.2h.2v.1a.1.1 0 0 1-.1 0 .2.2 0 0 1-.1-.1.1.1 0 0 1 0-.1.1.1 0 0 1 .1 0zm0 0h.1l-.1-.1zm.2-.3h.1v.2h.1v.1c-.1 0 0 0 0 0l-.2-.2zm.3 0v.1h.2v-.1.1a.1.1 0 0 1-.2 0 .1.1 0 0 1 0-.2h.1zm0 0c0-.1 0-.1 0 0zm0-.4h.1zm.2.1.1.2h.1l-.1.1-.1-.2zm.2-.1h.1-.1v.1h.1s.1.1 0 .1v.1h-.1.2l-.1-.1h-.1v-.2zm.2-.4.3.4h-.1l-.2-.3zm.5.3c-.1.1-.2 0-.2 0l.1-.1h-.1v-.1h.2v.2zm0 0v-.1h-.1v.1zm-4 3.3v-.1l.2.2v-.3.4l-.2-.2zm.3-.2.1.1h.1v-.1.2a.1.1 0 0 1-.1 0 .2.2 0 0 1-.1-.2.1.1 0 0 1 0-.1.1.1 0 0 1 .2 0zm0 0h.1c0-.1 0-.1 0 0zm.3-.3v.1-.1.4h.2-.2v-.2h-.1zm.4.1a.1.1 0 0 1 0 .1.2.2 0 0 1-.2 0 .2.2 0 0 1 0-.2v-.2l.2.2s.1 0 0 0v.1zm0 0v-.1c-.1 0-.2-.1-.2 0l.1.2.1-.1zm.3-.2-.1.1h-.1v-.2s-.1 0 0 0h.2c0 .1 0 0 0 0v.2zm0 0h-.1s0 .1 0 0zm.3-.1a.1.1 0 0 1-.1 0 .2.2 0 0 1-.2 0 .2.2 0 0 1 0-.2h.1v-.2h-.1l.3.3zm0 0-.1-.2h-.2v.1l.2.1zm.2 0v-.1h-.1c.1 0 .1 0 0 0v.1zm0-.5.1-.1.2.2v-.2h-.1v-.1l.1.3v.2s-.1 0 0 0v-.2l-.2-.1h-.1zm.4-.5.3.4h-.1l-.2-.3v-.1zm.5.2-.1.1s-.1 0 0 0v-.2h-.1v-.1h.1l.1.2zm0 0v-.1l-.1.1s0 .1 0 0zm0-.3.2-.1.2.2v-.2h-.1v-.1l.1.3-.2-.1h-.1zm.5-.2h.2v.1a.1.1 0 0 1-.2 0 .1.1 0 0 1 0-.2.1.1 0 0 1 .1 0zm0 0h.1l-.1-.1a.1.1 0 0 0 0 .1zm.2-.3h.1v.2h.1l-.1.2v-.1l-.1-.2zm.5 0a.1.1 0 0 1-.1.2.2.2 0 0 1-.2 0 .2.2 0 0 1 0-.3h.1v-.2l.2.3v.1zm0 0h-.1c0-.1-.1-.1-.1 0v.1h.2zm.2 0h-.1v-.2s-.1 0 0 0h-.1v-.1h.2v.2h.1zm0-.1v-.1h-.1v.2a.2.2 0 0 0 .1-.1zm.3-.2a.1.1 0 0 1 0 .1.2.2 0 0 1-.2 0 .2.2 0 0 1 0-.2v-.2l.2.3h.1zm0 0v-.1h-.2l.1.2h.1zm.3-.5c.2 0 .2.1.2.2 0 0-.1.2-.2.1a.2.2 0 0 1-.1-.1.1.1 0 0 1 0-.1zm0 0v.4h.2l-.1-.2h-.1zm.3-.2v.1h-.1.2v.2l-.1.1c0-.1 0 0 0 0l.1-.1h-.2v-.2zm-4.6 3.8v.2l.2-.1.2.2h-.1l-.1-.2h-.1v.1l.1.2h-.1l-.1-.3v-.1zm.6.1-.1.1h-.1v-.2c0 .1 0 0 0 0h.1l.1.1zm0 0h-.1s0 .1 0 0zm0-.3h.1v.2h.1l-.1.1-.1-.2v-.1zm.4 0v.2l-.2-.1.1-.2s-.1 0 0 0c-.1.1-.1 0-.1 0h.1l.1.1h.1s0 .1 0 0zm0 0a.3.3 0 0 0-.1 0v.1a.2.2 0 0 0 .1 0zm.1-.5.2.3h.1l-.1.1-.2-.3v-.1zm.2-.1zm0 0 .2.3v.1-.1l-.1-.1s-.1 0 0 0v-.1zm.3 0h.2a.2.2 0 0 1 0 .2.1.1 0 0 1-.1 0l-.3-.2v-.1zm0 0v.2h.2v-.2h-.2zm.2-.2h.1v.2h.1a67.3 67.3 0 0 0-.1.1l-.1-.2zm.2 0 .1.1h.2v-.1.1a.1.1 0 0 1-.2 0 .2.2 0 0 1-.1 0 .1.1 0 0 1 0-.2.1.1 0 0 1 .2 0zm0 0h.1c0-.1 0-.1 0 0zm.4-.3h-.1v.1h.2v.2h-.1v-.1h-.1v-.2zm.2.1z"
        />
      </g>
    </g>
  </svg>
)

export default DoFlag
