// This file is generated by @lib/ui/country/codegen/generateFlags.ts
import { SvgIconProps } from '@lib/ui/icons/SvgIconProps'

const BzFlag = (props: SvgIconProps) => (
  <svg
    width="1em"
    height="0.75em"
    xmlns="http://www.w3.org/2000/svg"
    xmlnsXlink="http://www.w3.org/1999/xlink"
    id="flag-icons-bz"
    viewBox="0 0 640 480"
    {...props}
  >
    <defs>
      <radialGradient id="bz-a">
        <stop offset={0} stopColor="#ffef5d" />
        <stop offset={1} stopColor="#ea5700" />
      </radialGradient>
      <radialGradient id="bz-b">
        <stop offset={0} stopColor="#952d1a" />
        <stop offset={1} stopColor="#570a00" />
      </radialGradient>
      <radialGradient
        xlinkHref="#bz-a"
        id="bz-c"
        cx={247.1}
        cy={238.3}
        r={36}
        fx={247.1}
        fy={238.3}
        gradientTransform="scale(1.22624 .8155)"
        gradientUnits="userSpaceOnUse"
      />
      <radialGradient
        xlinkHref="#bz-a"
        id="bz-d"
        cx={322}
        cy={152.9}
        r={10.6}
        fx={322}
        fy={152.9}
        gradientTransform="scale(.93615 1.06821)"
        gradientUnits="userSpaceOnUse"
      />
      <radialGradient
        xlinkHref="#bz-b"
        id="bz-e"
        cx={364.2}
        cy={237.8}
        r={36}
        fx={364.2}
        fy={237.8}
        gradientTransform="scale(1.2242 .81686)"
        gradientUnits="userSpaceOnUse"
      />
      <radialGradient
        xlinkHref="#bz-b"
        id="bz-f"
        cx={468.1}
        cy={156.1}
        r={10.7}
        fx={468.1}
        fy={156.1}
        gradientTransform="scale(.95596 1.04607)"
        gradientUnits="userSpaceOnUse"
      />
    </defs>
    <path fill="#ce1126" d="M0 0h640v480H0z" />
    <path fill="#003f87" d="M0 34.3h640v411.4H0z" />
    <circle cx={320} cy={240} r={188.6} fill="#fff" />
    <circle
      cx={320}
      cy={239}
      r={156.3}
      fill="none"
      stroke="#552300"
      strokeWidth={3.9}
    />
    <path
      fill="#007f00"
      d="M302 73.2c14-15.2 26.9 2.3 26.5 10.6C328.2 92 314 110 301 95.5c13.4 3.4 17.4-11.5 24.1-11.7-6.7.2-9.5-14.6-23.2-10.6zm-147.2 119c-7.4-19.4 14-23 21.3-19 7.3 3.9 17.3 24.6-1.6 29.6 9-10.4-2.7-20.5.2-26.6-2.9 6-17.5 2-19.9 16zM471.9 173c19.4 7.6 7.6 25.8-.2 28.4-7.9 2.7-30-4-21-21.2 1.6 13.6 17 12 19.7 18.1-2.6-6.2 10.3-14 1.5-25.3zM218.8 377.4c-20.7-2-14.3-22.7-7.5-27.4 6.8-4.7 30-4.3 26 14.7-5.3-12.6-19.7-6.8-24-12 4.3 5.2-6 16.3 5.5 24.7zm209.3-15c.3 20.7-21.1 16.8-26.6 10.6-5.4-6.2-7.7-29 11.8-27.3-12 6.6-4.6 20.2-9.4 25 4.8-4.8 17.1 4 24.2-8.2zM170 153c-1.9-20.6 19.8-18.3 25.7-12.6 6 5.8 10 28.4-9.6 28.2 11.5-7.6 3-20.5 7.4-25.6-4.4 5-17.3-2.8-23.5 10zm22.2 193c-20.5-3.5-12.7-23.7-5.6-27.9 7-4.2 30.1-2.3 25 16.4-4.5-13-19.3-8-23.1-13.6 3.8 5.5-7.2 16 3.7 25zM354.3 74c18.6-9.2 24.3 11.7 21 19.3-3.2 7.5-23 19.4-29.8 1.3 11.2 7.9 20.3-4.7 26.7-2.4-6.4-2.3-3.7-17-17.9-18.2zM394 388.3c-9.3 18.5-26.5 5.3-28.5-2.7s6.5-29.3 23-19c-13.8.5-13.4 16-19.8 18 6.4-2 13.3 11.4 25.3 3.7zm90.5-178.7c15.6 13.7-1.7 26.8-10 26.7-8.2-.1-26.8-13.8-12.5-27-3 13.4 12 17 12.4 23.6-.3-6.7 14.5-9.8 10-23.3zm-263-108.8c4.7-20 24.5-11.2 28.4-3.9 3.8 7.3.5 30-18 23.8 13.3-3.7 9.3-18.6 15-22-5.7 3.4-15.5-8-25.4 2.1zm-61.6 172.5c-18.2-10-4.2-26.5 4-28.1 8-1.7 29.2 7.7 18 23.7.2-13.7-15.4-14-17.2-20.5 1.8 6.5-12 12.7-4.8 25zm263.6-159.6c20.6-3 19.4 18.7 14 24.8-5.5 6.2-28 11.4-28.9-8 8.2 11 20.8 1.9 26.2 6-5.4-4.1 1.9-17.3-11.3-22.8zM306.3 408.1c-19 8.4-23.8-12.7-20.3-20 3.6-7.5 23.9-18.6 30-.1-11-8.4-20.5 3.8-26.8 1.3 6.3 2.5 3 17.2 17.1 18.8zM476.8 293c8.6 18.8-12.6 23.7-20.1 20.2-7.5-3.5-18.8-23.6-.2-29.7-8.4 10.9 4 20.3 1.4 26.6 2.5-6.3 17.3-3 19-17.1zm-325.1-60.6c-12-17 8-25.7 16-23.6 8 2 22.8 19.8 5.7 29.2 6.2-12.3-7.6-19.3-6.3-25.9-1.3 6.6-16.5 6.1-15.4 20.2zM264 395.6c-19.6 7.1-23-14.2-18.9-21.4 4-7.2 25-16.9 29.9 2-10.3-9.1-20.7 2.4-26.8-.5 6 2.9 1.8 17.3 15.8 19.9zm-5.7-314c11.6-17.2 27-2 28 6.3.9 8.1-10.3 28.2-25.4 15.8 13.8 1.3 15.4-14 22-15.2-6.6 1.2-11.7-13-24.6-7zm200.2 252.1c1.3 20.6-20.3 17.7-26 11.7-5.8-5.9-9.1-28.6 10.4-27.8-11.7 7.2-3.6 20.4-8.2 25.4 4.6-5 17.3 3.3 23.8-9.3zm-5.3-194.4c20.4 4 12 24 4.7 28-7.2 4-30.2 1.3-24.4-17.2 4 13.1 19 8.7 22.6 14.4-3.6-5.7 7.7-15.7-3-25.2zm-258.4-14.6c.2-20.6 21.5-16.2 26.8-9.9 5.3 6.3 7 29.3-12.4 27 12.2-6.3 5-20 10-24.7-5 4.7-17-4.5-24.4 7.6zM169 311c-18.6-9.4-5.1-26.4 2.9-28.3 8-2 29.5 6.7 19 23-.4-13.7-16-13.4-18-19.8 2 6.4-11.6 13.1-4 25zM392 91c19.5-7.3 23 14 19 21.2-4 7.2-24.9 17.1-29.9-1.7 10.4 9 20.7-2.6 26.9.3-6.2-2.9-2-17.3-16-19.8zm-41.3 314.8c-15.2 14.2-26.7-4.1-25.8-12.3.9-8.2 16.3-25.3 28.2-9.9-13-4.3-18 10.4-24.9 10 6.8.4 8.5 15.3 22.5 12.2zm132.7-158c14.2 15.1-4.4 26.5-12.6 25.5-8.2-.9-25.4-16.3-9.8-28-4.4 13 10.3 18 10 24.7.3-6.7 15.4-8.4 12.4-22.2z"
    />
    <path
      fill="#005800"
      d="M301 95.5c13.4 3.4 16.7-11.3 23.5-11.5-4 4.7-14.2 16.7-23.5 11.5zm1-22.3c14-15.2 26.9 2.3 26.5 10.6-11.5-20-15-17-26.6-10.6zM174.4 202.8c9-10.4-2.8-19.9 0-26 2.6 5.6 8.9 20.1 0 26zm-19.7-10.7c-7.4-19.3 14-22.9 21.3-19-23.1 1.4-22 6-21.3 19zm295.9-11.8c1.6 13.5 16.7 11.3 19.3 17.5-5.9-2-21-7.1-19.3-17.6zm21.2-7.3c19.4 7.6 7.6 25.8-.3 28.4 14.7-17.8 10.5-20 .3-28.4zM237.3 364.7c-5.3-12.6-19.2-6.4-23.4-11.7 6.2.3 22 1.2 23.4 11.7zm-18.5 12.7c-20.7-2-14.3-22.7-7.5-27.4-9.2 21.1-4.6 22.1 7.5 27.4zm194.5-31.7c-12 6.6-4.2 19.6-9 24.3-.4-6-1.3-21.8 9-24.3zm14.8 16.7c.3 20.7-21.1 16.8-26.6 10.6 22.3 6.6 22.7 2 26.6-10.6zM186 168.4c11.5-7.5 2.7-19.8 7-25 1 6.1 3 21.8-7 25zM169.9 153c-1.9-20.6 19.8-18.3 25.7-12.6-22.7-4.9-22.8-.2-25.7 12.6zm41.5 181.5c-4.4-13-18.7-7.6-22.5-13.2 6.1.7 21.9 2.7 22.5 13.2zM192.1 346c-20.5-3.5-12.7-23.7-5.6-27.9-10.6 20.5-6 21.8 5.6 27.9zM345.4 94.6c11.3 7.9 19.7-4.7 26.1-2.5-5.4 3-19.3 10.6-26 2.5zm8.9-20.6c18.6-9.2 24.3 11.7 21 19.3-3.5-22.8-8-21.1-21-19.3zm34.2 292.6c-13.8.5-12.8 15.6-19.3 17.6 2.5-5.6 9-20 19.3-17.5zm5.5 21.7c-9.3 18.5-26.5 5.3-28.5-2.7 16.7 16 19.2 12 28.5 2.7zm68-179c-3.1 13.4 11.9 16.3 12.2 23-4.9-3.8-17.2-13.7-12.2-23zm22.5.3c15.6 13.7-1.7 26.8-10 26.7 19.9-12 16.7-15.4 10-26.7zm-252.6-89c13.3-3.6 8.8-18 14.6-21.5-1 6-4 21.5-14.6 21.6zm-10.4-19.8c4.7-20 24.5-11.2 28.4-3.9-20-11.7-21.6-7.2-28.4 4zm-39.5 168c.1-13.6-15.2-13.3-17-19.8 5.6 2.7 19.9 9.7 17 19.9zm-22 4.5c-18.3-10-4.3-26.5 3.9-28.1-16.8 15.9-13 18.6-4 28.1zm248.6-142.8c8.2 11 20.2 1.6 25.6 5.7-6.1 1.2-21.7 4.1-25.6-5.7zm14.9-16.8c20.6-3 19.4 18.7 14 24.8 3.7-22.7-1-22.5-14-24.8zM316 388c-11-8.4-19.9 3.9-26.1 1.4 5.5-2.8 19.7-9.8 26-1.4zm-9.7 20.1c-19 8.4-23.8-12.7-20.3-20 2.7 22.8 7.2 21.4 20.3 20zm150.2-124.7c-8.4 10.9 4 19.7 1.5 25.9-2.8-5.4-10-19.5-1.5-26zm20.3 9.5c8.6 18.8-12.6 23.7-20.1 20.2 23-2.8 21.6-7.2 20.1-20.2zm-303.3-55c6.2-12.3-7.7-18.6-6.4-25.2 3.8 4.8 13.5 17.3 6.4 25.2zm-21.8-5.7c-12-16.9 8-25.5 16-23.5-22.1 7-19.8 11-16 23.6zm123.3 144c-10.3-9.1-20 2.5-26.2-.4 5.7-2.4 20.4-8.5 26.2.3zm-11 19.4c-19.6 7.1-23-14.2-18.9-21.4 1.1 23 5.7 21.9 18.9 21.4zm-3-291.9c13.7 1.3 14.7-13.8 21.3-15-3.1 5.3-11.4 18.8-21.4 15zm-2.7-22.2c11.6-17.1 27-1.8 28 6.3-14.5-18-17.6-14.3-28-6.3zM443 317.6c-11.7 7.2-3.3 19.8-7.9 24.8-.7-6.1-2.3-21.8 8-24.8zm15.6 16.1c1.3 20.6-20.3 17.7-26 11.7 22.4 5.7 22.7 1 26-11.7zm-25-183.6c4 13.1 18.5 8.3 22.1 14-6-1-21.8-3.5-22-14zm19.7-10.8c20.4 4 12 24 4.7 28 11.3-20.1 6.8-21.6-4.7-28zm-244 2.6c12.2-6.4 4.7-19.6 9.6-24.2.3 6.1.8 21.9-9.6 24.2zm-14.4-17.2c.2-20.6 21.5-16.2 26.8-9.9-22-7.1-22.6-2.4-26.8 10zm-4 181c-.3-13.7-15.6-12.8-17.6-19.2 5.7 2.4 20.2 9 17.6 19.2zM169 311c-18.5-9.4-5-26.4 3-28.3-16.2 16.4-12.3 19-3 28.3zm212.2-200.4c10.4 9 20-2.8 26.2 0-5.7 2.6-20.3 8.7-26.2 0zM392 91c19.5-7.3 23 14 19 21.3-1.2-23-5.8-21.9-19-21.3zm-38.9 292.6c-13-4.3-17.4 10.2-24.2 10 4.3-4.5 15.4-15.8 24.2-10zm-2.4 22.2c-15.2 14.2-26.7-4.1-25.8-12.3 10 20.7 13.8 17.9 25.8 12.3zM461 245.3c-4.4 13 10.2 17.3 9.9 24-4.5-4.2-15.8-15.3-9.9-24zm22.4 2.5c14.2 15.1-4.4 26.5-12.6 25.5 21-9.9 18.1-13.6 12.6-25.5z"
    />
    <g fill="#730000" stroke="#000" strokeWidth={0.5}>
      <path d="M349 120.3s.6-1.3 1.7-.6c1 .8 1.3 4.2 1.3 4.2l-1.6.8s.9-1.3-1.3-4.4zm-8.8 30.7s.8-1-.3-3.4l1.5-.5s.6 1.8-.2 3.9h-1m27-5.4-3.7 2.3 1.9.8 4.5-2.6-2.7-.5m-49.7 14.6c-1 .8-1 2.1-1.7 3-.4.7-2 1.8-2 3-.2 1.1-.3 1.9.2 3.5.6 1.5 3 8.5 2 13.7-1 5.3-.6 7.5-.3 8.3.4.8 1.6 3 2.3 3 1.6-.2.9-.7 1.5-1.7 1.4-2.5 0-22.2-.7-27.6-.5-4.2-2.5-8-2.7-8.4l-.8-2.6c-1.5-3.5-3.3-6.5-3.3-13.9 0 0-4.7 1.1-8.8-8.2-2.2-4.7-5.3-4.2-9-5.7l1.6-1.1s3.2 1.6 4.7 1.6c1.6 0 1-3.2 1-3.2l1.7-1.5v6.8c0 3.1 4.3 7.4 6.8 8.7 1.6.8 3.6-2.4 3.1-5.6-.5-3 0-7.3 0-7.3l2.2 1.3s-.8 1.3-.6 2.1c.3.8 1.3-.7 2.1-1.5 0 0 .2.2 1 .2l-2.3 4c-.8 1.2-.8 6.2-.8 8 0 2 .7 6.2.7 7.6 0 1 1.8 5 3.3 7.4l1.6 3.5c1.2 1.9 1.3 3.2 2 4.7.4.8 1 3 1.6 7l.7 7c.2 2.4 2.2.6 4.5-1 2.4-1.8 2.4-6 2.4-6s1.8-1.6 1.5-.7c-.2 1 1 2 1 2-1.4 3.3-.6 2.9.9 2.8 1.5-.2 6.5-4 6.5-4 .7-.2 3.8-.2 3.3 0-.6.3-1.4 1.7-1.4 1.7l3.3-.4c-1.1.9-5.5 3.4-6.5 4a90.6 90.6 0 0 1-8.6 4.1c-2.3 1-6.7 3.2-6.9 5.4 0 2.3.3 8.3 0 10.3l-1 10.6h-10.4s2-7.6 0-9.7c-2.1-2.1-7-8.4-10-10.5-3.2-2 2-.5 2-.5v-2.1l4.8 5.7s8.3-7.3 0-17.3c-2.6-3.1-5.3-7.9-7.3-8.4-2.2-.6-3.3-1-6.9 0-3.7 1.1-12.6 1.1-16.3-4.8l3.1-.5 2.7-1s-1.1 3.7 6.3 3.7 8.4 0 7.8-6.8l2.2-1.1 1.6 1.5s-1.1 3.8-.5 5.3c.5 1.6 3 2.7 5.1 4.2 1 .7 1.6.8 2.2.8.9-.1 1-.1 2.2-1.3 1.8-2 1.4-1.8 3.2-3.4l1-1.6 1.1 2.9z" />
      <path d="M319 155c.5-.4 1.2-1.9 2-3.1 1.1-2 2.5-3.2 4-5.6 1.5-2.2 2-5.6 1.5-7.9l1.4.8v3.7l2.7-2 .8.4s-5.9 6-11.3 15.9l-1-2.2zm-51.3-20.3c.8 1.4 1.6 4 3.9 6l1.6-.4s-3.6-4.2-3.6-6l-1.9.4m9.2-2.4s.5 5-.8 6.9l1.6-.8s1-3.4.7-5.3l-1.5-.7zm51.4-15.7s-.3 7 1.1 11.3l1.9-.5s-.3-1.3 1.2-1.9c1.6-.5 5.3-2 7.2-3.6l-.6-1.6s-2.8 2.3-4.2 2.9c-1.3.5-2 1-3.1.7-1.1-.3-2.4-2-1.6-6l-1.9-1.3m20.7 32.8s-.4 5-.2 7.2l1.7.4s-.4-6 .7-6.5l-2.2-1m7.5 3.7s-1.9 3.2-4 3.5l3.4-.7s1-.5 2.4-2l-1.8-.8" />
    </g>
    <g fill="#289400" stroke="#030" strokeWidth={0.5}>
      <path d="m326.6 138.4 1.3.8 1.3.2 3.2 2.6c1.2 1 1.2-.2 1.2-.2l.8 3.1h1l-.2 3.2 1.8-1.6 2.2 1.9s1.5-1.4 2.3-1.4c.8 0 1.1-.8 1.1-.8h.1c-5.2-2.4-7.4-5-5.9-7.6 2.6-4.4 6.8-1.6 8.1-1l19 10.2s1.3-.8.4-1.6c-1-.8-1.4-2.7-1-3.5.2-.8 2.4 2.4 3.4 2.7l3.5.7v-1s3 2.2 3 3.3c0 0 2.3-1.2 1.5-1.9-.7-.7 3.5 1.7 3.7 3l1-1c-.2 0 .2-3.2 1.3-4.6a4.8 4.8 0 0 1 2-1.9s1-1.7 2-1.7c0 0-1-.6-1.4-1.4-.5-.8-1.6-1.2-1.6-1.2s1.4-1 1.8-1.5c.4-.6.8-.7.8-.7s-2.2-1.9-3.8-2.2c0 0-.1-2.5-2-2.7h.8s-1.4-2.8-2.8-2.8c0 0 .9-1 1.6-1.1 0 0-1.6-2.2-3.9-1.4l1.5-.6s-1-1.1-4.4-.6c0 0 .3-1.3-1.2-2.4 0 0-1.2 0-1.2 1 0 0-1.2-1-2.7-1-1.4 0 .5 1.6.5 1.6s-2-1.3-3.1-1c0 0 .5-2.2-.8-3.3 0 0-1.4.7-1.8 1.7l-.4-1s-2 2.4-2.4 1.7c-.3-.4-.6-2-.6-2l-1.1 1.7.2-2.4s-1.4.8-2.5 3.3c0 0-1.3 1.3-1.3 2.4 0 0-1.1-1.2-2 0-1 1.4 0 1.1 0 1.1s-.5.5-1.5.7l.2.8s-1.2-.7-2.2-.4l.5 1.2s-2.6.2-2.7-2c0 0-2.1-1-2.4.2l-1.6 1s-.5-1-1.3-1.2c-1-.3-.2 1.3-.2 1.3s-.3-1.2-1.5-1.8c-1.2-.5-.2 1-.2 1s-1.5-1.2-.8-2.2c0 0-1.4 1.4-.7 2.7l-1 .7s-.5-.5-.4-1c0-.3-1.7 1.3-1.7 1.3s-1-2.6 0-2.6c.1 0-1.8 0-2.1 2.2 0 0-1.3 0-2.5.4s1 1.3 1 1.3-2-.4-3 .2l.7.9s-.7-.7-2.4-.1c-1.7.5.4.8.4.8s-1.7-.4-2.6 0c-.9.4.3 1 .3 1s-3.2-1-3.7-.6c-.5.3 1 1.8 1 1.8s-2 .5-2.3 2l1.8.7s-.8.4-1.2 1.1c-.4.8 1.2.4 1.2.4s-2.2 1.6-2.2 2.8c0 0 1.6.5 2.7-.7 1.2-1.2.4-.8.4-.8l.1.8s2.3-1 2.3-1.6c0-.5-.4.8-.4.8l2.2-1.2 1.5 1z" />
      <path d="m324.7 108-.5-2.2 5 .6.9-2s2.4 1 3.1 1.8c0 0 4.6-1.2 6-.7l-.6 2.1s4.2.3 5.6.8c1.2.5-.6 1.6-.6 1.6s4.8.6 6.8 1.8c2.2 1.3 2.2 2.4 1.1 2.7l2.6 4.2s-4.2.5-5 1.5c-.7 1.1-1.5-1-1.5-1l-.8 2.9s-2.6-1.4-3.7-2.4c0 0-1.3 1.6-.5 2.4l-4.8-3.1s-2-.3-2 1.5l-3-3.4-2.6.8s-.8-1-1.7-1.4c-1.1-.2-.3 1.4-.3 1.4l-1.6-1.9-1.6-1.8s-1.3 1.8-2.4 1.8c-1 0-1-1.2-.8-2.1.3-.8-3.1-1-3.4 0 0 0-1-4 2.6-5l3.7-1zm-19 13.3-1.6 1.6-1-.5-1.9 2.1-.4-1.1-1 1.7-1.7-.6-.8 1.3-1.5-.3s-1.2 1.2-2 1.5c-.8.2 0-1.8 0-1.8s-1.2 2-2 2c-.9 0-.6-1-.6-1s-.5 1.4-1.4 1.6c-.9 0-.5-1-.5-1l-1.6 1.2v-1l-.7-.3s.4-1.8 1.1-2.2c.7-.4-.7-1.5-.7-1.5l.7-.8s-2-.5-2-.1c0 0 1-2.6 2.4-3.1l.1-3s1.4-1.1 2.6-1.2c1.4-.2-.4-2.3-.4-2.3l3.2-1.8.4-2.3 4.7.4 1-2 3.8 1 3.3-1.7 2.3 2.7 3.5.3v3.1s4.1 1.3 4.6 1.7c0 0-.8 2.5-.8 3 0 0 3-.8 3.8-.6l.4 3.4s5 1.6 5.3 2.5c0 0-1 .7-1.7 1.6 0 0 .6 3 .6 4l-.4.5s-1.4-1.3-2.6-1.5l-1 2.1-1.7-1.1h-1.1s-.9-1-1.6-1v-1l-1.4.9s-2.2-1.1-2.2-1.8l.1-1.5-2.2 1.5s-.5-1.1-.4-1.6c0-.5-.9 1.1-.9 1.1s-1.2-2-1-2.4l-.4 1.7s-2.3-.8-2.6-2.4z" />
      <path d="M274.5 130.9s4.1 2 4.1 3c0 0 1.1-2.1.5-3l1.6 1.1s.5-1.9-.1-2.5c-.5-.5 3.5-2.1 4.4.5 0 0 2.4-2.5-2.3-4.7 0 0-.4-1.6 2.5-1.2 0 0-.2-1-.9-1.3h2.7s-1.6-1.4-4-1.8c-2.4-.4-1-.7-1-1.2-.2-.5 0-2.2 0-2.2s-1.4-.5-2.5 0l.4-.4s-2.5-.7-3.5-.1c0 0-1.5-.6-1.3-2.1 0 0-1.5-.1-2.1 1.4 0 0-1.4 1.6-3.3 1.6-.3 0-1.7-.8-1.7-.8l-1.2 2.7H265l.5 1s-2.8-.8-3.7 0c0 0 1.1 1.7.8 2.8 0 0-2.2.4-2.7.8-.6.4.8.7.8.7s-2.6.8-3.2 1.6l1 .7-1.2 1.6 1 .2-2.5.8c-.9.3 1.5.5 1.5.5l-1.1 1 1.8.3s-1.4 4-1.5 5.8c0 0 2.2-2.7 2.8-3l-1.8 3s3.4-1 3.7-1.6l.5-1 .1 1.6s1.3-1.7 1.5-2.4c.1-.7 2 .7 2 .7v-1l2.4.7c.7 0 .8-.3.8-.3l1.6-.2-.3 1.4s1.2-.8 1.5-1.6c.2-.8.8 0 .8 0l.8-3.1h1.6zm-13.4 13.8 1.6 3.3c-1.3 0-3.1 1.5-3.1 1.5.3 5.4-1 5.1-1 5.1.3 1-.3 2.8-.3 2.8l7.7-4.6.1-.5 9.2-4.3.3.5 2.6-1.5 1.9 4.9-1.9 1c.1 1.7 2.1 4.6 2.1 4.6l2.4-.6 2.7-1v1c0-.3 2.9-1.3 2.9-1.3l1.3 1.3c1-.1 2.7-2.5 2.7-2.5l2 .8s.7-1.2.7-2 2.6-.8 2.6-.8l1.7 1.2 2.3-1.8s.7 1.3 1.6 1.5c1 .1 3.4 2 3.4 1.6 0-.4 1-2.5 1-2.5l4.1 1.6c-.5-1.8-2-4-2-4s2-1.6 1.7-2c-.4-.4-1.6 0-1.6 0l1.2-2.4h-1.6l.5-.6-2.5-1 1.3-2.8c-.6-.7-7.3-2-7.3-2l1.6-1.5s-.8-1.2-1.6-1.2-4.9.1-5-.3l-1.8-1.8-2.6 1.9-1.3-.4-2.2.8s0 1.3-.3.4c-.3-.8-2.3-2.8-2.3-2.8-.4.7-3 3.8-3 3.8s-.5 1.7-1.3.5c-1-1.2-3-2.4-3.4-1.5-.2 1.1-2.1 2-2.5 1.8-.4-.3-2.5-.1-2.7.5-.1.7-2.5 2.4-2.5 2.4-1.4-.7-3.8-.3-3.8-.3s-.7 1.1-.8 2l-4.7 1.2zm44.2 39.6v-2l2.3 1.5 1.4-1.5 1.8 1.7 1-1.7v2.8l2.7-2.3 1.5.6v-2.2s1.9-3.1 1.1-3.7l1.6-.5s-2.7-2.6-3.4-3.1c-.8-.6-1.9-.6-1.9-.6s-2-2-3.4-2.7c-1.3-.5-2 .6-2 .6s-.8-1.5-2.2-1.8c-1.3-.3-1.3 1-1.3 1s-1-1-2.2-1.4c-1.3-.6-.4 1.2-.4 1.2l-4.5-1.4.6 1.4-4.2-1.1.5 1.5-3-.5-.2 1.3-4.2.8.8 1.4-2.6-1.1v1.9l-3 1 1.1 1-4.7 2.4c-.7.5 1.6 1.6 1.6 1.6l-4.2-.6 1.6 1.4-3.7 3.4 2.6 1.9-1.6 2.3 4 .8 1.5 2.6 3.2-.6v3l4.7-3.7s3.4 3 3.7 2.1c.2-.8.2-3.4.2-3.4h1.7V187l1.2 1 2.2-3.1 2.8 3.9 2.2-5 3.1.5zm19.1-11.8-.4-4.5-1.4 1.4.6-4.2-2.2-.4.8-4.1-1.6-.8.4-2 1.6-1.1 2.8-2.8 6.6.1.7-2.1 4.7.8c.8.8 3.3-1.8 3.3-1.8h1l1 2s3.4-.4 5 .6l-1.9 2.6 3.5.3 2.3.5 2.4-.8 3.2-.2.7 1.3h3l-1 1.1 3.8 1.8-.8.8s2.2.8 3.7.8h.8s.8 1.8-.3 2.6c0 0 1.1 2.6 3.4 3.1 2.4.5 2.4.5 2.7 1 .3.6 0 3.2-2.7 3.2v2.7s-2 1.8-2.3 2.6l-1.6-1s-1.3 1.5-1.3 2.5c0 0-3.5-4.5-4.7-4.7-1.4-.2-1 2.6-1 2.6l-3.8-3.1-.5 2.1-3.1-2.6-1.9 1.3-3.3-3.5-3.2.4 1.2-1.6h-3.9l-.7-3.4-.6 2.8-2.4-1.6-3 3.3s-.4-.4-.9-2c-.5-1.5-1.8 2-1.8 2l-1.1-2.5-1.3 2.4s-1-1.8-2.1-2.4c-1-.5-2 3-2.4 4.5zm.6 10.3.2-1.6 5.6-2.2 4.7-1.7 2.3-1.1 1.1 1.9 1.4-2.7 2.1 2.8 1.2-1.5 1.8 1.4h1.6l.3 2s3.9.3 4.2-.5c.3-.8.8 2.7.8 2.7l3.7.5.8 4.2s1.8 3.9 1.2 5.4c-.5 1.7-2-2-2-2s-.3 2.9-.6 3.7c-.2.8-5-.8-5-.8l-2 3.9s-2.2-3.1-3.2-3.1-1 3.1-1 3.1l-4.5-5.3c-1.3-1.5-1.6 1.6-1.6 1.6s-2-3.4-2-4.4c0-1-1.9-2.2-1.9-2.2s-3.2 3.7-5.6 4.7c0 0 .3-2.3-.5-3-.7-.9-3 1.5-3 1.5s-1.7-3.6 0-7.4z" />
    </g>
    <g fill="none" stroke="#004b00" strokeWidth={0.5}>
      <path d="m350.8 124.5.5 2s1.8-.4 3-.3l-.7 2.2s2.3-.4 3.4.3l-.5 1.2 2.7 1.2-2.5 2s4 1.5 4.9 2.7c0 0-2.7 1.8-3 1.7-.5-.2-.2.8.5 1.7l-2.2-.1s.9 2 .8 2.8c-.2.8-3.8.6-3.8.6m14.1-5.3s.7-3.9-.4-4.9c0 0 2.5 2.2 4.2 2.3 1.8 0 0-3.2 0-3.2s2.3 1.2 3.5 1.5c1.2.2-.9-2.4-.9-2.4s.7-1.3 2.7-.1m-45.4-15.5s0-1-.3-1.4c-2.4-3.2 2.4 2.4 3.4 2.6m4.5 0s1.6 1.2 2.3 1.2c.8 0-.5-3.1-.9-3.5-.3-.4 2.9 1.3 4 1.4 1.2.3 1.4-2 1.4-2s3.6.7 4.4 1.2m-25-.7-.5-3m-24.2 12.7c-.2-.3 1-2 .5-2.9 0 0 .7.6 1.4.7.6.1.4-2.2.4-2.2l.7.3s2-1 1.7-1.8c-.4-.8 1.4 1.2 1.4 1.2s1.1-1.2 1.1-1.7 1.4 1.2 1.4 1.2 1.5-.3 1.5-1.2c0-.9 1.8.3 1.8.3s.8-1 .7-1.8m-19.7 9.8s.9-2-.1-3.4m-23.6 9.8c0-1 .5-3.6 0-4-.4-.4 1 .4 2.2.7m9.3-.4c-1.2-1.1-1.9-1.7-3.7-1.7m-16.2 8.3c.3-.7.8-2.4.5-3.3m25 51.7 1.3-2.6 1.6 3.7 1-2.3.4.7 2.4-2.5 2.5 3.8m40.7-16.5 1.7-3.3 2.3 1.2 1-3.3 2.4 1.5 1.3-3 2.7.7.2-2.2s1.8 1 2.3 1.9c.6.7 0-2.7 0-2.7l2.2 1s1.5-1.6-.6-2.4" />
      <path d="m343.6 163.1 2.3 3.4 2-2.2 1.7 3.8 2.3-1.4 3.2 1.9 1.5-1.2 3.5 2.5 1.4-3 3.2 1 2-3.5m-84.4-9.2s1.4-2.3 1-3.4c-.7-1 2.8 1.8 2.8 1.8s.7-2.3.3-3.4c-.6-1 3.9 3.2 3.9 3.2s.7-3.7 0-4.4c-.8-.8 4.3 1 4.3 1s2-.6 1.2-1.6c-.8-1.1 3.4 1.5 3.4 1.5s1-2.6 0-3.6 3.2 1.3 3.2 1.3l-1.6-2.8 3.4.2-.3-3.2m30.3 45.1 2.2-1 2 2 2.2-3.5 2.6 2.5.4-2.5 2.8 1.2.6-1.6 3.1 1.7.3-2.4 1.6.5.3-1.5" />
    </g>
    <path
      fill="#9dd7ff"
      d="M283.1 298.1a69.8 69.8 0 0 1-6-13l42.4-37.2 42.3 37.1a64.7 64.7 0 0 1-6.2 13.3l-.3.5-3.2-1.2s-1.4 1.3-2.5 1.4c-1.4.2-2.7-1.3-2.7-1.3s-1.8 1.6-3.7 1.3c-1.9-.2-2.6-1.4-2.6-1.4s-2 1.6-3.4 1.3c-1.2-.3-2.1-1.2-2.1-1.2s-1.2 1.5-2.8 1.2c-1.6-.3-3-1.2-3-1.2s-2.5 1-4 1.3c-1.6.3-3-1.4-3-1.4s-2 1.4-2.8 1.4c-.8 0-3.7-1.4-3.7-1.4s-3 1-4.1 1c-1 0-4-1.3-4-1.3s-2.9.8-4.1.8c-1.4 0-3.4-.8-3.4-.8s-2.3 1.1-3.6.8c-1.4-.3-2.4-.8-2.4-.8s-2.6 1.1-4.2.8c-1.6-.3-3.4-1.4-3.4-1.4s-.3.8-3.4 1.4"
    />
    <path
      fill="#fff"
      stroke="#000"
      strokeWidth={0.7}
      d="M319.5 205.1V248l-42.3 37.4a84.2 84.2 0 0 1-4.4-27.1V205h46.7"
    />
    <path
      fill="#ffd83c"
      stroke="#000"
      strokeWidth={0.7}
      d="M319.5 205.1V248l42.2 37.4a84.2 84.2 0 0 0 4.3-27.1V205h-46.5"
    />
    <g stroke="#000" strokeWidth={0.5}>
      <path
        fill="#730000"
        d="M292.2 289.2c3.2 1.7 2 1.2 8.7 3.5a61.8 61.8 0 0 0 20.7 2.8c8 0 12.4-.7 15-1.4 2.5-.7 3.1-1.8 3.1-1.8l-6.5 6.7s-26.3 1.4-31-1.7c-2-1-6-4.2-10-8z"
      />
      <path
        fill="none"
        d="M330.8 276.8s8.4 4.8 0 14m-37.8-1 12-11.6-1.3 15.4m6.3 1.4v-25.8m20.8 25.8v-27.4m-10.5 27.9V266"
      />
      <path
        fill="#ff0018"
        d="m310 270.6-5.4 1.7 5.4.6v-2.3m10.3-4-5.8 2.1 5.8.2v-2.4m10.5 1.6-5.8 2.2 5.8.3V268zm3.4 12.4c-.3-1.1 3.4-1 3.4-1s1 3.9 0 6.3l-3.1-.6s.3-2.6-.3-4.7z"
      />
      <g fill="#fff">
        <path d="m294.8 288.1 10.3-10-.5 6s-5.3 3.5-5.3 5.9l-4.5-1.9m5.5 2.1s1-3.1 4-4.7l-.3 6.3-3.7-1.6zm14.7-17.3s4.2-.6 7.4 0c0 0-.5 4.2 0 5 0 0-5.8-1.4-8.1.8 0 0-.8-4 .7-5.8zm-8.9 1s4.2-.5 7.4 0c0 0-.8 4.8-.3 5.5 0 0-4.7-2.6-7-.4 0 0-1.6-3.3 0-5z" />
        <path d="M305.9 279.4s4.2-.4 7.3 0c0 0-.5 4.3 0 5 0 0-5.5-1.2-7.8.8 0 0-1.1-3.9.5-5.8zm8.4-.7s6-.8 9.1-.3c0 0-1.2 3.4.3 5.7 0 0-6.5-1.7-9 .3 0 0-2-3.9-.4-5.7zm-9 6.5 8.2.6s-.8 6-.3 6.7c0 0-6.6-1.5-7.8.6 0 0-2.2-5.4 0-7.9zm9.2 0s7-.5 10.3 0c0 0-1.9 4.5.2 8.4 0 0-9.2-2.6-10.5-.5 0 0-2.1-5.4 0-7.9zm10.8-12.3s4.2-.6 7.3 0c0 0-.5 4.2 0 5 0 0-5.8-1.4-8 .8 0 0-.9-4 .7-5.8zm0 5.8s4.2-.5 7.3 0c0 0-.5 4.2 0 5 0 0-5.8-1.3-8 .7 0 0-.9-3.9.7-5.7zm.5 6s4.2-.6 7.4 0c0 0-1 6.6-.6 7.4 0 0-4.8-2.3-7-.3 0 0-1.4-5.2.2-7z" />
        <path d="M334.5 285.2s1.3 5 3 5.6l-2.2 2.8s-2.9-2-3.2-4.4c0 0 1.9-2.1 2.4-4z" />
      </g>
    </g>
    <g stroke="#000" strokeWidth={0.6}>
      <path
        fill="#006ac8"
        stroke="none"
        d="M355.4 298.7a66.2 66.2 0 0 1-36 28.3 67.3 67.3 0 0 1-36.3-28.8h.1c3-.7 3.4-1.5 3.4-1.5s1.8 1.1 3.4 1.4c1.6.3 4.2-.8 4.2-.8s1 .5 2.4.8c1.3.3 3.6-.8 3.6-.8s2 .8 3.3.8c1.3 0 4.1-.8 4.1-.8s3 1.3 4 1.3c1.1 0 4.2-1 4.2-1s2.9 1.4 3.7 1.4c.7 0 2.8-1.4 2.8-1.4s1.4 1.7 3 1.4c1.5-.2 4-1.3 4-1.3s1.4.9 3 1.2c1.6.3 2.8-1.2 2.8-1.2s.9.9 2.1 1.2c1.4.3 3.3-1.3 3.3-1.3s.8 1.2 2.7 1.4c1.8.3 3.7-1.3 3.7-1.3s1.3 1.5 2.7 1.3c1.1-.1 2.5-1.4 2.5-1.4l3.3 1"
      />
      <path
        fill="none"
        strokeWidth={0.5}
        d="M353.7 301.2c-1.4.1-1.6-.8-1.6-.8s-2 1.6-3.8 1.3c-2-.3-2.9-1.5-2.9-1.5s-2 1.6-3.4 1.3a5 5 0 0 1-2.3-1.1s-1.3 1.4-3 1.1c-1.6-.2-3-1.1-3-1.1s-2.7 1-4.4 1.3c-1.6.3-3-1.5-3-1.5s-3.8 1.2-4.6 1.2c-.9 0-3.6-1.2-3.6-1.2s-1.9 1.1-3 1.1-4.2-1.3-4.2-1.3-3 .8-4.3.8c-1.4 0-3.5-.8-3.5-.8s-2.5 1-3.9.8l-2.4-.8s-2.7 1-4.4.8c-1.6-.4-3.6-1.4-3.6-1.4s-.3.7-3.5 1.4h-.1"
      />
      <path
        fill="#5ac800"
        d="M293.1 305.2s-.3.7-2.8 1.2l-.7.2.6-.2-.7.3a44 44 0 0 0 11.7 11c4.5 3 9.6 6.6 18.4 9.2a71 71 0 0 0 17.8-9c6-4.5 9.2-7.2 12.6-11.7-2.7 1.5-2.3 1.5-3.7 1.3-1.3-.3-2.3-1.3-2.3-1.3s-1.3 1.5-3 1.3c-1.6-.3-3-1.3-3-1.3s-2.2 1.5-4.4 1.4c-1.6-.1-3-1.6-3-1.6s-3.8 1.3-4.6 1.3c-.9 0-3.6-1.3-3.6-1.3s-1.9 1.2-3 1.2-4.2-1.4-4.2-1.4-3 .8-4.3.8-3.4-.8-3.4-.8-2.5 1-4 .8c-1.3-.3-2.4-.8-2.4-.8s-2.7 1-4.4.8c-1.6-.3-3.6-1.4-3.6-1.4z"
      />
      <path
        fill="#ffd800"
        d="M319.6 326.9a89 89 0 0 0 17.1-8.6c-1 0-4-1-2.9-1.2 0 0-1.2 1-2.3 1-1.1 0-4.2-1.3-4.2-1.3s-3 .7-4.3.7c-1.4 0-3.4-.7-3.4-.7s-2.6 1-4 .7l-2.4-.7s-2.8 1-4.4.7c-1.6-.3-3.6-1.3-3.6-1.3s-2.4 1.3-4 1.4a55 55 0 0 0 18.4 9.3z"
      />
    </g>
    <g stroke="#000" strokeWidth={0.5}>
      <path
        fill="#b34b00"
        d="M313.2 249c1.9-1.6 3-3 2.3-4.2-.7-1-1.8.6-3 .2 0 0-2-1.1-2.5-2-1-1.2-2.5-2.3-3.3-3.4-.9-1-4.2-5.3-9.1-10.3-1.5-.9-1.1-4.4-2.2-5.5 0-.8-10-10.6-13.4-14-1.5-1.1-2.2-1.8-4.7.5-2 1.7-2.7 3.6-.1 5.8l12.8 11.7c1.9 1.8 4.5 2.1 5.6 3l13 13.4c1.7 1.4 2.5 2.4 1.5 3.6-1 2 .1 2.3.3 2.3.2.1 1.1.1 1.7-.4l1-.7z"
      />
      <path fill="none" d="m280.7 214 13.4 13.2" />
      <path
        fill="#fff"
        strokeWidth={0.6}
        d="m298.8 220 1.1-2.5c.2-.4 3.8-6.2 5.6-6.3l11.3 8.2c0 .5-5 7.8-5.3 7.2 0 0-13.2-5.5-12.7-6.6z"
      />
      <path
        fill="#ccb8c8"
        stroke="none"
        d="M306 222c-1.6-1.2-4.1-2.4-6.2-3.8l-.9 2c.7.8 10 5.1 11.6 6 0 0-1.8-2-4.6-4.2z"
      />
      <path
        fill="none"
        strokeWidth={0.4}
        d="M299.8 218a73 73 0 0 0 5 3.1c2.7 2 4.4 4 6.4 5.2"
      />
      <path
        fill="#782121"
        d="m277.1 253 25.5-31.7c.5-.4 2.9-.4 3.2 2l-24.2 33s-2.7-.3-4.5-3.4z"
      />
      <path
        fill="#730000"
        d="M362.7 253.3c-1 .7-2.4.8-2.4.8-1.7-1.9-3-4-5.4-6.5l-25.5-31.3 2.7-2.6 23 26.9c.6.7 4.6 4.9 8.4 9.8 0 0 .3 2-.8 2.9z"
      />
      <path
        fill="#fff"
        d="m338.1 220.3-4-5s-3.2.5-3.8 2.1c0 0-2.2 3.7-8.2 4.1 0 0 1.7 7 8.6 10.7 0 0 2.5-7.2 5-8.4 0 0 2.5-1.9 2.4-3.6z"
      />
      <path
        fill="#730000"
        d="M327.9 242c-.6-.3-1.2 0-2 .4-.9.5-1.8.3-1.7-.7 0-.8 0-.7 1-1.4a6.3 6.3 0 0 1 5-.5l-2.3 2.1m27.8-27.7c-.2-.7-.4-1.4.3-2.2.7-.8.7-2.2-1-1.5-1.7.7-2.2 2.5-.9 5.4l1.6-1.7z"
      />
      <path
        fill="#fff"
        d="m327.3 242.5 28.9-28.7 7.1 7.6s-1.5-.6-2-.2c-.5.4.5 1.9.5 1.9s-1.3-.5-1.9-.1c-.7.4 0 2 0 2s-1.2-.8-1.8-.5c-.5.4 0 2.3 0 2.3s-1.5-.5-2-.1c-.3.4 0 2 0 2s-1.5-.7-2.3 0 .4 1.9.4 1.9-2-.8-2.7.4c-.8 1.2.1 2.2.1 2.2s-1.6-.7-2-.4c-.4.4 0 2.3 0 2.3s-1.3-.8-2.2.2c-.9 1 .1 2 .1 2s-1.3-.8-2-.4c-.6.4.2 2.2.2 2.2s-1.2-.9-2.1 0c-.9 1 0 2 0 2s-1-1-2.2 0c-1 1 0 2.1 0 2.1s-1.5-.8-2.1 0c-.7.8.2 1.9.2 1.9s-1.2-.7-2-.3c-.7.4 0 2.1 0 2.1s-1.1-1.3-1.6-.6c-.6.7 0 2.4 0 2.4s-1-1.3-1.6-.6c-.7.6.4 2 .4 2s-2-.8-1.5-.8z"
      />
      <path
        fill="#7e4b7e"
        stroke="none"
        d="m354.5 216.2-2.2 2.2.5 7.7s.5-2.2 1.1-.7c0 0 .2-1.8.7-1.5-.4-.2 0-7.8 0-7.8m-4.3 4.3-1.6 1.5.6 7.7s.4-2.9 1.1-.6v-8.6m-17.6 17.2-1.5 1.7.4 4.7s.5-3 1.1-.7l-.2-2.6.2-3"
      />
      <g fill="none" stroke="#7e4b7e" strokeWidth={0.9}>
        <path d="M330.9 218.3c1 1 4 5 4 5m-2.6-2.9c-.2.6-.6 2.3-1.5 3.2m2-2.8c-.2.4-.2 1.7-1.5 3m2-2.4c-.3.7-.4 1.2-.8 1.7m1-1c0 .4-.3.5-.4.8m-3.2-2.7a29 29 0 0 1-4.8 2.8m4-1.8a14 14 0 0 1-3.1 2.2m2.8-1c-.5.4-1.5 1.4-2.3 1.7m1.8-.5c-.4.5-1 .8-1.5 1.1" />
        <path
          strokeLinecap="square"
          d="M311.3 224.7c.3-.6.9-1.8 1.6-2.8 1-1.4 1.3-1.6 1.8-2"
        />
      </g>
    </g>
    <path
      fill="#289400"
      stroke="#060"
      strokeWidth={0.5}
      d="M217 303.4c1.5.7 0-4.8.5-6.8.6-2.2 4.8 5.2 6.8 6.2 2.2 1 15.3-5.2 15.3-5.2l3.1-5.8 1.7 4.8s3.6-4.2 4.6-5.8c1.1-1.6 0 3.1-1 4.7-1.1 1.5 3.1 2.1 2.6 5.3-.5 3 4.2-2.2 4.2-2.2l12.1 1s2-7.3 5.3-11.5l1 4.8 5-5.1a65.9 65.9 0 0 0 41.3 39.2 66.6 66.6 0 0 0 40.2-36.6l6.7 7s5.3-1.6 6.3-2.2a70.3 70.3 0 0 1 15.5 5.6c1 .7.3-3.5.3-3.5s5.8 1.1 5.3 4.2c0 0 1.2-2.9 2.3-3.4 1.1-.5 3.6 2.7 4.2 3.7.5 1 13 2.6 14.7 3.6 0 0 1.3 1.6 1.3 2.7 0 0 2.7-.3 4.7-.3 0 0-1.5.8-1.5 2.4 0 1.6-.8 2.9-2.4 3.6-1.5.8 0 1.4 2 1.6 2.2.3 0 3-4.1 4.5 0 0-1 2.3.8 3.1 0 0-3.7.3-4.2-.8 0 0-1.3 2.5-1.3 3.8 0 0-4-1.3-5-1.9 0 0-1.6 1.6-.5 2.3 0 0-7.1-.7-8.5-3.4 0 0-2.5.8-2 1.7 0 0-5-3.4-6.6-3.4l-1 1.7s-3.5-2-4.5-2-.2 1.5-.2 1.5l-4.8-2.9-1.9 3-5-2.7c-1-.8-1.2 1.6-2 1.9 0 0-1.6-2.2-3.7-1.9 0 0-.8 2.6-.5 3.4l-7.1-1.5c-1.1-.3-.5 1.2 0 2.3 0 0-4.5-1.3-5.5-2l-.3 2s-3.7-.3-4.5-1l-2.3 3.1h-3.5l-.7 2.9s-6.6-1.9-7.2-.8c-.5 1 .3 2.6.3 2.6l-5.7-.7-.5 2.3s-6.7-2-8.2-1c0 0-2 2-3.4 2.6-1.3.5 0-.8 0-.8l-2-2.9s-2.4 1.3-3.8.8c-1.3-.6-5.5 2-6.8 1.3 0 0 0-1.9-1.1-2.4-1-.4-2.8-.4-3.6.8l-2.2-3c-1.2-2.2-3.1.1-3.1.1l-.3-2.5-3.6-.3c-2.2-.3-2.6-2.2-2.6-2.2s-5.6.6-6.4.3l1.4-1.3s-7.6 1.6-9.2 1c-1.7-.5 1.8-2.6 1.8-2.6l-8.4-2c-1.3-.4-9 1.2-10 1.2s-1.6-1.8-1.6-1.8-1.8 1.6-3.4 2.1c0 0-1.3-3.1-.5-3.4 0 0-5 1.3-5.3 2.6 0 0-1.2-2-1-3 0 0-2.4 3.8-3.5 4.6-1 .8-.2-1.9-.2-1.9s-2.9 3.7-4 4v-2.6s-8.4 4.5-10.7 3.9c0 0 0-1.9.8-2.4l-5.3-.2c-1.3-.2-2.8-.8-4.2-1.1-1.3-.2 1.9-1.6 4-1 0 0-5.8-2.1-7.6-1 0 0-.8-2.2 2.3-3 0 0-4-3.9-6.3-3.6 0 0 2.6-1.6 4.8-.8 0 0-2.5-6.6-4-7.4 0 0 5.5-1 7.1-.2z"
    />
    <path
      fill="#730000"
      stroke="#000"
      strokeWidth={0.5}
      d="M208.9 188.8 280 152c.3-2-.7-3.4-1.9-5-20.3 10-38.8 22.2-61.4 29.5-1.3.5-12.5 5.2-18.3 12.1a7.7 7.7 0 0 0-2 4.5s.2 3.1.9 4c0 0 .1.8 1.2 1.5 0 0 .7.3 1.1.2.5 0 1.4 0 2.6-2a52.4 52.4 0 0 1 6.7-8z"
    />
    <path
      fill="#fff"
      stroke="#000"
      strokeWidth={0.5}
      d="m266.1 152.4 9.2-4.4s3.1 2.3 2.8 5c0 0 .7 6 8.2 10.2 0 0-6.3 8-17.4 8.6 0 0 1.2-10.4-1.1-13.5 0 0-.4.4-.2-.1.3-1-.2-4.5-1.7-5.3l.2-.5z"
    />
    <path
      fill="none"
      stroke="#7e4b7e"
      strokeWidth={0.8}
      d="M276.9 153.6c-2 .8-8.3 4.1-8.3 4.1m5.2-2.1c0 1-.6 3.3 0 5m-.8-4.7c0 .5-.8 2.2 0 4.6m-1-4.1c-.2 1-.4 1.5 0 2.6m-.8-2c-.2.5 0 .8 0 1.2m5.8-1.5c.3.7 2.9 4.8 4.5 6.5m-4.1-4.7c.3.8 1.7 3.6 2.8 4.7m-3-3c.4 1 1.1 2.7 2 3.7m-2-1.8a8 8 0 0 0 1.1 2.5"
    />
    <g stroke="#000" strokeWidth={0.5}>
      <path
        fill="#b34b00"
        d="m342.3 148.3 26.1 12.8c5.2 2.5 7.1.2 10 1.5l51.6 26.2c4.5 2 7 2.5 6.3 4.8-.1 3.7 1.7 3.7 2.2 3.8.4 0 2.1-.2 2.8-1.2l.6-.6c.6-.6.5-.7.7-1 2.1-3 3.3-5.8 1-7.5-2.5-1.3-2.8 1.5-5.6 1.2 0 0-4.8-1.8-6.6-3.1-3.2-1.8-7.8-3.9-8.8-5-3.3-.6-28-14.6-42.1-21.6-1.5-1.2-2.3-5.9-5.3-7.4-.8-1.3-19.8-10-29.8-15-3.6-1.3-5.7-2.2-8.3 2.3-2.3 4.4-1.8 6.8 5.2 9.8z"
      />
      <path fill="none" d="m344.5 142.8 29.2 14.6" />
    </g>
    <g
      fill="#ffa54b"
      stroke="#000"
      strokeWidth={0.5}
      transform="translate(-40) scale(.96)"
    >
      <path
        fill="url(#bz-c)"
        d="M309.7 165.1c-.2.6-.7.2-.7.4-.4 2.2-.3 3.3-.8 4.5a7.1 7.1 0 0 1-3.1 2.6c-2 .7-4.5 3.1-8.5.9l-.6-.5s1.1 4.1-3 6.2l-15.7 8.2s-1.5 2.8-.5 6.5c0 .6.3 1.1-.3 1.5-1 .7-2.7 2.8-3.7 6 0 0-3-1.3-3-3.2 0-2 1.2-3 1.5-4.4.3-1.3 1-4.7.7-5.7-.4-1.1-2.3-1.5-3-2-.6-.3-1.4.5-1.3 1.4.1 1 .8.8 1.6 1 0 0-.9 2-.8 3.4l-9.2 4.8 1.6 2.3c.4.7 1.3 10.2 4 14.7s3.7 3.2 4.3 3.8l2 2c.8.5 4 .8 4.5-1a9 9 0 0 1 3.2-4.1c2-1.6 6-5.4 6-7.2 0 0 2.3 6.8 2 12.4 0 0 8.5 1.7 16.1 1.9 7.6 0 11.5-1.5 11.5-1.5s1-6.4.6-7.7c0 0 1.2 4.2 2.2 5.6 1 1.8 2.1 5.3 4.3 5.5 2.2.1 4-2.1 4.2-3v-6.8h8.7s3.8 1.5 5 1.3c1.3-.1 2-1.3.8-1.7l-.4-.3c1.2 0 2.6.7 2.6.7h4.3l-.1-.5c-.3-1.2-2.6-2.2-4.2-3-1.6-.5-3.5-1.2-4.7-1.3a20 20 0 0 0-6.2.4c-.8 0-3.9.4-5.8 1.3-.5.3-1 .4-.8-1 .3-1.3.2-7.8-1.3-10.5-1.2-2-1-3.6-.9-5.2a87 87 0 0 0 0-8.8c-.3-1.7-2.5-4-6.6-4.4-3.8-.5-7-3.7-7.3-6.2-.3-2.6.4-7.2.8-9.3"
      />
      <g fill="none">
        <path
          fill="url(#bz-d)"
          d="M292.4 153.6c-.7 3.3-.7 6.1-.6 9.3.1 2.1 1.1 4.6 2 6.7a10 10 0 0 0 2.8 3.9c3.6 2.3 7-.2 8.9-1a6.4 6.4 0 0 0 2.7-2.5c.5-1.2.3-2.1.8-4.5l.7-.4c1-1.5.7-2 1.2-3 .6-1-.5-2.2-1.8-2 .6-1.9 1-4 .4-5.9-.2-.6.5-2.2-.6-1.8-4.6 1.8-10 1.4-14.8 1.4-.4 0-.8-.8-1.4-.7l-.3.5"
        />
        <path
          fill="#000"
          d="M292 155.3c-.5-.4-.6-1.3 0-3.2.7-2 0-2 1.1-3.2s.9-1.6 1.6-1.9c.7-.2 2.8-.2 3.5-.5a11 11 0 0 1 9-.3c1.5.8 2.5 2.8 3.4 3.6 1 .7 1.7 3.6 1.5 7.9-.3 4.3-1.2 3.5-1.2 3.5s-1.2-2-2.2-.3c0 0 0-1.7.2-3 .1-1.1-.6-3.4.1-4.9 0 0-5.8 1.8-8.7 1.7-3-.2-7.4-.9-7.6-1.6l-.7 2.2"
        />
        <path
          fill="#fff"
          stroke="#fff"
          d="M295 151.8c-.3-.6-1.8-2.9-.6-3.6 1-.6.4 2.8 2 3.5 0 0-.6 1.5-1.4.1z"
        />
        <path d="m298.3 160.1-.9 3.2m10.6 1.6c.2.6.4.3 1 .4m.3-4c.5-.5 1.2-.2.8 1.3m-17.7-4.9 2.8 1c1.5.6.6 2.9.2 4.3-.2.7-1 2-.6 2.5.5.8 1.1.3 2 .4 0-.3.6-.5.8-.5.7 0 1.1.5 1.7.3.6-.3.5-1.2.3-1.7m-.1-4.5c0-.4 1-.8 1.5-.9 2.1-.4 3.6-.7 5.4.5m-5.7 11.1c-1.8.4-3.6.7-5.2-.2m0-.8c.8-.4 1.1-.8 2.1-.3a5 5 0 0 1 1.1-.4c.8 0 1.4.3 2.2.8m-5.5.3c1-.3 3.3-.3 5.4.1" />
        <path
          fill="#fff"
          strokeWidth={0.3}
          d="M292.3 160.1c.7 0 1.6-.9 3.2.3 1.1.8-1.8 1.5-1.3 1.4-1.4.2-1.8-.5-1.9-1.2 0-.1-.2-.5 0-.5zm8.4.8c.7-1.4 1.8-1 2.8-.8 1 .3.7.1 1.7.7-1.2.1-.9.2-1.7.6-.9.5-1.7.7-2.3.3-.2-.2-.7-.5-.7-1 0 .2 0 .3.2.3z"
        />
        <path
          fill="#000"
          strokeWidth={0.3}
          d="M293.8 161.4c.4 0 .7-.4.7-.8 0-.6-.3-1-.7-1-.5 0-.9.4-.9 1 0 .4.4.8.9.8zm8.6.2c.4 0 .7-.4.7-1a.8.8 0 0 0-.8-.8c-.4 0-.7.3-.7.8 0 .6.4 1 .8 1z"
        />
      </g>
      <g id="bz-g">
        <g fill="none">
          <path d="M345.9 213.7a3.9 3.9 0 0 0-1.9-1.4l-2-1c-.7-.4-1.7-.5-2.4-.9m.5 2.6-.9-.5c-.3 0-.7 0-1-.2 0 0 0-.2-.2-.2a3.5 3.5 0 0 1-2.4-1.3m-62.8-9.3c1 .7 3.2 2.2 3.4 5.1a10.5 10.5 0 0 0 1 3M264 202c.5 1.7.6 7.4 6 13.4m-5-21.4c-.4 1.1-1 2.2.2 3m14.4 10.7c1.1-2.6 4.6-2.4 4.6-4.8" />
          <path d="M284.8 207.3c-.3-2.9-1-4.5-.4-8.7.2-1.2.4-5.9 0-8.1 0 0 1.6 7.8-3.7 9.3m34.4 12.5c0-4 1-6.2 1-6.2 1.2-5.6-1.2-7.7-.3-9.1.9-1.2 2-3.8.5-8.9 0 0 2.8 10.5-4.5 10.5-7.5 0-7.2-2.7-7.2-2.7" />
          <path d="M284.4 190.5c0 2 0 8.4 9 8.4 2.8 0 5.8-2 7.4-3.3m2.2-2.7c-.3-2-.3-4.4-.3-7m-13.6-3.4c2.4-.3 4.4-.6 9-.6m.2-6.3c.5 2.2-.3 5.8 4 6.3m4.3-7.1c-.6 1.6-.6 3.3-.8 4.4m.2 2.7c1.7 0 5-1.1 9-.3m1.4 22.8c.9 1.6 1 3.8 3.6 6.2m-31.7-11.4c.2 1.3-1.8 5.7-.3 9.3a12.3 12.3 0 0 1-1.2 11m6.7-19c-.9 1.7-2.3 3.3-2.6 4.7m6.6-1.6c0 1-2.7 8.7-4.7 10.9 0 0 3.6 1.4 3 6.6m7.4-21c0 1.2-.2 1.6 1 2.4m2.4 0c1.3 1.6 5.5 6.5 4.6 9.2m-7.4-6.5c.3 1 .3 6.3-.6 9m-2.1-.2c-1.1 0-2.8.8-3 2.7m8.7-3c1.1-.3 3.3 1.6 3.3 7m15.7-10.2c-2.1.6-3 1.7-2.4 1.1-1.1 1-2.2 1.6-2.2 1.6" />
        </g>
        <path
          fill="#000"
          strokeWidth={0.3}
          d="M289.8 198c.6 0 1.1-.4 1.1-1 0-.3-.5-.7-1.1-.7-.5 0-1 .4-1 .8 0 .5.5.9 1 .9zm23 .3c.6 0 1.1-.4 1.1-1 0-.4-.5-.7-1-.7-.6 0-1.1.3-1.1.8s.5.9 1 .9z"
        />
        <path
          fill="#fff"
          d="M280.5 239.8c1.3-8 5-14.5 5.1-15.2 0 0 3.9.9 10.6 1.5 6.6.7 8.4.4 11.5.2l6.8-.8s1.2 2.4 1.3 4.8c.3 5.2 2.3 27.7 2.5 33.7 0 0 .8 3.6.8 12.3 0 9.6 2.6 29 2.6 39.4l-2.6.5s-14.5 1.1-14.5-.8c0-2.1-.8-27 1.4-42.1 0 0-.5-3-1.4-5.5-.8-2.5-4.3-10-4.3-11.7 0 0-5.7 16-6 18.8-.3 2.6-1.2 38.4-1.7 41.3 0 0-8.2 6.3-9.3 7-1.1.4-9-3.4-9.3-4.4a211 211 0 0 1 4.6-33.2c1.4-7.1.6-8.4.6-10.4s.1-27.5 1.3-35.4z"
        />
        <path
          fill="none"
          d="M294.3 275c-.6 2.2-1.7 4.3-3.6 5.7m-2.7-53.6c-.3 1.3-2.3 7.3-7.2 10.9m14.3-9.8c-1.1 3.6-5.5 22.7-6.3 45.4m-.3 7.1-1.7 20.8m-.8 3a71.3 71.3 0 0 0-2.7 18.7m32.2-36c-.2 2-1 15.7 3.6 28m-18.5-86c-.3 2.3-.8 16.7-.8 17.8 0 1.2 1.6 2.8 2.4 3 0 0-1.6.6-2 6m-4-12.8c-.3 1.7-2 8.5-3 11.3m13-25.5s5 1 5.3 0c0 0 1.6 29.5 3.8 46m-11.2-42.2-.6 16.5m2.5 2.1s1.9 2.8 1.4 4m-17.8-28 3 .8m5.2 1.6c-.3.9-.6 4.6-.6 4.6m8.8 38.9c.6.8 1.4 2 .8 4.4"
        />
        <path
          fill="#9b5f00"
          d="M285 224.4s0-3.2 1.1-4.8c0 0 3.5.7 8.4 1.2 5 .5 9 .9 12.6.5 3.7-.4 7.4-1.3 7.4-1.3s1 4.8.5 5.5c0 0-4 .8-8.3 1a86 86 0 0 1-14.5-.8 57 57 0 0 1-7.3-1.3z"
        />
        <path
          fill="#fff"
          d="m288 224.8.7-4.8h1l-.2 5.1-1.4-.2m22-4.1.1 5.5 1.3-.2-.1-5.6-1.3.3m-15.6 0-.4 5.3h.7l.7-5.3h-1"
        />
        <path d="M276.8 320.8c-.3 1.3-.8 3.2-1 5.5 0 .5-.6 3.3 1 3.4 1 0 1.4-2.9 1.4-2.9s-1 3.3.3 3.7c1.8.4 2-3.6 2-3.6-.2 1.1-1.4 4 .3 4.3 1.9.3 2.4-3.9 2.4-3.9s-1.6 4.2.3 4.3c1.7 0 1.7-4 1.7-4s-.9 5 1.5 4.5c1.4-.2 1.7-2 2-3 .4-1.5 1.3-3.4.2-6.6-.8-2.3-.5-3-.5-3s-2.9 2.2-5.1 3.6c-1 .6-6.5-2.3-6.5-2.3zm29.7-4.4c-.5-.3-.4 1.9-.6 2.9-.1 1 .2 3.2 3.6 3 3.4-.3 6.7-1 8.9-.5 2.1.6 5.3.7 7 .7 1.7 0 2.8-.2 3.7-.5.7-.3 2.2.4 3 .4s1.7-1 1.6-1.8c0-1.3-1.3-1.3-3-1.4a22 22 0 0 1-5-1c-1.1-.3-3.1-1.5-5.7-2l-5.9.2c-1 0-7 .3-7.6 0z" />
      </g>
      <g fill="none">
        <path
          fill="#ffb366"
          d="M255.7 189.8c-.5.3-1.1-2 .4-2.9 0 0 .4-2 2-2.1 0 0 1.4-1.9 3.3-1.7 0 0 2.2-1.5 3-1.3.9.1 3 2.1 3 2.9.2.7 0 1.9-.5 2.4-.6.6-1-.1-1.1-1 0 0 .4 1.6-.8 2.2-1.2.7-1.1.2-1.2-.6 0 0-.4 1.6-1.2 1.9-.8.3-1.3-.5-2-.5 0 0 1.1.9.4 1.5-.7.5-1.5.3-2-.1-.5-.5-1.2-1.9-3.3-.6z"
        />
        <path d="M265.7 186c-.5-1.5-2.2-3-4-2.8m2.2 4.4c-.3-.4-.4-.8-.8-1.2-.9-1.5-2.8-1.4-4.4-1.8m2.4 4.5c-.6-.4-.8-1.2-1.4-1.5-1-.4-2-.9-3.3-.7" />
      </g>
    </g>
    <g stroke="#000" strokeWidth={0.5} transform="translate(-40) scale(.96)">
      <path
        fill="url(#bz-e)"
        d="M439.1 165.1c.7-.3.5.6.6 1 .4 1.3.4 2.7.9 3.9.6 1.1.8 1.5 1.8 2 1.6 1 6.4 3.6 9.8 1.5a3.1 3.1 0 0 0 .7-.5s-1.3 4.1 3 6.2l15.6 8.2s1.5 2.7.6 6.5c-.2.6-.4 1.1.2 1.5 1 .7 2.6 2.8 3.8 6 0 0 3-1.3 3-3.2 0-2-1.3-3-1.6-4.4-.2-1.3-1-4.7-.6-5.7.4-1.1 2.1-1.5 2.8-2 .7-.3 1.6.5 1.3 1.4 0 1-.8.8-1.6 1 0 0 1 2 .8 3.4l9.4 4.8-1.6 2.3c-.5.7-1.5 10.2-4.2 14.6-2.8 4.5-3.7 3.3-4.2 4l-2.1 1.8c-.6.5-3.8.9-4.5-.9a9 9 0 0 0-3.1-4.1c-2-1.6-6-5.4-6-7.2 0 0-2.3 6.8-2 12.4 0 0-8.4 1.7-16.2 1.9-7.6 0-11.5-1.5-11.5-1.5s-1-6.4-.6-7.7c0 0-1.2 4.2-2 5.6-1.1 1.8-2.2 5.3-4.4 5.5-2.2.1-4-2.1-4.2-3v-6.8h-8.7s-3.8 1.5-5 1.3c-1.3-.1-1.9-1.3-.9-1.7l.4-.3a7 7 0 0 0-2.5.7H402l.1-.5c.3-1.2 2.6-2.2 4.3-3 1.6-.5 3.3-1.2 4.6-1.3 1.9-.2 3.2-.1 6.2.4.8 0 4 .4 5.8 1.3.5.3 1 .4.8-1-.3-1.3-1.2-5.5.3-8.3 1-1.9.9-3.5.8-5.2-.2-1.7-1.1-5.6-1.1-7.3 0-5.7 4.4-8 8.2-9.2 4.3-1.4 7.1-2.8 7-5.3-.2-2.7.5-7 .1-9"
      />
      <g fill="none">
        <path
          fill="url(#bz-f)"
          d="M456.3 153.6a20 20 0 0 1 1.2 5.3c0 1.2-.5 1.4-.1 2.8.7 2.4-.8 5-2.5 8-.8 1.2-1.4 3-2.7 3.8-3.4 2.1-7.5-.4-9.6-1.3a3.7 3.7 0 0 1-2-2.2c-.4-1.2-.5-2.3-.8-4 0-.3 0-1.2-.6-.9-1.3-1.4-1-2-1.6-3-.5-1 1-2.2 2-2a10 10 0 0 1-.2-5.9c.2-.6-.6-2.2.5-1.8 4.5 1.8 10 1.4 14.8 1.4.4 0 .7-.8 1.3-.7l.3.5"
        />
        <path
          fill="#000"
          d="M456.8 155.3c.4-.4.1-2.3-.4-4.3-.1-1-1-1.5-2-2.6s-1.6-1-2.3-1.4c-.6-.2-2-.2-2.8-.5-.6-.3-2.2-.1-3.7.1-2 .3-3.2.2-4.7 1s-2.8 1.8-3.3 3.3c-.4 1-1 2.5-.8 6.8.2 4.3 1 3.5 1 3.5s1.1-1.7 1.9-.6l-.3-3.6c-.1-1.2 0-2.8.5-4.6 0 0 4.6 1.7 9 1.7 3 0 7-.3 7.1-1l.7 2.2z"
        />
        <path d="M450.4 160.1c.7 1.8.1 1.3.4 2.4m-10.2 2c0 .8-.6.6-1 .6" />
        <path d="M456.9 158.8c-1-.7-2.7-.2-3.5.1-1.5.7-.7 2.3-.2 3.7.2.7 1 1.7.5 2.4-.4.8-.7.4-1.6.5 0-.3-.8 0-1.1 0-.6 0-1 .4-1.5.2-.6-.3-.5-1.2-.3-1.7m.1-4.5c0-.4-1.3-.8-2.7-.9-2.3 0-2.5.1-4.2 1.3m11.5 9c-.4-.6-1-1-2.1-.4 0-.2-1.6-.4-1.6-.4-.8 0-1.3.3-2.1.7m5.6.6c-1-.6-3.3-.2-5.6-.2m.2.8c1.7.5 3.5.8 5.2 0" />
        <path
          fill="#fff"
          strokeWidth={0.3}
          d="M456.4 160.1c-.7 0-1-.9-3.1.3-1.1.7 1.8 1.5 1.4 1.4 1.2.2 1.6-.5 1.7-1.2 0-.1.2-.5 0-.5zm-8.3.8c0-.8-1.8-1-2.9-.8-1 .3-.5.1-1.5.7 1 .1.7.2 1.6.6.9.5 1 .9 2.3.3.3-.1.7-.5.8-1 0 .2-.2.3-.3.3z"
        />
        <path
          fill="#000"
          strokeWidth={0.3}
          d="M455.1 161.4a.8.8 0 0 1-.8-.8c0-.6.3-1 .8-1 .4 0 .7.4.7 1 0 .4-.3.8-.7.8zm-8.7.2c-.4 0-.7-.4-.7-1 0-.5.4-.8.8-.8s.7.3.7.8c0 .6-.3 1-.8 1z"
        />
      </g>
      <use
        xlinkHref="#bz-g"
        fill="#730000"
        transform="matrix(-1 0 0 1 748.8 0)"
      />
      <g fill="none">
        <path
          fill="#730000"
          d="M491.6 193.5c.5.2 2-2 .5-3 0 0-.5-2-2-2 0 0-1.4-2-3.4-1.7 0 0-2-1.5-2.9-1.4-1 .2-3 2.2-3 3-.2.5 0 1.8.5 2.4.6.5 1-.1 1-1 0 0-.3 1.5.9 2.2 1.2.7 1.1 0 1.2-.7 0 0 .3 1.6 1.1 2 .9.2 1.4-.5 2-.5 0 0-1 .8-.3 1.3.7.6 1.5.3 2 0 .6-.5.3-1.8 2.4-.6z"
        />
        <path d="M482.5 189.8c.5-1.8 2.2-3.2 4-2.9m-2 4.4c.1-.4.2-.8.5-1.2 1-1.6 3-1.6 4.6-1.9m-2.5 4.5c.6-.4.8-1.1 1.4-1.4a5.3 5.3 0 0 1 3.2-.7" />
        <path
          fill="#730000"
          stroke="none"
          d="M482.3 186.8c-.9.7-1.8 1.8-1.9 2.2 0 .7 0 1.9.5 2.5.6.5 1 0 1.1-.8 0 .5 0 1.5.8 2 1.3.7 1.2.1 1.3-.7 0 0 .3 1.6 1 2 .9.2 1.4-.5 2-.5 0 0-1 .8-.3 1.3.7.6 1.5.3 2 0 .6-.5.3-1.8 2.5-.6.2.2.8-.4 1-1.1l-7.7-5.5-2.3-.8z"
        />
        <path d="M480.7 188.2c-1.5 2.6.5 4.1 1.1 2.6-.1 2.4 1.7 2.3 2.3 1.5.7 2.5 1.9 1.4 3 1.2-1.3 2.3 1.4 1.6 2 1 1-1.3 1.4-.2 2-.3l1.3-1.3m-8-5.7c-1.7 1-2.5 2.2-2.6 3.7m5-2.2c-1.8 1-2.6 2.2-2.6 3.7m5.4-1.7c-1.7.9-1.8 1.7-2.5 2.8" />
      </g>
    </g>
    <path
      fill="#5ac800"
      d="m238.5 310.7-.2-4.5 1.9 1.6.4-3.4c.8-.2 2.1 1.3 2.1 1.3l-.2-3.4 2.8 3.1s-.2-2.6.8-4.2c0 0 2.2 1.9 2.2 4 0 1.9 1.8-2.6 1.8-2.6a3116.2 3116.2 0 0 0 1.6 5l1.3-1.9 1 4 2.4-3.5 1.8 4 4.2-.3.5 2.4 1.9-2 2.4 1.5s2-.6 3.1-.6 2.4 1.4 2.4 1.4.8-1.4 1.5-1.9 1.9.8 2.2 1.6l1.6-2.9s2 2 2.3 2.9c0 0 .3-2.4.8-3.2.5-.7 1.2.3 1.8 1.3l1.3-4.2s1.4.3 2.3 1.9c1.1 1.5 1.1-2.4 1.1-2.4s2.4 3.2 3 5.3c0 0-16.2 5.6-27.6 4a306 306 0 0 1-24.5-4.3m110.9-.5s.7-2.1 1.8-3.2c0 0 2 2.4 2 3.2l1.7-1 1.6 1.5 1.8-1.3 1.8 1.6 3.2-1.4 1.3 1.4 5-.6 1.8.8 1.8-2.3 1.6 1.8 2.7-2.6s1.3 1 1.5 1.8c0 0 2.2-1 2.7-1.8 0 0 2-.8 2.3.5 0 0 1.3-1 1.2-2-.1-1.2 1.5-.4 2 1 0 0 .5-2.2 2-2.4 0 0 1.2 1.3.9 3.7 0 0 2.3-1.9 3.4-2.1 0 0 .5 2.6-.3 5 0 0 2.4-4 3-2.7.1.8.7 3.5.1 5.3l2.2-1.3.8 2.6 2.3-.5s-13.9 2.1-27 .9c-13-1.3-25.3-5.9-25.3-5.9m-9.6 9.7c.6-.4-4.4 10.3-16.5 10.9-16.9.8-31.3-7.7-31.3-7.7s1.8-2.9 2.9-3.7c0 0 2.3 1.9 3 4.2 0 0 .4-1.5 1.2-2.9 0 0 2.9 1.4 3.4 3.2 0 0 1-1.8 1.8-2.3.8-.6 1.6 2 1.6 3.6 0 0 1.9-2 3-2 0 0 2 1 2.6 4.3 0 0 2-1.8 2.6-1.5 0 0 2.3 1.5 1.8 3.7-.3 1.2 2.3-1.4 5.5-2.2l2.9 2.2 3.4-4.7s2.1.8 2.1 2c0 0 1-3.7 1.8-4 .8-.5 1.8 1.1 1.8 2.2 0 0 .3-2.8 1.9-3.4 0 0 1.6 1 1.6 2.1 0 0 1.6-3.2 2.9-4z"
    />
    <path
      fill="none"
      stroke="#060"
      strokeWidth={0.5}
      d="m238.5 310.7-.2-4.5 1.9 1.6.4-3.4c.8-.2 2.1 1.3 2.1 1.3l-.2-3.4 2.8 3.1s-.2-2.6.8-4.2c0 0 2.2 1.9 2.2 4 0 1.9 1.8-2.6 1.8-2.6l1.6 5 1.3-1.9 1 4 2.4-3.5 1.8 4 4.2-.3.5 2.4 1.9-2 2.4 1.5s2-.6 3.1-.6 2.4 1.4 2.4 1.4.8-1.4 1.5-1.9c.8-.5 1.9.8 2.2 1.6l1.6-2.9s2 2.1 2.3 2.9c0 0 .3-2.4.8-3.2.5-.7 1.2.3 1.8 1.3l1.3-4.2s1.4.3 2.3 1.9c1.1 1.5 1.1-2.4 1.1-2.4s2.4 3.2 3 5.3m58.7-.8s.8-2.1 1.9-3.2c0 0 2 2.4 2 3.2l1.7-1 1.6 1.5 1.8-1.3 1.8 1.6 3.2-1.4 1.3 1.4 5-.6 1.8.8 1.8-2.2 1.6 1.7 2.7-2.6s1.2 1 1.5 1.8c0 0 2.2-1 2.7-1.8 0 0 2-.8 2.3.5 0 0 1.3-1 1.2-2-.1-1.2 1.5-.4 2 1 0 0 .5-2.2 2-2.4 0 0 1.2 1.3.9 3.7 0 0 2.3-1.9 3.4-2 0 0 .5 2.5-.3 4.9 0 0 2.4-4 3-2.7.1.8.7 3.5.1 5.3l2.2-1.3.8 2.6 2.3-.5m-109.8 8s1.8-3 2.9-3.7c0 0 2.3 1.8 3.1 4.2 0 0 .3-1.6 1-3 0 0 3 1.4 3.5 3.2 0 0 1-1.8 1.9-2.3.7-.6 1.5 2 1.5 3.6 0 0 1.9-2 3-2 0 0 2 1 2.6 4.4 0 0 2-1.9 2.6-1.6 0 0 2.4 1.6 1.8 3.7-.3 1.2 2.3-1.4 5.5-2.1l2.9 2.1 3.4-4.7s2.1.8 2.1 2c0 0 1-3.6 1.8-4 .8-.5 1.9 1.1 1.9 2.2 0 0 .3-2.8 1.8-3.4 0 0 1.6 1 1.6 2.1 0 0 1.6-3.2 3-4"
    />
    <g fill="#fff">
      <path d="M319.5 361.9c22 .2 35-7.8 42-12.6 16.8-11.2 20.3-11.6 23-11.4 3.1.3 7.7 1.3 8 4 .2 4.3-6.6 6.1-10.5 6.1-4 0-14.5-2.6-14.5-2.6l-2.7 1.9c1.8.8 23.2 8 27.3 1.2 4.2-6.8 8.4-17.9 8.4-17.9s-4.7-8.4-15.1-8.4c-10.6 0-20.8 6.7-27.6 11.7-6.9 5-15.5 11.8-38.3 11.8-22.9 0-31.6-6.8-38.4-11.8-6.9-5-17.1-11.7-27.6-11.7a18 18 0 0 0-15.2 8.4s4.2 11 8.4 18c4.1 6.7 25.5-.5 27.3-1.4l-2.6-1.8S261 348 257 348s-10.9-1.8-10.6-6c.2-2.8 4.8-3.8 8-4.1 2.7-.2 6.2.2 22.9 11.4a72 72 0 0 0 42.2 12.6" />
      <path d="M284.1 336s0-1.9-.3-4.6c-.4-3.5-2.4-4.4-4-3.9-1.2.4-3.3 3-3.3 3v.1a31 31 0 0 0-3-1.8 18 18 0 0 1 6.3-3.6c1 0 14.5 5.4 18.8 9.1 1 1 1.8 7 1.2 9a46.5 46.5 0 0 1-15.7-7.2m-6.5 13.6s-2.9 3-3 8.3c0 6.3 4.5 6.6 7.5 6.5 3.7 0 6.6-2.1 6.5-8.9 0 0-6-2.5-11-6m77.1-13.6.4-4.6c.4-3.5 2.4-4.4 4-3.9 1 .4 3.2 3 3.2 3v.1l3-1.8c-.7-1-5.2-3.6-6.2-3.6s-14.5 5.4-18.8 9.1c-1 1-1.8 7-1.3 9a45.5 45.5 0 0 0 15.7-7.2v-.1m6.5 13.7s2.9 3 3 8.3c.2 6.3-4.5 6.6-7.5 6.5-3.6 0-6.5-2.1-6.5-8.9 0 0 6-2.5 11-6" />
    </g>
    <path
      fill="#69f"
      d="M271.3 345.4S260.9 348 257 348c-4 0-10.9-1.8-10.6-6 .2-2.8 4.8-3.8 8-4.1 2.3-.2 5.3 0 17 7.5m96.1 0S378 348 382 348c3.9 0 10.7-1.8 10.4-6-.2-2.8-4.8-3.8-7.9-4.1-2.3-.2-5.4 0-17 7.5m-83.4-9.3a93.7 93.7 0 0 1-3.1-2.3c-1.5-1.1-3-2-4.5-3.2 0 0 2.1-2.7 3.2-3 1.7-.6 3.7.3 4.1 3.8.3 2.7.3 4.7.3 4.7m-7.1 27.6c1.8 1 3.9 1 5.1.8 3.7 0 6.6-2.1 6.5-8.9 0 0 4.5 2.3 11.8 4 0 0 1.2 1.5 1.4 4.4.3 2.5-1.4 5.1-3.3 5 0 0-10.3-2-16.5-3-3.7-.7-5-2.3-5-2.3m77.7-27.6 3.2-2.3 4.4-3.2s-2.1-2.7-3.2-3c-1.6-.6-3.6.3-4 3.8l-.4 4.7m7.1 27.6c-1.8 1-3.9 1-5.1.8-3.6 0-6.5-2.1-6.5-8.9 0 0-4.5 2.3-11.7 4 0 0-1.3 1.5-1.5 4.4-.2 2.5 1.5 5.1 3.4 5 0 0 10.3-2 16.5-3 3.6-.7 5-2.3 5-2.3"
    />
    <g fill="none" stroke="#000" strokeWidth={0.7}>
      <path d="M319.5 361.9c22 .2 35-7.8 42-12.6 16.8-11.2 20.3-11.6 23-11.4 3.1.3 7.7 1.3 8 4 .2 4.3-6.6 6.1-10.5 6.1-4 0-14.5-2.6-14.5-2.6l-2.7 1.9c1.8.8 23.2 8 27.3 1.2 4.2-6.8 8.4-17.9 8.4-17.9s-4.7-8.4-15.1-8.4c-10.6 0-20.8 6.7-27.7 11.7-6.8 5-15.4 11.8-38.2 11.8s-31.6-6.8-38.4-11.8c-6.9-5-17.1-11.7-27.6-11.7s-15.2 8.4-15.2 8.4 4.2 11 8.4 18c4.1 6.7 25.5-.5 27.4-1.4l-2.7-1.8S261 348 257 348s-10.9-1.8-10.6-6c.2-2.8 4.8-3.8 8-4.1 2.7-.2 6.2.2 22.9 11.4a72 72 0 0 0 42.2 12.6z" />
      <path d="M271.3 345.4S260.9 348 257 348c-4 0-10.9-1.8-10.6-6 .2-2.8 4.8-3.8 8-4.1 2.3-.2 5.3 0 17 7.5zm96.2 0S378 348 382 348c3.9 0 10.7-1.8 10.4-6-.2-2.8-4.8-3.8-7.9-4.1-2.3-.2-5.4 0-17 7.5zm-83.4-9.3a92.6 92.6 0 0 1-3.1-2.3c-1.5-1.1-3-2-4.5-3.2 0 0 2.1-2.7 3.2-3 1.7-.6 3.7.3 4.1 3.8.3 2.8.3 4.7.3 4.7z" />
      <path d="M284.1 336s0-1.9-.3-4.6c-.4-3.5-2.4-4.4-4-3.9-1.2.4-3.3 3-3.3 3v.1a31.9 31.9 0 0 0-3-1.8 18 18 0 0 1 6.3-3.6c1 0 14.5 5.4 18.8 9.1 1 1 1.8 7 1.2 9a46.6 46.6 0 0 1-15.7-7.2m-6.5 13.6s-2.9 3-3 8.3c0 6.3 4.5 6.6 7.5 6.5 3.7 0 6.6-2.1 6.5-8.9 0 0-6-2.5-11-6z" />
      <path d="M280.1 351.1s-2.3 2.5-2.7 6.5c-.2 3.1 1.8 4.9 4.5 4.7 3.7-.2 5.1-5.3 3.4-8.1l-5.2-3" />
      <path d="M277 363.7c1.8 1 3.9 1 5.2.8 3.6 0 6.5-2.1 6.4-8.9 0 0 4.5 2.3 11.8 4 0 0 1.2 1.5 1.4 4.5.3 2.4-1.4 5-3.3 4.8L282 366c-3.7-.7-5-2.3-5-2.3zm77.7-27.6 3.3-2.3c1.3-1.1 2.8-2 4.4-3.2 0 0-2.2-2.7-3.3-3-1.6-.6-3.6.3-4 3.8l-.4 4.7z" />
      <path d="m354.7 336 .4-4.6c.4-3.5 2.4-4.4 4-3.9 1 .4 3.2 3 3.2 3v.1a31.9 31.9 0 0 1 3-1.8c-.7-.9-5.2-3.6-6.2-3.6s-14.5 5.4-18.8 9.1c-1 1-1.8 7-1.3 9a45.7 45.7 0 0 0 15.7-7.2m6.5 13.6s2.9 3 3 8.3c.2 6.3-4.5 6.6-7.5 6.5-3.6 0-6.5-2.1-6.5-8.9 0 0 6-2.5 11-6z" />
      <path d="M358.7 351.1s2.4 2.5 2.8 6.5c.3 3.1-1.9 4.9-4.5 4.7-3.7-.2-5.1-5.3-3.4-8.1l5.1-3" />
      <path d="M361.9 363.7c-2 1-4 1-5.2.8-3.6 0-6.5-2.1-6.5-8.9 0 0-4.5 2.3-11.7 4 0 0-1.3 1.5-1.5 4.5-.2 2.4 1.5 5 3.4 4.8l16.5-2.9c3.6-.7 5-2.3 5-2.3z" />
    </g>
    <path
      fill="none"
      stroke="#fff"
      strokeWidth={0.7}
      d="M299.6 361.4s3.3 2.4-.7 5.3m-9-6.8 10 4.3m-8.3-2.1 7.2 3.1m-4.6-5 5.4 2.5m39.7-1.3s-3.3 2.4.6 5.3m9-6.8-10 4.3m8.4-2.1-7.2 3.1m4.6-5-5.4 2.5"
    />
    <path
      stroke="#000"
      strokeWidth={0.7}
      d="M261 331.4c.2.2.2.4.3.7a2.5 2.5 0 0 1 0 .8 2.4 2.4 0 0 1-1.2 1.6 3 3 0 0 1-2.2.4 3.7 3.7 0 0 1-1-.4 4.3 4.3 0 0 1-1-.6l-.3.4-.4-.1.4-2.9.5.1c0 .4 0 .7.2 1l.3 1 .7.6c.2.2.5.3.9.4h.7a1.2 1.2 0 0 0 .9-.6 1.8 1.8 0 0 0 .2-.6 1.7 1.7 0 0 0-.1-1 1.8 1.8 0 0 0-.7-.7 48.3 48.3 0 0 0-.8-.5l-.8-.6c-.5-.3-.8-.6-1-1-.2-.4-.2-.8-.1-1.4 0-.3.2-.6.4-.8a2.5 2.5 0 0 1 1.5-1 2.9 2.9 0 0 1 1 0l1 .4.8.6.3-.4.5.1-.5 2.8-.5-.1a11.2 11.2 0 0 0 0-1 3.6 3.6 0 0 0-.4-.8 2 2 0 0 0-.5-.7 2 2 0 0 0-.8-.4 1.4 1.4 0 0 0-1 .2c-.4.2-.6.5-.6.8v1l.7.7.8.5a14.1 14.1 0 0 1 1.3 1c.2 0 .4.3.5.5m12 1.6-.5-.1a1.4 1.4 0 0 0-.5-.1c-.2 0-.4.1-.5.3a5.7 5.7 0 0 0-.6 1l-1.8 3.1a2.4 2.4 0 0 1-1.9 1.3h-1.1a4.2 4.2 0 0 1-1-.5 4.3 4.3 0 0 1-1-.8 3 3 0 0 1-.7-1 2.2 2.2 0 0 1-.1-1 2 2 0 0 1 .2-.8l2.4-4.3a.9.9 0 0 0 .1-.4v-.3a1.5 1.5 0 0 0-.3-.3l-.4-.3.2-.3 3.1 1.7-.2.3-.3-.1a2 2 0 0 0-.4-.1h-.4a.9.9 0 0 0-.2.3l-2.2 4a3.3 3.3 0 0 0-.3.7 1.8 1.8 0 0 0 0 .8c0 .2 0 .5.2.7l.9.8 1 .3a1.9 1.9 0 0 0 1.5-.5l.5-.6 1.6-3 .5-1v-.6c0-.2-.2-.3-.4-.5a3.6 3.6 0 0 0-.4-.3l.2-.4 3 1.7a19.2 19.2 0 0 1-.2.3m4.3 7.5a1.9 1.9 0 0 1 0 1.8 2 2 0 0 1-.8.8 2.2 2.2 0 0 1-1 .3l-1-.1a4 4 0 0 1-.9-.4l-3.5-2 .2-.4a5 5 0 0 0 .8.3.5.5 0 0 0 .3 0 .7.7 0 0 0 .3-.3l3-5.3a1 1 0 0 0 .1-.3.6.6 0 0 0-.1-.4 1.7 1.7 0 0 0-.3-.3l-.3-.2.2-.4 3.4 2 .7.5.6.7a1.6 1.6 0 0 1 0 1.6 1.8 1.8 0 0 1-.6.6l-.7.3a2.5 2.5 0 0 1-.7 0 3.3 3.3 0 0 1-.8-.2v.1a5 5 0 0 1 .6.6l.5.7zm-.6-1.8c.2 0 .4-.2.5-.3a2.7 2.7 0 0 0 .5-.6c.2-.4.3-.8.2-1.2-.1-.3-.4-.6-.9-.9l-.4-.2-.4-.3-1.6 2.8.6.4.8.3h.7zm-.6 2.7c.2-.4.3-.8.1-1.3 0-.4-.4-.8-1-1.1a29 29 0 0 0-.5-.4l-.4-.1-1.5 2.5a.6.6 0 0 0 0 .7c.1.2.4.4.7.5.5.3 1 .4 1.4.3.5-.2.8-.5 1.2-1zm18.9 4.3a3.5 3.5 0 0 0-.5 0 1.4 1.4 0 0 0-.6-.1c-.1 0-.3.1-.4.4a5.9 5.9 0 0 0-.5 1l-1.5 3.3c-.1.4-.4.7-.7 1a2.6 2.6 0 0 1-1 .4 3.2 3.2 0 0 1-1.1 0 4.3 4.3 0 0 1-2.2-1 3.1 3.1 0 0 1-.7-.8 2.2 2.2 0 0 1-.3-1 2 2 0 0 1 .2-.9l2-4.5a.9.9 0 0 0 0-.4.7.7 0 0 0-.1-.3 1.6 1.6 0 0 0-.3-.3l-.4-.2.2-.4 3.3 1.4-.2.4a3.5 3.5 0 0 0-.4-.1 2.3 2.3 0 0 0-.4 0h-.3a1 1 0 0 0-.2.3l-1.9 4.3-.2.7a1.7 1.7 0 0 0 .4 1.4c.2.3.5.5 1 .7l1 .2a1.9 1.9 0 0 0 1.5-.7 2.5 2.5 0 0 0 .4-.6l1.3-3.1.3-1v-.7l-.4-.4a3.7 3.7 0 0 0-.5-.3l.2-.4 3.1 1.4-.1.3m9.2 10.8-3.6-1v-.4a9 9 0 0 0 .6 0l.4.1a.8.8 0 0 0 .4-.2.7.7 0 0 0 .2-.3l1.7-5.8a1.4 1.4 0 0 0-.1 0l-4.8 6h-.3l-.6-7.9-1.5 4.8-.2 1.1.1.6.5.4a3.2 3.2 0 0 0 .5.3l-.2.4-3.2-1v-.4h.6a1 1 0 0 0 .5 0c.2 0 .3-.2.5-.4l.3-1 1.2-4.2a1.7 1.7 0 0 0 .1-.6 1 1 0 0 0-.1-.4 1.2 1.2 0 0 0-.4-.4 2 2 0 0 0-.5-.2l.1-.4 2.8.8.6 6.7 3.5-4.5.3-.5a2.8 2.8 0 0 0 .2-.4l2.7.8-.1.4a3.9 3.9 0 0 0-.5 0 2.4 2.4 0 0 0-.4-.1.4.4 0 0 0-.3.1 1 1 0 0 0-.1.4l-1.7 5.8a.8.8 0 0 0 0 .3l.1.3a3.4 3.4 0 0 0 .8.4l-.1.4m8.7-2.6a1.9 1.9 0 0 1 .7 1.7l-.4 1c-.2.3-.5.4-.8.6-.3.2-.6.2-1 .3h-1l-4-.5v-.4h.5a1.7 1.7 0 0 0 .4 0 .5.5 0 0 0 .3-.2.7.7 0 0 0 .1-.4l.8-6a1 1 0 0 0 0-.3.6.6 0 0 0-.3-.3 1.7 1.7 0 0 0-.4-.2h-.3v-.5l3.9.5c.3 0 .6 0 .9.2l.7.4a1.6 1.6 0 0 1 .6 1.5l-.2.8a1.7 1.7 0 0 1-.6.5 2.6 2.6 0 0 1-.6.3 3.4 3.4 0 0 1-.8.2l.8.3.7.5zm-1.3-1.5.4-.5.2-.7a1.5 1.5 0 0 0-.3-1.1c-.2-.3-.6-.5-1.1-.5a27.3 27.3 0 0 0-1-.1l-.4 3.2h.8c.3.1.6 0 .8 0a1.3 1.3 0 0 0 .6-.3zm.5 2.8c0-.5 0-1-.3-1.3-.3-.3-.8-.5-1.4-.6l-.7-.1h-.4l-.3 2.9a.6.6 0 0 0 .2.6l.8.3c.6 0 1 0 1.5-.4.3-.3.5-.7.6-1.4zm11.4 2.6h-2.2a44 44 0 0 0-1.4-2l-1.3-1.8h-1v2.7l.1.4.3.2h.4l.5.1v.4h-3.6v-.4h.4l.4-.1a.5.5 0 0 0 .2-.2.7.7 0 0 0 .1-.4v-6.4l-.3-.3a2.2 2.2 0 0 0-.4 0l-.4-.1v-.4h4.9a2.8 2.8 0 0 1 .9.4l.6.6a2.3 2.3 0 0 1 0 1.8 2 2 0 0 1-.4.7 2.5 2.5 0 0 1-.7.4 5.3 5.3 0 0 1-.8.3l1 1.4c.3.4.7.8 1 1.4a2.5 2.5 0 0 0 1 .8 3 3 0 0 0 .8.1v.4zm-3.1-6.2c0-.5-.2-1-.4-1.2-.3-.3-.8-.5-1.3-.5h-1v3.6h.8c.5 0 1-.1 1.3-.5.4-.3.6-.8.6-1.4zm13 5.6-3.6.3v-.4l.7-.2c.2 0 .3-.2.3-.2v-.2a.5.5 0 0 0 0-.1l-.9-1.8-3 .2a9.6 9.6 0 0 0-.2.7l-.1.6a3.4 3.4 0 0 0-.1.4v.3c0 .2.1.3.4.3l.9.1v.4l-3.2.3v-.4a2 2 0 0 0 .4-.1 1.3 1.3 0 0 0 .7-.6l.2-.5 1.1-3.6 1.1-3.6h.5l3.4 7 .2.3a1.2 1.2 0 0 0 .7.4h.4v.4zm-3.7-3.1-1.6-3.2-1 3.4 2.6-.2zm15.7-6.7a27.9 27.9 0 0 0-.4.2 3.1 3.1 0 0 0-.8-.9c-.4-.2-.7-.4-1-.3a6.3 6.3 0 0 0-.3 0l-.6.2-1.4.4.9 3.2 1-.2.6-.3.3-.4.1-.4v-.6l.4-.2.9 3.2-.4.1a2.9 2.9 0 0 0-.3-.5l-.4-.4a.9.9 0 0 0-.5-.2 2.3 2.3 0 0 0-.6.1l-1 .3.8 2.8s0 .2.2.3a.6.6 0 0 0 .3.2h.4l.4-.1.1.4-3.5 1-.1-.4a9.5 9.5 0 0 0 .4-.2l.4-.2a.5.5 0 0 0 .2-.3.8.8 0 0 0 0-.3l-1.6-5.9a1.1 1.1 0 0 0-.2-.3l-.3-.2a2.4 2.4 0 0 0-.4 0 2.4 2.4 0 0 0-.5 0l-.1-.3 6.4-1.8.6 2m9.4-.7 1 2.4-6 2.8-.2-.3.4-.3a1.4 1.4 0 0 0 .3-.2.5.5 0 0 0 .1-.3.8.8 0 0 0 0-.4l-2.7-5.4a1 1 0 0 0-.2-.3.5.5 0 0 0-.4 0h-.4a2 2 0 0 0-.4 0l-.2-.3 3.3-1.6.2.4a2.8 2.8 0 0 0-.4.2 2.2 2.2 0 0 0-.3.3.4.4 0 0 0-.2.3.8.8 0 0 0 .1.4l2.5 5c0 .3.2.5.3.6l.3.2h.4l.7-.3.4-.2.4-.3.3-.2a.6.6 0 0 0 .2-.3 6.3 6.3 0 0 0 .2-2l.3-.2m4.5-8.3a4.2 4.2 0 0 1 1.5.8l1.2 1.4a5 5 0 0 1 .6 1.7 4.1 4.1 0 0 1 0 1.6 4 4 0 0 1-.7 1.5 4 4 0 0 1-1.2 1 4 4 0 0 1-3.2.4 4 4 0 0 1-1.4-.7 5 5 0 0 1-1.2-1.4 5 5 0 0 1-.6-1.7 4.3 4.3 0 0 1 0-1.7 4 4 0 0 1 2-2.4 4 4 0 0 1 1.5-.6 3.9 3.9 0 0 1 1.5.1zm2.3 5.6a4 4 0 0 0-.2-1.3 7 7 0 0 0-.7-1.4 7.2 7.2 0 0 0-1-1.3 4 4 0 0 0-1-.8 2.4 2.4 0 0 0-1-.2c-.5 0-.8.1-1.2.3-.4.3-.7.6-.9 1a2.6 2.6 0 0 0-.3 1c0 .5.1.9.3 1.3a7.2 7.2 0 0 0 1.5 2.6c.3.4.7.6 1 .8a2.4 2.4 0 0 0 1.2.3c.3 0 .7 0 1.1-.3a2.3 2.3 0 0 0 1.2-2zm10.5-5.7-1.9 1.3-2.3-.9-2-.6-.8.5 1.6 2.1.2.3h.4a1.8 1.8 0 0 0 .3-.1l.4-.3.3.4-3 2-.2-.3a8.6 8.6 0 0 0 .6-.5.5.5 0 0 0 0-.4.7.7 0 0 0 0-.3l-3.6-5a1 1 0 0 0-.2-.2.3.3 0 0 0-.4 0 3 3 0 0 0-.7.3l-.3-.4 3.2-2.2a4.6 4.6 0 0 1 .9-.5 2.7 2.7 0 0 1 .9-.2l.8.1a2.2 2.2 0 0 1 1.1 1.4v.8a2.5 2.5 0 0 1-.2.7 4.9 4.9 0 0 1-.5.8l1.6.5 1.6.5a2.5 2.5 0 0 0 1.2.1h.4a2.6 2.6 0 0 0 .4-.3l.2.4zm-6.2-3.3c-.3-.4-.6-.6-1-.7-.4-.1-.9 0-1.3.3l-.8.6 2 3 .7-.5c.4-.3.7-.7.8-1.2 0-.5 0-1-.4-1.5zm13.2-2 .7 2.4-6.6 2.4-.2-.4a4.3 4.3 0 0 0 .8-.4.6.6 0 0 0 .2-.3.7.7 0 0 0 0-.4l-2.2-5.6a1 1 0 0 0-.1-.3l-.4-.1h-.4a2.2 2.2 0 0 0-.5 0l-.1-.3 6.1-2.3.7 1.9-.4.1a2.7 2.7 0 0 0-.8-.7l-.9-.3a4.3 4.3 0 0 0-.4.2l-.6.2-1.2.4 1.1 3.1 1-.3c.2 0 .4-.2.5-.3a.9.9 0 0 0 .3-.4v-1.1l.4-.1 1.1 3-.4.2a3.2 3.2 0 0 0-.3-.5 1.5 1.5 0 0 0-.4-.3.9.9 0 0 0-.5-.2c-.2 0-.4 0-.6.2l-.9.3.9 2.4.2.5a.5.5 0 0 0 .3.3h.5l.7-.3.5-.2a3.9 3.9 0 0 0 1-.4l.2-.3.2-1v-1l.5-.1m7.1-5.8c.4.3.8.7 1 1.3.3.5.5 1 .6 1.7a4.9 4.9 0 0 1 0 1.8 4.1 4.1 0 0 1-.8 1.5 3.9 3.9 0 0 1-2.7 1.6 3.9 3.9 0 0 1-3-.9 4.1 4.1 0 0 1-1-1.2 4.9 4.9 0 0 1-.6-1.7 5 5 0 0 1 0-1.9l.8-1.5a4 4 0 0 1 2.7-1.5 4 4 0 0 1 1.6 0l1.4.8zm-.1 6c.2-.4.3-.8.3-1.3v-1.5a7 7 0 0 0-.4-1.5 3.9 3.9 0 0 0-.7-1.2 2.4 2.4 0 0 0-.9-.7 2.3 2.3 0 0 0-1.1-.1c-.5 0-1 .2-1.2.5-.3.2-.6.6-.7 1a4 4 0 0 0-.3 1.2 7 7 0 0 0 .4 3l.7 1.1c.2.4.5.6.9.7.3.2.7.2 1.2.2a2.3 2.3 0 0 0 1-.5 2.4 2.4 0 0 0 .8-1z"
    />
    <path
      fill="none"
      stroke="#000"
      d="M366 205.1v53c0 10.6-1.4 52.6-46.5 69-45.3-16.4-46.7-58.4-46.7-69v-53H366"
    />
  </svg>
)

export default BzFlag
