// This file is generated by @lib/ui/country/codegen/generateFlags.ts
import { SvgIconProps } from '@lib/ui/icons/SvgIconProps'

const AdFlag = (props: SvgIconProps) => (
  <svg
    width="1em"
    height="0.75em"
    xmlns="http://www.w3.org/2000/svg"
    xmlnsXlink="http://www.w3.org/1999/xlink"
    id="flag-icons-ad"
    viewBox="0 0 640 480"
    {...props}
  >
    <path fill="#d0103a" d="M0 0h640v480H0z" />
    <path fill="#fedf00" d="M0 0h435.2v480H0z" />
    <path fill="#0018a8" d="M0 0h204.8v480H0z" />
    <path
      fill="#c7b37f"
      d="M300.4 136.6c7.7 0 10.9 6.6 18.6 6.6 4.7 0 7.5-1.5 11.7-3.9 2.9-1.6 4.7-2.5 8-2.5 3.4 0 5.5 1 7.3 4 1 1.6 1.8 4.9 1.3 6.7a40 40 0 0 1-2.7 8.3c-.7 1.6-1.3 2.5-1.3 4.2 0 4.1 5.6 5.5 9.4 5.6.8 0 7.7 0 12-4.2-2.3-.1-4.9-2-4.9-4.3 0-2.6 1.8-4.3 4.3-5.1.5-.1 1.3.3 1.7 0 .7-.3.4-1 1-1.4 1.2-1 2-1.6 3.6-1.6 1 0 1.6.1 2.5.7.4.4.6.8 1 .8 1.2 0 1.8-.8 3-.8a5 5 0 0 1 2.3.6c.6.3.6 1.5 1.4 1.5.4 0 2.4-.9 3.5-.9 2.2 0 3.4.8 4.8 2.5.4.5.6 1.4 1 1.4a6.2 6.2 0 0 1 4.8 3c.3.4.7 1.4 1.1 1.5.6.3 1 .2 1.7.7a6 6 0 0 1 2.8 4.8c0 .7-.3 1.6-.5 2.2-1.8 6.5-6.3 8.6-10.8 14.3-2 2.4-3.5 4.3-3.5 7.4 0 .7 1 2.1 1.3 2.7-.2-1.4.5-3.2 2-3.3a4 4 0 0 1 4 3.6 4.5 4.5 0 0 1-.3 1.8 9.6 9.6 0 0 1 4-1.4h1.9c3.3 0 7 1.9 9.3 3.8a21 21 0 0 1 7.3 16.8c-.8 5.2-.3 14.8-13.8 18.6 2.5 1 4.2 3 4.2 5.2a4.5 4.5 0 0 1-4.4 4.7 4.4 4.4 0 0 1-3.5-1.4c-2.8 2.8-3.3 5.7-3.3 9.7 0 2.4.4 3.8 1.4 6 1 2.2 1.8 3.5 3.7 5.1 1-1.5 2.1-2.6 4-2.6 1.7 0 3.2.6 3.9 2.2.2.5 0 .9.3 1.4.3.6.8.7 1.1 1.3.5 1 0 1.8.5 2.7.3.7.9.8 1.2 1.4.4 1 .5 1.6.5 2.7 0 3-2.7 5.2-5.7 5.2-1 0-1.4-.4-2.3-.3 1.7 1.7 3 2.5 4.3 4.5a17.7 17.7 0 0 1 3 10.3 22 22 0 0 1-2.8 11.2 20 20 0 0 1-7 8.5 35 35 0 0 1-16 6.4 74.4 74.4 0 0 1-11 1.4l-14.1.8c-7.2.4-12.2 1.5-17.3 6.6 2.4 1.7 4 3.5 4 6.4 0 3-1.8 5.3-4.7 6.2-.7.2-1.2 0-1.9.4s-.7 1.3-1.4 1.7a6.2 6.2 0 0 1-3.8 1 8 8 0 0 1-6.4-2.5c-2.2 1.8-3 3.4-5.5 4.9-.8.4-1.2 1-2.1 1-1.5 0-2.2-1-3.4-1.8a23 23 0 0 1-4.4-4c-2.3 1.3-3.6 2.4-6.3 2.4a7 7 0 0 1-4-1c-.6-.5-.8-1.2-1.5-1.6-.7-.5-1.3-.3-2.1-.7-3-1.3-5-3.5-5-6.8 0-2.9 1.8-4.7 4.4-6-5-5-10-5.8-17-6.2l-14-.8c-4.4-.3-6.8-.7-11-1.4-3.3-.5-5.2-.7-8.2-2.1-10.2-4.8-16.8-11.3-18-22.5-.2-1-.2-1.5-.2-2.5 0-5.8 2.3-9.4 6.4-13.5-1-.3-1.7 0-2.8-.3-2.5-1-4.4-2.7-4.4-5.5 0-1 0-1.7.5-2.6.4-.6 1-.7 1.2-1.4.2-1 0-1.6.4-2.5.3-.5.8-.6 1-1.2 1-1.9 2-3.4 4.1-3.4 1.8 0 3 1 3.8 2.5 1.8-.8 2.2-2.1 3.2-3.7a15.5 15.5 0 0 0 1.4-13.3c-.4-1.5-.6-2.5-1.8-3.7-1 1-2 1.4-3.4 1.4-2.9 0-5-2.5-5-5.3a4.8 4.8 0 0 1 3-4.6c-1.6-1.4-3-1.5-4.7-2.6-2.6-1.6-3.5-3.4-5.2-6-1.2-1.6-1.5-2.8-2-4.7a19 19 0 0 1-1-7.8c.6-5 1.5-8 4.6-11.9 1.8-2.3 3-3.7 5.8-4.9 2.3-1 3.7-1.7 6.2-1.7l2 .1a6.9 6.9 0 0 1 2.8.8c.4.2 1.1.9 1.1.4s-.3-.8-.3-1.3c0-2 1.5-4 3.6-4 1.5 0 2.1 1.4 2.9 2.7.4-.8.7-1.4.7-2.3 0-3.4-1.9-5.2-4-7.9-4.7-5.8-10.5-8.5-10.5-16 0-2.2 1-3.7 3-4.9.5-.3 1.3 0 1.8-.3s.4-1 .7-1.4c.5-.7 1-1 1.6-1.6 1-1 2-.6 3.1-1.5.6-.4.8-1 1.2-1.4 1.3-1.6 2.5-2.4 4.6-2.4 1 0 1.6 0 2.5.4l1 .5c.3-.2.8-.8 1.5-1.1a4 4 0 0 1 2.2-.6c1.1 0 1.8.6 3 .6.3 0 .4-.4.8-.6 1-.7 1.5-1 2.7-1 1.2 0 1.8.3 2.8 1 1 .5 1 1.3 2 1.8.5.3 1 .2 1.5.4 2.6.9 4.5 2.6 4.5 5.3 0 1.5-.3 2.5-1.4 3.5-.9.7-1.7.6-2.8 1a16 16 0 0 0 11.3 3.5c4.2 0 9.3-1.7 9.3-5.9 0-2-1-3-1.8-4.8a18.8 18.8 0 0 1-2.1-8.5c0-2.8.3-4.5 1.9-6.7 1.6-2.3 3.6-2.9 6.5-2.9z"
    />
    <g fill="none" stroke="#703d29">
      <path
        strokeLinejoin="round"
        strokeWidth={0.7}
        d="M272.4 159a3.6 3.6 0 0 0 2.4 2.4c.8.3 2.7.2 3.8-1.4 1-1.2 1-2.8.6-4a4.7 4.7 0 0 0-1.7-2.2l-5.1 5.2z"
      />
      <path
        strokeLinecap="round"
        strokeWidth={0.7}
        d="M401 236.1c-1.2-2.9-4.3-1.6-4.4 0-.5 3.7 2.7 4.8 5 4.2a4 4 0 0 0 2.5-2c.6-1 .8-2.4.4-3.7a4.9 4.9 0 0 0-.8-1.6 5 5 0 0 0-1.3-1.2c-.9-.6-1.9-.6-3.4-.6-5.5 0-10.4 6.5-12 13.4-.6 2.2-1.3 7.3-.3 12a22.4 22.4 0 0 0 5.9 11.3 25.7 25.7 0 0 0 9.9 5.8 7.9 7.9 0 0 0 4 .1c3.2-.7 4.7-3.8 3-7-1.3-2.5-5.3-4-7.2-.6-.1.3-.4.9-.4 1.5 0 .9.4 2 1 2.4 1.5.9 3.8.6 3.7-2"
      />
      <path
        strokeWidth={0.8}
        d="M383.8 274a11.3 11.3 0 0 1 6.6-3.7c3-.4 5.6.5 8.2 2a18.5 18.5 0 0 1 10.8 17c0 3.6-1 7.5-2 9.4-.8 1.7-3 9-15.3 14-7.1 3-18 3.6-25.7 4-10.4.3-20 .7-25.5 7.6"
      />
      <g strokeWidth={0.7}>
        <path d="M386.4 285.7c-.3-1 0-2.1.8-3.3 1.2-1.6 3.7-2.1 6-1a7.4 7.4 0 0 1 2.5 2.2l1.1 1.6c.7 1.1 1 2 1 2.5 2.5 7-1.4 14.5-6.5 17.6-4 2.4-8.7 3.4-14.4 4-2.5.4-4 .3-6.5.5h-9.6a70.1 70.1 0 0 0-7.2 0c-2.9.3-5 .4-7.6.8-1.6.2-3.4.5-5.4 1-.6 0-1.2.2-1.8.4l-1.2.3c-3.6 1.1-7 2.4-9.8 4.2-.8.5-1.8 1-2.5 1.7l-1.3 1.2c-2 2-3.9 4-4.4 6.7v1.6c0 1.8 1.4 4.3 5.4 5m5.5-170c.8 1.4 1.3 2.3.8 3.9-.6 1.7-1.8 2.8-3.6 2.8-4 0-6.3-4.8-4.5-7.8 3.2-5.3 9.3-2.3 15 .3-.3-1.3-.8-1.8-.7-3.5.1-4.2 3.2-6 4.5-10 .7-2.3 1-4.3-.7-6-1.5-1.3-3.2-1.3-5.1-.6-3.8 1.5-8.5 5.9-16.6 6-8.2-.1-12.8-4.5-16.7-6-2-.7-3.6-.7-5.1.7-1.7 1.6-1.4 3.6-.7 6 1.3 3.8 4.4 5.7 4.5 10 0 1.6-.4 2-.7 3.4 5.7-2.6 12-5.9 15-.3 1.7 3.2-.5 7.7-4.5 7.7-1.8 0-3-1-3.6-2.7-.4-1.5 0-2.8.8-4" />
        <path
          strokeLinecap="round"
          d="M314.6 159.9a5.3 5.3 0 0 1 2.4 5c-.2 2.5-.8 3.1-2.8 4.5m2.4-3.8c-.1 1.5-.7 2.5-2.3 3.1"
        />
      </g>
      <path
        fill="#c7b37f"
        stroke="none"
        d="m276.7 153.3.7.5.8.8.5 1 .2.8v1.9l-.2.8-.5.6-.6.6-.9.5-1 .2-1 .2-1-.5-.9-.6-.5-.8-.4-1v-.4l4.8-4.6z"
      />
      <path
        strokeLinecap="round"
        strokeWidth={0.7}
        d="M275.2 157.2c-.3-1.7-2.2-2-3-1-1.1 1.5-.3 4 2 4.7a4 4 0 0 0 3.9-1.4c1-1.3.9-2.8.5-4a4.5 4.5 0 0 0-1.7-2.2c-2.7-2-7.1-1.6-8.6 2-1.8 4.4 2.2 7.8 6 10.3 4.6 3.2 10 3.8 14 3.8 9.2-.1 16.2-4.5 20.7-7 1-.6 2.1-.5 2.7.2a2 2 0 0 1-.3 2.7"
      />
      <path
        strokeWidth={0.7}
        d="m248 281.2-2 .7-2 1.6-1 1.3-1.1 2-.5 1.5-.4 1.8-.2 1.4m19-10.1-.1 1.8-.3 1.2-1 2.2-1.3 1.8-1.5 1.2-1.1.5-1.6.4"
      />
      <path strokeWidth={0.8} d="M319.7 329.1c-.3 1.7-1.9 3.6-5.3 4.2l-.6.2" />
      <path
        strokeWidth={0.9}
        d="M404.2 276.2a18.3 18.3 0 0 1 5.6 13.5c0 3.6-1 7.5-2 9.4-.8 1.7-3 9-15.3 14a85 85 0 0 1-25.6 4c-10.3.3-19.8.7-25.4 7.3"
      />
      <path
        strokeWidth={0.6}
        d="M387.5 282.9c.8-1 3.5-2.4 5.8-1.1a6.2 6.2 0 0 1 2.3 2"
      />
      <path
        strokeWidth={0.9}
        d="m401.6 273.8 1.4.5a7 7 0 0 0 4 0c2.8-.8 4.6-3.4 3.2-6.9a6 6 0 0 0-1.8-2.1"
      />
      <path
        strokeLinecap="round"
        strokeWidth={0.7}
        d="M240.3 199.8c-2 1.1-3.3 1.4-4.8 3.1a28.1 28.1 0 0 0-2.6 6.8m46-51.7c0 1.8-1.2 2.8-3 3.2"
      />
      <path
        strokeWidth={0.6}
        d="M397.1 192a19 19 0 0 1 18.6 19.8c0 16-9.9 18.5-13.8 19.6"
      />
      <path
        strokeWidth={0.7}
        d="M398.4 192c8.1-.3 16.5 5.7 16.9 20.7.3 11.7-8 17-12 18"
      />
      <path
        strokeWidth={0.6}
        d="m393.8 248.4.1-1.6.6-2.5.7-2 .9-1.6 1-1.3m7.8-3.4v1.5l-.5 1-.7 1.1-.8.6-1.2.5h-1.1l-.8-.1m-14.3-52.8.3-1.7.8-1.6 1-1.5 1.6-2.2 1.4-1.4 2-2.2 2-1.9 1.1-1.3 1.5-1.9 1.4-2 .8-1.7.5-2.2.1-2.7-.2-.8m-12.3 128.2 1.6-.4 1.2-.6.7-.7.5-.8.3-1.2v-.9m-158.2-12.1h2.7l1.6-.6m5-36.5-.2 1.4-.4.6-.4.6-.7.5-.7.3-1 .1h-.6m9.9-15.5-.3 2.1-.5 1-.8 1.2-1.2.9-1.2.6-2.3.5m15.3-39.7-.5 1.3-.5 1-.8 1-1 1-1.2.5-1.1.3-.6-.1m.3-6.2v1"
      />
      <g strokeWidth={0.6}>
        <path
          strokeLinecap="round"
          d="M254.3 224a6.9 6.9 0 0 1-2.1 1.4m150.5 44.8.5.2c1.4.8 4.2-.2 3.4-2.4"
        />
        <path d="M397.8 239.6c1 1.3 2.9 1.7 4.4 1.3a4 4 0 0 0 2.5-2c.6-1 .8-2.4.4-3.7a4.9 4.9 0 0 0-.9-1.6 6.8 6.8 0 0 0-1.3-1.5l-.4-.2m6.4 34a4 4 0 0 0 .1-.7 4 4 0 0 0-1.3-3l-.8-.8m.4.5c0-1.8-1.5-3.2-3.4-3.5m-4.2 2.8-1.3-1a15.7 15.7 0 0 1-4.3-10.7c0-4.2 1.6-8.4 3.6-10M341.2 324l1.8-1.6 1.2-1 2.3-1.4 2.2-1 1.6-.5 3-.6 3.6-.6m-29.5 19.4a17 17 0 0 1-7.6 6.1 17.7 17.7 0 0 1-7.6-6.1" />
        <path strokeLinecap="round" d="M314.4 332.6a10 10 0 0 1-2.2 4.2" />
        <path d="m314.7 330.5-.4 2.2M312 337l-1 1-1.7.9-2 .6m-5.6-177.8c.3-.8.5-1.4.5-2.6-.1-4.2-3.2-6.1-4.5-10-.7-2.3-1-4.3.7-6 1.4-1.4 3.2-1.4 5-.6 4 1.5 8.6 5.8 16.7 6-8.1-.2-12.8-4.5-16.6-6-2-.8-3.8-1-5.3.5-1.7 1.6-1.2 3.8-.5 6.1 1.3 3.9 4.2 5.8 4.3 10 0 1.2-.3 1.8-.5 2.6M320 148c8-.4 14.9-5.8 17.1-6.3 2-.4 3-.2 4.5 1.1-1.4-1.3-3-1.2-5-.5-3.8 1.5-8.4 5.8-16.6 6m79.6 112.9a15.5 15.5 0 0 1-6.2-12.4c0-4.1 1.7-8.4 3.6-10m-70 97.6c-1.3 2-4.3 5-7.6 6.2a17.7 17.7 0 0 1-7.6-6.2" />
        <path
          strokeLinecap="round"
          d="m306.7 163.7 2.3-1.3c1-.6 2.3-.5 2.9.2.6.7.7 2-.2 2.8"
        />
        <path d="M294.7 169.3c5.5-1.2 10-3.6 13.4-5.5M340.3 328c.5.3.8 1 .8 1 .1.2.3.5.3.8.3 1.5-.7 2.4-2 2.6-1.7.2-3-.8-3.5-2M294.4 169c5.5-1.1 10-3.6 13.4-5.5m97.6 106.9c-1 .4-1.6.3-3-.2l-1.8-1a20.7 20.7 0 0 1-8.4-9 18.8 18.8 0 0 1-1.7-4.6 12 12 0 0 1-.5-3.3 25.6 25.6 0 0 1 4.7-15.3c1.1-1.6 2.1-2.5 4.2-2.6m-143.7-39.3a7.1 7.1 0 0 1 2.7 5.7c0 3.1-2.6 8.2-9 10a8.3 8.3 0 0 1-6.3-.8" />
        <path d="M256.3 205.6c1.1.8 1.6 1.7 1.6 3.3 0 1-.7 2.4-1.9 3.7a12.4 12.4 0 0 1-8.8 4c-2 0-4-.4-6-1.7a9 9 0 0 1-3.8-5.4" />
        <path d="M256.2 212.3c1.3 1.2 1.7 2.7 1.7 4.6 0 2.7-1.1 4.8-3.7 7-.6.6-1.2 1-2 1.5m129.5-22.1v3.5m-.3-4.4v5m.3-15.8v6.6m-.3-8v8.9m-1.9 82a18.7 18.7 0 0 1-4.2 5.6 19.6 19.6 0 0 1-5.8 4.1 24.6 24.6 0 0 1-6.6 2.2 33 33 0 0 1-6.8.9c-2.5 0-3.9 0-6.4-.2-2.6-.2-4-.6-6.7-.8-2.2-.2-3.4-.4-5.6-.3a28.3 28.3 0 0 0-11 1.8c-2.6 1-5.7 3-6.3 3.8a22 22 0 0 0-6.4-3.8 22 22 0 0 0-5.1-1.4c-2.3-.4-3.5-.4-5.8-.4-2.2 0-3.4.1-5.6.3-2.6.3-4 .6-6.7.8-2.5.2-3.9.3-6.4.2a33 33 0 0 1-13.4-3 19.5 19.5 0 0 1-6.4-4.8m42.1 53.4 1.8-.2m30.3-2.4 1.8-.1 1.7-.7 1.2-.8 1.7-2 .3-.6.3-1.7v-.8m47-136.7c.7-2.6-.2-5.4-2.8-5.3m-132 46.5a8.2 8.2 0 0 1-3.5 4.7m3.6-46.7a6.5 6.5 0 0 1-3.6 4c-1.9.8-4 0-5.2-.8" />
        <path
          strokeLinecap="round"
          d="M243.8 202.4c1.5.8 3.1-.4 2.8-2.4a2.9 2.9 0 0 0-2.5-2.2"
        />
        <path d="M250.2 286.6c.3.3.4.7.8.8.7.2 1.2.4 1.9-.5.8-1.1.3-2.8-.5-3.9a5 5 0 0 0-5.8-1c-.8.5-1.7 1-2.6 2.2l-1.1 1.6c-.7 1.1-1 2-1.1 2.4-2 5.9.4 12 4.1 15.7" />
        <path
          strokeLinecap="round"
          d="m340.2 327.8.7.8.2.9c.3 1.5-.7 2.4-2 2.6-1.6.2-2.8-.8-3.3-2"
        />
        <path d="M389.4 154.8a7.4 7.4 0 0 1 6.3 7c0 4.4-1.5 6-3.8 9.2-2.5 3.4-10.7 9.6-10.7 16.7 0 4.3 1.2 7 4.3 8.4 2 1 4.3 0 5.4-1 2.6-2.4 1.5-6.5-1.2-7-3.2-.6-3.9 4.6-.7 4.3m17.9 69a3.7 3.7 0 0 0-3.6-3 3.7 3.7 0 0 0-3.7 3.7c0 1 .4 2 1 2.6" />
        <path d="M383.9 195.1a7.1 7.1 0 0 0-2.7 5.7c0 3.1 2.6 8.2 9 10 2.4.7 4.8.6 6.2-.3m-156-10.3a9.4 9.4 0 0 0-4.8 3.5 16.9 16.9 0 0 0-2.2 12.7 15.8 15.8 0 0 0 2.3 5.6 8 8 0 0 0 1 1.2l1.2 1m64 92c4.9 2.1 8.4 3.7 11.4 8.5a10 10 0 0 1 1.2 4.9c0 2.7-1 5.7-3.3 7.6a8.3 8.3 0 0 1-6.7 2c-1.9-.2-3.7-1.6-4-2.6M254 224.1c2.7 2.2 3.9 4.2 3.9 7.5a8.4 8.4 0 0 1-4 7.5" />
        <path
          strokeLinecap="round"
          d="M251.5 236.4c4 5.1 6.3 8.1 6.4 14.1.1 5.7-1.7 9.6-5 13.7"
        />
        <path d="M329.8 169.3a4.1 4.1 0 0 0 1.5-2.2c.5-1.5.5-2.8-.2-4 1 1.4 1 2.5.7 4-.1 1-.8 1.5-1.6 2.3m51.5 86.1v16.2l-.1 2.5a34.4 34.4 0 0 1-.3 1.7" />
        <path d="M381.4 254v19.9l-.5 2.6m.5-43v14.6m.3-13.4v11.8m0-26.8v8.8m-.3-9.9v11m.3-19v3.5m-.3-4.2v5m-1.8 65.2-.4.7a18.7 18.7 0 0 1-4.1 5.7 19.6 19.6 0 0 1-5.9 4 24.6 24.6 0 0 1-6.5 2.2c-2.7.6-4.2.8-6.9.9-2.5 0-3.9 0-6.3-.2-2.7-.2-4.1-.5-6.8-.8-2.2-.2-3.4-.3-5.6-.3-2.2 0-3.5 0-5.7.4a22 22 0 0 0-5.2 1.4c-2.7 1.1-5.7 3-6.4 3.8-.6-.8-3.7-2.7-6.3-3.8a22 22 0 0 0-5.2-1.4c-2.2-.4-3.5-.4-5.8-.4-2.2 0-3.4.1-5.6.3-2.6.3-4 .6-6.7.8-2.5.2-3.9.3-6.3.2a33 33 0 0 1-13.5-3 19.5 19.5 0 0 1-5.8-4.1 22 22 0 0 1-2.5-2.8m-2-3.2a10.1 10.1 0 0 1-2.3 7.7c-.8.9-2.6 2.6-5 2.6-3.7 0-4.8-2.5-5-3.2" />
        <path d="M255.6 278.9c.7.7 1.3 1.5 1.9 2.5 1 1.8.6 4.8-.1 6.2a4.4 4.4 0 0 1-.3.4m-20.3 18c2.3 2.4 5.7 5 10.9 7.1 7.1 3 18.1 3.6 25.7 4 10 .3 19.3.7 25 7m17.3-4a12 12 0 0 1 4 5.5m-7.3 11.5a8.2 8.2 0 0 1-.7.7 8.3 8.3 0 0 1-6.6 2c-2-.2-3.8-1.6-4.3-2.6m-5.4-2.9.3.4a7.6 7.6 0 0 0 5.1 2.4m27 0a18 18 0 0 1-7.7 6.1 17.7 17.7 0 0 1-7.6-6.1l-.3-.5m15.6.4.7.7a8.3 8.3 0 0 0 6.7 2 5.5 5.5 0 0 0 4-2.5l.5-.7" />
        <path d="m339 336.6-.7 1.2-1.1 1-1.7.7h-1.6" />
        <path d="M343 325.3a7.7 7.7 0 0 1 2.4 2.9c.3.7.4 1.5.5 2.3a5.8 5.8 0 0 1-1.5 4.2 7.5 7.5 0 0 1-5.4 2.4 5.5 5.5 0 0 1-.4 0m.2-.2a6.8 6.8 0 0 1-5.2-2.2m63.7-67.9a23.8 23.8 0 0 1-4.8-6.4 18.8 18.8 0 0 1-1.7-4.5 12 12 0 0 1-.5-3.3 26 26 0 0 1 4.6-15.3c.7-.8 1.4-1.8 2.1-2.2m-1.3-75.9c2.5.2 4.8 3 4.8 5.7 0 3.8-1.3 5.5-4.4 9.3-2.6 3.2-10.6 9-10.3 14.5 0 1 .5 2 1.1 2.8m-3.2 3.5a7 7 0 0 0 2 1.4 5 5 0 0 0 4.3-.3M369 153a6 6 0 0 1 2.2 2.6c1.8 4.5-2.2 7.9-6 10.4a21.3 21.3 0 0 1-8.3 3.3" />
        <path d="M364.6 161.6a4.2 4.2 0 0 1-3.1-1.5 3.4 3.4 0 0 1-.7-1m-15 4.9a4.6 4.6 0 0 1-1.2-1c-1-1-1.5-2.3-.8-4.4.6-1.9 3.7-7.2 3.8-10.9.2-5.6-2-9-5.3-10.2" />
        <path
          strokeLinecap="round"
          d="m347.3 146.5-.1 2-.6 2.2-1 3-1 1.9-.8 1.9-.4 1.3-.2 1 .1.9m38 126.3.6.8c.7 1 3.2 3 5.5 3 3.7 0 4.6-2.6 4.7-3.2.5-2.9-.5-3.6-2-4.5 0 0-.8-.4-1.9-.2"
        />
        <path d="M237 274.4a6.9 6.9 0 0 1-3.7 0c-2.9-.9-5.2-3.6-4-7m13.4-31.8c.3.3.4.7.4 1 .4 3.8-2.8 4.8-5 4.2a5.6 5.6 0 0 1-3-2.3 4.7 4.7 0 0 1-.7-2.3m22-23.6c.6.5 1 1 1.3 1.7m-1.1-8.5c.5.4.9.9 1.1 1.3" />
        <path
          strokeLinecap="round"
          d="M257.9 210.5a8.5 8.5 0 0 1-1.6 2.4 12.4 12.4 0 0 1-8.8 4c-2 0-4-.4-6-1.7a9.5 9.5 0 0 1-4-5.6"
        />
        <path d="M255.4 195.3a7.8 7.8 0 0 1 2.4 3.4" />
        <path
          strokeLinecap="round"
          d="M257.8 203.2c-.9 3-3.5 6.6-8.6 7.9-2.4.6-5.6-.2-6.6-1"
        />
        <path d="M240 202.6c.3 2.6 2 4.6 5.4 4.6 4.7.1 7.6-6.7 3.4-11.5" />
        <path
          strokeLinecap="round"
          d="M229.4 225.5c.7.9 1.5 1.7 2.4 2.4a16.8 16.8 0 0 0 6 3.3m5.2.5c4.2-.5 6.6-3.7 6-7.3-.3-2.8-2.8-5-4.6-5.1"
        />
        <path d="M249.8 188.1c1.9 0 3 1.6 2.9 3" />
        <path
          strokeLinecap="round"
          d="M249.4 163a11.5 11.5 0 0 0 5 5.9m144.2 31c1.7 2.3.6 7-4 7a5.2 5.2 0 0 1-4.5-2.5"
        />
        <path d="M381.7 169.1V185" />
        <path
          strokeLinecap="round"
          d="M243.8 202.3c1.4 1 3.3-.7 2.5-2.6-.5-1.2-2.2-2.6-4.7-.9-2.8 1.9-2 7.8 3.2 7.9 4.7 0 7.6-6.8 3.4-11.6-4-4.6-11.3-3.6-16 .2A21.4 21.4 0 0 0 225 207a22.5 22.5 0 0 0 0 9.2 20.9 20.9 0 0 0 3 7.5l1.3 1.7c.8.8 1 1.2 2 2a15 15 0 0 0 10.4 3.7c4.6-.2 7.3-3.4 6.8-7.3-.4-3.8-4.2-5.7-6.7-3.9-1.7 1.2-2.3 4.9.7 5.8 1.6.5 3.1-1.7 2-3M374 150.9c2.7-1.4 4.8-1.2 6.3 1a9.9 9.9 0 0 1 1.6 7.2 9.2 9.2 0 0 1-3.5 5.8"
        />
        <path
          strokeLinecap="round"
          d="M380.5 152c3.1-2 6.5-1.1 8.3 1.6 1.3 2 1.7 3.6 1.6 6.1a11.2 11.2 0 0 1-5.7 9.2"
        />
        <path d="M395 159.2c2.6.2 4.6 2.5 4.6 5.1 0 3.8-1 5.5-4 9.3-2.7 3.3-10.6 9-10.4 14.6 0 2.1 1.8 4 3.3 4.2" />
        <path
          strokeLinecap="round"
          d="M395.4 202.3c-1.5 1-3.3-.6-2.5-2.4.5-1.2 2.2-2.8 4.7-1.1 2.7 1.9 2 7.8-3.3 7.9-4.7 0-8-6.6-3.4-11.6 4-4.6 11.7-3.7 16.5.1 2 1.6 6.1 6 7 12 1 7 .9 15.6-6.4 21-3 2.1-7 3.1-10.6 3-4.6-.2-7.3-3.5-6.8-7.4.5-3.8 4-5.4 6.7-3.9 2.8 1.5 2.3 5.4-.7 5.8-1.7.2-3.1-1.7-2-3"
        />
        <path d="M392.9 199.9c.8-3.5 3.7-3.8 6.2-3.8 6.5.1 11.1 8 11.2 15.5 0 9.5-4 15.2-11 15.5-1.9 0-5-.8-5-3" />
        <path
          strokeLinecap="square"
          d="M397 198.3c6.9 1.6 9.3 7.8 9.3 13.8 0 4.9-.5 11.6-10 13.9"
        />
        <path d="M408.4 265.3a3.9 3.9 0 1 0-6.3 2.4" />
        <path
          strokeLinecap="round"
          d="M394.4 259.4c1.4 2 3 4.1 6.3 6m-1.3 10.5c-3.2-2.2-9.5-5-15-2.2a7.6 7.6 0 0 0-4.4 4.4 10 10 0 0 0 1.8 9.5c.9 1 2.7 2.6 5 2.7 3.8 0 4.7-2.6 4.8-3.2.4-2.8-1.2-3.9-2-4.1-.7-.3-2.8-.2-3.2 1.3-.2.5-.2 1.3.2 2"
        />
        <path
          strokeLinecap="round"
          d="M340.5 328.4c1 2.2-.2 3.2-1.6 3.4-2.2.3-3.3-1.4-3.4-3a4.4 4.4 0 0 1 4.3-4.7c2.3 0 4.1 1.5 5 3.5.3.7.5 1.5.5 2.4a5.8 5.8 0 0 1-1.4 4.1 7.5 7.5 0 0 1-5.4 2.5c-4.2.1-7.5-3.8-7.5-7.8 0-7.7 11.4-12 16-13a84 84 0 0 1 17.9-2.4c3.5-.1 6.2 0 10.1-.5 3.5-.3 5.4-.5 9-1.3a27.2 27.2 0 0 0 12.6-6.4c2.9-2.7 4.5-4.5 5.9-8.2a17 17 0 0 0-1.3-13.9 14.3 14.3 0 0 0-10.3-6.8c-3.7-.5-7 1.1-9 4.8-1 1.8-.6 4.8.1 6.2a6 6 0 0 0 4.8 3c3.8 0 4.7-2.6 4.8-3.2.4-2.8-1.2-3.9-2-4.2-.7-.2-2.8-.1-3.2 1.4-.2.5-.2 1.3.2 2"
        />
        <path
          strokeLinecap="round"
          d="M337.2 316.2c-4.8 2.1-8.4 3.7-11.4 8.5a9.9 9.9 0 0 0-1.2 4.9c0 2.7 1.1 5.7 3.3 7.6a8.3 8.3 0 0 0 6.7 2c2-.2 3.7-1.6 4-2.6"
        />
        <path d="M385.1 224.1c-2.3.8-3.9 4.2-3.9 7.5a8.4 8.4 0 0 0 4 7.5" />
        <path
          strokeLinecap="round"
          d="M387.6 236.4c-4 5.1-6.3 8.1-6.4 14.1 0 5.7 1.7 9.6 5.1 13.7"
        />
        <path d="m365.9 152 .3-.5c1.7-2.4 4.7-3.1 6.9-1.5 2.6 2 3.3 5.4 2.6 9-.5 2.2-2 4.1-4 5.5" />
        <path
          strokeLinecap="round"
          d="M265.1 150.8c-2.6-1.2-4.7-1-6.3 1a8.7 8.7 0 0 0-1.6 7.2c.6 2.7 1.4 3.8 3.5 5.8"
        />
        <path d="M258.6 152a5.8 5.8 0 0 0-8.3 1.6 9.1 9.1 0 0 0-1.6 6.1c.2 4.2 2.8 7.6 5.8 9.2" />
        <path d="M249.7 154.8a6.8 6.8 0 0 0-6 6.6c0 4.5 1 6.3 3.5 9.6 2.5 3.4 10.7 9.6 10.7 16.7 0 4.3-1.2 7-4.3 8.4-2 1-4.3 0-5.4-1-2.6-2.4-1.5-6.5 1.2-7 3.3-.6 3.9 4.6.7 4.3" />
        <path d="M244 159.2c-2.5.2-5 2.3-5 5 0 3.8 1.5 5.6 4.6 9.4 2.6 3.3 10.1 9 9.9 14.5 0 2-1.5 4.6-2.9 4.3" />
        <path
          strokeLinecap="round"
          d="M238 236.1c1.3-2.9 4.4-1.6 4.6 0 .4 3.7-2.8 4.8-5.1 4.2a4 4 0 0 1-2.5-2 4.8 4.8 0 0 1-.4-3.7 4.9 4.9 0 0 1 .9-1.6 5 5 0 0 1 1.2-1.2c1-.6 1.9-.6 3.4-.6 5.5 0 10.4 6.5 12 13.4.6 2.2 1.3 7.3.3 12a22.4 22.4 0 0 1-5.8 11.3 25.8 25.8 0 0 1-10 5.8 7 7 0 0 1-3.9.1c-2.8-.9-4.6-3.5-3.2-7 1.2-2.6 5.4-4 7.3-.6.2.3.4.9.4 1.5 0 .9-.4 2-1 2.4-1.4.9-3.7.6-3.6-2"
        />
        <path d="M233.8 270.4c1 .4 1.6.3 2.9-.2l1.8-1c2.6-1.5 5.6-3.8 8.4-9.1a18.8 18.8 0 0 0 1.7-4.5c.3-1 .5-2.2.6-3.3a25.6 25.6 0 0 0-4.8-15.3c-1.1-1.6-2-2.5-4.2-2.6m-9.5 31a3.9 3.9 0 1 1 6.3 2.3" />
        <path d="M232.2 261.4a3.7 3.7 0 0 1 3.7-3 3.7 3.7 0 0 1 3.6 3.7 3.8 3.8 0 0 1-1 2.6" />
        <path d="M239.4 261.3a15.5 15.5 0 0 0 6.2-12.4c0-4.1-1.6-8.4-3.6-10" />
        <path strokeLinecap="round" d="M244.7 259.4a16.5 16.5 0 0 1-6.3 6" />
        <path d="M254.6 273.7c-1-2.2-2.8-3.2-5.8-3.5-3-.3-5.5.5-8.2 1.9a18.6 18.6 0 0 0-10.8 17 25 25 0 0 0 2 9.5c.9 1.6 3 9 15.3 14a86.1 86.1 0 0 0 25.7 3.9c10.4.4 20 .8 25.6 7.6" />
        <path
          strokeLinecap="round"
          d="M239.7 275.9c3.3-2.2 9.5-5 15.1-2.2a8 8 0 0 1 4.3 4.4 10 10 0 0 1-1.8 9.5c-.9 1-2.7 2.6-5 2.7-3.8 0-4.7-2.6-4.8-3.2-.4-2.8 1.2-3.9 2-4.2.7-.2 2.8-.1 3.2 1.4.2.5.2 1.3-.2 2"
        />
        <path d="M252.7 285.7c.3-1 .2-2.2-.8-3.3a5.1 5.1 0 0 0-6-1c-.7.5-1.6 1-2.4 2.2-.4.4-1 1.1-1.2 1.6-.7 1.1-1 2-1 2.5-2.5 7 1.5 14.4 6.5 17.6 4.4 2.8 8.8 3.6 14.4 4 2.5.3 4 .3 6.5.5h9.6a70.1 70.1 0 0 1 7.2 0c3 .3 5.1.4 7.6.8 1.6.2 3.5.5 5.4 1 .6 0 1.2.2 1.8.4l1.2.3c3.6 1.1 7 2.4 9.8 4.2.8.5 1.8 1 2.5 1.7l1.3 1.2c2 2 4 4 4.4 6.7v1.6c0 1.8-1.4 4.3-5.3 5" />
        <path d="M298.6 328.4c-1 2.2.2 3.2 1.6 3.4 2.2.3 3.3-1.4 3.5-3a4.4 4.4 0 0 0-4.4-4.7 5.5 5.5 0 0 0-5 3.5 6.9 6.9 0 0 0-.5 2.4 5.8 5.8 0 0 0 1.4 4.1 7.5 7.5 0 0 0 5.4 2.5c4.2.1 7.5-3.8 7.5-7.8 0-7.7-11.4-12-16-13a84 84 0 0 0-17.9-2.4c-3.5-.1-6.2 0-10.1-.5-3.5-.3-5.4-.5-9-1.3a27.2 27.2 0 0 1-12.5-6.4 17 17 0 0 1-4.7-22 14.3 14.3 0 0 1 10.3-6.9c3.8-.5 7 1.1 9 4.8 1 1.8.6 4.8-.1 6.2a6 6 0 0 1-4.8 3c-3.8 0-4.7-2.6-4.8-3.2-.4-2.8 1.2-3.9 2-4.2.7-.2 2.8-.1 3.2 1.4.2.5.2 1.3-.2 2" />
        <path
          strokeLinecap="round"
          d="m273.3 152-.4-.5c-1.7-2.4-4.7-3.1-6.9-1.5-2.6 2-3.3 5.4-2.5 9a9 9 0 0 0 4 5.5"
        />
        <path d="M366.8 159.6c-4 4.4-8.1 5.8-14.1 6-2 0-5.5-.6-7.6-2.1-1.3-1-2.8-2.6-1.9-5.5.6-1.9 3.7-7.2 3.8-10.9.3-5.6-1.9-8.7-5.3-9.9-6.2-2.2-13 4-17 5.4-2.1.7-3.2.8-5.1.8-2 0-3-.1-5.2-.8-4-1.4-10.7-7.6-17-5.4-3.4 1.2-5.5 4.3-5.3 10 .1 3.6 3.2 9 3.8 10.8 1 2.9-.5 4.5-1.9 5.5-2 1.5-5.7 2.1-7.5 2-6-.1-10.1-1.5-14.1-5.9" />
        <path
          strokeLinecap="round"
          d="M297.3 314.4c.8.3.2-.2 5.3 2a22 22 0 0 1 11.3 8.9 10.5 10.5 0 0 1 .9 7.3"
        />
        <path d="M297.7 336a8 8 0 0 0 3.2.9c4.2.1 7.5-3.8 7.5-7.8 0-2.8-1.5-5.2-3.6-7" />
        <path
          strokeLinecap="round"
          d="M298.6 328.4c-1 2.3.4 3.5 1.8 3.7 2.2.2 3.4-1.4 3.6-3a4.5 4.5 0 0 0-2.2-4.2"
        />
        <path d="M390.1 154.8c3.2 0 6 3.6 6 7.2 0 4.3-2.2 6.9-3.9 8.8-1.3 1.6-2.7 3-4.4 4.7" />
        <path
          strokeLinecap="round"
          d="M386.3 151.4a9 9 0 0 1 2.8 2.4c1.3 2 1.7 3.7 1.6 6.2-.2 4.2-3.2 7.1-6 9m-4.7-17.6.6.7c1.9 2.2 2 5.4 1.6 7.2a8.2 8.2 0 0 1-3.8 5.4m-5-14.4c2.6 2 3.4 5.4 2.5 9-.6 2.5-2.2 4-4.2 5.2m11.1 41.1c.3 1 .9 1.3 1.5 2a13.5 13.5 0 0 0 6.2 3.5c2.4.7 4.6.2 6.3-.9m-163 54c1.2 0 2.5.9 3.3 2.3.1.2.4.8.4 1.5 0 .9-.4 1.8-1 2.2-1.5 1-4 .5-4-2"
        />
        <path d="M241.5 231.3c5 1 9.7 6.9 11.2 13.3.6 2.3 1.3 7.3.3 12a22.4 22.4 0 0 1-6 11.4 16.5 16.5 0 0 1-2.1 1.9l-1 .7m-8-12.1c2 0 3.8 1.9 3.8 4a3.8 3.8 0 0 1-1 2.6" />
        <path d="M234.6 260.7c2.1 0 4.1 2 4.1 4.2a3.9 3.9 0 0 1-1.4 3" />
        <path
          strokeLinecap="round"
          d="M254 239.5a18 18 0 0 1 3.8 7.7m0 8.5a17.3 17.3 0 0 1-1.5 4 17.8 17.8 0 0 1-3.6 4.7"
        />
        <path d="M254.3 224.3c1.8 1.5 3 3 3.5 4.8" />
        <path
          strokeLinecap="round"
          d="M257.9 219.5a10 10 0 0 1-3.4 4.6m-9.2-17.2 2.2-.6 1.3-1 .8-1.1.7-1.8.3-1.5"
        />
        <path d="M241 199.3c-.7.2-1.6.4-2.5.8a9 9 0 0 0-3.5 3 17 17 0 0 0-2.2 12.7 15.8 15.8 0 0 0 2.3 5.6l1 1.4c1.4 1.3 2.6 2 4.6 1.7" />
        <path strokeLinecap="round" d="M253 189.8c-.3 1.3-1 2.9-3 2.7" />
        <path d="M245.7 198.5c-2-1.9-6-2.4-10.1.2L234 200a8.8 8.8 0 0 0-1.4 1.6 17.5 17.5 0 0 0-2.4 5c-.7 3-.7 5.6-.6 6.3 0 1 .2 1.9.3 2.7.6 2.8 1.4 4.8 2.3 6.2.9 1.5 3 5 7.7 5.4 1.8.1 4.8-.7 5-3" />
        <path
          strokeLinecap="round"
          d="M363.8 157c.3-1.6 2.3-1.9 3-1 1.2 1.6.4 4.2-2 4.9a4 4 0 0 1-3.8-1.4c-1-1.3-.9-2.8-.5-4 .2-.8.9-1.5 1.7-2.2 2.7-2 7.1-1.6 8.6 2 1.8 4.4-2.2 7.8-6 10.3-4.6 3.2-10 3.8-14 3.7-9.2 0-16.1-4.4-20.7-7-1-.5-2.1-.4-2.7.3a2 2 0 0 0 .3 2.7"
        />
        <path
          strokeLinecap="round"
          d="M365.6 155.5c1 0 1.2.4 1.5.8 1.2 1.5.3 4.1-2 4.9m17.8 51.5c-3.5 3.8-.2 10.3 2.4 11.8.9.7 1.3.3 2 .7"
        />
        <path d="M383.1 205.4c-1.1.8-1.5 1.7-1.6 3.3a5.3 5.3 0 0 0 1.4 4 14 14 0 0 0 9.3 3.7c2 0 4-.4 6-1.7a9 9 0 0 0 3.8-5.4m-20.8 61.8-.2 2.5a18.9 18.9 0 0 1-2 7 18.7 18.7 0 0 1-4.2 5.6 19.6 19.6 0 0 1-5.9 4 24.6 24.6 0 0 1-6.5 2.3 43.8 43.8 0 0 1-13.2.6c-2.7-.2-4.1-.5-6.8-.8-2.2-.1-3.4-.3-5.6-.3a28.3 28.3 0 0 0-10.9 1.9c-2.7 1-5.7 3-6.4 3.8-.6-.9-3.7-2.8-6.3-3.8a22 22 0 0 0-5.2-1.5c-2.2-.4-3.5-.4-5.8-.4-2.2 0-3.4.2-5.6.4-2.6.2-4 .6-6.7.7-2.5.2-3.9.3-6.3.2a33 33 0 0 1-7-.8 24.6 24.6 0 0 1-6.5-2.2 19.6 19.6 0 0 1-5.8-4.1 18.7 18.7 0 0 1-4.2-5.7 19 19 0 0 1-2-6.9c-.2-1-.2-2.5-.2-2.5V169.3h123.2v101.8z" />
      </g>
      <g fill="#c7b37f" stroke="#c7b37f">
        <path
          strokeWidth={0.3}
          d="M248 285.6a2.5 2.5 0 1 1 5 0 2.5 2.5 0 0 1-5 0zM232.5 268c0-1.3.8-2.3 1.8-2.3s1.7 1 1.7 2.3c0 1.2-.8 2.2-1.7 2.2-1 0-1.8-1-1.8-2.2z"
        />
        <path
          stroke="none"
          d="M241.3 223.6c0-1 .8-1.8 1.7-1.8 1 0 1.7.8 1.7 1.8s-.7 1.8-1.7 1.8-1.7-.8-1.7-1.8zM272 158c0-1 .5-2 1.4-2 .9-.1 1.7.6 1.8 1.6 0 1-.5 2-1.4 2-.9.1-1.6-.6-1.8-1.6z"
        />
      </g>
      <g stroke="#c7b37f" strokeLinecap="round" strokeWidth={0.6}>
        <path d="M239.3 234c-.4.1-.6.2-.8.5-.3.3-.4.4-.6.9l-.2 1.2m4.7 26.7 1-1 .6-1 .5-1 .7-1.3m-1.3 14-1.5.7-1.1.6a17.4 17.4 0 0 0-1.3.8l-1.2 1m15-37.9-.8-.8-1-.8-.9-.8" />
        <path strokeLinecap="butt" d="m254.2 225-1.2.5a5.1 5.1 0 0 1-1.5.3" />
        <path d="M237.4 208.4c.2.6.2 1 .5 1.5.2.7.5 1.1.9 1.7a8.3 8.3 0 0 0 2.6 2.7l1.5.8m-1-5.8 1.3.6a7.4 7.4 0 0 0 3 .6l1.8-.1m7.2-40.7-2-1.2c-.9-.5-1.3-.9-2-1.5a9.3 9.3 0 0 1-1.1-1.3l-.8-1.3m7.5-4.6.6 1.7a7.8 7.8 0 0 0 1.4 2c1 1 1.7 1.3 2.8 2.2m1.4-6c.3.7.3 1 .7 1.6.2.5.4.8.8 1.2l1.3 1.3c.7.6 1.2.7 2 1.1" />
      </g>
      <path
        fill="#703d29"
        strokeWidth={0.2}
        d="M333.3 151.6c0-1.7-1.7-1.8-2.4-1.8-1.8 0-2.3 1.1-4.6 2.3a11.9 11.9 0 0 1-6.7 2 12 12 0 0 1-6.7-2c-2.3-1.2-2.7-2.3-4.6-2.3a2.3 2.3 0 0 0-2.2 2.4v.9l.3.2c0-.8.1-1.2.5-1.7a2.2 2.2 0 0 1 1.6-.8c1.8 0 2.5 1.2 4.8 2.4 3 1.6 4.2 1.9 6.7 2a12 12 0 0 0 6.8-2c2.3-1.2 3-2.5 4.8-2.5.6 0 1 .4 1.3 1v.9l.2.1c0-.3.2-.4.2-1z"
      />
    </g>
    <g fill="#703d29">
      <path d="M264.4 294c.5-.5.9-.3 1-.6 0-.2 0-.2-.3-.3l-.9-.2-.8-.4c-.1 0-.4-.2-.5 0-.1.4 1 .4.6 1.4a3.7 3.7 0 0 1-.8 1.2l-2.6 3-.2.1v-4.3l.1-1.8c.2-.4.8 0 .9-.4 0-.1 0-.2-.3-.3-.2 0-.5 0-1.1-.3l-1-.5c-.2 0-.5-.2-.6 0l.1.3c.4.2.5.4.5 1v7.4c0 .5.1.6.2.7.1 0 .2 0 .4-.3l5.3-5.7z" />
      <path d="M267.5 295.2c.3-1.1 1-.4 1-.8.1-.2 0-.2-.2-.3l-1.3-.4c-.4 0-.8-.3-1.2-.4 0 0-.3-.1-.4 0-.1.5 1.1.5.8 1.5l-1.7 5.5c-.3 1-1 .6-1.1 1v.1l1.2.4 1.6.5h.3c.2-.4-1.2-.3-.7-1.7l1.7-5.4zm3.7 1c.2-.6.5-.5.9-.4 1 .3 1.4 1.3 1 2.5-.2.6-.4 1.2-2 .8-.3-.1-.7-.2-.6-.5l.7-2.3zm-2.8 5c-.5 1.4-1.2.8-1.3 1.2 0 .2.2.2.3.3l1.6.4.8.3h.4c.1-.5-1-.3-.7-1.5l.6-2c.1-.4.1-.5.6-.3.6.1.7.3.8.8l.3 2c.2.9.3 1.7 1 2 .5 0 1.2 0 1.4-.4l-.2-.2h-.3s-.3 0-.3-.3l-.7-3.6c0-.2.4-.2.8-.3a2 2 0 0 0 1-1.3c.1-.5.4-2.2-1.8-2.9l-2.1-.5-1.2-.4h-.3c-.1.5 1.1.4.7 1.7l-1.5 5zm8.4 2.5c-.4 1.4-1.4.5-1.5 1 0 .2.1.3.3.3l1.5.3 1.4.4c.3 0 .5.2.6-.1 0-.3-1.3-.3-1-1.8l1.3-5.2c0-.6.2-.6.6-.5l1 .2c1.1.3.5 1.5 1 1.6.2 0 .2-.4.2-.6l.1-1v-.4l-3.3-.7-3.2-.8c-.1 0-.2 0-.2.2l-.5 1.5c-.1.1-.2.4 0 .4.5.1.5-1.5 1.7-1.2l.9.2c.4.1.5.2.4.8l-1.3 5.4zm12.7-3.3c.4-.6.8-.5.9-.7 0-.2-.2-.2-.4-.3h-.9l-.9-.3c-.1 0-.4-.1-.4.1-.1.4 1 .2.8 1.3 0 .2-.1.6-.6 1.3l-2 3.3-.3.2v-.2l-.7-4a5.4 5.4 0 0 1-.1-1.8c0-.5.7-.2.7-.5 0-.2 0-.2-.4-.3l-1.1-.1c-.4 0-.7-.2-1-.3-.2 0-.5-.1-.6.1l.1.2c.5.2.6.4.7.9l1.3 7.3c.1.5.2.7.3.7.1 0 .2 0 .4-.3l4.2-6.6zm.6 6.8c0 .3 0 .3.2.5.6.2 1 .6 1.7.7 1.4.2 2.6-.7 2.8-2.2.3-1.5-.3-2.1-1.4-2.9-1.3-.9-1.8-1.1-1.7-2 .1-.7.7-1 1.4-1 1.8.3 1.6 2.6 1.8 2.6.3 0 .3-.1.3-.4l.2-1.6v-.4h-.6c-.4 0-.7-.5-1.6-.7-1.2-.2-2.3.7-2.5 2-.2 1.2.4 1.8 1.2 2.4 1.6 1.1 2.2 1.4 2 2.4-.1 1-.9 1.4-1.7 1.3-1.2-.2-1.6-1.4-1.8-2.6 0-.2 0-.3-.2-.3s-.2.3-.2.5v1.7zm15.8-4.5c.3-.7.8-.6.8-.9 0-.2-.1-.1-.4-.2h-.9l-.9-.1c-.1 0-.4 0-.4.2 0 .4 1 0 1 1.1 0 .2-.1.6-.5 1.4l-1.8 3.5-.1.3-.1-.3-1.1-4a5.4 5.4 0 0 1-.3-1.6c0-.5.7-.3.7-.6 0-.2 0-.2-.4-.2h-1.2l-1-.2c-.2 0-.5-.1-.6.1l.2.2c.4.2.6.3.7.8l2.1 7.1.4.7c.1 0 .2 0 .3-.4l3.5-7z" />
      <path d="M307.6 308.5c0 1.2-1 1-1 1.5 0 .2.1.1.3.1h2.2l.4-.1c0-.6-1.4.2-1.4-2v-4.2l.1-.1.2.1 5.1 6.3.3.1.2-.3v-6.7c0-1.3 1-1 1-1.3 0 0 0-.2-.3-.2h-2.3c-.2 0-.2.1-.2.2 0 .4 1.3.2 1.3 1.3v4l-.1.4-.4-.3-4.2-5.3c-.2-.3-.1-.3-.4-.3h-1.8l-.2.1c0 .6 1.2-.2 1.2 2.1v4.6zM318 303c0-1.1.8-.7.8-1.1 0-.1 0-.2-.4-.2h-2.6s-.3 0-.3.2c0 .4 1.1 0 1.1 1.2v5.7c0 1.1-.8.8-.8 1.2 0 0 0 .2.2.2h2.8c.2 0 .3 0 .3-.2 0-.4-1.2.2-1.2-1.3l.1-5.7zm4.5 5.5c0 1.5-1.2 1-1.2 1.4 0 .2.2.2.4.2h3c.3 0 .5 0 .5-.3s-1.4 0-1.4-1.4V303c0-.6 0-.6.5-.6h1c1.2-.1.8 1.2 1.3 1.2.2 0 .1-.4.1-.6l-.1-1c0-.2 0-.4-.2-.4l-3.3.1h-3.3l-.2.3-.1 1.6.1.4c.5 0 .2-1.6 1.4-1.6h.9c.4 0 .5 0 .6.6v5.6zm6.3-2.2h-.4l.1-.5.7-2.2v-.2l.2.1 1 2.1.2.4c0 .2-.2.2-.4.2h-1.4zm1.8.5c.3 0 .3 0 .8 1l.2.8c0 .7-.7.6-.7 1 0 .1.2.1.4 0h1.2l1.3-.1c.3 0 .4 0 .4-.2 0-.4-.6 0-1-.7l-3.4-7-.3-.4c-.2 0-.2.2-.3.4L327 309c-.2.7-.8.7-.7 1h2.3c.2-.1.5 0 .5-.3s-1.2 0-1.3-.9l.2-1c.2-.8.4-.8.6-.8l2.1-.2zm8.3-5c-.1-.8 0-.8 1.2-1 2-.2 1.4 1.3 2 1.2.2 0 0-.4 0-.6l-.1-1.1c0-.1-.1-.2-.3-.2-1 0-1.7.2-2.4.3l-2.8.4c-.2 0-.3 0-.3.2.1.5 1.3 0 1.4 1l.7 5.5c.2 1.5-.7 1-.6 1.5 0 0 0 .1.2 0l1.4-.1 1.2-.1c.3 0 .5 0 .5-.3s-1.2.1-1.4-1.2l-.2-1.7c-.1-.7-.1-.9.3-1h.8c1.1-.2 1 1.1 1.3 1 .3 0 .2-.4.1-.5l-.3-2.1c0-.3-.2-.3-.2-.3-.3 0-.1 1.1-1 1.2l-.7.1c-.5.1-.5 0-.6-.5l-.2-1.7zm4 2.8c.4 2.3 2.1 3.7 4.2 3.3 3.4-.7 3.5-3.6 3.2-5.3-.5-2.5-2.3-3.7-4.4-3.3-2.5.5-3.5 2.7-3 5.3zm1.1-1c-.3-1.6 0-3.4 1.7-3.7 1.4-.3 3 .8 3.4 3.4.3 2 0 3.6-1.8 4-1.9.4-3-2-3.3-3.6zm8.3-4.1c-.1-.7.2-.8.6-.9 1-.2 1.8.5 2.1 1.6.2.7.3 1.4-1.3 1.8-.3 0-.7.1-.8-.2l-.5-2.3zm0 5.7c.4 1.4-.5 1.3-.5 1.6.1.3.3.2.4.1.6 0 1-.3 1.6-.4l1-.2c.2 0 .2-.1.2-.2 0-.4-1 .3-1.3-1l-.5-2c0-.4-.2-.4.4-.5.5-.2.7-.1 1.1.3l1.3 1.6c.5.6 1 1.3 1.8 1.1.5-.1 1-.5 1-.9l-.2-.1-.3.1s-.3.1-.4 0l-2.4-2.9.5-.6c.2-.4.4-.9.2-1.6-.1-.5-.7-2.1-3-1.6l-2.1.6-1.2.2c-.2 0-.3.1-.2.2 0 .5 1.1-.2 1.4 1l1.2 5.2zm8.7-2c.3 1.4-1 1.2-.9 1.6 0 .3.3.2.5.2l1.4-.5 1.5-.3c.3 0 .5 0 .4-.4 0-.3-1.3.4-1.7-1l-1.3-5.3c-.2-.5 0-.6.3-.7l1-.2c1.1-.4 1.1 1 1.5.9.3 0 0-.5 0-.7l-.4-1s0-.3-.2-.2l-3.2.9-3.2.7v.3l.1 1.6c0 .2 0 .4.3.4.5-.1-.3-1.6 1-1.9l.8-.2c.4-.1.6 0 .7.5l1.4 5.3zm5.5-7.3c-.3-1 .6-.9.4-1.3h-.3l-1.4.4-1.2.3s-.3 0-.3.2c.1.4 1.2-.2 1.5.8l1.6 5.6c.2 1-.6 1-.5 1.3 0 .1 0 .2.2.1l1.1-.3 1.6-.4c.3 0 .3-.1.3-.3-.1-.3-1.1.5-1.5-.9l-1.5-5.5zm2.3 2.7c.7 2.3 2.6 3.4 4.7 2.7 3.2-1.1 3-4.1 2.4-5.7-.8-2.4-2.8-3.3-4.8-2.7-2.4.9-3.2 3.2-2.3 5.7zm1-1c-.6-1.7-.6-3.5 1.1-4 1.3-.5 3 .4 3.9 2.9.6 1.8.5 3.6-1.2 4.2-1.8.6-3.2-1.5-3.8-3.2zm7.6-5.5c-.2-.7 0-.8.4-1 1-.3 2 .3 2.4 1.4.2.6.4 1.3-1.1 1.9-.3 0-.7.2-.8 0l-.9-2.3zm.8 5.6c.6 1.4-.4 1.4-.2 1.7 0 .3.2.1.4.1l1.5-.7.9-.2c.2-.1.2-.2.2-.3-.2-.4-1 .4-1.4-.8l-.8-1.9c-.2-.4-.2-.5.3-.7.5-.2.7-.1 1.1.3l1.6 1.4c.5.5 1.1 1.1 2 .8.3-.2.9-.7.7-1l-.2-.1-.2.2h-.5l-2.8-2.5.4-.7a2 2 0 0 0 0-1.6c-.1-.6-1-2-3.1-1.2l-2 .9-1.2.4-.2.2c.2.4 1.1-.4 1.6.8l2 5z" />
    </g>
    <g fill="#fedf00" transform="matrix(.64 0 0 .64 0 16)">
      <path fill="#d52b1e" d="M412.7 249.3h82.1v82h-82.1z" />
      <path
        id="ad-a"
        fill="#fff"
        d="M451.2 313.8s0 3-.8 5.3c-1 2.7-1 2.7-1.9 4a13.2 13.2 0 0 1-3.8 4c-2 1.2-4 1.8-6 1.6-5.4-.4-8-6.4-9.2-11.2-1.3-5.1-5-8-7.5-6-1.4 1-1.4 2.8-.3 4.6a9 9 0 0 0 4.1 2.8l-2.9 3.7s-6.3-.8-7.5-7.4c-.5-2.5.7-7.1 4.9-8.5 5.3-1.8 8.6 2 10.3 5.2 2.2 4.4 3.2 12.4 9.4 11.2 3.4-.7 5-5.6 5-7.9l2.4-2.6 3.7 1.2h.1z"
      />
      <use xlinkHref="#ad-a" transform="matrix(-1 0 0 1 907.5 0)" />
      <path d="m461.1 279 10.8-11.7s1.6-1.3 1.6-3.4l-2.2.4-.5-1.2-.1-1.1 3-.7V260l.3-1.3-3.2.2.3-1.4.5-1 1.9-.4h1.9c1.8-3.4 9.2-6.4 14.4-1 3.8 4 3 11.2-2 13.2a6.3 6.3 0 0 1-6.8-1.1l2-4c2.7 1.7 5-.3 4.8-2.4-.2-2.7-2-4.3-4.3-4.5-2.3-.2-4 1-5 3-.6 1.3-.3 2.2-.5 3.6-.2 1.5 0 2.3-.5 3.8a8.8 8.8 0 0 1-2.4 3.6l-11 12-43 46.4-3.2-3 43.2-46.7z" />
      <path
        fill="#fff"
        d="M429.5 283s2.7 13.4 11.9 33.5c4.7-1.7 7.4-2.8 12.4-2.8 4.9 0 7.6 1 12.3 2.8A171 171 0 0 0 478 283l-24.2-31-24.4 31z"
      />
      <path d="m456.1 262.4 16.8 21.7s-2.2 10.5-9 26.3c-2.7-.6-5-1.1-7.8-1.3v-46.7zm-4.7 0-16.8 21.7s2.2 10.5 9 26.3c2.7-.6 5-1.1 7.8-1.3v-46.7z" />
    </g>
    <g fill="#d52b1e">
      <path fill="#fedf00" d="M322.3 175.5h52.6V228h-52.6z" />
      <path d="M329.7 175.5h7.8V228h-7.8zm15 0h7.8V228h-7.8zm15 0h7.9V228h-7.9z" />
    </g>
    <g fill="#d52b1e" stroke="#d52b1e" strokeWidth={0.5}>
      <path
        fill="#fedf00"
        stroke="none"
        d="M264.3 273.5c.1 1 .5 2.6 1.4 4.3 1 1.5.6 1.4 2.7 3.8a15.3 15.3 0 0 0 4 2.9 32.7 32.7 0 0 0 15 2.6c2.7-.1 4.8-.4 6.6-.7a71 71 0 0 1 11-.6c1.5 0 3 .3 4.7.6 3.5.7 7 2 7 2v-54.7h-52.6V271l.2 2.4z"
      />
      <path
        strokeWidth={0.3}
        d="m270.4 283.1 2.5 1.5 3.4 1.2v-52.2h-5.9zm29.2 2.4v-51.9h-5.8v52.8l5.8-.7zm11.7-51.9h-5.8v52.1c1.9.2 3.8.6 5.8 1v-53zm-23.4 0V287s-3.8.2-5.8 0v-53.4z"
      />
    </g>
    <g transform="matrix(.64 0 0 .64 0 16)">
      <path
        fill="#fedf00"
        d="M585.5 402.4a20.8 20.8 0 0 1-2.2 6.6c-1.5 2.3-1 2.3-4.3 6a26.3 26.3 0 0 1-13 7 51.8 51.8 0 0 1-16.6 1.6c-4.3-.2-7.5-.7-10.3-1-3.8-.6-6.7-.9-11-1a62.9 62.9 0 0 0-6.2 0 83.3 83.3 0 0 0-18.3 4.2V340h82.2v58.5l-.3 3.8z"
      />
      <g id="ad-b">
        <path
          fill="#d52b1e"
          d="m524.6 347-.6.2-.8.8c-.4.4-.7.5-1.2.8l-.6.5c-.3.3 0 .6-.3 1-.1.4-.3.6-.6 1-.4.4-.7.5-1 1l-1.2 1-.3.1h-.6c-.4.2-.5.6-.8.8l.3.6.8 1.4c.2.3.2.7.5.8.5.2.9.2 1.3.1.8.2 1.3.2 2 .5l1.5.8c.5.3.8.4 1.3.5h1.8v.3l2 1a1.7 1.7 0 0 0-.1.4c-.1.3-.2.7-.1.8.6 1.9 1.2 3 1.5 3.2.6.2.8.9 1.1 1.5l-.3.3c-.6.6-1.2 1-1.7 1.8-.7 1.2-1.2 1.2-.3 2.8l1.5 2.4c.4.7.6 1.2.8 2 .2.7.3 1.2.3 2l1 .3.7-.6.6-1.2v-1c-.2-.1-.3-.4-.2-.7 0-.4.5-.3.7-.6.3-.5-.4-.8-.7-1.1-.6-.7-1.4-.9-1.6-1.9 0-.2 0-.4.4-.7l2-1.8c.2.1.6.2 1 .1l1.3.4c.6.2.9 0 1.2 0h.4l.1.6c.1 1-.1 3 .2 3.5l.3.6.2.6v2l-.2 1.7c0 .4-.2.7-.5 1-.2.4-.6.4-1 .7v1l1.1.5 1.3.3.7-.3.1-.6.5-.5c.4-.2.8 0 .9-.1.2-.3 0-.4 0-.8 0-.6-.2-1-.3-1.6a11.8 11.8 0 0 1-.1-2.8c0-.6 0-1 .2-1.5.1-1 .4-1.4.6-2.2.3-1 .3-1.6.4-2.5a24.4 24.4 0 0 0 10.1-.6c.8.7 1.7 1.2 2.7 1.6v1c0 .3 0 .4.2.7l.3.3c.3 0 .5 0 .7-.2.2-.2.2-.4.2-.7v-.7h1.8v1.1c.1.3.3.4.5.4a.7.7 0 0 0 .6 0c.3-.2.2-.6.3-1v-.7l1-.4a5.1 5.1 0 0 1 0 .9l-.3.9c-.2.6-.5.8-.8 1.4-.4.6-.5 1-1 1.5l-.6.7-.6.9-.9 1c-.7.6-1.2.2-2 .9l-.3 1 1.4.6 1.3.2.4-.2c0-.3 0-.6.3-.8.2-.3.4-.3.7-.4.4 0 .8 0 1-.2.4-.3.4-1 .7-1.5a12.7 12.7 0 0 1 3-3.9l1.7-1.4c.2-.4.5-.5.5-1l-.2-.6-.2-1c1.5.7 1 .7 1.2 1.4.3.6 0 1 .1 1.7.1.8.5 1.1.5 1.9.1.9-.1 1.4-.3 2.3-.1.8-.1 1.3-.5 2a3.8 3.8 0 0 1-1.1 1.5l-.6.5-.1 1 1.1.4 1.6.4.4-.3c.2-.7 0-1.7.4-1.7.4-.1.7 0 .8-.3v-.7l.7-4.5.4-1.9.4-1.7c.7-2-.2-2.3-1-3.6-.5-.7-.7-1-.7-1.5V362a42.7 42.7 0 0 1 0-2.8l.4-.2c1.2-.7 1.7-.9 2.4-2.5a3.4 3.4 0 0 0 .3-1.5v-1l-.4-1a3.2 3.2 0 0 0-.6-.8c-.7-1-1.7-1.1-2.7-1.5-1.5-.5-2.5-.4-4-.5-1.8-.2-2.7-.2-4.4 0-2 0-3.1.4-5.1.7l-4.9.4c-2.3 0-4.4-.5-5.8-.4-2.4.2-2.5.8-6.2 1.1a67 67 0 0 1-3.8.2l-2.2-.7c.9-.3 1.1-.5 1.5-1 .3-.4.2-.7.6-1.1l.7-1a2.2 2.2 0 0 0-.9-.4h-1a3 3 0 0 0-1.2.3l-.8.6-2.2-1.2a8.8 8.8 0 0 0-3-.9zm2 11.8z"
        />
        <g fill="none" stroke="#fedf00" strokeLinecap="round">
          <path d="m568.8 359.5-.8.3c-.9.4-1.6.4-2.6.5-2.6.2-4.3-1.1-7-.9-1.4.1-2 1.2-3.5 1.6a9.3 9.3 0 0 1-1.7.2l.5-1s-1.2.3-2 .3a7.5 7.5 0 0 1-1.6-.2l1-1-1.3-.2a4 4 0 0 1-1-.7 20.5 20.5 0 0 0 1.7-.3c1.5-.4 2-1.2 3.9-1.4 1.1 0 3 0 7.6.8 3 .5 4.4.2 5.5-.3.8-.3 1-1 1.1-1.8.1-.8-.4-1.4-.8-1.8-.1 0-.5-.3-1.1-.4" />
          <path
            fill="#fcd900"
            strokeLinecap="butt"
            strokeWidth={0.5}
            d="M524.8 350.6c-.5 0-.9 0-1.3.3-.5.3-.6.7-1 1.1.5.1.8.4 1.2.3.4 0 .5-.2.8-.5.3-.4.4-.7.4-1.2h-.1z"
          />
          <path d="M536 363.8a13.6 13.6 0 0 0 1 2.3c.2.8 0 1.2.2 2v1.6m6.8-7-.3 1.3-1 3.5v.7m-11-4c.9.2.6 3.3 1.9 4" />
          <path
            strokeLinecap="butt"
            d="m560.1 369.8.4-.3a8.2 8.2 0 0 0 2.7-1.8"
          />
          <path d="M552.4 368c3.5-.9 5.9-2.6 7.6-2.9m-4-1.5h.8c1.5-.3 1.7.6 2.7 1.2 1.9 1 2.1 2.3 4.3 3.4l.4.1.8.4" />
          <path
            fill="#fcd900"
            strokeLinecap="butt"
            strokeWidth={0.5}
            d="M517.7 354.5h.7l.8-.2c.3 0 .5 0 .7.2.2 0 .2.1.3.3 0 .2.2.3.1.5 0 .2-.3.4-.6.4-.2 0-.4 0-.5-.3a.5.5 0 0 1 0-.4 1 1 0 0 1-.9 0 1 1 0 0 1-.6-.5z"
          />
        </g>
        <path
          fill="#0065bd"
          d="m525.1 364.2-2-.9c.4-.2.7-.2 1-.5.3-.4.3-.8.5-1.3s.2-1 .7-1.4c.3-.2.8-.2 1.1-.1.4 0 .8.4.9.7 0 .6-.2 1-.3 1.5 0 .6-.3.9-.2 1.4 0 .4.2.6.4 1l-2-.4zm-1 1a.6.6 0 1 1 .7.5.6.6 0 0 1-.7-.6zm-1.7-16.6h-.2c-.4-.4-.4-.8-.6-1.2a4 4 0 0 1-.3-1.2v-2c0-.3 0-.6-.2-.9 0-.2-.4-.3-.3-.4 0-.1.3 0 .4 0 .4 0 .6.1 1 .4.3.3.5.6.6 1l.4 1.5.3.8.5.6-.7.8-.9.6zm3.6 10.6 2.2 1a9.2 9.2 0 0 0 3.5-3.8c.9-1.8 1-2.7 1.4-4.4l-1.8-.5h-.4c-.5 1.8-.7 2.7-1.6 4.2-.8 1.3-1.7 2.3-2.6 3l-.7.5zm5 18.2.8-1.3 1.4-1.1h.4a8.7 8.7 0 0 1-.5 2.8l-.4 1-.5.5c-.5-.8-1.3-1.3-1.3-2zm33 1.8 1.4.6 1.5.9v.5l-1.5.2a8.4 8.4 0 0 1-1.3 0h-1l-.6-.4c.5-.7.8-1.6 1.4-1.8zm-9.8-2 1.4.5 1.5 1c0 .1.1.3 0 .4a9 9 0 0 1-2.7.3l-1-.1-.7-.3c.6-.7.9-1.7 1.5-1.8zm-17.4 2.1 1.5.5 1.5 1v.5a9 9 0 0 1-2.8.2h-1l-.6-.4c.5-.7.8-1.6 1.4-1.8zm-9-29.8c-.6-.3-1-1-.6-1.6.1-.2.4-.2.6-.4.2-.3.1-.5 0-.8l-.1-1-.2-1c0-.6 0-1 .4-1.6.2-.3.7-.6.8-.6.2.1 0 .5 0 .8 0 .5.1.7.3 1.2l.7 1.3c.2.6.4.8.4 1.4 0 .5 0 .7-.2 1.2a2 2 0 0 1-.6.8 2 2 0 0 1-.8.4 1.1 1.1 0 0 1-.6 0z"
        />
      </g>
      <use xlinkHref="#ad-b" y={36.6} />
    </g>
    <path
      fill="none"
      stroke="#703d29"
      strokeWidth={0.5}
      d="M264.1 175.5h52.6V228h-52.6zm58.2 0h52.6V228h-52.6zm-58 98c.1 1 .5 2.6 1.4 4.3 1 1.5.6 1.4 2.7 3.8a15.3 15.3 0 0 0 4 2.9 32.7 32.7 0 0 0 15 2.6c2.7-.1 4.8-.4 6.6-.7a71 71 0 0 1 11-.6c1.5 0 3 .3 4.7.6 3.5.7 7 2 7 2v-54.7h-52.6V271l.2 2.4zm110.4 0a13 13 0 0 1-1.4 4.3c-1 1.5-.6 1.4-2.7 3.8a15.4 15.4 0 0 1-4 2.9c-1.3.7-2.3 1-4.4 1.6a32.6 32.6 0 0 1-10.6 1c-2.7-.1-4.8-.5-6.5-.7a71 71 0 0 0-7.2-.6 40.5 40.5 0 0 0-3.9 0c-1.5 0-3 .3-4.7.6-3.5.7-7 2-7 2v-54.8H375v37.5l-.2 2.4z"
    />
  </svg>
)

export default AdFlag
