import { formatCode } from './formatCode'
import { createFile } from './createFile'

interface CreateTsFileParams {
  extension?: 'ts' | 'tsx'
  directory: string
  fileName: string
  generatedBy?: string
  content: string
}

export const createTsFile = async ({
  extension = 'ts',
  directory,
  fileName,
  generatedBy,
  content,
}: CreateTsFileParams) => {
  const code = await formatCode({
    content: generatedBy
      ? [`// This file is generated by ${generatedBy}`, content].join('\n')
      : content,
    extension,
  })

  createFile({
    directory,
    fileName,
    content: code,
    extension,
  })
}
