import plugin from 'tailwindcss/plugin';

export const palettesArray = [
    'trust'
];

export const palette = plugin(
    ({ addBase }) => {
        addBase({
            ':root': {
                '--colors-slate-50': '248 250 252',
                '--colors-slate-100': '241 245 249',
                '--colors-slate-200': '226 232 240',
                '--colors-slate-300': '203 213 225',
                '--colors-slate-400': '148 163 184',
                '--colors-slate-500': '100 116 139',
                '--colors-slate-600': '71 85 105',
                '--colors-slate-700': '51 65 85',
                '--colors-slate-800': '30 41 59',
                '--colors-slate-900': '15 23 42',
                '--colors-slate-925': '9 14 31',
                '--colors-slate-950': '2 6 23',

                '--colors-graycolor-50': '249 250 251',
                '--colors-graycolor-100': '243 244 246',
                '--colors-graycolor-200': '229 231 235',
                '--colors-graycolor-300': '209 213 219',
                '--colors-graycolor-400': '156 163 175',
                '--colors-graycolor-500': '107 114 128',
                '--colors-graycolor-600': '75 85 99',
                '--colors-graycolor-700': '55 65 81',
                '--colors-graycolor-800': '31 41 55',
                '--colors-graycolor-900': '17 24 39',
                '--colors-graycolor-925': '11 15 28',
                '--colors-graycolor-950': '3 7 18',

                '--colors-zinc-50': '250 250 250',
                '--colors-zinc-100': '244 244 245',
                '--colors-zinc-200': '228 228 231',
                '--colors-zinc-300': '212 212 216',
                '--colors-zinc-400': '161 161 170',
                '--colors-zinc-500': '113 113 122',
                '--colors-zinc-600': '82 82 91',
                '--colors-zinc-700': '63 63 70',
                '--colors-zinc-800': '39 39 42',
                '--colors-zinc-900': '24 24 27',
                '--colors-zinc-925': '16 16 18',
                '--colors-zinc-950': '9 9 11',

                '--colors-neutral-50': '250 250 250',
                '--colors-neutral-100': '245 245 245',
                '--colors-neutral-200': '229 229 229',
                '--colors-neutral-300': '212 212 212',
                '--colors-neutral-400': '163 163 163',
                '--colors-neutral-500': '115 115 115',
                '--colors-neutral-600': '82 82 82',
                '--colors-neutral-700': '64 64 64',
                '--colors-neutral-800': '38 38 38',
                '--colors-neutral-900': '23 23 23',
                '--colors-neutral-925': '17 17 17',
                '--colors-neutral-950': '10 10 10',

                '--colors-stone-50': '250 250 249',
                '--colors-stone-100': '245 245 244',
                '--colors-stone-200': '231 229 228',
                '--colors-stone-300': '214 211 209',
                '--colors-stone-400': '168 162 158',
                '--colors-stone-500': '120 113 108',
                '--colors-stone-600': '87 83 78',
                '--colors-stone-700': '68 64 60',
                '--colors-stone-800': '41 37 36',
                '--colors-stone-900': '28 25 23',
                '--colors-stone-925': '19 18 16',
                '--colors-stone-950': '12 10 9',

                '--colors-greenish-50': '243 248 250',
                '--colors-greenish-100': '238 243 246',
                '--colors-greenish-200': '228 235 238',
                '--colors-greenish-300': '193 208 213',
                '--colors-greenish-400': '153 168 175',
                '--colors-greenish-500': '110 125 132',
                '--colors-greenish-600': '78 93 100',
                '--colors-greenish-700': '56 72 80',
                '--colors-greenish-800': '33 44 52',
                '--colors-greenish-900': '16 22 27',
                '--colors-greenish-925': '11 16 20',
                '--colors-greenish-950': '2 3 4',

                '--colors-indigray-50': '250 250 252',
                '--colors-indigray-100': '245 245 249',
                '--colors-indigray-200': '231 231 240',
                '--colors-indigray-300': '214 214 225',
                '--colors-indigray-400': '168 168 184',
                '--colors-indigray-500': '110 110 129',
                '--colors-indigray-600': '77 77 95',
                '--colors-indigray-700': '58 58 75',
                '--colors-indigray-800': '31 31 49',
                '--colors-indigray-900': '18 18 32',
                '--colors-indigray-925': '9 9 21',
                '--colors-indigray-950': '2 2 13',

                '--colors-cyanish-50': '248 250 252',
                '--colors-cyanish-100': '241 250 255',
                '--colors-cyanish-200': '226 237 245',
                '--colors-cyanish-300': '203 218 230',
                '--colors-cyanish-400': '148 163 184',
                '--colors-cyanish-500': '100 126 149',
                '--colors-cyanish-600': '71 85 105',
                '--colors-cyanish-700': '51 75 95',
                '--colors-cyanish-800': '20 41 59',
                '--colors-cyanish-900': '5 23 42',
                '--colors-cyanish-925': '2 14 28',
                '--colors-cyanish-950': '0 4 20',

                '--colors-red-50': '254 242 242',
                '--colors-red-100': '254 226 226',
                '--colors-red-200': '254 202 202',
                '--colors-red-300': '252 165 165',
                '--colors-red-400': '248 113 113',
                '--colors-red-500': '239 68 68',
                '--colors-red-600': '220 38 38',
                '--colors-red-700': '185 28 28',
                '--colors-red-800': '153 27 27',
                '--colors-red-900': '127 29 29',
                '--colors-red-950': '69 10 10',

                '--colors-orange-50': '255 247 237',
                '--colors-orange-100': '255 237 213',
                '--colors-orange-200': '254 215 170',
                '--colors-orange-300': '253 186 116',
                '--colors-orange-400': '251 146 60',
                '--colors-orange-500': '249 115 22',
                '--colors-orange-600': '234 88 12',
                '--colors-orange-700': '194 65 12',
                '--colors-orange-800': '154 52 18',
                '--colors-orange-900': '124 45 18',
                '--colors-orange-950': '67 20 7',

                '--colors-amber-50': '255 251 235',
                '--colors-amber-100': '254 243 199',
                '--colors-amber-200': '253 230 138',
                '--colors-amber-300': '252 211 77',
                '--colors-amber-400': '251 191 36',
                '--colors-amber-500': '245 158 11',
                '--colors-amber-600': '217 119 6',
                '--colors-amber-700': '180 83 9',
                '--colors-amber-800': '146 64 14',
                '--colors-amber-900': '120 53 15',
                '--colors-amber-950': '69 26 3',

                '--colors-yellow-50': '254 252 232',
                '--colors-yellow-100': '254 249 195',
                '--colors-yellow-200': '254 240 138',
                '--colors-yellow-300': '253 224 71',
                '--colors-yellow-400': '250 204 21',
                '--colors-yellow-500': '234 179 8',
                '--colors-yellow-600': '202 138 4',
                '--colors-yellow-700': '161 98 7',
                '--colors-yellow-800': '133 77 14',
                '--colors-yellow-900': '113 63 18',
                '--colors-yellow-950': '66 32 6',

                '--colors-lime-50': '247 254 231',
                '--colors-lime-100': '236 252 203',
                '--colors-lime-200': '217 249 157',
                '--colors-lime-300': '190 242 100',
                '--colors-lime-400': '163 230 53',
                '--colors-lime-500': '132 204 22',
                '--colors-lime-600': '101 163 13',
                '--colors-lime-700': '77 124 15',
                '--colors-lime-800': '63 98 18',
                '--colors-lime-900': '54 83 20',
                '--colors-lime-950': '26 46 5',

                '--colors-green-50': '240 253 244',
                '--colors-green-100': '220 252 231',
                '--colors-green-200': '187 247 208',
                '--colors-green-300': '134 239 172',
                '--colors-green-400': '74 222 128',
                '--colors-green-500': '34 197 94',
                '--colors-green-600': '22 163 74',
                '--colors-green-700': '21 128 61',
                '--colors-green-800': '22 101 52',
                '--colors-green-900': '20 83 45',
                '--colors-green-950': '5 46 22',

                '--colors-emerald-50': '236 253 245',
                '--colors-emerald-100': '209 250 229',
                '--colors-emerald-200': '167 243 208',
                '--colors-emerald-300': '110 231 183',
                '--colors-emerald-400': '52 211 153',
                '--colors-emerald-500': '16 185 129',
                '--colors-emerald-600': '5 150 105',
                '--colors-emerald-700': '4 120 87',
                '--colors-emerald-800': '6 95 70',
                '--colors-emerald-900': '6 78 59',
                '--colors-emerald-950': '2 44 34',

                '--colors-teal-50': '240 253 250',
                '--colors-teal-100': '204 251 241',
                '--colors-teal-200': '153 246 228',
                '--colors-teal-300': '94 234 212',
                '--colors-teal-400': '45 212 191',
                '--colors-teal-500': '20 184 166',
                '--colors-teal-600': '13 148 136',
                '--colors-teal-700': '15 118 110',
                '--colors-teal-800': '17 94 89',
                '--colors-teal-900': '19 78 74',
                '--colors-teal-950': '4 47 46',

                '--colors-cyan-50': '236 254 255',
                '--colors-cyan-100': '207 250 254',
                '--colors-cyan-200': '165 243 252',
                '--colors-cyan-300': '103 232 249',
                '--colors-cyan-400': '34 211 238',
                '--colors-cyan-500': '6 182 212',
                '--colors-cyan-600': '8 145 178',
                '--colors-cyan-700': '14 116 144',
                '--colors-cyan-800': '21 94 117',
                '--colors-cyan-900': '22 78 99',
                '--colors-cyan-950': '8 51 68',

                '--colors-sky-50': '240 249 255',
                '--colors-sky-100': '224 242 254',
                '--colors-sky-200': '186 230 253',
                '--colors-sky-300': '125 211 252',
                '--colors-sky-400': '56 189 248',
                '--colors-sky-500': '14 165 233',
                '--colors-sky-600': '2 132 199',
                '--colors-sky-700': '3 105 161',
                '--colors-sky-800': '7 89 133',
                '--colors-sky-900': '12 74 110',
                '--colors-sky-950': '8 47 73',

                '--colors-blue-50': '239 246 255',
                '--colors-blue-100': '219 234 254',
                '--colors-blue-200': '191 219 254',
                '--colors-blue-300': '147 197 253',
                '--colors-blue-400': '96 165 250',
                '--colors-blue-500': '59 130 246',
                '--colors-blue-600': '37 99 235',
                '--colors-blue-700': '29 78 216',
                '--colors-blue-800': '30 64 175',
                '--colors-blue-900': '30 58 138',
                '--colors-blue-950': '23 37 84',

                '--colors-indigo-50': '238 242 255',
                '--colors-indigo-100': '224 231 255',
                '--colors-indigo-200': '199 210 254',
                '--colors-indigo-300': '165 180 252',
                '--colors-indigo-400': '129 140 248',
                '--colors-indigo-500': '99 102 241',
                '--colors-indigo-600': '79 70 229',
                '--colors-indigo-700': '67 56 202',
                '--colors-indigo-800': '55 48 163',
                '--colors-indigo-900': '49 46 129',
                '--colors-indigo-950': '30 27 75',

                '--colors-violet-50': '245 243 255',
                '--colors-violet-100': '237 233 254',
                '--colors-violet-200': '221 214 254',
                '--colors-violet-300': '196 181 253',
                '--colors-violet-400': '167 139 250',
                '--colors-violet-500': '139 92 246',
                '--colors-violet-600': '124 58 237',
                '--colors-violet-700': '109 40 217',
                '--colors-violet-800': '91 33 182',
                '--colors-violet-900': '76 29 149',
                '--colors-violet-950': '46 16 101',

                '--colors-purple-50': '250 245 255',
                '--colors-purple-100': '243 232 255',
                '--colors-purple-200': '233 213 255',
                '--colors-purple-300': '216 180 254',
                '--colors-purple-400': '192 132 252',
                '--colors-purple-500': '168 85 247',
                '--colors-purple-600': '147 51 234',
                '--colors-purple-700': '126 34 206',
                '--colors-purple-800': '107 33 168',
                '--colors-purple-900': '88 28 135',
                '--colors-purple-950': '59 7 100',

                '--colors-fuchsia-50': '253 244 255',
                '--colors-fuchsia-100': '250 232 255',
                '--colors-fuchsia-200': '245 208 254',
                '--colors-fuchsia-300': '240 171 252',
                '--colors-fuchsia-400': '232 121 249',
                '--colors-fuchsia-500': '217 70 239',
                '--colors-fuchsia-600': '192 38 211',
                '--colors-fuchsia-700': '162 28 175',
                '--colors-fuchsia-800': '134 25 143',
                '--colors-fuchsia-900': '112 26 117',
                '--colors-fuchsia-950': '74 4 78',

                '--colors-pink-50': '253 242 248',
                '--colors-pink-100': '252 231 243',
                '--colors-pink-200': '251 207 232',
                '--colors-pink-300': '249 168 212',
                '--colors-pink-400': '244 114 182',
                '--colors-pink-500': '236 72 153',
                '--colors-pink-600': '219 39 119',
                '--colors-pink-700': '190 24 93',
                '--colors-pink-800': '157 23 77',
                '--colors-pink-900': '131 24 67',
                '--colors-pink-950': '80 7 36',

                '--colors-rose-50': '255 241 242',
                '--colors-rose-100': '255 228 230',
                '--colors-rose-200': '254 205 211',
                '--colors-rose-300': '253 164 175',
                '--colors-rose-400': '251 113 133',
                '--colors-rose-500': '244 63 94',
                '--colors-rose-600': '225 29 72',
                '--colors-rose-700': '190 18 60',
                '--colors-rose-800': '159 18 57',
                '--colors-rose-900': '136 19 55',
                '--colors-rose-950': '76 5 25'
            },
            '[data-palette="trust"]': {
                '--colors-primary-50': 'var(--colors-blue-50)',
                '--colors-primary-100': 'var(--colors-blue-100)',
                '--colors-primary-200': 'var(--colors-blue-200)',
                '--colors-primary-300': 'var(--colors-blue-300)',
                '--colors-primary-400': 'var(--colors-blue-400)',
                '--colors-primary-500': 'var(--colors-blue-500)',
                '--colors-primary-600': 'var(--colors-blue-600)',
                '--colors-primary-700': 'var(--colors-blue-700)',
                '--colors-primary-800': 'var(--colors-blue-800)',
                '--colors-primary-900': 'var(--colors-blue-900)',
                '--colors-primary-950': 'var(--colors-blue-950)',

                '--colors-secondary-50': 'var(--colors-purple-50)',
                '--colors-secondary-100': 'var(--colors-purple-100)',
                '--colors-secondary-200': 'var(--colors-purple-200)',
                '--colors-secondary-300': 'var(--colors-purple-300)',
                '--colors-secondary-400': 'var(--colors-purple-400)',
                '--colors-secondary-500': 'var(--colors-purple-500)',
                '--colors-secondary-600': 'var(--colors-purple-600)',
                '--colors-secondary-700': 'var(--colors-purple-700)',
                '--colors-secondary-800': 'var(--colors-purple-800)',
                '--colors-secondary-900': 'var(--colors-purple-900)',
                '--colors-secondary-950': 'var(--colors-purple-950)',

                '--colors-accent-50': 'var(--colors-lime-50)',
                '--colors-accent-100': 'var(--colors-lime-100)',
                '--colors-accent-200': 'var(--colors-lime-200)',
                '--colors-accent-300': 'var(--colors-lime-300)',
                '--colors-accent-400': 'var(--colors-lime-400)',
                '--colors-accent-500': 'var(--colors-lime-500)',
                '--colors-accent-600': 'var(--colors-lime-600)',
                '--colors-accent-700': 'var(--colors-lime-700)',
                '--colors-accent-800': 'var(--colors-lime-800)',
                '--colors-accent-900': 'var(--colors-lime-900)',
                '--colors-accent-950': 'var(--colors-lime-950)',

                '--colors-gray-50': 'var(--colors-slate-50)',
                '--colors-gray-100': 'var(--colors-slate-100)',
                '--colors-gray-200': 'var(--colors-slate-200)',
                '--colors-gray-300': 'var(--colors-slate-300)',
                '--colors-gray-400': 'var(--colors-slate-400)',
                '--colors-gray-500': 'var(--colors-slate-500)',
                '--colors-gray-600': 'var(--colors-slate-600)',
                '--colors-gray-700': 'var(--colors-slate-700)',
                '--colors-gray-800': 'var(--colors-slate-800)',
                '--colors-gray-900': 'var(--colors-slate-900)',
                '--colors-gray-925': 'var(--colors-slate-925)',
                '--colors-gray-950': 'var(--colors-slate-950)'
            }
        });
    },
    {
        theme: {
            extend: {
                colors: ({ colors }) => ({
                    primary: {
                        50: 'rgb(var(--colors-primary-50) / <alpha-value>)',
                        100: 'rgb(var(--colors-primary-100) / <alpha-value>)',
                        200: 'rgb(var(--colors-primary-200) / <alpha-value>)',
                        300: 'rgb(var(--colors-primary-300) / <alpha-value>)',
                        400: 'rgb(var(--colors-primary-400) / <alpha-value>)',
                        500: 'rgb(var(--colors-primary-500) / <alpha-value>)',
                        600: 'rgb(var(--colors-primary-600) / <alpha-value>)',
                        700: 'rgb(var(--colors-primary-700) / <alpha-value>)',
                        800: 'rgb(var(--colors-primary-800) / <alpha-value>)',
                        900: 'rgb(var(--colors-primary-900) / <alpha-value>)',
                        950: 'rgb(var(--colors-primary-950) / <alpha-value>)'
                    },
                    secondary: {
                        50: 'rgb(var(--colors-secondary-50) / <alpha-value>)',
                        100: 'rgb(var(--colors-secondary-100) / <alpha-value>)',
                        200: 'rgb(var(--colors-secondary-200) / <alpha-value>)',
                        300: 'rgb(var(--colors-secondary-300) / <alpha-value>)',
                        400: 'rgb(var(--colors-secondary-400) / <alpha-value>)',
                        500: 'rgb(var(--colors-secondary-500) / <alpha-value>)',
                        600: 'rgb(var(--colors-secondary-600) / <alpha-value>)',
                        700: 'rgb(var(--colors-secondary-700) / <alpha-value>)',
                        800: 'rgb(var(--colors-secondary-800) / <alpha-value>)',
                        900: 'rgb(var(--colors-secondary-900) / <alpha-value>)',
                        950: 'rgb(var(--colors-secondary-950) / <alpha-value>)'
                    },
                    accent: {
                        50: 'rgb(var(--colors-accent-50) / <alpha-value>)',
                        100: 'rgb(var(--colors-accent-100) / <alpha-value>)',
                        200: 'rgb(var(--colors-accent-200) / <alpha-value>)',
                        300: 'rgb(var(--colors-accent-300) / <alpha-value>)',
                        400: 'rgb(var(--colors-accent-400) / <alpha-value>)',
                        500: 'rgb(var(--colors-accent-500) / <alpha-value>)',
                        600: 'rgb(var(--colors-accent-600) / <alpha-value>)',
                        700: 'rgb(var(--colors-accent-700) / <alpha-value>)',
                        800: 'rgb(var(--colors-accent-800) / <alpha-value>)',
                        900: 'rgb(var(--colors-accent-900) / <alpha-value>)',
                        950: 'rgb(var(--colors-accent-950) / <alpha-value>)'
                    },
                    gray: {
                        50: 'rgb(var(--colors-gray-50) / <alpha-value>)',
                        100: 'rgb(var(--colors-gray-100) / <alpha-value>)',
                        200: 'rgb(var(--colors-gray-200) / <alpha-value>)',
                        300: 'rgb(var(--colors-gray-300) / <alpha-value>)',
                        400: 'rgb(var(--colors-gray-400) / <alpha-value>)',
                        500: 'rgb(var(--colors-gray-500) / <alpha-value>)',
                        600: 'rgb(var(--colors-gray-600) / <alpha-value>)',
                        700: 'rgb(var(--colors-gray-700) / <alpha-value>)',
                        800: 'rgb(var(--colors-gray-800) / <alpha-value>)',
                        900: 'rgb(var(--colors-gray-900) / <alpha-value>)',
                        925: 'rgb(var(--colors-gray-925) / <alpha-value>)',
                        950: 'rgb(var(--colors-gray-950) / <alpha-value>)'
                    },
                    success: {
                        50: 'rgb(var(--colors-success-50) / <alpha-value>)',
                        100: 'rgb(var(--colors-success-100) / <alpha-value>)',
                        200: 'rgb(var(--colors-success-200) / <alpha-value>)',
                        300: 'rgb(var(--colors-success-300) / <alpha-value>)',
                        400: 'rgb(var(--colors-success-400) / <alpha-value>)',
                        500: 'rgb(var(--colors-success-500) / <alpha-value>)',
                        600: 'rgb(var(--colors-success-600) / <alpha-value>)',
                        700: 'rgb(var(--colors-success-700) / <alpha-value>)',
                        800: 'rgb(var(--colors-success-800) / <alpha-value>)',
                        900: 'rgb(var(--colors-success-900) / <alpha-value>)',
                        950: 'rgb(var(--colors-success-950) / <alpha-value>)'
                    },
                    danger: {
                        50: 'rgb(var(--colors-danger-50) / <alpha-value>)',
                        100: 'rgb(var(--colors-danger-100) / <alpha-value>)',
                        200: 'rgb(var(--colors-danger-200) / <alpha-value>)',
                        300: 'rgb(var(--colors-danger-300) / <alpha-value>)',
                        400: 'rgb(var(--colors-danger-400) / <alpha-value>)',
                        500: 'rgb(var(--colors-danger-500) / <alpha-value>)',
                        600: 'rgb(var(--colors-danger-600) / <alpha-value>)',
                        700: 'rgb(var(--colors-danger-700) / <alpha-value>)',
                        800: 'rgb(var(--colors-danger-800) / <alpha-value>)',
                        900: 'rgb(var(--colors-danger-900) / <alpha-value>)',
                        950: 'rgb(var(--colors-danger-950) / <alpha-value>)'
                    },
                    warning: {
                        50: 'rgb(var(--colors-warning-50) / <alpha-value>)',
                        100: 'rgb(var(--colors-warning-100) / <alpha-value>)',
                        200: 'rgb(var(--colors-warning-200) / <alpha-value>)',
                        300: 'rgb(var(--colors-warning-300) / <alpha-value>)',
                        400: 'rgb(var(--colors-warning-400) / <alpha-value>)',
                        500: 'rgb(var(--colors-warning-500) / <alpha-value>)',
                        600: 'rgb(var(--colors-warning-600) / <alpha-value>)',
                        700: 'rgb(var(--colors-warning-700) / <alpha-value>)',
                        800: 'rgb(var(--colors-warning-800) / <alpha-value>)',
                        900: 'rgb(var(--colors-warning-900) / <alpha-value>)',
                        950: 'rgb(var(--colors-warning-950) / <alpha-value>)'
                    },
                    info: {
                        50: 'rgb(var(--colors-info-50) / <alpha-value>)',
                        100: 'rgb(var(--colors-info-100) / <alpha-value>)',
                        200: 'rgb(var(--colors-info-200) / <alpha-value>)',
                        300: 'rgb(var(--colors-info-300) / <alpha-value>)',
                        400: 'rgb(var(--colors-info-400) / <alpha-value>)',
                        500: 'rgb(var(--colors-info-500) / <alpha-value>)',
                        600: 'rgb(var(--colors-info-600) / <alpha-value>)',
                        700: 'rgb(var(--colors-info-700) / <alpha-value>)',
                        800: 'rgb(var(--colors-info-800) / <alpha-value>)',
                        900: 'rgb(var(--colors-info-900) / <alpha-value>)',
                        950: 'rgb(var(--colors-info-950) / <alpha-value>)'
                    },
                    white: colors.white,
                    black: colors.black,
                    current: colors.current,
                    transparent: colors.transparent
                })
            }
        }
    }
);
