# Algorithms Hacktoberfest 2022

# :star_struck: Hacktoberfest_2022 :star_struck:
![image](https://user-images.githubusercontent.com/30775542/194536427-e22c5081-a29b-4577-9dd5-d9664ec701d4.png)

### This repository aims to help code beginners with their first successful pull request and open source contribution. :partying_face:

:star: Feel free to use this project to make your first contribution to an open-source project on GitHub. Practice making your first pull request to a public repository before doing the real thing!

:star: Make sure to grab some cool swags during Hacktoberfest by getting involved in the open-source community.

### This repository is open to all members of the GitHub community. Any member can contribute to this project! :grin:

:point_right: Repo Link : [https://github.com/radadiyamohit81/Algorithm-Hacktoberfest-2022](https://github.com/radadiyamohit81/Algorithm-Hacktoberfest-2022)

## What is Hacktoberfest? :thinking:
Hacktoberfest — brought to you by [DigitalOcean](https://hacktoberfest.digitalocean.com/) in partnership with [GitHub](https://github.blog/2017-09-27-celebrate-open-source-this-october-with-hacktoberfest/) and [Intel](https://www.intel.in/) — is a month-long celebration of open source software. Maintainers are invited to guide would-be contributors towards resolving issues that will help move the project forward, and contributors get the opportunity to give back to both projects they like, and ones they've just discovered. **No contribution is too small** — bug fixes and documentation updates are valid ways of participating. Celebrated every month of October based on the German festivity Oktoberfest.

Hacktoberfest is *open to everyone* in the global community. Whether you’re a developer, student learning to code, event host, or company of any size, you can help drive growth of open source and make positive contributions to an [ever-growing community](https://github.com/open-source). 

Visit the official website of [Hacktoberfest] (https://hacktoberfest.digitalocean.com/).

## Rules :fire:
To qualify for the __official limited edition Hacktoberfest shirt__, you must register [here](https://hacktoberfest.digitalocean.com/) and make four Pull Requests (PRs) between October 1-31, 2022 (in any time zone). PRs can be made to any public repo on GitHub, not only the ones with issues labeled Hacktoberfest. This year, the __first 50,000__ participants who complete the challenge will earn a T-shirt.

## Choose from these tasks :rainbow:

Here is easy ways to contribute to this project:


## Task : [Algorithm Skills](https://github.com/radadiyamohit81/Algorithm-Hacktoberfest-2022) :rocket:
Help us in making a one-stop place to find necessary codes and articles, which can vary from `Hello World` to `Dynamic Programming` in any language of your choice.  
:star: The file structure will be as follows:

```
<algorithm name>/
├── <implementation file> (With commented sample input/output. In any language including C/Java/Python etc.)
```

:eyes: Upload your contribution here in this folder [Task](https://github.com/radadiyamohit81/Algorithm-Hacktoberfest-2022)

## Make a pull request for your work and wait for it to be merged! :heart:


## Steps to follow :scroll:

### 0. Star The Repo :star2:

Star the repo by pressing the topmost-right button to start your wonderful journey.


### 1. Fork it :fork_and_knife:

You can get your own fork/copy of [HacktoberFest_2022](https://github.com/radadiyamohit81/Algorithm-Hacktoberfest-2022) by using the <a href="https://github.com/radadiyamohit81/Algorithm-Hacktoberfest-2022/new/master?readme=1#fork-destination-box"><kbd><b>Fork</b></kbd></a> button or clicking [this](https://github.com/radadiyamohit81/Algorithm-Hacktoberfest-2022/new/master?readme=1#fork-destination-box) at top-right of your screen.

 [![Fork Button](https://help.github.com/assets/images/help/repository/fork_button.jpg)](https://github.com/radadiyamohit81/Algorithm-Hacktoberfest-2022)


### 2. Clone it :busts_in_silhouette:

`NOTE: commands are to be executed on Linux, Mac, and Windows(using Powershell)`

You need to clone (download) it to local machine using

```sh
$ git clone https://github.com/Your_Username/Algorithm-Hacktoberfest-2022.git
```

> This makes a local copy of the repository in your machine.

Once you have cloned the `Algorithm-Hacktoberfest-2022` repository in Github, move to that folder first using change directory command on Linux, Mac, and Windows(PowerShell to be used).

```sh
# This will change directory to a folder Hacktoberfest_2022
$ cd Algorithm-Hacktoberfest-2022
```

Move to this folder for all other commands.


### 3. Sync it :recycle:

Always keep your local copy of the repository updated with the original repository.
Before making any changes and/or in an appropriate interval, run the following commands *carefully* to update your local repository.

```sh
# Fetch all remote repositories and delete any deleted remote branches
$ git fetch --all --prune

# Switch to `main` branch
$ git checkout main

# Reset local `main` branch to match the `upstream` repository's `main` branch
$ git reset --hard upstream/main

# Push changes to your forked `Algorithm-Hacktoberfest-2022` repo
$ git push origin main
```

### 5. Ready Steady Go... :turtle: :rabbit2:

Once you have completed these steps, you are ready to start contributing by checking our `Good First Issue` Issues and creating [pull requests](https://github.com/radadiyamohit81/Algorithm-Hacktoberfest-2022/pulls).

### 6. Create a new branch :bangbang:

Whenever you are going to contribute. Please create a separate branch using command and keep your `main` branch clean (i.e. synced with remote branch).

```sh
# It will create a new branch with name Branch_Name and switch to branch Folder_Name
$ git checkout -b BranchName
```

Create a separate branch for contribution and try to use the same name of the branch as of folder.

To switch to the desired branch

```sh
# To switch from one folder to other
$ git checkout BranchName
```

To add the changes to the branch. Use

```sh
# To add all files to branch Folder_Name
$ git add .
```

Type in a message relevant for the code reviewer using

```sh
# This message get associated with all files you have changed
$ git commit -m 'relevant message'
```

Now, Push your awesome work to your remote repository using

```sh
# To push your work to your remote repository
$ git push -u origin BranchName
```

Finally, go to your repository in the browser and click on `compare and pull requests`.
Then add a title and description to your pull request that explains your precious effort.

## Awesome contributors :star_struck:
<a href="https://github.com/radadiyamohit81/Algorithm-Hacktoberfest-2022/graphs/contributors">
  <img src="https://contributors-img.web.app/image?repo=radadiyamohit81/Algorithm-Hacktoberfest-2022&max=300" />
</a>

Made with [contributors-img](https://contributors-img.web.app).

## Help Contributing Guides :crown:

We love to have `articles` and `codes` in different languages and the `betterment` of existing ones.

Please discuss it with us first by creating a new issue.

:tada: :confetti_ball: :smiley: _**Happy Contributing**_ :smiley: :confetti_ball: :tada:

