/*
 * Copyright 2021-2022 by Nedim Sabic Sabic
 * https://www.fibratus.io
 * All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package va

import (
	"github.com/stretchr/testify/assert"
	"strconv"
	"testing"
)

func TestAddressRanges(t *testing.T) {
	var tests = []struct {
		addr       Address
		inSysRange bool
	}{
		{0xfffff8036710ad28, true},
		{0x7ffd38e326e4, false},
		{0xfffff803672274e5, true},
	}

	for _, tt := range tests {
		t.Run(strconv.FormatUint(tt.addr.Uint64(), 16), func(t *testing.T) {
			assert.Equal(t, tt.inSysRange, tt.addr.InSystemRange())
		})
	}
}
