// Code generated by 'go generate'; DO NOT EDIT.

package sys

import (
	"syscall"
	"unsafe"

	"golang.org/x/sys/windows"
)

var _ unsafe.Pointer

// Do the interface allocations only once for common
// Errno values.
const (
	errnoERROR_IO_PENDING = 997
)

var (
	errERROR_IO_PENDING error = syscall.Errno(errnoERROR_IO_PENDING)
	errERROR_EINVAL     error = syscall.EINVAL
)

// errnoErr returns common boxed Errno values, to prevent
// allocations at runtime.
func errnoErr(e syscall.Errno) error {
	switch e {
	case 0:
		return errERROR_EINVAL
	case errnoERROR_IO_PENDING:
		return errERROR_IO_PENDING
	}
	// TODO: add more here, after collecting data on the common
	// error values see on Windows. (perhaps when running
	// all.bat?)
	return e
}

var (
	moddbghelp  = windows.NewLazySystemDLL("dbghelp.dll")
	modkernel32 = windows.NewLazySystemDLL("kernel32.dll")
	modntdll    = windows.NewLazySystemDLL("ntdll.dll")
	modpsapi    = windows.NewLazySystemDLL("psapi.dll")
	modshell32  = windows.NewLazySystemDLL("shell32.dll")
	modshlwapi  = windows.NewLazySystemDLL("shlwapi.dll")
	moduser32   = windows.NewLazySystemDLL("user32.dll")
	modwintrust = windows.NewLazySystemDLL("wintrust.dll")
	modwtsapi32 = windows.NewLazySystemDLL("wtsapi32.dll")

	procEnumerateLoadedModulesW64            = moddbghelp.NewProc("EnumerateLoadedModulesW64")
	procSymCleanup                           = moddbghelp.NewProc("SymCleanup")
	procSymFromAddrW                         = moddbghelp.NewProc("SymFromAddrW")
	procSymGetModuleInfoW64                  = moddbghelp.NewProc("SymGetModuleInfoW64")
	procSymInitialize                        = moddbghelp.NewProc("SymInitialize")
	procSymLoadModuleExW                     = moddbghelp.NewProc("SymLoadModuleExW")
	procSymSetOptions                        = moddbghelp.NewProc("SymSetOptions")
	procSymUnloadModule64                    = moddbghelp.NewProc("SymUnloadModule64")
	procCreateThread                         = modkernel32.NewProc("CreateThread")
	procFreeConsole                          = modkernel32.NewProc("FreeConsole")
	procGetPackageId                         = modkernel32.NewProc("GetPackageId")
	procGetProcessIdOfThread                 = modkernel32.NewProc("GetProcessIdOfThread")
	procTerminateThread                      = modkernel32.NewProc("TerminateThread")
	procWTSGetActiveConsoleSessionId         = modkernel32.NewProc("WTSGetActiveConsoleSessionId")
	procNtAlpcQueryInformation               = modntdll.NewProc("NtAlpcQueryInformation")
	procNtCreateSection                      = modntdll.NewProc("NtCreateSection")
	procNtMapViewOfSection                   = modntdll.NewProc("NtMapViewOfSection")
	procNtQueryMutant                        = modntdll.NewProc("NtQueryMutant")
	procNtQueryObject                        = modntdll.NewProc("NtQueryObject")
	procNtQueryVolumeInformationFile         = modntdll.NewProc("NtQueryVolumeInformationFile")
	procNtUnmapViewOfSection                 = modntdll.NewProc("NtUnmapViewOfSection")
	procRtlNtStatusToDosError                = modntdll.NewProc("RtlNtStatusToDosError")
	procEnumDeviceDrivers                    = modpsapi.NewProc("EnumDeviceDrivers")
	procGetDeviceDriverFileNameW             = modpsapi.NewProc("GetDeviceDriverFileNameW")
	procGetMappedFileNameW                   = modpsapi.NewProc("GetMappedFileNameW")
	procQueryWorkingSetEx                    = modpsapi.NewProc("QueryWorkingSetEx")
	procSHGetStockIconInfo                   = modshell32.NewProc("SHGetStockIconInfo")
	procShell_NotifyIconW                    = modshell32.NewProc("Shell_NotifyIconW")
	procPathIsDirectoryW                     = modshlwapi.NewProc("PathIsDirectoryW")
	procCreateWindowExW                      = moduser32.NewProc("CreateWindowExW")
	procDefWindowProcW                       = moduser32.NewProc("DefWindowProcW")
	procDestroyIcon                          = moduser32.NewProc("DestroyIcon")
	procDestroyWindow                        = moduser32.NewProc("DestroyWindow")
	procLoadImageW                           = moduser32.NewProc("LoadImageW")
	procRegisterClassExW                     = moduser32.NewProc("RegisterClassExW")
	procCryptCATAdminAcquireContext2         = modwintrust.NewProc("CryptCATAdminAcquireContext2")
	procCryptCATAdminCalcHashFromFileHandle2 = modwintrust.NewProc("CryptCATAdminCalcHashFromFileHandle2")
	procCryptCATAdminEnumCatalogFromHash     = modwintrust.NewProc("CryptCATAdminEnumCatalogFromHash")
	procCryptCATAdminReleaseCatalogContext   = modwintrust.NewProc("CryptCATAdminReleaseCatalogContext")
	procCryptCATAdminReleaseContext          = modwintrust.NewProc("CryptCATAdminReleaseContext")
	procCryptCATCatalogInfoFromContext       = modwintrust.NewProc("CryptCATCatalogInfoFromContext")
	procWinVerifyTrust                       = modwintrust.NewProc("WinVerifyTrust")
	procWTSQuerySessionInformationW          = modwtsapi32.NewProc("WTSQuerySessionInformationW")
	procWTSQueryUserToken                    = modwtsapi32.NewProc("WTSQueryUserToken")
)

func SymEnumLoadedModules(handle windows.Handle, callback uintptr, ctx uintptr) (b bool) {
	r0, _, _ := syscall.Syscall(procEnumerateLoadedModulesW64.Addr(), 3, uintptr(handle), uintptr(callback), uintptr(ctx))
	b = r0 != 0
	return
}

func SymCleanup(handle windows.Handle) (b bool) {
	r0, _, _ := syscall.Syscall(procSymCleanup.Addr(), 1, uintptr(handle), 0, 0)
	b = r0 != 0
	return
}

func SymFromAddr(handle windows.Handle, addr uint64, offset *uint64, sym *SymbolInfo) (b bool) {
	r0, _, _ := syscall.Syscall6(procSymFromAddrW.Addr(), 4, uintptr(handle), uintptr(addr), uintptr(unsafe.Pointer(offset)), uintptr(unsafe.Pointer(sym)), 0, 0)
	b = r0 != 0
	return
}

func SymGetModuleInfo(handle windows.Handle, addr uint64, mod *ModuleInfo) (b bool) {
	r0, _, _ := syscall.Syscall(procSymGetModuleInfoW64.Addr(), 3, uintptr(handle), uintptr(addr), uintptr(unsafe.Pointer(mod)))
	b = r0 != 0
	return
}

func SymInitialize(handle windows.Handle, searchPath *uint16, invadeProcess bool) (b bool) {
	var _p0 uint32
	if invadeProcess {
		_p0 = 1
	}
	r0, _, _ := syscall.Syscall(procSymInitialize.Addr(), 3, uintptr(handle), uintptr(unsafe.Pointer(searchPath)), uintptr(_p0))
	b = r0 != 0
	return
}

func SymLoadModule(handle windows.Handle, file windows.Handle, imageName *uint16, moduleName *uint16, baseDLL uint64, sizeDLL uint32, data uintptr, flags uint32) (base uint64) {
	r0, _, _ := syscall.Syscall9(procSymLoadModuleExW.Addr(), 8, uintptr(handle), uintptr(file), uintptr(unsafe.Pointer(imageName)), uintptr(unsafe.Pointer(moduleName)), uintptr(baseDLL), uintptr(sizeDLL), uintptr(data), uintptr(flags), 0)
	base = uint64(r0)
	return
}

func SymSetOptions(opts uint32) (options uint32) {
	r0, _, _ := syscall.Syscall(procSymSetOptions.Addr(), 1, uintptr(opts), 0, 0)
	options = uint32(r0)
	return
}

func SymUnloadModule(handle windows.Handle, baseDLL uint64) {
	syscall.Syscall(procSymUnloadModule64.Addr(), 2, uintptr(handle), uintptr(baseDLL), 0)
	return
}

func CreateThread(attributes *windows.SecurityAttributes, stackSize uint, startAddress uintptr, param uintptr, creationFlags uint32, threadID *uint32) (handle windows.Handle) {
	r0, _, _ := syscall.Syscall6(procCreateThread.Addr(), 6, uintptr(unsafe.Pointer(attributes)), uintptr(stackSize), uintptr(startAddress), uintptr(param), uintptr(creationFlags), uintptr(unsafe.Pointer(threadID)))
	handle = windows.Handle(r0)
	return
}

func FreeConsole() {
	syscall.Syscall(procFreeConsole.Addr(), 0, 0, 0, 0)
	return
}

func GetPackageID(handle windows.Handle, length *uint32, buf uintptr) (err error) {
	r1, _, e1 := syscall.Syscall(procGetPackageId.Addr(), 3, uintptr(handle), uintptr(unsafe.Pointer(length)), uintptr(buf))
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func GetProcessIdOfThread(handle windows.Handle) (pid uint32) {
	r0, _, _ := syscall.Syscall(procGetProcessIdOfThread.Addr(), 1, uintptr(handle), 0, 0)
	pid = uint32(r0)
	return
}

func TerminateThread(handle windows.Handle, exitCode uint32) (err error) {
	r1, _, e1 := syscall.Syscall(procTerminateThread.Addr(), 2, uintptr(handle), uintptr(exitCode), 0)
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func WTSGetActiveConsoleSessionID() (n uint32) {
	r0, _, _ := syscall.Syscall(procWTSGetActiveConsoleSessionId.Addr(), 0, 0, 0, 0)
	n = uint32(r0)
	return
}

func NtAlpcQueryInformation(handle windows.Handle, alpcInfoClass int32, alpcInfo unsafe.Pointer, alpcInfoLen uint32, retLen *uint32) (ntstatus error) {
	r0, _, _ := syscall.Syscall6(procNtAlpcQueryInformation.Addr(), 5, uintptr(handle), uintptr(alpcInfoClass), uintptr(alpcInfo), uintptr(alpcInfoLen), uintptr(unsafe.Pointer(retLen)), 0)
	if r0 != 0 {
		ntstatus = windows.NTStatus(r0)
	}
	return
}

func NtCreateSection(section *windows.Handle, desiredAccess uint32, objectAttributes uintptr, maxSize uintptr, protection uint32, allocation uint32, file windows.Handle) (ntstatus error) {
	r0, _, _ := syscall.Syscall9(procNtCreateSection.Addr(), 7, uintptr(unsafe.Pointer(section)), uintptr(desiredAccess), uintptr(objectAttributes), uintptr(maxSize), uintptr(protection), uintptr(allocation), uintptr(file), 0, 0)
	if r0 != 0 {
		ntstatus = windows.NTStatus(r0)
	}
	return
}

func NtMapViewOfSection(section windows.Handle, process windows.Handle, sectionBase uintptr, zeroBits uintptr, commitSize uintptr, offset uintptr, size uintptr, inherit uint32, allocation uint32, protect uint32) (ntstatus error) {
	r0, _, _ := syscall.Syscall12(procNtMapViewOfSection.Addr(), 10, uintptr(section), uintptr(process), uintptr(sectionBase), uintptr(zeroBits), uintptr(commitSize), uintptr(offset), uintptr(size), uintptr(inherit), uintptr(allocation), uintptr(protect), 0, 0)
	if r0 != 0 {
		ntstatus = windows.NTStatus(r0)
	}
	return
}

func NtQueryMutant(handle windows.Handle, mutantInfoClass int32, mutantInfo unsafe.Pointer, mutantInfoLen uint32, retLen *uint32) (ntstatus error) {
	r0, _, _ := syscall.Syscall6(procNtQueryMutant.Addr(), 5, uintptr(handle), uintptr(mutantInfoClass), uintptr(mutantInfo), uintptr(mutantInfoLen), uintptr(unsafe.Pointer(retLen)), 0)
	if r0 != 0 {
		ntstatus = windows.NTStatus(r0)
	}
	return
}

func NtQueryObject(handle windows.Handle, objectInfoClass int32, objInfo unsafe.Pointer, objInfoLen uint32, retLen *uint32) (ntstatus error) {
	r0, _, _ := syscall.Syscall6(procNtQueryObject.Addr(), 5, uintptr(handle), uintptr(objectInfoClass), uintptr(objInfo), uintptr(objInfoLen), uintptr(unsafe.Pointer(retLen)), 0)
	if r0 != 0 {
		ntstatus = windows.NTStatus(r0)
	}
	return
}

func NtQueryVolumeInformationFile(handle windows.Handle, ioStatusBlock *windows.IO_STATUS_BLOCK, fsInfo uintptr, retLen uint32, fsInfoClass int32) (ntstatus error) {
	r0, _, _ := syscall.Syscall6(procNtQueryVolumeInformationFile.Addr(), 5, uintptr(handle), uintptr(unsafe.Pointer(ioStatusBlock)), uintptr(fsInfo), uintptr(retLen), uintptr(fsInfoClass), 0)
	if r0 != 0 {
		ntstatus = windows.NTStatus(r0)
	}
	return
}

func NtUnmapViewOfSection(process windows.Handle, addr uintptr) (ntstatus error) {
	r0, _, _ := syscall.Syscall(procNtUnmapViewOfSection.Addr(), 2, uintptr(process), uintptr(addr), 0)
	if r0 != 0 {
		ntstatus = windows.NTStatus(r0)
	}
	return
}

func RtlNtStatusToDosError(status uint32) (code uint32) {
	r0, _, _ := syscall.Syscall(procRtlNtStatusToDosError.Addr(), 1, uintptr(status), 0, 0)
	code = uint32(r0)
	return
}

func EnumDeviceDrivers(imageBase uintptr, size uint32, needed *uint32) (err error) {
	r1, _, e1 := syscall.Syscall(procEnumDeviceDrivers.Addr(), 3, uintptr(imageBase), uintptr(size), uintptr(unsafe.Pointer(needed)))
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func GetDeviceDriverFileName(imageBase uintptr, filename *uint16, size uint32) (n uint32) {
	r0, _, _ := syscall.Syscall(procGetDeviceDriverFileNameW.Addr(), 3, uintptr(imageBase), uintptr(unsafe.Pointer(filename)), uintptr(size))
	n = uint32(r0)
	return
}

func GetMappedFileName(handle windows.Handle, addr uintptr, filename *uint16, size uint32) (n uint32) {
	r0, _, _ := syscall.Syscall6(procGetMappedFileNameW.Addr(), 4, uintptr(handle), uintptr(addr), uintptr(unsafe.Pointer(filename)), uintptr(size), 0, 0)
	n = uint32(r0)
	return
}

func QueryWorkingSet(handle windows.Handle, ws *MemoryWorkingSetExInformation, size uint32) (err error) {
	r1, _, e1 := syscall.Syscall(procQueryWorkingSetEx.Addr(), 3, uintptr(handle), uintptr(unsafe.Pointer(ws)), uintptr(size))
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func SHGetStockIconInfo(id int32, flags uint32, icon *ShStockIcon) (err error) {
	r1, _, e1 := syscall.Syscall(procSHGetStockIconInfo.Addr(), 3, uintptr(id), uintptr(flags), uintptr(unsafe.Pointer(icon)))
	if r1 != 0 {
		err = errnoErr(e1)
	}
	return
}

func ShellNotifyIcon(msg NotifyIconMessage, data *NotifyIconData) (err error) {
	r1, _, e1 := syscall.Syscall(procShell_NotifyIconW.Addr(), 2, uintptr(msg), uintptr(unsafe.Pointer(data)), 0)
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func pathIsDirectory(path *uint16) (isDirectory bool) {
	r0, _, _ := syscall.Syscall(procPathIsDirectoryW.Addr(), 1, uintptr(unsafe.Pointer(path)), 0, 0)
	isDirectory = r0 != 0
	return
}

func CreateWindowEx(exStyle uint32, className *uint16, windowName *uint16, style uint32, x int32, y int32, w int32, h int32, parent Hwnd, menu uintptr, instance windows.Handle, param uintptr) (hwnd Hwnd, err error) {
	r0, _, e1 := syscall.Syscall12(procCreateWindowExW.Addr(), 12, uintptr(exStyle), uintptr(unsafe.Pointer(className)), uintptr(unsafe.Pointer(windowName)), uintptr(style), uintptr(x), uintptr(y), uintptr(w), uintptr(h), uintptr(parent), uintptr(menu), uintptr(instance), uintptr(param))
	hwnd = Hwnd(r0)
	if hwnd == 0 {
		err = errnoErr(e1)
	}
	return
}

func DefWindowProc(hwnd uintptr, msg uint32, wparam uintptr, lparam uintptr) (result uintptr) {
	r0, _, _ := syscall.Syscall6(procDefWindowProcW.Addr(), 4, uintptr(hwnd), uintptr(msg), uintptr(wparam), uintptr(lparam), 0, 0)
	result = uintptr(r0)
	return
}

func DestroyIcon(icon Hicon) {
	syscall.Syscall(procDestroyIcon.Addr(), 1, uintptr(icon), 0, 0)
	return
}

func DestroyWindow(hwnd Hwnd) {
	syscall.Syscall(procDestroyWindow.Addr(), 1, uintptr(hwnd), 0, 0)
	return
}

func LoadImage(inst windows.Handle, name *uint16, typ uint, cx int, cy int, flags uint) (handle windows.Handle, err error) {
	r0, _, e1 := syscall.Syscall6(procLoadImageW.Addr(), 6, uintptr(inst), uintptr(unsafe.Pointer(name)), uintptr(typ), uintptr(cx), uintptr(cy), uintptr(flags))
	handle = windows.Handle(r0)
	if handle == 0 {
		err = errnoErr(e1)
	}
	return
}

func RegisterClass(class *WndClassEx) (err error) {
	r1, _, e1 := syscall.Syscall(procRegisterClassExW.Addr(), 1, uintptr(unsafe.Pointer(class)), 0, 0)
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func CryptCatalogAdminAcquireContext(handle *windows.Handle, subsystem *windows.GUID, hashAlgorithm *uint16, hashPolicy uintptr, flags uint32) (err error) {
	r1, _, e1 := syscall.Syscall6(procCryptCATAdminAcquireContext2.Addr(), 5, uintptr(unsafe.Pointer(handle)), uintptr(unsafe.Pointer(subsystem)), uintptr(unsafe.Pointer(hashAlgorithm)), uintptr(hashPolicy), uintptr(flags), 0)
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func CryptCatalogAdminCalcHashFromFileHandle(handle windows.Handle, fd uintptr, size *uint32, hash uintptr, flags uint32) (err error) {
	r1, _, e1 := syscall.Syscall6(procCryptCATAdminCalcHashFromFileHandle2.Addr(), 5, uintptr(handle), uintptr(fd), uintptr(unsafe.Pointer(size)), uintptr(hash), uintptr(flags), 0)
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func CryptCatalogAdminEnumCatalogFromHash(handle windows.Handle, hash uintptr, size uint32, flags uint32, prevCatalog *windows.Handle) (catalog windows.Handle) {
	r0, _, _ := syscall.Syscall6(procCryptCATAdminEnumCatalogFromHash.Addr(), 5, uintptr(handle), uintptr(hash), uintptr(size), uintptr(flags), uintptr(unsafe.Pointer(prevCatalog)), 0)
	catalog = windows.Handle(r0)
	return
}

func CryptCatalogAdminReleaseCatalogContext(handle windows.Handle, info windows.Handle, flags uint32) (err error) {
	r1, _, e1 := syscall.Syscall(procCryptCATAdminReleaseCatalogContext.Addr(), 3, uintptr(handle), uintptr(info), uintptr(flags))
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func CryptCatalogAdminReleaseContext(handle windows.Handle, flags int32) (ok bool) {
	r0, _, _ := syscall.Syscall(procCryptCATAdminReleaseContext.Addr(), 2, uintptr(handle), uintptr(flags), 0)
	ok = r0 != 0
	return
}

func CryptCatalogInfoFromContext(handle windows.Handle, catalog *CatalogInfo, flags uint32) (err error) {
	r1, _, e1 := syscall.Syscall(procCryptCATCatalogInfoFromContext.Addr(), 3, uintptr(handle), uintptr(unsafe.Pointer(catalog)), uintptr(flags))
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func WinVerifyTrust(handle windows.Handle, action *windows.GUID, data *WintrustData) (ret uint32, err error) {
	r0, _, e1 := syscall.Syscall(procWinVerifyTrust.Addr(), 3, uintptr(handle), uintptr(unsafe.Pointer(action)), uintptr(unsafe.Pointer(data)))
	ret = uint32(r0)
	if ret != 0 {
		err = errnoErr(e1)
	}
	return
}

func WTSQuerySessionInformationA(handle windows.Handle, sessionID uint32, klass uint8, buf **uint16, size *uint32) (err error) {
	r1, _, e1 := syscall.Syscall6(procWTSQuerySessionInformationW.Addr(), 5, uintptr(handle), uintptr(sessionID), uintptr(klass), uintptr(unsafe.Pointer(buf)), uintptr(unsafe.Pointer(size)), 0)
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func WTSQueryUserToken(sessionID uint32, token *windows.Token) (ok bool) {
	r0, _, _ := syscall.Syscall(procWTSQueryUserToken.Addr(), 2, uintptr(sessionID), uintptr(unsafe.Pointer(token)), 0)
	ok = r0 != 0
	return
}
