// Code generated by 'go generate'; DO NOT EDIT.

package etw

import (
	"syscall"
	"unsafe"

	"golang.org/x/sys/windows"
)

var _ unsafe.Pointer

// Do the interface allocations only once for common
// Errno values.
const (
	errnoERROR_IO_PENDING = 997
)

var (
	errERROR_IO_PENDING error = syscall.Errno(errnoERROR_IO_PENDING)
	errERROR_EINVAL     error = syscall.EINVAL
)

// errnoErr returns common boxed Errno values, to prevent
// allocations at runtime.
func errnoErr(e syscall.Errno) error {
	switch e {
	case 0:
		return errERROR_EINVAL
	case errnoERROR_IO_PENDING:
		return errERROR_IO_PENDING
	}
	// TODO: add more here, after collecting data on the common
	// error values see on Windows. (perhaps when running
	// all.bat?)
	return e
}

var (
	modadvapi32 = windows.NewLazySystemDLL("advapi32.dll")

	procCloseTrace            = modadvapi32.NewProc("CloseTrace")
	procControlTraceW         = modadvapi32.NewProc("ControlTraceW")
	procEnableTraceEx2        = modadvapi32.NewProc("EnableTraceEx2")
	procOpenTraceW            = modadvapi32.NewProc("OpenTraceW")
	procProcessTrace          = modadvapi32.NewProc("ProcessTrace")
	procStartTraceW           = modadvapi32.NewProc("StartTraceW")
	procTraceQueryInformation = modadvapi32.NewProc("TraceQueryInformation")
	procTraceSetInformation   = modadvapi32.NewProc("TraceSetInformation")
)

func closeTrace(handle TraceHandle) (err error) {
	r1, _, e1 := syscall.Syscall(procCloseTrace.Addr(), 1, uintptr(handle), 0, 0)
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func controlTrace(handle TraceHandle, name string, props *EventTraceProperties, operation TraceOperation) (err error) {
	var _p0 *uint16
	_p0, err = syscall.UTF16PtrFromString(name)
	if err != nil {
		return
	}
	return _controlTrace(handle, _p0, props, operation)
}

func _controlTrace(handle TraceHandle, name *uint16, props *EventTraceProperties, operation TraceOperation) (err error) {
	r1, _, e1 := syscall.Syscall6(procControlTraceW.Addr(), 4, uintptr(handle), uintptr(unsafe.Pointer(name)), uintptr(unsafe.Pointer(props)), uintptr(operation), 0, 0)
	if r1 != 0 {
		err = errnoErr(e1)
	}
	return
}

func enableTraceEx2(handle TraceHandle, providerID *windows.GUID, controlCode uint32, level uint8, matchAnyKeyword uint64, matchAllKeyword uint64, timeout uint32, enableParameters *EnableTraceParameters) (err error) {
	r1, _, e1 := syscall.Syscall9(procEnableTraceEx2.Addr(), 8, uintptr(handle), uintptr(unsafe.Pointer(providerID)), uintptr(controlCode), uintptr(level), uintptr(matchAnyKeyword), uintptr(matchAllKeyword), uintptr(timeout), uintptr(unsafe.Pointer(enableParameters)), 0)
	if r1 != 0 {
		err = errnoErr(e1)
	}
	return
}

func openTrace(logfile *EventTraceLogfile) (handle TraceHandle) {
	r0, _, _ := syscall.Syscall(procOpenTraceW.Addr(), 1, uintptr(unsafe.Pointer(logfile)), 0, 0)
	handle = TraceHandle(r0)
	return
}

func processTrace(handle *TraceHandle, count uint32, start *windows.Filetime, end *windows.Filetime) (err error) {
	r1, _, e1 := syscall.Syscall6(procProcessTrace.Addr(), 4, uintptr(unsafe.Pointer(handle)), uintptr(count), uintptr(unsafe.Pointer(start)), uintptr(unsafe.Pointer(end)), 0, 0)
	if r1 != 0 {
		err = errnoErr(e1)
	}
	return
}

func startTrace(handle *TraceHandle, name string, props *EventTraceProperties) (err error) {
	var _p0 *uint16
	_p0, err = syscall.UTF16PtrFromString(name)
	if err != nil {
		return
	}
	return _startTrace(handle, _p0, props)
}

func _startTrace(handle *TraceHandle, name *uint16, props *EventTraceProperties) (err error) {
	r1, _, e1 := syscall.Syscall(procStartTraceW.Addr(), 3, uintptr(unsafe.Pointer(handle)), uintptr(unsafe.Pointer(name)), uintptr(unsafe.Pointer(props)))
	if r1 != 0 {
		err = errnoErr(e1)
	}
	return
}

func traceQueryInformation(handle TraceHandle, infoClass uint8, info uintptr, length uint32, size *uint32) (err error) {
	r1, _, e1 := syscall.Syscall6(procTraceQueryInformation.Addr(), 5, uintptr(handle), uintptr(infoClass), uintptr(info), uintptr(length), uintptr(unsafe.Pointer(size)), 0)
	if r1 != 0 {
		err = errnoErr(e1)
	}
	return
}

func traceSetInformation(handle TraceHandle, infoClass uint8, info uintptr, length uint32) (err error) {
	r1, _, e1 := syscall.Syscall6(procTraceSetInformation.Addr(), 4, uintptr(handle), uintptr(infoClass), uintptr(info), uintptr(length), 0, 0)
	if r1 != 0 {
		err = errnoErr(e1)
	}
	return
}
