# Thread events

#### CreateThread and TerminateThread

Thread events notify the creation (`CreateThread`) or termination (`TerminateThread`) of threads within the process' address space. In situations where a process spawns a remote thread that runs in other process' address space, the `CreateThread` event is also triggered.
Thread events are comprised of the following parameters:

- `pid` identifies the process where the thread was created. If this value is not equal to the `pid` of the process generating the event, then the thread is created in remote process.
- `tid` represents the identifier of the freshly spawn thread.
- `base_prio` is the scheduler priority of the thread.
- `page_prio` is a memory page priority hint for memory pages accessed by the thread.
- `io_prio` represents an I/O priority hint for scheduling I/O operations generated by the thread.
- `ustack_base` is the base address of the thread's user space stack.
- `ustack_limit` is the limit of the thread's user space stack.
- `kstack_base` is the base address of the thread's kernel space stack.
- `kstack_limit` is the limit of the thread's kernel space stack.
- `start_address` is the start address of the function to be executed by the thread.
- `teb` is the address of the Thread Environment Block (TEB).

#### OpenThread

`OpenProcess` event is triggered when a process opens an existing local thread object. This event contains the following parameters:

- `desired_access` is the hexadecimal value that represents the desired access to the thread object.
- `desired_access_names` is the list of human-readable desired access strings (e.g. `QUERY_LIMITED_INFORMATION`). For a full list and detailed explanation of available access rights, head to the official [docs](https://docs.microsoft.com/en-us/windows/win32/procthread/thread-security-and-access-rights).
- `name` is the name of the local process whose thread object was open.
- `exe` is the full path of the local process image whose thread object was open.
- `pid` is the identifier of the local process whose thread object was opened.
- `tid` is the identifier of the local thread that was opened.
- `status` contains the result of the thread object open operation. (e.g. `Success`)

#### SetThreadContext

`SetThreadContext` sets the thread context. Thread context represents the set of CPU registers.

- `status` contains the result of operation. (e.g. `Success`)
