import { async, ComponentFixture, TestBed } from '@angular/core/testing';

import { StageComponent } from './stage.component';
import { MatButtonModule } from '@angular/material/button';
import { MatDividerModule } from '@angular/material/divider';
import { MatIconModule } from '@angular/material/icon';
import { MatInputModule } from '@angular/material/input';
import { MatMenuModule } from '@angular/material/menu';
import { TreeModule } from 'angular-tree-component';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { WrapperService } from 'src/app/github/wrapper.service';
import { Store } from '@ngrx/store';

describe('StageComponent', () => {
  let component: StageComponent;
  let fixture: ComponentFixture<StageComponent>;

  beforeEach(async(() => {
    let storeSpy = jasmine.createSpyObj("Store", ["dispatch"]);
    TestBed.configureTestingModule({
      declarations: [ StageComponent ],
      imports: [MatMenuModule, MatIconModule, MatDividerModule, MatInputModule,
        FormsModule,
        ReactiveFormsModule, BrowserAnimationsModule, 
        TreeModule.forRoot(), MatButtonModule],
      providers: [{provide: WrapperService, useValue: undefined},
        {provide: Store, useValue: storeSpy}]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(StageComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  // it('should create', () => {
  //   expect(component).toBeTruthy();
  // });
});
