|                                                                                                                                                       tag                                                                                                                                                        | contents                                                                                 | common properties                                                                                                                                                                                       |
| :--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: | ---------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
|                                                                                                                    [`<html>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/html)                                                                                                                    | the contents of the html file                                                            | <li> `lang` = the document's [language code](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) ("en" for english)                                                                                  |
|                                                                                                                    [`<head>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/head)                                                                                                                    | metadata and links to style sheets                                                       |                                                                                                                                                                                                         |
|                                                                                                                    [`<meta>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta)                                                                                                                    | none, used for metadata (information about the html file)                                | <li> `charset` = the character encoding (use "UTF-8")<li> `name` = "author", "description", "keywords"<li> `contents` = the metadata value                                                              |
|                                                                                                                   [`<title>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/title)                                                                                                                   | the title of the tab/window                                                              |                                                                                                                                                                                                         |
|                                                                                                                    [`<link>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/link)                                                                                                                    | none, used to load CSS                                                                   | <li> `rel` = type of link ("stylesheet" for CSS, "icon" for the page icon)<li> `href` = (hyperlink reference) the path of the file                                                                      |
|                                                                                                                    [`<body>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/body)                                                                                                                    | the visiable contents of the page                                                        |                                                                                                                                                                                                         |
|                                                                                                                     [`<div>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/div)                                                                                                                     | a group of elements (the most commonly used HTML tag)                                    |
|                                                                                                                       [`<a>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a)                                                                                                                       | clickable links to other webpages                                                        | <li> `href` = (hyperlink reference) the path of the file                                                                                                                                                |
|                                                                                                           [`<h1>`-`<h6>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/heading_elements)                                                                                                            | header text (1 is largest, 6 is smallest)                                                |                                                                                                                                                                                                         |
|                                                                                                                 [`<article>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/article)                                                                                                                 | an article                                                                               |                                                                                                                                                                                                         |
|                                                                                                                       [`<p>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/p)                                                                                                                       | a paragraph of text, displayed on a new line                                             |                                                                                                                                                                                                         |
|                                                                                                                    [`<span>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/span)                                                                                                                    | span of text, not displayed on a new line (can be used for text highlighting)            |                                                                                                                                                                                                         |
|                                                                                                                     [`<img>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/img)                                                                                                                     | none, displays an image                                                                  | <li> `src` = (source) the path of the file                                                                                                                                                              |
|                                                                                                                   [`<video>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/video)                                                                                                                   | none, displays a video                                                                   | <li> `src` = (source) the path of the file <li> `controls` = boolean attribute for adding controls (play/pause, seek, and volume)                                                                       |
|                                                                                                                     [`<nav>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/nav)                                                                                                                     | site navigation links, usually placed at the top of a web page                           |                                                                                                                                                                                                         |
|                                                                                                                  [`<footer>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/footer)                                                                                                                  | typically used to cite the author of the site at the bottom of every page                |                                                                                                                                                                                                         |
|                                                                                                                    [`<form>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form)                                                                                                                    | inputs for the user to enter data in                                                     |                                                                                                                                                                                                         |
|                                                                                                                   [`<input>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input)                                                                                                                   | none                                                                                     | <li> `value` = the value of the user's input<li> `type` = common types include "checkbox", "color", "date", "email", "file", "number", "password", "radio", "range", "search", "tel", "text", and "url" |
|                                                                                                                [`<textarea>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/textarea)                                                                                                                | contains a large scrollable portion of text                                              |                                                                                                                                                                                                         |
|                                                                                                                  [`<button>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button)                                                                                                                  | the displayed name of the button                                                         | <li> `type` = "button" for a normal button or "submit" for transfering form data to the site's server                                                                                                   |
|                                                                                                                   [`<label>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/label)                                                                                                                   | displayed label text                                                                     | <li> `for` = id of the element being labeled                                                                                                                                                            |
|                                                                                                                  [`<select>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/select)                                                                                                                  | an expandable menu with selectable options                                               | <li> `multiple` = boolean attribute specifies if the user can select multiple options (default is false)                                                                                                |
|                                                                                                                  [`<option>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/option)                                                                                                                  | displayed option text (notably it can't be styled by CSS on browsers other than Firefox) | <li> `value` = the data value of this option which can be different from the displayed option text<li> `selected` = used to specify the default selected option                                         |
|                                              [`<ol>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ol), [`<ul>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ul), [`<li>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/li)                                              | ordered list, unordered list, and list item                                              |                                                                                                                                                                                                         |
| [`<table>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/table), [`<thead>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/thead), [`<tbody>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tbody), [`<tr>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tr) | table, table head, table body, table row                                                 |                                                                                                                                                                                                         |
|                                                                                  [`<th>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/th), [`<td>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/td)                                                                                  | table header cell, table data cell                                                       | <li> `colspan` = how many columns the cell should span<li> `rowspan` = how many rows the cell should span                                                                                               |
