# [QuintOS]

Level up your coding skills by using QuintOS to create retro games and applications!

At <https://quinton-ashley.github.io/quintos> you can see programs made by my students!

I've developed two courses that use QuintOS: [IntroToJS] and [IntroToJava].

Contact me <mailto:qashto@gmail.com> for lessons! Or use the QuintOS [template project] to get started making your own retro stuff.

## Features

QuintOS is a JavaScript library that simulates the look and feel of retro computers and game consoles, including:

- `a2` : Apple II
- `arc` : Generic Arcade
- `c64` : Commodore 64
- `calcu` : Casio FX-702P
- `cpet` : Commodore PET
- `gameboi` : Nintendo GameBoy
- `gridc` : GRID Compass
- `ibm2250` : IBM 2250
- `macin` : Macintosh
- `sas` : Speak & Spell
- `zx` : ZX Spectrum

# Credits

I'd like to thank all the creators whose work is included in this project and all the people who worked on the original machines that QuintOS simulates. Your work continues to inspire my students!

### Fonts

- [Apple2]
- [C64 Pro Mono]
- [Casio FX 9860GII]:
- [Digital 7]
- [ZX Spectrum]
- [Basis 33]
- [Cyrillic Pixel 7]
- [Press Start 2P]

### Art

#### WorldWideWeb

- [PicGifs]

#### SuperJump

- [Slime Pack 4]
- [Ancient City]

#### Sokoban

- [BitBoi]

  "Hi! That's wonderful! Glad that you liked my assets. Looking forward to seeing some projects using my art! Have a great day!"

  \- blueapollo\_ Sep 9, 2021, 7:21 PM

  - [Tileset Pack 1]
  - [1 Bit House]

  Additional animations for the bitBoi character were commissioned from Pepe Jamal <contato.pepejamal@gmail.com> Huge thanks!

- questKid

  - [RPG Dungeon Crawl Tileset]
  - [Pixel Art adventurer Sprites]

- tribeMan:

  - [Dungeon Mini Tileset 6382]
  - [Pixel Tribe Man 2]

#### PigeonSimulator

- [Pigeons 2D Pixel Asset Pack]
- [Tiny Tiny Heroes Animals]
- [Pixel Sidescroller Background City]

### Sounds

#### SpeakAndSpell

- [Nnoncarey]

8 Bit sounds:

- [Retro 8-Bit Sounds 9524]

### CodePens

##### William Jawad

- [Casio FX-702P]

##### Alexander Guski

- [Terminal]

##### Manz

- [Old Retro TV] with CSS

- [ZX Spectrum]

- [MS-DOS Defrag]

- [MS-DOS Scandisk]

- [Nintendo GameBoy] with vanilla CSS / JS

##### Benjamin Braithwaite

- [Web Survey Form]
  Build a responsive web survey form

### Data

#### Wordle

- [Common 5 Letter Words]

- [5 Letter Words]

<!----------------------------------------------------------------------------->

[template project]: https://github.com/quinton-ashley/quintos-template
[introtojava]: https://github.com/quinton-ashley/IntroToJava/blob/main/README.md
[introtojs]: https://github.com/quinton-ashley/IntroToJS/blob/main/README.md

<!-----------------------------------[ Fonts ]--------------------------------->

[cyrillic pixel 7]: https://www.1001fonts.com/cyrillic-pixel-7-font.html
[casio fx 9860gii]: https://www.dafont.com/casio-fx-9860gii.font
[press start 2p]: https://fonts.google.com/specimen/Press+Start+2P#standard-styles
[c64 pro mono]: https://style64.org/petscii/
[zx spectrum]: https://www.dafont.com/zx-spectrum-7.font
[digital 7]: https://www.dafont.com/digital-7.font?text=digital7
[basis 33]: https://www.1001fonts.com/basis33-font.html
[apple2]: https://www.kreativekorp.com/software/fonts/apple2.shtml

<!------------------------------------[ Art ]---------------------------------->

[pixel sidescroller background city]: https://www.gamedevmarket.net/asset/pixel-sidescroller-background-city/
[pigeons 2d pixel asset pack]: https://www.gamedevmarket.net/asset/pigeons-2d-pixel-asset-pack/
[tiny tiny heroes animals]: https://www.gamedevmarket.net/asset/tiny-tiny-heroes-animals/
[pixel art adventurer sprites]: https://www.gamedevmarket.net/asset/pixel-art-adventurer-sprites/
[rpg dungeon crawl tileset]: https://www.gamedevmarket.net/asset/rpg-dungeon-crawl-tileset/
[pixel tribe man 2]: https://www.gamedevmarket.net/asset/pixel-tribe-man-2/
[tileset pack 1]: https://www.gamedevmarket.net/asset/platform-dirt-rock-tileset-pack-1bit-16x16-8x8-bonus-characters-items/
[slime pack 4]: https://www.gamedevmarket.net/asset/slime-pack-4-slime-variants/
[dungeon mini tileset 6382]: https://www.gamedevmarket.net/asset/dungeon-mini-tileset-6382/
[ancient city]: https://www.gamedevmarket.net/asset/ancient-city/
[1 bit house]: https://www.gamedevmarket.net/asset/1bit-house/
[picgifs]: https://www.picgifs.com
[bitboi]: https://www.gamedevmarket.net/asset/oracle-1-bit-asset/

<!-----------------------------------[ Sound ]--------------------------------->

[retro 8-bit sounds 9524]: https://www.gamedevmarket.net/asset/retro-8-bit-sounds-9524/
[nnoncarey]: https://sha.nnoncarey.com/

<!---------------------------------[ CodePens ]-------------------------------->

[nintendo gameboy]: https://codepen.io/manz/pen/yLzxgXj
[web survey form]: https://codepen.io/bgbraithwaite/pen/vzPrRY
[ms-dos scandisk]: https://codepen.io/manz/pen/KLPEby
[ms-dos defrag]: https://codepen.io/manz/pen/MdErww
[casio fx-702p]: https://codepen.io/wiljav/pen/zYrBYKb
[old retro tv]: https://codepen.io/manz/pen/MWoRMja
[zx spectrum]: https://codepen.io/manz/pen/eYRMgQV
[terminal]: https://codepen.io/rocknrollinc/pen/MwLMZG

<!-----------------------------------[ Data ]---------------------------------->

[common 5 letter words]: https://www.unscramblerer.com/common-five-letter-words/
[5 letter words]: https://www.bestwordlist.com/5letterwords.txt
