# ConvoAI - OpenAI's GPT 3.5 Turbo API 
- Implemented OpenAI's newly-released API `gpt-3.5-turbo`
- Designed a new User Interface with smooth User Experience (snap to latest message, animated loading indicator, hovering effects)
- Use your own API to converse with the bot !
- Switchable theme - persist through refresh
- Option to log in with Google and have your avatar displayed 
- Messages persist throught refresh :)

# First Mount
- Welcoming message :) Telling you to use your API key while disabling any query functionalities
<img width="661" alt="1" src="https://user-images.githubusercontent.com/84165564/224532615-6a84089f-cca2-4306-bdd1-29709765c67e.png">

# First Mount (with Google signed in)
![signed](https://user-images.githubusercontent.com/84165564/225588555-361dc7df-65f6-43a3-af95-b6a30cd57344.png)

# Menu Sidebar
- Where you can have the options to have New Chat and use your own API Key, also sign in with Google !
![signin](https://user-images.githubusercontent.com/84165564/225588544-fb4c4adb-c07a-4981-8778-05556a7ac5a0.png)

# Pop-up Modal for you to enter your API Key
<img width="1143" alt="3" src="https://user-images.githubusercontent.com/84165564/224532612-e5dca251-2d53-44e9-a689-5db2e6a7bd1b.png">

# Animated Loading Indicator
- Indicate answers are being generated and disable your ability to send any queries
<img width="961" alt="8" src="https://user-images.githubusercontent.com/84165564/224532600-848f9361-47fa-4cd0-921a-375fe9a4e14f.png">

# FAQs (Frequently Asked Questions) Accordion
<img width="1143" alt="4" src="https://user-images.githubusercontent.com/84165564/224532610-ee573054-959f-4c1c-bc31-78fb53037fd2.png">

# After API Key entered, you can start to converse !
<img width="667" alt="5" src="https://user-images.githubusercontent.com/84165564/224532607-2ceb9426-5187-49fc-84d0-2a82be6fcdd0.png">

# Holding a Conversation
- Capable of remembering the context in order to hold a conversation
<img width="1346" alt="context" src="https://user-images.githubusercontent.com/84165564/223445985-3ddcf588-c12e-4779-9ed8-852d220973a9.png">

# Long Conversation
<img width="959" alt="7" src="https://user-images.githubusercontent.com/84165564/224532602-a3a6f8db-3717-4cad-ba95-6889a0fdf20f.png">

# New Chat Feature
- Clear the current conversation and API Key so you can start a new one
- With aesthestically pleasing hovering effect
<img width="672" alt="6" src="https://user-images.githubusercontent.com/84165564/224532606-ac1aca18-e373-4130-97cd-5d23b97ae4d1.png">

# Light Mode
- Even when refreshed, the theme will still persist !
![light](https://user-images.githubusercontent.com/84165564/225588529-93e1774f-da99-43ea-b718-cfd6dc45af05.png)

# Menu View (Phone View)
- Get in touch :)
<img width="497" alt="SCR-20230312-lxl" src="https://user-images.githubusercontent.com/84165564/224534276-7dffff1c-9200-4a2d-a11b-7485b925a633.png">


# Getting Started (if you want to use the app locally)
- `cd` into the folder
- `npm i`
- Get your API key [here](https://platform.openai.com/account/api-keys)
- `npm start`
- Open [http://localhost:3000](http://localhost:3000) to view it in your browser.

