// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             v3.15.8
// source: trip.proto

package core

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// TripServiceClient is the client API for TripService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type TripServiceClient interface {
	// trip related operations
	BookTrip(ctx context.Context, in *BookTripRequest, opts ...grpc.CallOption) (*wrapperspb.StringValue, error)
	GetTrip(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*Trip, error)
	GetTrips(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (TripService_GetTripsClient, error)
	DeleteTrip(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// trip event related operations
	CancelTripEvent(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error)
	StartTripEvent(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error)
	CompleteTripEvent(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error)
	GetTripEvents(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (TripService_GetTripEventsClient, error)
	GetTripEvent(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (TripService_GetTripEventClient, error)
	// candidates
	GetCandidatesForTrip(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (TripService_GetCandidatesForTripClient, error)
}

type tripServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewTripServiceClient(cc grpc.ClientConnInterface) TripServiceClient {
	return &tripServiceClient{cc}
}

func (c *tripServiceClient) BookTrip(ctx context.Context, in *BookTripRequest, opts ...grpc.CallOption) (*wrapperspb.StringValue, error) {
	out := new(wrapperspb.StringValue)
	err := c.cc.Invoke(ctx, "/trip.TripService/book_trip", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tripServiceClient) GetTrip(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*Trip, error) {
	out := new(Trip)
	err := c.cc.Invoke(ctx, "/trip.TripService/get_trip", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tripServiceClient) GetTrips(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (TripService_GetTripsClient, error) {
	stream, err := c.cc.NewStream(ctx, &TripService_ServiceDesc.Streams[0], "/trip.TripService/get_trips", opts...)
	if err != nil {
		return nil, err
	}
	x := &tripServiceGetTripsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type TripService_GetTripsClient interface {
	Recv() (*TripList, error)
	grpc.ClientStream
}

type tripServiceGetTripsClient struct {
	grpc.ClientStream
}

func (x *tripServiceGetTripsClient) Recv() (*TripList, error) {
	m := new(TripList)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *tripServiceClient) DeleteTrip(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/trip.TripService/delete_trip", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tripServiceClient) CancelTripEvent(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/trip.TripService/cancel_trip_event", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tripServiceClient) StartTripEvent(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/trip.TripService/start_trip_event", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tripServiceClient) CompleteTripEvent(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/trip.TripService/complete_trip_event", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tripServiceClient) GetTripEvents(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (TripService_GetTripEventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &TripService_ServiceDesc.Streams[1], "/trip.TripService/get_trip_events", opts...)
	if err != nil {
		return nil, err
	}
	x := &tripServiceGetTripEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type TripService_GetTripEventsClient interface {
	Recv() (*TripEventList, error)
	grpc.ClientStream
}

type tripServiceGetTripEventsClient struct {
	grpc.ClientStream
}

func (x *tripServiceGetTripEventsClient) Recv() (*TripEventList, error) {
	m := new(TripEventList)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *tripServiceClient) GetTripEvent(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (TripService_GetTripEventClient, error) {
	stream, err := c.cc.NewStream(ctx, &TripService_ServiceDesc.Streams[2], "/trip.TripService/get_trip_event", opts...)
	if err != nil {
		return nil, err
	}
	x := &tripServiceGetTripEventClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type TripService_GetTripEventClient interface {
	Recv() (*TripEvent, error)
	grpc.ClientStream
}

type tripServiceGetTripEventClient struct {
	grpc.ClientStream
}

func (x *tripServiceGetTripEventClient) Recv() (*TripEvent, error) {
	m := new(TripEvent)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *tripServiceClient) GetCandidatesForTrip(ctx context.Context, in *wrapperspb.StringValue, opts ...grpc.CallOption) (TripService_GetCandidatesForTripClient, error) {
	stream, err := c.cc.NewStream(ctx, &TripService_ServiceDesc.Streams[3], "/trip.TripService/get_candidates_for_trip", opts...)
	if err != nil {
		return nil, err
	}
	x := &tripServiceGetCandidatesForTripClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type TripService_GetCandidatesForTripClient interface {
	Recv() (*TripCandidateList, error)
	grpc.ClientStream
}

type tripServiceGetCandidatesForTripClient struct {
	grpc.ClientStream
}

func (x *tripServiceGetCandidatesForTripClient) Recv() (*TripCandidateList, error) {
	m := new(TripCandidateList)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// TripServiceServer is the server API for TripService service.
// All implementations must embed UnimplementedTripServiceServer
// for forward compatibility
type TripServiceServer interface {
	// trip related operations
	BookTrip(context.Context, *BookTripRequest) (*wrapperspb.StringValue, error)
	GetTrip(context.Context, *wrapperspb.StringValue) (*Trip, error)
	GetTrips(*wrapperspb.StringValue, TripService_GetTripsServer) error
	DeleteTrip(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error)
	// trip event related operations
	CancelTripEvent(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error)
	StartTripEvent(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error)
	CompleteTripEvent(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error)
	GetTripEvents(*wrapperspb.StringValue, TripService_GetTripEventsServer) error
	GetTripEvent(*wrapperspb.StringValue, TripService_GetTripEventServer) error
	// candidates
	GetCandidatesForTrip(*wrapperspb.StringValue, TripService_GetCandidatesForTripServer) error
	mustEmbedUnimplementedTripServiceServer()
}

// UnimplementedTripServiceServer must be embedded to have forward compatible implementations.
type UnimplementedTripServiceServer struct {
}

func (UnimplementedTripServiceServer) BookTrip(context.Context, *BookTripRequest) (*wrapperspb.StringValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BookTrip not implemented")
}
func (UnimplementedTripServiceServer) GetTrip(context.Context, *wrapperspb.StringValue) (*Trip, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTrip not implemented")
}
func (UnimplementedTripServiceServer) GetTrips(*wrapperspb.StringValue, TripService_GetTripsServer) error {
	return status.Errorf(codes.Unimplemented, "method GetTrips not implemented")
}
func (UnimplementedTripServiceServer) DeleteTrip(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTrip not implemented")
}
func (UnimplementedTripServiceServer) CancelTripEvent(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelTripEvent not implemented")
}
func (UnimplementedTripServiceServer) StartTripEvent(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartTripEvent not implemented")
}
func (UnimplementedTripServiceServer) CompleteTripEvent(context.Context, *wrapperspb.StringValue) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CompleteTripEvent not implemented")
}
func (UnimplementedTripServiceServer) GetTripEvents(*wrapperspb.StringValue, TripService_GetTripEventsServer) error {
	return status.Errorf(codes.Unimplemented, "method GetTripEvents not implemented")
}
func (UnimplementedTripServiceServer) GetTripEvent(*wrapperspb.StringValue, TripService_GetTripEventServer) error {
	return status.Errorf(codes.Unimplemented, "method GetTripEvent not implemented")
}
func (UnimplementedTripServiceServer) GetCandidatesForTrip(*wrapperspb.StringValue, TripService_GetCandidatesForTripServer) error {
	return status.Errorf(codes.Unimplemented, "method GetCandidatesForTrip not implemented")
}
func (UnimplementedTripServiceServer) mustEmbedUnimplementedTripServiceServer() {}

// UnsafeTripServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to TripServiceServer will
// result in compilation errors.
type UnsafeTripServiceServer interface {
	mustEmbedUnimplementedTripServiceServer()
}

func RegisterTripServiceServer(s grpc.ServiceRegistrar, srv TripServiceServer) {
	s.RegisterService(&TripService_ServiceDesc, srv)
}

func _TripService_BookTrip_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BookTripRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TripServiceServer).BookTrip(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trip.TripService/book_trip",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TripServiceServer).BookTrip(ctx, req.(*BookTripRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TripService_GetTrip_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.StringValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TripServiceServer).GetTrip(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trip.TripService/get_trip",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TripServiceServer).GetTrip(ctx, req.(*wrapperspb.StringValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _TripService_GetTrips_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(wrapperspb.StringValue)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(TripServiceServer).GetTrips(m, &tripServiceGetTripsServer{stream})
}

type TripService_GetTripsServer interface {
	Send(*TripList) error
	grpc.ServerStream
}

type tripServiceGetTripsServer struct {
	grpc.ServerStream
}

func (x *tripServiceGetTripsServer) Send(m *TripList) error {
	return x.ServerStream.SendMsg(m)
}

func _TripService_DeleteTrip_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.StringValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TripServiceServer).DeleteTrip(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trip.TripService/delete_trip",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TripServiceServer).DeleteTrip(ctx, req.(*wrapperspb.StringValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _TripService_CancelTripEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.StringValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TripServiceServer).CancelTripEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trip.TripService/cancel_trip_event",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TripServiceServer).CancelTripEvent(ctx, req.(*wrapperspb.StringValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _TripService_StartTripEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.StringValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TripServiceServer).StartTripEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trip.TripService/start_trip_event",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TripServiceServer).StartTripEvent(ctx, req.(*wrapperspb.StringValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _TripService_CompleteTripEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(wrapperspb.StringValue)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TripServiceServer).CompleteTripEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trip.TripService/complete_trip_event",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TripServiceServer).CompleteTripEvent(ctx, req.(*wrapperspb.StringValue))
	}
	return interceptor(ctx, in, info, handler)
}

func _TripService_GetTripEvents_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(wrapperspb.StringValue)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(TripServiceServer).GetTripEvents(m, &tripServiceGetTripEventsServer{stream})
}

type TripService_GetTripEventsServer interface {
	Send(*TripEventList) error
	grpc.ServerStream
}

type tripServiceGetTripEventsServer struct {
	grpc.ServerStream
}

func (x *tripServiceGetTripEventsServer) Send(m *TripEventList) error {
	return x.ServerStream.SendMsg(m)
}

func _TripService_GetTripEvent_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(wrapperspb.StringValue)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(TripServiceServer).GetTripEvent(m, &tripServiceGetTripEventServer{stream})
}

type TripService_GetTripEventServer interface {
	Send(*TripEvent) error
	grpc.ServerStream
}

type tripServiceGetTripEventServer struct {
	grpc.ServerStream
}

func (x *tripServiceGetTripEventServer) Send(m *TripEvent) error {
	return x.ServerStream.SendMsg(m)
}

func _TripService_GetCandidatesForTrip_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(wrapperspb.StringValue)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(TripServiceServer).GetCandidatesForTrip(m, &tripServiceGetCandidatesForTripServer{stream})
}

type TripService_GetCandidatesForTripServer interface {
	Send(*TripCandidateList) error
	grpc.ServerStream
}

type tripServiceGetCandidatesForTripServer struct {
	grpc.ServerStream
}

func (x *tripServiceGetCandidatesForTripServer) Send(m *TripCandidateList) error {
	return x.ServerStream.SendMsg(m)
}

// TripService_ServiceDesc is the grpc.ServiceDesc for TripService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var TripService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "trip.TripService",
	HandlerType: (*TripServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "book_trip",
			Handler:    _TripService_BookTrip_Handler,
		},
		{
			MethodName: "get_trip",
			Handler:    _TripService_GetTrip_Handler,
		},
		{
			MethodName: "delete_trip",
			Handler:    _TripService_DeleteTrip_Handler,
		},
		{
			MethodName: "cancel_trip_event",
			Handler:    _TripService_CancelTripEvent_Handler,
		},
		{
			MethodName: "start_trip_event",
			Handler:    _TripService_StartTripEvent_Handler,
		},
		{
			MethodName: "complete_trip_event",
			Handler:    _TripService_CompleteTripEvent_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "get_trips",
			Handler:       _TripService_GetTrips_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "get_trip_events",
			Handler:       _TripService_GetTripEvents_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "get_trip_event",
			Handler:       _TripService_GetTripEvent_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "get_candidates_for_trip",
			Handler:       _TripService_GetCandidatesForTrip_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "trip.proto",
}
