#!/usr/bin/awk -f

### Script: url_decode.awk
##
## URL デコードする関数を定義する。
##
## Usage:
##
## ------ Text ------
## awk -f 'url_decode.awk'
## ------------------
##
## ------ Text ------
## @include "url_decode.awk"
## ------------------
##
## Metadata:
##
##   id - 63077be4-ad3a-47ca-8c0a-56c38d1059e9
##   author - <qq542vev at https://purl.org/meta/me/>
##   version - 1.0.0
##   date - 2022-09-02
##   since - 2022-07-26
##   copyright - Copyright (C) 2022-2022 qq542vev. Some rights reserved.
##   license - <CC-BY at https://creativecommons.org/licenses/by/4.0/>
##   package - w3mplus
##
## See Also:
##
##   * <Project homepage at https://github.com/qq542vev/w3mplus>
##   * <Bug report at https://github.com/qq542vev/w3mplus/issues>

### Function: url_decode
##
## URL エンコードされた文字列をデコードする。
##
## Parameters:
##
##   string - デコードする文字列。
##   httpEncode - '+' をスペースにデコードする。
##
## Returns:
##
##   デコードされた文字列。

function url_decode(string, httpDecode,  p2c,result) {
	split("", p2c)

	p2c["00"] = "\000"; p2c["01"] = "\001";
	p2c["02"] = "\002"; p2c["03"] = "\003";
	p2c["04"] = "\004"; p2c["05"] = "\005";
	p2c["06"] = "\006"; p2c["07"] = "\007";
	p2c["08"] = "\010"; p2c["09"] = "\011";
	p2c["0A"] = p2c["0a"] = "\012"; p2c["0B"] = p2c["0b"] = "\013";
	p2c["0C"] = p2c["0c"] = "\014"; p2c["0D"] = p2c["0d"] = "\015";
	p2c["0E"] = p2c["0e"] = "\016"; p2c["0F"] = p2c["0f"] = "\017";
	p2c["10"] = "\020"; p2c["11"] = "\021";
	p2c["12"] = "\022"; p2c["13"] = "\023";
	p2c["14"] = "\024"; p2c["15"] = "\025";
	p2c["16"] = "\026"; p2c["17"] = "\027";
	p2c["18"] = "\030"; p2c["19"] = "\031";
	p2c["1A"] = p2c["1a"] = "\032"; p2c["1B"] = p2c["1b"] = "\033";
	p2c["1C"] = p2c["1c"] = "\034"; p2c["1D"] = p2c["1d"] = "\035";
	p2c["1E"] = p2c["1e"] = "\036"; p2c["1F"] = p2c["1f"] = "\037";
	p2c["20"] = "\040"; p2c["21"] = "\041";
	p2c["22"] = "\042"; p2c["23"] = "\043";
	p2c["24"] = "\044"; p2c["25"] = "\045";
	p2c["26"] = "\046"; p2c["27"] = "\047";
	p2c["28"] = "\050"; p2c["29"] = "\051";
	p2c["2A"] = p2c["2a"] = "\052"; p2c["2B"] = p2c["2b"] = "\053";
	p2c["2C"] = p2c["2c"] = "\054";	p2c["2D"] = p2c["2d"] = "\055";
	p2c["2E"] = p2c["2e"] = "\056"; p2c["2F"] = p2c["2f"] = "\057";
	p2c["30"] = "\060"; p2c["31"] = "\061";
	p2c["32"] = "\062"; p2c["33"] = "\063";
	p2c["34"] = "\064"; p2c["35"] = "\065";
	p2c["36"] = "\066"; p2c["37"] = "\067";
	p2c["38"] = "\070"; p2c["39"] = "\071";
	p2c["3A"] = p2c["3a"] = "\072"; p2c["3B"] = p2c["3b"] = "\073";
	p2c["3C"] = p2c["3c"] = "\074"; p2c["3D"] = p2c["3d"] = "\075";
	p2c["3E"] = p2c["3e"] = "\076"; p2c["3F"] = p2c["3f"] = "\077";
	p2c["40"] = "\100"; p2c["41"] = "\101";
	p2c["42"] = "\102"; p2c["43"] = "\103";
	p2c["44"] = "\104"; p2c["45"] = "\105";
	p2c["46"] = "\106"; p2c["47"] = "\107";
	p2c["48"] = "\110"; p2c["49"] = "\111";
	p2c["4A"] = p2c["4a"] = "\112"; p2c["4B"] = p2c["4b"] = "\113";
	p2c["4C"] = p2c["4c"] = "\114"; p2c["4D"] = p2c["4d"] = "\115";
	p2c["4E"] = p2c["4e"] = "\116"; p2c["4F"] = p2c["4f"] = "\117";
	p2c["50"] = "\120"; p2c["51"] = "\121";
	p2c["52"] = "\122"; p2c["53"] = "\123";
	p2c["54"] = "\124"; p2c["55"] = "\125";
	p2c["56"] = "\126"; p2c["57"] = "\127";
	p2c["58"] = "\130"; p2c["59"] = "\131";
	p2c["5A"] = p2c["5a"] = "\132"; p2c["5B"] = p2c["5b"] = "\133";
	p2c["5C"] = p2c["5c"] = "\134"; p2c["5D"] = p2c["5d"] = "\135";
	p2c["5E"] = p2c["5e"] = "\136"; p2c["5F"] = p2c["5f"] = "\137";
	p2c["60"] = "\140"; p2c["61"] = "\141";
	p2c["62"] = "\142"; p2c["63"] = "\143";
	p2c["64"] = "\144"; p2c["65"] = "\145";
	p2c["66"] = "\146"; p2c["67"] = "\147";
	p2c["68"] = "\150"; p2c["69"] = "\151";
	p2c["6A"] = p2c["6a"] = "\152"; p2c["6B"] = p2c["6b"] = "\153";
	p2c["6C"] = p2c["6c"] = "\154"; p2c["6D"] = p2c["6d"] = "\155";
	p2c["6E"] = p2c["6e"] = "\156"; p2c["6F"] = p2c["6f"] = "\157";
	p2c["70"] = "\160"; p2c["71"] = "\161";
	p2c["72"] = "\162"; p2c["73"] = "\163";
	p2c["74"] = "\164"; p2c["75"] = "\165";
	p2c["76"] = "\166"; p2c["77"] = "\167";
	p2c["78"] = "\170"; p2c["79"] = "\171";
	p2c["7A"] = p2c["7a"] = "\172"; p2c["7B"] = p2c["7b"] = "\173";
	p2c["7C"] = p2c["7c"] = "\174"; p2c["7D"] = p2c["7d"] = "\175";
	p2c["7E"] = p2c["7e"] = "\176"; p2c["7F"] = p2c["7f"] = "\177";
	p2c["80"] = "\200"; p2c["81"] = "\201";
	p2c["82"] = "\202"; p2c["83"] = "\203";
	p2c["84"] = "\204"; p2c["85"] = "\205";
	p2c["86"] = "\206"; p2c["87"] = "\207";
	p2c["88"] = "\210"; p2c["89"] = "\211";
	p2c["8A"] = p2c["8a"] = "\212"; p2c["8B"] = p2c["8b"] = "\213";
	p2c["8C"] = p2c["8c"] = "\214"; p2c["8D"] = p2c["8d"] = "\215";
	p2c["8E"] = p2c["8e"] = "\216"; p2c["8F"] = p2c["8f"] = "\217";
	p2c["90"] = "\220"; p2c["91"] = "\221";
	p2c["92"] = "\222"; p2c["93"] = "\223";
	p2c["94"] = "\224"; p2c["95"] = "\225";
	p2c["96"] = "\226"; p2c["97"] = "\227";
	p2c["98"] = "\230"; p2c["99"] = "\231";
	p2c["9A"] = p2c["9a"] = "\232"; p2c["9B"] = p2c["9b"] = "\233";
	p2c["9C"] = p2c["9c"] = "\234"; p2c["9D"] = p2c["9d"] = "\235";
	p2c["9E"] = p2c["9e"] = "\236"; p2c["9F"] = p2c["9f"] = "\237";
	p2c["A0"] = p2c["a0"] = "\240"; p2c["A1"] = p2c["a1"] = "\241";
	p2c["A2"] = p2c["a2"] = "\242"; p2c["A3"] = p2c["a3"] = "\243";
	p2c["A4"] = p2c["a4"] = "\244"; p2c["A5"] = p2c["a5"] = "\245";
	p2c["A6"] = p2c["a6"] = "\246"; p2c["A7"] = p2c["a7"] = "\247";
	p2c["A8"] = p2c["a8"] = "\250"; p2c["A9"] = p2c["a9"] = "\251";
	p2c["AA"] = p2c["aA"] = p2c["Aa"] = p2c["aa"] = "\252";
	p2c["AB"] = p2c["aB"] = p2c["Ab"] = p2c["ab"] = "\253";
	p2c["AC"] = p2c["aC"] = p2c["Ac"] = p2c["ac"] = "\254";
	p2c["AD"] = p2c["aD"] = p2c["Ad"] = p2c["ad"] = "\255";
	p2c["AE"] = p2c["aE"] = p2c["Ae"] = p2c["ae"] = "\256";
	p2c["AF"] = p2c["aF"] = p2c["Af"] = p2c["af"] = "\257";
	p2c["B0"] = p2c["b0"] = "\260"; p2c["B1"] = p2c["b1"] = "\261";
	p2c["B2"] = p2c["b2"] = "\262"; p2c["B3"] = p2c["b3"] = "\263";
	p2c["B4"] = p2c["b4"] = "\264"; p2c["B5"] = p2c["b5"] = "\265";
	p2c["B6"] = p2c["b6"] = "\266"; p2c["B7"] = p2c["b7"] = "\267";
	p2c["B8"] = p2c["b8"] = "\270"; p2c["B9"] = p2c["b9"] = "\271";
	p2c["BA"] = p2c["bA"] = p2c["Ba"] = p2c["ba"] = "\272";
	p2c["BB"] = p2c["bB"] = p2c["Bb"] = p2c["bb"] = "\273";
	p2c["BC"] = p2c["bC"] = p2c["Bc"] = p2c["bc"] = "\274";
	p2c["BD"] = p2c["bD"] = p2c["Bd"] = p2c["bd"] = "\275";
	p2c["BE"] = p2c["bE"] = p2c["Be"] = p2c["be"] = "\276";
	p2c["BF"] = p2c["bF"] = p2c["Bf"] = p2c["bf"] = "\277";
	p2c["C0"] = p2c["c0"] = "\300"; p2c["C1"] = p2c["c1"] = "\301";
	p2c["C2"] = p2c["c2"] = "\302"; p2c["C3"] = p2c["c3"] = "\303";
	p2c["C4"] = p2c["c4"] = "\304"; p2c["C5"] = p2c["c5"] = "\305";
	p2c["C6"] = p2c["c6"] = "\306"; p2c["C7"] = p2c["c7"] = "\307";
	p2c["C8"] = p2c["c8"] = "\310"; p2c["C9"] = p2c["c9"] = "\311";
	p2c["CA"] = p2c["cA"] = p2c["Ca"] = p2c["ca"] = "\312";
	p2c["CB"] = p2c["cB"] = p2c["Cb"] = p2c["cb"] = "\313";
	p2c["CC"] = p2c["cC"] = p2c["Cc"] = p2c["cc"] = "\314";
	p2c["CD"] = p2c["cD"] = p2c["Cd"] = p2c["cd"] = "\315";
	p2c["CE"] = p2c["cE"] = p2c["Ce"] = p2c["ce"] = "\316";
	p2c["CF"] = p2c["cF"] = p2c["Cf"] = p2c["cf"] = "\317";
	p2c["D0"] = p2c["d0"] = "\320"; p2c["D1"] = p2c["d1"] = "\321";
	p2c["D2"] = p2c["d2"] = "\322"; p2c["D3"] = p2c["d3"] = "\323";
	p2c["D4"] = p2c["d4"] = "\324"; p2c["D5"] = p2c["d5"] = "\325";
	p2c["D6"] = p2c["d6"] = "\326"; p2c["D7"] = p2c["d7"] = "\327";
	p2c["D8"] = p2c["d8"] = "\330"; p2c["D9"] = p2c["d9"] = "\331";
	p2c["DA"] = p2c["dA"] = p2c["Da"] = p2c["da"] = "\332";
	p2c["DB"] = p2c["dB"] = p2c["Db"] = p2c["db"] = "\333";
	p2c["DC"] = p2c["dC"] = p2c["Dc"] = p2c["dc"] = "\334";
	p2c["DD"] = p2c["dD"] = p2c["Dd"] = p2c["dd"] = "\335";
	p2c["DE"] = p2c["dE"] = p2c["De"] = p2c["de"] = "\336";
	p2c["DF"] = p2c["dF"] = p2c["Df"] = p2c["df"] = "\337";
	p2c["E0"] = p2c["e0"] = "\340"; p2c["E1"] = p2c["e1"] = "\341";
	p2c["E2"] = p2c["e2"] = "\342"; p2c["E3"] = p2c["e3"] = "\343";
	p2c["E4"] = p2c["e4"] = "\344"; p2c["E5"] = p2c["e5"] = "\345";
	p2c["E6"] = p2c["e6"] = "\346"; p2c["E7"] = p2c["e7"] = "\347";
	p2c["E8"] = p2c["e8"] = "\350"; p2c["E9"] = p2c["e9"] = "\351";
	p2c["EA"] = p2c["eA"] = p2c["Ea"] = p2c["ea"] = "\352";
	p2c["EB"] = p2c["eB"] = p2c["Eb"] = p2c["eb"] = "\353";
	p2c["EC"] = p2c["eC"] = p2c["Ec"] = p2c["ec"] = "\354";
	p2c["ED"] = p2c["eD"] = p2c["Ed"] = p2c["ed"] = "\355";
	p2c["EE"] = p2c["eE"] = p2c["Ee"] = p2c["ee"] = "\356";
	p2c["EF"] = p2c["eF"] = p2c["Ef"] = p2c["ef"] = "\357";
	p2c["F0"] = p2c["f0"] = "\360"; p2c["F1"] = p2c["f1"] = "\361";
	p2c["F2"] = p2c["f2"] = "\362"; p2c["F3"] = p2c["f3"] = "\363";
	p2c["F4"] = p2c["f4"] = "\364"; p2c["F5"] = p2c["f5"] = "\365";
	p2c["F6"] = p2c["f6"] = "\366"; p2c["F7"] = p2c["f7"] = "\367";
	p2c["F8"] = p2c["f8"] = "\370"; p2c["F9"] = p2c["f9"] = "\371";
	p2c["FA"] = p2c["fA"] = p2c["Fa"] = p2c["fa"] = "\372";
	p2c["FB"] = p2c["fB"] = p2c["Fb"] = p2c["fb"] = "\373";
	p2c["FC"] = p2c["fC"] = p2c["Fc"] = p2c["fc"] = "\374";
	p2c["FD"] = p2c["fD"] = p2c["Fd"] = p2c["fd"] = "\375";
	p2c["FE"] = p2c["fE"] = p2c["Fe"] = p2c["fe"] = "\376";
	p2c["FF"] = p2c["fF"] = p2c["Ff"] = p2c["ff"] = "\377";

	if(httpDecode) {
		gsub(/\+/, " ", string)
	}

	for(result = ""; match(string, /%[0-9A-Fa-f]{2}/); string = substr(string, RSTART + RLENGTH)) {
		result = result substr(string, 1, RSTART - 1) p2c[substr(string, RSTART + 1, 2)]
	}

	return result string
}
