#!/usr/bin/awk -f

### Script: uri_check.awk
##
## URI であるか検査する関数を定義する。
##
## Usage:
##
## ------ Text ------
## awk -f 'uri_check.awk'
## ------------------
##
## ------ Text ------
## @include "uri_check.awk"
## ------------------
##
## Metadata:
##
##   id - a0ec5ae7-9110-4f38-bb20-f97e4c95575e
##   author - <qq542vev at https://purl.org/meta/me/>
##   version - 1.0.2
##   date - 2022-11-09
##   since - 2022-07-26
##   copyright - Copyright (C) 2022-2022 qq542vev. Some rights reserved.
##   license - <CC-BY at https://creativecommons.org/licenses/by/4.0/>
##   package - w3mplus
##
## See Also:
##
##   * <Project homepage at https://github.com/qq542vev/w3mplus>
##   * <Bug report at https://github.com/qq542vev/w3mplus/issues>

### Function: uri_check
##
## 文字列が URI であるか検査する。
##
## Parameters:
##
##   uri - 検査する文字列。
##   relative - 相対 URI を許可する。
##
## Returns:
##
##   0か1の真理値。

function uri_check(uri, relative) {
	# char = ALPHA / DIGIT / "-" / "." / "_" / "~" / "!" / "$" / "&" / "'" / "(" / ")" / "*" / "+" / "," / ";" / "="
	# [!$&-.0-;=A-Z_a-z~] = char
	# [!$&-.0-;=@-Z_a-z~] = char / ":" / "@"
	# [!$&-;=?-Z_a-z~] = char / "@" / "/" "?"

	if(relative) {
		return (uri ~ /^([A-Za-z][A-Za-z0-9+.-]*:)?(\/\/(([!$&-.0-;=A-Z_a-z~]|%[0-9A-Fa-f]{2})*@)?(\[(((([0-9A-F]{1,4}:){6}|::([0-9A-F]{1,4}:){5}|([0-9A-F]{1,4})?::([0-9A-F]{1,4}:){4}|(([0-9A-F]{1,4}:){0,1}[0-9A-F]{1,4})?::([0-9A-F]{1,4}:){3}|(([0-9A-F]{1,4}:){0,2}[0-9A-F]{1,4})?::([0-9A-F]{1,4}:){2}|(([0-9A-F]{1,4}:){0,3}[0-9A-F]{1,4})?::[0-9A-F]{1,4}:|(([0-9A-F]{1,4}:){0,4}[0-9A-F]{1,4})?::)([0-9A-F]{1,4}:[0-9A-F]{1,4}|(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))|(([0-9A-F]{1,4}:){0,5}[0-9A-F]{1,4})?::[0-9A-F]{1,4}|(([0-9A-F]{1,4}:){0,6}[0-9A-F]{1,4})?::)|v[0-9A-F]+\.[!$&-.0-;=A-Z_a-z~]+)\]|([A-Za-z0-9._~!$&'()*+,;=-]|%[0-9A-Fa-f]{2})*)(:[0-9]*)?(\/([!$&-.0-;=@-Z_a-z~]|%[0-9A-Fa-f]{2})*)*|\/(([!$&-.0-;=@-Z_a-z~]|%[0-9A-Fa-f]{2})+(\/([!$&-.0-;=@-Z_a-z~]|%[0-9A-Fa-f]{2})*)*)?|([!$&-.0-;=@-Z_a-z~]|%[0-9A-Fa-f]{2})+(\/([!$&-.0-;=@-Z_a-z~]|%[0-9A-Fa-f]{2})*)*|)(\?([!$&-;=?-Z_a-z~]|%[0-9A-Fa-f]{2})*)?(#([!$&-;=?-Z_a-z~]|%[0-9A-Fa-f]{2})*)?$/)
	} else {
		return (uri ~ /^[A-Za-z][A-Za-z0-9+.-]*:(\/\/(([!$&-.0-;=A-Z_a-z~]|%[0-9A-Fa-f]{2})*@)?(\[(((([0-9A-F]{1,4}:){6}|::([0-9A-F]{1,4}:){5}|([0-9A-F]{1,4})?::([0-9A-F]{1,4}:){4}|(([0-9A-F]{1,4}:){0,1}[0-9A-F]{1,4})?::([0-9A-F]{1,4}:){3}|(([0-9A-F]{1,4}:){0,2}[0-9A-F]{1,4})?::([0-9A-F]{1,4}:){2}|(([0-9A-F]{1,4}:){0,3}[0-9A-F]{1,4})?::[0-9A-F]{1,4}:|(([0-9A-F]{1,4}:){0,4}[0-9A-F]{1,4})?::)([0-9A-F]{1,4}:[0-9A-F]{1,4}|(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))|(([0-9A-F]{1,4}:){0,5}[0-9A-F]{1,4})?::[0-9A-F]{1,4}|(([0-9A-F]{1,4}:){0,6}[0-9A-F]{1,4})?::)|v[0-9A-F]+\.[!$&-.0-;=A-Z_a-z~]+)\]|([A-Za-z0-9._~!$&'()*+,;=-]|%[0-9A-Fa-f]{2})*)(:[0-9]*)?(\/([!$&-.0-;=@-Z_a-z~]|%[0-9A-Fa-f]{2})*)*|\/(([!$&-.0-;=@-Z_a-z~]|%[0-9A-Fa-f]{2})+(\/([!$&-.0-;=@-Z_a-z~]|%[0-9A-Fa-f]{2})*)*)?|([!$&-.0-;=@-Z_a-z~]|%[0-9A-Fa-f]{2})+(\/([!$&-.0-;=@-Z_a-z~]|%[0-9A-Fa-f]{2})*)*|)(\?([!$&-;=?-Z_a-z~]|%[0-9A-Fa-f]{2})*)?(#([!$&-;=?-Z_a-z~]|%[0-9A-Fa-f]{2})*)?$/)
	}
}
