---
id: 0e7d351e-f684-45a7-be38-9c552e4d3a53
title: w3mplus のマニュアル
description: w3mplus の利用方法及び機能についての解説。
author:
- name: qq542vev
  url: https://purl.org/meta/me/
created: 2022-08-17
modified: 2022-12-10
copyright: Copyright (C) 2022-2022 qq542vev. Some rights reserved.
license:
- name: CC-BY
  url: https://creativecommons.org/licenses/by/4.0/
lang: ja
...

# 初めに {#intro}

[w3mplus](https://github.com/qq542vev/w3mplus) は、[w3m](https://github.com/tats/w3m "GitHub - tats/w3m: Debian's w3m: WWW browsable pager") 用の無料ブラウザーアドオンで、ブラウジングをより効率的に、特にキーボード操作を容易にするために設計されている。[Pentadactyl](https://github.com/pentadactyl/pentadactyl "GitHub - pentadactyl/pentadactyl: Pentadactyl for Pale Moon (community maintained)"), [Pale Moon](https://www.palemoon.org/ "The Pale Moon Project homepage"), [Vim](https://www.vim.org/ "welcome home : vim online") に大きく影響され、指の感触はそれらユーザーには馴染み易い操作性となっている。

## 機能 {#features}

 * Pale Moon の模倣
   * メニューバー
   * ロケーションバー
   * コンテキストメニュー
   * Denylist
   * その他の細かな UI 関連
 * Pentadactyl の模倣
   * `o`, `t`, `O`, `T`, `gh`, `gu` などのリソースへのアクセス
   * `h`, `j`, `k`, `l`, `gg`, `G`, `0`, `$` などのページ内の移動
   * `y`, `Y` などのヤンク
   * `d`, `u` などのタブを閉じる、タブの復元
   * ヒント及び拡張ヒント
   * クイックマーク、ローカルマーク、URL マーク
   * レジスタ

## 連絡 {#contact}

質問、機能追加の要望、不具合の報告などは [Github issue](https://github.com/qq542vev/w3mplus/issues "Issues · qq542vev/w3mplus · GitHub") から受け付けている。

# ブラウジング {#surfing}

## Web ページを開く {#opening}

[`o`]{#key-o}, [`:o`]{#key-.3Ao}
: 現在のタブで任意の URL を開く。

[`t`]{#key-t}, [`:t`]{#key-.3At}
: 現在のタブで任意の URL を開く。

[`O`]{#key-O}
: 現在のタブで任意の URL を開く。(現在の URL が補完されている)

[`T`]{#key-T}
: 現在のタブで任意の URL を開く。(現在の URL が補完されている)

[`s`]{#key-s}
: 現在のタブで任意のキーワードを検索する。

[`S`]{#key-S}
: 新たなタブで任意のキーワードを検索する。

[`<C-t>d`]{#key-.3CC-t.3Ed}
: 現在のタブを複製する。

[`w`]{#key-w}
: 新たな w3m を開く。

[`W`]{#key-W}
: 現在の URL を外部ブラウザーで開く。

[`p`]{#key-p}
: 現在のカーソルの単語を現在のタブで検索する。

[`P`]{#key-P}
: 現在のカーソルの単語を新たなタブで検索する。

[`gP`]{#key-gP}
: 現在のカーソルの単語を新たなタブで検索し、元のタブに移動する。

[`<C-x>`]{#key-.3CC-x.3E}
: 現在の URL の最後の数値をデクリメントする。URL の末尾の数値にはしばしばハイフンが付くので、負の数はサポートされていない。

[`<C-a>`]{#key-.3CC-a.3E}
: 現在の URL の最後の数値をインクリメントする。

## 履歴 {#history}

[`[count]<C-o>`]{#key-.3CC-o.3E}
: カーソルの移動履歴を遡る。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`[count]<ESC-C-o>`]{#key-.3CESC-C-o.3E}
: カーソルの移動履歴を進める。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`:j`]{#key-.3Aj}
: 現在のタブの閲覧履歴のメニューを開く。

[`[count]H`]{#key-H}
: 現在のタブの閲覧履歴を遡る。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`[count]L`]{#key-L}
: 現在のタブの閲覧履歴を進める。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`:H`]{#key-.3AH}
: w3m の閲覧履歴を開く。

## ナビゲート {#navigating}

[`~`]{#key-.7E}
: 現在のタブでホームディレクトリを開く。

[`gh`]{#key-gh}
: 現在のタブでホームページを開く。

[`gH`]{#key-gH}
: 新たなタブでホームページを開く。

[`gu`]{#key-gu}
: 現在の URL の上位ディレクトリを開く。
: 例えば、http://www.example.com/dir1/dir2/file.htm の `gu` は http://www.example.com/dir1/dir2/ を開く。

[`gU`]{#key-gU}
: 現在の URL のルートディレクトリを開く。
: 例えば、http://www.example.com/dir1/dir2/file.htm の `gU` は http://www.example.com/ を開く。

## 再読み込み {#reloading}

[`r`]{#key-r}
: 現在の URL を再読み込みする。

## 停止 {#stopping}

[`<C-c>`]{#key-.3CC-c.3E}
: 画像の読み込みを中止する。

## 書き込み {#writing}

[`:w`]{#key-.3Aw}
: 現在のドキュメントのソースを保存する。

[`:W`]{#key-.3AW}
: 現在のドキュメントの表示内容を保存する。

## 終了 {#quitting}

[`:x`]{#key-.3Ax}, [`ZQ`]{#key-ZQ}
: 確認をなしに w3m を終了する。

[`:q`]{#key-.3Aq}, [`ZZ`]{#key-ZZ}
: w3m を終了する。

# バッファ {#buffer}

バッファとは、Web ページとその履歴やフレームを全て保持するコンテナである。各タブは正確に1つのバッファを含み、この2つの用語は殆どの用途で互換性がある。

## バッファ情報 {#buffer-information}

[`<C-g>`]{#key-.3CC-g.3E}, [`;?`]{#key-.3B.3F}
: 現在のカーソルの行数、列数、ドキュメントの文字エンコーディングを表示する。

[`g<C-g>`]{#key-g.3CC-g.3E}
: 現在のドキュメントの各種情報を表示する。

[`gf`]{#key-gf}
: レンダリングビューとソースビューを切り替る。

[`gF`]{#key-gF}
: 現在のドキュメントのソースを外部テキストエディタで開く。環境変数 [`EDITOR`](#env-EDITOR) でテキストエディタの変更が可能である。

## 移動コマンド {#motion}

[`0`]{#key-0}
: カーソルを現在の行の先頭に移動する。

[`^`]{#key-.5E}
: カーソルを現在の行の先頭の非空白文字に移動する。

[`$`]{#key-.24}
: カーソルを現在の行の末尾に移動する。

[`g_`]{#key-g_}
: カーソルを現在の行の末尾の非空白文字に移動する。

[`+`]{#key-.2B}
: カーソルを次の行の先頭の非空白文字に移動する。

[`-`]{#key--}
: カーソルを前の行の先頭の非空白文字に移動する。

[`[count]gg`]{#key-gg}, [`[count]<Home>`]{#key-.3CHome.3E}
: カーソルをドキュメントの最上部に移動する。`[count]` を指定した場合、`[count] - 1` の回数分カーソルを下に移動する。

[`G`]{#key-G}, [`<End>`]{#key-.3CEnd.3E}
: カーソルをドキュメントの最下部に移動する。

[`g:`]{#key-g.3A}
: カーソルを任意の行に移動する。

[`%`]{#key-.25}
: パーセントメニューを開く。任意のパーセント分カーソルを移動する。

[`[count]h`]{#key-h}, [`[count]<Left>`]{#key-.3CLeft.3E}
: カーソルを1列左に移動する。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`[count]j`]{#key-j}, [`[count]<Down>`]{#key-.3CDown.3E}
: カーソルを1行下に移動する。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`[count]k`]{#key-k}, [`[count]<Up>`]{#key-.3CUp.3E}
: カーソルを1行上に移動する。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`[count]l`]{#key-l}, [`[count]<Right>`]{#key-.3CRight.3E}
: カーソルを1列右に移動する。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`[count]gj`]{#key-gj}
: カーソルを1行下に移動する。

[`[count]gk`]{#key-gk}
: カーソルを1行上に移動する。

[`[count]<C-d>`]{#key-.3CC-d.3E}
: ドキュメントを半ページ下にスクロールする。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`[count]<C-u>`]{#key-.3CC-u.3E}
: ドキュメントを半ページ上にスクロールする。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`zH`]{#key-zH}
: ドキュメントを半ページ左にスクロールする。

[`zL`]{#key-zL}
: ドキュメントを半ページ右にスクロールする。

[`[count]<ESC-Space>`]{#key-.3CESC-Space.3E}, [`[count]<PageUp>`]{#key-.3CPageUp.3E}, [`[count]<C-b>`]{#key-.3CC-b.3E}
: 前のページにスクロールする。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`[count]<Space>`]{#key-.3CSpace.3E}, [`[count]<PageDown>`]{#key-.3CPageDown.3E}, [`[count]<C-f>`]{#key-.3CC-f.3E}
: 次のページにスクロールする。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`B`]{#key-B}
: カーソルを前の単語に移動する。

[`E`]{#key-E}
: カーソルを次の単語に移動する。

[`[count]<C-e>`]{#key-.3CC-e.3E}
: ドキュメントを1行下にスクロールする。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`[count]<C-y>`]{#key-.3CC-y.3E}
: ドキュメントを1行上にスクロールする。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`[count]zh`]{#key-zh}, [`[count]z<Left>`]{#key-z.3CLeft.3E}
: ドキュメントを1列左にスクロールする。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`[count]zl`]{#key-zl}, [`[count]z<Right>`]{#key-z.3CRight.3E}
: ドキュメントを1列右にスクロールする。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`zb`]{#key-zb}
: 現在の行を最下部にスクロールする。

[`zt`]{#key-zt}
: 現在の行を最上部にスクロールする。

[`z.`]{#key-z.2E}
: 現在の行を中央にスクロールし、カーソルを先頭の非空白文字に移動する。

[`zz`]{#key-zz}
: 現在の行を中央にスクロールする。

[`gM`]{#key-gM}
: 現在の列を中央にスクロールする。

## ジャンプ {#jumping}

[`[count]<Tab>`]{#key-.3CTab.3E}
: カーソルを次のリンクに移動する。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`[count]<ESC-Tab>`]{#key-.3CESC-Tab.3E}
: カーソルを前のリンクに移動する。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`gi`]{#key-gi}
: カーソルをインプットフィールドに移動する。

[`[[`]{#key-.5B.5B}
: カーソルを「前へ」のリンクに移動する。

[`]]`]{#key-.5D.5D}
: カーソルを「次へ」のリンクに移動する。

[`{`]{#key-.7B}
: カーソルを前の段落に移動する。

[`}`]{#key-.7D}
: カーソルを次の段落に移動する。

# ズーム {#zooming}

使用可能なズーム範囲は、環境変数 [`W3MPLUS_ZOOM_MIN`](#env-W3MPLUS_ZOOM_MIN), [`W3MPLUS_ZOOM_MAX`](#env-W3MPLUS_ZOOM_MAX) を設定することで変更が可能である。デフォルトのズーム範囲は30%から300%迄である。

[`ZI`]{#key-ZI}
: 画像の表示倍率を拡大する。

[`ZM`]{#key-ZM}
: 画像の表示倍率を大幅に拡大する。

[`ZO`]{#key-ZO}
: 画像の表示倍率を縮小する。

[`ZR`]{#key-ZR}
: 画像の表示倍率を大幅に縮小する。

[`zZ`]{#key-zZ}
: 画像の表示倍率をリセットする。

[`:z`]{#key-.3Az}
: ズームメニューを開く。

## フレーム {#frames}

[`:f`]{#key-.3Af}
: フレームの有効・無効を切り替える。

## テキストコピー {#copying}

テキストコピーの際に使用するプログラムは環境変数 [`W3MPLUS_YANK`](#env-W3MPLUS_YANK) を設定することで変更が可能である。

[`y`]{#key-y}
: 現在の URL をコピーする。

[`Y`]{#key-Y}
: 現在のカーソルの単語をコピーする。

[`V`]{#key-V}
: ビジュアルモードを開始・終了する。選択範囲をコピーする。

## レジスタ

[`"{0-9}`]{#key-.22.7B0-9.7D}
: 番号付きレジスタのメニューを開く。

[`"{a-z}`]{#key-.22.7Ba-z.7D}
: 名前付きレジスタのメニューを開く。

[`"{A-Z}`]{#key-.22.7BA-Z.7D}
: 値追加用名前付きレジスタのメニューを開く。

[`"%`]{#key-.22.25}
: 現在の URL のレジスタのメニューを開く。

[`"-`]{#key-.22-}
: 直前に閉じたタブの URL のレジスタのメニューを開く。

[`"/`]{#key-.22.2F}
: 直前の検索キーワードのレジスタのメニューを開く。

[`""`]{#key-.22.22}
: 直前に登録された値のレジスタのメニューを開く。

[`:"`]{#key-.3A.22}
: レジスタの一覧を表示する。

# コマンドラインモード {#command-line-mode}

コマンドラインモードは、恐らく最も強力なインターフェースである。このモードでは、ウィンドウの下部にあるコマンド入力バーがキーボードにフォーカスされ、様々な入力が可能になる。コマンドラインは、w3mplus と w3m の殆ど全ての機能を利用することが可能である。

[`::`]{#key-.3A.3A}
: 任意の w3m コマンドを実行する。

# 設定 {#options}

w3mplus は、特殊な効果を得るために設定が可能な変数やオプションを数多く持っている。これらのオプションは、以下のような形で提供される。

## 設定オプション {#set-option}

[`:s`]{#key-.3As}
: 任意の w3m オプションを設定する。

[`:p`]{#key-.3Ap}
: w3m のオプション設定パネルを開く。

[`:L`]{#key-.3AL}
: 任意の環境変数を設定する。

[`&`]{#key-.26}
: w3m オプションの切り替えメニューを開く。

## 環境変数 {#list-env}

w3mplus では以下の環境変数を使用する。環境変数を設定することで w3mplus の動作を変更が可能である。

当該環境変数が存在しないか、または空文字列の場合は、デフォルト値が使用される。

| 変数名 | 説明 | デフォルト値 |
| ------ | ---- | ------------- |
| [`BROWSER`]{#env-BROWSER} | 使用する Web ブラウザー。| `'w3m'` |
| [`VISUAL`]{#env-VISUAL} | 使用するテキストエディタ。 | `"${EDITOR}"` |
| [`EDITOR`]{#env-EDITOR} | 使用するテキストエディタ。 | `'vi --'` |
| [`MAILER`]{#env-MAILER} | 使用するメーラー。 | `'mutt --'` |
| [`PAGER`]{#env-PAGER} | 使用するページャー。 | `'less --'` |
| [`W3MPLUS_W3M_HOME`]{#env-W3MPLUS_W3M_HOME} | w3m の設定ファイルのディレクトリ。 | `"${HOME}/.w3m"` |
| [`W3MPLUS_W3M_BOOKMARK`]{#env-W3MPLUS_W3M_BOOKMARK} | w3m のブックマークファイル。 | `"${W3MPLUS_W3M_HOME}/bookmark.html"` |
| [`W3MPLUS_W3M_CONFIG`]{#env-W3MPLUS_W3M_CONFIG} | w3m の設定ファイル。 | `"${W3MPLUS_W3M_HOME}/config"` |
| [`W3MPLUS_W3M_HISTORY`]{#env-W3MPLUS_W3M_HISTORY} | w3m の閲覧履歴ファイル。 | `"${W3MPLUS_W3M_HOME}/history"` |
| [`W3MPLUS_W3M_SITECONF`]{#env-W3MPLUS_W3M_SITECONF} | w3m の Web サイト毎の設定ファイル。 | `"${W3MPLUS_W3M_HOME}/siteconf"` |
| [`W3MPLUS_HOME`]{#env-W3MPLUS_HOME} | w3mplus の設定ファイルのディレクトリ。 | `"${HOME}/.w3mplus"` |
| [`W3MPLUS_CACHE`]{#env-W3MPLUS_CACHE} | w3mplus のキャッシュを保存するディレクトリ。 | `"${W3MPLUS_HOME}/cache"` |
| [`W3MPLUS_PATH`]{#env-W3MPLUS_PATH} | w3mplus の実行ファイルのディレクトリ。 | `"${W3MPLUS_HOME}/bin"` |
| [`W3MPLUS_LIB`]{#env-W3MPLUS_LIB} | w3mplus のライブラリファイルのディレクトリ。 | `"${W3MPLUS_HOME}/lib"` |
| [`W3MPLUS_PASS_FILE`]{#env-W3MPLUS_PASS_FILE} | w3mplus のパスファイル。 | `"${W3MPLUS_HOME}/pass"` |
| [`W3MPLUS_YANK`]{#env-W3MPLUS_YANK} | コピーする際に起動するプログラム。 | `'v=$(cat; printf "_"); v="${v%_}"; "${HOME}/.w3mplus/bin/setreg" "+" "${v}"; exec 3>&1 >>"${HOME}/w3mplusyank"; date "+# %Y-%m-%d %H:%M:%S %Z"; echo "${v}"; exec 1>&3 3>&-'` |
| [`W3MPLUS_UNDO_TIMEOUT`]{#env-W3MPLUS_UNDO_TIMEOUT} | 復元するタブのタイムアウト秒数。 | `'+86400'` |
| [`W3MPLUS_UNDO_HISTSIZE`]{#env-W3MPLUS_UNDO_HISTSIZE} | 復元するタブの最大保存数。 | `'2000'` |
| [`W3MPLUS_UNDO_FILE`]{#env-W3MPLUS_UNDO_FILE} | 復元するタブを記録するファイル。 | `"${W3MPLUS_HOME}/tabrestore"` |
| [`W3MPLUS_VISUAL_TIMEOUT`]{#env-W3MPLUS_VISUAL_TIMEOUT} | ビジュアルモードでタイムアウトする秒数。 | `'+600'` |
| [`W3MPLUS_SEARCH_CONFIGFILE`]{#env-W3MPLUS_SEARCH_CONFIGFILE} | 検索エンジンの設定ファイル。 | `"${W3MPLUS_HOME}/search-config"` |
| [`W3MPLUS_SEARCH_ENGINE`]{#env-W3MPLUS_SEARCH_ENGINE} | 使用する検索エンジン名 | `'google'` |
| [`W3MPLUS_SEARCH_HISTSIZE`]{#env-W3MPLUS_SEARCH_HISTSIZE} | 検索履歴の最大保存数。 | `'2000'` |
| [`W3MPLUS_SEARCH_HISTFILE`]{#env-W3MPLUS_SEARCH_HISTFILE} | 検索履歴を記録するファイル。 | `"${W3MPLUS_HOME}/search-history"` |
| [`W3MPLUS_REGISTER_FILE`]{#env-W3MPLUS_REGISTER_FILE} | レジスタを記録するファイル。 | `"${W3MPLUS_HOME}/register"` |
| [`W3MPLUS_OPERATORFUNC`]{#env-W3MPLUS_OPERATORFUNC} | operatorfunc 用プログラム。 | `'cat'` |
| [`W3MPLUS_FORMATPRG`]{#env-W3MPLUS_FORMATPRG} | formatprg 用プログラム。 | `'cat'` |
| [`W3MPLUS_KEYWORDPRG`]{#env-W3MPLUS_KEYWORDPRG} | keywordprg 用プログラム。 | `'man "$(cat)"'` |
| [`W3MPLUS_EQUALPRG`]{#env-W3MPLUS_EQUALPRG} | equalprg 用プログラム。 | `'cat'` |
| [`W3MPLUS_ZOOM_MAX`]{#env-W3MPLUS_ZOOM_MAX} | 画像表示の最大倍率。 | `'300'` |
| [`W3MPLUS_ZOOM_MIN`]{#env-W3MPLUS_ZOOM_MIN} | 画像表示の最小倍率。 | `'30'` |
| [`W3MPLUS_QUICKMARK_FILE`]{#env-W3MPLUS_QUICKMARK_FILE} | クイックマークを記録するファイル。 | `"${W3MPLUS_HOME}/quickmark"` |
| [`W3MPLUS_LOCALMARK_FILE`]{#env-W3MPLUS_LOCALMARK_FILE} | ローカルマークを記録するファイル。 | `"${W3MPLUS_HOME}/localmark"` |
| [`W3MPLUS_URLMARK_FILE`]{#env-W3MPLUS_URLMARK_FILE} | URL マークを記録するファイル。 | `"${W3MPLUS_HOME}/urlmark"` |
| [`W3MPLUS_USERCOMMAND_FILE`]{#env-W3MPLUS_USERCOMMAND_FILE} | ユーザーコマンドを記録するファイル。 | `"${W3MPLUS_HOME}/usercommand"` |
| [`W3MPLUS_SIDEBAR_SIZE`]{#env-W3MPLUS_SIDEBAR_SIZE} | サイドバーのサイズ。 | `'200'` |
| [`W3MPLUS_SIDEBAR_POSITION`]{#env-W3MPLUS_SIDEBAR_POSITION} | サイドバーの位置。 | `'left'` |
| [`W3MPLUS_HTTP_PROGRAM`]{#env-W3MPLUS_HTTP_PROGRAM} | HTTP レスポンス用の呼び出しコマンド。 | |
| [`W3MPLUS_HTML_PROGRAM`]{#env-W3MPLUS_HTML_PROGRAM} | HTML 用の呼び出しコマンド。 | |
| [`W3MPLUS_FRAMESET_PROGRAM`]{#env-W3MPLUS_FRAMESET_PROGRAM} | HTML フレーム用の呼び出しコマンド。 | |

# ページ内検索 {#text-find-commands}

w3mplus は、Vim 風なインクリメンタル検索インターフェースを提供する。

[`/`]{#key-.2F}
: 任意のパターンを後方インクリメント検索する。

[`?`]{#key-.3F}
: 任意のパターンを前方インクリメント検索する。

[`n`]{#key-n}
: 次のパターンを検索する。

[`N`]{#key-N}
: 前のパターンを検索する。

[`#`]{#key-.23}
: 現在のカーソルの単語を後方検索する。

[`*`]{#key-.2A}
: 現在のカーソルの単語を前方検索する。

[`g#`]{#key-g.23}
: 現在のカーソルの単語を後方単語検索する。

[`g*`]{#key-g.2A}
: 現在のカーソルの単語を前方単語検索する。

# タブ {#tabs}

タブを使うと、同時に多くの Web ページを開いておき、素早く切り替えることが可能である。

## タブを開く {#opening-tabs}

[`<C-t>t`]{#key-.3CC-t.3Et}
: 新たなタブを開く。

## タブの変更 {#changing-tabs}

[`[count]gt`]{#key-gt}, [`[count]<C-n>`]{#key-.3CC-n.3E}
: 次のタブに移動する。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`[count]gT`]{#key-gT}, [`[count]<C-p>`]{#key-.3CC-p.3E}
: 前のタブに移動する。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`b`]{#key-b}
: タブの選択メニューを開く。

[`g0`]{#key-g0}
: 最初のタブに移動する。

[`g$`]{#key-g.24}
: 最後のタブに移動する。

## タブの並び替え {#reordering-tabs}

[`[count]<C-t>H`]{#key-.3CC-t.3EH}
: 現在のタブを左に移動する。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`[count]<C-t>L`]{#key-.3CC-t.3EL}
: 現在のタブを右に移動する。`[count]` を指定した場合、`[count]` の回数分繰り返す。

[`<C-t>0`]{#key-.3CC-t.3E0}
: 現在のタブを左端に移動する。

[`<C-t>$`]{#key-.3CC-t.3E.24}
: 現在のタブを右端に移動する。

## タブを閉じる {#closing-tabs}

[`d`]{#key-d}
: 現在のタブを閉じた後、右のタブに移動する。

[`D`]{#key-D}
: 現在のタブを閉じた後、左のタブに移動する。

[`<C-t>o`]{#key-.3CC-t.3Eo}
: 現在のタブ以外のタブを閉じる。

[`u`]{#key-u}
: 閉じたタブを復元する。

[`U`]{#key-U}
: 全ての閉じたタブを復元する。

[`:u`]{#key-.3Au}
: 閉じたタブの一覧を表示する。

# ヒント {#hints}

ヒントは、マウスを使わずに Web ページを操作するための簡単な方法である。ヒントモードではクリックが可能な全てのリンクをリストアップし、番号を表示する。

[`f`]{#key-f}
: リンク一覧のメニューを開く。

[`F`]{#key-F}
: 新たなタブでリンク一覧のメニューを開く。

[`;;`]{#key-.3B.3B}
: リンク一覧のメニューを開き、選択したリンクにカーソルを移動する。

# リンク {#links}

[`;s`]{#key-.3Bs}
: カーソルのリンク先を保存する。

[`;o`]{#key-.3Bo}
: カーソルのリンク先を開く。

[`;t`]{#key-.3Bt}
: カーソルのリンク先を新たなタブで開く。

[`;b`]{#key-.3Bb}
: カーソルのリンク先を新たなタブで開き、元のタブに移動する。

[`;w`]{#key-.3Bw}
: カーソルのリンク先を新たな w3m で開く。

[`;O`]{#key-.3BO}
: 現在のタブで任意の URL を開く。(リンクの URL が補完されている)

[`;T`]{#key-.3BT}
: 新たなタブで任意の URL を開く。(リンクの URL が補完されている)

[`;W`]{#key-.3BW}
: カーソルのリンク先を外部ブラウザーで開く。

[`;a`]{#key-.3Ba}
: カーソルのリンク先をブックマークに登録する。

[`;S`]{#key-.3BS}
: カーソルのリンクの URL を検索する。

[`;v`]{#key-.3Bv}
: カーソルのリンク先のソースを表示する。

[`;V`]{#key-.3BV}
: リンク先のソースを外部テキストエディタで開く。

[`;y`]{#key-.3By}
: カーソルのリンクの URL をコピーする。

[`;Y`]{#key-.3BY}
: 現在のカーソルの単語をコピーする。

[`;i`]{#key-.3Bi}
: カーソルの画像を表示する。

[`;I`]{#key-.3BI}
: カーソルの画像を保存する。

[`gx`]{#key-gx}
: カーソルの URL を開く。

# キーボードショートカット {#keyboard-shortcuts}

## w3mplus を回避する {#bypassing-w3mplus}

w3mplus は、Vim ユーザーが快適にブラウジングが可能なように、w3m のほぼ全てのキーを上書きする。w3mplus のキー操作を迂回するようにして、w3m モードや Pale Moon モードを利用するには幾つかの選択肢がある。

w3m モードではなく、lynx モードに切り替える事も可能である。その場合、`~/.w3m/keymap_builtin` に `~/.w3m/keymap_lynx` への、`~/.w3m/keymap_builtin-onetime` に `~/.w3m/keymap_lynx-onetime` へのシンボリックリンクを作成する。

[`<ESC-b>`]{#key-.3CESC-b.3E}
: キーマップを一時的に [w3m モード](#w3m-mode)に切り替える。キー入力後 w3mplus モードに戻る。

[`<ESC-C-b>`]{#key-.3CESC-C-b.3E}
: キーマップを [w3m モード](#w3m-mode)に切り替える。

[`<C-v>`]{#key-.3CC-v.3E}
: キーマップを一時的に [Pale Moon モード](#palemopon-mode)に切り替える。キー入力後 w3mplus モードに戻る。

[`<ESC-C-v>`]{#key-.3CESC-C-v.3E}
: キーマップを [Pale Moon モード](#palemopon-mode)に切り替える。

# マーク {#marks}

w3mplus は、後で簡単に戻ることができるように、様々な方法で URL やカーソル位置をマークすることが可能である。

 * w3m マークとブックマークは、w3m の標準的なマーク方法で、完全にサポートされている。
 * クイックマークは、キーボードショートカット（a-zA-z0-9）で異なる Web サイトを素早く保存し、戻ることが可能である。
 * ローカルマークは、現在の Web ページの位置を保存し、そこに戻ることが可能である。
 * URL マークは、現在の Web ページの位置と URL を保存し、そこに戻ることが可能である。

## w3m マーク {#w3mmark}

w3m マークは w3m よってサポートされている機能である。ドキュメント内の任意の箇所をマークし移動が可能である。

[`` m` ``]{#key-m.60}
: 現在のカーソル位置をマークする。

[`m@`]{#key-m.40}
: 正規表現にマッチする箇所をマークする。

[`` ]` ``]{#key-.5D.60}
: カーソルを次のマークに移動する。

[`` [` ``]{#key-.5B.60}
: カーソルを前のマークに移動する。

## ブックマーク {#bookmarks}

ブックマークは、w3m がサポートする最も伝統的なマークの一種である。ブックマークは、Pale Moon 風のブックマークメニューからもアクセスが可能である。

[`a`]{#key-a}
: 現在の URL をブックマークに登録する。

[`:b`]{#key-.3Ab}
: ブックマークの一覧を開く。

## クイックマーク {#quickmarks}

クイックマークは、よく訪れるページに素早くアクセスするための、無駄を省いたブックマークで、アルファベットや数字に URL を割り当てただけのものである。そのため、僅か3回のキー操作で保存したり開いたりすることが可能である。クイックマークはブラウザーのセッションを跨いで保持される。

[`M{0-9A-Za-z}`]{#key-M}
: 現在の URL をクイックマークに登録する。

[`go{0-9A-Za-z}`]{#key-go}
: 現在のタブで任意のクイックマークにを開く。

[`gn{0-9A-Za-z}`]{#key-gn}
: 新たなタブで任意のクイックマークにを開く。

[`:Q`]{#key-.3AQ}
: クイックマークの一覧を表示する。

## ローカルマークと URL マーク {#urlmarks}

ローカルマークと URL マークは、現在のカーソル位置をマークして、後ですぐに戻れるようにするためのものである。マークには其々の文字が割り当てられており、小文字はローカルマークとして、大文字は URL マークとして動作する。この2つの違いは、ローカルマークが各ページに一意的に適用されるのに対し、URL マークは特定のページの特定の位置をマークする。つまり、サイト1では **m** というマークがページの一番上に来るかもしれないが、サイト2では真ん中に来るかもしれない。一方、マーク **M** は常にサイト1に戻る。全てのマークは、ブラウザーのセッションを跨いで保持される。

[`m{a-z}`]{#key-m.7Ba-z.7D}
: 現在のカーソル位置をローカルマークに登録する。

[`m{A-Z}`]{#key-m.7BA-Z.7D}
: 現在のカーソル位置を URL マークに登録する。

[`` `{a-z} ``]{#key-.60.7Ba-z.7D}
: 任意のローカルマークを開く。

[`` `{A-Z} ``]{#key-.60.7BA-Z.7D}
: 任意の URL マークを開く。

[`'{a-z}`]{#key-.27.7Ba-z.7D}
: 任意のローカルマークを開き、カーソルを先頭の非空白文字に移動する。

[`'{A-Z}`]{#key-.27.7BA-Z.7D}
: 任意の URL マークを開き、カーソルを先頭の非空白文字に移動する。

[`:m`]{#key-.3Am}
: ローカルマークの一覧を表示する。

[`:M`]{#key-.3AM}
: URL マークの一覧を表示する。

# w3m UI {#ui}

## メニュー{#menu}

[`:e`]{#key-.3Ae}
: Pale Moon 風のメニューを開く。

[`;c`]{#key-.3Bc}
: コンテキストメニューを開く。

## ダイアログ {#dialogs}

[`:d`]{#key-.3Ad}
: ダウンロードリストを表示する。

# スタイル {#styling}

[`:C`]{#key-.3AC}
: スタイルメニューを開く。

# エラーとメッセージ {#messages}

[`:G]{#key-.3AG}
: メッセージを表示する。

# プライバシーと機密情報 {#privacy}

## プライベートブラウジング {#private-mode}

w3mplus は、Pale Moon のようなプライベートブラウジングモードに対応している。プライベートブラウジングモードでは、ブックマークと w3mplus 固有の機能(各種マーク、レジスタ、検索履歴など)以外は同期されない。プライベートブラウジングモード用のデータは一時的に環境変数 `TMP` で指定されたディレクトリ内に配置され、終了すると、閲覧履歴、キャッシュ、Cookie などの蓄積されたデータは全て消去される。

## Cookie の設定 {#cookie-settings}

[`:c`]{#key-.3Ac}
: Cookie の一覧を表示する。

# ページの編集 {#edit}

[`!`]{#key-.21}
: フィルターメニューを開く。選択範囲を任意のコマンドでフィルタリングする。

[`g~`]{#key-g.7E}
: 大文字・小文字の切り替えメニューを開く。選択範囲の大文字・小文字の切り替える。

[`g?`]{#key-g.3F}
: ROT13 のメニューを開く。選択範囲を ROT13 で暗号化する。

[`gq`]{#key-gq}
: 整形メニューを開く。選択範囲を環境変数 [`W3MPLUS_FORMATPRG`](#env-W3MPLUS_FORMATPRG) で処理する。

[`g@`]{#key-g.40}
: operatorfunc のメニューを開く。選択範囲を環境変数 [`W3MPLUS_OPERATORFUNC`](#env-W3MPLUS_OPERATORFUNC) で処理する。

[`K`]{#key-K}
: 現在のカーソルの単語を環境変数 [`W3MPLUS_KEYWORDPRG`](#env-W3MPLUS_KEYWORDPRG) で処理する。

[`=`]{#key-.3D}
: 現在のドキュメントのソースを環境変数 [`W3MPLUS_EQUALPRG`](#env-W3MPLUS_EQUALPRG) で編集する。

# その他のヘルプ {#other}

## 様々なコマンド {#various}

[`<C-l>`]{#key-.3CC-l.3E}
: 再描画する。

[`:<Tab>`]{#key-.3A.3CTab.3E}
: ':' で始まるコマンドの一覧を表示する。

[`g;`]{#key-g.3B}, [`;<Tab>`]{#key-.3B.3CTab.3E}
: ';' で始まるコマンドの一覧を表示する。

[`:!`]{#key-.3A.21}
: Shell コマンドを実行する。

[`:r`]{#key-.3Ar}
: Shell コマンドの実行結果を逐次表示する。

[`:S`]{#key-.3AS}
: Shell を開く

[`:v`]{#key-.3Av}
: w3m のバージョンを表示する。

## ヘルプ {#online-help}

[`:h`]{#key-.3Ah}
: w3mplus のヘルプドキュメントを開く。

[`:l`]{#key-.3Al}
: 一覧メニューを開く。

## 未分類ヘルプ {#uncategorized}

[`i`]{#key-i}, [`<Insert>`]{#key-.3CInsert.3E}
: バッファの内容を外部テキストエディタで開く。

[`<C-z>`]{#key-.3CC-z.3E}
: w3m を中断する。

# バージョン情報 {#version}

## v0.4.4 - 2022-12-10 {#v0.4.4}

 * プログラムがユーザーコマンドやテキストエディタを実行する際に、元々の LC_ALL の値を使用する。

## v0.4.3 - 2022-12-02 {#v0.4.3}

 * <about:cache> のバグを修正。
 * Local Mark のバグを修正。
 * 一部の環境変数名を変更。
 * 制御文字の除去に関するバグを修正。
 * URI の検査を高速化。

## v0.4.2 - 2022-09-27 {#v0.4.2}

 * 制御文字の除去に関するバグを修正。

## v0.4.1 - 2022-09-17 {#v0.4.1}

 * 閲覧履歴のサイドバーが動作しないのを修正。
 * ズーム機能が動作しないのを修正。
 * `~/.w3m` がシンボリックリンクの際に <about:cache> が動作しなくなるバグを修正。
 * HTML を生成する際に自動的に制御文字を削除するように変更。
 * `includefile` に `--verbose` オプションを追加。 
 * `includehelp` を追加。
 * ヘルプドキュメントと readme.md の文面を改善。
 * コマンドリファレンスに `--help` の出力内容を追加。

## v0.4.0 - 2022-09-07 {#v0.4.0}

 * ヘルプドキュメントの改善。CSS の追加。
 * `<F11>` でページャーを開く機能を追加。
 * `<F1>` でヘルプを開く機能を追加。
 * `:h` でヘルプドキュメントを開く機能に変更。

## v0.3.0 - 2022-09-01 {#v0.3.0}

 * ヘルプドキュメントを追加。
 * ほぼ全てのファイルに UUID を追加。
 * Shell Script のコメントを削除。
 * 設定(config)で既定値を優先。
 * w3m-private
   * ブックマークを同期。
   * シンボリックリンクによるバグを修正。
 * セーフモードを追加。
 * keymap
   * `M-[` による不具合を修正。
   * `+`, `-` をカーソルの行移動に変更。
   * `;S` でリンク URL を検索する機能を追加。
   * `'{A-Za-z}` でローカルマーク、URL マークの非空白先頭行に移動する機能を追加。
   * `` `' `` を ` `` ` に変更。
   * `:U`, `|` を削除。
   * `zH`, `zL` を半ページ左右に移動に変更。
   * `"-` に閉じたタブの URL のレジスタ機能を追加。
 * menu の名前をアンダースコアを含めたものに変更。
 * w3mplus
   * `add_printtmp` のバグを修正。
   * `QUERY_STRING` で定数値も使用可能に。
 * w3maction
   * `exec-shell`, `read-shell` の利用が可能に。

## v0.2.0 - 2022-07-31 {#v0.2.0}

ほぼ一から全てを書き直したバージョン。インストールファイルが追加されインストールが容易に。

## v0.1.0 - 2019-12-31 {#v0.1.0}

最初にリリースしたバージョン。

# 索引 {#index}

## w3mplus モード {#w3mplus-mode}

w3mplus モードは Pentadactyl + Pale Moon 風のキーマップである。w3mplus モードは [Pale Moon モード](#palemoon-mode)の上に構築されており、上書きされていない Pale Moon モードのキーも利用が可能である。

| キー | 説明 | w3m コマンド |
| ---- | ---- | ------------ |
| [`!`](#key-.21) | フィルターメニューを開く。 | |
| [`""`](#key-.22.22) | 直前に登録された値のレジスタのメニューを開く。 | |
| [`"%`](#key-.22.25) | 現在の URL のレジスタのメニューを開く。 | |
| [`"-`](#key-.22-) | 直前に閉じたタブの URL のレジスタのメニューを開く。 | |
| [`"/`](#key-.22.2F) | 直前の検索語句のレジスタのメニューを開く。 | |
| [`"{0-9}`](#key-.22.7B0-9.7D) | 番号付きレジスタのメニューを開く。 | |
| [`"{A-Z}`](#key-.22.7BA-Z.7D) | 値追加用名前付きレジスタのメニューを開く。 | |
| [`"{a-z}`](#key-.22.7Ba-z.7D) | 名前付きレジスタのメニューを開く。 | |
| [`#`](#key-.23) | 現在のカーソルの単語を後方検索する。 | |
| [`$`](#key-.24) | カーソルを現在の行の末尾に移動する。 | |
| [`%`](#key-.25) | パーセントメニューを開く。 | |
| [`&`](#key-.26) | w3m オプションの切り替えメニューを開く。 | |
| [`'{A-Z}`](#key-.27.7BA-Z.7D) | 任意の URL マークを開き、カーソルを先頭の非空白文字に移動する。 | |
| [`'{a-z}`](#key-.27.7Ba-z.7D) | 任意のローカルマークを開き、カーソルを先頭の非空白文字に移動する。 | |
| [`*`](#key-.2A) | 現在のカーソルの単語を前方検索する。 | |
| [`+`](#key-.2B) | カーソルを次の行の先頭の非空白文字に移動する。 | |
| [`-`](#key--) | カーソルを前の行の先頭の非空白文字に移動する。 | |
| [`/`](#key-.2F) | 任意のパターンを後方インクリメント検索する。 | `ISEARCH` |
| [`0`](#key-0) | カーソルを現在の行の先頭に移動する。 | `LINE_BEGIN` |
| [`:!`](#key-.3A.21) | Shell コマンドを実行する。 | `EXEC_SHELL` |
| [`:"`](#key-.3A.22) | レジスターの一覧を表示する。 | |
| [`::`](#key-.3A.3A) | 任意の w3m コマンドを実行する。 | `COMMAND` |
| [`:<Tab>`](#key-.3A.3CTab.3E) | ':' で始まるコマンドの一覧を表示する。 | |
| [`:C`](#key-.3AC) | スタイルメニューを開く。 | |
| [`:G`](#key-.3AG) | メッセージを表示する。 | `MSGS` |
| [`:H`](#key-.3AH) | w3m の閲覧履歴を開く。 | `HISTORY` |
| [`:L`](#key-.3AL) | 任意の環境変数を設定する。 | `SETENV` |
| [`:M`](#key-.3AM) | URL マークの一覧を表示する。 | |
| [`:Q`](#key-.3AQ) | クイックマークの一覧を表示する。 | |
| [`:S`](#key-.3AS) | Shell を開く。 | |
| [`:W`](#key-.3AW) | 現在のドキュメントの表示内容を保存する。 | `PRINT` |
| [`:b`](#key-.3Ab) | ブックマークの一覧を開く。 | `VIEW_BOOKMARK` |
| [`:c`](#key-.3Ac) | Cookie の一覧を表示する。 | `COOKIE` |
| [`:d`](#key-.3Ad) | ダウンロードリストを表示する。 | `DOWNLOAD_LIST` |
| [`:e`](#key-.3Ae) | Pale Moon 風のメニューを開く。 | |
| [`:f`](#key-.3Af) | フレームの有効・無効を切り替える。 | `FRAME` |
| [`:h`](#key-.3Ah) | w3mplus のヘルプドキュメントを開く。 | `HELP` |
| [`:j`](#key-.3Aj) | 現在のタブの閲覧履歴のメニューを開く。 | `SELECT_MENU` |
| [`:l`](#key-.3Al) | 一覧メニューを開く。 | |
| [`:m`](#key-.3Am) |ローカルマークの一覧を表示する。 | |
| [`:o`](#key-.3Ao) | 現在のタブで任意の URL を開く。 | |
| [`:p`](#key-.3Ap) | w3m のオプション設定パネルを開く。 | `OPTIONS` |
| [`:q`](#key-.3Aq) | w3m を終了する。 | `QUIT` |
| [`:r`](#key-.3Ar) | Shell コマンドの実行結果を逐次表示する。 | `PIPE_SHELL` |
| [`:s`](#key-.3As) | 任意の w3m オプションを設定する。 | `SET_OPTION` |
| [`:t`](#key-.3At) | 現在のタブで任意の URL を開く。 | |
| [`:u`](#key-.3Au) | 閉じたタブの一覧を表示する。 | |
| [`:v`](#key-.3Av) | w3m のバージョンを表示する。 | `VERSION` |
| [`:w`](#key-.3Aw) | 現在のドキュメントのソースを保存する。 | `DOWNLOAD` |
| [`:x`](#key-.3Ax) | 確認をなしに w3m を終了する。 | `EXIT` |
| [`:z`](#key-.3Az) | ズームメニューを開く。 | |
| [`;;`](#key-.3B.3B) | リンク一覧のメニューを開き、選択したリンクにカーソルを移動する。 | |
| [`;<Tab>`](#key-.3B.3CTab.3E) | ';' で始まるコマンドの一覧を表示する。 | |
| [`;?`](#key-.3B.3F) | 現在のカーソルの行数、列数、ドキュメントの文字エンコーディングを表示する。 | `LINE_INFO` |
| [`;I`](#key-.3BI) | カーソルの画像を保存する。 | `SAVE_IMAGE` |
| [`;O`](#key-.3BO) | 現在のタブで任意の URL を開く。(リンクの URL が補完されている) | |
| [`;T`](#key-.3BT) | 新たなタブで任意の URL を開く。(リンクの URL が補完されている) | |
| [`;S`](#key-.3BS) | カーソルのリンクの URL を検索する。 | |
| [`;V`](#key-.3BV) | リンク先のソースを外部テキストエディタで開く。 | |
| [`;W`](#key-.3BW) | カーソルのリンク先を外部ブラウザーで開く。 | `EXTERN_LINK` |
| [`;Y`](#key-.3BY) | 現在のカーソルの単語をコピーする。 | |
| [`;a`](#key-.3Ba) | カーソルのリンク先をブックマークに登録する。 | |
| [`;b`](#key-.3Bb) | カーソルのリンク先を新たなタブで開き、元のタブに移動する。 | |
| [`;c`](#key-.3Bc) | コンテキストメニューを開く。 | |
| [`;i`](#key-.3Bi) | カーソルの画像を表示する。 | `VIEW_IMAGE` |
| [`;o`](#key-.3Bo) | カーソルのリンク先を開く。 | `GOTO_LINK` |
| [`;s`](#key-.3Bs) | カーソルのリンク先を保存する。 | `SAVE_LINK` |
| [`;t`](#key-.3Bt) | カーソルのリンク先を新たなタブで開く。 | `TAB_LINK` |
| [`;v`](#key-.3Bv) | カーソルのリンク先のソースを表示する。 | |
| [`;w`](#key-.3Bw) | カーソルのリンク先を新たな w3m で開く。 | |
| [`;y`](#key-.3By) | カーソルのリンクの URL をコピーする。 | |
| [`<C-a>`](#key-.3CC-a.3E) | 現在の URL の最後の数値をインクリメントする。 | |
| [`<C-b>`](#key-.3CC-b.3E) | 前のページにスクロールする。 | `PREV_PAGE` |
| [`<C-c>`](#key-.3CC-c.3E) | 画像の読み込みを中止する。 | `STOP_IMAGE` |
| [`<C-d>`](#key-.3CC-d.3E) | ドキュメントを半ページ下にスクロールする。 | `NEXT_HALF_PAGE` |
| [`<C-e>`](#key-.3CC-e.3E) | ドキュメントを1行下にスクロールする。 | `UP` |
| [`<C-f>`](#key-.3CC-f.3E) | 次のページにスクロールする。 | `NEXT_PAGE` |
| [`<C-g>`](#key-.3CC-g.3E) | 現在のカーソルの行数、列数、ドキュメントの文字エンコーディングを表示する。 | `LINE_INFO` |
| [`<C-l>`](#key-.3CC-l.3E) | 再描画する。 | `REDRAW` |
| [`<C-n>`](#key-.3CC-n.3E) | 次のタブに移動する。 | `NEXT_TAB` |
| [`<C-o>`](#key-.3CC-o.3E) | カーソルの移動履歴を遡る。 | `UNDO` |
| [`<C-p>`](#key-.3CC-p.3E) | 前のタブに移動する。 | `PREV_TAB` |
| [`<C-t>$`](#key-.3CC-t.3E.24) | 現在のタブを右端に移動する。 | |
| [`<C-t>0`](#key-.3CC-t.3E0) | 現在のタブを左端に移動する。 | |
| [`<C-t>H`](#key-.3CC-t.3EH) | 現在のタブを左に移動する。 | `TAB_LEFT` |
| [`<C-t>L`](#key-.3CC-t.3EL) | 現在のタブを右に移動する。 | `TAB_RIGHT` |
| [`<C-t>d`](#key-.3CC-t.3Ed) | 現在のタブを複製する。 | `NEW_TAB` |
| [`<C-t>o`](#key-.3CC-t.3Eo) | 現在のタブ以外のタブを閉じる。 | |
| [`<C-t>t`](#key-.3CC-t.3Et) | 新たなタブを開く。 | |
| [`<C-u>`](#key-.3CC-u.3E) | ドキュメントを半ページ上にスクロールする。 | `PREV_HALF_PAGE` |
| [`<C-v>`](#key-.3CC-v.3E) | 一時的に Pale Moon 風のキーマップに切り替える。 | |
| [`<C-x>`](#key-.3CC-x.3E) | 現在の URL の最後の数値をデクリメントする。 | |
| [`<C-y>`](#key-.3CC-y.3E) | ドキュメントを1行上にスクロールする。 | `DOWN` |
| [`<C-z>`](#key-.3CC-z.3E) | w3m を中断する。 | `SUSPEND` |
| [`<Down>`](#key-.3CDown.3E) | カーソルを1行下に移動する。 | `MOVE_DOWN` |
| [`<ESC-C-b>`](#key-.3CESC-C-b.3E) | デフォルトのキーマップに切り替える。 | |
| [`<ESC-C-o>`](#key-.3CESC-C-o.3E) | カーソルの移動履歴を進める。 | `REDO` |
| [`<ESC-C-v>`](#key-.3CESC-C-v.3E) | Pale Moon 風のキーマップに切り替える。 | |
| [`<ESC-Space>`](#key-.3CESC-Space.3E) | 前のページにスクロールする。 | `PREV_PAGE` |
| [`<ESC-Tab>`](#key-.3CESC-Tab.3E) | カーソルを前のリンクに移動する。 | `PREV_LINK` |
| [`<ESC-b>`](#key-.3CESC-b.3E) | 一時的にデフォルトのキーマップに切り替える。 | |
| [`<End>`](#key-.3CEnd.3E) | カーソルをドキュメントの最下部に移動する。 | `END` |
| [`<Home>`](#key-.3CHome.3E) | カーソルをドキュメントの最上部に移動する。 | `BEGIN` |
| [`<Insert>`](#key-.3CInsert.3E) | バッファの内容を外部テキストエディタで開く。 | `EDIT_SCREEN` |
| [`<Left>`](#key-.3CLeft.3E) | カーソルを1列左に移動する。 | `MOVE_LEFT` |
| [`<PageDown>`](#key-.3CPageDown.3E) | 次のページにスクロールする。 | `NEXT_PAGE` |
| [`<PageUp>`](#key-.3CPageUp.3E) | 前のページにスクロールする。 | `PREV_PAGE` |
| [`<Right>`](#key-.3CRight.3E) | カーソルを1列右に移動する。 | `MOVE_RIGHT` |
| [`<Shift-Tab>`](#key-.3CShift-Tab.3E) | カーソルを前のリンクに移動する。 | `PREV_LINK` |
| [`<Space>`](#key-.3CSpace.3E) | 次のページにスクロールする。 | `NEXT_PAGE` |
| [`<Tab>`](#key-.3CTab.3E) | カーソルを次のリンクに移動する。 | `NEXT_LINK` |
| [`<Up>`](#key-.3CUp.3E) | カーソルを1行上に移動する。 | `MOVE_UP` |
| [`=`](#key-.3D) | 現在のドキュメントのソースを外部プログラムで編集する。 | |
| [`?`](#key-.3F) | 任意のパターンを前方インクリメント検索する。 | `ISEARCH_BACK` |
| [`B`](#key-B) | カーソルを前の単語に移動する。 | `PREV_WORD` |
| [`D`](#key-D) | 現在のタブを閉じた後、左のタブに移動する。 | |
| [`E`](#key-E) | カーソルを次の単語に移動する。 | `NEXT_WORD` |
| [`F`](#key-F) | 新たなタブでリンク一覧のメニューを開く。 | |
| [`G`](#key-G) | カーソルをドキュメントの最下部に移動する。 | `END` |
| [`H`](#key-H) | 現在のタブの閲覧履歴を遡る。 | `PREV` |
| [`K`](#key-K) | 現在のカーソルの単語を外部プログラムで処理する。 | |
| [`L`](#key-L) | 現在のタブの閲覧履歴を進める。 | `NEXT` |
| [`M{0-9A-Za-z}`](#key-M.7B0-9A-Za-z.7D) | 現在の URL をクイックマークに登録する 。 | |
| [`N`](#key-N) | 前のパターンを検索する。 | `SEARCH_PREV` |
| [`O`](#key-O) | 現在のタブで任意の URL を開く。(現在の URL が補完されている) | |
| [`P`](#key-P) | 現在のカーソルの単語を新たなタブで検索する。 | |
| [`S`](#key-S) | 新たなタブで任意のキーワードを検索する。 | |
| [`T`](#key-T) | 現在のタブで任意の URL を開く。(現在の URL が補完されている) | |
| [`U`](#key-U) | 全ての閉じたタブを復元する。 | |
| [`V`](#key-V) | ビジュアルモードを開始・終了する。 | |
| [`W`](#key-W) | 現在の URL を外部ブラウザーで開く。 | `EXTERN` |
| [`Y`](#key-Y) | 現在のカーソルの単語をコピーする。 | |
| [`ZI`](#key-ZI) | 画像の表示倍率を拡大する。 | |
| [`ZM`](#key-ZM) | 画像の表示倍率を大幅に拡大する。 | |
| [`ZO`](#key-ZO) | 画像の表示倍率を縮小する。 | |
| [`ZQ`](#key-ZQ) | 確認をなしに w3m を終了する。 | `EXIT` |
| [`ZR`](#key-ZR) | 画像の表示倍率を大幅に縮小する。 | |
| [`ZZ`](#key-ZZ) | w3m を終了する。 | `QUIT` |
| [`[[`](#key-.5B.5B) | カーソルを「前へ」のリンクに移動する。 | |
| [`` [` ``](#key-.5B.60) | カーソルを前のマークに移動する。 | `PREV_MARK` |
| [`` `{A-Z} ``](#key-.60.7BA-Z.7D) | 任意の URL マークを開く。 | |
| [`` `{a-z} ``](#key-.60.7Ba-z.7D) | 任意のローカルマークを開く。 | |
| [` `` `](#key-.60.60) | UNDO と REDO を切り替える。 | |
| [`` ]` ``](#key-.5D.60) | カーソルを次のマークに移動する。 | `NEXT_MARK` |
| [`]]`](#key-.5D.5D) | カーソルを「次へ」のリンクに移動する。 | |
| [`^`](#key-.5E) | カーソルを現在の行の先頭の非空白文字に移動する。 | |
| [`a`](#key-a) | 現在の URL をブックマークに登録する。 | `ADD_BOOKMARK` |
| [`b`](#key-b) | タブの選択メニューを開く。 | `TAB_MENU` |
| [`d`](#key-d) | 現在のタブを閉じた後、右のタブに移動する。 | |
| [`f`](#key-f) | リンク一覧のメニューを開く。 | `LIST_MENU` |
| [`g#`](#key-g.23) | 現在のカーソルの単語を後方単語検索する。 | |
| [`g$`](#key-g.24) | 最後のタブに移動する。 | |
| [`g*`](#key-g.2A) | 現在のカーソルの単語を前方単語検索する。 | |
| [`g0`](#key-g0) | 最初のタブに移動する。 | |
| [`g:`](#key-g.3A) | カーソルを任意の行に移動する。 | `GOTO_LINE` |
| [`g;`](#key-g.3B) | ';' で始まるコマンドの一覧を表示する。 | |
| [`g<C-g>`](#key-g.3CC-g.3E) | 現在のドキュメントの各種情報を表示する。 | `INFO` |
| [`g?`](#key-g.3F) | ROT13 のメニューを開く。 | |
| [`g@`](#key-g.40) | operatorfunc のメニューを開く。 | |
| [`gF`](#key-gF) | 現在のドキュメントのソースを外部テキストエディタで開く。 | |
| [`gH`](#key-gH) | 新たなタブでホームページを開く。 | |
| [`gM`](#key-gM) | 現在の列を中央にスクロールする。 | `CENTER_H` |
| [`gP`](#key-gP) | 現在のカーソルの単語を新たなタブで検索し、元のタブに移動する。 | |
| [`gT`](#key-gT) | 前のタブに移動する。 | `PREV_TAB` |
| [`gU`](#key-gU) | 現在 URL のルートディレクトリを開く。 | |
| [`g_`](#key-g_) | カーソルを現在の行の末尾の非空白文字に移動する。 | |
| [`gf`](#key-gf) | レンダリングビューとソースビューを切り替える。 | `VIEW` |
| [`gg`](#key-gg) | カーソルをドキュメントの最上部に移動する。 | `BEGIN` |
| [`gh`](#key-gh) | 現在のタブでホームページを開く。 | |
| [`gi`](#key-gi) | カーソルをインプットフィールドに移動する。 | |
| [`gj`](#key-gj) | カーソルを1行下に移動する。 | `MOVE_DOWN1` |
| [`gk`](#key-gk) | カーソルを1行上に移動する。 | `MOVE_UP1` |
| [`gn{0-9A-Za-z}`](#key-gn.7B0-9A-Za-z.7D) | 新たなタブで任意のクイックマークを開く。 | |
| [`go{0-9A-Za-z}`](#key-go.7B0-9A-Za-z.7D) | 現在のタブで任意のクイックマークを開く。 | |
| [`gq`](#key-gq) | 整形メニューを開く。 | |
| [`gt`](#key-gt) | 次のタブに移動する。 | `NEXT_TAB` |
| [`gu`](#key-gu) | 現在の URL の上位ディレクトリを開く。 | |
| [`gx`](#key-gx) | カーソルの URL を開く。 | |
| [`g~`](#key-g.7E) | 大文字・小文字の切り替えメニューを開く。 | |
| [`h`](#key-h) | カーソルを1列左に移動する。 | `MOVE_LEFT` |
| [`i`](#key-i) | バッファの内容を外部テキストエディタで開く。 | `EDIT_SCREEN` |
| [`j`](#key-j) | カーソルを1行下に移動する。 | `MOVE_DOWN` |
| [`k`](#key-k) | カーソルを1行上に移動する。 | `MOVE_UP` |
| [`l`](#key-l) | カーソルを1列右に移動する。 | `MOVE_RIGHT` |
| [`m@`](#key-m.40) | 正規表現にマッチする箇所をマークする。 | `REG_MARK` |
| [`m{A-Z}`](#key-m.7BA-Z.7D) | 現在のカーソル位置を URL マークに登録する。 | |
| [`m{a-z}`](#key-m.7Ba-z.7D) | 現在のカーソル位置をローカルマークに登録する。 | |
| [`` m` ``](#key-m.60) | 現在のカーソル位置をマークする。 | `MARK` |
| [`n`](#key-n) | 次のパターンを検索する。 | `SEARCH_NEXT` |
| [`o`](#key-o) | 現在のタブで任意の URL を開く。 | |
| [`p`](#key-p) | 現在のカーソルの単語を現在のタブで検索する。 | |
| [`r`](#key-r) | 現在の URL を再読み込みする。 | `RELOAD` |
| [`s`](#key-s) | 現在のタブで任意のキーワードを検索する。 | |
| [`t`](#key-t) | 現在のタブで任意の URL を開く。 | |
| [`u`](#key-u) | 閉じたタブを復元する。 | |
| [`w`](#key-w) | 新たな w3m を開く。 | |
| [`y`](#key-y) | 現在の URL をコピーする。 | |
| [`z.`](#key-z.2E) | 現在の行を中央にスクロールし、カーソルを先頭の非空白文字に移動する。 | |
| [`z<Left>`](#key-z.3CLeft.3E) | ドキュメントを1列左にスクロールする。 | `LEFT` |
| [`z<Right>`](#key-z.3CRight.3E) | ドキュメントを1列右にスクロールする。 | `RIGHT` |
| [`zH`](#key-zH) | ドキュメントを半ページ左にスクロールする。 | |
| [`zL`](#key-zL) | ドキュメントを半ページ右にスクロールする。 | |
| [`zZ`](#key-zZ) | 画像の表示倍率をリセットする。 | |
| [`zb`](#key-zb) | 現在の行を最下部にスクロールする。 | |
| [`zh`](#key-zh) | ドキュメントを1列左にスクロールする。 | `LEFT` |
| [`zl`](#key-zl) | ドキュメントを1列右にスクロールする。 | `RIGHT` |
| [`zt`](#key-zt) | 現在の行を最上部にスクロールする。 | |
| [`zz`](#key-zz) | 現在の行を中央にスクロールする。 | `CENTER_V` |
| [`{`](#key-.7B) | カーソルを前の段落に移動する。 | |
| [`}`](#key-.7D) | カーソルを次の段落に移動する。 | |
| [`~`](#key-.7E) | 現在のタブでホームディレクトリを開く。 | |

## Pale Moon モード {#palemoon-mode}

Pale Moon モードは [Pale Moon](https://www.palemoon.org/ "The Pale Moon Project homepage") 風のキーマップである。

| キー | 説明 | w3m コマンド |
| ---- | ---- | ------------ |
| `'` | リンク一覧のメニューを開く。 | `LIST_MENU` |
| `/` | 任意のパターンを後方インクリメント検索する。 | `ISEARCH` |
| `<C-b>` | ブックマークのサイドバーを開く。 | |
| `<C-c>` | 現在のカーソルの単語をコピーする。 | |
| `<C-d>` | 現在の URL をブックマークに登録する。 | `ADD_BOOKMARK` |
| `<C-e>` | 新たなタブで任意のキーワードを検索する。 | |
| `<C-f>` | 任意のパターンを後方検索する。 | `SEARCH` |
| `<C-g>` | 次のパターンを検索する。 | `SEARCH_NEXT` |
| `<C-h>` | 閲覧履歴のサイドバーを開く。 | |
| `<C-j>` | カーソルのリンク先を開く。 | `GOTO_LINK` |
| `<C-k>` | 現在のタブで任意のキーワードを検索する。 | |
| `<C-l>` | 現在のタブで任意の URL を開く。(現在の URL が補完されている) | |
| `<C-m>` | カーソルのリンク先を開く。 | `GOTO_LINK` |
| `<C-n>` | 新たな w3m を開く。 | |
| `<C-o>` | ローカルファイルを開く。 | `LOAD` |
| `<C-p>` | 現在のドキュメントの表示内容を保存する。 | `PRINT` |
| `<C-q>` | 確認をなしに w3m を終了する。 | `EXIT` |
| `<C-r>` | 現在の URL を再読み込みする。 | `RELOAD` |
| `<C-s>` | 現在のドキュメントのソースを保存する。 | `DOWNLOAD` |
| `<C-t>` | 新たなタブを開く。 | |
| `<C-u>` | レンダリングビューとソースビューを切り替える。 | `VIEW` |
| `<C-v>` | 現在のカーソルの単語を現在のタブで検索する。 | |
| `<C-w>` | 現在のタブを閉じる。 | |
| `<C-y>` | カーソルの移動履歴を進める。 | `REDO` |
| `<C-z>` | カーソルの移動履歴を遡る。 | `UNDO` |
| `<Del>` | 現在のタブの閲覧履歴を遡る。 | `PREV` |
| `<Down>` | カーソルを1行下に移動する。 | `MOVE_DOWN` |
| `<ESC-1>` | 1番目のタブに移動する。 | |
| `<ESC-2>` | 2番目のタブに移動する。 | |
| `<ESC-3>` | 3番目のタブに移動する。 | |
| `<ESC-4>` | 4番目のタブに移動する。 | |
| `<ESC-5>` | 5番目のタブに移動する。 | |
| `<ESC-6>` | 6番目のタブに移動する。 | |
| `<ESC-7>` | 7番目のタブに移動する。 | |
| `<ESC-8>` | 8番目のタブに移動する。 | |
| `<ESC-9>` | 9番目のタブに移動する。 | |
| `<ESC-C-b>` | ブックマークの一覧を開く。 | `BOOKMARK` |
| `<ESC-C-d>` | w3m を中断する。 | `SUSPEND` |
| `<ESC-C-g>` | 前のパターンを検索する。 | `SEARCH_PREV` |
| `<ESC-C-h>` | w3m の閲覧履歴を開く。 | `HISTORY` |
| `<ESC-C-j>` | カーソルのリンク先を保存する。 | `SAVE_LINK` |
| `<ESC-C-k>` | ドキュメントの表示内容を Shell で処理する。 | `PIPE_BUF` |
| `<ESC-C-m>` | カーソルのリンク先を保存する。 | `SAVE_LINK` |
| `<ESC-C-p>` | プライベートモードの w3m を開く。 | |
| `<ESC-C-q>` | request.log を開く。 | |
| `<ESC-C-t>` | 閉じたタブを復元する。 | |
| `<ESC-C-v>` | w3mplus のキーマップに切り替える。 | |
| `<ESC-C-w>` | w3m を終了する。 | `QUIT` |
| `<ESC-C-y>` | ダウンロードリストを表示する。 | `DOWNLOAD_LIST` |
| `<ESC-Del>` | 現在のタブの閲覧履歴を進める。 | `NEXT` |
| `<ESC-Space>` | 前のページにスクロールする。 | `PREV_PAGE` |
| `<ESC-Tab>` | カーソルを前のリンクに移動する。 | `PREV_LINK` |
| `<ESC-b>` | ブックマークメニューを開く。 | |
| `<ESC-d>` | 現在の URL を基に現在のタブで任意の URL を開く。 | |
| `<ESC-e>` | 編集メニューを開く。 | |
| `<ESC-f>` | ファイルメニューを開く。 | |
| `<ESC-h>` | ヘルプメニューを開く。 | |
| `<ESC-s>` | 履歴メニューを開く。 | |
| `<ESC-t>` | ツールメニューを開く。 | |
| `<ESC-v>` | 表示メニューを開く。 | |
| `<End>` | カーソルをドキュメントの最下部に移動する。 | `END` |
| `<F10>` | Pale Moon 風のメニューを開く。 | |
| `<F11>` | ページャーで現在のドキュメントを開く。 | |
| `<F12>` | 開発者用メニューを開く。 | |
| `<F14>` | 任意の w3m コマンドを実行する。 | `COMMAND` |
| `<F15>` | 前のパターンを検索する。 | `SEARCH_PREV` |
| `<F16>` | Shell コマンドを実行する。 | `EXEC_SHELL` |
| `<F1>` | ヘルプページを開く。 | `HELP` |
| `<F3>` | 次のパターンを検索する。 | `SEARCH_NEXT` |
| `<F4>` | 検索プロンプトのメニューを開く。 | |
| `<F5>` | 現在の URL を再読み込みする。 | `RELOAD` |
| `<F6>` | 現在のタブで任意の URL を開く。(現在の URL が補完されている) | |
| `<F7>` | バッファの内容を外部テキストエディタで開く。 | `EDIT_SCREEN` |
| `<Home>` | カーソルをドキュメントの最上部に移動する。 | `BEGIN` |
| `<Left>` | カーソルを1列左に移動する。 | `MOVE_LEFT` |
| `<PageDown>` | 次のページにスクロールする。 | `NEXT_PAGE` |
| `<PageUp>` | 前のページにスクロールする。 | `PREV_PAGE` |
| `<Right>` | カーソルを1列右に移動する。 | `MOVE_RIGHT` |
| `<Shift-Tab>` | カーソルを前のリンクに移動する。 | |
| `<Space>` | 次のページにスクロールする。 | `NEXT_PAGE` |
| `<Tab>` | カーソルを次のリンクに移動する。 | `NEXT_LINK` |
| `<Up>` | カーソルを1行上に移動する。 | `MOVE_UP` |

## w3m モード {#w3m-mode}

w3m モードは [w3m](https://github.com/tats/w3m "GitHub - tats/w3m: Debian's w3m: WWW browsable pager") 風のキーマップである。

| キー | 説明 | w3m コマンド |
| ---- | ---- | ------------ |
| `!` | Shell コマンドを実行する。 | `SHELL` |
| `"` | 正規表現にマッチする箇所をマークする。 | `REG_MARK` |
| `#` | Shell コマンドの実行結果を逐次表示する。 | `PIPE_SHELL` |
| `$` | カーソルを現在の行の末尾に移動する。 | `LINE_END` |
| `(` | カーソルの移動履歴を遡る。 | `UNDO` |
| `)` | カーソルの移動履歴を進める。 | `REDO` |
| `+` | 次のページにスクロールする。 | `NEXT_PAGE` |
| `,` | ドキュメントを1列左にスクロールする。 | `LEFT` |
| `-` | 前のページにスクロールする。 | `PREV_PAGE` |
| `.` | ドキュメントを1列右にスクロールする。 | `RIGHT` |
| `/` | 任意のパターンを後方検索する。 | `SEARCH` |
| `:` | URL 文字列をリンクに変換する。 | `MARK_URL` |
| `;` | 現在のカーソルの単語をリンクに変換する。 | `MARK_WORD` |
| `<C-@>` | 現在のカーソル位置をマークする。 | `MARK` |
| `<C-a>` | カーソルを現在の行の先頭に移動する。 | `LINE_BEGIN` |
| `<C-b>` | カーソルを1列左に移動する。 | `MOVE_LEFT` |
| `<C-e>` | カーソルを現在の行の末尾に移動する。 | `LINE_END` |
| `<C-f>` | カーソルを1列右に移動する。 | `MOVE_RIGHT` |
| `<C-g>` | 現在のカーソルの行数、列数、ドキュメントの文字エンコーディングを表示する。 | `LINE_INFO` |
| `<C-h>` | w3m の閲覧履歴を開く。 | `HISTORY` |
| `<C-j>` | カーソルのリンク先を開く。 | `GOTO_LINK` |
| `<C-k>` | Cookie の一覧を表示する。 | `COOKIE` |
| `<C-l>` | 再描画する。 | `REDRAW` |
| `<C-m>` | カーソルのリンク先を開く。 | `GOTO_LINK` |
| `<C-n>` | カーソルを1行下に移動する。 | `MOVE_DOWN` |
| `<C-p>` | カーソルを1行上に移動する。 | `MOVE_UP` |
| `<C-q>` | 現在のタブを閉じる。 | `CLOSE_TAB` |
| `<C-r>` | 任意のパターンを前方インクリメント検索する。 | `ISEARCH_BACK` |
| `<C-s>` | 任意のパターンを後方インクリメント検索する。 | `ISEARCH` |
| `<C-t>` | カーソルのリンク先を新たなタブで開く。 | `TAB_LINK` |
| `<C-u>` | カーソルを前のリンクに移動する。 | `PREV_LINK` |
| `<C-v>` | 次のページにスクロールする。 | `NEXT_PAGE` |
| `<C-w>` | 折り返し検索の有効・無効を切り替える。 | `WRAP_TOGGLE` |
| `<C-z>` | w3m を中断する。 | `SUSPEND` |
| `<Down>` | カーソルを1行下に移動する。 | `MOVE_DOWN` |
| `<ESC-:>` | Message-ID 風の文字列を news: のリンクにする。 | `MARK_MID` |
| `<ESC-<>` | カーソルをドキュメントの最上部に移動する。 | `BEGIN` |
| `<ESC->>` | カーソルをドキュメントの最下部に移動する。 | `END` |
| `<ESC-C-b>` | w3mplus のキーマップに切り替える。 | |
| `<ESC-C-j>` | カーソルのリンク先を保存する。 | `SAVE_LINK` |
| `<ESC-C-m>` | カーソルのリンク先を保存する。 | `SAVE_LINK` |
| `<ESC-I>` | カーソルの画像を保存する。 | `SAVE_IMAGE` |
| `<ESC-M>` | カーソルのリンク先を外部ブラウザーで開く。 | `EXTERN_LINK` |
| `<ESC-Tab>` | カーソルを前のリンクに移動する。 | `PREV_LINK` |
| `<ESC-W>` | 現在のカーソルの単語を現在のタブで検索する。 | `DICT_WORD_AT` |
| `<ESC-[1~>` | カーソルをドキュメントの最上部に移動する。 | `BEGIN` |
| `<ESC-[28~>` | デフォルトメニューを開く。 | `MENU` |
| `<ESC-[2~>` | デフォルトメニューを開く。 | `MENU` |
| `<ESC-[4~>` | カーソルをドキュメントの最下部に移動する。 | `END` |
| `<ESC-[5~>` | 前のページにスクロールする。 | `PREV_PAGE` |
| `<ESC-[6~>` | 次のページにスクロールする。 | `NEXT_PAGE` |
| `<ESC-[E>` | デフォルトメニューを開く。 | `MENU` |
| `<ESC-[L>` | デフォルトメニューを開く。 | `MENU` |
| `<ESC-[Z>` | カーソルを前のリンクに移動する。 | `PREV_LINK` |
| `<ESC-a>` | 現在の URL をブックマークに登録する。 | `ADD_BOOKMARK` |
| `<ESC-b>` | ブックマークの一覧を開く。 | `BOOKMARK` |
| `<ESC-c>` | 任意の w3m コマンドを実行する。 | `COMMAND` |
| `<ESC-e>` | バッファの内容を外部テキストエディタで開く。 | `EDIT_SCREEN` |
| `<ESC-g>` | カーソルを任意の行に移動する。 | `GOTO_LINE` |
| `<ESC-k>` | キーマップを定義する。 | `DEFINE_KEY` |
| `<ESC-l>` | リンク一覧のメニューを開く。 | `LIST_MENU` |
| `<ESC-m>` | リンク一覧のメニューを開き、リンクにカーソルを移動する。 | `MOVE_LIST_MENU` |
| `<ESC-n>` | カーソルを次のマークに移動する。 | `NEXT_MARK` |
| `<ESC-o>` | 任意の w3m オプションを設定する。 | `SET_OPTION` |
| `<ESC-p>` | カーソルを前のマークに移動する。 | `PREV_MARK` |
| `<ESC-s>` | ドキュメントのソースを保存する。 | `SAVE` |
| `<ESC-t>` | タブの選択メニューを開く。 | `TAB_MENU` |
| `<ESC-u>` | 相対 URL を開く。 | `GOTO_RELATIVE` |
| `<ESC-v>` | 前のページにスクロールする。 | `PREV_PAGE` |
| `<ESC-w>` | 任意のキーワードを検索する。 | `DICT_WORD` |
| `<Left>` | カーソルを1列左に移動する。 | `MOVE_LEFT` |
| `<Right>` | カーソルを1列右に移動する。 | `MOVE_RIGHT` |
| `<Space>` | 次のページにスクロールする。 | `NEXT_PAGE` |
| `<Tab>` | カーソルを次のリンクに移動する。 | `NEXT_LINK` |
| `<Up>` | カーソルを1行上に移動する。 | `MOVE_UP` |
| `<` | ドキュメントを1ページ左にスクロールする。 | `SHIFT_LEFT` |
| `=` | 現在のドキュメントの各種情報を表示する。 | `INFO` |
| `>` | ドキュメントを1ページ右にスクロールする。 | `SHIFT_RIGHT` |
| `?` | 任意のパターンを前方検索する。 | `SEARCH_BACK` |
| `@` | Shell コマンドの実行結果を表示する。 | `READ_SHELL` |
| `B` | 一つ前のバッファーを表示する。 | `BACK` |
| `D` | ダウンロードリストを表示する。 | `DOWNLOAD_LIST` |
| `E` | ドキュメントのソースを編集する。 | `EDIT` |
| `F` | フレームの有効・無効を切り替える。 | `FRAME` |
| `G` | カーソルをドキュメントの最下部に移動する。 | `END` |
| `H` | ヘルプページを開く。 | `HELP` |
| `I` | カーソルの画像を表示する。 | `VIEW_IMAGE` |
| `J` | ドキュメントを1行下にスクロールする。 | `UP` |
| `K` | ドキュメントを1行上にスクロールする。 | `DOWN` |
| `L` | 現在のドキュメントのリンクと画像の一覧を表示する。 | `LIST` |
| `M` | 現在の URL を外部ブラウザーで開く。 | `EXTERN` |
| `N` | 前のパターンを検索する。 | `SEARCH_PREV` |
| `Q` | 確認をなしに w3m を終了する。 | `EXIT` |
| `R` | 現在の URL を再読み込みする。 | `RELOAD` |
| `S` | ドキュメントの表示内容を保存する。 | `SAVE_SCREEN` |
| `T` | 現在のタブを複製する。 | `NEW_TAB` |
| `U` | 現在のタブで任意の URL を開く。 | `GOTO` |
| `V` | ローカルファイルを開く。 | `LOAD` |
| `W` | カーソルを前の単語に移動する。 | `PREV_WORD` |
| `Z` | 現在の列を中央にスクロールする。 | `CENTER_H` |
| `[` | カーソルを現在の行の末尾に移動する。 | `LINK_BEGIN` |
| `]` | カーソルを現在の行の先頭に移動する。 | `LINK_END` |
| `^` | カーソルを現在の行の先頭に移動する。 | `LINE_BEGIN` |
| `a` | カーソルのリンク先を保存する。 | `SAVE_LINK` |
| `b` | 前のページにスクロールする。 | `PREV_PAGE` |
| `c` | 現在の URL を表示する。 | `PEEK` |
| `g` | カーソルをドキュメントの最上部に移動する。 | `BEGIN` |
| `h` | カーソルを1列左に移動する。 | `MOVE_LEFT` |
| `i` | 画像の URL を表示する。 | `PEEK_IMG` |
| `j` | カーソルを1行下に移動する。 | `MOVE_DOWN` |
| `k` | カーソルを1行上に移動する。 | `MOVE_UP` |
| `l` | カーソルを1列右に移動する。 | `MOVE_RIGHT` |
| `m` | マウスの有効・無効を切り替える。 | `MOUSE_TOGGLE` |
| `n` | 次のパターンを検索する。 | `SEARCH_NEXT` |
| `o` | w3m のオプション設定パネルを開く。 | `OPTIONS` |
| `q` | w3m を終了する。 | `QUIT` |
| `r` | w3m のバージョンを表示する。 | `VERSION` |
| `s` | 現在のタブの閲覧履歴のメニューを開く。 | `SELECT_MENU` |
| `u` | リンクの URL を表示する。 | `PEEK_LINK` |
| `v` | レンダリングビューとソースビューを切り替える。 | `VIEW` |
| `w` | カーソルを次の単語に移動する。 | `NEXT_WORD` |
| `z` | 現在の行を中央にスクロールする。 | `CENTER_V` |
| `{` | 前のタブに移動する。 | `PREV_TAB` |
| `|` | ドキュメントの表示内容を Shell で処理する。 | `PIPE_BUF` |
| `}` | 次のタブに移動する。 | `NEXT_TAB` |

## lynx モード {#lynx-mode}

lynx モードは [lynx](https://lynx.browser.org/ "Lynx Information") 風のキーマップである。

| キー | 説明 | w3m コマンド |
| ---- | ---- | ------------ |
| `!` | Shell コマンドを実行する。 | `SHELL` |
| `"` | 正規表現にマッチする箇所をマークする。 | `REG_MARK` |
| `#` | Shell コマンドの実行結果を逐次表示する。 | `PIPE_SHELL` |
| `$` | カーソルを現在の行の末尾に移動する。 | `LINE_END` |
| `(` | カーソルの移動履歴を遡る。 | `UNDO` |
| `)` | カーソルの移動履歴を進める。 | `REDO` |
| `+` | 次のページにスクロールする。 | `NEXT_PAGE` |
| `,` | ドキュメントを1列左にスクロールする。 | `LEFT` |
| `-` | 前のページにスクロールする。 | `PREV_PAGE` |
| `.` | ドキュメントを1列右にスクロールする。 | `RIGHT` |
| `/` | 任意のパターンを後方インクリメント検索する。 | `SEARCH` |
| `:` | URL 文字列をリンクに変換する。 | `MARK_URL` |
| `;` | 現在のカーソルの単語をリンクに変換する。 | `MARK_WORD` |
| `<C-@>` | 現在のカーソル位置をマークする。 | `MARK` |
| `<C-a>` | カーソルをドキュメントの最上部に移動する。 | `BEGIN` |
| `<C-b>` | 一つ前のバッファーを表示する。 | `BACK` |
| `<C-e>` | カーソルをドキュメントの最下部に移動する。 | `END` |
| `<C-f>` | カーソルのリンク先を開く。 | `GOTO_LINK` |
| `<C-g>` | 現在のカーソルの行数、列数、ドキュメントの文字エンコーディングを表示する。 | `LINE_INFO` |
| `<C-h>` | w3m の閲覧履歴を開く。 | `HISTORY` |
| `<C-j>` | カーソルのリンク先を開く。 | `GOTO_LINK` |
| `<C-k>` | Cookie の一覧を表示する。 | `COOKIE` |
| `<C-l>` | 再描画する。 | `REDRAW` |
| `<C-m>` | カーソルのリンク先を開く。 | `GOTO_LINK` |
| `<C-n>` | カーソルを次のリンクに移動する。 | `NEXT_LINK` |
| `<C-p>` | カーソルを前のリンクに移動する。 | `PREV_LINK` |
| `<C-q>` | 現在のタブを閉じる。 | `CLOSE_TAB` |
| `<C-r>` | 現在の URL を再読み込みする。 | `RELOAD` |
| `<C-s>` | 任意のパターンを後方インクリメント検索する。 | `SEARCH` |
| `<C-t>` | カーソルのリンク先を新たなタブで開く。 | `TAB_LINK` |
| `<C-u>` | カーソルを前のリンクに移動する。 | `PREV_LINK` |
| `<C-v>` | 次のページにスクロールする。 | `NEXT_PAGE` |
| `<C-w>` | 再描画する。 | `REDRAW` |
| `<C-z>` | w3m を中断する。 | `SUSPEND` |
| `<Down>` | カーソルを次のリンクに移動する。 | `NEXT_LINK` |
| `<ESC-:>` | Message-ID 風の文字列を news: のリンクにする。 | `MARK_MID` |
| `<ESC-<>` | カーソルをドキュメントの最上部に移動する。 | `BEGIN` |
| `<ESC->>` | カーソルをドキュメントの最下部に移動する。 | `END` |
| `<ESC-C-b>` | w3mplus のキーマップに切り替える。 | |
| `<ESC-C-j>` | カーソルのリンク先を保存する。 | `SAVE_LINK` |
| `<ESC-C-m>` | カーソルのリンク先を保存する。 | `SAVE_LINK` |
| `<ESC-I>` | カーソルの画像を保存する。 | `SAVE_IMAGE` |
| `<ESC-M>` | カーソルのリンク先を外部ブラウザーで開く。 | `EXTERN_LINK` |
| `<ESC-Tab>` | カーソルを前のリンクに移動する。 | `PREV_LINK` |
| `<ESC-W>` | 現在のカーソルの単語を現在のタブで検索する。 | `DICT_WORD_AT` |
| `<ESC-[1~>` | カーソルをドキュメントの最上部に移動する。 | `BEGIN` |
| `<ESC-[28~>` | デフォルトメニューを開く。 | `MENU` |
| `<ESC-[2~>` | デフォルトメニューを開く。 | `MENU` |
| `<ESC-[4~>` | カーソルをドキュメントの最下部に移動する。 | `END` |
| `<ESC-[5~>` | 前のページにスクロールする。 | `PREV_PAGE` |
| `<ESC-[6~>` | 次のページにスクロールする。 | `NEXT_PAGE` |
| `<ESC-[E>` | デフォルトメニューを開く。 | `MENU` |
| `<ESC-[L>` | デフォルトメニューを開く。 | `MENU` |
| `<ESC-a>` | 現在の URL をブックマークに登録する。 | `ADD_BOOKMARK` |
| `<ESC-b>` | ブックマークの一覧を開く。 | `BOOKMARK` |
| `<ESC-c>` | 任意の w3m コマンドを実行する。 | `COMMAND` |
| `<ESC-e>` | バッファの内容を外部テキストエディタで開く。 | `EDIT_SCREEN` |
| `<ESC-g>` | カーソルを任意の行に移動する。 | `GOTO_LINE` |
| `<ESC-k>` | キーマップを定義する。 | `DEFINE_KEY` |
| `<ESC-l>` | リンク一覧のメニューを開く。 | `LIST_MENU` |
| `<ESC-m>` | リンク一覧のメニューを開き、リンクにカーソルを移動する。 | `MOVE_LIST_MENU` |
| `<ESC-n>` | カーソルを次のマークに移動する。 | `NEXT_MARK` |
| `<ESC-o>` | 任意の w3m オプションを設定する。 | `SET_OPTION` |
| `<ESC-p>` | カーソルを前のマークに移動する。 | `PREV_MARK` |
| `<ESC-s>` | ドキュメントのソースを保存する。 | `SAVE` |
| `<ESC-t>` | タブの選択メニューを開く。 | `TAB_MENU` |
| `<ESC-u>` | 相対 URL を開く。 | `GOTO_RELATIVE` |
| `<ESC-v>` | 前のページにスクロールする。 | `PREV_PAGE` |
| `<ESC-w>` | 任意のキーワードを検索する。 | `DICT_WORD` |
| `<Left>` | 一つ前のバッファーを表示する。 | `BACK` |
| `<Right>` | カーソルのリンク先を開く。 | `GOTO_LINK` |
| `<Space>` | 次のページにスクロールする。 | `NEXT_PAGE` |
| `<Tab>` | カーソルを次のリンクに移動する。 | `NEXT_LINK` |
| `<Up>` | カーソルを前のリンクに移動する。 | `PREV_LINK` |
| `<` | ドキュメントを1ページ左にスクロールする。 | `SHIFT_LEFT` |
| `=` | 現在のドキュメントの各種情報を表示する。 | `INFO` |
| `>` | ドキュメントを1ページ右にスクロールする。 | `SHIFT_RIGHT` |
| `?` | ヘルプページを開く。 | `HELP` |
| `@` | Shell コマンドの実行結果を表示する。 | `READ_SHELL` |
| `B` | 一つ前のバッファーを表示する。 | `BACK` |
| `D` | ダウンロードリストを表示する。 | `DOWNLOAD_LIST` |
| `E` | ドキュメントのソースを編集する。 | `EDIT` |
| `F` | フレームの有効・無効を切り替える。 | `FRAME` |
| `G` | カーソルを任意の行に移動する。 | `GOTO_LINE` |
| `H` | ヘルプページを開く。 | `HELP` |
| `I` | カーソルの画像を表示する。 | `VIEW_IMAGE` |
| `J` | ドキュメントを1行下にスクロールする。 | `UP` |
| `K` | ドキュメントを1行上にスクロールする。 | `DOWN` |
| `L` | 現在のドキュメントのリンクと画像の一覧を表示する。 | `LIST` |
| `M` | 現在の URL を外部ブラウザーで開く。 | `EXTERN` |
| `N` | カーソルを次のマークに移動する。 | `NEXT_MARK` |
| `P` | カーソルを前のマークに移動する。 | `PREV_MARK` |
| `Q` | 確認をなしに w3m を終了する。 | `EXIT` |
| `R` | 現在の URL を再読み込みする。 | `RELOAD` |
| `S` | ドキュメントの表示内容を保存する。 | `SAVE_SCREEN` |
| `T` | 現在のタブを複製する。 | `NEW_TAB` |
| `U` | 現在のタブで任意の URL を開く。 | `GOTO` |
| `V` | ローカルファイルを開く。 | `LOAD` |
| `W` | カーソルを前の単語に移動する。 | `PREV_WORD` |
| `Z` | 現在の列を中央にスクロールする。 | `CENTER_H` |
| `[` | カーソルを現在の行の末尾に移動する。 | `LINK_BEGIN` |
| `]` | カーソルを現在の行の先頭に移動する。 | `LINK_END` |
| `^` | カーソルを現在の行の先頭に移動する。 | `LINE_BEGIN` |
| `a` | 現在の URL をブックマークに登録する。 | `ADD_BOOKMARK` |
| `b` | 前のページにスクロールする。 | `PREV_PAGE` |
| `c` | 現在の URL を表示する。 | `PEEK` |
| `d` | カーソルのリンク先を保存する。 | `SAVE_LINK` |
| `g` | 現在のタブで任意の URL を開く。 | `GOTO` |
| `h` | カーソルを1列左に移動する。 | `MOVE_LEFT` |
| `i` | 画像の URL を表示する。 | `PEEK_IMG` |
| `j` | カーソルを1行下に移動する。 | `MOVE_DOWN` |
| `k` | カーソルを1行上に移動する。 | `MOVE_UP` |
| `l` | カーソルを1列右に移動する。 | `MOVE_RIGHT` |
| `m` | マウスの有効・無効を切り替える。 | `MOUSE_TOGGLE` |
| `n` | 次のパターンを検索する。 | `SEARCH_NEXT` |
| `o` | w3m のオプション設定パネルを開く。 | `OPTIONS` |
| `p` | ドキュメントの表示内容を保存する。 | `SAVE_SCREEN` |
| `q` | w3m を終了する。 | `QUIT` |
| `r` | w3m のバージョンを表示する。 | `VERSION` |
| `s` | 現在のタブの閲覧履歴のメニューを開く。 | `SELECT_MENU` |
| `u` | リンクの URL を表示する。 | `PEEK_LINK` |
| `v` | ブックマークの一覧を開く。 | `BOOKMARK` |
| `w` | カーソルを次の単語に移動する。 | `NEXT_WORD` |
| `z` | 現在の行を中央にスクロールする。 | `CENTER_V` |
| `{` | 前のタブに移動する。 | `PREV_TAB` |
| `|` | ドキュメントの表示内容を Shell で処理する。 | `PIPE_BUF` |
| `}` | 次のタブに移動する。 | `NEXT_TAB` |
