export default {
  defaultTheme: 'light',
  themes: {
    light: {
      dark: false,
      colors: {
        'background': '#FFF',
        'on-background': '#333333',
        'surface': '#FFF',
        'on-surface': '#333333',
        'surface-variant': '#424242',
        'on-surface-variant': '#EEE',
        'primary': '#0969DA',
        'secondary': '#F2F3F5',
        'on-secondary': '#1D2129',
        'error': '#F53F3F',
        'info': '#2080F0',
        'success': '#00B42A',
        'warning': '#FF7D00',
      },
      variables: {
        'border-color': '#000',
        'border-opacity': 0.12,
        'high-emphasis-opacity': 0.87,
        'medium-emphasis-opacity': 0.60,
        'disabled-opacity': 0.38,
        'idle-opacity': 0.04,
        'hover-opacity': 0.04,
        'focus-opacity': 0.12,
        'selected-opacity': 0.08,
        'activated-opacity': 0.12,
        'pressed-opacity': 0.12,
        'dragged-opacity': 0.08,
      },
    },
    dark: {
      dark: true,
      colors: {
        'background': '#22272E',
        'surface': '#2D333B',
        'surface-variant': '#BDBDBD',
        'on-surface-variant': '#424242',
        'primary': '#539BF5',
        'secondary': '#444C56',
        'on-secondary': '#F2F3F5',
        'error': '#F53F3F',
        'info': '#2080F0',
        'success': '#00B42A',
        'warning': '#FF7D00',
      },
      variables: {
        'border-color': '#FFF',
        'border-opacity': 0.08,
        'high-emphasis-opacity': 0.87,
        'medium-emphasis-opacity': 0.60,
        'disabled-opacity': 0.38,
        'idle-opacity': 0.10,
        'hover-opacity': 0.04,
        'focus-opacity': 0.12,
        'selected-opacity': 0.08,
        'activated-opacity': 0.12,
        'pressed-opacity': 0.16,
        'dragged-opacity': 0.08,
      },
    },
  },
}
