const tagsToReplace: Record<string, string> = {
  '&': '&amp;',
  '<': '&lt;',
  '>': '&gt;',
}

export function escapeHTML(str: string): string {
  return str.replace(/[&<>]/g, tag => tagsToReplace[tag] || tag)
}
