---
title: Localization
---

# Localization

<div class="documentation__toc"></div>

## Introduction

PyroCMS has robust localization support. Let's take a look at how it works.
 
## Specifying Locale

### Query String

You can specify the `_locale` in the query string to change active locale for the session. 

```twig
<a href="{{ url_current() }}?_locale=en">Change to English</a>
```

### URI Hints

PyroCMS supports locale hints in the URI by default.

```bash
https://yoursite.com/fr/contact
```

### Wildcard Sub-Domain Hints

PyroCMS also supports locale hints in the sub-domain by default.

```bash
https://fr.yoursite.com/contact
```
