---
title: Addons
---

# Addons

<div class="documentation__toc"></div>

## Introduction

Addons are the fundamental building blocks of PyroCMS. They also allow you to extend PyroCMS to add powerful features.

Addons are essentially organized as standalone bundles of code very similar to [packages](https://getcomposer.org/doc/05-repositories.md#package). In fact, PyroCMS delivers it's addons as packages and you can too!

### Addon Repositories

PyroCMS addons are available from several sources. You can find free addons from our first party [package repository](http://packages.pyrocms.com). If you are interested in the cutting edge you can look through our [development repository](https://development.pyrocms.com).

You can define repositories in your `composer.json` file like so:

```json
    // ...
    "repositories": [
        {
            "type": "composer",
            "url": "https://packages.pyrocms.com"
        },
        {
            "type": "composer",
            "url": "https://development.pyrocms.com"
        }
    ],
    // ...
```

### PRO Addons

We provide unlimited licensing for every paid and private addon we have for just $25/month. We call it Pyro PRO. Once subscribed you can find PRO addons in our [GitHub repository](https://github.com/anomalylabs) as well.

## Addon Types

### Modules

Modules are the largest and most flexible addon types.

Modules can:

- Provide areas in the control panel with forms, tables, etc.
- Run install and uninstall logic and migrations.
- Provide streams models, presenters, etc.

### Field Types

Field types are the basic building blocks of data structures in PyroCMS. They control HTML inputs, data storage, attribute values, and everything in between.

Field types can:

- Render inputs and provide validation for forms.
- Decorate data for models to extend working with values in views.
- Extend the query builder for leveraging stored data easier.

### Plugins

Plugins are essentially [Twig extensions](https://twig.symfony.com/doc/2.x/advanced.html#creating-an-extension) because they extend `Twig_ExtensionInterface`. They let you add functionality to the [view layer](/documentation/streams-platform/latest/templating/views).

Plugins can:

- Define functions and filters accessible within views.
- Provide view data that's accessible globally.

### Themes

Themes are the addons responsible for providing front-end or control panel resources. Themes can be `standard` (front-end) or `admin` (control panel).

Themes contain all the assets, images, views, layouts, and anything else you need to build up the user experience for your website or application.

### Extensions

Extensions are commonly used as `drivers` or `adapters` but can do _almost_ anything you need.

- They can provide a driver designed for a specific addon.
- They can manipulate, extend, or override core functionality.
- Extensions can simply provide a place to store code that you use often.
- They can do anything you need them to do - except provide control panel UI.

Extensions can:

- Run install and uninstall logic and migrations.
- Provide your main Stream models, presenters, etc.
- Provide drivers for addons via an interface or abstract extension.


## Addon Development

Please refer to [addon development documentation](/documentation/streams-platform/latest/addon-development) to learn more about developing the above addons.
