---
title: Streams and Entries
---

# Streams and Entries

<div class="documentation__toc"></div>

## What are streams?

We have three distinct concepts that use the term "Streams" in it's name.

### Streams Data

Streams when used as a noun is often referring to the structure/information in the Stream's database table(s). The records in a stream are referred to as `Entries`.
 
In this context Streams is essentially a `database table` bound to a `model`. In PyroCMS streams are grouped into `namespaces` for organization.

### Streams Platform

The Streams Platform is the foundation of PyroCMS. It can be seen as a framework like Laravel. Usually used by name or the abbreviation "SP" in discussion. Sometimes referred to as the `Streams API` (not to be confused with the API module).

### Streams Module

The Streams Module is a [PRO](https://pyrocms.com/pro) addon that let's you manage Streams Data via the [control panel](/documentation/pyrocms/latest/getting-started/control-panel). Typically you would run a couple commands to make an addon and scaffold streams. However the Streams Module let's you do the same visually and has configurable overrides to customize UI and even an option to add the namespace to your navigation like a virtual module.

## Stream Entries

Stream entries are the `database records` found within the stream's database table.

## Fields

Fields are `attributes` that are `assigned` to a stream. The often represent a `database column` and are accessed via the `model` as an `attribute`.

Fields use a `slug` for their attributes. For example a field named `First Name` would probably have a slug like `first_name` and could be accessed like this:

```twig
{% set entry = entries('users').where('first_name', 'Ryan').first() %}
 
{{ entry.first_name }}
```

```php
$entry = $repositoryOrModel->where('first_name', 'Ryan')->fist();

echo "My name is {$entry->first_name}";
```

## Field Types

Field types represent the `type` of data the `field` uses. PyroCMS comes with a number of field types out of the box and many others are available through our [PRO](https://pyrocms.com/pro) subscription or our addon marketplace.
 
Sometimes field types represent `relations` and define native Laravel relations you can use similarly to attributes:

```php
dump($entry->familyMembers()->where('role', 'dad')->first());
```
