---
title: Architecture
---

# Architecture

<div class="documentation__toc"></div>

## Introduction

A top level summary of PyroCMS's architecture would be `PyroCMS = Laravel + Streams Platform + Addons`.

## What is the Streams Platform?

The Streams Platform is a [Composer package](https://packagist.org/packages/anomaly/streams-platform) that serves as the foundation for PyroCMS. 

Nearly every functionality in every addon for PyroCMS relies on the Streams Platform to do it's work. The Streams Platform is responsible for everything from [Table Builders](/documentation/streams-platform/latest/ui/tables) to [Image](/documentation/streams-platform/latest/core-principles/image) and [Asset](/documentation/streams-platform/latest/core-principles/asset) pipelines to providing the actual addon layer itself. 

## The Application Reference

You will often see `{application}` mentioned in documentation. PyroCMS can handle multiple applications with a single installation. For this reason we use the `application_reference` to distinguish resources between potential multiple applications being served.  

### Where is my application reference?

You can find your `APPLICATION_REFERENCE` in the `.env` file within the root directory of your application.
