---
title: Change Log
---


# Change Log

<div class="documentation__toc"></div>

## Introduction

All notable changes to this project will be documented in this file.

- `Added` for new features.
- `Changed` for changes in existing functionality.
- `Deprecated` for soon-to-be removed features.
- `Removed` for now removed features.
- `Fixed` for any bug fixes.
- `Security` in case of vulnerabilities.

### Versioning

This project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

### Deprecated Features

Features that are deprecated will generally be removed in the next `minor` update unless noted otherwise.

## Releases

### Unreleased
#### Changed
- Updated `anomaly/streams-platform` to `~1.6.0`.
- Updated `anomaly/multiple-field_type` to `~2.3.0`.
- Updated `anomaly/files-field_type` to `~2.3.0`.
- Updated `anomaly/preferences-module` to `~2.2.0`.
- Updated `anomaly/sitemap-extension` to `~2.2.0`.
- Updated `anomaly/redirects-module` to `~2.3.0`.
- Updated `anomaly/variables-module` to `~2.4.0`.
- Updated `anomaly/settings-module` to `~2.4.0`.
- Updated `anomaly/addons-module` to `~2.3.0`.
- Updated `anomaly/blocks-module` to `~1.3.0`.
- Updated `anomaly/users-module` to `~2.5.0`.
- Updated `anomaly/pages-module` to `~2.6.0`.
- Updated `anomaly/posts-module` to `~2.6.0`.
- Updated `anomaly/files-module` to `~2.6.0`.
- Updated `pyrocms/accelerant-theme` to `~1.2.0`.
- Updated `phpunit/phpunit` to `^7.0`.

#### Removed
- Removed `anomaly/local_storage_adapter-extension` dependency (use private storage adapter).

#### Added
- Added `anomaly/search-module: ~3.0.0` requirement.
- Added `anomaly/system-module: ~1.0.0` requirement.
- Added `anomaly/private_storage_adapter-extension: ~1.0.0` requirement.
- Added `dont-discover` for Laravel packages. We want to retain control.
