---
title: Optimizing  
---

# Optimizing

<div class="documentation__toc"></div>

## Autoloader Optimization

When deploying to production, make sure that you are optimizing Composer's class autoloader map so Composer can quickly find the proper file to load for a given class:

```bash
composer install --optimize-autoloader --no-dev
```

[Deployment](../getting-started/deployment){.link}

> In addition to optimizing the autoloader, you should always be sure to include a `composer.lock` file in your project's source control repository. Your project's dependencies can be installed much faster when a `composer.lock` file is present.{.tip}

## Optimizing Configuration Loading

When deploying your application to production, you should make sure that you run the `config:cache` CLI command during your deployment process:

```bash
php artisan config:cache
```

This command will combine all configuration files into a single cached file, which greatly reduces the number of trips the framework must make to the filesystem when loading your configuration values.

> If you execute the `config:cache` command during your deployment process, you should be sure that you are only calling the `env` function from within your configuration files. Once the configuration has been cached, the `.env` file will not be loaded and all calls to the `env` function will return `null`.{.important}

## Optimizing Route Loading

If you are building a large application with many routes, you should make sure that you are running the `route:cache` CLI command during your deployment process:

```bash
php artisan route:cache
```

This command reduces all of your route registrations into a single method call within a cached file, improving the performance of route registration when registering hundreds of routes.

> Since this feature uses PHP serialization, you may only cache the routes for applications that exclusively use controller based routes. PHP is not able to serialize Closures.{.important}

## HTTP Caching

When possible it is advised to enable HTTP cache from the [Settings module](/documentation/settings-module). This will cache applicable requests for a specified TTL and bypass your application entirely on subsequent requests, greatly improving response times and resources needed for high load applications. 

[HTTP Cache](/documentation/latest/core-concepts/http-cache){.link}

## Database Caching

When possible it is advised to enable database cache from the [Settings module](/documentation/settings-module). Doing so will allow PyroCMS to intelligently manage database level cache for you. This feature, by default, does not require any special code considerations.
  
[Caching Queries](/documentation/latest/database/query-builder#database-cache){.link}
