---
title: Deployment  
---

# Deployment

<div class="documentation__toc"></div>

## Introduction

[Laravel Envoy](https://laravel.com/docs/envoy) is an SSH task runner that helps you automate common tasks around deployment and maintenance. 

PyroCMS comes with an [Envoy.blade.php](https://github.com/pyrocms/pyrocms/blob/3.7/Envoy.blade.php) file ready to assist in initializing, deploying, and maintaining your projects with **zero downtime**.

> Deployments is currently in **Beta**, please use caution when setting up and using this feature.{.danger}

## Installation

Before you get started make sure you have [Laravel Envoy](https://laravel.com/docs/envoy#installation) installed.

## Configuration

Before using Envoy deployments make sure you have the following **required** `.env` parameters set:

```bash
DEPLOY_SERVER="ssh_user@65.176.97.208"
DEPLOY_REPOSITORY=git@github.com:yourteam/yourproject.git
DEPLOY_HEALTH_CHECK=https://example.com
DEPLOY_PATH=/home/example
```

`DEPLOY_SERVER` should be your `ssh` login (including port if needed).

`DEPLOY_DEPLOY_REPOSITORY` should be the `git` repository of your project.

`DEPLOY_HEALTH_CHECK` should be the `URL` of your project to ping.

`DEPLOY_PATH` should be the `root` path of your project. **Not the public root.**

You may optionally define additional parameters as needed to help with different remote configurations (shown below with default values):

```bash
DEPLOY_PHP_BINARY=php
DEPLOY_MYSQL_BINARY=mysql
DEPLOY_COMPOSER_BINARY=composer
```

Lastly you can define the default branch to use for deployments like so:

```bash
DEPLOY_DEFAULT_BRANCH=develop
```


## Initializing

To initialize new projects using deployments you simply need to run `envoy run init` after configuring. 
 
### Existing Projects

To initialize an existing project make sure you have a `.env` file in place and run `envoy run init` after configuring.


## Deploying

Deployments are pushed into timestamped directories within the `DEPLOY_PATH`. The `currrent` deployment is symlinked to `{{ DEPLOY_PATH }}/current`. You can manage deployments with the following commands:

### Deploy

Use `envoy run deploy` to deploy the branch and latest dependencies to the remote.

### Rollback

Use `envoy run rollback` to rollback the remote and rollback prior migrations.


## Pushing Code

You may want to push small patches of code instead of triggering a deployment. You can use the following commands to work within the `current` deployment:

### Push

Use `envoy run push` to push your branch changes to the server.

### Revert

Use `envoy run revert` to revert your last `push`.
