---
title: Managing Addons  
---

# Managing Addons

<div class="documentation__toc"></div>

PyroCMS comes with a few different ways you can include additional addons in your project.

## The Addons Module

PyroCMS comes with an [Addons Module](/documentation/addons-module) that uses `composer` to help you safely download, install, update, and migrate addons.

## Downloading Addons with Composer

> Addons installed this way will be downloaded to the `core` directory.{.note}

The easiest way to download addons is to use `composer require`.

```bash
composer require anomaly/image-field_type
```

Addons can also be included in your root `composer.json` file like a normal package would.

```js
{
    "require": {
        ...
        "anomaly/repeater-field_type": "~1.2.0"
    }
}
```

### Downloading PRO Addons

You can download PRO addons with Composer as well.

## GitHub Authentication for PRO

When deploying PRO addons to servers using composer you will need to authorize Composer to access PRO addons on your behalf. To do this you will need to [create a new personal access token](https://github.com/settings/tokens/new?scopes=repo&description=PyroCMS) and install it on your remote:

```bash
composer config -g github-oauth.github.com <oauthtoken>
```

## Including Addons Manually

Some hosts do not allow CLI access. Don't worry, you can manually install addons by copying the addon folder into the appropriate vendor folder in `addons/{application}/{vendor}` for a specific application or `addons/shared/{vendor}` to allow all applications access to the addon.

> You must run the `composer dump-autoload` command after manually modifying addon files.{.important}
