---
title: Directory Structure  
---

# Directory Structure

<div class="documentation__toc"></div>

## Introduction

The default PyroCMS application structure is nearly identical to native Laravel applications and provides a great starting point for both large and small applications. Of course, you are free to organize your application however you like. PyroCMS imposes almost no restrictions on where any given class is located - as long as Composer can autoload the class.

### Where Everything?

When getting started with PyroCMS, many developers are confused by the lack of classes within Laravel's `app` directory. This directory is intentionally left untouched. Feel free to use it for your own odds and ends.

PyroCMS instead provides it's functionality entirely through the Streams Platform and addons. The Streams Platform is located in `vendor/anomaly/streams-platform` and all core addons, core being required by the `composer.json` file, within the `core` directory. 


## The Addons Directory

The `addons` directory is where all addons not included in the composer.json file should be kept.

> The addons directory should be committed to your application's version control.{.tip}

Just like composer packages PyroCMS addons have a `vendor` slug that is included in their path. Addons also include the site's `application reference` and the addon's `type` in it's full path.

```bash
addons/{application}/{vendor}/{addon}-{type}

addons/your_site/anomaly/cool_example-module
```

All addons in the `composer.json` file will be available for all applications in your PyroCMS installation in a multisite situation.

You can also share custom addons by placing them in the `addons/shared` directory.

```bash
addons/shared/anomaly/cool_example-module
```

## The App Directory

The `app` directory is generally unused in PyroCMS applications. PyroCMS leads by example in bundling it's features and logic into addons. You may, however, use the `app` directory just like you would when creating a Laravel application.

## The Bootstrap Directory

The `bootstrap` directory contains the `app.php` file which bootstraps the Laravel framework. This directory also houses a `cache` directory which contains framework generated files for performance optimization such as the route and services cache files.

You will notice the `bootstrap/app.php` file also initializes custom `console kernel` and `http kernel` instances from the Streams Platform.

## The Config Directory

The `config` directory, as the name implies, contains all of your application's basic configuration files. It's a great idea to read through all of these files and familiarize yourself with all of the options available to you.

> The Streams Platform and all addons bring their own configuration which can be found in their respective `resources/config` directories.{.tip}
     
## The Database Directory

The `database` directory contains _application specific_ database migrations, model factories, and seeds. If you wish, you may also use this directory to hold an SQLite database.

> The Streams Platform and all addons bring their own database resources which can be found in their respective `migrations` and `factories` directories.{.tip}

## The Public Directory

The `public` directory contains the `index.php` file, which is the entry point for all requests entering your application and configures autoloading. This directory also houses your assets such as images, JavaScript, and CSS.

The [/documentation/streams-platform/core-concepts/asset](Asset) service in the [/documentation/streams-platform](Streams Platform) also uses the public directory to cache images and assets from various themes and addons. Cached assets can be found in the `public/app/{application}/assets` directory.

> `php artisan asset:clear public` is a quick way to wipe out public asset cache.{.tip}

## The Resources Directory

The `resources` directory contains application specific views and can be used for your raw, un-compiled assets such as LESS, SASS, or JavaScript. This directory also houses all of your language files.

While you can use the resources directory exactly like you would in a native Laravel application you are encouraged to bundle language files, assets, and views in their respective addons that you are developing for your website or application.

> It is highly encouraged to bundle your resources into their respective addons that you develop.{.important}

The `resources` directory will also contain override files for addon config, views, and language files. You will be published to the `resources/{application}/addons` directory then when running the corresponding Artisan commands.

## The Routes Directory

The `routes` directory contains all of the route definitions for your application. By default, several route files are included with Laravel: web.php, api.php, console.php and  channels.php.

> It is highly encouraged to bundle your routes into their respective addons that you develop.{.important}

The `web.php` file contains routes that the RouteServiceProvider places in the web middleware group, which provides session state, CSRF protection, and cookie encryption. If your application does not offer a stateless, RESTful API, all of your routes will most likely be defined in the web.php file.

The `api.php` file contains routes that the RouteServiceProvider places in the api middleware group, which provides rate limiting. These routes are intended to be stateless, so requests entering the application through these routes are intended to be authenticated via tokens and will not have access to session state.

The `console.php` file is where you may define all of your Closure based console commands. Each Closure is bound to a command instance allowing a simple approach to interacting with each command's IO methods. Even though this file does not define HTTP routes, it defines console based entry points (routes) into your application.

The `channels.php` file is where you may register all of the event broadcasting channels that your application supports.

> These routes are loaded FIRST. This means that duplicate subsequent routes will override them by name and route path.{.tip}

## The Storage Directory

The `storage` directory contains your compiled Blade templates, file based sessions, file caches, and other files generated by the framework. This directory is segregated into app, framework, streams, and logs directories. The app directory may be used to store any files generated by your application. The framework directory is used to store framework generated files and caches. Finally, the logs directory contains your application's log files.

The storage/app/public directory may be used to store user-generated files, such as profile avatars, that should be publicly accessible. You should create a symbolic link at  public/storage which points to this directory. You may create the link using the  php artisan storage:link command.

## The `Tests` Directory

The tests directory contains your automated tests. An example PHPUnit test is provided out of the box. Each test class should be suffixed with the word Test. You may run your tests using the phpunit or php vendor/bin/phpunit commands.

## The Vendor Directory

The `vendor` directory contains your Composer dependencies including composer required addons.

> It is not advised to commit your vendor directory to version control.{.important}
