---
title: Installation  
---

# Installation

<div class="documentation__toc"></div>

## Server Requirements

PyroCMS has a few system requirements:

- PHP >= 7.3
- XML PHP Extension
- PDO PHP Extension
- cURL PHP Extension
- JSON PHP Extension
- Ctype PHP Extension
- BCMath PHP Extension
- SQLite PHP Extension
- OpenSSL PHP Extension
- Mbstring PHP Extension
- Fileinfo PHP Extension
- Tokenizer PHP Extension
- GD Library (>=2.0) **OR** Imagick PHP extension (>=6.5.7)

### Host Configuration

When you setup your web host be sure to point the web root to Pyro's `public` directory. Just as you would a normal Laravel installation.

#### Alternate Directories

In some environments like cPanel or Virtualmin it may be difficult to use the `public` directory as the web root. In these cases we suggest symlinking the `public` directory to `public_html`:

```bash
ln -s public public_html
```

You may also simply rename the `public` directory to `public_html`. Path hints will automatically use the correct path. 

### Directory Permissions

After installing, you may need to configure some permissions in order to proceed. Directories within the `storage`, `public/app`, and the `bootstrap/cache` directories should be writable by your web server. If you are using the [Homestead](http://laravel.com/docs/homestead) virtual machine, these permissions should already be set.


## Downloading PyroCMS

PyroCMS utilizes [Composer](https://getcomposer.org/) to manage its dependencies. So, before using PyroCMS, make sure you have Composer installed on your machine.

> Do not create an `.env` file just yet - Pyro's installer will generate one for you.{.important}


### Via Composer

You may download PyroCMS by issuing the Composer `create-project` command in your terminal:

```bash
composer create-project pyrocms/pyrocms
```

If you are using a Windows environment, you might run into issues with the length of paths when unzipping packages. To avoid this issue, use the `--prefer-source` flag.

#### Specifying Specific Versions

You can specify a specific version by using the branch and also include VCS sources with the `--prefer-source` option.

```bash
composer create-project pyrocms/pyrocms:3.5
```

#### Development Branches

Similarly, you can specify a development branch like so:

```bash
composer create-project pyrocms/pyrocms:3.7.x-dev
```


## Installing PyroCMS

### Running the Installation Wizard

After downloading PyroCMS and it's dependencies, you will need to install the software in order to get started. By this time you should be able to visit your site's URL which will redirect you to the installer: `http://example.com/installer`

### Using the CLI Installer

PyroCMS comes with a CLI installer you can use with the following command:

```bash
php artisan install
```

You will be prompted for details in order to proceed with the installation process.

> You may need to run `ulimit -n 1024` before installing via CLI to temporarily increase your max open files limit.{.notice}

#### Automating the CLI Installer

You can automate the installer by creating your own .env file with something like this:

```bash
INSTALLED=false
APP_ENV=local
APP_DEBUG=true
APP_KEY=zfesbnTkXvooWVcsKMw2r4SmPVNGbFoS
DB_CONNECTION=mysql
DB_HOST=localhost
DB_DATABASE=workbench
DB_USERNAME=root
DB_PASSWORD=root
APPLICATION_NAME=Default
APPLICATION_REFERENCE=default
APPLICATION_DOMAIN=localhost
ADMIN_EMAIL=ryan@pyrocms.com
ADMIN_USERNAME=admin
ADMIN_PASSWORD=password
LOCALE=en
TIMEZONE=America/Chicago
```
> The APP_KEY must be exactly 32 characters in length.{.important}

Then run the installer and indicate that the system is ready to install:

```bash
php artisan install --ready
```

### Using the cURL Installer

PyroCMS also comes with a cURL installer you can use by executing the following CLI command:

```bash
curl -L --max-redirs 100 "http://example.com/installer/process?database_driver=mysql&database_host=localhost&database_name=workbench&database_username=root&database_password=root&admin_username=admin&admin_email=ryan%40pyrocms.com&admin_password=password&application_name=Default&application_reference=default&application_domain=workbench.local%3A8888&application_locale=en&application_timezone=UTC&action=install"
```

If desired you can make a browser request to the same URL and append `&verbose=true` to load the installer directly without the wizard.


## Post Installation

### Accessing the Control Panel

Once installed you will be able to access the control panel as well as view the front-end of your website.

[Control Panel Basics](../the-basics/control-panel#accessing-the-control-panel){.link}

### Removing the Installer

Upon logging in the first time after installation you will notice the suggestion to delete the Installer module. To do this simply remove the `"anomaly/installer-module"` requirement from your project's `composer.json` file and run `composer update`.

If you are not using composer going forward you can simply delete `/vendor/anomaly/installer-module` from your PyroCMS installation though it's a good idea to still delete it from your `composer.json` file as well.
