---
title: Upgrade Guide
---

# Upgrade Guide

<div class="documentation__toc"></div>

## Upgrading to 3.9.0 From 3.8

**Estimated Upgrade Time: 5 - 10 Minutes**

> We attempt to document every possible change. Since some of these changes are in obscure parts of the API only a portion of these changes may actually affect your application.{.notice}

Before continuing please refer to the [release notes](../prologue/release-notes) to see more information on what has been changed.

### Updating Dependencies

The following dependencies should be removed from your `composer.json` file.

- `wikimedia/composer-merge-plugin`
- `anomaly/streams-composer-plugin`

### VCS Addons

Addons located within your `/addons` directory will need to be registered as local composer packages within your `composer.json`.

```
{
    "name": "example/custom-theme",
    ...
    "repositories": {
      "custom-theme": {
        "type": "path",
        "url": "addons/default/example/custom-theme",
        "options": {
          "symlink": true
        }
      }
    }
}
```

### Remove Core References

Core addons are now loaded as "native" addons via the addition of the native addon path loader. Core addons will continue to be supported, but collide with Composer 2 and the future of PyroCMS. Addons go in the vendor directory. See below for project/one-off addons.

### Bump Version

Lastly, update the version in `resources/streams/config/distribution.php`.
