///item for gamepad device instance, provide common API
Item {
	signal axes;						///< emitted when one of the axes is changed
	signal button;						///< emitted when any button is pressed
	property int index;					///< gamepad index in order of appearance
	property int buttonsCount;			///< supported buttons count
	property int axesCount;				///< supported axes count
	property int vendorId;				///< vendor ID
	property int productId;				///< product ID
	property bool connected;			///< is gamepad connected or not
	property bool standartMapping: true;	///< gamepad use standart buttons and axes mapping
	property string deviceInfo;			///< gamepad device info string

	/// @private
	constructor : {
		this._state = {}
		this._standartMapping = {
			axes: [ "leftStickX", "leftStickY", "rightStickX", "rightStickY"],
			button: [
				"a", "b", "x", "y",
				"leftBumper", "rightBumper", "leftTrigger", "rightTrigger",
				"back", "start", "leftStick", "rightStick",
				"up", "down", "left", "right", "guide"
			]
		}
		this._mapping = this._standartMapping

		this._db =
			{"10256:0": {"mapping": {"axes": ["leftStickX", "leftStickY"], "button": ["b", "a", 0, "y", "x", 0, "leftBumper", "rightBumper", 0, 0, "back", "start"]}, "name": "8Bitdo SFC30 GamePad"}, "10256:256": {"mapping": {"axes": ["leftStickX", "leftStickY"], "button": ["b", "a", 0, "y", "x", 0, "leftBumper", "rightBumper", 0, 0, "back", "start"]}, "name": "8Bitdo SFC30 GamePad"}, "10256:9": {"mapping": {"axes": ["leftStickX", "leftStickY"], "button": ["b", "a", 0, "y", "x", 0, "leftBumper", "rightBumper", 0, 0, "back", "start"]}, "name": "8Bitdo SFC30 GamePad"}, "10294:0": {"mapping": {"axes": ["leftStickX", "leftStickY", 0, "rightStickX", "rightStickY"], "button": ["a", "x", "y", "b", "leftBumper", "rightBumper", "leftStick", "rightStick", "up", "down", "left", "right", "leftTrigger", "rightTrigger", "start", "guide"]}, "name": "OUYA Controller"}, "10294:258": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "x", "y", "b", "leftBumper", "rightBumper", "leftStick", "rightStick", "up", "down", "left", "right", 0, 0, "guide"]}, "name": "OUYA Game Controller"}, "10294:259": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "x", "y", "b", "leftBumper", "rightBumper", "leftStick", "rightStick", "up", "down", "left", "right", 0, 0, "guide"]}, "name": "OUYA Game Controller"}, "10462:1": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide", "leftStick", "rightStick"]}, "name": "Valve Streaming Gamepad"}, "1064:0": {"mapping": {"axes": ["leftStickX", "leftStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start"]}, "name": "GamePad Pro USB"}, "1064:256": {"mapping": {"axes": ["leftStickX", "leftStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start"]}, "name": "Gravis GamePad Pro USB "}, "1103:0": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", 0, 0, "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "Dual Trigger 3-in-1"}, "1103:256": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", 0, 0, "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "Thrustmaster Run N Drive  Wireless"}, "1103:272": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["a", "x", "b", "y", "leftBumper", "leftTrigger", "rightBumper", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "Thrustmaster Dual Analog 4"}, "1103:45824": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["a", "x", "b", "y", "leftBumper", "leftTrigger", "rightBumper", "rightTrigger", "guide", "back", "start", "leftStick"]}, "name": "Thrustmaster Firestorm Dual Power"}, "1103:45845": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["a", "x", "b", "y", "leftBumper", "leftTrigger", "rightBumper", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "Thrustmaster Dual Analog 3.2"}, "1118:1395": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide", "leftStick", "rightStick"]}, "name": "Speedlink TORID Wireless Gamepad"}, "1118:256": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "rightBumper", "x", "y", "leftBumper", "back", "start", "leftStick", "rightStick"]}, "name": "Microsoft X-Box pad (Japan)"}, "1118:257": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide", "leftStick", "rightStick"]}, "name": "Microsoft X-Box One pad"}, "1118:260": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide", "leftStick", "rightStick"]}, "name": "Microsoft X-Box 360 pad"}, "1118:263": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide", "leftStick", "rightStick", "left", "right", "up", "down"]}, "name": "X360 Wireless Controller"}, "1118:272": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide", "leftStick", "rightStick"]}, "name": "X360 Controller"}, "1118:276": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide", "leftStick", "rightStick"]}, "name": "X360 Controller"}, "1118:289": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "rightBumper", "x", "y", "leftBumper", "back", "start", "leftStick", "rightStick"]}, "name": "Microsoft X-Box pad v2 (US)"}, "1118:515": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide", "leftStick", "rightStick"]}, "name": "Microsoft X-Box One pad v2"}, "1118:654": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "leftStick", "rightStick", "start", "back", "guide", "up", "down", "left", "right"]}, "name": "X360 Controller"}, "1118:733": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "leftStick", "rightStick", "start", "back", "guide", "up", "down", "left", "right"]}, "name": "Xbox One Wired Controller"}, "1118:736": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "leftStick", "rightStick", "guide"]}, "name": "Xbox Wireless Controller"}, "1118:746": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "leftStick", "rightStick", "start", "back", "guide", "up", "down", "left", "right"]}, "name": "Xbox Wireless Controller"}, "1118:8224": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide", "leftStick", "rightStick"]}, "name": "SpeedLink XEOX Pro Analog Gamepad pad"}, "1118:9058": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide", "leftStick", "rightStick"]}, "name": "Microsoft X-Box 360 pad"}, "1133:0": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "Logitech RumblePad 2 USB"}, "1133:16404": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide", "leftStick", "rightStick"]}, "name": "Logitech F310 Gamepad (XInput)"}, "1133:272": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "Logitech Logitech RumblePad 2 USB"}, "1133:273": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "Logitech F710 Gamepad (DInput)"}, "1133:49686": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "Logitech F310 Gamepad (DInput)"}, "1133:49688": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "Logitech F510 Gamepad (DInput)"}, "1133:49689": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "Logitech Wireless Gamepad (DInput)"}, "1133:49695": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "leftStick", "rightStick", "start", "back", "guide", "up", "down", "left", "right"]}, "name": "Logitech F710 Gamepad (XInput)"}, "1133:773": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide", "leftStick", "rightStick"]}, "name": "Logitech F710 Gamepad (XInput)"}, "1133:8224": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide", "leftStick", "rightStick"]}, "name": "Logitech F510 Gamepad (XInput)"}, "1204:266": {"mapping": {"axes": ["leftStickX", "leftStickY"], "button": ["a", "b", "guide", "x", "y", "back", "leftBumper", "rightBumper", "start"]}, "name": "Sega Saturn USB Gamepad"}, "120:272": {"mapping": {"axes": ["leftStickX", "leftStickY"], "button": ["y", "b", "a", "x", "leftTrigger", "rightTrigger", "leftBumper", "rightBumper", "back", "start"]}, "name": "Microntek USB Joystick"}, "121:0": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", 0, "rightStickY"], "button": ["x", "y", "a", "b", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "NGS Phantom"}, "121:17": {"mapping": {"axes": [0, 0, 0, "leftStickX", "leftStickY"], "button": ["y", "b", "a", "x", "leftBumper", "rightBumper", 0, 0, "back", "start"]}, "name": "Retrolink Classic Controller"}, "121:272": {"mapping": {"axes": ["leftStickX", "leftStickY"], "button": ["y", "b", "a", "x", "leftBumper", "rightBumper", 0, 0, "back", "start"]}, "name": "Retrolink Classic Controller"}, "121:6": {"mapping": {"axes": ["leftStickX", "leftStickY", 0, "rightStickX", "rightStickY"], "button": ["y", "b", "a", "x", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "G-Shark GP-702"}, "121:6144": {"mapping": {"axes": ["leftStickX", 0, 0, 0, "leftStickY", 0, 0, 0, "rightStickX", 0, 0, 0, "rightStickY"], "button": ["x", 0, 0, 0, "a", 0, 0, 0, "b", 0, 0, 0, "y", 0, 0, 0, "leftBumper", 0, 0, 0, "rightBumper", 0, 0, 0, "leftTrigger", 0, 0, 0, "rightTrigger", 0, 0, 0, "back", 0, 0, 0, "start", 0, 0, 0, "leftStick", 0, 0, 0, "rightStick"]}, "name": "Mayflash WiiU Pro Game Controller Adapter (DInput)"}, "1356:0": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "leftTrigger", "rightTrigger", "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", 0, 0, 0, "start", "leftStick", "rightStick", "guide", "back"]}, "name": "Sony DualShock 4 Wireless Adaptor"}, "1356:1476": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "leftTrigger", "rightTrigger", "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", 0, 0, 0, "start", "leftStick", "rightStick", "guide", "back"]}, "name": "Sony DualShock 4"}, "1356:2508": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "leftTrigger", "rightTrigger", "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", 0, 0, 0, "start", "leftStick", "rightStick", "guide", "back"]}, "name": "Sony DualShock 4 V2"}, "1356:256": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["back", "leftStick", "rightStick", "start", "up", "right", "down", "left", "leftTrigger", "rightTrigger", "leftBumper", "rightBumper", "y", "b", "a", "x", "guide"]}, "name": "PS3 Controller (Bluetooth)"}, "1356:273": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "leftTrigger", "rightTrigger", "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", 0, 0, 0, "start", "leftStick", "rightStick", "guide", "back"]}, "name": "Sony DualShock 4 Wireless Adaptor"}, "1356:616": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["back", "leftStick", "rightStick", "start", "up", "right", "down", "left", "leftTrigger", "rightTrigger", "leftBumper", "rightBumper", "y", "b", "a", "x", "guide"]}, "name": "PS3 Controller"}, "1390:272": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["x", "y", "a", "b", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "leftStick", "rightStick", "back", "start", "guide"]}, "name": "JC-U3613M - DirectInput Mode"}, "1406:1": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["a", "b", "y", "x", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "guide", "leftStick", "rightStick", "up", "down", "left", "right"]}, "name": "Nintendo Wii U Pro Controller"}, "1411:0": {"mapping": {"axes": ["leftStickX", "leftStickY"], "button": ["b", "a", "y", "x", "leftBumper", "rightBumper", "back", "start"]}, "name": "iBuffalo USB 2-axis 8-button Gamepad"}, "1411:272": {"mapping": {"axes": ["leftStickX", "leftStickY"], "button": ["b", "a", "y", "x", "leftBumper", "rightBumper", "back", "start"]}, "name": "iBuffalo USB 2-axis 8-button Gamepad"}, "1411:8288": {"mapping": {"axes": ["leftStickX", "leftStickY"], "button": ["b", "a", "y", "x", "leftBumper", "rightBumper", "back", "start"]}, "name": "iBuffalo USB 2-axis 8-button Gamepad"}, "14368:0": {"mapping": {"axes": ["leftStickX", "leftStickY", 0, "rightStickX", "rightStickY"], "button": ["a", "b", 0, "x", "y", 0, "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", 0, "leftStick", "rightStick"]}, "name": "8Bitdo NES30 PRO Wireless"}, "1440:1": {"mapping": {"axes": ["leftStickX", "leftStickY"], "button": ["a", "b", 0, "x", "y", 0, "leftBumper", "rightBumper", 0, 0, "back", "start"]}, "name": "8Bitdo Zero GamePad"}, "1452:1": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickY", "rightStickX"], "button": ["a", "b", "x", "y", "leftTrigger", "rightTrigger", "leftBumper", "rightBumper", "back", "start", "leftStick", "rightStick"]}, "name": "VR-BOX"}, "1533:256": {"mapping": {"axes": ["leftStickX", "leftStickY"], "button": ["x", "y", "rightBumper", "a", "b", "rightTrigger", "back", "start"]}, "name": "InterAct GoPad I-73000 (Fighting Game Layout)"}, "1699:0": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["x", "y", "a", "b", "start", "back", "leftBumper", "rightBumper", "leftStick", "rightStick", "guide"]}, "name": "Saitek P2500"}, "1699:256": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickY", "rightStickX"], "button": ["x", "y", "a", "b", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "leftStick", "rightStick"]}, "name": "Saitek P880"}, "1699:272": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "rightBumper", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "Saitek PLC Saitek P3200 Rumble Pad"}, "1699:273": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickY", "rightStickX"], "button": ["x", "a", "b", "y", "leftTrigger", "rightTrigger", "leftBumper", "rightBumper", "back", "guide", "leftStick", "rightStick", "start"]}, "name": "Saitek P2900 Wireless Pad"}, "1848:1040": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide", "leftStick", "rightStick"]}, "name": "Mad Catz Wired Xbox 360 Controller"}, "1848:293": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick", "guide"]}, "name": "Mad Catz C.T.R.L.R "}, "1:3": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "guide", "leftStick", "rightStick"]}, "name": "Nintendo Wiimote"}, "2064:0": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["a", "b", 0, 0, 0, 0, 0, 0, "back", "start"]}, "name": "NEXT Classic USB Game Controller"}, "2064:272": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickY", "rightStickX"], "button": ["y", "b", "a", "x", "leftTrigger", "rightTrigger", "leftBumper", "rightBumper", "back", "start", "leftStick", "rightStick"]}, "name": "USB Gamepad"}, "21319:25697": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "GameStop Gamepad"}, "2341:0": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["b", "a", "y", "x", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "guide", "up", "left", "down", "right"]}, "name": "Mayflash Wii Classic Controller"}, "2341:1000": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["b", "a", "y", "x", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "guide", "up", "left", "down", "right"]}, "name": "Mayflash Wii Classic Controller"}, "2341:256": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["y", "b", "a", "x", "leftTrigger", "rightTrigger", "leftBumper", "rightBumper", "start", "back", "leftStick", "rightStick"]}, "name": "Sony PS2 pad with SmartJoy adapter"}, "2342:256": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY", "leftTrigger", "rightTrigger"], "button": ["a", "x", "b", "y", 0, 0, "rightBumper", "start"]}, "name": "GameCube {WiseGroup USB box}"}, "25176:28773": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY", "rightTrigger", "leftTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide", "leftStick", "rightStick"]}, "name": "Xbox Gamepad (userspace driver)"}, "26214:256": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["y", "b", "a", "x", "leftTrigger", "rightTrigger", "leftBumper", "rightBumper", "start", "back", "leftStick", "rightStick", "up", "right", "down", "left"]}, "name": "Super Joy Box 5 Pro"}, "34952:0": {"mapping": {"axes": ["leftStickX", "leftStickY", 0, "rightStickX", "rightStickY"], "button": ["x", "b", "a", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "leftStick", "rightStick", "start", "guide"]}, "name": "PS3 Controller"}, "3695:0": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick", "guide"]}, "name": "Rock Candy Gamepad for PS3"}, "3695:1568": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide", "leftStick", "rightStick"]}, "name": "Afterglow Wired Controller for Xbox One"}, "3695:256": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide", "leftStick", "rightStick"]}, "name": "Generic X-Box pad"}, "3695:257": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide", "leftStick", "rightStick"]}, "name": "Rock Candy Wired Controller for Xbox One"}, "3695:273": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick", "guide"]}, "name": "Rock Candy Gamepad for PS3"}, "3695:512": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide", "leftStick", "rightStick"]}, "name": "Logic3 Controller"}, "3727:0": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "Multilaser JS071 USB"}, "3727:272": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickY", "rightStickX"], "button": ["a", "b", "x", "y", "leftBumper", "leftTrigger", "rightBumper", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "GreenAsia Inc.      USB  Joystick  "}, "3727:3": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickY", "rightStickX"], "button": ["y", "b", "a", "x", "leftTrigger", "rightTrigger", "leftBumper", "rightBumper", "back", "start", "leftStick", "rightStick"]}, "name": "Piranha xtreme"}, "3853:0": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick", "guide"]}, "name": "Hatsune Miku Sho Controller"}, "3853:102": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", 0, "rightTrigger", "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "leftTrigger", 0, "back", "start", "leftStick", "rightStick", "guide"]}, "name": "HORIPAD FPS PLUS 4"}, "3853:256": {"mapping": {"axes": [], "button": ["a", "x", "y", "leftBumper", "leftStickX", "leftStickY", "b", "rightBumper", "back", "start", "guide"]}, "name": "hori"}, "3853:273": {"mapping": {"axes": [], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", 0, 0, "guide"]}, "name": "HORI CO. LTD. FIGHTING STICK 3"}, "3853:77": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick", "guide"]}, "name": "HORI Gem Pad 3"}, "3888:0": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickY", "rightStickX"], "button": ["x", "y", "a", "b", "leftBumper", "leftTrigger", "rightBumper", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "Saitek P480 Rumble Pad"}, "4544:0": {"mapping": {"axes": ["leftStickX", "leftStickY"], "button": ["leftBumper", "rightBumper", "back", "start", "x", "y", "a", "b"]}, "name": "Battalife Joystick"}, "4553:273": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "HJC Game GAMEPAD"}, "4607:0": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", 0, "rightStickY"], "button": ["x", "y", "a", "b", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "Gembird JPD-DualForce"}, "4607:272": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["y", "b", "a", "x", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "PC Game Controller"}, "4661:43809": {"mapping": {"axes": ["leftStickX", "leftStickY"], "button": ["b", "a", 0, "y", "x", 0, "leftBumper", "rightBumper", 0, 0, "back", "start"]}, "name": "SFC30 Joystick"}, "4683:0": {"mapping": {"axes": ["leftStick", 0, "rightStick", "leftBumper"], "button": ["a", "b", "x", "y", 0, "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "guide"]}, "name": "NYKO AIRFLO"}, "4797:272": {"mapping": {"axes": ["leftStickX", "leftStickY"], "button": ["y", "b", "a", "x", "leftBumper", "rightBumper", 0, 0, "back", "start"]}, "name": "Tomee SNES USB Controller"}, "4797:53269": {"mapping": {"axes": ["leftStickX", "leftStickY"], "button": ["y", "b", "a", "x", "leftBumper", "rightBumper", 0, 0, "back", "start"]}, "name": "Tomee SNES USB Controller"}, "5336:273": {"mapping": {"axes": ["leftStickX", "leftStickY"], "button": ["a", "b", "y", "x", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start"]}, "name": "Toodles 2008 Chimp PC/PS3"}, "5336:53198": {"mapping": {"axes": [], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start"]}, "name": "MC Cthulhu"}, "5769:292": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide", "leftStick", "rightStick", "left", "right", "up", "down"]}, "name": "Razer Onza Classic Edition"}, "5769:64768": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "leftStick", "rightStick", "start", "back", "guide", "up", "down", "left", "right"]}, "name": "Razer Onza Tournament"}, "5:28001": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "GameStop Gamepad"}, "5:29807": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": [0, 0, 0, 0, 0, 0, "start", "back", "guide", 0, 0, "up", "down", "left", "right", "b", "a", "y", "x", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "leftStick", "rightStick"]}, "name": "Wii U Pro Controller"}, "6017:1406": {"mapping": {"axes": ["leftStickX", 0, "leftStickY", 0, "rightTrigger", "leftTrigger"], "button": ["x", 0, "a", 0, "b", 0, "y", 0, "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", 0, "start", "right", "left", "down", "up"]}, "name": "Sega Saturn"}, "61440:0": {"mapping": {"axes": ["leftStickX", "leftStickY"], "button": ["x", "a", "back", "start", "y", "b", "leftBumper", "rightBumper"]}, "name": "RetroUSB.com Super RetroPort"}, "61440:256": {"mapping": {"axes": ["leftStickX", "leftStickY"], "button": ["x", "a", "back", "start", "y", "b", "leftBumper", "rightBumper"]}, "name": "RetroUSB.com Super RetroPort"}, "6473:0": {"mapping": {"axes": ["leftStickX", "leftStickY", 0, "rightStickX", "rightStickY"], "button": ["a", "b", 0, "x", "y", 0, "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", 0, "leftStick", "rightStick"]}, "name": "Ipega PG-9023"}, "65535:0": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "GameStop Gamepad"}, "6708:0": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", 0, "rightStick", "back", "start"]}, "name": "EXEQ RF USB Gamepad 8206"}, "6708:272": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickY", "leftTrigger", "rightTrigger", "rightStickX"], "button": ["x", "a", "b", "y", 0, 0, 0, "rightBumper", 0, "start", 0, 0, "up", "right", "down", "left"]}, "name": "GameCube {HuiJia USB box}"}, "7085:1168": {"mapping": {"axes": [0, 0, "leftTrigger", 0, 0, "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide"]}, "name": "Mad Catz Fightpad SFxT"}, "7085:1331": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "back", "start", "guide", "leftStick", "rightStick"]}, "name": "Hori Pad EX Turbo 2"}, "7085:63745": {"mapping": {"axes": ["leftStickX", "leftStickY", "leftTrigger", "rightStickX", "rightStickY", "rightTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "leftStick", "rightStick", "start", "back", "guide", "up", "down", "left", "right"]}, "name": "Gamestop BB-070 X360 Controller"}, "8194:0": {"mapping": {"axes": ["leftStickX", "leftStickY", 0, "rightStickX", "rightStickY"], "button": ["a", "b", 0, "x", "y", 0, "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", 0, "leftStick", "rightStick"]}, "name": "8Bitdo NES30 PRO USB"}, "8406:0": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick", "guide"]}, "name": "PowerA Pro Ex"}, "8406:1": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY", "rightTrigger", "leftTrigger"], "button": ["a", "b", "x", "y", "leftBumper", "rightBumper", "start", "leftStick", "rightStick"]}, "name": "Moga Pro"}, "8890:257": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickY", "rightStickX"], "button": ["y", "b", "a", "x", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start"]}, "name": "Jess Technology USB Game Controller"}, "9571:0": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["y", "b", "a", "x", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick"]}, "name": "USB Vibration Joystick (BM)"}, "9712:272": {"mapping": {"axes": ["leftStickX", "leftStickY", "rightStickX", "rightStickY"], "button": ["x", "a", "b", "y", "leftBumper", "rightBumper", "leftTrigger", "rightTrigger", "back", "start", "leftStick", "rightStick", "guide"]}, "name": "Goodbetterbest Ltd USB Controller"}}

	}

	/// @private
	function _set(name, idx, n, value) {
		//log(name, idx, value)
		var _state = this._state
		var values
		if (!(name in _state))
			values = _state[name] = Array(n)
		else
			values = _state[name]

		var old = values[idx] || 0
		var delta = value - old
		if (delta != 0) {
			values[idx] = value
			var mapping = this._mapping[name] || []
			var mapName = mapping[idx]
			if (mapName) this.emit(mapName, value, delta); else this.emit(name, idx, value, delta)
		}
	}


	/// @private
	function get(name, idx) {
		var values = this._state[name] || []
		return values[idx] || 0
	}


	/// @private
	function poll(gp) {
		var event = { 'type': 'keydown', 'source': 'gamepad', 'index': gp.index }
		if (gp.axes) {
			var axes = gp.axes
			var n = axes.length
			for(var i = 0; i < n; ++i) {
				this._set('axes', i, n, axes[i])
			}
		}
		if (gp.buttons) {
			var buttons = gp.buttons
			var n = buttons.length
			for(var i = 0; i < n; ++i) {
				this._set('button', i, n, buttons[i].value)
			}
		}
	}

	onStandartMappingChanged: {
		if (value) {
			this._mapping = this._standartMapping
		} else {
			log("Not standart gamepad mapping")
			var gamepadId = this.vendorId + ":" + this.productId
			var mapping = this._db[gamepadId]
			if (mapping) {
				log("Use " + gamepadId + " mapping")
				this._mapping = mapping
			} else {
				log(gamepadId, "mapping not found, use default")
				this._mapping = this._standartMapping
			}
		}
	}
}
