/**
 * @license
 * Copyright 2024 Google Inc.
 * SPDX-License-Identifier: Apache-2.0
 */
/** @type {import('@docusaurus/plugin-content-docs').SidebarsConfig} */
module.exports = {
  docs: [
    {
      type: 'category',
      label: 'Introduction',
      link: {
        type: 'generated-index',
        title: 'Introduction',
        keywords: ['introduction'],
      },
      items: [
        'guides/what-is-puppeteer',
        'guides/installation',
        'guides/getting-started',
        'guides/system-requirements',
      ],
    },
    {
      type: 'category',
      label: 'Core concepts',
      link: {
        type: 'generated-index',
        title: 'Core concepts',
        keywords: ['core-concepts'],
      },
      items: [
        'guides/browser-management',
        'guides/page-interactions',
        'guides/javascript-execution',
        'guides/network-logging',
      ],
    },
    {
      type: 'category',
      label: 'Guides',
      link: {
        type: 'generated-index',
        title: 'Guides',
        keywords: ['guides'],
      },
      items: [
        'guides/configuration',
        'guides/debugging',
        'guides/network-interception',
        'guides/headless-modes',
        'guides/screenshots',
        'guides/pdf-generation',
        'guides/chrome-extensions',
        'guides/cookies',
        'guides/files',
        'guides/running-puppeteer-in-the-browser',
        'guides/running-puppeteer-in-extensions',
      ],
    },
    'examples',
    {
      type: 'category',
      label: 'Integrations',
      link: {
        type: 'generated-index',
        title: 'Puppeteer Integrations',
        keywords: ['integrations'],
      },
      items: [
        {
          type: 'doc',
          label: 'Angular',
          id: 'guides/ng-schematics',
        },
        {
          type: 'doc',
          label: 'Docker',
          id: 'guides/docker',
        },
      ],
    },
    {
      type: 'category',
      label: 'Community',
      link: {
        type: 'generated-index',
        title: 'Community',
        keywords: ['community'],
      },
      items: ['contributing', 'troubleshooting', 'guides/links'],
    },
    'webdriver-bidi',
    'supported-browsers',
    'faq',
  ],
  api: [
    {
      type: 'autogenerated',
      dirName: 'api',
    },
  ],
  browsersApi: [
    {
      type: 'autogenerated',
      dirName: 'browsers-api',
    },
  ],
};
