# Supported browsers

## Chrome

Starting with v20.0.0 Puppeteer downloads and works with **[Chrome for Testing](https://github.com/GoogleChromeLabs/chrome-for-testing?tab=readme-ov-file#what-is-chrome-for-testing)**, which supports both headless and headful modes sharing the same code path in the browser.
The old headless mode is now a separate program called **[chrome-headless-shell](https://developer.chrome.com/blog/chrome-headless-shell)** (use `headless: 'shell'` with Puppeteer).

Prior to this version Puppeteer downloaded and worked with Chromium.

## Firefox

Starting with v23.0.0 Puppeteer downloads and works with the stable release of [Firefox](https://www.mozilla.org/en-US/firefox/).

Prior to this version Puppeteer downloaded and worked with the nightly versions of Firefox at the time.

## Supported browser version list

The following table provides mapping between the Puppeteer version and the browsers version you can use it with.
If an exact matching version of Puppeteer isn't listed, the supported version of the browser is that for the immediately prior version:

<!-- version-start -->

| Puppeteer                                                                                              | Chrome                                                                                     | Firefox                                                   |
| ------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------ | --------------------------------------------------------- |
| [Puppeteer v23.6.1](https://github.com/puppeteer/puppeteer/blob/puppeteer-v23.6.1/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 130.0.6723.69  | [Firefox](https://www.mozilla.org/en-US/firefox/) 131.0.3 |
| [Puppeteer v23.6.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v23.6.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 130.0.6723.58  | [Firefox](https://www.mozilla.org/en-US/firefox/) 131.0.3 |
| [Puppeteer v23.5.3](https://github.com/puppeteer/puppeteer/blob/puppeteer-v23.5.3/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 129.0.6668.100 | [Firefox](https://www.mozilla.org/en-US/firefox/) 131.0.2 |
| [Puppeteer v23.5.2](https://github.com/puppeteer/puppeteer/blob/puppeteer-v23.5.2/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 129.0.6668.91  | [Firefox](https://www.mozilla.org/en-US/firefox/) 131.0   |
| [Puppeteer v23.5.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v23.5.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 129.0.6668.89  | [Firefox](https://www.mozilla.org/en-US/firefox/) 131.0   |
| [Puppeteer v23.4.1](https://github.com/puppeteer/puppeteer/blob/puppeteer-v23.4.1/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 129.0.6668.70  | [Firefox](https://www.mozilla.org/en-US/firefox/) 130.0.1 |
| [Puppeteer v23.4.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v23.4.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 129.0.6668.58  | [Firefox](https://www.mozilla.org/en-US/firefox/) 130.0.1 |
| [Puppeteer v23.3.1](https://github.com/puppeteer/puppeteer/blob/puppeteer-v23.3.1/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 128.0.6613.137 | [Firefox](https://www.mozilla.org/en-US/firefox/) 130.0   |
| [Puppeteer v23.3.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v23.3.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 128.0.6613.119 | [Firefox](https://www.mozilla.org/en-US/firefox/) 130.0   |
| [Puppeteer v23.2.2](https://github.com/puppeteer/puppeteer/blob/puppeteer-v23.2.2/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 128.0.6613.119 | [Firefox](https://www.mozilla.org/en-US/firefox/) 129.0.2 |
| [Puppeteer v23.2.1](https://github.com/puppeteer/puppeteer/blob/puppeteer-v23.2.1/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 128.0.6613.86  | [Firefox](https://www.mozilla.org/en-US/firefox/) 129.0.2 |
| [Puppeteer v23.2.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v23.2.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 128.0.6613.84  | [Firefox](https://www.mozilla.org/en-US/firefox/) 129.0.2 |
| [Puppeteer v23.1.1](https://github.com/puppeteer/puppeteer/blob/puppeteer-v23.1.1/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 127.0.6533.119 | [Firefox](https://www.mozilla.org/en-US/firefox/) 129.0.2 |
| [Puppeteer v23.1.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v23.1.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 127.0.6533.119 | [Firefox](https://www.mozilla.org/en-US/firefox/) 129.0   |
| [Puppeteer v23.0.2](https://github.com/puppeteer/puppeteer/blob/puppeteer-v23.0.2/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 127.0.6533.99  | [Firefox](https://www.mozilla.org/en-US/firefox/) 129.0   |
| [Puppeteer v23.0.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v23.0.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 127.0.6533.88  | [Firefox](https://www.mozilla.org/en-US/firefox/) 129.0   |
| [Puppeteer v22.15.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.15.0/docs/api/index.md) | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 127.0.6533.88  | Firefox Nightly (at the time)                             |
| [Puppeteer v22.14.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.14.0/docs/api/index.md) | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 127.0.6533.72  | Firefox Nightly (at the time)                             |
| [Puppeteer v22.13.1](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.13.1/docs/api/index.md) | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 126.0.6478.182 | Firefox Nightly (at the time)                             |
| [Puppeteer v22.12.1](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.12.1/docs/api/index.md) | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 126.0.6478.126 | Firefox Nightly (at the time)                             |
| [Puppeteer v22.12.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.12.0/docs/api/index.md) | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 126.0.6478.63  | Firefox Nightly (at the time)                             |
| [Puppeteer v22.11.1](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.11.1/docs/api/index.md) | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 126.0.6478.61  | Firefox Nightly (at the time)                             |
| [Puppeteer v22.11.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.11.0/docs/api/index.md) | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 126.0.6478.55  | Firefox Nightly (at the time)                             |
| [Puppeteer v22.10.1](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.10.1/docs/api/index.md) | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 125.0.6422.141 | Firefox Nightly (at the time)                             |
| [Puppeteer v22.10.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.10.0/docs/api/index.md) | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 125.0.6422.78  | Firefox Nightly (at the time)                             |
| [Puppeteer v22.9.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.9.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 125.0.6422.60  | Firefox Nightly (at the time)                             |
| [Puppeteer v22.8.2](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.8.2/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 124.0.6367.207 | Firefox Nightly (at the time)                             |
| [Puppeteer v22.8.1](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.8.1/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 124.0.6367.201 | Firefox Nightly (at the time)                             |
| [Puppeteer v22.8.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.8.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 124.0.6367.91  | Firefox Nightly (at the time)                             |
| [Puppeteer v22.7.1](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.7.1/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 124.0.6367.78  | Firefox Nightly (at the time)                             |
| [Puppeteer v22.7.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.7.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 124.0.6367.60  | Firefox Nightly (at the time)                             |
| [Puppeteer v22.6.4](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.6.4/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 123.0.6312.122 | Firefox Nightly (at the time)                             |
| [Puppeteer v22.6.3](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.6.3/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 123.0.6312.105 | Firefox Nightly (at the time)                             |
| [Puppeteer v22.6.2](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.6.2/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 123.0.6312.86  | Firefox Nightly (at the time)                             |
| [Puppeteer v22.6.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.6.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 123.0.6312.58  | Firefox Nightly (at the time)                             |
| [Puppeteer v22.5.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.5.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 122.0.6261.128 | Firefox Nightly (at the time)                             |
| [Puppeteer v22.4.1](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.4.1/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 122.0.6261.111 | Firefox Nightly (at the time)                             |
| [Puppeteer v22.4.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.4.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 122.0.6261.94  | Firefox Nightly (at the time)                             |
| [Puppeteer v22.3.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.3.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 122.0.6261.69  | Firefox Nightly (at the time)                             |
| [Puppeteer v22.2.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v22.2.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 122.0.6261.57  | Firefox Nightly (at the time)                             |
| [Puppeteer v21.9.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v21.9.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 121.0.6167.85  | Firefox Nightly (at the time)                             |
| [Puppeteer v21.8.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v21.8.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 120.0.6099.109 | Firefox Nightly (at the time)                             |
| [Puppeteer v21.5.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v21.5.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 119.0.6045.105 | Firefox Nightly (at the time)                             |
| [Puppeteer v21.4.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v21.4.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 118.0.5993.70  | Firefox Nightly (at the time)                             |
| [Puppeteer v21.3.7](https://github.com/puppeteer/puppeteer/blob/puppeteer-v21.3.7/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 117.0.5938.149 | Firefox Nightly (at the time)                             |
| [Puppeteer v21.3.2](https://github.com/puppeteer/puppeteer/blob/puppeteer-v21.3.2/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 117.0.5938.92  | Firefox Nightly (at the time)                             |
| [Puppeteer v21.3.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v21.3.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 117.0.5938.62  | Firefox Nightly (at the time)                             |
| [Puppeteer v21.1.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v21.1.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 116.0.5845.96  | Firefox Nightly (at the time)                             |
| [Puppeteer v21.0.2](https://github.com/puppeteer/puppeteer/blob/puppeteer-v21.0.2/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 115.0.5790.170 | Firefox Nightly (at the time)                             |
| [Puppeteer v21.0.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v21.0.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 115.0.5790.102 | Firefox Nightly (at the time)                             |
| [Puppeteer v20.9.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v20.9.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 115.0.5790.98  | Firefox Nightly (at the time)                             |
| [Puppeteer v20.7.2](https://github.com/puppeteer/puppeteer/blob/puppeteer-v20.7.2/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 114.0.5735.133 | Firefox Nightly (at the time)                             |
| [Puppeteer v20.6.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v20.6.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 114.0.5735.90  | Firefox Nightly (at the time)                             |
| [Puppeteer v20.1.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v20.1.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 113.0.5672.63  | Firefox Nightly (at the time)                             |
| [Puppeteer v20.0.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v20.0.0/docs/api/index.md)   | [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) 112.0.5615.121 | Firefox Nightly (at the time)                             |
| [Puppeteer v19.8.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v19.8.0/docs/api/index.md)   | Chromium 112.0.5614.0                                                                      | Firefox Nightly (at the time)                             |
| [Puppeteer v19.7.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v19.7.0/docs/api/index.md)   | Chromium 111.0.5556.0                                                                      | Firefox Nightly (at the time)                             |
| [Puppeteer v19.6.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v19.6.0/docs/api/index.md)   | Chromium 110.0.5479.0                                                                      | Firefox Nightly (at the time)                             |
| [Puppeteer v19.4.0](https://github.com/puppeteer/puppeteer/blob/puppeteer-v19.4.0/docs/api/index.md)   | Chromium 109.0.5412.0                                                                      | Firefox Nightly (at the time)                             |
| [Puppeteer v19.2.0](https://github.com/puppeteer/puppeteer/blob/v19.2.0/docs/api/index.md)             | Chromium 108.0.5351.0                                                                      | Firefox Nightly (at the time)                             |
| [Puppeteer v18.1.0](https://github.com/puppeteer/puppeteer/blob/v18.1.0/docs/api/index.md)             | Chromium 107.0.5296.0                                                                      | Firefox Nightly (at the time)                             |
| [Puppeteer v17.1.0](https://github.com/puppeteer/puppeteer/blob/v17.1.0/docs/api/index.md)             | Chromium 106.0.5249.0                                                                      | Firefox Nightly (at the time)                             |
| [Puppeteer v15.5.0](https://github.com/puppeteer/puppeteer/blob/v15.5.0/docs/api/index.md)             | Chromium 105.0.5173.0                                                                      | Firefox Nightly (at the time)                             |
| [Puppeteer v15.1.0](https://github.com/puppeteer/puppeteer/blob/v15.1.0/docs/api.md)                   | Chromium 104.0.5109.0                                                                      | Firefox Nightly (at the time)                             |
| [Puppeteer v14.2.0](https://github.com/puppeteer/puppeteer/blob/v14.2.0/docs/api.md)                   | Chromium 103.0.5059.0                                                                      | Firefox Nightly (at the time)                             |
| [Puppeteer v14.0.0](https://github.com/puppeteer/puppeteer/blob/v14.0.0/docs/api.md)                   | Chromium 102.0.5002.0                                                                      | Firefox Nightly (at the time)                             |
| [Puppeteer v13.6.0](https://github.com/puppeteer/puppeteer/blob/v13.6.0/docs/api.md)                   | Chromium 101.0.4950.0                                                                      | Firefox Nightly (at the time)                             |
| [Puppeteer v13.5.0](https://github.com/puppeteer/puppeteer/blob/v13.5.0/docs/api.md)                   | Chromium 100.0.4889.0                                                                      | Firefox Nightly (at the time)                             |
| [Puppeteer v13.2.0](https://github.com/puppeteer/puppeteer/blob/v13.2.0/docs/api.md)                   | Chromium 99.0.4844.16                                                                      | Firefox Nightly (at the time)                             |
| [Puppeteer v13.1.0](https://github.com/puppeteer/puppeteer/blob/v13.1.0/docs/api.md)                   | Chromium 98.0.4758.0                                                                       | Firefox Nightly (at the time)                             |
| [Puppeteer v12.0.0](https://github.com/puppeteer/puppeteer/blob/v12.0.0/docs/api.md)                   | Chromium 97.0.4692.0                                                                       | Firefox Nightly (at the time)                             |
| [Puppeteer v10.2.0](https://github.com/puppeteer/puppeteer/blob/v10.2.0/docs/api.md)                   | Chromium 93.0.4577.0                                                                       | Firefox Nightly (at the time)                             |
| [Puppeteer v10.0.0](https://github.com/puppeteer/puppeteer/blob/v10.0.0/docs/api.md)                   | Chromium 92.0.4512.0                                                                       | Firefox Nightly (at the time)                             |
| [Puppeteer v9.0.0](https://github.com/puppeteer/puppeteer/blob/v9.0.0/docs/api.md)                     | Chromium 91.0.4469.0                                                                       | Firefox Nightly (at the time)                             |
| [Puppeteer v8.0.0](https://github.com/puppeteer/puppeteer/blob/v8.0.0/docs/api.md)                     | Chromium 90.0.4427.0                                                                       | Firefox Nightly (at the time)                             |
| [Puppeteer v7.0.0](https://github.com/puppeteer/puppeteer/blob/v7.0.0/docs/api.md)                     | Chromium 90.0.4403.0                                                                       | Firefox Nightly (at the time)                             |
| [Puppeteer v6.0.0](https://github.com/puppeteer/puppeteer/blob/v6.0.0/docs/api.md)                     | Chromium 89.0.4389.0                                                                       | Firefox Nightly (at the time)                             |
| [Puppeteer v5.5.0](https://github.com/puppeteer/puppeteer/blob/v5.5.0/docs/api.md)                     | Chromium 88.0.4298.0                                                                       | Firefox Nightly (at the time)                             |
| [Puppeteer v5.4.0](https://github.com/puppeteer/puppeteer/blob/v5.4.0/docs/api.md)                     | Chromium 87.0.4272.0                                                                       | Firefox Nightly (at the time)                             |
| [Puppeteer v5.3.0](https://github.com/puppeteer/puppeteer/blob/v5.3.0/docs/api.md)                     | Chromium 86.0.4240.0                                                                       | Firefox Nightly (at the time)                             |
| [Puppeteer v5.2.1](https://github.com/puppeteer/puppeteer/blob/v5.2.1/docs/api.md)                     | Chromium 85.0.4182.0                                                                       | Firefox Nightly (at the time)                             |
| [Puppeteer v5.1.0](https://github.com/puppeteer/puppeteer/blob/v5.1.0/docs/api.md)                     | Chromium 84.0.4147.0                                                                       | Firefox Nightly (at the time)                             |
| [Puppeteer v3.1.0](https://github.com/puppeteer/puppeteer/blob/v3.1.0/docs/api.md)                     | Chromium 83.0.4103.0                                                                       | Firefox Nightly (at the time)                             |
| [Puppeteer v3.0.0](https://github.com/puppeteer/puppeteer/blob/v3.0.0/docs/api.md)                     | Chromium 81.0.4044.0                                                                       | Firefox Nightly (at the time)                             |
| [Puppeteer v2.1.0](https://github.com/puppeteer/puppeteer/blob/v2.1.0/docs/api.md)                     | Chromium 80.0.3987.0                                                                       | Firefox Nightly (at the time)                             |
| [Puppeteer v2.0.0](https://github.com/puppeteer/puppeteer/blob/v2.0.0/docs/api.md)                     | Chromium 79.0.3942.0                                                                       | Firefox not supported                                     |
| [Puppeteer v1.20.0](https://github.com/puppeteer/puppeteer/blob/v1.20.0/docs/api.md)                   | Chromium 78.0.3882.0                                                                       | Firefox not supported                                     |
| [Puppeteer v1.19.0](https://github.com/puppeteer/puppeteer/blob/v1.19.0/docs/api.md)                   | Chromium 77.0.3803.0                                                                       | Firefox not supported                                     |
| [Puppeteer v1.17.0](https://github.com/puppeteer/puppeteer/blob/v1.17.0/docs/api.md)                   | Chromium 76.0.3803.0                                                                       | Firefox not supported                                     |
| [Puppeteer v1.15.0](https://github.com/puppeteer/puppeteer/blob/v1.15.0/docs/api.md)                   | Chromium 75.0.3765.0                                                                       | Firefox not supported                                     |
| [Puppeteer v1.13.0](https://github.com/puppeteer/puppeteer/blob/v1.13.0/docs/api.md)                   | Chromium 74.0.3723.0                                                                       | Firefox not supported                                     |
| [Puppeteer v1.12.2](https://github.com/puppeteer/puppeteer/blob/v1.12.2/docs/api.md)                   | Chromium 73.0.3679.0                                                                       | Firefox not supported                                     |

<!-- version-end -->
