# What is Puppeteer?

Puppeteer is a JavaScript library which provides a high-level API to
control Chrome or Firefox over the [DevTools Protocol](https://chromedevtools.github.io/devtools-protocol/) or
[WebDriver BiDi](https://pptr.dev/webdriver-bidi). Puppeteer runs in the
headless (no visible UI) by default but can be configured to run in a
visible ("headful") browser.

# Features

Most things that you can do manually in the browser can be done using Puppeteer!
Here are a few examples to get you started:

- Automate form submission, UI testing, keyboard input, etc.
- Create an automated testing environment using the latest JavaScript and
  browser features.
- Capture a
  [timeline trace](https://developer.chrome.com/docs/devtools/performance/reference)
  of your site to help diagnose performance issues.
- [Test Chrome Extensions](https://pptr.dev/guides/chrome-extensions).
- Generate screenshots and PDFs of pages.
- Crawl a SPA (Single-Page Application) and generate pre-rendered content (i.e.
  "SSR" (Server-Side Rendering)).
