# FAQ

## Q: Who maintains Puppeteer?

The Chrome Browser Automation team maintains the library, but we'd love your help and
expertise on the project! See our
[contributing guide](https://pptr.dev/contributing).

## Q: What is the status of cross-browser support?

From Puppeteer v23.0.0 onwards Puppeteer provides support for both Chrome and Firefox.

To automate Chrome Puppeteer uses the Chrome DevTools Protocol (CDP) by default, but it can
also be automated using WebDriver BiDi which is the default for automating Firefox.

To understand the subtle differences in API support refer to our
[WebDriver BiDi guide](https://pptr.dev/webdriver-bidi).

## Q: Does Puppeteer support WebDriver BiDi?

From Puppeteer v23.0.0 and up Puppeteer has production-ready support for WebDriver BiDi
to automate both Chrome and Firefox.

## Q: Will keep Puppeteer supporting CDP?

We are not going to stop supporting automation of Chrome with CDP - despite
Puppeteer's support for WebDriver BiDi. To not break existing automations relying on CDP,
but also to keep enabling automation use-cases unique to Chrome and not standardized
with WebDriver BiDi.

## Q: What are Puppeteer’s goals and principles?

The goals of the project are:

- Provide a reference implementation that highlights the capabilities of the
  [Chrome DevTools](https://chromedevtools.github.io/devtools-protocol/)
  and [WebDriver BiDi](https://w3c.github.io/webdriver-bidi/) protocols.
- Grow the adoption of automated cross-browser testing.
- Help dogfood new DevTools Protocol and WebDriver BiDi features...and catch bugs!
- Learn more about the pain points of automated browser testing and help fill
  those gaps.

We adapt
[Chromium principles](https://www.chromium.org/developers/core-principles) to
help us drive product decisions:

- **Speed**: Puppeteer has almost zero performance overhead over an automated
  page.
- **Security**: Puppeteer operates off-process with respect to the browser, making
  it safe to automate potentially malicious pages.
- **Stability**: Puppeteer should not be flaky and should not leak memory.
- **Simplicity**: Puppeteer provides a high-level API that’s easy to use,
  understand, and debug.

## Q: Is Puppeteer a replacement for Selenium?

Puppeteer is a Node.js based reference implementation of how to automate browsers
with CDP and WebDriver BiDi - the same web standard the Selenium project is also
contributing to.

The Selenium project goes beyond what Puppeteer offers in multiple aspects: it provides
bindings for more languages than just JavaScript and for example it also offers tooling
to orchestrate automation at large, like Selenium Grid. Both is beyond Puppeteer's scope.

There are community projects that add capabilities to Puppeteer beyond its core,
making things like testing more convenient. For example see:

- [jest-puppeteer](https://github.com/smooth-code/jest-puppeteer) or
- [Puppeteer's Angular integration](https://pptr.dev/integrations/ng-schematics)

## Q: Why doesn’t Puppeteer v.XXX work with a certain version of Chrome or Firefox?

Every Puppeteer release is tightly bundled with a specific browser release
to ensure compatibility with the implementation of the underlying protocols,
the Chrome DevTools Protocol and WebDriver BiDi.

This is to prevent changes in either Chrome or Firefox not unexpectedly break Puppeteer.

## Q: Which Chrome and Firefox version does Puppeteer use?

Look for the `chrome` and `firefox` entries in
[revisions.ts](https://github.com/puppeteer/puppeteer/blob/main/packages/puppeteer-core/src/revisions.ts).

## Q: What’s considered a “Navigation”?

From Puppeteer’s standpoint, **“navigation” is anything that changes a page’s
URL**. Aside from regular navigation where the browser hits the network to fetch
a new document from the web server, this includes
[anchor navigations](https://www.w3.org/TR/html5/single-page.html#scroll-to-fragid)
and [History API](https://developer.mozilla.org/en-US/docs/Web/API/History_API)
usage.

With this definition of “navigation,” **Puppeteer works seamlessly with
single-page applications.**

## Q: What’s the difference between a “trusted" and "untrusted" input event?

In browsers, input events could be divided into two big groups: trusted vs.
untrusted.

- **Trusted events**: events generated by users interacting with the page, e.g.
  using a mouse or keyboard.
- **Untrusted event**: events generated by Web APIs, e.g. `document.createEvent`
  or `element.click()` methods.

Websites can distinguish between these two groups:

- using an
  [`Event.isTrusted`](https://developer.mozilla.org/en-US/docs/Web/API/Event/isTrusted)
  event flag
- sniffing for accompanying events. For example, every trusted `'click'` event
  is preceded by `'mousedown'` and `'mouseup'` events.

For automation purposes it’s important to generate trusted events. **All input
events generated with Puppeteer are trusted and fire proper accompanying
events.** If, for some reason, one needs an untrusted event, it’s always
possible to hop into a page context with `page.evaluate` and generate a fake
event:

```ts
await page.evaluate(() => {
  document.querySelector('button[type=submit]').click();
});
```

## Q: Does Puppeteer support media and audio playback?

Puppeteer uses [Chrome for Testing](https://developer.chrome.com/blog/chrome-for-testing/) binaries
by default which ship with properietary codecs support starting from
[M120](https://chromiumdash.appspot.com/commit/12d607016c31ea13579e897740c765be189ed6eb).

## Q: I am having trouble installing / running Puppeteer in my test environment. Where should I look for help?

We have a
[troubleshooting](https://pptr.dev/troubleshooting)
guide for various operating systems that lists the required dependencies.

## Q: I have more questions! Where do I ask?

There are many ways to get help on Puppeteer:

- For questions: [Stack Overflow](https://stackoverflow.com/questions/tagged/puppeteer)
- For bug reports: [GitHub Issues](https://github.com/puppeteer/puppeteer/issues)

Make sure to search these channels before posting your question.
