# Examples & Use cases

## Official examples

[The Puppeteer repository](https://github.com/puppeteer/puppeteer/tree/main/examples) includes a small number of examples maintained by the Puppeteer team.

Follow the instructions in the README to run the examples, covering use cases like creating PDFs from websites, creating screenshots or intercepting requests.

## Example suite

Find a set of unstructured examples in Puppeteer's dedicated [example repository](https://github.com/puppeteer/examples).

This suite is a collection of examples that has been growing over time and covers various use cases like forwarding events
from your Puppeteer process to the browser, interacting with elements and running CDP commands.

## Other projects, articles and demos

See the following list for use cases and examples from categories like Rendering, Web scraping and Testing.

### Rendering and web scraping

- **[Puppetron](https://github.com/cheeaun/puppetron)**: Demo site that shows
  how to use Puppeteer and Headless Chrome to render pages. Inspired by
  [GoogleChrome/rendertron](https://github.com/GoogleChrome/rendertron).
- **[Thal](https://medium.com/@e_mad_ehsan/getting-started-with-puppeteer-and-chrome-headless-for-web-scrapping-6bf5979dee3e)**:
  Get started with Puppeteer and Chrome Headless for Web Scraping.
- **[pupperender](https://github.com/LasaleFamine/pupperender)**: Express
  middleware that checks the User-Agent header of incoming requests, and if
  it matches one of a configurable set of bots, render the page using Puppeteer.
  Useful for PWA rendering.
- **[headless-chrome-crawler](https://github.com/yujiosaka/headless-chrome-crawler)**:
  Crawler that provides APIs to manipulate Headless Chrome and lets you crawl
  dynamic websites.
- **[Puppeteer examples from Checkly](https://www.checklyhq.com/learn/headless/basics-puppeteer-intro/)**:
  E2E Puppeteer examples for real life use cases, such as getting
  useful info from the web pages or common login scenarios.
- **[browserless](https://github.com/browserless/browserless)**: Headless
  Chrome as a service letting you execute Puppeteer scripts remotely.
- **[Puppeteer on AWS Lambda](https://github.com/jay-deshmukh/headless-chrome-with-puppeteer-on-AWS-lambda-with-serverless-framework)**:
  Run puppeteer on AWS Lambda with Serverless framework
- **[Apify SDK](https://github.com/apifytech/apify-js)**: The scalable web
  crawling and scraping library for JavaScript. Automatically manages a pool of
  Puppeteer browsers and provides error handling, task management, proxy
  rotation and more.

### Testing

- **[angular-puppeteer-demo](https://github.com/Quramy/angular-puppeteer-demo)**:
  Demo repository explaining how to use Puppeteer in Karma.
- **[mocha-headless-chrome](https://github.com/direct-adv-interfaces/mocha-headless-chrome)**:
  Tool which runs client-side mocha tests in the command line through headless
  Chrome.
- **[puppeteer-to-istanbul-example](https://github.com/bcoe/puppeteer-to-istanbul-example)**:
  Demo repository demonstrating how to output Puppeteer coverage in Istanbul
  format.
- **[jest-puppeteer](https://github.com/smooth-code/jest-puppeteer)**: (almost)
  Zero configuration tool for setting up and running Jest and Puppeteer. Also
  includes an assertion library for Puppeteer.
- **[puppeteer-har](https://github.com/Everettss/puppeteer-har)**: Generate HAR
  file with puppeteer.
- **[puppetry](https://puppetry.app/)**: A desktop app to build Puppeteer and
  Jest driven tests without coding.
- **[puppeteer-loadtest](https://github.com/svenkatreddy/puppeteer-loadtest)**:
  command line interface for performing load test on Puppeteer scripts.
- **[cucumber-puppeteer-example](https://github.com/mlampedx/cucumber-puppeteer-example)**:
  Example repository demonstrating how to use Puppeeteer and Cucumber for
  integration testing.
