## Default Security Policy

When you call {@link ChatEngine#connect| ```ChatEngine.connect()``` } with a
{@link User#uuid | ```UUID``` } parameter, the client SDK calls
[PubNub Functions](https://www.pubnub.com/products/functions/) and
[Access Manager](https://www.pubnub.com/tutorials/pubnub-access-manager/) features
to grant the user access to a set of chat channels by default. Once access is granted,
the user’s {@link User#uuid | ```UUID``` } and chat association is stored in PubNub and
used for future logins.

```js
ChatEngine.connect('UUID');
```

The method also allows you to provide an ```authKey``` for added security.
When an ```authKey```  is provided, the user is granted access to chat channels based on
the UUID and ```authKey```. Typically an ```authKey```  is generated by a third party
authentication service and passed on to PubNub.

```js
ChatEngine.connect('UUID', {}, 'authKey');
```

Each user is granted access to the following channels upon login:


| Channel | Reference      | Sample Format | Default Permissions |
|:-------:|:--------------:|:-------------:|:--------------------|
| Global Channel | {@link ```ChatEngine#.global```} | ```chat-engine``` | ```read```/```write``` access for all users. |
| Direct Channel | {@link ```Me#direct```} | ```chat-engine#user#uuid#write#direct``` | The user who owns the channel has all permissions, while other users only have ```write``` permissions |
| Feed Channel | {@link ```Me#feed```} | ```chat-engine#user#uuid#read#feed``` | The user who owns the channel has all permissions, while other users only have ```read``` permissions |
| Public Channels | {@link ```ChatEngine#chats```} | ```chat-engine#chat#public.#custom-channel``` | ```read```/```write``` access for all users. |
| Private Channels | {@link ```ChatEngine#chats```} | ```chat-engine#chat#private.#private-channel``` | ```read```/```write``` access for all users. |

## Securing Chats

The default ```authPolicy()``` method for ChatEngine is open and has no restrictions
on the chats a user can join. A user’s private, feed, and direct chats are
accessible by anyone.

ChatEngine developers may update this ```authPolicy()``` method to introduce stricter access
control across their ChatEngine user base.

It is possible to edit the default auth policy by adding logic to the ChatEngine PubNub 
Function. This logic can be added to the ```authPolicy()`` method within the PubNub
Function code.

For example, you may send a request to a 3rd party server to validate a user’s UUID
and ```authKey```. If the ```authKey``` is invalid or expired, the auth policy can
prevent the client from ever connecting.

Follow the steps below to edit the ChatEngine auth policy:

- Navigate to the [PubNub Admin Portal](https://admin.pubnub.com/).
- Find your ChatEngine app.
- Locate the ChatEngine PubNub Functions.
- Edit the ```authPolicy()``` code within the PubNub Function.
- Save the PubNub Function code and restart the PubNub Module.
