## Basics

Currently, ChatEngine leverages two internal PubNub services to handle _granting_ and _revoking_ user access control lists (ACLs) across the various chat channels assigned to CE users.

1. PubNub [Functions](https://www.pubnub.com/tutorials/pubnub-functions/) (microservice).
2. PubNub Access Monitor ([PAM](https://www.pubnub.com/tutorials/pubnub-access-manager/)).

In short, communication follows this pattern:

1. ChatEngine Client code sends a series of RESTful HTTP calls to a PubNub On Request Function (i.e. a microservice running the ChatEngine backend).
2. ChatEngine first tries to connect to default chat channels generated from ```ChatEngine.global```. The PubNub ChatEngine Function receives a request and makes subsequent ```grant``` calls to PubNub's PAM service (the authorization service), granting either read and/or write access to appropriate ChatEngine ```ChatEngine.global``` chat channels.
3. Next, ChatEngine tries to connect to default chat channels generated from ```ChatEngine.Me```. Similar to step 2, requests are routed to the PubNub ChatEngine On Request Function, granting read and/or write access to the relevant ChatEngine ```ChatEngine.Me``` chat channels.
4. After the two connection attempts, if successful, ChatEngine emits a ```$.ready``` event, signaling that ChatEngine has successfully initialized and connected to the default ```ChatEngine.global``` and ```ChatEngine.Me``` chat channels.

> A ```secretKey``` is required to grant access with PAM. The PubNub ChatEngine Function stores an encrypted version of the ```secretKey``` within a secret store ([PubNub Functions Vault module](https://www.pubnub.com/docs/blocks/vault-module))

## Editing the Default Security Policy

While the default ChatEngine security policy is sufficient to prevent users from accessing other users' _private_, _feed_ and _direct_ chats, a user might still be able to connect to ChatEngine with a random ```UUID``` and access all [public chats](connect.md#Connect ChatEngine.Global).

In order to implement additional security controls, the default security policy can be amended by adding logic to the PubNub ChatEngine Function. Since ```authKeys``` are generated by your server, a custom policy can be added in the PubNub ChatEngine Function to send XMLHttpRequest (XHR) requests to the server to validate a user ```UUID``` and ```authKey```. If the ```authKey``` is invalid or expired, the PubNub ChatEngine Function can block the ```ChatEngine.connect()``` call.

This effectively provides ChatEngine with authentication logic. To read further on this topic, refer to the following documentation on [adding authentication to CE](../advancedConcepts/authentication.md).
