/*
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'@Module Name:  MouseHook(.cpp)
'@Main Func:    Hook
'@Author:       denglf
'@Last Modify:  2018-08-18
'@Notes:
'@Interface:
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
*/

// MouseHook.cpp : Implementation of CMouseHook
#include "stdafx.h"
#include "TSubclass.h"
#include "MouseHook.h"

MouseHookObject gMouseHook[MaxMouseHooks];
MouseObject gMouseObj[MaxMouseHooks];  

int gMouseHooks = 0;
int gMouseObjs = 0;

/////////////////////////////////////////////////////////////////////////////
// CMouseHook


// ȡǰעHook
HHOOK GetCurrentMouseHook()
{
	DWORD id = GetCurrentThreadId();
	for(int i=0; i<gMouseHooks; i++)
	{
		if(gMouseHook[i].id == id)
		{
			return gMouseHook[i].hHook;
		}
	}
	
	return NULL;
}

// Hook
LRESULT CALLBACK MouseHookProc(int nCode, WPARAM wParam, LPARAM lParam)
{
	HHOOK hHook = GetCurrentMouseHook();
	long bEatIt = 0;
	
	//ֻϢַǰ
	if (nCode == HC_ACTION)
	{
		MOUSEHOOKSTRUCT lpMHx;
		long hWnd = 0;
		UINT uMsg = 0;
		long x = 0;
		long y = 0;
		long wMouseData = 0;
		
		//ռϢ
		CopyMemory(&lpMHx, (void*)lParam, sizeof(lpMHx));
		hWnd = (long)lpMHx.hwnd;
		uMsg = wParam;
		x = lpMHx.pt.x;
		y = lpMHx.pt.y;
		wMouseData = lpMHx.dwExtraInfo;
		if (_WIN32_WINNT) //NTϵͳȡ־Ҫ⴦
		{
			MSLLHOOKSTRUCT lpMHn;
			CopyMemory(&lpMHn, (void*)lParam, sizeof(lpMHn));
			wMouseData = lpMHn.dwExtraInfo;
		}
	
		//Ϣַ
		for(int i=0; i<gMouseObjs; i++)
		{
			if(gMouseObj[i].hHook == hHook)
			{	
				gMouseObj[i].pOwner->Fire_OnMessage(hWnd, uMsg, x, y, wMouseData, &bEatIt);
			}
		}
	}
	
	//
	if (bEatIt)
	{
		return -1;
	}
	else
	{
		/*
		MSDN: Calling CallNextHookEx is optional, but it is highly recommended; otherwise, 
		other applications that have installed hooks will not receive hook notifications and may behave incorrectly as a result. 
		You should call CallNextHookEx unless you absolutely need to prevent the notification from being seen by other applications. 
		MSDN: CallNextHookExǿѡģǿƼ
		Ѿװ˹ӵӦó򽫲յ֪ͨΪȷ
		ӦõCallNextHookExҪֹӦó򿴵֪ͨ
		*/
		return CallNextHookEx(hHook, nCode, wParam, lParam);
	}
}

// ϵͳɣҪ޸
STDMETHODIMP CMouseHook::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IMouseHook
	};
	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (::InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

//
STDMETHODIMP CMouseHook::AboutMe()
{
	MessageBox(NULL, ABOUTME, COPYRIGHT, MB_ICONWARNING | MB_OK);
	return S_OK;
}

// Hook
STDMETHODIMP CMouseHook::Hook(VARIANT_BOOL* outVal)
{
	*outVal = 0;

	if (!mbHooked)
	{
		int i = 0;

		//
		if (gMouseHooks >= MaxMouseHooks)
		{
			return FALSE;
		}
		if (gMouseObjs >= MaxMouseObjs)
		{
			return FALSE;
		}

		//ظע
		for(i=0; i<gMouseObjs; i++)
		{
			if(gMouseObj[i].pOwner == this)
			{
				return FALSE;
			}
		}
	
		//עHook
		HHOOK hHook = NULL;
		DWORD id = GetCurrentThreadId();
		for(i=0; i<gMouseHooks; i++)
		{
			if(gMouseHook[i].id == id)
			{
				hHook = gMouseHook[i].hHook;
				break;
			}
		}
		if (hHook == NULL)
		{
			/*
			The SetWindowsHookEx function installs an application-defined hook procedure into a hook chain. 
			You would install a hook procedure to monitor the system for certain types of events. 
			These events are associated either with a specific thread or with all threads in the system. 
			SetWindowsHookExӦóĹӴװϡ
			װһӴϵͳض͵¼
			Щ¼Ҫôض̹߳Ҫôϵͳе̹߳
			*/
			hHook = SetWindowsHookEx(WH_MOUSE, (HOOKPROC) MouseHookProc, GetModuleHandle(NULL), id);
			if(hHook == NULL) //Hookʧ
			{
				return S_FALSE;
			}
			else
			{
				gMouseHook[gMouseHooks].id = id;
				gMouseHook[gMouseHooks].hHook = hHook;
				gMouseHook[gMouseHooks].lock++; //סԱ
				gMouseHooks++;
			}
		}
		
		//ע
		gMouseObj[gMouseObjs].hHook = hHook;
		gMouseObj[gMouseObjs].pOwner = this;
		gMouseObjs++;
		
		//
		mbHooked = TRUE;
		*outVal = 1;
		return S_OK;
	}
	return S_FALSE;

}

// жHook
STDMETHODIMP CMouseHook::UnHook(VARIANT_BOOL* outVal)
{
	*outVal = 0;

	if (mbHooked)
	{
		Destory();
		mbHooked = FALSE;
		*outVal = 1;
		return S_OK;
	}
	return S_FALSE;

}

// Hook
void CMouseHook::Destory()
{	
	int i = 0;
	DWORD id = GetCurrentThreadId();
	HHOOK hHook = GetCurrentMouseHook();
	
	if (hHook != NULL)
	{
		//жصǰMouseVB:
		//Set mclsMouseHook1 = New TSubclass.MouseHook
		//Set mclsMouseHook2 = New TSubclass.MouseHook
		//...
		for(i=0; i<gMouseObjs; i++)
		{
			if(gMouseObj[i].pOwner == this) //ǰ
			{
				//עĴ1
				gMouseObjs--;
				
				//ǰƶ
				for(int k = i; k<gMouseObjs; k++)
				{
					gMouseObj[k].hHook = gMouseObj[k+1].hHook;
					gMouseObj[k].pOwner = gMouseObj[k+1].pOwner;
				}
				i--;
			}
		}
		
		//ǷҪжHook
		bool bUnhook = true;
		for(i=0; i<gMouseObjs; i++)
		{
			if(gMouseObj[i].hHook == hHook) //ȻעĶҽHook
			{
				bUnhook = false; 
				break;
			}
		}
		
		//жصǰעHook
		if(bUnhook)
		{
			for(i=0; i<gMouseHooks; i++)
			{
				if(gMouseHook[i].id == id)
				{
					gMouseHook[i].lock--; //
					if(gMouseHook[i].lock == 0)
					{
						//жHook
						UnhookWindowsHookEx(gMouseHook[i].hHook); 
						
						//עHook1
						gMouseHooks--;
						
						//ǰƶHook
						for(int k = i; k<gMouseHooks; k++)
						{
							gMouseHook[k].id = gMouseHook[k+1].id;
							gMouseHook[k].hHook = gMouseHook[k+1].hHook;
							gMouseHook[k].lock = gMouseHook[k+1].lock;
						}
					}
					break;
				}
			}
		}
		
		/*
		if(gMouseHooks<=0)
		{
			MessageBox(0, TEXT("ɾ"), TEXT("MouseHook"), 0);
		}
		*/

	}
}