// TFastDictInt.h : Declaration of the CFastDict

#ifndef __FASTDICTINT_H_
#define __FASTDICTINT_H_

#include "stdafx.h"
#include "resource.h"       // main symbols
#include "fastdict.h"

/////////////////////////////////////////////////////////////////////////////
// CFastDict
class ATL_NO_VTABLE CFastDict : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CFastDict, &CLSID_FastDict>,
	public IDispatchImpl<IFastDict, &IID_IFastDict, &LIBID_TFastDict>
{
public:
	CFastDict()
	{
		m_dic = new FastDict();
	}

	DECLARE_REGISTRY_RESOURCEID(IDR_FastDict)
	DECLARE_PROTECT_FINAL_CONSTRUCT()

	BEGIN_COM_MAP(CFastDict)
		COM_INTERFACE_ENTRY(IFastDict)
		COM_INTERFACE_ENTRY(IDispatch)
	END_COM_MAP()

	//
	// Դ
	//
	void FinalRelease()
	{
		m_dic->Destory();
		delete m_dic;
	}

// IFastDict
public:

	//
	STDMETHOD(AboutMe)();

	///ָĿ
	STDMETHOD(putref_Item)(/*[in]*/ VARIANT* Key, /*[in]*/ VARIANT* pItem);
    STDMETHOD(put_Item)(/*[in]*/ VARIANT* Key, /*[in]*/ VARIANT* pItem);
    STDMETHOD(get_Item)(/*[in]*/ VARIANT* Key, /*[out, retval]*/ VARIANT* pRetItem);

    //ֵһ¼
	STDMETHOD(Add)(/*[in]*/ VARIANT* Key, /*[in]*/ VARIANT* Item, /*[out, retval]*/ VARIANT_BOOL* pOk);

    //ֵеĿ
	STDMETHOD(get_Count)(/*[out, retval]*/ long* pCount);

	//жָļǷֵ
	STDMETHOD(Exists)(/*[in]*/ VARIANT* Key, /*[out, retval]*/ VARIANT_BOOL* pExists);

	//һ,аֵем
    STDMETHOD(Keys)(/*[out, retval]*/ VARIANT* pKeysArray);

	//һ,аֵеĿ
	STDMETHOD(Items)(/*[out, retval]*/ VARIANT* pItemsArray);

	//һ,аֵеĲҵĿ
	STDMETHOD(Query)(/*[in]*/ VARIANT* pItem, /*[out, retval]*/ VARIANT* pItemsArray);

	//ֵɾָļ
	STDMETHOD(Remove)(/*[in]*/ VARIANT* Key);

	//ɾֵеĿ
	STDMETHOD(RemoveAll)();

private:
	
	FastDict *m_dic;
};

#endif //__FASTDICTINT_H_
