
/*
	ģ飺ֵʵ
	ߣdenglf
	ڣ2019-04-24
	˵ο΢.NET Frameworks
*/

#ifndef __FASTDICT_H_
#define __FASTDICT_H_

#include <malloc.h>
#include "HashHelpers.h"
#include "VMemAlloc.h"

class FastDict
{
private:
	
	//ֵĿ,΢VB6ֵΪֵkeyitem_pair
	//ռ4+4+16*2=40ֽ
    struct dicitem
    {
        int32_t hash;		// ϣ, -1ʾĿѾɾ
        int32_t next;		// һĿ, -1ʾǰѾһĿ
        VARIANT	key;		// Ŀkey
        VARIANT value;		// Ŀvalue
    };
	
	int32_t *m_buckets;		// д
	dicitem	*m_items;		// Ŀ

	int32_t	m_capacity;		// ֵϣԪ
	int32_t	m_count;		// ֵĿ
	int32_t m_delIndex;		// ɾĿ
	int32_t	m_delCount;		// ɾĿ
	
	VMemAlloc m_mem;		// ڴ

public:

	FastDict()
	{
		m_buckets = NULL;
		m_items = NULL;
		m_capacity = 0;
		m_count = 0;
		m_delIndex = 0;
		m_delCount = 0;
		this->Initialize(DefaultHashTable);
	}

	//capacity: ֵ
	FastDict(int32_t capacity)
    {
		m_buckets = NULL;
		m_items = NULL;
		m_capacity = 0;
		m_count = 0;
		m_delIndex = 0;
		m_delCount = 0;

        if (capacity < 0)
        {
			capacity = DefaultHashTable;
        }
            
        if (capacity > 0)
        {
            this->Initialize(capacity);
        }
    }

	//Դ
	virtual ~FastDict()
	{
		this->Destory();
	}

	//Ӽֵ
	bool Add(VARIANT* key, VARIANT* value)
    {

		//hashcode
		int32_t hash = HashHelpers::GetHashCode(key) & 0x7FFFFFFF;//0x7FFFFFFF=2147483647 &ǽת

		//hashcodeôλ
		int32_t targetBucket = hash % m_capacity;

		//ӴвѯÿĿ:
		//ǰ״β,Ϊδʹ(-1),˲ѭ;
		//ǰѾĿѭ
		if (m_buckets[targetBucket] >= 0)
		{
			for (int32_t i = m_buckets[targetBucket]; i >= 0; i = m_items[i].next)
			{
				//УĿhashǷһ£ȽĿkeyǷͬ
				//if (m_items[i].hash == hash && KeyEqual(key, &m_items[i].key))
				if (m_items[i].hash == hash && (VarCmp(key, &m_items[i].key, 0) == 1))
				{
					//keyڵĻֵ滻
					VariantCopyInd(&m_items[i].value, value);
					//ز
					return true;
				}
			}
		}

		int32_t index = 0;
		if (m_delCount > 0)
		{
			//ɾĿлһ
			//ɾʱûͷſռ䣬˿ռɷãҲӿ˲ٶ
			index = m_delIndex;//һɾĿ
			m_delIndex = m_items[index].next;//ָһĿ
			m_delCount--;//ɾ
		}
		else
		{
			//ĿѾĿ(itemsѾ)bucketsitems
			//countΪǰĿitems.LengthΪ=۵
			//״βcount=0items.Length>0˲룬ֻеѾitemsʱŻ
			if (m_count == m_capacity)
			{
				//ݣͨݿԿ½ֵʱָcapacityĴСؼݵĴ
				if (this->Resize())
				{
					//ݳɹ¶λµĴۣԭhash % m_capacityĴλѾȷ
					targetBucket = hash % m_capacity;
				}
				else
				{
					//ʧܣڴ治
					return false;
				}
			}

			//¼һ/ɾĿ״ʱcount=0
			index = m_count;

			//Ŀ+1
			m_count++;
		}

		//ʼֵ
		VariantInit(&m_items[index].key);
		VariantInit(&m_items[index].value);

		//ֵ
		VariantCopyInd(&m_items[index].key, key);
		VariantCopyInd(&m_items[index].value, value);

		//hashcode
		m_items[index].hash = hash;

		//һ(next)ĿóɵǰеĿ,
		//۷ײʱϴιĿͳ˵ǰĿһĿ
		//ܹȷѭϵĿ
		m_items[index].next = m_buckets[targetBucket];
		
		//ڽĿλü¼ڴУڸݴ洢ҵĿ
		m_buckets[targetBucket] = index;

		//
		return true;
    }

	//ɾĿ
    bool Remove(VARIANT* key)
    {

        if (m_buckets != NULL)
        {

			//hashcode
			int32_t hash = HashHelpers::GetHashCode(key) & 0x7FFFFFFF;//0x7FFFFFFF=2147483647 &ǽת

			//hashcodeôλ
			int32_t bucket = hash % m_capacity;

			//ɾ
			if (m_buckets[bucket] >= 0)
			{
				int last = -1;
				for (int32_t i = m_buckets[bucket]; i >= 0; last = i, i = m_items[i].next)
				{
					if ((m_items[i].hash == hash) && KeyEqual(key, &m_items[i].key))
					//if ((m_items[i].hash == hash) && (VarCmp(key, &m_items[i].key, 0) == 1))
					{
						//ɾĿAddʱ
						if (last < 0)
						{
							m_buckets[bucket] = m_items[i].next;
						}
						else
						{
							m_items[last].next = m_items[i].next;
						}

						//ע: ɾʱûͷſռ
						m_items[i].hash = -1;//
						m_items[i].next = m_delIndex;//ָһĿ
						VariantClear(&m_items[i].key);//
						VariantClear(&m_items[i].value);//ֵ
						m_delIndex = i; //ָһĿ
						m_delCount++;
						return true;
					}
				}
			}
        }

        return false;
    }

	//ɾĿ
    void RemoveAll()
    {
        if (m_count > 0)
        {
			int32_t i = 0;

            //д
			for (i = 0; i < m_capacity; i++)
			{
				m_buckets[i] = -1;
			}
			//Ŀ
			for (i = 0; i < m_count; i++)
			{
				VariantClear(&m_items[i].key);
				VariantClear(&m_items[i].value);
			}
			memset(m_items, -1, sizeof(dicitem) * m_count);

            m_delIndex = -1;
			m_delCount = 0;
            m_count = 0;
        }
    }

	//ȡֵ
    bool GetValue(VARIANT* key, VARIANT* value)
    {
        //value
        int32_t i = FindItem(key);
		if (i >= 0)
		{
			VariantCopy(value, &m_items[i].value); //ֵȥ
			return true;
		}

        //ûҵȱʡֵ
		VariantInit(value);
        return false;
    }

	//keyǷ
    bool ContainsKey(VARIANT* key)
    {
        int32_t i = FindItem(key);
        if (i >= 0)
        {
            return true;
        }
        return false;
    }

	//ֵǷ
    bool ContainsValue(VARIANT* value)
    {
		if (value == NULL)
		{
			for (int32_t i = 0; i < m_count; i++)
			{
				if (m_items[i].hash >= 0 && (V_VT(&m_items[i].value) == VT_EMPTY))
				{
					return true;
				}
			}
		}
		else
		{
			for (int32_t i = 0; i < m_count; i++)
			{
				if (m_items[i].hash >= 0 && ValueMatch(&m_items[i].value, value))
				{
					return true;
				}
			}
		}
		return false;
    }

	//Keys
	HRESULT Keys(VARIANT* keys)
	{
		SAFEARRAYBOUND bound;
		SAFEARRAY *sa;
		VARIANT *v;
		HRESULT hr;

		//
		bound.lLbound = 0;
		bound.cElements = m_count;
		sa = SafeArrayCreate(VT_VARIANT, 1, &bound);
		if (!sa)
		{
			return E_OUTOFMEMORY;
		}

		//У
		hr = SafeArrayAccessData(sa, (void**)&v);
		if (FAILED(hr)) 
		{
			SafeArrayDestroy(sa);
			return hr;
		}
		
		//ȡ
		for (int32_t i = 0; i < m_count; i++)
		{
			if (m_items[i].hash >= 0)
			{
				VariantCopy(&v[i], &m_items[i].key);
			}
		}
		SafeArrayUnaccessData(sa);
		
		//
		V_VT(keys) = VT_ARRAY|VT_VARIANT;
		V_ARRAY(keys) = sa;

		return S_OK;
	}

	//Values
	HRESULT Values(VARIANT* values)
	{
		SAFEARRAYBOUND bound;
		SAFEARRAY *sa;
		VARIANT *v;
		HRESULT hr;

		//
		bound.lLbound = 0;
		bound.cElements = m_count;
		sa = SafeArrayCreate(VT_VARIANT, 1, &bound);
		if (!sa)
		{
			return E_OUTOFMEMORY;
		}
		
		//У
		hr = SafeArrayAccessData(sa, (void**)&v);
		if (FAILED(hr)) 
		{
			SafeArrayDestroy(sa);
			return hr;
		}
		
		//ȡ
		for (int32_t i = 0; i < m_count; i++)
		{
			if (m_items[i].hash >= 0)
			{
				VariantCopy(&v[i], &m_items[i].value);
			}
		}
		SafeArrayUnaccessData(sa);
		
		//
		V_VT(values) = VT_ARRAY|VT_VARIANT;
		V_ARRAY(values) = sa;

		return S_OK;
	}

	//ѯֵ֧ͨ*?
	HRESULT Query(VARIANT* value, VARIANT* values)
	{
		SAFEARRAYBOUND bound;
		SAFEARRAY *sa;
		VARIANT *v;
		HRESULT hr;

		//
		bound.lLbound = 0;
		bound.cElements = m_count;
		sa = SafeArrayCreate(VT_VARIANT, 1, &bound);
		if (!sa)
		{
			return E_OUTOFMEMORY;
		}
		
		//У
		hr = SafeArrayAccessData(sa, (void**)&v);
		if (FAILED(hr)) 
		{
			SafeArrayDestroy(sa);
			return hr;
		}
		
		//ȡ
		int32_t count = 0;
		for (int32_t i = 0; i < m_count; i++)
		{

			if (m_items[i].hash >= 0 && ValueMatch(&m_items[i].value, value))
			{
				VariantCopy(&v[count], &m_items[i].value);
				count++;
			}
		}
		SafeArrayUnaccessData(sa);
		
		//С
		if (count > 0 && count < m_count)
		{
			bound.lLbound = 0;
			bound.cElements = count;
			SafeArrayRedim(sa, &bound);
		}
		
		//
		if (count == 0)
		{
			VariantInit(values);
		}
		else
		{
			V_VT(values) = VT_ARRAY | VT_VARIANT;
			V_ARRAY(values) = sa;
		}
		
		return S_OK;
	}

	//Ŀ
	int32_t Count()
	{
		return m_count;
	}

	//Ŀ
	void Destory()
	{
		//
		RemoveAll();

		//ٴ۵
		if (m_buckets != NULL)
		{
			m_mem.Free(m_buckets);
			m_buckets = NULL;
		}
		if (m_items != NULL)
		{
			m_mem.Free(m_items);
			m_items = NULL;
		}
		m_capacity = 0;
	}

private:

	//ʼ
	__forceinline bool Initialize(int32_t capacity)
    {
   
		//ֵ
        //ʵhashtableĴСĴСײƵ
        //ԽƵʾԽͣӦռڴͻ
        //ľǣcapacityprimeвһcapacityС
		int32_t size = HashHelpers::GetPrime(capacity);

		//ȷ
		//ɼֵĿsΪhashtableĴСʼĿ
		//dicitem* newItems = new dicitem[size];
		//dicitem* newItems = (dicitem*)malloc(sizeof(dicitem) * size);
		dicitem* newItems = (dicitem*)m_mem.Alloc(sizeof(dicitem) * size);
		if (newItems == NULL)
		{
			return false; //ڴʧ
		}
		else
		{
			for (int32_t i = 0; i < size; i++)
			{
				newItems[i].hash = -1;
				newItems[i].next = -1;
				VariantInit(&newItems[i].key);
				VariantInit(&newItems[i].value);
			}
		}

        //s(hashtable)ʼдΪδʹ(-1)״̬
		//int32_t* newBuckets = new int32_t[size]; //newʵmalloc
		//int32_t* newBuckets = (int32_t*)malloc(sizeof(int32_t) * size);
		int32_t* newBuckets = (int32_t*)m_mem.Alloc(sizeof(int32_t) * size);
		if (newBuckets == NULL)
		{
			//ͷnewItemsռõڴֹڴй©
			if (newItems != NULL)
			{
				m_mem.Free(newItems);
			}
			return false; //ڴʧ
		}
		else
		{
			for (int32_t i = 0; i < size; i++)
			{
				newBuckets[i] = -1;
			}
		}
        
		//ָbucketsitems
		this->m_buckets = newBuckets;
		this->m_items = newItems;

		//ʼϢ
		this->m_delIndex = -1;		
		this->m_delCount = 0;	
		this->m_count = 0;

		//뱣ֵ䳤
		this->m_capacity = size;

		//
		return true;
    }

	//
	//٣2*m_countС
	__forceinline bool Resize()
	{
		//
		int32_t newSize = GetCapacity();

		//
		//µĿs(=newBuckets.Length)ʼĿ
		//΢ֵ㷨ȻĿ죬˼ÿռ任ʱ䣬
		//ǧ: 50000000 * 40/ 1048576 1907 MBڴ治£100%ڴʧܡ
		//dicitem *newItems = new dicitem[newSize];
		//dicitem *newItems = (dicitem*)malloc(sizeof(dicitem) * newSize);
		dicitem *newItems = (dicitem*)m_mem.Alloc(sizeof(dicitem) * newSize);
		if (newItems == NULL)
		{
			return false; //ڴʧ
		}
		else
		{
			//ʼĿ
			for (int32_t i = 0; i < newSize; i++)
			{
				newItems[i].hash = -1;
				newItems[i].next = -1;
				VariantInit(&newItems[i].key);
				VariantInit(&newItems[i].value);
			}
		}

		//µĴsʼΪδʹ
		int32_t *newBuckets = (int32_t*)m_mem.Alloc(sizeof(int32_t) * newSize);
		if (newBuckets == NULL)
		{
			//ͷnewItemsռõڴֹڴй©
			if (newItems != NULL)
			{
				m_mem.Free(newItems);
			}
			return false; //ڴʧ
		}
		else
		{
			//³ʼ
			for (int32_t i = 0; i < newSize; i++)
			{
				newBuckets[i] = -1;
			}
		}

		//ڽоɵĿ䵽½Ŀ
		memcpy(newItems, m_items, sizeof(dicitem) * m_count);

		//Ȼ½Ŀ(entry)봢(й)ΪʲôҪô
		//Ϊhashcode % newSizehashcode % newBuckets.LengthԺѾԭĴˣ
		//Ա½й
		for (int32_t i = 0; i < m_count; i++)
		{
			if (newItems[i].hash >= 0)
			{
				int32_t bucket = newItems[i].hash % newSize;//¼bucket

				//һĿ
				//۷ײͬkeyͨhashõͬһۣʱ,
				//ѾĿʱͽѹĿΪĿһĿ
				//ȷӦǳΪǰĿһĿʹ˳򱻴˵ⲢҪ
				//Ϊm_itemsʼնöٳ˳ӵÿһĿ
				if (newBuckets[bucket] >= 0) //ѷ(ײ)
				{
					newItems[i].next = newBuckets[bucket];//ΪǰĿһĿ
				}
				else //ײ
				{
					newItems[i].next = -1; //ѾһĿ
				}

				//ǰĿµbucket۹ͨbucketܿҵԼ
				newBuckets[bucket] = i;
			}
		}

		//ͷԭռõڴ,ֹڴй©
		m_mem.Free(m_buckets);
		m_mem.Free(m_items);
		
		//ָµbucketsitems
		m_buckets = newBuckets;
		m_items = newItems;

		//뱣ֵ䳤
		m_capacity = newSize;

		//
		return true;
	}

	/*
	//δȱһڴ̫пʧܣ磺
	//ǧ: 50000000 * 40/ 1048576 1907 MB
	//ڴ治£malloc 90%ʧ
	__forceinline void Resize()
    {
		//
		int32_t newSize = HashHelpers::ExpandPrime(m_count);

		//µĴsʼΪδʹ
		int32_t *newBuckets = (int32_t*)realloc(m_buckets, sizeof(int32_t) * newSize);// 
		for (int32_t i = m_count; i < newSize; i++)
		{
			newBuckets[i] = -1;
		}

		//µĿs(=newBuckets.Length)ʼĿ
		//ڽṹdicitemĳߴ=40ֽڣǧԺڴ䲻
		//.netƽ̨ȴnewɹΪʲôѵ.netʹڴأ
		//ǵڴأ΢Ʋõ
		dicitem *newItems = (dicitem*)realloc(m_items, sizeof(dicitem) * newSize);// 
		for (int32_t i = m_count; i < newSize; i++)
		{
			newItems[i].hash = -1;
			newItems[i].next = -1;
			VariantInit(&newItems[i].key);
			VariantInit(&newItems[i].value);
		}
		
		//½Ŀ(entry)봢(й)ΪʲôҪô
		//Ϊhashcode % newSizehashcode % newBuckets.LengthԺѾԭĴ
		//Ա½й
		for (int32_t i = 0; i < m_count; i++)
		{
			if (newItems[i].hash >= 0)
			{
				int32_t bucket = newItems[i].hash % newSize;//ȡô
				newBuckets[bucket] = i;//޸´۵״̬Ϊʹ(>=0)(ʵó1ɶԸ)
				newItems[i].next = -1;//һ(next)Ŀóδʹ״̬(-1)ΪݺÿۺĿδǰĿóδʹ״̬(-1)
			}
		}

		//ָµbucketsitems
		m_buckets = newBuckets;
		m_items = newItems;

		//뱣ֵ䳤
		m_len = newSize;
    }
	*/

	//Ŀ, ҵĿ,򷵻-1
    __forceinline int32_t FindItem(VARIANT* key)
    {

		//hashcode
		int32_t hash = HashHelpers::GetHashCode(key) & 0x7FFFFFFF;//0x7FFFFFFF=2147483647 &ǽת

		//hashcodeôλ
		int32_t bucket = hash % m_capacity;

        //ȡô۵λi۴(i >= 0)ʼĿĿ
		for (int32_t i = m_buckets[bucket]; i >= 0; i = m_items[i].next)
		{
			//ֻhash, ַҪбȽ
			//if ((m_items[i].hash == hash) && KeyEqual(key, &m_items[i].key)) 
			if ((m_items[i].hash == hash) && (VarCmp(key, &m_items[i].key, 0) == 1))
			{
				return i;
			}
		}
        
        return -1;//ûҵ
    }

	//Ƿ
	__forceinline bool KeyEqual(VARIANT* key1, VARIANT* key2)
	{
		//keyǷַ
		bool bStrKey1 = (V_VT(key1) == VT_BSTR) || (V_VT(key1) == (VT_BSTR|VT_BYREF));
		bool bStrKey2 = (V_VT(key2) == VT_BSTR) || (V_VT(key2) == (VT_BSTR|VT_BYREF));

		//ȽϼǷ
		if (bStrKey1 && bStrKey2) 
		{
			// תWCHAR Only for VT_BSTR or VT_BSTR|VT_BYREF types
			WCHAR *strKey1 = NULL;
			if (V_VT(key1) == VT_BSTR)
				strKey1 = V_BSTR(key1);
			else if (V_BSTRREF(key1))
				strKey1 = *V_BSTRREF(key1);

			WCHAR *strKey2 = NULL;
			if (V_VT(key2) == VT_BSTR)
				strKey2 = V_BSTR(key2);
			else if (V_BSTRREF(key2))
				strKey2 = *V_BSTRREF(key2);

			return strcmpW(strKey1, strKey2) == 0;
		}
		
		//Ͳһ
		if ((bStrKey1 && !bStrKey2) || (!bStrKey1 && bStrKey2))
		{
			return false;
		}

		//1ȽϺ
		return true;
	}
	
	//ֵǷƥ
	__forceinline bool ValueMatch(VARIANT* value1, VARIANT* value2)
	{
		BSTR str1, str2;
		CStr(value1, &str1);
		CStr(value2, &str2);

		return strmatchW(str1, str2);
	}

    //ַȽ
	//Compare S1 and S2, returning less than, equal to or
	//greater than zero if S1 is lexicographically less than,
	//equal to or greater than S2.  
	//ȽS1S2S1ֵСڡڻS2򷵻Сڡڻ㡣
	__forceinline int32_t strcmpW(const WCHAR* str1, const WCHAR* str2)
	{
		/*	
		int32 ret = 0;
		while (!(ret = *(WCHAR*) str1 - *(WCHAR*) str2) && *str2) 
		  ++str1, ++str2;

		if (ret < 0)
			ret = -1;
		else if (ret > 0)
			ret = 1 ;

		return ret;
		*/

		register const WCHAR* s1 = (const WCHAR*) str1;
		register const WCHAR* s2 = (const WCHAR*) str2;
		register WCHAR c1, c2;

		do
		{
			c1 = (WCHAR) *s1++;
			c2 = (WCHAR) *s2++;
			if (c1 == 0/*NUL*/)
				return c1 - c2;
		}
		while (c1 == c2);

		return c1 - c2;
	}

	//ַƥ
	__forceinline bool strmatchW(const WCHAR* text, const WCHAR* filter)
	{
		if(text == NULL || filter == NULL)
		{
			return false;
		}

		const WCHAR* cp = NULL;
		const WCHAR* mp = NULL;
		while((*text) && (*filter != _T('*')))
		{
			if ((*filter != *text) && (*filter != _T('?'))) return false;
			filter++;
			text++;
		}

		while (*text) 
		{
			if (*filter == _T('*')) 
			{
				if (!*++filter) return true;
				mp = filter;
				cp = text + 1;
			} 
			else if ((*filter == *text) || (*filter == _T('?'))) 
			{
				filter++;
				text++;
			}
			else 
			{
				filter = mp;
				text = cp++;
			}
		}

		while (*filter == _T('*')) 
		{
			filter++;
		}

		return !*filter;
	}

	//תַ
	__forceinline bool CStr(VARIANT *v, BSTR *ret)
	{
		VARIANT dst;
		HRESULT hres;

		V_VT(&dst) = VT_EMPTY;
		hres = VariantChangeType(&dst, v, VARIANT_LOCALBOOL, VT_BSTR);
		if (FAILED(hres))
			return false;

		*ret = V_BSTR(&dst);
		return true;
	}

	//һЧ
	__forceinline int32_t GetCapacity()
	{
		//ȡֽ
		int32_t newCapacity = HashHelpers::ExpandPrime(m_capacity);//
		int32_t blocks = sizeof(int32_t) + sizeof(dicitem); //ÿۺĿռõֽ
		#if (_MSC_VER <= 1200) //VC++ 6.0
			int64_t newSize = blocks * (int64_t)newCapacity;//ֽ
		#else
			uint64_t newSize = blocks * (uint64_t)newCapacity;//ֽ
		#endif

		//ȡڴÿռ
		MEMORYSTATUSEX ms;
		ms.dwLength = sizeof(MEMORYSTATUSEX);
		GlobalMemoryStatusEx(&ms);

		#if (_MSC_VER <= 1200) //VC++ 6.0
			int64_t ullAvailPhys = (int64_t)ms.ullAvailPhys; //ֽ
			int64_t ullAvailVirtual = (int64_t)ms.ullAvailVirtual; //ֽ
		#else
			uint64_t ullAvailPhys = (uint64_t)ms.ullAvailPhys; //ֽ
			uint64_t ullAvailVirtual = (uint64_t)ms.ullAvailVirtual; //ֽ
		#endif

		//Ѿ˿õڴ棬ûгõڴ棬ڴ50%ڴ
		if (newSize >= ullAvailVirtual && newSize < ullAvailPhys)
		{
			//
			int32_t capacity = (int32_t)((ullAvailVirtual * 0.5)/ blocks) ;
			//¼(һ>=m_capacity С)
			capacity = HashHelpers::CalcPrime(capacity);
			if (capacity > m_capacity)
			{
				newCapacity = capacity;
			}
		}

		//
		return newCapacity;
	}
};

#endif //__FASTDICT_H_

