# Contributor Manual

We welcome contributions of any size and skill level. As an open source project, we believe in giving back to our contributors and are happy to help with guidance on PRs, technical writing, and turning any feature idea into a reality.

> **Tip for new contributors:**
> Take a look at [https://github.com/firstcontributions/first-contributions](https://github.com/firstcontributions/first-contributions) for helpful information on contributing

## Quick Guide

### Prerequisite

```shell
node: ">=16.0.0"
npm: "^8.11.0"
# otherwise, your build will fail
```

### Setting up your local repo

```shell
git clone && cd ...
npm install
npm run build
```

### Development

```shell
# starts a file-watching, live-reloading dev script for active development
npm run dev
# build the entire project, one time.
npm run build
```

### Running tests

```shell
# run this in the top-level project root to run all tests
npm run test
```

### Making a Pull Request

You can run the following commands before making a Pull Request

```shell
# format with fix
npm run format:fix
# lint with fix
npm run lint:fix
```

## Code Structure

TODO

## Translation

See [i18n guide](TRANSLATING.md)
