# ClickPrompt - Streamline your prompt design

[![ci](https://github.com/prompt-engineering/click-prompt/actions/workflows/ci.yaml/badge.svg)](https://github.com/prompt-engineering/click-prompt/actions/workflows/ci.yaml)
![GitHub](https://img.shields.io/github/license/prompt-engineering/click-prompt)
[![Discord](https://img.shields.io/discord/1082563233593966612)](https://discord.gg/FSWXq4DmEj)

<img src="packages/click-prompt/src/assets/clickprompt-home.svg" width='128' height='128' alt='ClickPrompt Logo' />

English | [简体中文](./README.zh-CN.md)

> ClickPrompt is a tool designed for Prompt writers, it supports a variety of Prompt-based AI applications, such as Stable Diffusion, ChatGPT, and GitHub Copilot, etc.
> With ClickPrompt, you can easily view, share, and run these models with one click, and an online prompt generator is provided to enable users to easily create prompts that meet their requirements and share them with others.

Stable Env：https://www.clickprompt.org/

Dev Env(latest): https://dev.clickprompt.org/

Join us:

[![Chat Server](https://img.shields.io/badge/chat-discord-7289da.svg)](https://discord.gg/FSWXq4DmEj)

## Features:

- One-click execution: supports one-click execution for ChatGPT and StableDiffusion, making it easier for you to learn and use Prompts.
- Prompt online generator: use popular StableDiffusion character generator and StableDiffusion->ChatGPT generator to quickly create high-quality Prompts that meet your needs.
- Prompt sample library: learn from Prompt samples generated by our users, including StableDiffusion, ChatGPT, and GitHub Copilot. Showcase your work and share it with others.
- Industry-specific Prompt generator: improve your work efficiency, currently available in programming, writing, and design fields.
- Prompt optimization (PoC under consideration): use Prompt optimizer to help improve the quality of your Prompts.

## Roadmap

Phase 1: MVP

- Support for Prompt-based AI applications, including ChatGPT and Stable Diffusion.
- Provides prompt generator and one-click run.
- Provide user samples display.

Phase 2: Enhancement

- Added Prompt-based AI applications like GPT-3 and DALL-E.
- Provides user customization options and multilingual support.
- Added AI editor and user rights management feature.
- Support API interface and integration of other third-party platforms.

Phase 3: Improvement

- Improve the Prompt generator's algorithm to improve the quality and accuracy of the generated text.
- Add user feedback and evaluation features to collect user suggestions and opinions.
- Promote ClickPrompt and cooperate with various industries to provide them with efficient AI application solutions.

## Development

### Tech Stacks:

- ServerVercel
- React + Next.js + Typescript
- UI
  - Chakra UI
  - Styled Components: @emotion/styled
  - Tailwind CSS
  - React Table
- React Markdown for render markdown

### Run ClickPrompt

```shell
# Clone click-prompt
git clone https://github.com/prompt-engineering/click-prompt

cd click-prompt

npm install

# If you want to run Hugging Face integration locally
echo "NEXT_PUBLIC_HUGGING_FACE_ACCESS_TOKEN={Your Hugging Face Access Token}" > .env.local

npm run dev

# Build
npm run build
```

You can find more in [Contributors Guide](docs/CONTRIBUTING.md).

## Contributing Guide

New contributors welcome! Check out our [Contributors Guide](docs/CONTRIBUTING.md) for help getting started.

![Powered by Vercel](https://images.ctfassets.net/e5382hct74si/78Olo8EZRdUlcDUFQvnzG7/fa4cdb6dc04c40fceac194134788a0e2/1618983297-powered-by-vercel.svg)

## Translate Guide

Speak another language natively?

Check out the dedicated [i18n guide](docs/TRANSLATING.md) for more details.

## License

This code is distributed under the MIT license. See [LICENSE](./LICENSE) in this directory.

## Star History

[![Star History Chart](https://api.star-history.com/svg?repos=prompt-engineering/click-prompt&type=Date)](https://star-history.com/#prompt-engineering/click-prompt&Date)
